/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboBoxUI
extends ComboBoxUI {
    private static final Dimension MAXIMUM_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    protected JButton arrowButton;
    protected JComboBox comboBox;
    protected Component editor;
    protected FocusListener focusListener;
    protected boolean hasFocus;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    private MouseListener mouseListener;
    protected JList listBox;
    protected ListDataListener listDataListener;
    protected ComboPopup popup;
    protected KeyListener popupKeyListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    private Color buttonBackground;
    private Color buttonShadow;
    private Color buttonDarkShadow;
    private Color buttonHighlight;
    Dimension displaySize;
    protected Dimension cachedMinimumSize;
    protected CellRendererPane currentValuePane;
    protected boolean isMinimumSizeDirty;

    public static ComponentUI createUI(JComponent c) {
        return new BasicComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JComboBox) {
            this.comboBox = (JComboBox)c;
            this.comboBox.setOpaque(true);
            this.comboBox.setLayout(this.createLayoutManager());
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.comboBox = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        this.buttonBackground = UIManager.getColor("ComboBox.buttonBackground");
        this.buttonShadow = UIManager.getColor("ComboBox.buttonShadow");
        this.buttonDarkShadow = UIManager.getColor("ComboBox.buttonDarkShadow");
        this.buttonHighlight = UIManager.getColor("ComboBox.buttonHighlight");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.focusListener = this.createFocusListener();
        this.comboBox.addFocusListener(this.focusListener);
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.keyListener = this.createKeyListener();
        this.comboBox.addKeyListener(this.keyListener);
        this.mouseListener = this.createMouseListener();
        this.arrowButton.addMouseListener(this.mouseListener);
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
    }

    protected void uninstallDefaults() {
        if (this.comboBox.getFont() instanceof UIResource) {
            this.comboBox.setFont(null);
        }
        if (this.comboBox.getForeground() instanceof UIResource) {
            this.comboBox.setForeground(null);
        }
        if (this.comboBox.getBackground() instanceof UIResource) {
            this.comboBox.setBackground(null);
        }
        this.buttonBackground = null;
        this.buttonShadow = null;
        this.buttonDarkShadow = null;
        this.buttonHighlight = null;
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.comboBox.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removeKeyListener(this.keyListener);
        this.keyListener = null;
        this.arrowButton.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.comboBox.getModel().removeListDataListener(this.listDataListener);
        this.listDataListener = null;
    }

    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    private final MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    protected void installComponents() {
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        this.comboBox.setRenderer(this.createRenderer());
        this.arrowButton = this.createArrowButton();
        this.configureArrowButton();
        this.comboBox.add(this.arrowButton);
        ComboBoxEditor currentEditor = this.comboBox.getEditor();
        if (currentEditor == null || currentEditor instanceof UIResource) {
            this.comboBox.setEditor(this.createEditor());
            this.editor = this.comboBox.getEditor().getEditorComponent();
        }
        this.comboBox.revalidate();
    }

    protected void uninstallComponents() {
        this.unconfigureArrowButton();
        this.comboBox.remove(this.arrowButton);
        this.arrowButton = null;
        this.listBox = null;
        this.popup = null;
        this.comboBox.setRenderer(null);
        ComboBoxEditor currentEditor = this.comboBox.getEditor();
        if (currentEditor instanceof UIResource) {
            this.comboBox.setEditor(null);
            this.editor = null;
        }
    }

    public void addEditor() {
        this.comboBox.add(this.editor);
    }

    public void removeEditor() {
        this.comboBox.remove(this.editor);
    }

    protected void configureEditor() {
        this.editor.setFont(this.comboBox.getFont());
        this.comboBox.getEditor().setItem(this.comboBox.getSelectedItem());
    }

    protected void unconfigureEditor() {
    }

    public void configureArrowButton() {
        this.arrowButton.setEnabled(this.comboBox.isEnabled());
        this.arrowButton.setFont(this.comboBox.getFont());
    }

    public void unconfigureArrowButton() {
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5, this.buttonBackground, this.buttonShadow, this.buttonDarkShadow, this.buttonHighlight);
    }

    public boolean isPopupVisible(JComboBox c) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox c, boolean v) {
        if (v) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox c) {
        return !this.comboBox.isEditable();
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle rect = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(g, rect, this.hasFocus);
        this.paintCurrentValue(g, rect, this.hasFocus);
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = this.getDisplaySize();
        int arrowButtonWidth = d.height;
        Dimension result = new Dimension(d.width + arrowButtonWidth, d.height);
        return result;
    }

    public Dimension getMaximumSize(JComponent c) {
        return MAXIMUM_SIZE;
    }

    public int getAccessibleChildrenCount(JComponent c) {
        return 0;
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        return null;
    }

    protected boolean isNavigationKey(int keyCode) {
        return false;
    }

    protected void selectNextPossibleValue() {
        int index = this.comboBox.getSelectedIndex();
        if (index != this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(index + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int index = this.comboBox.getSelectedIndex();
        if (index != 0) {
            this.comboBox.setSelectedIndex(index - 1);
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, this.isPopupVisible(this.comboBox) ^ true);
    }

    protected Rectangle rectangleForCurrentValue() {
        Rectangle cbBounds = SwingUtilities.getLocalBounds(this.comboBox);
        Rectangle abBounds = this.arrowButton.getBounds();
        Rectangle rectForCurrentValue = new Rectangle(cbBounds.x, cbBounds.y, cbBounds.width - abBounds.width, cbBounds.height);
        return rectForCurrentValue;
    }

    protected Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (!this.comboBox.isEditable()) {
            Object currentValue = this.comboBox.getSelectedItem();
            boolean isPressed = this.arrowButton.getModel().isPressed();
            Component comp = this.comboBox.getRenderer().getListCellRendererComponent(this.listBox, currentValue != null ? currentValue : "", -1, isPressed, hasFocus);
            if (!this.comboBox.isEnabled()) {
                comp.setBackground(UIManager.getLookAndFeelDefaults().getColor("ComboBox.disabledBackground"));
                comp.setForeground(UIManager.getLookAndFeelDefaults().getColor("ComboBox.disabledForeground"));
                comp.setEnabled(false);
            }
            comp.setBounds(0, 0, bounds.width, bounds.height);
            comp.setFont(this.comboBox.getFont());
            comp.paint(g);
            this.comboBox.revalidate();
        } else {
            this.comboBox.getEditor().setItem(this.comboBox.getSelectedItem());
        }
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    protected Dimension getDefaultSize() {
        FontMetrics fm = this.comboBox.getFontMetrics(this.comboBox.getFont());
        int w = fm.charWidth(' ') + 2;
        int h = fm.getHeight() + 2;
        return new Dimension(w, h);
    }

    protected Dimension getDisplaySize() {
        Object prototype = this.comboBox.getPrototypeDisplayValue();
        if (prototype != null) {
            ListCellRenderer renderer = this.comboBox.getRenderer();
            Component comp = renderer.getListCellRendererComponent(this.listBox, prototype, -1, false, false);
            Dimension compSize = comp.getPreferredSize();
            compSize.width += 2;
            compSize.height += 2;
            return compSize;
        }
        ComboBoxModel model = this.comboBox.getModel();
        int numItems = model.getSize();
        if (numItems == 0) {
            this.displaySize = this.getDefaultSize();
            return this.displaySize;
        }
        Dimension size = new Dimension(0, 0);
        ListCellRenderer renderer = this.comboBox.getRenderer();
        int i = 0;
        while (i < numItems) {
            Object item = model.getElementAt(i);
            Component comp = renderer.getListCellRendererComponent(this.listBox, item, -1, false, false);
            Dimension compSize = comp.getPreferredSize();
            if (compSize.width + 2 > size.width) {
                size.width = compSize.width + 2;
            }
            if (compSize.height + 2 > size.height) {
                size.height = compSize.height + 2;
            }
            ++i;
        }
        this.displaySize = size;
        return this.displaySize;
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (BasicComboBoxUI.this.comboBox.isEnabled()) {
                BasicComboBoxUI.this.toggleOpenClose();
            }
        }

        private MouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            BasicComboBoxUI.this.hasFocus = true;
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void focusLost(FocusEvent e) {
            BasicComboBoxUI.this.hasFocus = false;
            BasicComboBoxUI.this.setPopupVisible(BasicComboBoxUI.this.comboBox, false);
            BasicComboBoxUI.this.comboBox.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent e) {
            ComboBoxModel model = BasicComboBoxUI.this.comboBox.getModel();
            ListCellRenderer renderer = BasicComboBoxUI.this.comboBox.getRenderer();
            if (BasicComboBoxUI.this.displaySize == null) {
                BasicComboBoxUI.this.displaySize = BasicComboBoxUI.this.getDisplaySize();
            }
            if (BasicComboBoxUI.this.displaySize.width < BasicComboBoxUI.this.getDefaultSize().width) {
                BasicComboBoxUI.this.displaySize.width = BasicComboBoxUI.this.getDefaultSize().width;
            }
            if (BasicComboBoxUI.this.displaySize.height < BasicComboBoxUI.this.getDefaultSize().height) {
                BasicComboBoxUI.this.displaySize.height = BasicComboBoxUI.this.getDefaultSize().height;
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void intervalRemoved(ListDataEvent e) {
            BasicComboBoxUI.this.displaySize = BasicComboBoxUI.this.getDisplaySize();
            BasicComboBoxUI.this.comboBox.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && BasicComboBoxUI.this.comboBox.isEditable()) {
                BasicComboBoxUI.this.comboBox.getEditor().setItem(e.getItem());
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("enabled")) {
                BasicComboBoxUI.this.arrowButton.setEnabled(BasicComboBoxUI.this.comboBox.isEnabled());
                if (BasicComboBoxUI.this.comboBox.isEditable()) {
                    BasicComboBoxUI.this.comboBox.getEditor().getEditorComponent().setEnabled(BasicComboBoxUI.this.comboBox.isEnabled());
                }
            } else if (e.getPropertyName().equals("editable")) {
                if (BasicComboBoxUI.this.comboBox.isEditable()) {
                    BasicComboBoxUI.this.configureEditor();
                    BasicComboBoxUI.this.addEditor();
                } else {
                    BasicComboBoxUI.this.unconfigureEditor();
                    BasicComboBoxUI.this.removeEditor();
                }
                BasicComboBoxUI.this.comboBox.revalidate();
                BasicComboBoxUI.this.comboBox.repaint();
            } else if (e.getPropertyName().equals("dataModel")) {
                ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                if (oldModel != null) {
                    oldModel.removeListDataListener(BasicComboBoxUI.this.listDataListener);
                }
                if ((ComboBoxModel)e.getNewValue() != null) {
                    BasicComboBoxUI.this.comboBox.getModel().addListDataListener(BasicComboBoxUI.this.listDataListener);
                }
            } else if (e.getPropertyName().equals("font")) {
                Font font = (Font)e.getNewValue();
                BasicComboBoxUI.this.editor.setFont(font);
                BasicComboBoxUI.this.listBox.setFont(font);
                BasicComboBoxUI.this.arrowButton.setFont(font);
                BasicComboBoxUI.this.comboBox.revalidate();
                BasicComboBoxUI.this.comboBox.repaint();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return BasicComboBoxUI.this.getPreferredSize((JComponent)parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            int arrowSize = BasicComboBoxUI.this.comboBox.getHeight();
            int editorWidth = BasicComboBoxUI.this.comboBox.getBounds().width - arrowSize;
            if (BasicComboBoxUI.this.comboBox.isEditable()) {
                BasicComboBoxUI.this.editor.setBounds(0, 0, editorWidth, BasicComboBoxUI.this.comboBox.getBounds().height);
            }
            BasicComboBoxUI.this.arrowButton.setBounds(editorWidth, 0, arrowSize, arrowSize);
            BasicComboBoxUI.this.comboBox.revalidate();
        }
    }
}

