/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.Color;
import java.awt.Component;
import net.sourceforge.napkinlaf.NapkinThemeColor;
import net.sourceforge.napkinlaf.sketch.TemplateColor;
import net.sourceforge.napkinlaf.sketch.XMLUtility;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.XMLShape;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;

public class TemplateItem
implements Cloneable {
    private boolean drawStroke = true;
    private boolean drawFill = false;
    private Color strokeColor;
    private float strokeWeight = 1.0f;
    private Color fillColor;
    private SketchShape shape;

    public Color getStrokeColor(Component c) {
        return TemplateColor.colorFor(this.strokeColor, c, NapkinThemeColor.PEN_COLOR);
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public float getStrokeWeight() {
        return this.strokeWeight;
    }

    public void setStrokeWeight(float strokeWeight) {
        this.strokeWeight = strokeWeight;
    }

    public Color getFillColor(Component c) {
        return TemplateColor.colorFor(this.fillColor, c, NapkinThemeColor.HIGHLIGHT_COLOR);
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public SketchShape getShape() {
        return this.shape;
    }

    public void setShape(SketchShape shape) {
        if (shape == null) {
            throw new NullPointerException("shape cannot be null");
        }
        this.shape = shape;
    }

    public boolean isDrawFill() {
        return this.drawFill;
    }

    public void setDrawFill(boolean drawFill) {
        this.drawFill = drawFill;
    }

    public boolean isDrawStroke() {
        return this.drawStroke;
    }

    public void setDrawStroke(boolean drawStroke) {
        this.drawStroke = drawStroke;
    }

    public Element produceXML() {
        Element result = null;
        if (this.shape instanceof XMLShape) {
            DefaultJDOMFactory f = new DefaultJDOMFactory();
            result = f.element("templateItem");
            if (this.strokeColor != null) {
                result.addContent(XMLUtility.colorToXML("strokeColor", this.strokeColor));
            }
            if (this.strokeWeight != 1.0f) {
                Element t = f.element("strokeWeight");
                t.addContent(f.text(Float.toString(this.strokeWeight)));
                result.addContent(t);
            }
            if (this.fillColor != null) {
                result.addContent(XMLUtility.colorToXML("fillColor", this.fillColor));
            }
            result.addContent(((XMLShape)this.shape).produceXML());
        }
        return result;
    }

    public TemplateItem clone() {
        try {
            TemplateItem item = (TemplateItem)super.clone();
            item.shape = this.shape.clone();
            return item;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("cannot clone?", e);
        }
    }
}

