/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.SquirrelAppender;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.Log4jLoggerFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.PropertyConfigurator;

public class SquirrelLoggerFactory
extends Log4jLoggerFactory {
    public SquirrelLoggerFactory(FileAppender fa, boolean doStartupLogging) {
        super(false);
        this.initialize(fa, doStartupLogging);
    }

    public SquirrelLoggerFactory(boolean doStartupLogging) {
        try {
            SquirrelAppender fa = new SquirrelAppender();
            this.initialize((FileAppender)fa, doStartupLogging);
        }
        catch (Exception e) {
            ILogger log = this.createLogger(this.getClass());
            log.error("Error occurred configuring logging. Now logging to standard output", e);
            BasicConfigurator.configure();
        }
    }

    private void initialize(FileAppender fa, boolean doStartupLogging) {
        String configFileName = ApplicationArguments.getInstance().getLoggingConfigFileName();
        if (configFileName != null) {
            PropertyConfigurator.configure((String)configFileName);
        } else {
            Properties props = new Properties();
            props.setProperty("log4j.rootLogger", "debug, SquirrelAppender");
            props.setProperty("log4j.appender.SquirrelAppender", "net.sourceforge.squirrel_sql.client.SquirrelFileSizeRollingAppender");
            props.setProperty("log4j.appender.SquirrelAppender.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.SquirrelAppender.layout.ConversionPattern", "%d{ISO8601} [%t] %-5p %c %x - %m%n");
            PropertyConfigurator.configure((Properties)props);
        }
        if (doStartupLogging) {
            this.doStartupLogging();
        }
    }

    private void doStartupLogging() {
        ILogger log = this.createLogger(this.getClass());
        log.info("#############################################################################################################");
        log.info("# Starting " + Version.getVersion() + " at " + DateFormat.getInstance().format(new Date()));
        log.info("#############################################################################################################");
        log.info(Version.getVersion() + " started: " + Calendar.getInstance().getTime());
        log.info(Version.getCopyrightStatement());
        log.info("java.vendor: " + System.getProperty("java.vendor"));
        log.info("java.version: " + System.getProperty("java.version"));
        log.info("java.runtime.name: " + System.getProperty("java.runtime.name"));
        log.info("os.name: " + System.getProperty("os.name"));
        log.info("os.version: " + System.getProperty("os.version"));
        log.info("os.arch: " + System.getProperty("os.arch"));
        log.info("user.dir: " + System.getProperty("user.dir"));
        log.info("user.home: " + System.getProperty("user.home"));
        log.info("java.home: " + System.getProperty("java.home"));
        log.info("java.class.path: " + System.getProperty("java.class.path"));
    }
}

