/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.gui.IAbortEventHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang.StringUtils;

public class ProgressAbortDialog
extends JDialog
implements ProgressAbortCallback {
    private final ProgressAbortDialog instance = this;
    private static final long serialVersionUID = 1L;
    public static final ILogger s_log = LoggerController.createLogger(ProgressAbortDialog.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProgressAbortDialog.class);
    private DateFormat dateFormat = DateFormat.getTimeInstance();
    private int itemCount = 0;
    private JProgressBar progressBar = null;
    private JLabel statusLabel = null;
    private JLabel additionalStatusLabel = null;
    private String _loadingPrefix = i18n.DEFAULT_LOADING_PREFIX;
    private boolean indeterminate;
    private IAbortEventHandler abortHandler;
    private JButton cancelButton;
    private JTextArea historyArea;
    private JComponent taskDescriptionComponent;
    private boolean canceled;
    private boolean finished;
    private String simpleTaskDescription = null;

    public ProgressAbortDialog(Dialog owner, String title, String description, int totalItems, boolean indeterminate, IAbortEventHandler abortHandler) {
        super(owner, title);
        this.init(description, totalItems, indeterminate, abortHandler);
    }

    public ProgressAbortDialog(Frame owner, String title, String description, int totalItems, boolean indeterminate, IAbortEventHandler abortHandler) {
        super(owner, title);
        this.setLocationRelativeTo(owner);
        this.init(description, totalItems, indeterminate, abortHandler);
    }

    @Override
    public void setTotalItems(int totalItems) {
        this.itemCount = totalItems;
        this.progressBar.setMaximum(totalItems);
    }

    @Override
    public void setLoadingPrefix(String loadingPrefix) {
        if (loadingPrefix != null) {
            this._loadingPrefix = loadingPrefix;
        }
    }

    @Override
    public void currentlyLoading(String simpleName) {
        final StringBuilder statusText = this.appendPrefixed(simpleName);
        try {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    ProgressAbortDialog.this.statusLabel.setText(statusText.toString());
                    ProgressAbortDialog.this.setTaskStatus(null);
                    ProgressAbortDialog.this.progressBar.setValue(ProgressAbortDialog.this.progressBar.getValue() + 1);
                    if (ProgressAbortDialog.this.finishedLoading()) {
                        ProgressAbortDialog.this.setVisible(false);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            s_log.error("Unexpected exception: " + e.getMessage(), e);
        }
    }

    private StringBuilder appendPrefixed(String simpleName) {
        StringBuilder statusText = new StringBuilder();
        statusText.append(this._loadingPrefix);
        statusText.append(" ");
        statusText.append(simpleName);
        this.appendToHistory(statusText.toString());
        return statusText;
    }

    @Override
    public void setTaskStatus(String status) {
        final StringBuilder statusText = new StringBuilder();
        if (StringUtils.isNotBlank((String)status)) {
            statusText.append(status);
        } else {
            statusText.append(" ");
        }
        try {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    String statusTextToAppend = statusText.toString();
                    ProgressAbortDialog.this.additionalStatusLabel.setText(statusTextToAppend);
                    if (StringUtils.isNotBlank((String)statusTextToAppend)) {
                        ProgressAbortDialog.this.appendPrefixed(statusTextToAppend);
                    }
                }
            });
        }
        catch (Exception e) {
            s_log.error("Unexpected exception: " + e.getMessage(), e);
        }
    }

    private void appendToHistory(String string) {
        if (this.historyArea != null) {
            final StringBuilder sb = new StringBuilder();
            sb.append(this.dateFormat.format(new Date()));
            sb.append(": ");
            sb.append(string);
            sb.append(StringUtilities.getEolStr());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressAbortDialog.this.historyArea.append(sb.toString());
                    ProgressAbortDialog.this.historyArea.setCaretPosition(ProgressAbortDialog.this.historyArea.getDocument().getLength());
                }
            };
            GUIUtils.processOnSwingEventThread(runnable);
        }
    }

    @Override
    public boolean finishedLoading() {
        if (this.finished) {
            this.progressBar.setIndeterminate(false);
            return true;
        }
        if (this.indeterminate) {
            return false;
        }
        return this.progressBar.getValue() == this.itemCount;
    }

    @Override
    public void dispose() {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ProgressAbortDialog.this.callDisposeFromSuperClass();
            }
        });
    }

    private void callDisposeFromSuperClass() {
        super.dispose();
    }

    @Override
    public void setVisible(final boolean b) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ProgressAbortDialog.this.callSetVisibleFromSuperClass(b);
            }
        });
    }

    private void callSetVisibleFromSuperClass(boolean b) {
        super.setVisible(b);
    }

    private void init(String description, int totalItems, boolean intermediate, IAbortEventHandler abortHandler) {
        this.itemCount = totalItems;
        this.indeterminate = intermediate;
        this.abortHandler = abortHandler;
        this.simpleTaskDescription = description;
        Window owner = super.getOwner();
        ProgressAbortDialog dialog = this;
        this.createGUI();
        this.setLocationRelativeTo(owner);
        dialog.setVisible(true);
    }

    private void createGUI() {
        JPanel dialogPanel = new JPanel(new GridBagLayout());
        dialogPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.anchor = 17;
        c.insets = new Insets(4, 0, 4, 0);
        this.taskDescriptionComponent = this.createTaskDescripion();
        dialogPanel.add((Component)this.taskDescriptionComponent, c);
        ++c.gridy;
        JPanel progressPanel = new JPanel(new GridBagLayout());
        progressPanel.setMinimumSize(new Dimension(400, 200));
        progressPanel.setPreferredSize(new Dimension(400, 200));
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        dialogPanel.add((Component)progressPanel, c);
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 10, 4, 10);
        this.statusLabel = new JLabel(i18n.INITIAL_LOADING_PREFIX);
        progressPanel.add((Component)this.statusLabel, c);
        ++c.gridy;
        c.insets = new Insets(4, 10, 4, 10);
        this.additionalStatusLabel = new JLabel(" ");
        progressPanel.add((Component)this.additionalStatusLabel, c);
        ++c.gridy;
        c.weightx = 1.0;
        this.progressBar = new JProgressBar(0, this.itemCount);
        this.progressBar.setIndeterminate(this.indeterminate);
        progressPanel.add((Component)this.progressBar, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.historyArea = new JTextArea();
        this.historyArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.historyArea);
        progressPanel.add((Component)jScrollPane, c);
        if (this.abortHandler != null) {
            this.cancelButton = new JButton(new CancelAction());
            ++c.gridy;
            c.anchor = 17;
            c.fill = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            dialogPanel.add((Component)this.cancelButton, c);
        }
        super.getContentPane().add(dialogPanel);
        super.pack();
        super.setSize(new Dimension(450, 450));
        super.setDefaultCloseOperation(0);
        super.addWindowListener(new WindowCloseListener());
    }

    protected JComponent createTaskDescripion() {
        return new JLabel(this.simpleTaskDescription);
    }

    public static void main(String[] args) throws Exception {
        IAbortEventHandler handler = new IAbortEventHandler(){

            @Override
            public void cancel() {
                System.out.println("echo");
            }
        };
        ProgressAbortDialog dialog = new ProgressAbortDialog((Frame)null, "myTitle", "myDescription", 0, true, handler);
        Thread.sleep(3000L);
        dialog.currentlyLoading("Running query");
        Thread.sleep(3000L);
        dialog.currentlyLoading("1 Row(s) exported");
        Thread.sleep(3000L);
        dialog.currentlyLoading("100 Row(s) exported");
        Thread.sleep(3000L);
        dialog.currentlyLoading("1000 Row(s) exported");
        dialog.currentlyLoading("Finished");
    }

    @Override
    public boolean isStop() {
        return this.canceled;
    }

    @Override
    public boolean isVisble() {
        return super.isVisible();
    }

    @Override
    public void setFinished() {
        this.finished = true;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(i18n.CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.clickCancel();
        }

        public void clickCancel() {
            int ret = JOptionPane.showConfirmDialog(ProgressAbortDialog.this.instance, i18n.CONFIRM_CANCEL);
            if (0 == ret) {
                ProgressAbortDialog.this.appendToHistory(i18n.CANCEL_FEEDBACK);
                ProgressAbortDialog.this.canceled = true;
                ProgressAbortDialog.this.cancelButton.setEnabled(false);
                ProgressAbortDialog.this.abortHandler.cancel();
            }
        }
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().clickCancel();
        }
    }

    static interface i18n {
        public static final String DEFAULT_LOADING_PREFIX = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.defaultLoadingPrefix");
        public static final String INITIAL_LOADING_PREFIX = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.initialLoadingPrefix");
        public static final String CONFIRM_CANCEL = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.confirmCancel");
        public static final String TITEL_PROGRESS = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.titelProgress");
        public static final String CANCEL = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.cancel");
        public static final String CANCEL_FEEDBACK = ProgressAbortDialog.access$000().getString("ProgressAbortDialog.cancelFeedback");
    }
}

