/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.example;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class PrintReadsExample {
    private static final Log log = Log.getInstance(PrintReadsExample.class);

    private PrintReadsExample() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: " + PrintReadsExample.class.getCanonicalName() + " inFile eagerDecode [outFile]");
            System.exit(1);
        }
        File inputFile = new File(args[0]);
        boolean eagerDecode = Boolean.parseBoolean(args[1]);
        File outputFile = args.length >= 3 ? new File(args[2]) : null;
        long start = System.currentTimeMillis();
        log.info("Start with args:" + Arrays.toString(args));
        PrintReadsExample.printConfigurationInfo();
        SamReaderFactory readerFactory = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
        if (eagerDecode) {
            readerFactory = readerFactory.enable(SamReaderFactory.Option.EAGERLY_DECODE);
        }
        try (SamReader reader = readerFactory.open(inputFile);){
            SAMFileHeader header = reader.getFileHeader();
            try (SAMFileWriter writer = outputFile != null ? new SAMFileWriterFactory().makeBAMWriter(header, true, outputFile) : null;){
                ProgressLogger pl = new ProgressLogger(log, 1000000);
                for (SAMRecord record : reader) {
                    if (writer != null) {
                        writer.addAlignment(record);
                    }
                    pl.record(record);
                }
            }
        }
        long end = System.currentTimeMillis();
        log.info(String.format("Done. Elapsed time %.3f seconds", (double)(end - start) / 1000.0));
    }

    private static void printConfigurationInfo() throws IOException {
        log.info("Executing as " + System.getProperty("user.name") + '@' + InetAddress.getLocalHost().getHostName() + " on " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + "; " + System.getProperty("java.vm.name") + ' ' + System.getProperty("java.runtime.version"));
        List list = Defaults.allDefaults().entrySet().stream().map(e -> (String)e.getKey() + ':' + e.getValue()).collect(Collectors.toList());
        log.info(String.join((CharSequence)" ", list));
    }
}

