/*
 * Decompiled with CFR 0.152.
 */
package net.pflaeging.PortableSigner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import net.pflaeging.PortableSigner.Main;

public class GetJavaKeystore {
    public String[] aliases = new String[64];
    private KeyStore ks = null;

    public GetJavaKeystore(String keystore, String password) {
        try {
            this.ks = KeyStore.getInstance("jks");
            FileInputStream fis = new FileInputStream(keystore);
            this.ks.load(fis, password.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            Main.setResult("Beim Lesen des Zertifikates trat ein Fehler auf (Algorithmus)!", true, e.getLocalizedMessage());
        }
        catch (CertificateException e) {
            Main.setResult("Beim Lesen des Zertifikates trat ein Fehler auf (Zertifikatsfehler)", true, e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            Main.setResult("Beim Lesen des Zertifikates trat ein Fehler auf (Datei nicht zugreifbar)", true, e.getLocalizedMessage());
        }
        catch (IOException e) {
            Main.setResult("Beim Lesen des Zertifikates trat ein Fehler auf (EA Fehler)", true, e.getLocalizedMessage());
        }
        catch (KeyStoreException e) {
            Main.setResult("Beim Lesen des Zertifikates trat ein Fehler auf (Datei nicht zugreifbar)", true, e.getLocalizedMessage());
        }
        String alias = "";
        try {
            int count = 0;
            Enumeration<String> aliasKey = this.ks.aliases();
            while (aliasKey.hasMoreElements()) {
                String key = aliasKey.nextElement().toString();
                String name = this.ks.getCertificate(key).toString();
                if (!this.ks.isKeyEntry(key)) continue;
                this.aliases[count] = key;
                System.out.println("Key#" + count + " " + key);
                ++count;
            }
        }
        catch (NoSuchElementException e) {
            Main.setResult("Beim Lesen des Zertifikates trat ein Fehler auf (Keine Schluessel)", true, e.getLocalizedMessage());
        }
        catch (KeyStoreException e) {
            Main.setResult("Beim Lesen des Zertifikates trat ein Fehler auf (Datei nicht zugreifbar)", true, e.getLocalizedMessage());
        }
    }
}

