/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.net.URL;
import org.apache.catalina.util.SchemaResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.EntityResolver;

public class DigesterFactory {
    protected static Log log = LogFactory.getLog((Class)DigesterFactory.class);
    private static SchemaResolver schemaResolver;

    public static Digester newDigester() {
        return DigesterFactory.newDigester(false, false, null);
    }

    public static Digester newDigester(RuleSet rule) {
        return DigesterFactory.newDigester(false, false, rule);
    }

    public static Digester newDigester(boolean xmlValidation, boolean xmlNamespaceAware, RuleSet rule) {
        Digester digester = new Digester();
        digester.setNamespaceAware(xmlNamespaceAware);
        digester.setValidating(xmlValidation);
        digester.setUseContextClassLoader(true);
        if (xmlValidation || xmlNamespaceAware) {
            DigesterFactory.configureSchema(digester);
        }
        schemaResolver = new SchemaResolver(digester);
        DigesterFactory.registerLocalSchema();
        digester.setEntityResolver((EntityResolver)schemaResolver);
        if (rule != null) {
            digester.addRuleSet(rule);
        }
        return digester;
    }

    protected static void registerLocalSchema() {
        DigesterFactory.register("/javax/servlet/resources/j2ee_1_4.xsd", "j2ee_1_4.xsd");
        DigesterFactory.register("/javax/servlet/resources/xml.xsd", "xml.xsd");
        DigesterFactory.register("/javax/servlet/resources/jsp_2_0.xsd", "jsp_2_0.xsd");
        DigesterFactory.register("/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
        DigesterFactory.register("/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN");
        DigesterFactory.register("/javax/servlet/resources/web-jsptaglibrary_2_0.xsd", "web-jsptaglibrary_2_0.xsd");
        DigesterFactory.register("/javax/servlet/resources/web-app_2_2.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
        DigesterFactory.register("/javax/servlet/resources/web-app_2_3.dtd", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
        DigesterFactory.register("/javax/servlet/resources/web-app_2_4.xsd", "web-app_2_4.xsd");
        DigesterFactory.register("/javax/servlet/resources/j2ee_web_services_1_1.xsd", "j2ee_web_services_1_1.xsd");
        DigesterFactory.register("/javax/servlet/resources/j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
    }

    protected static void register(String resourceURL, String resourcePublicId) {
        URL url = DigesterFactory.class.getResource(resourceURL);
        if (url == null) {
            log.warn((Object)("Could not get url for " + resourceURL));
        } else {
            schemaResolver.register(resourcePublicId, url.toString());
        }
    }

    protected static void configureSchema(Digester digester) {
        URL url = DigesterFactory.class.getResource("/javax/servlet/resources/web-app_2_4.xsd");
        if (url == null) {
            log.error((Object)"Could not get url for /javax/servlet/resources/web-app_2_4.xsd");
        } else {
            digester.setSchema(url.toString());
        }
    }
}

