/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;

class PeriodicCommitLogService
extends AbstractCommitLogService {
    private static final long blockWhenSyncLagsNanos = (long)((double)DatabaseDescriptor.getCommitLogSyncPeriod() * 1500000.0);

    public PeriodicCommitLogService(CommitLog commitLog) {
        super(commitLog, "PERIODIC-COMMIT-LOG-SYNCER", DatabaseDescriptor.getCommitLogSyncPeriod(), !commitLog.configuration.useCompression() && !commitLog.configuration.useEncryption());
    }

    @Override
    protected void maybeWaitForSync(CommitLogSegment.Allocation alloc) {
        long expectedSyncTime = System.nanoTime() - blockWhenSyncLagsNanos;
        if (this.lastSyncedAt < expectedSyncTime) {
            this.pending.incrementAndGet();
            this.awaitSyncAt(expectedSyncTime, this.commitLog.metrics.waitingOnCommit.time());
            this.pending.decrementAndGet();
        }
    }
}

