/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.util.Pow2;

public class SpscUnboundedAtomicArrayQueue<E>
extends AbstractQueue<E>
implements QueueProgressIndicators {
    static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
    protected final AtomicLong producerIndex;
    protected int producerLookAheadStep;
    protected long producerLookAhead;
    protected int producerMask;
    protected AtomicReferenceArray<Object> producerBuffer;
    protected int consumerMask;
    protected AtomicReferenceArray<Object> consumerBuffer;
    protected final AtomicLong consumerIndex;
    private static final Object HAS_NEXT = new Object();

    public SpscUnboundedAtomicArrayQueue(int chunkSize) {
        int p2ChunkSize = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        int mask = p2ChunkSize - 1;
        AtomicReferenceArray buffer = new AtomicReferenceArray(p2ChunkSize + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2ChunkSize);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerLookAhead = mask - 1;
        this.producerIndex = new AtomicLong();
        this.consumerIndex = new AtomicLong();
        this.soProducerIndex(0L);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray<Object> buffer = this.producerBuffer;
        long index = this.lpProducerIndex();
        int mask = this.producerMask;
        int offset = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask);
        if (index < this.producerLookAhead) {
            return this.writeToQueue(buffer, e, index, offset);
        }
        int lookAheadStep = this.producerLookAheadStep;
        int lookAheadElementOffset = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index + (long)lookAheadStep, mask);
        if (null == SpscUnboundedAtomicArrayQueue.lvElement(buffer, lookAheadElementOffset)) {
            this.producerLookAhead = index + (long)lookAheadStep - 1L;
            return this.writeToQueue(buffer, e, index, offset);
        }
        if (null == SpscUnboundedAtomicArrayQueue.lvElement(buffer, SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index + 1L, mask))) {
            return this.writeToQueue(buffer, e, index, offset);
        }
        this.resize(buffer, index, offset, e, mask);
        return true;
    }

    private boolean writeToQueue(AtomicReferenceArray<Object> buffer, E e, long index, int offset) {
        SpscUnboundedAtomicArrayQueue.soElement(buffer, offset, e);
        this.soProducerIndex(index + 1L);
        return true;
    }

    private void resize(AtomicReferenceArray<Object> oldBuffer, long currIndex, int offset, E e, long mask) {
        int capacity = oldBuffer.length();
        AtomicReferenceArray<Object> newBuffer = new AtomicReferenceArray<Object>(capacity);
        this.producerBuffer = newBuffer;
        this.producerLookAhead = currIndex + mask - 1L;
        SpscUnboundedAtomicArrayQueue.soElement(newBuffer, offset, e);
        this.soNext(oldBuffer, newBuffer);
        SpscUnboundedAtomicArrayQueue.soElement(oldBuffer, offset, HAS_NEXT);
        this.soProducerIndex(currIndex + 1L);
    }

    private void soNext(AtomicReferenceArray<Object> curr, AtomicReferenceArray<Object> next) {
        SpscUnboundedAtomicArrayQueue.soElement(curr, SpscUnboundedAtomicArrayQueue.calcDirectOffset(curr.length() - 1), next);
    }

    private AtomicReferenceArray<Object> lvNext(AtomicReferenceArray<Object> curr) {
        return (AtomicReferenceArray)SpscUnboundedAtomicArrayQueue.lvElement(curr, SpscUnboundedAtomicArrayQueue.calcDirectOffset(curr.length() - 1));
    }

    @Override
    public final E poll() {
        boolean isNextBuffer;
        int mask;
        AtomicReferenceArray<Object> buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        int offset = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask = this.consumerMask);
        Object e = SpscUnboundedAtomicArrayQueue.lvElement(buffer, offset);
        boolean bl = isNextBuffer = e == HAS_NEXT;
        if (null != e && !isNextBuffer) {
            this.soConsumerIndex(index + 1L);
            SpscUnboundedAtomicArrayQueue.soElement(buffer, offset, null);
            return (E)e;
        }
        if (isNextBuffer) {
            return this.newBufferPoll(buffer, index, mask);
        }
        return null;
    }

    private E newBufferPoll(AtomicReferenceArray<Object> buffer, long index, int mask) {
        AtomicReferenceArray<Object> nextBuffer = this.lvNext(buffer);
        this.consumerBuffer = nextBuffer;
        int offsetInNew = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask);
        Object n = SpscUnboundedAtomicArrayQueue.lvElement(nextBuffer, offsetInNew);
        this.soConsumerIndex(index + 1L);
        SpscUnboundedAtomicArrayQueue.soElement(nextBuffer, offsetInNew, null);
        this.soNext(buffer, null);
        return (E)n;
    }

    @Override
    public final E peek() {
        int mask;
        AtomicReferenceArray<Object> buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        int offset = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask = this.consumerMask);
        Object e = SpscUnboundedAtomicArrayQueue.lvElement(buffer, offset);
        if (e == HAS_NEXT) {
            return this.newBufferPeek(this.lvNext(buffer), index, mask);
        }
        return (E)e;
    }

    private E newBufferPeek(AtomicReferenceArray<Object> nextBuffer, long index, int mask) {
        this.consumerBuffer = nextBuffer;
        int offsetInNew = SpscUnboundedAtomicArrayQueue.calcWrappedOffset(index, mask);
        return (E)SpscUnboundedAtomicArrayQueue.lvElement(nextBuffer, offsetInNew);
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lpProducerIndex() {
        return this.producerIndex.get();
    }

    private long lpConsumerIndex() {
        return this.consumerIndex.get();
    }

    private void soProducerIndex(long v) {
        this.producerIndex.lazySet(v);
    }

    private void soConsumerIndex(long v) {
        this.consumerIndex.lazySet(v);
    }

    private static int calcWrappedOffset(long index, int mask) {
        return SpscUnboundedAtomicArrayQueue.calcDirectOffset((int)index & mask);
    }

    private static int calcDirectOffset(int index) {
        return index;
    }

    private static void soElement(AtomicReferenceArray<Object> buffer, int offset, Object e) {
        buffer.lazySet(offset, e);
    }

    private static <E> Object lvElement(AtomicReferenceArray<Object> buffer, int offset) {
        return buffer.get(offset);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }
}

