/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.SolrException;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrCacheBase;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.IOFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineCache<K, V>
extends SolrCacheBase
implements SolrCache<K, V>,
Accountable,
RemovalListener<K, V> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CaffeineCache.class) + RamUsageEstimator.shallowSizeOfInstance(CacheStats.class) + 2L * RamUsageEstimator.shallowSizeOfInstance(LongAdder.class);
    private static final long RAM_BYTES_PER_FUTURE = RamUsageEstimator.shallowSizeOfInstance(CompletableFuture.class);
    private Executor executor;
    private CacheStats priorStats;
    private long priorHits;
    private long priorInserts;
    private long priorLookups;
    private String description = "Caffeine Cache";
    private LongAdder hits;
    private LongAdder inserts;
    private LongAdder lookups;
    private Cache<K, V> cache;
    private AsyncCache<K, V> asyncCache;
    private long warmupTime;
    private int maxSize;
    private long maxRamBytes;
    private int initialSize;
    private int maxIdleTimeSec;
    private boolean cleanupThread;
    private boolean async;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private MetricsMap cacheMap;
    private SolrMetricsContext solrMetricsContext;
    private long initialRamBytes = 0L;
    private final LongAdder ramBytes = new LongAdder();

    public CaffeineCache() {
        this.priorStats = CacheStats.empty();
    }

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        super.init(args, regenerator);
        String str = (String)args.get("size");
        this.maxSize = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get("initialSize");
        this.initialSize = Math.min(str == null ? 1024 : Integer.parseInt(str), this.maxSize);
        str = (String)args.get("maxIdleTime");
        this.maxIdleTimeSec = str == null ? -1 : Integer.parseInt(str);
        str = (String)args.get("maxRamMB");
        int maxRamMB = str == null ? -1 : Double.valueOf(str).intValue();
        this.maxRamBytes = maxRamMB < 0 ? Long.MAX_VALUE : (long)maxRamMB * 1024L * 1024L;
        this.cleanupThread = Boolean.parseBoolean((String)args.get("cleanupThread"));
        this.async = Boolean.parseBoolean(args.getOrDefault("async", "true"));
        this.executor = this.async ? Runnable::run : (this.cleanupThread ? ForkJoinPool.commonPool() : Runnable::run);
        this.description = this.generateDescription(this.maxSize, this.initialSize);
        this.cache = this.buildCache(null);
        this.hits = new LongAdder();
        this.inserts = new LongAdder();
        this.lookups = new LongAdder();
        this.initialRamBytes = RamUsageEstimator.shallowSizeOfInstance(this.cache.getClass()) + RamUsageEstimator.shallowSizeOfInstance(this.executor.getClass()) + RamUsageEstimator.sizeOfObject((Object)this.description);
        return persistence;
    }

    private Cache<K, V> buildCache(Cache<K, V> prev) {
        Cache newCache;
        Caffeine builder = Caffeine.newBuilder().initialCapacity(this.initialSize).executor(this.executor).removalListener((RemovalListener)this).recordStats();
        if (this.maxIdleTimeSec > 0) {
            builder.expireAfterAccess(Duration.ofSeconds(this.maxIdleTimeSec));
        }
        if (this.maxRamBytes != Long.MAX_VALUE) {
            builder.maximumWeight(this.maxRamBytes);
            builder.weigher((k, v) -> (int)(RamUsageEstimator.sizeOfObject((Object)k) + RamUsageEstimator.sizeOfObject((Object)v)));
        } else {
            builder.maximumSize((long)this.maxSize);
        }
        if (this.async) {
            this.asyncCache = builder.buildAsync();
            newCache = this.asyncCache.synchronous();
        } else {
            newCache = builder.build();
        }
        if (prev != null) {
            newCache.putAll((Map)prev.asMap());
        }
        return newCache;
    }

    public void onRemoval(K key, V value, RemovalCause cause) {
        this.ramBytes.add(-(RamUsageEstimator.sizeOfObject(key, (long)1024L) + RamUsageEstimator.sizeOfObject(value, (long)1024L) + RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY));
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.initialRamBytes + this.ramBytes.sum();
    }

    @Override
    public V get(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    private V computeAsync(K key, IOFunction<? super K, ? extends V> mappingFunction) throws IOException {
        CompletableFuture<V> future = new CompletableFuture<V>();
        CompletableFuture result = this.asyncCache.asMap().putIfAbsent(key, future);
        this.lookups.increment();
        if (result != null) {
            try {
                Object value = result.join();
                this.hits.increment();
                return (V)value;
            }
            catch (CompletionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw e;
            }
        }
        try {
            V value = mappingFunction.apply(key);
            future.complete(value);
            this.recordRamBytes(key, null, value);
            this.inserts.increment();
            return value;
        }
        catch (IOException | Error | RuntimeException e) {
            future.completeExceptionally(e);
            throw e;
        }
    }

    @Override
    public V computeIfAbsent(K key, IOFunction<? super K, ? extends V> mappingFunction) throws IOException {
        if (this.async) {
            return this.computeAsync(key, mappingFunction);
        }
        try {
            return (V)this.cache.get(key, k -> {
                Object value;
                try {
                    value = mappingFunction.apply((K)k);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (value == null) {
                    return null;
                }
                this.recordRamBytes(key, null, value);
                this.inserts.increment();
                return value;
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public V put(K key, V val) {
        this.inserts.increment();
        V old = this.cache.asMap().put(key, val);
        this.recordRamBytes(key, old, val);
        return old;
    }

    private void recordRamBytes(K key, V oldValue, V newValue) {
        this.ramBytes.add(RamUsageEstimator.sizeOfObject(key, (long)1024L) + RamUsageEstimator.sizeOfObject(newValue, (long)1024L));
        if (oldValue == null) {
            this.ramBytes.add(RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY);
            if (this.async) {
                this.ramBytes.add(RAM_BYTES_PER_FUTURE);
            }
        } else {
            this.ramBytes.add(-RamUsageEstimator.sizeOfObject(oldValue, (long)1024L));
        }
    }

    @Override
    public V remove(K key) {
        Object existing = this.cache.asMap().remove(key);
        if (existing != null) {
            this.ramBytes.add(-RamUsageEstimator.sizeOfObject(key, (long)1024L));
            this.ramBytes.add(-RamUsageEstimator.sizeOfObject(existing, (long)1024L));
            this.ramBytes.add(-RamUsageEstimator.LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY);
        }
        return existing;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
        this.ramBytes.reset();
    }

    @Override
    public int size() {
        return this.cache.asMap().size();
    }

    @Override
    public void close() throws IOException {
        SolrCache.super.close();
        this.cache.invalidateAll();
        this.cache.cleanUp();
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdownNow();
        }
        this.ramBytes.reset();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        if (this.maxSize == maxSize) {
            return;
        }
        Optional evictionOpt = this.cache.policy().eviction();
        if (evictionOpt.isPresent()) {
            Policy.Eviction eviction = (Policy.Eviction)evictionOpt.get();
            eviction.setMaximum((long)maxSize);
            this.maxSize = maxSize;
            this.initialSize = Math.min(1024, this.maxSize);
            this.description = this.generateDescription(this.maxSize, this.initialSize);
            this.cache.cleanUp();
        }
    }

    @Override
    public int getMaxRamMB() {
        return this.maxRamBytes != Long.MAX_VALUE ? (int)(this.maxRamBytes / 1024L / 1024L) : -1;
    }

    @Override
    public void setMaxRamMB(int maxRamMB) {
        long newMaxRamBytes;
        long l = newMaxRamBytes = maxRamMB < 0 ? Long.MAX_VALUE : (long)maxRamMB * 1024L * 1024L;
        if (newMaxRamBytes != this.maxRamBytes) {
            this.maxRamBytes = newMaxRamBytes;
            Optional evictionOpt = this.cache.policy().eviction();
            if (evictionOpt.isPresent()) {
                Policy.Eviction eviction = (Policy.Eviction)evictionOpt.get();
                if (!eviction.isWeighted()) {
                    this.cache = this.buildCache(this.cache);
                    return;
                }
                if (this.maxRamBytes == Long.MAX_VALUE) {
                    this.cache = this.buildCache(this.cache);
                    return;
                }
                eviction.setMaximum(newMaxRamBytes);
                this.description = this.generateDescription(this.maxSize, this.initialSize);
                this.cache.cleanUp();
            }
        }
    }

    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache<K, V> old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.nanoTime();
        Map hottest = Collections.emptyMap();
        CaffeineCache other = (CaffeineCache)old;
        if (this.isAutowarmingOn()) {
            int size = this.autowarm.getWarmCount(other.cache.asMap().size());
            hottest = other.cache.policy().eviction().map(p -> p.hottest(size)).orElse(Collections.emptyMap());
        }
        for (Map.Entry entry : hottest.entrySet()) {
            try {
                boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, entry.getKey(), entry.getValue());
                if (continueRegen) continue;
                break;
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + entry.getKey()), (Throwable)e);
            }
        }
        this.hits.reset();
        this.inserts.reset();
        this.lookups.reset();
        CacheStats oldStats = other.cache.stats();
        this.priorStats = oldStats.plus(other.priorStats);
        this.priorHits = oldStats.hitCount() + other.hits.sum() + other.priorHits;
        this.priorInserts = other.inserts.sum() + other.priorInserts;
        this.priorLookups = oldStats.requestCount() + other.lookups.sum() + other.priorLookups;
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    private String generateDescription(int limit, int initialSize) {
        return String.format(Locale.ROOT, "Caffeine Cache(maxSize=%d, initialSize=%d%s)", limit, initialSize, this.isAutowarmingOn() ? ", " + this.getAutowarmDescription() : "");
    }

    @Override
    public boolean isRecursionSupported() {
        return this.async;
    }

    @Override
    public String getName() {
        return CaffeineCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @VisibleForTesting
    MetricsMap getMetricsMap() {
        return this.cacheMap;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    public String toString() {
        return this.name() + (this.cacheMap != null ? this.cacheMap.getValue().toString() : "");
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.cacheMap = new MetricsMap(map -> {
            if (this.cache != null) {
                CacheStats stats = this.cache.stats();
                long hitCount = stats.hitCount() + this.hits.sum();
                long insertCount = this.inserts.sum();
                long lookupCount = stats.requestCount() + this.lookups.sum();
                map.put((CharSequence)"lookups", lookupCount);
                map.put((CharSequence)"hits", hitCount);
                map.put((CharSequence)"hitratio", CaffeineCache.hitRate(hitCount, lookupCount));
                map.put((CharSequence)"inserts", insertCount);
                map.put((CharSequence)"evictions", stats.evictionCount());
                map.put((CharSequence)"size", this.cache.asMap().size());
                map.put((CharSequence)"warmupTime", this.warmupTime);
                map.put((CharSequence)"ramBytesUsed", this.ramBytesUsed());
                map.put((CharSequence)"maxRamMB", this.getMaxRamMB());
                CacheStats cumulativeStats = this.priorStats.plus(stats);
                long cumLookups = this.priorLookups + lookupCount;
                long cumHits = this.priorHits + hitCount;
                map.put((CharSequence)"cumulative_lookups", cumLookups);
                map.put((CharSequence)"cumulative_hits", cumHits);
                map.put((CharSequence)"cumulative_hitratio", CaffeineCache.hitRate(cumHits, cumLookups));
                map.put((CharSequence)"cumulative_inserts", this.priorInserts + insertCount);
                map.put((CharSequence)"cumulative_evictions", cumulativeStats.evictionCount());
            }
        });
        this.solrMetricsContext.gauge(this, this.cacheMap, true, scope, this.getCategory().toString());
    }

    private static double hitRate(long hitCount, long lookupCount) {
        return lookupCount == 0L ? 1.0 : (double)hitCount / (double)lookupCount;
    }
}

