/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.membership.MemberImpl;

public class Membership
implements Cloneable {
    protected static final MemberImpl[] EMPTY_MEMBERS = new MemberImpl[0];
    private Object membersLock = new Object();
    protected MemberImpl local;
    protected HashMap<MemberImpl, MbrEntry> map = new HashMap();
    protected MemberImpl[] members = EMPTY_MEMBERS;
    protected Comparator<Member> memberComparator = new MemberComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership clone() {
        Object object = this.membersLock;
        synchronized (object) {
            HashMap tmpclone;
            Membership clone;
            try {
                clone = (Membership)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
            clone.map = tmpclone = (HashMap)this.map.clone();
            clone.members = (MemberImpl[])this.members.clone();
            clone.membersLock = new Object();
            return clone;
        }
    }

    public Membership(MemberImpl local, boolean includeLocal) {
        this.local = local;
        if (includeLocal) {
            this.addMember(local);
        }
    }

    public Membership(MemberImpl local) {
        this(local, false);
    }

    public Membership(MemberImpl local, Comparator<Member> comp) {
        this(local, comp, false);
    }

    public Membership(MemberImpl local, Comparator<Member> comp, boolean includeLocal) {
        this(local, includeLocal);
        this.memberComparator = comp;
    }

    public synchronized void reset() {
        this.map.clear();
        this.members = EMPTY_MEMBERS;
    }

    public synchronized boolean memberAlive(MemberImpl member) {
        boolean result = false;
        if (member.equals(this.local)) {
            return result;
        }
        MbrEntry entry = this.map.get(member);
        if (entry == null) {
            entry = this.addMember(member);
            result = true;
        } else {
            MemberImpl updateMember = entry.getMember();
            if (updateMember.getMemberAliveTime() != member.getMemberAliveTime()) {
                updateMember.setMemberAliveTime(member.getMemberAliveTime());
                updateMember.setPayload(member.getPayload());
                updateMember.setCommand(member.getCommand());
                Arrays.sort(this.members, this.memberComparator);
            }
        }
        entry.accessed();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MbrEntry addMember(MemberImpl member) {
        Object object = this.membersLock;
        synchronized (object) {
            MbrEntry entry = new MbrEntry(member);
            if (!this.map.containsKey(member)) {
                this.map.put(member, entry);
                MemberImpl[] results = new MemberImpl[this.members.length + 1];
                for (int i = 0; i < this.members.length; ++i) {
                    results[i] = this.members[i];
                }
                results[this.members.length] = member;
                this.members = results;
                Arrays.sort(this.members, this.memberComparator);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(MemberImpl member) {
        this.map.remove(member);
        Object object = this.membersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] != member && !this.members[i].equals(member)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            MemberImpl[] results = new MemberImpl[this.members.length - 1];
            int j = 0;
            for (int i = 0; i < this.members.length; ++i) {
                if (i == n) continue;
                results[j++] = this.members[i];
            }
            this.members = results;
        }
    }

    public synchronized MemberImpl[] expire(long maxtime) {
        if (!this.hasMembers()) {
            return EMPTY_MEMBERS;
        }
        ArrayList<MemberImpl> list = null;
        for (MbrEntry entry : this.map.values()) {
            if (!entry.hasExpired(maxtime)) continue;
            if (list == null) {
                list = new ArrayList<MemberImpl>();
            }
            list.add(entry.getMember());
        }
        if (list != null) {
            MemberImpl[] result = new MemberImpl[list.size()];
            list.toArray(result);
            for (MemberImpl member : result) {
                this.removeMember(member);
            }
            return result;
        }
        return EMPTY_MEMBERS;
    }

    public boolean hasMembers() {
        return this.members.length > 0;
    }

    public Member getMember(Member mbr) {
        MemberImpl[] members = this.members;
        if (members.length > 0) {
            for (MemberImpl member : members) {
                if (!((Object)member).equals(mbr)) continue;
                return member;
            }
        }
        return null;
    }

    public boolean contains(Member mbr) {
        return this.getMember(mbr) != null;
    }

    public MemberImpl[] getMembers() {
        if (this.hasMembers()) {
            return this.members;
        }
        return EMPTY_MEMBERS;
    }

    protected synchronized MbrEntry[] getMemberEntries() {
        MbrEntry[] result = new MbrEntry[this.map.size()];
        Iterator<Map.Entry<MemberImpl, MbrEntry>> i = this.map.entrySet().iterator();
        int pos = 0;
        while (i.hasNext()) {
            result[pos++] = i.next().getValue();
        }
        return result;
    }

    protected static class MbrEntry {
        protected MemberImpl mbr;
        protected long lastHeardFrom;

        public MbrEntry(MemberImpl mbr) {
            this.mbr = mbr;
        }

        public void accessed() {
            this.lastHeardFrom = System.currentTimeMillis();
        }

        public MemberImpl getMember() {
            return this.mbr;
        }

        public boolean hasExpired(long maxtime) {
            long delta = System.currentTimeMillis() - this.lastHeardFrom;
            return delta > maxtime;
        }
    }

    private static class MemberComparator
    implements Comparator<Member>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MemberComparator() {
        }

        @Override
        public int compare(Member m1, Member m2) {
            long result = m2.getMemberAliveTime() - m1.getMemberAliveTime();
            if (result < 0L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

