/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;

public class GameWindow
extends AFrame {
    private boolean setupDone = false;
    private GamePanel panel;
    private final Listener listener = new Listener();
    private final int winTitleFormatter;

    public GameWindow(int winTitleFormatter, Component parent, GamePanel panel) {
        super(parent);
        this.winTitleFormatter = winTitleFormatter;
        this.setDefaultCloseOperation(0);
        this.setGamePanel(null, panel);
        this.addWindowListener(this.listener);
    }

    public void setGamePanel(GamePanel oldPanel, GamePanel newPanel) {
        if (oldPanel != this.panel) {
            throw new IllegalArgumentException();
        }
        if (this.panel != null) {
            this.panel.removeListener(this.listener);
            this.getContentPane().remove(this.panel);
        }
        this.panel = newPanel;
        if (this.panel != null) {
            newPanel.addListener(this.listener);
            this.getContentPane().add(newPanel);
            this.retitle(newPanel.getTitleText());
            if (this.setupDone) {
                this.validate();
            } else {
                this.pack();
                this.setVisible(true);
                this.setupDone = true;
            }
        }
    }

    @Override
    protected String getSavePositionPref() {
        return "9MX~JG~b";
    }

    protected void retitle(Object title) {
        this.setTitle(Defs.getString(this.winTitleFormatter, title));
    }

    protected EventListener getListener() {
        return this.listener;
    }

    protected void closePressed() {
        this.panel.closePressed();
    }

    protected void gameClosed(GamePanel gamePanel) {
        this.dispose();
    }

    private class Listener
    extends WindowAdapter
    implements EventListener {
        private Listener() {
        }

        @Override
        public void handleEvent(Event event) {
            switch (event.type) {
                case 0: {
                    GameWindow.this.retitle(event.arg);
                    break;
                }
                case 2: {
                    GameWindow.this.gameClosed((GamePanel)event.source);
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent event) {
            GameWindow.this.closePressed();
        }
    }
}

