/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.InstanceAttribute;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.Options;

public class ResetInstanceAttribute
extends BaseCmd {
    private static final String[] KERNEL_DESC = new String[]{"Resets the ID of the kernel to be used by the instance", "to its initial value."};
    private static final String[] RAMDISK_DESC = new String[]{"Resets the ID of the ramdisk to be used by the instance", "to its initial value."};
    private static final Map<String, InstanceAttribute.InstanceAttributeType> OPTION_ATTRIBUTE_MAPPING = new HashMap<String, InstanceAttribute.InstanceAttributeType>();

    public ResetInstanceAttribute(String[] args) {
        super("ec2rinatt", new String[]{"ec2-reset-instance-attribute", "ec2riatt"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(ResetInstanceAttribute.createOption(null, "kernel", KERNEL_DESC));
        result.addOption(ResetInstanceAttribute.createOption(null, "ramdisk", RAMDISK_DESC));
        return result;
    }

    protected String getOptionString() {
        return "[SPECIFIC OPTIONS] INSTANCE";
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("kernel");
        this.printOption("ramdisk");
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Resets an instance attribute to its initial value. Only");
        System.out.println("     one attribute can be specified per call.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        InstanceAttribute.InstanceAttributeType instanceAttributeType;
        String instanceId = this.getInstanceId();
        RequestResultPair rsp = jec2.resetInstanceAttribute(instanceId, instanceAttributeType = this.getInstanceAttributeType());
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.output(System.out, instanceId, instanceAttributeType);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    private InstanceAttribute.InstanceAttributeType getInstanceAttributeType() {
        ArrayList<String> attributes = new ArrayList<String>(1);
        for (String pa : OPTION_ATTRIBUTE_MAPPING.keySet()) {
            if (!this.isOptionSet(pa)) continue;
            attributes.add(pa);
        }
        if (attributes.isEmpty()) {
            throw new InvalidArgumentCombination("An attribute must be specified.");
        }
        if (attributes.size() > 1) {
            throw new InvalidArgumentCombination("Only one attribute may be specified.");
        }
        return OPTION_ATTRIBUTE_MAPPING.get(attributes.get(0));
    }

    protected String getInstanceId() {
        String[] instanceIds = this.getNonOptions();
        if (instanceIds.length == 0) {
            throw new InvalidArgumentCombination("An instance ID must be specified.");
        }
        if (instanceIds.length > 1) {
            throw new InvalidArgumentCombination("Only one instance ID may be specified.");
        }
        return instanceIds[0];
    }

    public static void main(String[] args) {
        new ResetInstanceAttribute(args).invoke();
    }

    static {
        OPTION_ATTRIBUTE_MAPPING.put("kernel", InstanceAttribute.InstanceAttributeType.kernel);
        OPTION_ATTRIBUTE_MAPPING.put("ramdisk", InstanceAttribute.InstanceAttributeType.ramdisk);
    }
}

