<?php

###############################################################################
# russian.php
# This is the russian language page for Geeklog!
#
# 01/10/2003 R.03-1
# Thanks goes to Marina Prince & Frederick Ouano (RussianHouston.com)
# for completing the project.
# This version has been tested to work with Geeklog v.1.3.6
#
# Copyright (c) 2002 Konstantin Komash, Zoya Koneva
# komash@profit.ru
# 
# Updated for version 1.3.8-1sr2 by Kuznetsov Denis
# d_kuz@bk.ru
#
# Updated (translating the untranslated text) by Konstantinn Boyandin
# konstantin@boyandin.ru
#
# Credits of English version:
# Special thanks to Mischa Polivanov for his work on this project
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten@securitygeeks.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

$LANG_ISO639_1 = 'ru';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Опубликовал:',
    2 => 'читать дальше',
    3 => 'Комментарии',
    4 => 'Изменить',
    5 => 'Contributed by: %s on %s',
    6 => 'Last modified on %s',
    7 => '',
    8 => '',
    9 => 'Функции администратора:',
    10 => 'Публикации',
    11 => 'Статьи',
    12 => 'Блоки',
    13 => 'Темы',
    14 => 'Command &amp; Control',
    15 => '',
    16 => '',
    17 => 'Пользователи',
    18 => 'Запрос SQL',
    19 => 'Завершить сеанс',
    20 => 'Информация о пользователе:',
    21 => 'Имя пользователя',
    22 => 'ID пользователя',
    23 => 'Уровень безопастности',
    24 => 'Без подписи',
    25 => 'Ответ',
    26 => 'Следующие комментарии принадлежат тем, кто их опубликовал. Этот сайт не несёт ответственности за содержание комментариев.',
    27 => 'Свежайшая публикация',
    28 => 'Удалить',
    29 => 'Комментариев нет.',
    30 => 'Предыдущие статьи',
    31 => 'Разрешённые тэги HTML:',
    32 => 'Ошибка, неправильное имя пользователя',
    33 => 'Ошибка, не могу записать в журнальный файл',
    34 => 'Ошибка',
    35 => 'Выход',
    36 => 'вкл',
    37 => 'Статей нет',
    38 => 'Синдикация',
    39 => 'Обновить',
    40 => 'Error in password request, invalid username',
    41 => 'Гости',
    42 => 'Автор:',
    43 => 'Ответить на это',
    44 => 'Предок',
    45 => 'Номер ошибки MySQL',
    46 => 'Сообщение об ошибке MySQL',
    47 => 'Функции пользователя',
    48 => 'Информация об учётной записи',
    49 => 'Настройки изображения',
    50 => 'Ошибка выражения SQL ',
    51 => 'помощь',
    52 => 'Создать',
    53 => 'Рабочая страница Администратора',
    54 => 'Не могу открыть файл.',
    55 => 'Ошибка в',
    56 => 'Голосовать',
    57 => 'Пароль',
    58 => 'Войти',
    59 => "Не зарегистрировались?<br" . XHTML . ">-> <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">Новый пользователь</a>",
    60 => 'Послать комментарий',
    61 => 'Создать учётную запись',
    62 => 'cлова',
    63 => 'Параметры комментариев',
    64 => 'Послать статью другу',
    65 => 'Версия для печати',
    66 => '',
    67 => 'Добро пожаловать на ',
    68 => 'домой',
    69 => 'почта',
    70 => 'Найти',
    71 => 'опубликовать',
    72 => 'ссылки',
    73 => '',
    74 => '',
    75 => 'Расширенный поиск',
    76 => 'Статистика',
    77 => 'Модули',
    78 => '',
    79 => 'Что нового',
    80 => 'статей за',
    81 => 'статья за',
    82 => 'часов',
    83 => 'КОММЕНТАРИИ',
    84 => '',
    85 => 'за 48 часов',
    86 => 'Нет новых комментариев',
    87 => 'за 2 недели',
    88 => '',
    89 => '',
    90 => 'Домой',
    91 => 'Страница создана за',
    92 => 'секунд',
    93 => 'Копирайт',
    94 => 'Все торговые марки и копирайты на этой странице являются собственностью их хозяев.',
    95 => 'Работает на',
    96 => 'Группы',
    97 => 'Список слов',
    98 => 'Плагины',
    99 => 'СТАТЬИ',
    100 => 'Новых статей нет',
    101 => 'There are no older articles',
    102 => '',
    103 => 'Копии базы данных',
    104 => 'от',
    105 => 'Пользователи почты',
    106 => 'Просмотры',
    107 => 'Проверка версии GL',
    108 => 'Очистить кэш',
    109 => 'Сообщить о недопустимом использовании',
    110 => 'Уведомить администрацию об этом постинге',
    111 => '',
    112 => 'Зарегистрированные пользователи',
    113 => 'Документация',
    114 => 'TRACKBACKS',
    115 => 'No new trackback comments',
    116 => 'Trackback',
    117 => 'Directory',
    118 => 'Please continue reading on the next page:',
    119 => "Или <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">забыли пароль</a>?",
    120 => 'Permanent link to this comment',
    121 => 'Comments (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'All HTML is allowed',
    124 => 'Click to delete all checked items',
    125 => 'Are you sure you want to Delete all checked items?',
    126 => 'Select or de-select all items',
    127 => 'Permalink',
    128 => 'Login with OpenID:',
    129 => 'Configuration',
    130 => 'Webservices',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    140 => 'Allowed Autotags:',
    141 => 'An Error Occurred',
    142 => 'Unfortunately, an error has occurred rendering this page. Please try again later.',
    143 => 'Comment (%d)',
    144 => 'Parse Error.  An error occurred while parsing PHP code.',
    'loginform' => "<a href=\"{$_CONF['site_url']}/users.php\">Login Here</a>",
    'remoteloginoptions' => 'Remote Login Options',
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn',
    'google' => 'Login with Google',
    'microsoft' => 'Login with Microsoft',
    'yahoo' => 'Login with Yahoo',
    'github' => 'Login with GitHub',
    'ctl' => 'Clear Cache',
    'ok' => 'OK',
    'filemanager' => 'File Manager',
    'error_invalid_password' => 'Error, invalid password for username',
    'error_filemanager_disabled' => 'Filemanager is disabled',
    'terms_of_use' => 'Terms of Use',
    'terms_of_service' => 'Terms of Service',
    'privacy_policy' => 'Privacy Policy',
    'about_cookies' => 'About Cookies',
    'parse_php_error' => 'There was an error parsing your PHP code: %s',
    'error_title' => 'An Error Occurred'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Послать комментарий',
    2 => 'Режим публикации',
    3 => 'Выйти',
    4 => 'Создать учётную запись',
    5 => 'Имя пользователя',
    6 => 'This site requires you to be logged in to post a comment. If you have an account already (or need to create one), please <a href="%s">login here</a>.',
    7 => 'Ваш последный комментарий был ',
    8 => " секунд тому назад.  Просим извинить, но необходимо, что бы между комментариями прошло хотя бы {$_CONF['commentspeedlimit']} секунд",
    9 => 'Комментарий',
    10 => 'Отправить отчёт',
    11 => 'Отправить комментарий',
    12 => 'Пожалуйста, заполните поля: Имя, Почтовый адрес, Заголовок и Комментарий, т.к. они необходимы для публикации Вашего комментария.',
    13 => 'Ваша информация',
    14 => 'Предпросмотр',
    15 => 'Сообщить об этом постинге',
    16 => 'Заголовок',
    17 => 'Ошибка',
    18 => 'Важный материал',
    19 => 'Пожалуйста, придерживайтесь в сообщении темы.',
    20 => 'Пытайтесь ответить на комментарии других людей вместо того, что бы начинать новую цепочку.',
    21 => 'Прочтите сообщения других людей до отправки собственного сообщения, что бы избежать дублирования того, что уже сказано.',
    22 => 'Используйте заголовок, который бы точно передавал смысл сообщения.',
    23 => 'Ваш почтовый адрес НЕ будет опубликован.',
    'instr_line6' => 'When logged in as a user your comments will be linked to your account and you can specify if you would like notifications of any replies.',
    24 => 'Анонимный пользователь',
    25 => 'Вы действительно хотите уведомить администрацию об этом постинге?',
    26 => '%s сообщил о следующем нарушающем правила постинге:',
    27 => 'Сообщение о недопустимом использовании',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment.",
    100 => 'Comment Manager',
    101 => 'Existing Comments',
    102 => 'Bulk Action',
    103 => 'Ban this user',
    104 => 'Ban this IP address with the Spamx plugin',
    105 => 'IP Address',
    106 => 'Perform bulk action on comments and comment submissions including approval, deleting, and banning of user or IP address.',
    'record_edit' => 'Record user and time of edit?',
    'ban_plugin_ban_ip' => 'Ban this IP address with the Ban plugin',
    'num_comments' => '%s Comment(s)',
    'anon_user_name' => '%s (Anonymous User)',
    'comments_closed_msg' => 'Comments are closed and no new posts are allowed.',
    'read_comment' => 'Read the full comment at',
    'comment_for' => 'The above comment is for the following item',
    'comment_page_title' => 'Comments for %s',
    'comments' => 'Comments'
);

###############################################################################
# usersettings.php

$LANG04 = array(
    1 => 'Профиль пользователя для',
    2 => 'Имя пользователя',
    3 => 'Полное имя',
    4 => 'Пароль',
    5 => 'Почтовый адрес',
    6 => 'Домашняя страница',
    7 => 'Биография',
    8 => 'Ключ PGP',
    9 => 'Сохранить информацию',
    10 => 'Последние 10 комментариев на пользователя',
    11 => 'Нет пользовательских комментариев',
    12 => 'Установки пользователя для',
    13 => 'Ночной дайджест почты',
    14 => 'Этот пароль сгенерирован случайным образом. Мы рекомендуем сменить его немедленно. Для этого войдите в систему и выберите пункт Информация об учётной записи из Функций пользователя.',
    15 => "Ваша учётная запись на {$_CONF['site_name']} успешно создана. Для того, чтобы использовать её, Вы должны войти в систему под именем и паролем, указанными ниже. Пожалуйста, сохраните это письмо, чтобы воспользоваться им в случае необходимости.",
    'email_convert_remote' => "Your {$_CONF['site_name']} remote account has been converted to a local account. To continue to use your account, you must login using the information below. Please save this mail for further reference.",
    16 => 'Ваша Учётная запись',
    17 => 'Учётная запись не существует',
    18 => 'Указан неверный электронный адрес',
    19 => 'Указанные имя пользователя или электронный адрес уже существуют',
    20 => 'Указан неверный электронный адрес',
    21 => 'Ошибка',
    22 => 'Создать учётную запись',
    23 => 'Регистрация в нашей системе позволит Вам посылать комментарии и опубликовывать статьи под своим именем. Если Вы не зарегестрируетесь, все Ваши публикации будут подписаны - Без подписи.',
    24 => 'Ваш пароль будет отправлен по указанному Вами электронному адресу.',
    25 => 'Забыли пароль?',
    26 => 'Введите Ваше имя пользователя и новый пароль будет отправлен по электронному адресу, указанному при регистрации.',
    27 => 'Создать нового пользователя',
    28 => 'Отправить пароль',
    29 => 'вышел из',
    30 => 'вошёл из',
    31 => 'Прежде чем воспользоваться этой функцией, войдите в систему',
    32 => 'Подпись',
    33 => 'Эта информация недоступна другим пользователям',
    34 => 'Это Ваше настоящее имя',
    35 => 'Введите новый пароль, если Вы хотите изменить старый',
    36 => 'Адрес должен начинаться с http://',
    37 => 'Добавляется к комментариям',
    38 => 'Информация о Вас! Доступна всем пользователям',
    39 => 'Ваш публичный ключ PGP для совместного использования',
    42 => 'Формат даты',
    43 => 'Максимальное количество статей',
    48 => 'Темы',
    52 => 'По умолчанию',
    53 => 'Получать статьи дня каждый вечер',
    56 => 'Авторы',
    57 => 'Режим отображения',
    58 => 'Порядок сортировки',
    59 => 'Предельное количество комментариев',
    60 => 'Как Вы хотите отображать свои комментарии?',
    61 => 'По убыванию или по возрастанию даты?',
    62 => 'По умолчанию 100',
    63 => 'Ваш пароль был только что отправлен Вам по электронной почте. Пожалуйста, следуйте указаниям в сообщении. Мы благодарим Вас за использование ',
    64 => 'Параметры комментариев для',
    65 => 'Попробуйте ещё раз войти в систему',
    66 => 'Возможно Вы неправильно набрали пароль или имя пользователя. Если это так, Вы можете снова попробовать войти в систему ниже. Если Вы забыли свой пароль, Вы можете получить по электронной почте новый. Для этого заполните форму, расположенную внизу этой страницы.',
    67 => 'Зарегистрирован',
    68 => 'Помнить обо мне до',
    69 => 'Как долго мы должны помнить о Вас входа в систему?',
    'cookietimeout_tooltip' => 'This site will remember you are logged in from the device you are currently using regardless of if your account has been logged out automatically due to no activity. Accounts are logged out after being inactive for %s seconds (this is called the "User Session Timeout"). When "Remember Me For" is set for your account it will include the time you select here PLUS the "User Session timeout".',
    70 => "Настроить структуру и содержание {$_CONF['site_name']}",
    71 => "На нашем сайте Вы можете настроить содержание информации, которую Вы получите, а так же структуру расположения информации. Для этого Вы должны <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">зарегистрироваться</a> на {$_CONF['site_name']}.  Вы уже зарегистрировались? Используйте форму для входа в систему!",
    72 => 'Тема',
    73 => 'Язык',
    74 => 'Измените внешний вид сайта!',
    75 => 'Отправлены темы для',
    76 => 'Если Вы выберете тему из нижеприведенного списка, Вы сможете получать все новые сообщения опубликованные на эту тему в конце каждого дня.  Выбирайте только интересующие Вас темы!',
    77 => 'Фотография',
    78 => 'Добавьте Вашу фотографию!',
    79 => 'Отметьте здесь, чтобы стереть изображение',
    80 => 'Войти',
    81 => 'Отправить письмо',
    82 => 'Последние 10 статей для пользователя',
    83 => 'Составляется статистика для пользователя',
    84 => 'Всего статей:',
    85 => 'Всего комментариев:',
    86 => 'Найти все сообщения',
    87 => 'Ваш логин',
    88 => "Кто-то (возможно Вы) запросил новый пароль для Вашего аккаунта \"%s\" на {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nЕсли Вы действительно хотите произвести данное действие, пожалуйста, кликните на следующей ссылке:\n\n",
    'user_password_action_msg' => 'If you really want this action to be taken, please click on the following link:',
    89 => "Если Вы не хотите выполнять данное действие, просто проигнорируйтеэто сообщение и запрос будет отменён (Ваш пароль останеттся неизменённым).\n\n",
    90 => 'Вы можете отредактировать новый пароль для Вашего аккаунта ниже. Имейте ввиду, что Ваш старый пароль является валидным пока Вы не отправите это форму.',
    91 => 'Установить новый пароль',
    92 => 'ВВести новый пароль',
    93 => 'Ваш последний запрос о новом пароле был %d секунд назад. Наш сайт требует как минимум %d секунд между запросами пароля.',
    94 => 'Удалить аккаунт "%s"',
    96 => 'удалить аккаунт',
    97 => 'Подтвердите удаление аккаунта',
    98 => 'Вы уверены, что хотите удалить Ваш аккаунт? Сделав это, Вы не сможете войти в этот сайт снова (если не создадите новый аккаунт). Если вы уверены - кликните "удалить аккаунт" снова в форме ниже.',
    99 => 'Установки Приватности для',
    100 => 'Почта от Администратора',
    101 => 'Разрешить почту от администриторов сайта',
    102 => 'Почта от пользователей',
    103 => 'Разрешить почту от других пользователей',
    104 => 'Показывать онлайн-статус',
    105 => 'Показывать в Who\'s Online блоке',
    106 => 'Location',
    107 => 'Будет показан в Вашем публичном профиле',
    108 => 'Подтвердите новый пароль',
    109 => 'Повторно введите Ваш новый пароль здесь',
    110 => 'Текущий пароль',
    111 => 'Пожалуйста, введите Ваш Текущий пароль',
    112 => 'Вы превысили разрешённое количество попыток ввода пароля. Попробуйте снова позднее.',
    113 => 'Попытка входа неудачна',
    114 => 'Аккаунт заблокирован',
    115 => 'Ваш аккаунт был заблокирован, возможно, Вы не сможете войти. Свяжитесь с Администрацией.',
    116 => 'Аккаунт ожидает активацию',
    117 => 'Ваш аккаунт ожидает активации Администратором. Будьте терпеливы.',
    118 => '',
    119 => '',
    120 => 'Аккаунт активирован',
    121 => 'Service',
    122 => 'Извините, регистрация новых пользователей отключена',
    123 => "Вы <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">новый пользователь</a>?",
    124 => 'Подтвержите Email',
    125 => 'Вы должны ввести одинаковые email адреса в обоих полях!',
    126 => 'Пожалуйста, повторите для подтверждения',
    127 => 'Для изменения каких-либо настроек Вы должны ввести свой текущий пароль.',
    128 => 'Ваше имя',
    129 => 'Пароль &amp; Email',
    130 => 'О Вас',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Comment Display',
    134 => 'Comment Options',
    135 => '<li>Default mode for how comments will be displayed</li><li>Default order to display comments</li><li>Set maximum number of comments to show - default is 100</li>',
    138 => 'Misc Settings',
    139 => 'Тема и язык',
    140 => '<li>No Topic Icons if checked will not display the article topic icons</li><li>No boxes if checked will only show the Admin Menu, User Menu and Topics</li><li>Set the maximum number of articles to show per page</li><li>Set your theme, timezone and preferred date format</li>',
    141 => 'Privacy Settings',
    142 => 'The default setting is to allow users & admins to email fellow site members and show your status as online. Un-check these options to protect your privacy.',
    145 => 'Your Public Profile',
    146 => 'Пароль и email',
    147 => 'Edit your account password, email and autologin feature. You will need to enter the same password or email address twice as a confirmation.',
    148 => 'Информация о Пользователе',
    149 => 'Modify your user information that will be shown to other users.<li>The signature will be added to any comments or forum posts you made</li><li>The BIO is a brief summary of yourself to share</li><li>Share your PGP Key</li>',
    150 => '',
    156 => 'Удалить аккаунт',
    157 => 'Delete Option',
    158 => 'Time Zone',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services',
    169 => 'User has updated his/her profile',
    170 => "Admin at {$_CONF['site_name']} changed the password of your account as follows.  Please save this mail for further reference.",
    171 => 'Post mode for "Signature" and "Bio".',
    'user_login' => 'User Login',
    'user_login_message' => 'Please login below. You must enter both a username and password.',
    'user_remote_login_desc_long' => 'Click on one of the button(s) below to login and/or register via an account you have on another supported remote service. Please note, you must have an account on the remote service. If you are creating a new account on this website, then the remote service may ask you to give this website permissions to access information like your name, email address, and profile photo.',
    'remote_register_instructions' => "<strong>Please note:</strong> To register and create an account via Remote Login, please visit the <a href=\"{$_CONF['site_url']}/users.php\" rel=\"nofollow\">User Login</a>.",
    'user_logged_in_message' => "You are already logged in. Whould you like to <a href=\"{$_CONF['site_url']}/users.php?mode=logout\" rel=\"nofollow\">logout</a>?",
    'user_max_login_attempts' => 'Max Login Attempts and Speed Limit Reached',
    'tfa_two_factor_auth' => 'Two Factor Authentication',
    'tfa_help1' => 'Make sure to install "Google Authenticator" application on your mobile device before you enable Two Factor Authentication.',
    'tfa_help2' => 'Enable Two Factor Authentication.',
    'tfa_help3' => 'Run "Google Authenticator", tap on the plus icon and scan the QR code.',
    'tfa_help4' => 'Print or download the backup codes below in case you cannot use your mobile device you installed the Google Authenticator.  Each backup code is valid only one-time.  If you generate a new set of backup codes, then the current set will be invalid.',
    'tfa_help5' => 'Hit the "Save" button at the bottom of the screen.',
    'tfa_enter_code' => 'Enter the %d-digit code your Google Authenticator app is showing or one of the backup code you have got in your preference page.',
    'tfa_backup_code_desc' => 'Note: You can only use a backup code once, then it becomes invalid. Remember to generate more backup codes from the user preference page if you are getting low.',
    'tfa_code' => 'Google Authenticator Code',
    'tfa_authenticate' => 'Authenticate',
    'tfa_qrcode' => 'QR Code',
    'tfa_show_hide' => 'Show/Hide',
    'tfa_backup_code' => 'Backup Codes',
    'tfa_download' => 'Download Backup Codes',
    'tfa_new_backup_code' => 'Generate a new set of backup codes',
    'tfa_generate_confirm' => 'Go ahead?',
    'lang_tfa_user_edit_desc' => 'You are only allowed to disable Two Factor Authentication (2FA) from this form if needed (like the user does not have their backup codes). It should not be enabled by Admins as the user themselves are required to enable and setup 2FA from their Account, including the Google Authenticator App for their phone and coping the backup codes.',
    'desc_new_pwd_status' => 'You are required to enter a new password for your account. You can enter a new password for your account below. <em>Please note you will not be able to do anything with your account until your password is updated.</em>',
    'new_email' => 'New Email',
    'set_new_email' => 'Set New Email',
    'confirm_new_email' => 'Confirm new email',
    'enter_new_email' => 'Enter New Email',
    'desc_new_email_status' => 'You are required to enter a new email address for your account. You can enter a new email for your account below. <em>Please note you will not be able to do anything with your account until your email is updated and verified.</em>',
    'email_msg_email_status_1' => "You have updated your email address for your account \"%s\" on {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nPlease click on the following link to verify this email address:\n\n",
    'email_msg_verify' => 'Please click on the following link to verify this email address:',
    'email_msg_email_status_2' => "If you do not verify this email address and you log into your account you will be required to enter a new email address and go through this email verification process again.\n\n",
    'email_verify' => 'New Email to be Verified',
    'email_verify_delete' => 'Delete email to be verified',
    'email_verify_msg' => "You have previously updated your email address for your account but it still needs to be verified. Please check your email account for an email from {$_CONF['site_name']} that contains a verification link. Once you click on that link your new email address will be verified and your account will be updated to use it.<br" . XHTML . "><br" . XHTML . ">If you wish you may update the new email to be verified with the email fields above or you can delete it.",
    'remove_account_msg' => 'To remove your account from our database, enter your current password into the above "Current Password", check the checkbox next to "Delete Option" below and click on "Save" . Please note that any articles and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    'remove_remote_account_msg' => 'To remove your remote account from our database, check the checkbox next to "Delete Option" below and click on "Save" . Please note that any articles and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    'theme_info' => '%1$s %2$s (requires Geeklog %3$s)'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Preview',
    'pe_namepass' => 'Username &amp; Password',
    'pe_userinfo' => 'About You',
    'pe_layout' => 'Layout &amp; Language',
    'pe_content' => 'Content',
    'pe_privacy' => 'Privacy'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Новостей для показа нет',
    2 => 'Новых статей для показа нет. Может быть нет новостей на данную тему, либо Ваши Установки пользователя слишком жесткие',
    3 => '',
    4 => 'Сегодняшняя Особая статья',
    5 => 'Следующая',
    6 => 'Предыдущая',
    7 => 'Первая',
    8 => 'Последняя',
    9 => 'Page navigation'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'При отправке Вашего сообщения произошла ошибка. Пожалуйста, попробуйте ещё.',
    2 => 'Сообщение было успешно отправлено.',
    3 => 'Пожалуйста, удостоверьтесь, что Вы набрали правильный адрес в поле Обратный адрес.',
    4 => 'Пожалуйста, заполните поля: Ваше имя, Обратный адрес, Тема, Сообщение.',
    5 => 'Ошибка: Такого пользователя нет.',
    6 => 'Произошла ошибка.',
    7 => 'Биография пользователя для',
    8 => 'Имя пользователя',
    9 => 'URL пользователя',
    10 => 'Письмо для',
    11 => 'Ваше имя:',
    12 => 'Обратный адрес:',
    13 => 'Тема:',
    14 => 'Сообщение:',
    15 => 'HTML не будет интерпретирован.',
    16 => 'Послать сообщение',
    17 => 'Послать статью другу',
    18 => 'Получатель',
    19 => 'Адрес получателя',
    20 => 'Отправитель',
    21 => 'Адрес отправителя',
    22 => 'Все поля обязательны',
    23 => "Сообщение отправил %s, адрес %s, полагая, что Вас заинтересует следующая статья, источник: {$_CONF['site_url']}.  Это не SPAM, и электронные адреса, вовлечённые в эту  транзакцию, не были сохранены для последующего использования.",
    24 => 'Комментарий на эту тему за',
    25 => 'Чтобы использовать эту функцию, Вы должны войти в систему. Ваша регистрация поможет нам предотвратить неправильное использование системы',
    26 => 'Эта форма позволит Вам отправить электронное сообщение выбранному пользователю.  Все поля обязательны.',
    27 => 'Короткое сообщение',
    28 => '%s пишет: ',
    29 => "Это дневной дайджест с {$_CONF['site_name']} для ",
    30 => ' Дневной новостной бюллетень для ',
    31 => 'Название',
    32 => 'Дата',
    33 => 'Читайте полную статью на',
    34 => 'Конец сообщения',
    35 => 'Извините, но установки данного пользователя не позволяют ему отправить сообщение.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages",
    41 => 'This user doesn\'t exist.',
    42 => 'This users email address doesn\'t exist. This most likely means is is an OAuth user account.',
    43 => 'This users email address is invalid.',
    44 => 'This users status is set to something other than Active or New Password therefore the email address is assumed bad.',
    45 => "This is a message sent from {$_CONF['site_name']} by %s. Any replies will need to be sent to the email address: %s",
    46 => "To unsubscribe from the Daily Digest, login to {$_CONF['site_name']} at {$_CONF['site_url']}. Then visit the user settings page at {$_CONF['site_url']}/usersettings.php and view the Content Tab. You can then unsubscribe to the Daily Digest by deselecting all topics and saving your profile."
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Расширенный поиск',
    2 => 'Ключевые слова',
    3 => 'Тема',
    4 => 'Всё',
    5 => 'Тип',
    6 => 'Статьи',
    7 => 'Комментарии',
    8 => 'Авторы',
    9 => 'Всё',
    10 => 'Поиск',
    11 => 'Результаты поиска',
    12 => 'совпадений',
    13 => 'Результат поиска статьи: Нет совпадений',
    14 => 'Не найдено никаких совпадений по Вашему запросу',
    15 => 'Пожалуйста, попробуйте ещё раз.',
    16 => 'Заголовок',
    17 => 'Дата',
    18 => 'Автор',
    19 => "Поиск по всей базе {$_CONF['site_name']} текущих и архивных статей",
    20 => 'Дата',
    21 => 'по',
    22 => '(Формат даты ММ-ДД-ГГГГ)',
    23 => 'Хиты',
    24 => 'Найдено',
    25 => 'совпадений для',
    26 => 'пунктов за',
    27 => 'секунд',
    28 => 'Ни одной статьи или комментария, соответствующих Вашему запросу, не найдено',
    29 => 'Результаты по статьям и комментариям',
    30 => '',
    31 => 'Этот запрос (ping) не вернул результатов',
    32 => '',
    33 => 'URL',
    34 => 'Место',
    35 => 'Весь день',
    36 => 'Key Word Type',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Строка запорса должна содержать как минимум 3 символа.',
    42 => 'Пожалуйста, используйте дату в следующем формате: ГГГГ-ММ-ДД (год-месяц-день).',
    43 => 'точное совпадение',
    44 => 'все слова',
    45 => 'любое из слов',
    46 => 'следующие',
    47 => 'предыдущие',
    48 => 'Автор',
    49 => 'Дата',
    50 => 'Хиты',
    51 => '',
    52 => 'Расположение',
    53 => 'Данные статьи',
    54 => 'Данные комментария',
    55 => 'запрос',
    56 => 'И',
    57 => 'ИЛИ',
    58 => 'More results &gt;&gt;',
    59 => 'Results',
    60 => 'per page',
    61 => 'Refine search',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Article',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc',
    73 => 'Submit',
    74 => 'Limit Results'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Статистика сайта',
    2 => 'Хиты в системе',
    3 => 'Статьи (комментарии) в системе',
    4 => 'Site Statistic',
    5 => "Overall Site Statistics for {$_CONF['site_name']}",
    6 => '',
    7 => 'Десятка самых читаемых статей',
    8 => 'Название статьи',
    9 => 'Просмотры',
    10 => 'На сайте отсутствуют статьи, или их никто не просматривал.',
    11 => 'Десятка наиболее комментируемых статей',
    12 => 'Комментарии',
    13 => 'На сайте отсутствуют статьи, или никто не опубликовал комментарии.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => '10 наиболее пересылаемых статей',
    23 => 'Почтовые пересылки',
    24 => 'Похоже, что никто не пересылал по почте статью на этом сайте',
    25 => 'Top Ten Trackback Commented Articles',
    26 => 'No trackback comments found.',
    27 => 'Number of active users',
    28 => '',
    29 => '',
    30 => 'Hits',
    31 => '',
    32 => 'Top Ten Liked Articles',
    33 => 'No liked articles found.'
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Что имеет отношение',
    2 => 'Отправить статью другу',
    3 => 'Печатная форма статьи',
    4 => 'Параметры статьи',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Для публикации Вы должны быть зарегестрированы как пользователь.',
    2 => 'Войти',
    3 => 'Новый пользователь',
    4 => '',
    5 => '',
    6 => 'Публикация статьи',
    7 => 'Регистрация в системе обязятельна',
    8 => 'Опубликовать',
    9 => 'При публикации информации на этом сайте для последующего использования, рекомендуется придерживаться следующих указаний...<ul><li>Заполните все поля, они обязательны<li>Обеспечьте полную и достоверную информацию<li>Дважды проверьте используемые URL</li><li>Чтобы добавить рисунок, используйте тэг &lt;img src=ImageName&gt, где ImageName полное имя файла, заключенное в кавычки. Например, &lt;img src="C:/Мои документы/Мои рисунки/picture.jpg"&gt;.</li></ul>',
    10 => 'Заголовок',
    11 => '',
    12 => 'Дата начала',
    13 => 'Дата конца',
    14 => 'Место проведения',
    15 => 'Описание',
    16 => '',
    17 => '',
    18 => '',
    19 => 'В первую очередь прочтите',
    20 => '',
    21 => '',
    22 => 'Ошибка: Незаполненные поля',
    23 => 'Пожалуйста, заполните все поля формы. Все поля обязательны.',
    24 => 'Публикация сохранена',
    25 => 'Ваша статья %s успешно сохранена.',
    26 => 'Ограничение быстродействия',
    27 => 'Имя пользователя',
    28 => 'Раздел',
    29 => 'Текст',
    30 => 'Последний ввод данных произошёл ',
    31 => " секунд назад.  Система требует по крайней мере {$_CONF['speedlimit']} секунд между подачами данных.",
    32 => 'Предпросмотр статьи',
    33 => 'Предпросмотр',
    34 => 'Выход из системы',
    35 => 'Использование HTML тэгов запрещено',
    36 => 'Режим публикации',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Адрес строка 1',
    45 => 'Адрес строка 2',
    46 => 'Город',
    47 => 'Штат',
    48 => 'Индекс',
    49 => '',
    50 => '',
    51 => 'Местоположение',
    52 => 'Удалить',
    53 => 'Создать счет',
    54 => 'Article Introduction',
    55 => 'Article Body'
);

###############################################################################
# LIKES feature since Geeklog 2.2.1

$LANG_LIKES = array(
    'like' => 'Like',
    'unlike' => 'Unlike',
    'dislike' => 'Dislike',
    'undislike' => 'Undislike',
    'likes' => 'Likes',
    'unlikes' => 'Unlikes',
    'dislikes' => 'Dislikes',
    'undislikes' => 'Undislikes',
    'i_like_this' => 'I like this',
    'i_dislike_this' => 'I dislike this',
    'thanks_for_action' => 'Thanks for voting!',
    'likes_speedlimit' => 'You last used the Likes system on an item %s seconds ago. This site requires at least %s seconds between using the Likes system',
    'likes_ip_error' => 'Your IP address has already performed this Likes action.',
    'likes_uid_error' => 'Your User account has already performed this Likes action.',
    'own_item_error' => 'Either you own the item or do not have permission to Like/Dislike it.',
    'liked_by' => 'Liked by:',
    'disliked_by' => 'Disliked by:',
    'num_anon_users' => '<br' . XHTML . '>%s Anonymous Users',
    'one_anon_users' => '<br' . XHTML . '>1 Anonymous User',
    'num_more_users' => '<br' . XHTML . '>+%s more Users',
    'username_in_likes_list' => '<br' . XHTML . '>%s',
    'autotag_desc_likes_block' => "[likes_block:aid action:aid wrapper:wid class:likes-autotag type: subtype: time:604800 max:10 cache:3600 line:1 length:20]
\n	- Displays the Likes block. No attributes are required. If attribute not specified then default in configuration used. 
\n	- action = 1 (likes only), 2 (dislikes only), or 3 (both) 
\n	- wrapper = 0 (no wrapper), 1 (block wrapper with title), div wrapper with css class), or both
\n	- class = Specifies the css class used by the div wrapper if enabled else default likes-autotag will be used 
\n	- type = Either empty (for all types) or include 1 supported like type. For example 'article' or 'comment'
\n	- subtype = Specify a sub type of type if needed
\n	- time = Display items that are this many seconds old. 0 will display all items
\n	- max = Maximum number of items to display
\n	- cache = Cached for no longer than this many seconds. If 0 caching is disabled
\n	- line = Display likes icons on new line
\n	- length = Trim item title length to this many characters",
    'num_likes_in_time_limit' => 'The last number of Likes this item received within the time specified.',
    'num_dislikes_in_time_limit' => 'The last number of Dislikes this item received within the time specified.',
    'num_likes_total' => 'The total number of Likes this item has received.',
    'num_dislikes_total' => 'The total number of Dislikes this item has received.',
    'likes_time_span' => 'Most Likes in the last %t %s',
    'dislikes_time_span' => 'Most Dislikes in the last %t %s',
    'all_time_span' => 'Most engaging in the last %t %s',
    'whats_liked' => 'Whats Liked',
    'whats_recently_liked' => 'Whats Recently Liked',
    'whats_disliked' => 'Whats Disliked',
    'whats_recently_disliked' => 'Whats Recently Disliked',
    'whats_popular' => 'Whats Popular',
    'whats_recently_popular' => 'Whats Recently Popular',
    'whats_liked_type' => 'Liked %s',
    'whats_recently_liked_type' => 'Recently Liked %s',
    'whats_disliked_type' => 'Disliked %s',
    'whats_recently_disliked_type' => 'Recently Disliked %s',
    'whats_popular_type' => 'Popular %s',
    'whats_recently_popular_type' => 'Recently Popular %s',
    'no_liked_items_in_time_limit' => 'There have been no Likes during the time specified.',
    'no_disliked_items_in_time_limit' => 'There have been no Dislikes during the time specified.',
    'no_action_items_in_time_limit' => 'There have been no Likes or Dislikes during the time specified.',
    'no_liked_items' => 'There are no Liked items.',
    'no_disliked_items' => 'There are no Disliked items.',
    'no_action_items' => 'There are no Liked or Disliked items.',
    'last_num_likes_by' => 'Last %s Likes and Dislikes by %s',
    'msg_no_likes' => 'No likes or dislikes found by user.',
    'total_num_likes' => 'Total number of likes and dislikes:',
    'title_liked' => '%s Liked on ',
    'title_disliked' => '%s Disliked on ',
    'articles' => 'Articles',
    'comments' => 'Comments'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/logviewer.php

$LANG_LOGVIEW = array(
    'log_viewer' => 'Log Viewer',
    'info' => 'Geeklog log file administration.',
    'logs' => 'Logs',
    'view' => 'View Log File',
    'clear' => 'Clear Log File',
    'log_file' => 'Log File'
);

###############################################################################
# admin/envcheck.php - distribution integrity checker

$LANG_ENVCHECK = array(
    'correct_perms' => 'Please correct the issues identified below. Once they have been corrected, use the <b>Recheck</b> button to validate the environment.',
    'current' => 'Current',
    'current_php_settings' => 'Current PHP Settings',
    'directory_permissions' => 'Directory Permissions',
    'enabled' => 'Enabled',
    'env_check' => 'Environment Check',
    'file_permissions' => 'File Permissions',
    'file_uploads' => 'Many features of Geeklog require the ability to upload files, this should be enabled.',
    'filesystem_check' => 'Directory / File Permissions',
    'gd_lib' => 'GD Libraries',
    'gd_not_found' => 'Unable to locate the GD library functions.  Please ensure that the GD libraries were compiled into PHP or select an alternate graphics library.',
    'gd_ok' => 'GD Libraries v2 are installed.',
    'gd_v1' => 'GD Libraries v1 is installed - This version does not fully support JPG image processing so there may be some quality issues.',
    'graphics' => 'Graphics Library',
    'libraries' => 'Libraries',
    'hosting_env' => 'Hosting Environment Check',
    'imagemagick' => 'ImageMagick Programs',
    'im_not_found' => 'Unable to locate the <strong>convert</strong> executable for ImageMagick.',
    'im_ok' => 'The <strong>convert</strong> executable appears to be valid.',
    'memory_limit' => 'It is recommended that you have at least 48M of memory enabled on your site.',
    'not_writable' => 'NOT WRITABLE',
    'notes' => 'Notes',
    'not_found' => 'Not Found',
    'netpbm' => 'NetPBM Library',
    'np_ok' => 'The NetPBM library is installed',
    'np_not_found' => 'The NetPBM executables were not found.',
    'fileinfo_library' => 'Fileinfo Library',
    'fileinfo_ok' => 'The Fileinfo library is loaded. This library is required when uploading images for articles. It is used to get the mime type of the file being uploaded when creating a thumbnail of the image.',
    'fileinfo_not_found' => 'The Fileinfo library is not loaded. This is required <strong>only</strong> when uploading images in the article editor.',
    'openssl_library' => 'OpenSSL Library',
    'openssl_ok' => 'The OpenSSL library is loaded. This library is required if you wish to use the OAuth user login method with Geeklog.',
    'openssl_not_found' => 'The OpenSSL library is not loaded. This is required <strong>only</strong> if you wish to use the OAuth user login method with Geeklog.',
    'off' => 'Off',
    'ok' => 'OK',
    'on' => 'On',
    'open_basedir' => 'If <strong>open_basedir</strong> restrictions are enabled on your site, it may cause permission problems during the install. The File System Check below should point out any issues.',
    'database_settings' => 'Database Settings',
    'database_mysql_version' => 'MySQL Version',
    'database_mysql_req_version' => 'Geeklog requires MySQL version 4.1.2 or newer (MySQL 5 recommended).',
    'database_pgsql_version' => 'Postgresql Version',
    'database_pgsql_req_version' => 'Geeklog requires Postgresql version 9.1.7 or newer.',
    'database_dms' => 'Database Management System',
    'database_dms_notes' => 'Failed to determine Database Management System. Geeklog requires either MySQL or Postgresql',
    'php_req_version' => 'Geeklog requires PHP version 5.6.4 or newer.',
    'php_settings' => 'PHP Settings',
    'php_version' => 'PHP Version',
    'php_warning' => 'If any of the items below are marked in <span class="no">red</span>, you may encounter problems with your Geeklog site.  Check with your hosting provider for information on changing any of these PHP settings.',
    'post_max_size' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the maximum post size.',
    'recheck' => 'Recheck Environment',
    'recommended' => 'Recommended',
    'setting' => 'Setting',
    'unable_mkdir' => 'Unable to create directory',
    'upload_max_filesize' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the upload size.',
    'not_checked' => 'Skipped',
    'bypass_note' => 'Since either Safe Mode or open_basedir restrictions were detected, the check for graphic libraries were skipped.',
    'not_used_note' => 'No graphic libraries are set to be used by Geeklog.',
    'location' => 'Location',
    'status' => 'Status',
    'item' => 'Item',
    'jhead' => 'jhead Program',
    'jhead_not_found' => 'Unable to locate the jhead executable.',
    'jhead_ok' => 'The jhead executable is installed.',
    'jpegtran' => 'jpegtran Program',
    'jpegtran_not_found' => 'Unable to locate the jpegtran executable.',
    'jpegtran_ok' => 'The jpegtran executable is installed.',
    'showhide_phpinfo' => 'Show/Hide Full PHP Info',
    'view_online' => 'Click here %s to view online',
    'no_new_items' => 'No New Items',
    'max_execution_time' => 'Geeklog recommends the PHP default value of 30 seconds as a minimum, but plugin uploads and other operations may take longer than this depending upon your hosting environment.  If safe_mode (above) is Off, you may be able to increase this by modifying the value of <b>max_execution_time</b> in your php.ini file.',
    'phpinfo_disabled' => 'In order to view the current php settings, you will have to contact your host and enable access to the phpinfo() function.'
);

###############################################################################
# For Demo Mode (since v2.2.1)

$LANG_DEMO = array(
    'header' => 'Header',
    'subject' => 'Subject:',
    'to' => 'To:',
    'from' => 'From:',
    'priority' => 'Priority:',
    'body' => 'Body',
    'notice' => 'Notice',
    'emails_disabled_msg' => 'Please note sending emails is disabled in Demo mode. An email which would have been sent was:'
);

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Необходима аутентификация',
    2 => 'Отказано! Неверная регистрационная информация',
    3 => 'Неверный пароль',
    4 => 'Имя пользователя:',
    5 => 'Пароль:',
    6 => 'Доступ к административным функциям этого сайта журналируется и просматривается.<br' . XHTML . '>Эта страница только для авторизованного персонала сайта.',
    7 => 'вход',
    8 => 'Login',
    9 => 'This page is for the use of authorized personnel only. Please note all access to administrative portions of this web site are logged and reviewed.'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Недостаточно административных прав',
    2 => 'У Вас нет прав для изменения этого блока.',
    3 => 'Редактор блоков',
    4 => 'There was a problem reading this feed (see error.log for details).',
    5 => 'Yes',
    6 => 'No',
    7 => 'Всё',
    8 => 'Уровень допуска блока',
    9 => 'Порядок блока',
    10 => '',
    11 => 'Портальный блок',
    12 => 'Обычный блок',
    13 => 'Параметры портального блока',
    14 => 'RDF URL',
    15 => 'Последнее обновление RDF',
    16 => 'Параметры обычного блока',
    17 => 'Содержимое блока',
    18 => 'Пожалуйста, заполните поля Заголовок блока, Уровень допуска и Содержимое блока',
    19 => 'Менеджер блоков',
    20 => 'Regular Blocks',
    21 => 'Уровень<br' . XHTML . '>секетности блока',
    22 => 'Dynamic Blocks',
    23 => 'Порядок блока',
    24 => 'Dynamic',
    25 => 'Для изменения или удаления блока, выберите блок ниже. Для создания нового нажмите на кнопку Создать блок.',
    26 => 'Разметочный блок',
    27 => 'Блок PHP',
    28 => 'Свойства Блока PHP',
    29 => 'Функция блока',
    30 => 'Если Вы хотите, что бы один из блоков использовал PHP код, введите имя функции выше. Ваша функция должна начинаться с префикса "phpblock_" (например phpblock_getweather).  Если она не имеет указанного префикса, она НЕ будет вызвана.  Это сделано для того, что бы не позволить людям, которые могут взломать Ваш Geeklog, вызывать функции, которые могут быть опасны для Вашей системы.  Не помещайте пустые скобки "()" после имени Вашей функции.  Мы рекомендуем размещать код Ваших функций в /path/to/geeklog/system/lib-custom.php.  Это позволит Вам сохранить код даже в случае перехода на новую версию Geeklog.',
    31 => 'Ошибка в Блоке PHP.  Функция %s не существует.',
    32 => 'Ошибка потеряно(ы) поле(я)',
    33 => 'Введите URL к .rdf файлу для портального блока',
    34 => 'Введите заголовок и функцию для PHP блока',
    35 => 'Введите заголовок и содержимое для обычного блока',
    36 => 'Введите содержимое для структурного блока',
    37 => 'Неверное имя для функции блока PHP',
    38 => 'Функция для блока PHP должна иметь префикс "phpblock_" (например phpblock_getweather).  Префикс "phpblock_" необходим по соображениям безопасности для предотвращения исполнения нежелательного кода.',
    39 => 'Сторона',
    40 => 'Слева',
    41 => 'Справа',
    42 => 'Вы должны ввести порядок блоков и уровень допуска для блока по-умолчанию',
    43 => 'Только для Главной страницы',
    44 => 'Multiple',
    45 => "Вы пытались получить доступ к блоку, для которого у Вас нет прав. Эта попытка была запротоколирована. Пожалуйста, <a href=\"{$_CONF['site_admin_url']}/block.php\">вернитесь на станицу администрирования блоков</a>.",
    46 => 'Новый блок',
    47 => 'None',
    48 => 'Имя блока',
    49 => ' (без пробелов и должно быть уникально)',
    50 => 'The Block Name can not be empty',
    51 => 'включая http://',
    52 => 'Если Вы оставите это поле пустым значок помощи для блока не будетпоказан',
    53 => 'Разрешено',
    54 => 'сохранить',
    55 => 'отменить',
    56 => 'удалить',
    57 => 'Сдвинуть блок вниз',
    58 => 'Сдвинуть блок вверх',
    59 => 'Сдвинуть блок в правую сторону',
    60 => 'Сдвинуть блок в левую сторону',
    61 => 'No Title',
    62 => 'Article Limit',
    63 => 'Bad Block Title',
    64 => 'Your Title must not be empty and cannot contain HTML!',
    65 => 'Order',
    66 => 'Autotags',
    67 => 'Check to allow autotags',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.',
    69 => 'Plugin Name',
    70 => 'CSS ID',
    71 => 'This field is optional',
    72 => 'CSS Classes',
    73 => 'This field is optional.  You can specify multiple classes separated by space',
    'autotag_desc_block' => '[block:name class:block-autotag] - Displays a block. Class not required. Class specifies the css class and will wrap the block in a div. The class block-autotag will always be included with the div.',
    'newlines' => 'Newlines',
    'convert_newlines' => 'Check to convert newlines (EOL) into line break HTML element',
    'position' => 'Position',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This block will be cached for no longer than this many seconds. If 0 caching is disabled. (3600 = 1 hour,  86400 = 1 day)',
    'block_type_gldefault' => 'System',
    'block_type_normal' => 'Normal',
    'block_type_phpblock' => 'PHP',
    'block_type_portal' => 'Portal',
    'block_type_dynamic' => 'Dynamic'
);

###############################################################################
# Block Locations

$LANG23 = array(
    'blocks_article_footer_name' => 'Article Footer',
    'blocks_article_footer_desc' => 'Display Blocks in article Footer',
    'blocks_article_topic_list_name' => 'Article Topic List',
    'blocks_article_topic_list_desc' => 'Displays Blocks right after every X number of articles in topics.'
);

###############################################################################
# admin/article.php

$LANG24 = array(
    1 => 'Предыдущие статьи',
    2 => 'Следующие статьи',
    3 => 'Режим',
    4 => 'Режим публикации',
    5 => 'Редактирование статьи',
    6 => 'Статей нет',
    7 => 'Автор',
    8 => 'сохранить',
    9 => 'предварительный просмотр',
    10 => 'отменить',
    11 => 'стереть',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Дата',
    16 => 'Преамбула',
    17 => 'Текст статьи',
    18 => 'Хиты',
    19 => 'Комментарии',
    20 => 'Ping',
    21 => 'Send Ping',
    22 => 'Список статей',
    23 => 'Для изменения или удаления статьи, выберите номер статьи ниже.  Для просмотра статьи нажмите на её заголовок. Для создания новой нажмите на кнопку Создать статью.',
    24 => 'ID, который вы выбрали для этой публикации, уже занят. Пожалуйста, выберите другой.',
    25 => 'Error when saving article',
    26 => 'Предварительный просмотр статьи',
    27 => 'If you use [unscaledX] instead of [imageX], the image will be inserted at its original dimensions.',
    28 => '<p><b>PREVIEWING</b>: Previewing an article with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    29 => 'Trackbacks',
    30 => 'Ошибка загрузки файла',
    31 => 'Пожалуйста, заполните поля Автор, Заголовок и Преамбула',
    32 => 'Особая',
    33 => 'Может существовать только одна Особая статья',
    34 => 'Черновик',
    35 => 'Да',
    36 => 'Нет',
    37 => 'Ещё от',
    38 => 'Ещё от',
    39 => 'Пересылки',
    40 => '',
    41 => "Вы пытались получить доступ к статье, на которую у Вас нет прав. Эта попытка была запротоколирована.  You may view the article in read-only below. Пожалуйста, <a href=\"{$_CONF['site_admin_url']}/article.php\">вернитесь на станицу администрирования статей</a> когда закончите.",
    42 => "Вы пытались получить доступ к статье, на которую у Вас нет прав. Эта попытка была запротоколирована. Пожалуйста, <a href=\"{$_CONF['site_admin_url']}/article.php\">вернитесь на станицу администрирования статей</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>Замечание:</b> Если Вы измените эту дату на дату в будущем, эта статья не будет опубликована до указанной даты. Это также означает, что статья не будет указана в Вашем RDF файле заголовкови будет игнорироваться при поиске и на странице статистики.',
    47 => 'Изображения',
    48 => 'изображение',
    49 => 'справа',
    50 => 'слева',
    51 => 'Чтобы добавить одно из изображений прилагаемых Вами к статье, Вам следует добавить текст, сформатированный таким образом:  [imageX], [imageX_right] или [imageX_left], где X - номер прилагаемого Вами изображения.  Замечание: Вы должны использовать все прилагаемые Вами изображения. В противном случае, Вам не удастся сохранить Вашу статью.<BR><P><B>PREVIEWING</B>: Предварительный просмотр статьи с прилагаемыми изображениями лучше всего осуществить сохранив статью как набросок, ВМЕСТО того, чтобы нажимать кнопку предварительного просмотра.  Нажимайте кнопку предварительного просмотра только тогда, когда Вы не прилагаете к статье изображений.',
    52 => '',
    53 => 'не был использован.  Вы должны включить эту картинку в преамбулу или текст перед тем, как сохранить Ваши изменения',
    54 => 'Добавленные изображения не использованы',
    55 => 'Следующие ошибки произошли при сохранении Вашей статьи.  Пожалуйста, исправьте ошибки перед тем, как сохранить статью',
    56 => 'Показать иконку темы',
    57 => 'Показывать немасштибируемую картинку',
    58 => 'Управление статьёй',
    59 => 'Опция',
    60 => '',
    61 => 'Автоматическая архивация',
    62 => 'Автоматическое удаление',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Expand the Content Edit Area size',
    68 => 'Reduce the Content Edit Area size',
    69 => 'Publish Article Date',
    70 => 'Toolbar Selection',
    71 => 'Basic Toolbar',
    72 => 'Common Toolbar',
    73 => 'Advanced Toolbar',
    74 => 'Advanced II Toolbar',
    75 => 'Full Featured',
    76 => 'Publish Options',
    77 => 'Javascript needs to be enabled for Advanced Editor. Option can be disabled in the main site config.php',
    78 => 'Click <a href="%s/article.php?mode=edit&amp;sid=%s&amp;editopt=default">here</a> to use default editor',
    79 => 'Preview',
    80 => 'Editor',
    81 => 'Publish Options',
    82 => 'Images',
    83 => 'Archive Options',
    84 => 'Permissions',
    85 => 'Show All',
    86 => 'Advanced Editor',
    87 => 'Article Stats',
    88 => 'Wiki-style format',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.',
    92 => 'You might also like',
    93 => '#',
    94 => 'Resized',
    95 => 'Original',
    96 => 'Upload | Replace',
    97 => 'No Image',
    'autotag_desc_story' => '[article: id alternate title] - Displays a link to an article using the Article Title as the title. An alternate title may be specified but is not required.',
    'autotag_desc_article' => '[article: id alternate title] - Displays a link to an article using the Article Title as the title. An alternate title may be specified but is not required.',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This article will be cached for no longer than this many seconds. If 0 caching is disabled. If -1 cached until article is edited again. (3600 = 1 hour,  86400 = 1 day)'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Редактирование темы',
    2 => 'ID темы',
    3 => 'Наименование темы',
    4 => 'Картинка темы',
    5 => '(не использовать пробелы)',
    6 => 'Удаление темы приведёт к удалению всех связанных с ней статей и блоков',
    7 => 'Пожалуйста заполните поля ID темы и Наименование темы',
    8 => 'Менеджер тем',
    9 => 'Для изменения или удаления темы, выберите тему ниже.  Для создания новой нажмите на кнопку Создать тему.',
    10 => 'Порядок сортировки',
    11 => 'Статей на страницу',
    12 => 'Доступ закрыт',
    13 => "Вы пытались получить доступ к теме, на которую у Вас нет прав. Эта попытка была запротоколирована.  Пожалуйста, <a href=\"{$_CONF['site_admin_url']}/topic.php\">вернитесь на станицу администрирования тем</a>.",
    14 => 'Метод сортировки',
    15 => 'алфавитный',
    16 => 'по-умолчанию',
    17 => 'Новая тема',
    18 => 'Home администратора',
    19 => 'сохранить',
    20 => 'отменить',
    21 => 'стереть',
    22 => 'По умолчанию',
    23 => 'Сделать эту тему темо по умолчанию при добаслении новой статьи',
    24 => '(*)',
    25 => 'Тема архива',
    26 => 'сделать темой по умолчаниюдля архивированных статей - разрешена только одна тема.',
    27 => 'Or Upload Topic Icon',
    28 => 'Maximum',
    29 => 'File Upload Errors',
    30 => 'Articles in Topic',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'Parent Topic',
    33 => 'Inherit',
    34 => 'Items of child topic are inherited',
    35 => 'Hidden',
    36 => 'Topic will be hidden and cannot be viewed directly, only inherited',
    37 => 'Root',
    38 => 'All',
    39 => 'Homepage Only',
    40 => 'Assign one or more topics. ',
    41 => 'If "All" is selected then the item will appear for all topics. If "Homepage Only" is selected then item will appear just on the homepage. Else you must select at least one topic to assign the item to. ',
    'topic_control_select_topics' => 'Else you must select at least one topic to assign the item to. ',
    'topic_control_select_topics_disabled' => 'Else you must select at least one topic you have edit access for, to assign the item to (text is darker). ',
    'topic_control_no_topics' => 'Unfortunately you do not have edit access to any topics so none can be selected. ',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Inherit',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Yes',
    51 => 'No',
    52 => 'Article',
    53 => 'Image',
    54 => 'Selected',
    55 => 'Assigned',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home',
    'autotag_desc_topic' => '[topic: id alternate title] - Displays a link to a topic using the ID as the title. An alternate title may be specified but is not required.',
    'autotag_desc_related_topics' => '[related_topics:id type:plugin max:max_items_listed] - Creates a clickable horizontal list of related topics based on the item id and type.',
    'autotag_desc_related_items' => '[related_items:id type:plugin max:max_items_listed trim:max_length include:plugin] - Create a clickable list of related items based on the item id and type.',
    'no_related_items' => 'No related items found.',
    'topics:' => 'Topics:',
    'filed_under:' => 'Filed under:',
    'topic_title' => 'Topic Title',
    'topic_title_desc' => 'Used as the page title for the topic. If empty the topic name will be used.',
    'move_topic_up' => 'Move topic up the sort order',
    'move_topic_down' => 'Move topic down in the sort order',
    'topics_edit_access_select' => 'You can only select topics you have Edit access to you (text is darker).',
    'topics_edit_access_listed' => 'Only topics with Edit access are listed.'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Редактирование пользователя',
    2 => 'ID пользователя',
    3 => 'Имя пользователя',
    4 => 'Полное имя',
    5 => 'Пароль',
    6 => 'Уровень допуска',
    7 => 'Почтовый адрес',
    8 => 'Домашняя страница',
    9 => '(не использовать пробелы)',
    10 => 'Пожалуйста, заполните поля Имя пользователя, Полное имя, Уровень секретности и Почтовый адрес',
    11 => 'Менеджер пользователей',
    12 => 'Для изменения или удаления пользователя, выберите пользователя ниже.  Для создания нового нажмите на кнопку Создать пользователя.',
    13 => 'УрСекр',
    14 => 'Дата рег.',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'сохранить',
    21 => 'Такое имя пользователя уже существует.',
    22 => 'Ошибка',
    23 => 'Добавить группу',
    24 => 'Импортировать группу пользователей',
    25 => 'Вы можете импортировать группу пользователей.  Файл импорта должен быть tab-delimited текстовой файл и должен включать поля в следующем порядке: полное имя, ник, адрес почты.  Каждому импортированному пользователю будет выслан по почте пароль. В каждой линии файла может быть только один пользователь.  При несоблюдении этих инструкций, могут возникнуть проблемы, требующие ручного вмешательства, поэтому тщательно проверьте Ваш файл!',
    26 => '',
    27 => '',
    28 => 'Отметьте здесь, чтобы стереть изображение',
    29 => 'Путь',
    30 => 'Импортировать',
    31 => 'Новые пользователи',
    32 => 'Обработка завершена. Импортировано %d, произошло ошибок: %d',
    33 => 'отправить',
    34 => 'Ошибка: укажите файл, который Вы загружаете.',
    35 => 'Последний вход',
    36 => '(никогда)',
    37 => 'UID',
    38 => 'Group Listing',
    39 => 'Password (again)',
    40 => 'Registration Date',
    41 => 'Last login Date',
    42 => 'Banned',
    43 => 'Awaiting Activation',
    44 => 'Awaiting Authorization',
    45 => 'Active',
    46 => 'User Status',
    'user_status_desc' => "An explanation of all possible user statuses: <ul>\n\n        <li><strong>Awaiting Activation</strong> - New account awaiting user to login. Email has been sent but not verified. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>\n\n        <li><strong>Awaiting Authorization</strong> - New account awaiting moderator approval in the User Submission Queue. When User Submission approved, user will be sent email with password. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>\n\n        <li><strong>Active</strong> - This is an Active account.</li>\n\n        <li><strong>Banned</strong> -  This Account is banned/disabled. Username is crossed out on the site for any content they have submitted, User cannot login, emails to account is disabled, and profile cannot be viewed by any user except Admins.</li>\n\n        <li><strong>Locked</strong> - This Account is locked. User cannot login, emails to account is disabled, but profile can still be viewed by all.</li>\n\n        <li><strong>New Email Required</strong> - Emails to account is disabled. When user logs in again they must submit new email address and verify before access to rest of the website (under this user account). Status stays the same until email is verified. If \"Require User Email\" config option true then any users who login (includes remote accounts) that do not have an email address will automatically switch to this status.</li>\n\n        <li><strong>New Password Required</strong> -  When the user logs in they must submit a new password before access to rest of website (under this user account). This is only for regular accounts and not remote accounts.</li>\n\n        </ul>\n\n    ",
    47 => 'Edit',
    48 => 'Show Admin Groups',
    49 => 'Admin Group',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Note: "Online Days" is the number of days between the first registration and the last login.',
    53 => 'registered',
    54 => 'Batch Delete',
    55 => 'This only works if you have <code>$_CONF[\'lastlogin\'] = true;</code> in your config.php',
    56 => 'Please choose the type of user you want to delete and press "Update List". Then, uncheck those from the list you do not want to delete and press "Delete". Please note that you will only delete those that are currently visible in case the list spans over several pages.',
    57 => 'Phantom users',
    58 => 'Short-Time Users',
    59 => 'Old Users',
    60 => 'Users that registered more than ',
    61 => ' months ago, but never logged in.',
    62 => 'Users that registered more than ',
    63 => ' months ago, then logged in within 24 hours, but since then never came back to your site.',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => ' months.',
    66 => 'Update List',
    67 => 'Months since registration',
    68 => 'Online Hours',
    69 => 'Offline Months',
    70 => 'could not be deleted',
    71 => 'sucessfully deleted',
    72 => 'No User selected for deletion',
    73 => 'Are You sure you want to permanently delete ALL selected users?',
    74 => 'Recent Users',
    75 => 'Users that registered in the last ',
    76 => ' months',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts',
    91 => 'Send password to user',
    92 => 'Only for new users or when changing password for existing user.',
    'convert_remote' => 'Check here to convert from remote to a local account',
    'convert_remote_desc' => 'When a remote account is converted to a local account, a password will be automatically generated. If the account does not have a confirmed email address, the account will be locked after it is converted since the user will have no way of retrieving the password. Once converted and if the account is active and has an email address the user will be emailed the password or they can request the password by using the forget password link from the Login page. For user accounts that do not have an active status and valid email you will have to manually notify the user of the account change and how to login.',
    'contributed' => 'Contributed',
    'na' => 'NA',
    'nothing' => 'Nothing',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.',
    'USER_ACCOUNT_LOCKED' => 'Locked',
    'USER_ACCOUNT_NEW_EMAIL' => 'New Email Required',
    'USER_ACCOUNT_NEW_PASSWORD' => 'New Password Required'
);

###############################################################################
# admin/moderation.php
# admin/index.php

$LANG29 = array(
    1 => 'Одобрить',
    2 => 'Удалить',
    3 => 'Изменить',
    4 => 'Профиль',
    10 => 'Заголовок',
    11 => 'Старт',
    12 => 'URL',
    13 => 'Категория',
    14 => 'Датиа',
    15 => 'Тема',
    16 => 'Имя пользователя',
    17 => 'Полное имя',
    18 => 'Email',
    34 => 'Команды управления',
    35 => 'Статии на одобрение',
    36 => 'Parent or Comment',
    37 => 'Author',
    38 => 'Отправить',
    39 => 'В данный момент модерировать нечего',
    40 => 'Отправлено пользователями',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?',
    44 => 'Results of your moderation',
    45 => 'Approved %1$d items and deleted %2$d items of user submissions.',
    46 => 'User Profile Updated',
    'core' => 'Core',
    'plugins' => 'Plugins',
    'tools' => 'Tools',
    'users' => 'Users',
    'submissions_desc' => 'To modify or delete a user submssion, click on that item\'s edit icon below. To approve and delete multiple submissions use the radio options in the lists and then click submit.',
    'max_invalid_login' => 'Max Invalid Logins Reached for User',
    'max_invalid_login_msg' => 'This user has reached the maximum number of invalid login attempts () within the specified time limit ( seconds). The last IP to make an invalid login attempt is %s. Either the real user has forgotten the password for their account, or someone else is attempting to guess the password for this user account.'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => 'Почта',
    2 => 'От',
    3 => 'Отвечать на',
    4 => 'Тема',
    5 => 'Тело',
    6 => 'Адресат:',
    7 => 'Все пользователи',
    8 => 'Администратор',
    9 => 'Параметры',
    10 => 'HTML',
    11 => 'Срочное сообщение!',
    12 => 'Послать',
    13 => 'Сброс',
    14 => 'Игнорировать установки пользователя',
    15 => 'Ошибка при отправке на: ',
    16 => 'Сообщение успешно отправлено на: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Послать ещё сообщение</a>",
    18 => 'Кому',
    19 => 'Внимание: если хотите отправить сообщение всем участникам сайта, выберите группу Logged-in.',
    20 => "Успешно отправлено <successcount> сообщений и не отправлено <failcount> сообщений.  К Вашему сведению, детали о попытках отправления каждого сообщения приведены ниже.  Вы можете также <a href=\"{$_CONF['site_admin_url']}/mail.php\">отправить новое сообщение</a> или <a href=\"{$_CONF['site_admin_url']}/moderation.php\">вернуться на страницу администрирования</a>.",
    21 => 'Неудачи',
    22 => 'Удачи',
    23 => 'Неудач нет',
    24 => 'Удач нет',
    25 => '-- Выбрать группу --',
    26 => 'Пожалуйста, заполните все поля формы и выберите группу пользователей из списка.',
    27 => 'The following template variables are available in <strong>Subject</strong> and <strong>Message</strong>: {uid}, {username}, {fullname}, {email}, {homepage}, {theme}, {language}, {location}, {lastgranted}, {lastlogin}, {site_url}, {site_name}, {site_slogan}, {owner_name}, {copyrightyear}, {site_mail}, {noreply_mail}',
    'email_divider' => '------------------------------------------------------------',
    'email_divider_html' => '<hr' . XHTML . '>',
    'sig_divider' => '---',
    'sig_divider_html' => '---<br' . XHTML . '>',
    'email_footer_msg_noreply' => 'The address used to send this email is not monitored. Please do not reply to this email.',
    'email_footer_msg_content' => 'If content from the website is displayed in this email, there may be layout changes which result in formatting issues.',
    'ip_address_email' => 'IP address that initiated email:'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Установка плагина может повредить установленному у Вас Geeklog-у или даже Вашей системе.  Важно, что бы Вы устанавливали только плагины, скачанные с <a href="https://WWW.geeklog.net" target="_blank">Geeklog Homepage</a> т.к. мы тестируем все присланные нам плагины на различных операционных системах. Важно, что бы Вы понимали, что установка плагина требует исполнения некоторых системных команд, которые могут вызвать проблемы с безопастностью, особенно это касается плагинов, скачаных не с нашего сайта.  Даже после этого предупреждения мы не можем гарантировать успешность инсталяции и не несём ответственности за проблемы, вызванные установкой Geeklog-плагина. Иначе говоря, Вы устанавливаете плагин на свой собственный риск. Руководство по ручной установке плагина включено в каждый инсталляционный пакет.',
    2 => 'Предупреждение о установке плагинов',
    3 => 'Форма установки плагина',
    4 => 'Файл плагина',
    5 => 'Список плагинов',
    6 => 'Предупреждение: Плагин уже установлен!',
    7 => 'Плагин, который Вы пытаетесь установить, уже существует. Перед тем, как переустановить плагин, удалите его.',
    8 => 'Проверка совместимости плагина провалилась',
    9 => 'Плагин требует более новой версии Geeklog-а. Обновите Вашу копию с <a href="https://www.geeklog.net">Geeklog</a> или попробуйте найти другую версию плагина.',
    10 => '<br' . XHTML . '><b>В системе нет установленных плагинов.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Для изменения или удаления плагина, нажмите на его номер ниже. Для получения информации о плагине, нажмите на его имя, и вы будете направлены вебсайт плагина. Для установки или обновления плагина нажмите кнопку "Новый плагин" выше.',
    12 => 'имя плагина не передано в plugineditor()',
    13 => 'Редактор плагинов',
    14 => 'Новый плагин',
    'installed_plugins' => 'Installed Plugins',
    15 => 'Home администратора',
    16 => 'Наименование плагина',
    17 => 'Версия плагина',
    18 => 'Версия Geeklog',
    19 => 'Разрешено',
    20 => 'Да',
    21 => 'Нет',
    22 => 'Установить',
    23 => 'Сохранить',
    24 => 'Отмена',
    25 => 'Удалить',
    26 => 'Наименование плагина',
    27 => 'Homepage плагина',
    28 => 'Версия плагина',
    29 => 'Версия Geeklog',
    30 => 'Удалить плагин?',
    31 => 'Вы уверены, что хотите удалить этот плагин? Продолжив, Вы удалите все файлы и данные, которые данный плагин использовал.  Если Вы уверены, нажмите кнопку "Удалить" ниже.',
    32 => '<p><b>Ошибка: неверный формат тега AutoLink</b></p>',
    33 => 'Версия кода',
    34 => 'Обновить',
    35 => 'Edit',
    36 => 'Code',
    37 => 'Data',
    38 => 'Update!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    43 => 'Load Order',
    44 => 'Move plugin up the load order',
    45 => 'Move plugin down the load order',
    46 => 'Click to Delete this Plugin',
    47 => 'Really Delete %s Plugin?',
    48 => 'Click to Enable this Plugin',
    49 => 'Click to Disable this Plugin',
    50 => 'Dependencies',
    51 => 'OK',
    52 => 'Unresolved',
    53 => 'Disabled',
    54 => 'Unavailable',
    55 => 'Uninstalled',
    56 => 'Wrong Version',
    57 => 'Unknown',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Close',
    61 => 'Status',
    62 => 'Click to Install this Plugin',
    63 => 'This Plugin Cannot be Installed',
    64 => 'This Plugin Cannot be Enabled',
    65 => 'The plugin upload function has been disabled due to the following errors:',
    66 => 'File uploads are disabled in your PHP configuration.',
    67 => 'The directory "%s" is not writable.',
    68 => 'You do not have the required permissions to install plugins.',
    69 => 'You do not have the required permissions to upload plugins.',
    'delete' => 'Delete',
    'delete_plugin' => 'Delete Plugin and all of its files?',
    'click_to_delete_msg' => 'Click to Delete this Plugin files',
    'really_delete_msg' => 'Really Delete %s Plugin files?',
    99 => 'An unknown error occurred',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'создать синопсис',
    2 => 'сохранить',
    3 => 'удалить',
    4 => 'отменить',
    10 => 'Синдикация контента',
    11 => 'Новый синопсис',
    12 => 'Домой к администратору',
    13 => 'Чтобы удалить или исправить настрйоки синопсиса, нажмите на его название. Чтобы создать новый синопсис, нажмите на соответствующую ссылку выше.',
    14 => 'Заголовок',
    15 => 'Тип',
    16 => 'Имя файла',
    17 => 'Формат',
    18 => 'последнее обновление',
    19 => 'Включен',
    20 => 'Да',
    21 => 'Нет',
    22 => '<i>(нет синопсисов)</i>',
    23 => 'все статьи',
    24 => 'Редактор синопсисов',
    25 => 'Заголовок синопсиса',
    26 => 'Предел',
    27 => 'Количество записей',
    28 => '(0 = текст не включать, 1 = весь текст, прочее = ограничить указанным числом символов.)',
    29 => 'Описание',
    30 => 'Последнее обновление',
    31 => 'Кодировка',
    32 => 'Язык',
    33 => 'Содержимое',
    34 => 'Записи',
    35 => 'Часы',
    36 => 'Выберите тип синопсиса',
    37 => '',
    38 => 'Ошибка: не все необходимые поля заполнены',
    39 => 'Укажите заголовок, описание и имя файла.',
    40 => 'Укажите либо количество записей, либо количество часов.',
    41 => 'Ссылки',
    42 => '',
    43 => 'All',
    44 => 'None',
    45 => 'Header-link in topic',
    46 => 'Limit Results',
    47 => 'Search',
    48 => 'Edit',
    49 => 'Feed Logo',
    50 => "Relative to site url ({$_CONF['site_url']})",
    51 => 'The filename you have chosen is already used by another feed. Please choose a different one.',
    52 => 'Error: existing Filename',
    53 => 'All Frontpage Articles',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles',
    'num_articles' => '%s Article(s)'
);

###############################################################################
# admin/language.php (since v2.1.2)

$LANG_LANG = array(
    'language_admin_title' => 'Language Overrides',
    'language_manager' => 'Language Manager',
    'new_language_msg' => 'To modify or delete a language item, click on that item\'s edit icon below. To create a new item, click on "Create New" above.',
    'language_editor' => 'Language Editor',
    'id' => 'ID',
    'language' => 'Language',
    'name' => 'Name',
    'var_name' => 'Var Name',
    'name_tip' => 'Required just for language arrays.',
    'var_name_tip' => 'Can be a regular variable or array. Do not include the dollar sign at the beginning of the variable/array name.',
    'value' => 'Value'
);

###############################################################################
# admin/router.php

$LANG_ROUTER = array(
    1 => 'URL routing',
    2 => 'Routing Manager',
    3 => 'ID',
    4 => 'method',
    5 => 'rule',
    6 => 'route',
    7 => 'priority',
    8 => 'Increase priority',
    9 => 'Decrease priority',
    10 => 'Edit routing',
    11 => 'To modify or delete a route, click on the route\'s edit icon below. To create a new route, click on "Create New" above.  When you use placeholders (@), you must define the same placeholders in a rule and its route.',
    12 => 'Bad request method',
    13 => 'Rule is a mandatory item.',
    14 => 'Route is a mandatory item.',
    15 => 'Placeholders (@) in a rule and those in a route must be the same.',
    16 => 'Route must not start with "/index.php/".',
    17 => 'Database error occurred.',
    18 => '<strong>To enable URL routing, you have to enable URL rewrite in the Configuration.</strong>',
    19 => '<strong>To enable URL routing, you have to enable URL routing in the Configuration.</strong>',
    20 => '<ul><li>Placeholders (@) must be the same both in a rule and its route.</li><li>A placeholder starts with "@", followed by an alphabet, optionally followed by any length of alphabet or digit.</li><li>Placeholders are case-sensitive.</li></ul>',
    21 => 'Status Code',
    22 => 'Enabled',
    23 => 'Yes',
    24 => 'No'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Ваш пароль был отправлен Вам по электронной почте. Пожалуйста, следуйте указаниям в полученном сообщении. Благодарим за использование {$_CONF['site_name']}",
    2 => "Спасибо за добавление статьи на {$_CONF['site_name']}.  Она была принята на рассмотрение. Если разрешение будет получено, Вашу статью смогут прочитать другие пользователи нашего сайта.",
    3 => '',
    4 => '',
    5 => 'Информация о Вашей учётной записи была успешно сохранена.',
    6 => 'Ваши настройки изображения были успешно сохранены.',
    7 => 'Ваши параметры комментариев были успешно сохранены.',
    8 => 'Вы успешно вышли из системы.',
    9 => 'Статья была успешно сохранена.',
    10 => 'Статья была успешно удалена.',
    11 => 'Ваш блок был успешно сохранён.',
    12 => 'Ваш блок был успешно удалён.',
    13 => 'Тема была успешно сохранена.',
    14 => 'Тема и все относящиеся к ней статьи и блоки были успешно удалены.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => 'Your user account has been locked and access to it has been disabled. For more information please contact the Admin.',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Новый пользователь был успешно зарегестрирован.',
    22 => 'Пользователь был успешно удалён',
    23 => 'Your passwords must match, please try again. Passwords are case sensitive.',
    24 => 'Your emails must match, please try again.',
    25 => 'You have not entered a valid email address, please try again.',
    26 => 'That email address is already being used by an account, please try again.',
    27 => 'Сообщение успешно отправлено.',
    28 => 'Плагин успешно сохранён',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Доступ закрыт',
    31 => 'Sorry, This feature is not supported by the  database server this website is using.  Please note that all attempts to access unsupported features are logged.',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Системное сообщение',
    41 => '',
    42 => '',
    43 => 'Account does not exist.',
    44 => 'Плагин успешно установлен!',
    45 => 'Плагин успешно удалён.',
    46 => 'Your username or email address was not found, please try again.',
    47 => 'Sorry you cannot currently request the password for your account. For more information please contact the Admin.',
    48 => "Спасибо за подачу заявления на членство в ' . {$_CONF['site_name']} . '. Мы рассмотрим Ваше заявление. Как только Вы приняты, Ваш пароль будет выслан Вам на указанный Вами адрес.",
    49 => 'Ваша группа успешно сохранена.',
    50 => 'Ваша группа успешно стерта.',
    51 => 'Это имя пользователя уже используется. Пожалуйста, выберите другое.',
    52 => 'Почтовый адрес, который Вы указали, не соотвествует правилам для валидных почтовых адресов.',
    53 => 'Ваш новый пароль принят. Пожалуйста, используйте Ваш новый пароль ниже для входа прямо сейчас.',
    54 => 'Время Вашего запроса на новый пароль истекло. Пожалуйста, попробуйте ещё раз ниже.',
    55 => 'Постовое сообщение было Вам отправлено и должно прийти моментально. Пожалуйста, следуйте указаниям в сообщении для указания нового пароля для Вашего аккаунта.',
    56 => 'Почтоый адрес, который Вы указали, уже используется в другом аккаунте.',
    57 => 'Ваш аккаунт был успешно удалён.',
    58 => 'Синопсис успешно сохранён.',
    59 => 'Синопсис успешно удалён.',
    60 => 'Модуль успешно обновлён',
    61 => 'Модуль %s: неизвестное хранилище сообщений',
    62 => 'Комментарий trackback успешно удалён.',
    63 => 'Произошла ошибка при попытке удаления комментария trackback.',
    64 => 'Ваш комментарий trackback успешно отослан.',
    65 => 'Каталог Weblog сервиса успешно сохранён.',
    66 => 'Каталог weblog сервиса был удалён.',
    67 => 'Новый пароль не соответствует паролю в поле подтверждения!',
    68 => 'Вы должны ввести правильный текущий пароль.',
    69 => 'Ваш аккаунт заблокирован!',
    70 => 'Ваш аккаунт ожидает проверки Администратором.',
    71 => 'Ваш аккаунт подтверждён, но ожидает проверки Администратором.',
    72 => 'При попытке инсталляции плагина произошла ошибка. Смотрите error.log - там все подробности.',
    73 => 'При попытке деинсталляции плагина произошла ошибка. Смотрите error.log - там все подробности.',
    74 => 'Pingback был успешно отправлен.',
    75 => 'Trackbacks должен быть отправлен, используя запрос POST.',
    76 => 'Вы действительно хотите удалить этот пункт?',
    77 => 'ВНИМАНИЕ:<br' . XHTML . '>Вы должны установить кодировкой по умолчанию UTF-8. Тем не менее, Ваш сервер не поддерживает мультибайтовые кодировки. Пожалуйста, установите функции mbstring для PHP или выберите другую раскладку/язык.',
    78 => 'Пожалуйста, проверьте, чтобы email адрес и адрес подтверждения email совпадали.',
    79 => 'Страница, которую Вы пытаетесь открыть, обращается к функции, которой больше нет на сайте.',
    80 => 'Плагин, который создал этот механизм, отключен. Вы не сможете редактировать этот механизм, пока не включите родительский плагин.',
    81 => 'Вы неправильно набрали на клавиатуре логин. Пожалуйста, попробуйте войти позже.',
    82 => 'Вы превысили количество разрешенных попыток входа. Пожалуйста, попробуйте позже.',
    83 => 'Чтобы изменить свой пароль, email адрес, или срок, в течение которого система будет помнить Вас, введите свой текущий пароль.',
    84 => 'Чтобы удалить свой аккаунт, пожалуйста, введите свой текущий пароль.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit articles.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    116 => 'Loading...',
    117 => 'Help page is not found.',
    118 => 'Click to select a date',
    119 => 'More..',
    120 => 'Send this?',
    121 => 'Saved a URL routing item.',
    122 => 'Could not save a URL routing item.',
    123 => 'Deleted a URL routing item.',
    130 => 'Your language item has been successfully deleted.',
    131 => 'Your language item has been successfully saved.',
    140 => 'Deleted comment(s).',
    141 => 'Failed to delete a comment.',
    142 => 'Approved comment(s).',
    143 => 'Banned user(s).',
    144 => 'Banned IP addresses with the Spamx plugin.',
    145 => 'Banned IP addresses with the Ban plugin.',
    150 => 'Successfully deleted all the files and directories used during the installation.',
    151 => 'Failed to delete some files and directories used during the installation.  Please remove them manually.',
    152 => 'All the files and directories used during the installation are left as they are.  It is dangerous to keep them on the server, so please don\'t forget to remove them manually.',
    153 => 'You last emailed an article %1$d seconds ago.  This site requires at least %2$d seconds between emailing articles.',
    160 => 'The plugin files was successfully deleted.',
    161 => 'The archive includes a file whose name includes an unsafe character.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname',
    500 => 'The Template Cache has been successfully cleared.',
    501 => 'A verification message has been sent to your email address. Please click on the link in the email to confirm your email address and update your account. If you log into your account again before you verify your email address you will be asked again for a email address.<br' . XHTML . '><br' . XHTML . '>Please note you have now been successfully logged out so you can complete this verification.',
    502 => 'Your request for a new email has expired. Please try again below.',
    503 => 'Your email has been successfully verified.',
    504 => 'Passwords must have a minimum of 8 characters and contain at least 1 number and 1 letter. Passwords are case sensitive.',
    505 => "Warning - The current theme {$_CONF['theme']} v{$_CONF['theme_gl_version']} is not 100% compatible with this version of Geeklog (v2.2.1) and you will have issues using this site. The required minimum theme Geeklog version is v{$_CONF['min_theme_gl_version']}.",
    506 => "Warning - The current theme {$_CONF['theme']} (version not known) is not 100% compatible with this version of Geeklog (v2.2.1) and you will have issues using this site. The required minimum theme Geeklog version is v{$_CONF['min_theme_gl_version']}."
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Доступ',
    'ownerroot' => 'Владелец/Root',
    'group' => 'Группа',
    'readonly' => 'Только чтение',
    'accessrights' => 'Права доступа',
    'owner' => 'Владелец',
    'grantgrouplabel' => 'Дать права на редактирование упомянутой группы',
    'permmsg' => 'Замечание: Пользователи - все вошедшие в систему зарегистрированные пользователи, анонимные пользователи - все посетители сайта, не вошедшие в систему.',
    'securitygroups' => 'Группы безопасности',
    'editrootmsg' => "Даже если Вы Администратор Пользователей, Вы не можете изменить корневого пользователя если сами им не являетесь. Вы можете изменять любых пользователей, кроме корневого. Все попытки нелегально изменить корневых пользователей протоколируются. Пожалуйста, вернитесь на страницу <a href=\"{$_CONF['site_admin_url']}/user.php\">Администрирование Пользователей</a>.",
    'securitygroupsmsg' => 'Выберите группы, к которым должен принадлежать пользователь.',
    'groupeditor' => 'Редактор групп',
    'description' => 'Описание',
    'name' => 'Имя',
    'rights' => 'Права',
    'missingfields' => 'Пропущенные поля',
    'missingfieldsmsg' => 'Вы должны заполнить наименование и описание группы',
    'groupmanager' => 'Менеджер групп',
    'newgroupmsg' => 'Для изменения или удаления группы, нажмите на группу ниже. Для создания новой группы нажмите "Новая группа" выше. Просим заметить, что удаление базовых групп невозможно, т.к. они используются в системе.',
    'groupname' => 'Имя группы',
    'coregroup' => 'Базовая группа',
    'yes' => 'Да',
    'no' => 'Нет',
    'corerightsdescr' => 'Эта группа является базовой. Поэтому права для этой группы не редактируемы. Ниже перечислены права, которые данная группа имеет.',
    'groupmsg' => 'Структура Групп Безопастности является иерархической. Включая данную группу в другую, Вы даёте данной группе теже права, что имеет эта группа.  Это позволяет Вам использовать группы, перечисленные ниже, для назначения прав группе. Если Вы хотите назначить этой группе произвольные права, то Вы можете выбрать права к отдельным функциям данного сайта в разделе "Права" указанном ниже. Что бы добавить группу к любой из перечисленных ниже, просто проставте галочки напротив нужных групп.',
    'coregroupmsg' => 'Эта группа является базовой. Поэтому группы, к которым эта группа относится не поддаются изменению. Ниже перечислены группы, к которым данная группа относится.',
    'rightsdescr' => 'Групповые права могут быть назначены назначены напрямую группе ИЛИ другой группе, к которой принадлежит данная. Те права, которые не имеют чекбоксов рядом, являются правами, доставшимися группе по наследству от групп к которым она принадлежит. Права с чекбоксами рядом могут быть назначены этой группе напрямую.',
    'lock' => 'Блокировано',
    'members' => 'Пользователь',
    'anonymous' => 'Анонимный',
    'permissions' => 'Права',
    'permissionskey' => 'R = чтение, E = изменение, право изменить подразумевает право читать',
    'edit' => 'Изменить',
    'none' => 'Никаких',
    'accessdenied' => 'Доступ закрыт',
    'storydenialmsg' => "У Вас нет прав на просмотр этой статьи. Возможно, Вы просто не являетесь зарегистрированным пользователем {$_CONF['site_name']}.  Пожалуйста, <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">зарегистрируйтесь</a> на {$_CONF['site_name']} для получения пользовательского доступа!",
    'nogroupsforcoregroup' => 'Эта группа не принадлежит ниодной другой группе',
    'grouphasnorights' => 'Эта группа не имеет доступа ни к одной административной функции сайта.',
    'newgroup' => 'Новая группа',
    'adminhome' => 'Home администратора',
    'save' => 'сохранить',
    'cancel' => 'отмена',
    'delete' => 'удалить',
    'canteditroot' => 'Вы пытаетесь редактировать Корневую группу, но при этом не являетесь её членом поэтому доступ к этой группе закрыт. Пожалуйста, обратитесь к системному администратору, если считаете это ошибкой.',
    'listusers' => 'Список пользователей',
    'listthem' => 'список',
    'usersingroup' => 'Пользователей в группе %s',
    'usersingroupmsg' => 'A list of users that belong to the group. Users lists here may belong directly to the group or are inherited from another group that has been added to this group.',
    'usergroupadmin' => 'Администрирование групп пользователей',
    'add' => 'Добавить',
    'remove' => 'Удалить',
    'availmembers' => 'Доступные пользователи',
    'groupmembers' => 'Члены группы',
    'inheritmembers' => 'Inherited Group Members',
    'canteditgroup' => 'Чтобы править эту группу, вы должны быть в составе группы. Если вы считаете это ошибкой, уведомите системного администратора.',
    'cantlistgroup' => 'Чтобы увидеть состав группы, вы сами доложны быть в её составе. Если вы считаете это ошибкой, уведомите системного администратора.',
    'editgroupmsg' => 'To modify the group membership, click on the member names(s) and use the add or remove buttons. If the member is a member of the group, their name will appear on the right side only. Once you are complete - press <b>Save</b> to update the group and return to the main group admin page.',
    'listgroupmsg' => 'Listing of all current members in the group: <b>%s</b>',
    'search' => 'Поиск',
    'submit' => 'Принять',
    'limitresults' => 'Limit Results',
    'group_id' => 'Group ID',
    'plugin_access_denied_msg' => 'Вы пытаетесь нелегально получить доступ к странице администрирования. Учтите, что все подобные попытки протоколируются и Ваш провайдер также о них узнает.',
    'groupexists' => 'Такое имя группы уже есть',
    'groupexistsmsg' => 'Уже есть группа с таким именем. Имена групп должны быть уникальны.',
    'demo_mode_denied_msg' => 'This feature is currently disabled while the site is in Demo Mode.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'database_admin' => 'Database Administration',
    'last_ten_backups' => 'Последние 10 бэкапов',
    'site_db_backup' => "{$_CONF['site_name']} Database Backup",
    'create_backup' => 'Backup Database',
    'do_backup' => 'Сделать Бэкап',
    'backup_successful' => 'Резервное копирование базы данных успешно завершено.',
    'backup_error' => 'Error performing database backup.',
    'db_explanation' => 'Для создания новой резервной копии Вашей системы Geeklog, нажмите кнопку ниже',
    'backup_instructions' => 'To create a new backup of your site database, select the "Do Backup" button below. This will backup all current Geeklog tables. You can download a copy of the backup from the main Database Administration Screen.',
    'zero_size' => 'Неудачный бэкап: Размер файла 0 байт',
    'path_not_found' => "{$_CONF['backup_path']} не существует или не является директорией",
    'no_access' => "Ошибка: Директория {$_CONF['backup_path']} не доступна.",
    'backup_file' => 'Бэкап-файл',
    'size' => 'Размер',
    'bytes' => 'Байт',
    'total_number' => 'Общее количество бэкапов: %d',
    'download' => 'Click to download this file',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_myisam_menu' => 'Convert to MyISAM',
    'convert_myisam_title' => 'Convert to MyISAM tables',
    'convert_button' => 'Convert',
    'converting' => 'Converting',
    'no_innodb' => 'Your version of MySQL does not support InnoDB tables.',
    'no_myisam' => 'Your version of MySQL does not support MyISAM tables.',
    'innodb_instructions' => 'InnoDB tables can provide better performance on large databases. Please <a href="http://dev.mysql.com/doc/refman/5.7/en/converting-tables-to-innodb.html" target="_blank">read up</a> on the benefits and drawbacks of InnoDB tables before you perform a conversion.',
    'myisam_instructions' => 'MyISAM tables can provide better performance on smaller databases.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'already_converted_myisam' => 'It appears that all of the tables have already been converted to MyISAM.',
    'conversion_message' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'myisam_success' => 'Successfully converted tables to MyISAM.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimizing' => 'Optimizing',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_message' => 'Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.',
    'conversion_status' => 'Conversion Status',
    'optimization_status' => 'Optimization Status',
    'backup_status' => 'Backup Status',
    'backingup' => 'Performing Backup',
    'backup_title' => 'Backup the Geeklog Database',
    'backup_warning' => 'Note: The configuration is set to only backup database structures. No data will be backed up.',
    'latest_backup' => 'Latest Backup',
    'tables_to_backup' => 'Tables to Backup',
    'include' => 'Include',
    'exclude' => 'Exclude',
    'options' => 'Options',
    'struct_only' => 'Only Backup Table Structure (no data)',
    'max_files' => 'Maximum Backup Files to Keep',
    'disable_purge' => '("0" to disable purging.)',
    'use_gzip' => 'Use GZip if available',
    'configure' => 'Configure',
    'config_instructions' => 'Select any tables you wish to exclude from the backup. Other options can be found in the Geeklog Configuration under the Database tab.',
    'config_successful' => 'Tables to Backup list was saved successfully.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'В начало',
    2 => 'Обратная связь',
    3 => 'Опубликуйтесь',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Статистика сайта',
    8 => 'Персонализация',
    9 => 'Искать',
    10 => 'Расширенный поиск',
    11 => 'Каталог'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Ошибка',
    2 => 'Хмм, мы посмотрели везде, но не смогли найти <b>%s</b>.',
    3 => "<p>Нам очень жаль, но файл, который Вы запросили, не существует. Пожайлуйста, не стесняйтесь посмотреть <a href=\"{$_CONF['site_url']}\">главную страницу</a> или <a href=\"{$_CONF['site_url']}/search.php\">страницу поиска</a> чтобы определить, сможете ли Вы найти то, что потеряли :).",
    4 => "<p>We're sorry, but the page you have requested does not exist. We recommend going back to this <a href=\"%s\">related page</a>, or you may want to check the <a href=\"{$_CONF['site_url']}/\">home page</a>, or the <a href=\"{$_CONF['site_url']}/search.php\">search page</a> to see if you can find what you lost."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Требуется вход',
    2 => 'Извините, чтобы получить доступ к этой зоне вы должны зайти как зарегистрированный пользователь.',
    3 => 'Вход',
    4 => 'Новый пользователь'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'from',
    'tracked_on' => 'Tracked on',
    'read_more' => '[read more]',
    'intro_text' => 'Here\'s what others have to say about \'%s\':',
    'no_comments' => 'No trackback comments for this entry.',
    'this_trackback_url' => 'Trackback URL for this entry:',
    'num_comments' => '%d trackback comments',
    'send_trackback' => 'Send Pings',
    'preview' => 'Preview',
    'editor_title' => 'Send trackback comment',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'Entry URL',
    'entry_title' => 'Entry Title',
    'blog_name' => 'Site Name',
    'excerpt' => 'Excerpt',
    'truncate_warning' => 'Note: The receiving site may truncate your excerpt',
    'button_send' => 'Send',
    'button_preview' => 'Preview',
    'send_error' => 'Error',
    'send_error_details' => 'Error when sending trackback comment:',
    'url_missing' => 'No Entry URL',
    'url_required' => 'Please enter at least a URL for the entry.',
    'target_missing' => 'No Trackback URL',
    'target_required' => 'Please enter a trackback URL',
    'error_socket' => 'Could not open socket.',
    'error_response' => 'Response not understood.',
    'error_unspecified' => 'Unspecified error.',
    'select_url' => 'Select Trackback URL',
    'not_found' => 'Trackback URL not found',
    'autodetect_failed' => 'Geeklog could not detect the Trackback URL for the post you want to send your comment to. Please enter it manually below.',
    'trackback_explain' => 'From the links below, please select the URL you want to send your Trackback comment to. Geeklog will then try to determine the correct Trackback URL for that post. Or you can <a href="%s">enter it manually</a> if you know it already.',
    'no_links_trackback' => 'No links found. You can not send a Trackback comment for this entry.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback results',
    'send_pings' => 'Send Pings',
    'send_pings_for' => 'Send Pings for "%s"',
    'no_links_pingback' => 'No links found. No Pingbacks were sent for this entry.',
    'pingback_success' => 'Pingback sent.',
    'no_pingback_url' => 'No pingback URL found.',
    'resend' => 'Resend',
    'ping_all_explain' => 'You can now notify the sites you linked to (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), advertise that your site has been updated by pinging weblog directory services, or send a <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> comment in case you wrote about a post on someone else\'s site.',
    'pingback_button' => 'Send Pingback',
    'pingback_short' => 'Send Pingbacks to all sites linked from this entry.',
    'pingback_disabled' => '(Pingback disabled)',
    'ping_button' => 'Send Ping',
    'ping_short' => 'Ping weblog directory services.',
    'ping_disabled' => '(Ping disabled)',
    'trackback_button' => 'Send Trackback',
    'trackback_short' => 'Send a Trackback comment.',
    'trackback_disabled' => '(Trackback disabled)',
    'may_take_a_while' => 'Please note that sending Pingbacks and Pings may take a while.',
    'ping_results' => 'Ping results',
    'unknown_method' => 'Unknown ping method',
    'ping_success' => 'Ping sent.',
    'error_site_name' => 'Please enter the site\'s name.',
    'error_site_url' => 'Please enter the site\'s URL.',
    'error_ping_url' => 'Please enter a valid Ping URL.',
    'no_services' => 'No weblog directory services configured.',
    'services_headline' => 'Weblog Directory Services',
    'service_explain' => 'To modify or delete a weblog directory service, click on the edit icon of that service below. To add a new weblog directory service, click on "Create New" above.',
    'service' => 'Service',
    'ping_method' => 'Ping method',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(unknown method)',
    'edit_service' => 'Edit Weblog Directory Service',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Prepare your trackback comment for <a href="%s">%s</a>.',
    'editor_intro_none' => 'Prepare your trackback comment.',
    'trackback_note' => 'To send a trackback comment for an article, go to the list of articles and click on "Send Ping" for the article. To send a trackback that is not related to an article, <a href="%s">click here</a>.',
    'pingback_explain' => 'Enter a URL to send the Pingback to. The pingback will point to your site\'s homepage.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'URL этого сайта',
    'pingback_note' => 'Чтобы отправить pingback на историю, пройдите в список историй и кликните "Send Ping" для данной истории. Чтобы отправить pingback, не относящийся к истории, <a href="%s">нажмите сюда</a>.',
    'pbtarget_missing' => 'Нет Pingback URL',
    'pbtarget_required' => 'Пожалуйста, введите pingback URL',
    'pb_error_details' => 'Ошибка pingback:',
    'delete_trackback' => 'Чтобы удалить этот Trackback кликните: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Каталог статей',
    'title_year' => 'Каталог статей за %d',
    'title_month_year' => 'Каталог статей за %s %d',
    'nav_top' => 'Вернуться в каталог статей',
    'no_articles' => 'Нет статей.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# This here determines the order of the sentence "No new articles in 2 hrs"
# order it so it makes sense in your language:
# %i    item, "Articles"
# %n    amount, "2", "20" etc
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n новых %i за последние %t %s',
    'new_last' => 'за последние %t %s',
    'minutes' => 'минуты',
    'hours' => 'часов',
    'days' => 'дней',
    'weeks' => 'недели',
    'months' => 'месяца',
    'years' => 'years',
    'minute' => 'минута',
    'hour' => 'час',
    'day' => 'день',
    'week' => 'неделя',
    'month' => 'месяц',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Январь',
    2 => 'Февраль',
    3 => 'Март',
    4 => 'Апрель',
    5 => 'Май',
    6 => 'Июнь',
    7 => 'Июль',
    8 => 'Август',
    9 => 'Сентябрь',
    10 => 'Октябрь',
    11 => 'Ноябрь',
    12 => 'Декабрь'
);

###############################################################################
# Short Month names

$LANG_MONTH_SHORT = array(
    1 => 'Jan',
    2 => 'Feb',
    3 => 'Mar',
    4 => 'Apr',
    5 => 'May',
    6 => 'Jun',
    7 => 'Jul',
    8 => 'Aug',
    9 => 'Sep',
    10 => 'Oct',
    11 => 'Nov',
    12 => 'Decr'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Воскресенье',
    2 => 'Понедельник',
    3 => 'Вторник',
    4 => 'Среда',
    5 => 'Четверг',
    6 => 'Пятница',
    7 => 'Суббота'
);

###############################################################################
# Short Weekday Names

$LANG_WEEK_SHORT = array(
    1 => 'Sun',
    2 => 'Mon',
    3 => 'Tue',
    4 => 'Wed',
    5 => 'Thu',
    6 => 'Fri',
    7 => 'Sat'
);

###############################################################################
# AM/PM

$LANG_AMPM = array(
    'am_pm' => array('am' => 'am', 'pm' => 'pm'),
    'AM_PM' => array('am' => 'AM', 'pm' => 'PM')
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Поиск',
    'limit_results' => 'Limit Results',
    'submit' => 'Принять',
    'edit' => 'Редактировать',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Главная администрирования',
    'create_new' => 'Создать',
    'create_new_adv' => 'Создать (Adv.)',
    'enabled' => 'Включено',
    'disabled' => 'Disabled',
    'title' => 'Описание',
    'page_title' => 'Page Title',
    'type' => 'Тип',
    'topic' => 'Раздел',
    'info' => 'Info',
    'help_url' => 'Файл подсказки (URL)',
    'save' => 'Сохранить',
    'cancel' => 'Отмена',
    'install' => 'Install',
    'delete' => 'Удалить',
    'deleteitem' => 'Delete',
    'delete_sel' => 'Удалить выбранное',
    'copy' => 'Копировать',
    'no_results' => '- Не найдено записей -',
    'data_error' => 'Произошла ошибка обработки данных подписки. Пожалуйста, проверьте исходные данные.',
    'preview' => 'Предварит. просмотр',
    'records_found' => 'Найдено записей',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'token_expired_remote_user' => 'The security token for this operation has expired. Since you are a remote user you cannot re-authenticate, so you have lost your changes.',
    'token_re_authentication_error' => 'There was an error after your account was re-authenticated. It is unclear if the operation you were performing was executed or not.',
    'authenticate' => 'Authenticate',
    'approve' => 'Approve',
    'device' => 'Device',
    'device_desc' => 'For what device do you want this item to display for?',
    'for_all' => 'All',
    'for_mobile' => 'For Mobile',
    'for_computer' => 'For Computer',
    'all' => 'All',
    'mobile' => 'Mobile',
    'computer' => 'Computer',
    'edit_access_only' => 'Edit Access Only'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Комментарии разрешены',
    -1 => 'Комментарии запрещены',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Flat',
    'nested' => 'Nested',
    'threaded' => 'Threaded',
    'nocomment' => 'Нет комментариев'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 час',
    7200 => '2 часа',
    10800 => '3 часа',
    28800 => '8 часов',
    86400 => '1 день',
    604800 => '1 неделя',
    2678400 => '1 месяц'
);

$LANG_dateformats = array(
    0 => 'Как на сайте'
);

$LANG_featurecodes = array(
    0 => 'Обычная',
    1 => 'Особенная'
);

$LANG_frontpagecodes = array(
    0 => 'Показывать только в разделе',
    1 => 'Показывать на главной странице'
);

$LANG_postmodes = array(
    'plaintext' => 'Обычный текст',
    'html' => 'HTML форматирование'
);

$LANG_sortcodes = array(
    'ASC' => 'Сначала старые',
    'DESC' => 'Сначала новые'
);

$LANG_statuscodes = array(
    0 => 'Normal',
    1 => 'Refreshing',
    10 => 'Archive'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback включен',
    -1 => 'Trackback отключен'
);

$LANG_structureddatatypes = array(
    'none' => 'None',
    'core-webpage' => 'WebPage',
    'core-article' => 'Article',
    'core-newsarticle' => 'NewsArticle',
    'core-blogposting' => 'BlogPosting'
);

$LANG_STRUCT_DATA = array(
    'lang_structured_data_type' => 'Structured Data Type',
    'autotag_desc_structureddata' => '[structureddata:schema_property]Property Value[/structureddata] - Adds a property to the structured data of the content that the autotag is embedded in.'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Search Configuration',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'mail_charset' => 'Email Character Set',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'path_site_logo' => 'Site Logo',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_editors' => 'Advanced Editors',
    'mail_settings' => 'Mail Settings',
    'dbdump_filename_prefix' => 'Backup File Name Prefix',
    'dbdump_tables_only' => 'Only Backup Table Structure',
    'dbdump_gzip' => 'Use GZip if available',
    'dbdump_max_files' => 'Maximum Backup Files to Keep',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'cache_templates' => 'Cache Templates?',
    'cache_mobile' => 'Cache Mobile Devices Separately?',
    'cache_resource' => 'Combine, Minify and Cache CSS and JavaScript Files?',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'switchlang_homepage' => 'Switch Language Block Redirects to Homepage',
    'new_item_set_current_lang' => 'Add Current Language Id to New Item',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'require_user_email' => 'Require User Email',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'google_login' => 'Enable OAuth Login Method Google',
    'google_consumer_key' => 'Google OAuth Consumer Key',
    'google_consumer_secret' => 'Google OAuth Consumer Secret',
    'microsoft_login' => 'Enable OAuth Login Method Microsoft',
    'microsoft_consumer_key' => 'Microsoft OAuth Consumer Key',
    'microsoft_consumer_secret' => 'Microsoft OAuth Consumer Secret',
    'yahoo_login' => 'Enable OAuth Login Method Yahoo',
    'yahoo_consumer_key' => 'Yahoo OAuth Consumer Key',
    'yahoo_consumer_secret' => 'Yahoo OAuth Consumer Secret',
    'github_login' => 'Enable OAuth Login Method GitHub',
    'github_consumer_key' => 'GitHub OAuth Consumer Key',
    'github_consumer_secret' => 'GitHub OAuth Consumer Secret',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Article Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Article Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Articles?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'advanced_editor_name' => 'Advanced Editor Name?',
    'wikitext_editor' => 'Wikitext Editor?',
    'remove_4byte_chars' => 'Remove 4-byte utf-8 characters?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Article Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Articles',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Articles Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Articles',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'whatsnew_cache_time' => 'Max Cache Time',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Articles per Page',
    'minnews' => 'Min. Articles per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'structured_data_type_default' => 'Structured Data Type Default',
    'structured_data_article_topic' => 'Structured Data of Articles in Topics',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Article',
    'related_topics' => 'Related Topics',
    'related_topics_max' => 'Max Related Topics to Display',
    'whats_related' => 'What\'s Related',
    'whats_related_max' => 'Max What\'s Related to Display',
    'whats_related_trim' => 'What\'s Related Title Length',
    'default_cache_time_article' => 'Default Article Cache Time',
    'blocks_article_topic_list_repeat_after' => 'Article Topic List Blocks Location Repeat',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Article as Featured?',
    'template_comments' => 'Template Comments in Output?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Articles in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'generate_user_icon' => 'Generate User Icon automatically?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating',
    'gravatar_identicon' => 'Gravatar Identicon',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_order' => 'Comment Order',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'likes_enabled' => 'Likes Enabled',
    'likes_articles' => 'Article Likes',
    'likes_comments' => 'Comment Likes',
    'likes_speedlimit' => 'Likes Speed Limit',
    'likes_users_listed' => 'User Listed',
    'likes_block_cache_time' => 'Cache Time',
    'likes_block_include_time' => 'Include Time',
    'likes_block_max_items' => 'Max Items Listed',
    'likes_block_displayed_actions' => 'Displayed Actions',
    'likes_block_title_trim_length' => 'Title Trim Length',
    'likes_block_likes_new_line' => 'Likes on New Line',
    'likes_block_type' => 'Type',
    'likes_block_subtype' => 'Sub Type',
    'likes_block_enable' => 'Enabled',
    'likes_block_isleft' => 'Display Block on Left',
    'likes_block_order' => 'Block Order',
    'likes_block_topic_option' => 'Topic Options',
    'likes_block_topic' => 'Topic',
    'likes_block_group_id' => 'Group',
    'likes_block_permissions' => 'Permissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'invalidloginattempts' => 'Max. Invalid Login Attempts',
    'invalidloginmaxtime' => 'Invalid Login Max Time',
    'enable_twofactorauth' => 'Enable Two Factor Authentication?',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autotags?',
    'clickable_links' => 'Make URLs clickable?',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'page_navigation_mobile_max_pages' => 'Max Pages for Navigation with Mobile Devices',
    'default_cache_time_block' => 'Default Block Cache Time',
    'titletoid' => 'Enable Title To Id?',
    '404_log' => 'Log 404 Errors',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'url_routing' => 'Enable URL Routing',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Article Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Articles in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent articles enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order',
    'search_use_topic' => 'Use Current Topic',
    'autotag_permissions_story' => '[article: ] Permissions',
    'autotag_permissions_user' => '[user: ] Permissions',
    'autotag_permissions_topic' => '[topic: ] Permissions',
    'autotag_permissions_related_topics' => '[related_topics: ] Permissions',
    'autotag_permissions_related_items' => '[related_items: ] Permissions',
    'autotag_permissions_block' => '[block: ] Permissions',
    'autotag_permissions_structureddata' => '[structureddata: ] Permissions',
    'autotag_permissions_likes_block' => '[likes_block: ] Permissions',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?',
    'filemanager_disabled' => 'Disable Filemanager?',
    'filemanager_browse_only' => 'Browse only mode?',
    'filemanager_default_view_mode' => 'Default view mode',
    'filemanager_show_confirmation' => 'Show confirmation?',
    'filemanager_search_box' => 'Show search box?',
    'filemanager_file_sorting' => 'File sorting',
    'filemanager_chars_only_latin' => 'Allow only latin chars?',
    'filemanager_date_format' => 'Date time format',
    'filemanager_logger' => 'Enable logger?',
    'filemanager_show_thumbs' => 'Show thumbnails?',
    'filemanager_generate_thumbnails' => 'Generate thumbnails?',
    'filemanager_upload_overwrite' => 'Overwrite existing file?',
    'filemanager_upload_file_size_limit' => 'Upload file size limit (MiB)',
    'filemanager_images_ext' => 'Image file extensions',
    'filemanager_show_video_player' => 'Show video player?',
    'filemanager_videos_ext' => 'Video file extensions',
    'filemanager_videos_player_width' => 'Video player width (px)',
    'filemanager_videos_player_height' => 'Video player height (px)',
    'filemanager_show_audio_player' => 'Show audio player?',
    'filemanager_audios_ext' => 'Audio file extensions',
    'cookie_consent' => 'Enable Cookie Consent',
    'terms_of_use_link' => 'Terms of Use Link',
    'privacy_policy_link' => 'Privacy Policy Link',
    'about_cookies_link' => 'About Cookies Consent Link',
    'ip_anonymization' => 'IP Anonymization'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Articles and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous',
    'sg_filemanager' => 'Filemanager'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_database_backup' => 'Database Backup',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_multilanguage' => 'Multi-Language Content',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Article',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_likes' => 'Likes',
    'fs_likes_block_settings' => 'Block Settings',
    'fs_likes_block_permissions' => 'Block Permissions',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Article Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag Usage Permissions',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings',
    'fs_filemanager_general' => 'General Settings',
    'fs_filemanager_upload' => 'Upload',
    'fs_filemanager_images' => 'Images',
    'fs_filemanager_videos' => 'Videos',
    'fs_filemanager_audios' => 'Audios'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Paths',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_database' => 'Database',
    'tab_users' => 'Users',
    'tab_misc' => 'Miscellaneous',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin Block',
    'tab_locale' => 'Locale',
    'tab_language' => 'Language',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Login Settings',
    'tab_search' => 'Search',
    'tab_user_submission' => 'User Submission',
    'tab_submission' => 'Submission Settings',
    'tab_topics_block' => 'Topics Block',
    'tab_whosonline_block' => 'Who\'s Online Block',
    'tab_daily_digest' => 'Daily Digest',
    'tab_whatsnew_block' => 'What\'s New Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Article',
    'tab_theme_advanced' => 'Advanced Settings',
    'tab_syndication' => 'Syndication',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Images in Articles',
    'tab_topicicon' => 'Topic Icons',
    'tab_userphoto' => 'Photos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Comments',
    'tab_likes' => 'Likes',
    'tab_htmlfilter' => 'HTML Filtering',
    'tab_censoring' => 'Censoring',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Permissions',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics',
    'tab_filemanager_general' => 'General Settings',
    'tab_filemanager_upload' => 'Upload',
    'tab_filemanager_images' => 'Images',
    'tab_filemanager_videos' => 'Videos',
    'tab_filemanager_audios' => 'Audios'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html', 'Wiki-style Format' => 'wikitext'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'Login' => 'login', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Articles' => 'article', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user', 'User Updates' => 'user_update'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none'),
    31 => array('Newest First' => 'DESC', 'Oldest First' => 'ASC'),
    32 => array('Disabled' => 0, 'Just Article Pages' => 1, 'Articles and Topics' => 2),
    33 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (No Links)' => 2, 'Enabled (No Outbound Links)' => 3),
    34 => array('grid' => 'grid', 'list' => 'list'),
    35 => array('default' => 'default', 'Name (asc)' => 'NAME_ASC', 'Name (desc)' => 'NAME_DESC', 'Type (asc)' => 'TYPE_ASC', 'Type (desc)' => 'TYPE_DESC', 'Modified (asc)' => 'MODIFIED_ASC', 'Modified (desc)' => 'MODIFIED_DESC'),
    36 => array('False' => 'false', 'Frontpage only' => 'frontpage', 'Frontpage and Topics' => 'frontpage_topics'),
    37 => array('Disabled' => 0, 'Enabled (with "index.php")' => 1, 'Enabled (without "index.php")' => 2),
    38 => array('Mystery Man' => 'mm', 'Identicon' => 'identicon', 'MonsterId' => 'monsterid', 'WAvatar' => 'wavatar', 'Retro' => 'retro'),
    39 => array('None' => '', 'WebPage' => 'core-webpage', 'Article' => 'core-article', 'NewsArticle' => 'core-newsarticle', 'BlogPosting' => 'core-blogposting'),
    40 => array('False' => 0, 'Users and Anonymous' => 1, 'Users Only' => 2),
    41 => array('False' => 0, 'Likes and Dislikes' => 1, 'Likes Only' => 2),
    42 => array('None' => 0, 'Use individual Article Settings' => 1),
    43 => array('All' => 'all', 'Homepage Only' => 'homeonly', 'Select Topics' => 'selectedtopics'),
    44 => array('No access' => 0, 'Read-Only' => 2),
    46 => array('Likes and Dislikes' => 3, 'Likes Only' => 1, 'Dislikes Only' => 2)
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'alphaNumericOrEmpty' => 'This field must be alpha numeric or empty',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'fileName' => 'This field must be a proper file name',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP',
    'config_setting_lang_array' => 'Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value',
    'config_setting_lang_array_element_req' => 'Requires at least one element. Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value'
);

