/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.parser.IParserEventsProcessor;
import net.sourceforge.squirrel_sql.client.session.parser.ParserEventsListener;
import net.sourceforge.squirrel_sql.client.session.parser.SQLSchemaImpl;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParserThread;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParsingFinishedListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.TableAliasInfo;
import net.sourceforge.squirrel_sql.fw.util.BaseRuntimeException;

public class ParserEventsProcessor
implements IParserEventsProcessor {
    private Timer _parserTimer;
    private ParserThread _parserThread;
    private Vector<ParserEventsListener> _listeners = new Vector();
    private ISession _session;
    private ISQLPanelAPI _sqlPanelApi;
    private KeyAdapter _triggerParserKeyListener;
    private boolean _processingEnded;

    public ParserEventsProcessor(ISQLPanelAPI sqlPanelApi, ISession session) {
        this._session = session;
        this._sqlPanelApi = sqlPanelApi;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParserEventsProcessor.this.onTimerStart();
            }
        };
        this._triggerParserKeyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ParserEventsProcessor.this.onKeyTyped(e);
            }
        };
        this._parserTimer = new Timer(500, al);
        this._parserTimer.start();
    }

    private void onParserExitedOnException(final Throwable e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                throw new BaseRuntimeException(e);
            }
        });
    }

    @Override
    public void addParserEventsListener(ParserEventsListener l) {
        if (this._listeners != null && l != null) {
            this._listeners.add(l);
        }
    }

    @Override
    public void removeParserEventsListener(ParserEventsListener l) {
        if (this._listeners != null && l != null) {
            this._listeners.add(l);
        }
    }

    public void endProcessing() {
        this._processingEnded = true;
        this._sqlPanelApi.getSQLEntryPanel().getTextComponent().removeKeyListener(this._triggerParserKeyListener);
        if (this._parserTimer != null) {
            this._parserTimer.stop();
        }
        if (this._parserThread != null) {
            this._parserThread.exitThread();
        }
        this._session = null;
        this._sqlPanelApi = null;
        this._listeners = null;
    }

    @Override
    public void triggerParser() {
        this._parserTimer.restart();
    }

    private void onParsingFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParserEventsProcessor.this.fireParsingFinished();
            }
        });
    }

    private void fireParsingFinished() {
        if (this._processingEnded) {
            return;
        }
        ParserEventsListener[] clone = this._listeners.toArray(new ParserEventsListener[this._listeners.size()]);
        TableAliasInfo[] aliasInfos = this._parserThread.getTableAliasInfos();
        ErrorInfo[] errorInfos = this._parserThread.getErrorInfos();
        for (int i = 0; i < clone.length; ++i) {
            clone[i].aliasesFound(aliasInfos);
            clone[i].errorsFound(errorInfos);
        }
    }

    private void onTimerStart() {
        if (null == this._sqlPanelApi.getSQLEntryPanel() || null == this._session.getSchemaInfo() || !this._session.getSchemaInfo().isLoaded()) {
            return;
        }
        this.initParserThread();
        this._parserThread.notifyParser(this._sqlPanelApi.getSQLEntryPanel().getText());
    }

    private void initParserThread() {
        if (null != this._parserThread) {
            return;
        }
        this._parserThread = new ParserThread(new SQLSchemaImpl(this._session));
        this._sqlPanelApi.getSQLEntryPanel().getTextComponent().addKeyListener(this._triggerParserKeyListener);
        this._parserTimer.setRepeats(false);
        this._parserThread.setParsingFinishedListener(new ParsingFinishedListener(){

            @Override
            public void parsingFinished() {
                ParserEventsProcessor.this.onParsingFinished();
            }

            @Override
            public void parserExitedOnException(Throwable e) {
                ParserEventsProcessor.this.onParserExitedOnException(e);
            }
        });
    }

    private void onKeyTyped(KeyEvent e) {
        if (!e.isActionKey()) {
            this._parserTimer.restart();
        }
    }
}

