/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class KunststoffMenuUI
extends BasicMenuUI {
    public static ComponentUI createUI(JComponent c) {
        return new KunststoffMenuUI();
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Container parent = this.menuItem.getParent();
        if (c.isOpaque() && parent != null && parent instanceof JMenuBar) {
            ColorUIResource colorShadow;
            Point loc = c.getLocation();
            ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorReflection != null) {
                Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                Rectangle drawRect = new Rectangle(0, 0, parent.getWidth(), parent.getHeight() / 2);
                Rectangle gradRect = new Rectangle(0, -loc.y, parent.getWidth(), parent.getHeight() / 2);
                KunststoffUtilities.drawGradient(g, colorReflection, colorReflectionFaded, drawRect, gradRect, true);
            }
            if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                Rectangle drawRect = new Rectangle(0, parent.getHeight() / 2, parent.getWidth(), parent.getHeight() / 2);
                Rectangle gradRect = new Rectangle(0, parent.getHeight() / 2 - loc.y, parent.getWidth(), parent.getHeight() / 2);
                KunststoffUtilities.drawGradient(g, colorShadowFaded, colorShadow, drawRect, gradRect, true);
            }
        }
    }
}

