/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.prefs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PreferenceUtil;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.sqlscript.prefs.SQLScriptPreferenceBean;

public class SQLScriptPreferencesManager {
    private static final ILogger s_log = LoggerController.createLogger(SQLScriptPreferencesManager.class);
    private static final String USER_PREFS_FILE_NAME = "prefs.xml";
    private static FileWrapper _userSettingsFolder;
    private static SQLScriptPreferenceBean _prefs;
    private static IPlugin plugin;
    private static FileWrapperFactory fileWrapperFactory;

    public static void initialize(IPlugin thePlugin) throws PluginException {
        plugin = thePlugin;
        try {
            _userSettingsFolder = plugin.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        SQLScriptPreferencesManager.loadPrefs();
    }

    public static SQLScriptPreferenceBean getPreferences() {
        return _prefs;
    }

    public static void unload() {
        SQLScriptPreferencesManager.savePrefs();
    }

    public static void savePrefs() {
        try {
            XMLBeanWriter wtr = new XMLBeanWriter((Object)_prefs);
            wtr.save(fileWrapperFactory.create(_userSettingsFolder, USER_PREFS_FILE_NAME));
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occurred writing to preferences file: prefs.xml", (Throwable)ex);
        }
    }

    public static void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull((String)"setFileWrapperFactory", (Object[])new Object[]{"fileWrapperFactory", fileWrapperFactory});
        SQLScriptPreferencesManager.fileWrapperFactory = fileWrapperFactory;
    }

    private static void loadPrefs() {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            FileWrapper prefFile = PreferenceUtil.getPreferenceFileToReadFrom((IPlugin)plugin);
            doc.load(prefFile, SQLScriptPreferenceBean.class.getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                _prefs = (SQLScriptPreferenceBean)it.next();
            }
        }
        catch (FileNotFoundException ignore) {
            s_log.info((Object)"prefs.xml not found - will be created");
        }
        catch (Exception ex) {
            s_log.error((Object)"Error occurred reading from preferences file: prefs.xml", (Throwable)ex);
        }
        if (_prefs == null) {
            _prefs = new SQLScriptPreferenceBean();
        }
        _prefs.setClientName(Version.getApplicationName() + "/" + plugin.getDescriptiveName());
        _prefs.setClientVersion(Version.getShortVersion() + "/" + plugin.getVersion());
    }

    static {
        _prefs = null;
        plugin = null;
        fileWrapperFactory = new FileWrapperFactoryImpl();
    }
}

