/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ListIterator;
import net.sourceforge.napkinlaf.sketch.Template;
import net.sourceforge.napkinlaf.sketch.TemplateItem;
import net.sourceforge.napkinlaf.sketch.geometry.CubicLine;
import net.sourceforge.napkinlaf.sketch.geometry.Path;
import net.sourceforge.napkinlaf.sketch.geometry.Point;
import net.sourceforge.napkinlaf.sketch.geometry.QuadLine;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.StraightLine;

public abstract class AbstractSketcher {
    protected static void cleanSketch(TemplateItem item, Graphics2D g2d, Component c) {
        if (item.isDrawFill()) {
            g2d.setColor(item.getFillColor(c));
            g2d.fill(item.getShape());
        }
        if (item.isDrawStroke()) {
            g2d.setStroke(AbstractSketcher.getPen(item.getStrokeWeight()));
            g2d.setColor(item.getStrokeColor(c));
            g2d.draw(item.getShape());
        }
    }

    public static Stroke getPen(float weight) {
        return new BasicStroke(weight, 1, 1);
    }

    public void sketch(Template template, Graphics2D g2d, Component c) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ListIterator<TemplateItem> i = template.getListIterator();
        while (i.hasNext()) {
            TemplateItem current = (TemplateItem)i.next();
            current.setShape(current.getShape().deform(this));
            AbstractSketcher.cleanSketch(current, g2d, c);
        }
    }

    public abstract SketchShape deformLine(StraightLine var1);

    public abstract SketchShape deformQuad(QuadLine var1);

    public abstract SketchShape deformCubic(CubicLine var1);

    public abstract SketchShape deformPath(Path var1);

    protected static Path formPath(StraightLine[] lines) {
        Path ret = new Path();
        Point p = new Point(lines[0].getP1());
        ret.moveTo(p.floatX(), p.floatY());
        for (StraightLine line : lines) {
            p = new Point(line.getP2());
            ret.lineTo(p.floatX(), p.floatY());
        }
        return ret;
    }
}

