/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import javax.swing.SwingUtilities;

public abstract class GUIWorkerThread {
    private Object value;
    private ThreadVar threadVar;

    public GUIWorkerThread() {
        this.reset();
    }

    public abstract Object construct();

    public void finished() {
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    protected synchronized Object getValue() {
        return this.value;
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public void reset() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                GUIWorkerThread.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    GUIWorkerThread.this.setValue(GUIWorkerThread.this.construct());
                }
                finally {
                    GUIWorkerThread.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

