/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.xiph.speex.AudioFileWriter;

public class PcmWaveWriter
extends AudioFileWriter {
    private RandomAccessFile raf;
    private int channels;
    private int sampleRate;
    private int size = 0;

    public PcmWaveWriter() {
    }

    public PcmWaveWriter(int n, int n2) {
        this();
        this.setFormat(n, n2);
    }

    private void setFormat(int n, int n2) {
        this.channels = n;
        this.sampleRate = n2;
    }

    public void close() throws IOException {
        this.raf.seek(4L);
        int n = (int)this.raf.length() - 8;
        PcmWaveWriter.writeInt(this.raf, n);
        this.raf.seek(40L);
        PcmWaveWriter.writeInt(this.raf, this.size);
        this.raf.close();
    }

    public void open(String string) throws IOException {
        new File(string).delete();
        this.raf = new RandomAccessFile(string, "rw");
        this.size = 0;
    }

    public void writeHeader(String string) throws IOException {
        byte[] byArray = "RIFF".getBytes();
        this.raf.write(byArray, 0, byArray.length);
        PcmWaveWriter.writeInt(this.raf, 0);
        byArray = "WAVE".getBytes();
        this.raf.write(byArray, 0, byArray.length);
        byArray = "fmt ".getBytes();
        this.raf.write(byArray, 0, byArray.length);
        PcmWaveWriter.writeInt(this.raf, 16);
        short s = 16;
        PcmWaveWriter.writeShort(this.raf, (short)1);
        PcmWaveWriter.writeShort(this.raf, (short)this.channels);
        PcmWaveWriter.writeInt(this.raf, this.sampleRate);
        PcmWaveWriter.writeInt(this.raf, this.sampleRate * this.channels * (s / 8));
        PcmWaveWriter.writeShort(this.raf, (short)(this.channels * (s / 8)));
        PcmWaveWriter.writeShort(this.raf, s);
        byArray = "data".getBytes();
        this.raf.write(byArray, 0, byArray.length);
        PcmWaveWriter.writeInt(this.raf, 0);
    }

    public void writePacket(byte[] byArray, int n, int n2) throws IOException {
        this.raf.write(byArray, n, n2);
        this.size += n2;
    }
}

