/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class IntervalListWriter
implements Closeable {
    private static final char TAB = '\t';
    private final BufferedWriter out;

    public IntervalListWriter(Path path) {
        this(path, null);
    }

    public IntervalListWriter(Path path, SAMFileHeader header) {
        this.out = IOUtil.openFileForBufferedWriting(path, new OpenOption[0]);
        if (header != null) {
            SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
            codec.encode(this.out, header);
        }
    }

    public void write(Interval interval) throws IOException {
        this.out.write(interval.getContig());
        this.out.write(9);
        this.out.write(Integer.toString(interval.getStart()));
        this.out.write(9);
        this.out.write(Integer.toString(interval.getEnd()));
        this.out.write(9);
        this.out.write(interval.getStrand().encode());
        this.out.write(9);
        this.out.write(interval.getName() != null ? interval.getName() : ".");
        this.out.newLine();
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }
}

