.TH FBM 1 25-Jun-90
.CM 3
.SH NAME
fbm \- Fuzzy pixmap manipulation (Sun, GIF, IFF, TIFF, HAM, PCX, PBM, FBM, PostScript, rasters, bitmaps, pixmaps)
.SH SYNOPSIS
.nf
clr2gray  Convert color to grayscale
fbcat     Copy image (used for format conversion)
fbclean   Flip isolated pixels (clean image)
fbedge    Compute derivative image (edge detection)
fbext     Extract region, resize, change aspect ratio
fbgamma   Do gamma correction on grayscale, RGB, and mapped color images
fbhalf    Halftone grayscale image (Blue noise, Floyd-Steinberg, etc)
fbham     Convert 24 bit color to Amiga HAM mode
fbhist    Compute histogram
fbinfo    Dump image header
fbm2pod   Convert grayscale image to Diablo graphics (!)
fbm2tga   Convert FBM to Targa format
fbm2tiff  Convert FBM to 1, 2, 4, 8, or 24 bit TIFF format
fbmask    Set region to gray value
fbnorm    Normalize image intensity / increase contrast
fbpalet   Replace one colormap with another
fbps      Convert greyscale to PostScript
fbquant   Color quantization (24 bit to 4..256 colors) Mod. Heckbert
fbrot     Rotate 90, 180, or 270 degrees
fbsample  Sample a 1bit file to produce an 8bit file
fbsharp   Sharpen (edge enhancement) by digital Laplacian
gray2clr  Add a "gray" colormap to a grayscale image
idiff     (and udiff) convert raw byte stream into byte-by-byte difference
pbm2ps    Convert PBM file to PostScript
pbmtitle  Add a title to a PBM file
pic2fbm   Convert PIC format to FBM
qrt2fbm   Convert QRT raytracer output to FBM
raw2fbm   Convert raw file to FBM format (eg: Amiga Digiview files)
tga2fbm   Convert Targa format to FBM format
tiff2fbm  Convert 1, 2, 4, 8, or 24 bit TIFF format to FBM format
.fi
.SH DESCRIPTION
.PP
The Fuzzy Pixmap package (FBM) is a collection of routines for the
manipulation and conversion of images from and to a variety of file
formats.  
.SH FILE FORMATS
.PP
In general each routine can read any type of file format (file type is
determined by examining the magic numbers).  Files that are compressed
with the Lempel-Ziv 'compress' program are automatically uncompressed
where possible. With few exceptions the programs are filters, and
an image manipulation or conversion will be composed of a pipeline of
several FBM programs.
.sp
Output file format is specified by an upper case letter in the argument
list.  Each site has a separate default (defined in fbm.h) for 8bit and
1bit images.  The following upper
case letters are assigned (not all are handled, yet):
.sp
.TP
.BR -A
.I andrew toolkit
CMU specific format (not implemented, if at CMU, use 'bmcv' to convert).
.TP
.BR -B
.I face
format, as used by Bennet Yee's
.I face
program at CMU. His 'bmcv' program can convert to a number of useful
formats.
.TP
.BR -F
.I FBM
format (by default, the default).
.TP
.BR -G
.I GIF
Compuserve GIF format.  GIF support by David Koblas and David Rowley.
On input, the aspect ratio is guessed from the size (for example,
320x200 and 640x400 images are assumed to have an aspect ratio of 1.2).
For unknown sizes, an aspect ratio of 1.0 is assumed.  fbcat can
override the aspect ratio, if you know the actual value.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used mainly by Amigas (from ELArts).
To output HAM mode, create a 24 bit color image (using unmap) and use the
fbham(1) command to convert it to a 6 plane IFF ILBM HAM mode file.
.TP
.BR -J
.I JPEG
compressed images in JFIF format.
Uses the JPEG library released by the independent JPEG Group.
.TP
.BR -L
.I InterLeaf
bitmap format for inclusion in InterLeaf documents (not yet supported).
.TP
.BR -M
.I MacPaint
format (not yet supported, use -P and pipe through pbmtomacp).
.TP
.BR -P
.I PBM
Jef Poskanzer's bitmap format.  His pbm(1) package can convert this to
a number of useful formats.
.TP
.BR -R
.I Utah RLE
image format.  Included as a compile-time option, your site may or may
not have the RLE option enabled.
.TP
.BR -S
.I sun
rasterfiles.  Code does not require any Sun libraries to read or write
Sun format.
.TP
.BR -T
.I TIFF
format, as used by NeXT machines and many scanners.  Not implemented as
filters, but by the separate conversion programs tiff2fbm(1) and
fbm2tiff(1).
.TP
.BR -Z
.I ZSoft's PCX
format, as used on IBM PCs.
.PP
.SH OPTIONS
.PP
Some options are common, and an attempt has been made to keep the
letters the same throughout, although the same letter may mean
something else in some circumstances.
.TP
.BR -a
.I aspect ratio,
some rasters (like Amiga and IBM PC images) have pixels that are
"taller" than they are wide.  For example, a standard TV image is 4/3
wider than it is tall.  A "standard" screen that is 320 by 200 is
squashed so that it appears normal when displayed as though it were 320
by 240 (and 240 / 200 gives a 1.2 aspect ratio).
.sp
On some programs, like 
.I raw2fbm & fbcat,
the
.B -a
option specifies the aspect ratio of the input (for GIF and raw bitmaps
the default is 1.2).  Other programs (like
.I fbext)
use this parameter as the desired output ratio.
Finally, some programs assume specific ratios (usually 1, although
.fpm2pod
assumes 1.25 for output).
.TP
.BR -w, -h
.I width
and
.I height,
specifies the actual or desired width and height.
.TP
.BR -t'title'
.I title,
specify a character string (up to 80 characters) to describe the image.
The default is no title.
.TP
.BR -c'credits'
.I credits or subtitle,
specify a second character string (up to 80 characters) to describe the
image.  The default is no credit string.
.TP
.BR -s
.I size
or
.I sharpen
halftoning programs use
.B -s
to specifiy the amount of sharpening (0=none, values up to 5 look
reasonable, higher values can generate grainy images).  The extraction
program fbext(1) uses
.B -s
to mean the output size in total number of pixels.
.sp
That's what comes of using one letter argument names.
.PP
.SH SEE ALSO
clr2gray(1),
fbcat(1),
fbclean(1),
fbedge(1),
fbext(1),
fbgamma(1),
fbhalf(1),
fbham(1),
fbhist(1),
fbinfo(1),
fbm2pod(1),
fbm2tga(1),
fbm2tiff(1),
fbmask(1),
fbmedian(1),
fbnorm(1),
fbpalet(1),
fbps(1),
fbquant(1),
fbrot(1),
fbsample(1),
fbsharp(1),
gray2clr(1),
idiff(1),
pbm2ps(1),
pbmtitle(1),
raw2fbm(1),
tga2fbm(1),
tiff2fbm(1),
as well as pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989-1993 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
07-Apr-93  Michael L. Mauldin at Carnegie Mellon University
Release 1.2 mlm@cs.cmu.edu.
Includes JPEG input and output, plus more bug fixes.
To find more information about the JPEG library, contact:
.nf
	The Independent JPEG Group
	jpeg-info@uunet.uu.net
.fi
.TP
25-Jun-90  Michael L. Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu.
Includes Tiff output and numerous bug fixes.
.TP
20-May-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.94) mlm@cs.cmu.edu. User contributed software
includes
.nf
	C. Harald Koch	fbham
	Butler Hines	qrt2fbm
	Ian MacPhedran	tga2fbm, fbm2tga, pic2fbm
.fi
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
