/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.cram;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import org.apache.log4j.Logger;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ObjectCache;

public class IGVReferenceSource
implements CRAMReferenceSource {
    private static Logger log = Logger.getLogger(IGVReferenceSource.class);
    static ObjectCache<String, byte[]> cachedSequences = new ObjectCache(2);
    static GenomeChangeListener genomeChangeListener = new GenomeChangeListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getReferenceBases(SAMSequenceRecord record, boolean tryNameVariants) {
        String name = record.getSequenceName();
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        String chrName = currentGenome.getCanonicalChrName(name);
        Chromosome chromosome = currentGenome.getChromosome(chrName);
        byte[] bases = cachedSequences.get(chrName);
        if (bases == null) {
            try {
                if (bases == null) {
                    if (IGV.hasInstance()) {
                        IGV.getInstance().setStatusBarMessage("Loading sequence");
                    }
                    bases = currentGenome.getSequence(chrName, 0, chromosome.getLength(), false);
                    for (int i = 0; i < bases.length; ++i) {
                        if (bases[i] < 97) continue;
                        int n = i;
                        bases[n] = (byte)(bases[n] - 32);
                    }
                }
                cachedSequences.put(chrName, bases);
            }
            finally {
                if (IGV.hasInstance()) {
                    IGV.getInstance().setStatusBarMessage("");
                }
            }
        }
        return bases;
    }

    static {
        IGVEventBus.getInstance().subscribe(GenomeChangeEvent.class, genomeChangeListener);
    }

    public static class GenomeChangeListener
    implements IGVEventObserver {
        @Override
        public void receiveEvent(Object event) {
            cachedSequences.clear();
        }
    }
}

