/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;

public class IlluminaUtils {
    public static final String LOCUS_DELIMITER = "///";

    public static void main(String[] args) throws IOException {
        File annotFile = new File("/Users/jrobinso/IGV/ProbeAnnotations/illumina");
        File outputFile = new File("/Users/jrobinso/IGV/ProbeAnnotations/illumina_probe_gene_mapping.txt");
        IlluminaUtils.createProbeMappingFile(annotFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createProbeMappingFile(File inputDir, File outputFile) throws IOException {
        BufferedReader reader = null;
        PrintWriter pw = null;
        HashSet<String> processedProbes = new HashSet<String>(100000);
        try {
            int dupCount = 0;
            pw = new PrintWriter(outputFile);
            for (File inputFile : inputDir.listFiles()) {
                String nextLine;
                System.out.println(inputFile.getName());
                reader = new BufferedReader(new FileReader(inputFile));
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens = nextLine.split("\t");
                    boolean isMIArray = inputFile.getName().endsWith("MAP.txt");
                    int probeColumn = isMIArray ? 3 : 13;
                    int chrColumn = isMIArray ? 19 : 18;
                    int coordColumn = 20;
                    int probeSeqColumn = 4;
                    if (tokens.length <= coordColumn) continue;
                    int probeLength = tokens[probeSeqColumn].trim().length();
                    String probe = tokens[probeColumn].trim();
                    if (processedProbes.contains(probe)) {
                        ++dupCount;
                        continue;
                    }
                    processedProbes.add(probe);
                    String chr = "chr" + tokens[chrColumn].trim();
                    String[] coords = tokens[coordColumn].split(":");
                    pw.print(probe + "\t");
                    for (int i = 0; i < coords.length; ++i) {
                        pw.print(chr + ":" + coords[i]);
                        if (isMIArray) {
                            pw.print("-" + (Integer.parseInt(coords[i]) + probeLength));
                        }
                        if (i >= coords.length - 1) continue;
                        pw.print(LOCUS_DELIMITER);
                    }
                    pw.println();
                }
                reader.close();
                reader = null;
            }
            System.out.println("# overlapping probes = " + dupCount);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            pw.close();
        }
    }
}

