/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.stat;

import edu.cornell.med.icb.stat.PredictionStatisticCalculator;
import it.unimi.dsi.fastutil.objects.ObjectList;

public class RootMeanSquaredErrorCalculator
extends PredictionStatisticCalculator {
    @Override
    public String getMeasureName() {
        return "RMSE";
    }

    public RootMeanSquaredErrorCalculator() {
        this.highestStatisticIsBest = true;
        this.zero = 0.0;
    }

    @Override
    public double evaluateStatisticAtThreshold(double threshold, double[] decisionValues, double[] labels) {
        double meanSquareError = 0.0;
        for (int i = 0; i < decisionValues.length; ++i) {
            double error = decisionValues[i] - labels[i];
            meanSquareError += error * error;
        }
        return Math.sqrt(meanSquareError /= (double)decisionValues.length);
    }

    @Override
    public double thresholdIndependentStatistic(double[] decisionValues, double[] labels) {
        return this.evaluateStatisticAtThreshold(0.0, decisionValues, labels);
    }

    @Override
    public double thresholdIndependentStatistic(ObjectList<double[]> decisionValueList, ObjectList<double[]> labelList) {
        double averageStatistic = 0.0;
        double count = 0.0;
        for (int i = 0; i < decisionValueList.size(); ++i) {
            double statisticSingleSplit = this.thresholdIndependentStatistic((double[])decisionValueList.get(i), (double[])labelList.get(i));
            averageStatistic += statisticSingleSplit;
            count += 1.0;
        }
        return averageStatistic / count;
    }
}

