/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.Random;
import primitive.collection.IntStatList;
import primitive.collection.LongFunction;
import primitive.collection.LongList;

public class LongStatList
extends LongList {
    public void each(LongFunction longFunction) {
        for (int i = 0; i != this.size(); ++i) {
            longFunction.apply(this.get(i));
        }
    }

    public long reduce(long l, LongFunction longFunction) {
        long l2 = l;
        for (int i = 0; i != this.size(); ++i) {
            l2 = longFunction.accumulate(l2, this.get(i));
        }
        return l2;
    }

    public long sum() {
        LongFunction longFunction = new LongFunction(){

            @Override
            public long accumulate(long l, long l2) {
                return l + l2;
            }
        };
        return this.reduce(0L, longFunction);
    }

    public LongStats stats() {
        final LongStats longStats = new LongStats();
        LongFunction longFunction = new LongFunction(){

            @Override
            public void apply(long l) {
                if (l < longStats.min) {
                    longStats.min = l;
                }
                if (l > longStats.max) {
                    longStats.max = l;
                }
                longStats.sum += l;
            }
        };
        this.each(longFunction);
        longStats.n = this.size();
        longStats.avg = (double)longStats.sum / (double)longStats.n;
        longFunction = new LongFunction(){

            @Override
            public void apply(long l) {
                longStats.var += Math.pow(longStats.avg - (double)l, 2.0);
            }
        };
        this.each(longFunction);
        longStats.var /= (double)longStats.n;
        longStats.stdd = Math.pow(longStats.var, 0.5);
        return longStats;
    }

    static LongStatList random(int n) {
        Random random = new Random(0L);
        LongStatList longStatList = new LongStatList();
        for (int i = 0; i != n; ++i) {
            long l = random.nextLong();
            longStatList.add(l);
        }
        return longStatList;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        LongStatList longStatList = LongStatList.random(10);
        longStatList.each(new LongFunction(){

            @Override
            public void apply(long l) {
                LongStatList.p(l);
            }
        });
        LongStatList.p(longStatList.stats());
        LongStatList.p(longStatList.sum());
        IntStatList intStatList = new IntStatList();
        for (int i = 1; i < 101; ++i) {
            intStatList.add(i);
        }
        LongStatList.p(intStatList.stats());
        LongStatList.p(intStatList.sum());
    }

    class LongStats {
        public int n;
        public long min = Long.MAX_VALUE;
        public long max = Long.MIN_VALUE;
        public long sum;
        public double avg;
        public double stdd;
        public double var;

        LongStats() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("n    = ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n");
            stringBuilder.append("min  = ");
            stringBuilder.append(this.min);
            stringBuilder.append("\n");
            stringBuilder.append("max  = ");
            stringBuilder.append(this.max);
            stringBuilder.append("\n");
            stringBuilder.append("sum  = ");
            stringBuilder.append(this.sum);
            stringBuilder.append("\n");
            stringBuilder.append("avg  = ");
            stringBuilder.append(this.avg);
            stringBuilder.append("\n");
            stringBuilder.append("stdd = ");
            stringBuilder.append(this.stdd);
            stringBuilder.append("\n");
            stringBuilder.append("var  = ");
            stringBuilder.append(this.var);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

