/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class BigDecimalHelper {
    public static void main(String[] args) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            BigDecimal d = new BigDecimal("12234.54689");
            BigDecimalHelper.write(b, d);
            byte[] a = b.toByteArray();
            int i = 0;
            while (i < a.length) {
                int k = a[i] & 0xFF;
                System.out.print(Integer.toHexString(k) + ' ');
                ++i;
            }
            System.out.println("Now reading");
            ByteArrayInputStream bin = new ByteArrayInputStream(a);
            BigDecimal r = BigDecimalHelper.read(bin, d.scale());
            System.out.println(r);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static BigDecimal read(InputStream in, int scale) throws IOException {
        int f;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        do {
            if ((f = in.read()) < 0) continue;
            bout.write(f);
        } while ((f & 0xF) <= 9);
        return BigDecimalHelper.createFixed(scale, bout.toByteArray());
    }

    public static void write(OutputStream out, BigDecimal x) throws IOException, BadKind {
        int c;
        int negative;
        StringBuffer v = new StringBuffer(x.unscaledValue().toString());
        int n = 0;
        if (v.charAt(0) == '-') {
            n = 1;
        }
        if ((negative = n) != 0) {
            v = v.deleteCharAt(0);
        }
        if ((v.length() & 1) == 0) {
            v.insert(0, '0');
        }
        int i = 0;
        while (i < v.length() - 1) {
            c = v.charAt(i) - 48 << 4 | v.charAt(i + 1) - 48;
            out.write(c);
            i += 2;
        }
        c = v.charAt(v.length() - 1) - 48 << 4 | negative + 12;
        out.write(c);
    }

    private static final BigDecimal createFixed(int scale, byte[] d) {
        StringBuffer s = new StringBuffer(2 * d.length);
        int last = d.length - 1;
        if ((d[last] & 0xF) == 13) {
            s.append('-');
        }
        if (last > 0) {
            int i = 0;
            while (i < last) {
                s.append((char)((d[i] >> 4 & 0xF) + 48));
                s.append((char)((d[i] & 0xF) + 48));
                ++i;
            }
        }
        s.append((char)((d[last] >> 4 & 0xF) + 48));
        BigInteger b = new BigInteger(s.toString());
        BigDecimal dec = new BigDecimal(b, scale);
        return dec;
    }
}

