/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.NullConfiguration;

public abstract class Configuration {
    private static Configuration config;

    public static synchronized Configuration getConfiguration() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getLoginConfiguration"));
        }
        return Configuration.getConfig();
    }

    public static synchronized void setConfiguration(Configuration config) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("setLoginConfiguration"));
        }
        Configuration.config = config;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public abstract void refresh();

    static Configuration getConfig() {
        if (config == null) {
            String conf = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    return Security.getProperty("login.configuration.provider");
                }
            });
            try {
                config = conf != null ? (Configuration)Class.forName(conf).newInstance() : new NullConfiguration();
            }
            catch (Exception x) {
                config = new NullConfiguration();
            }
        }
        return config;
    }

    protected Configuration() {
    }
}

