/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import java.awt.geom.Point2D;

public class LowPassFilter {
    static final double TWO_PI = Math.PI * 2;
    double cutOffFrequency = 0.0;
    double tau;
    boolean firstTime = true;
    double previousValue;
    Point2D previousPoint;

    public void setCutOffFrequency(double cOffFrequency) {
        this.cutOffFrequency = cOffFrequency;
        this.tau = 1.0 / (Math.PI * 2 * this.cutOffFrequency);
    }

    public double apply(double newValue, double frequency) {
        double filteredValue;
        if (this.firstTime) {
            this.previousValue = newValue;
            this.firstTime = false;
        }
        double te = 1.0 / frequency;
        this.previousValue = filteredValue = (newValue + this.tau / te * this.previousValue) * (1.0 / (1.0 + this.tau / te));
        return filteredValue;
    }

    public Point2D apply(Point2D newValue, double frequency) {
        if (this.firstTime) {
            this.previousPoint = newValue;
            this.firstTime = false;
        }
        double te = 1.0 / frequency;
        double filteredX = (newValue.getX() + this.tau / te * this.previousPoint.getX()) * (1.0 / (1.0 + this.tau / te));
        double filteredY = (newValue.getY() + this.tau / te * this.previousPoint.getY()) * (1.0 / (1.0 + this.tau / te));
        this.previousPoint = new Point2D.Double(filteredX, filteredY);
        return this.previousPoint;
    }
}

