/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001, 2005 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: XftFont.h
Responsibility: Keith Stribley
Last reviewed: Not yet.

Description:
    A Font is an object that represents a font-family + bold + italic setting, that contains
	Graphite tables.
----------------------------------------------------------------------------------------------*/
#ifndef XFTGRFONT_INCLUDED
#define XFTGRFONT_INCLUDED
#include <X11/Xft/Xft.h>
#include <graphite/FreetypeFont.h>

//:End Ignore


namespace gr
{
/*-----------------------------------------------------------------------------
	Stock implementation of an Xft font class. 
------------------------------------------------------------------------------*/
/** 
* An implementation of the Graphite gr::Font class for Xft fonts for use on
* systems using X. Freetype is used to retrieve font information.
* If you are using Freetype directly, without Xft, you can pass in a FT_Face
* directly.
*/
class XftGrFont : public FreetypeFont
{
public:
  /**
  * The main user constructor. Constructs the font from the supplied XftFont.
  * @param xftFont the XftFont pointer to initialise from (must not be null)
  */
  XftGrFont(XftFont * xftFont, Display * disp = 0, Screen * scrn = 0);
  
  /**
  * Destructor - cleans up the tables that it has allocated if all other copies
  * of this font have been deleted.
  */
  virtual ~XftGrFont();
  
  /**
  * Returns a copy of the recipient. Specifically needed to store the Font 
  * in a segment. 
  * @internal
  */
  virtual Font * copyThis();
  
  /**
  * Copy constructor - note the tables are shared between the copy and the
  * original font for efficiency reasons. 
  * The last copy to be deleted will delete the tables.
  * @param font the XftGrFont object to copy from.
  * @internal
  */
  XftGrFont(const XftGrFont & font);

  /**
  * Returns true if the given arguments specify a font that contains Graphite
  * tables—specfically an “Silf” table.
  * @param xftFont XftFont pointer
  * @return true if this font has the silf table
  */
  static bool FontHasGraphiteTables(XftFont * xftFont);
  
private:
  /** Default constructor is not used */
  XftGrFont();

  void initializeDPI(Display * disp, Screen * scrn);

  // Member variables:
  XftFont *m_font;
};

} // namespace gr

#endif


