/*****
 NAME
 	derror.h - error code table
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

/* o this file is copied from the swclib package.
 * o macro values are defined in 'error.h' (linux)
 * o undefined macro section is defined as 'ND'
 */

/* error-type		macro	description
 * ----------		-----	-----------
 */
							/* general */
ERR(no_error,		0,	"no error")
ERR(can_not_happen_err,	ND,	"can not happen")
ERR(unknown_err,	ND,	"unknown error")
ERR(not_supported_err,	ENOSYS,	"not supported")
ERR(already_exist_err,	EEXIST,	"already exist")
ERR(not_exist_err,	ND,	"not exist")
ERR(not_matched_err,	ND,	"no match")
ERR(errno_err,		ND,	"error with errno variable")
ERR(illegal_param_err,	ND,	"illegal parameter")
ERR(try_again_err,	ND,	"try again")
ERR(not_serious_err,	ND,	"not serious (planned)")
ERR(exit_err,		ND,	"exit program")
							/* math */
ERR(illegal_range_err,	ERANGE,	"illegal range")
ERR(overflow_err,	ND,	"overflow")
ERR(underflow_err,	ND,	"underflow")
							/* memory */
ERR(bad_address_err,	EFAULT,	"bad address")
ERR(no_address_err,	ENXIO,	"no such device/address")
ERR(no_mem_space_err,	ENOMEM,	"no enough memory")
							/* file operation */
ERR(access_denied_err,	EACCES, "access denied")
ERR(no_such_device_err,	ENODEV,	"no such device")
ERR(bad_file_desc_err,	EBADF,	"bad file descriptor")
ERR(no_such_file_err,	ENOENT,	"no such file or dirctory")
ERR(can_not_open_err,	ND,	"can not open")
ERR(no_more_open_err,	ENFILE,	"too many open in system")
ERR(can_not_close_err,	ND,	"can not close")
ERR(can_not_read_err,	ND,	"can not read")
ERR(can_not_write_err,	ND,	"can not write")
ERR(read_only_err,	EROFS,	"read only")
ERR(is_directory_err,	EISDIR,	"is a directory")
ERR(not_empry_dir_err,	ENOTEMPTY, "not empty directory")
ERR(is_not_directory_err, ENOTDIR, "is not a directory")
ERR(too_big_err,	EFBIG,	"too big")
ERR(io_err,		EIO,	"input/output error")
ERR(io_control_err,	ENOTTY,	"inapplropriate I/O error")
ERR(too_many_open_err,	EMFILE,	"too many open")
ERR(too_many_link_err,	EMLINK,	"too many links")
ERR(too_long_name,	ENAMETOOLONG, "too long name")
ERR(no_file_space_err,	ENOSPC,	"no enough space on device")
ERR(broken_pipe_err,	EPIPE,	"broken pipe error")
ERR(invalid_seek_err,	ESPIPE,	"invalid seek")
ERR(inmproper_link_err,	EXDEV,	"improper link")
ERR(eof_err,		ND,	"end of file")

							/* command line opt */
ERR(too_many_arg,	E2BIG,	"too many arglist")
ERR(illegal_arg_err,	EINVAL,	"illegal argument")
ERR(illegal_opt_err,	ND,	"illegal option")
ERR(no_arg_err,		ND,	"some arugments requied")

							/* object */
ERR(object_alloc_err,	ND,	"object alloc failed")
ERR(illegal_object_err,	ND,	"illegal object type")
							/* format */
ERR(illegal_format_err,	ND,	"illegal format")
ERR(not_exec_format_err, ENOEXEC, "exec format error")
ERR(bad_quote_err,	ND,	"bad quoting error")
							/* program flow */
ERR(can_not_continue_err, ND,	"can not continue")
ERR(no_effect_err,	ND,	"no effect")
ERR(program_pre_err,	ND,	"program pre-process failed")
ERR(program_main_err,	ND,	"program main-process failed")
ERR(program_post_err,	ND,	"program post-process failed")
							/* resource */
ERR(no_permission_err,	EPERM,	"not permitted")
ERR(already_used_err,	ND,	"already used")
ERR(not_ready_err,	EAGAIN,	"not ready yet")
ERR(no_more_err,	ND,	"can not do anymore")
ERR(busy_err,		EBUSY,	"resource busy")
ERR(dead_lock_err,	EDEADLK, "dead lock")
ERR(unavailable_lock_err, ENOLCK, "no locks available")
							/* network */
ERR(domain_err,		EDOM,	"domain error")
ERR(socket_err,		ND,	"socket error")
							/* process */
ERR(no_child_process_err, ECHILD, "no child processes")
ERR(no_such_process_err, ESRCH,	"no such process")
							/* interupt */
ERR(interrupted_err,	EINTR,	"interrupted function call")
							/* Environment Var. */
ERR(illegal_envvar_err,	ND,	"illegal environment variable") 

