/*****
 NAME
 	dgtkxml.h - tag name definition for XML 
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 NOTE
 	1) This file is designed to be included two or more times in a file
	2) You have to include "dconst.h" before including this one.
	3) if you edit this file, edit the following files:
	     dxml.h, dcmdxml.h, dgtkxml.h
 */

#if !defined(TAG_NAME)
#  define TAG_NAME(IDENT, VALUE)
#endif
#if !defined(ATTR_NAME)
#  define ATTR_NAME(IDENT, VALUE)
#endif
#if !defined(ATTR_VALUE)
#  define ATTR_VALUE(IDENT, VALUE)
#endif

/************************************************************************
 * COMMON TAG DEFINITION
 ************************************************************************/
#include <coconut/dxml.h>

/************************************************************************
 * WIDGET TAG DEFINITION
 ************************************************************************/
TAG_NAME(arrow_element,			ARROW_STR)
TAG_NAME(button_element,		BUTTON_STR)
TAG_NAME(check_button_element,		CHECK_BUTTON_STR)
TAG_NAME(container_element,		CONTAINER_STR)
TAG_NAME(frame_element,			FRAME_STR)
TAG_NAME(label_element,			LABEL_STR)
TAG_NAME(separator_element,		SEPARATOR_STR)

/* attributes for window widget */
ATTR_NAME(window_type_attr,		"window_type")
  ATTR_VALUE(toplevel_attr_value,	"toplevel")
  ATTR_VALUE(dialog_attr_value,		"dialog")
ATTR_NAME(screen_align_attr,		"screen_align")
  ATTR_VALUE(free_attr_value,		"free")
  ATTR_VALUE(center_attr_value,		"center")
  ATTR_VALUE(mouse_attr_value,		"mouse")

/* attributes for container widget */
ATTR_NAME(layout_attr,			"layout")
  ATTR_VALUE(holiz_attr_value,		"holiz")
  ATTR_VALUE(vert_attr_value,		"vert")
ATTR_NAME(homogeneous_attr,		"homogeneous")
  /* "true", "false" */
ATTR_NAME(spacing_attr,			"spacing")
  /* spacing attribute takes integer value */

/* attributes for widgets */
ATTR_NAME(align_attr,			"align")
  /* "left", "center", "right" */
  ATTR_VALUE(top_attr_value,		"top")
  ATTR_VALUE(middle_attr_value,		"middle")
  ATTR_VALUE(bottom_attr_value,		"bottom")
ATTR_NAME(direction_attr,		"direction")
  ATTR_VALUE(up_attr_value,		"up")
  ATTR_VALUE(down_attr_value,		"down")
  ATTR_VALUE(left_attr_value,		"left")
  ATTR_VALUE(right_attr_value,		"right")
ATTR_NAME(shadow_attr,			"shadow")
  ATTR_VALUE(none_attr_value,		NONE_STR)
  ATTR_VALUE(in_attr_value,		IN_STR)
  ATTR_VALUE(out_attr_value,		OUT_STR)
  ATTR_VALUE(etched_in_attr_value,	"etched_in")
  ATTR_VALUE(etched_out_attr_value,	"etched_out")
ATTR_NAME(title_attr,			TITLE_STR)
  /* title attribute takes the string */

/************************************************************************
 * EVENT TAG DEFINITION
 ************************************************************************/
TAG_NAME(events_element,	"events")
TAG_NAME(clicked_element,	"clicked")

#undef	TAG_NAME
#undef	ATTR_NAME
#undef	ATTR_VALUE

