/*****
 NAME
	toptparser.h - type definition for command line option parser
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(TOPTPARSER_H_INCLUDED)
#define	TOPTPARSER_H_INCLUDED

#include <coconut/dconfig.h>
#if defined(COCONUT_HAVE_LIBPOPT)
#	include <popt.h>
#else
#	error "this file requires popt.h"
#endif /* defined(COCONUT_HAVE_LIBPOPT) */

typedef	enum {
	none_arg		= POPT_ARG_NONE,
	string_arg		= POPT_ARG_STRING,
	int_arg			= POPT_ARG_INT,
	long_arg		= POPT_ARG_LONG,
	float_arg		= POPT_ARG_FLOAT,
	double_arg		= POPT_ARG_DOUBLE
} arg_t ;

#define	ARGT2POPT(v)	((int) v)

typedef void (*optparser_callback_func_t)(poptContext con, int reason,
  struct poptOption * opt, char * arg, void * data) ;

#endif /* !defined(TOPTPARSER_H_INCLUDED) */

