/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.PolarCoords;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VCbCurve;
import com.xerox.VTM.glyphs.VSegment;
import java.awt.Color;
import java.util.Vector;
import net.claribole.zvtm.lens.ExplanationEventHandler;

public class Explanation {
    VirtualSpaceManager vsm = new VirtualSpaceManager();
    View mView;
    static final String mViewName = "mainView";
    static final int VIEW_WIDTH = 800;
    static final int VIEW_HEIGHT = 600;
    ExplanationEventHandler eeh;
    VirtualSpace mSpace;
    static final String mSpaceName = "mainSpace";
    Camera mCamera;
    VSegment lseg;
    VSegment cseg;
    VSegment rseg;
    VSegment caseg1;
    VSegment caseg2;
    VSegment caseg3;
    VSegment caseg4;
    VCbCurve lcur;
    VCbCurve rcur;
    static final Color SEG_COLOR = Color.black;
    static final Color CUR_COLOR = Color.black;
    static final Color CAM1_COLOR = Color.red;
    static final Color CAM2_COLOR = Color.blue;
    boolean zooming = false;
    int ANIM_LENGTH = 500;

    public Explanation() {
        this.init();
        this.initGlyphs();
    }

    void init() {
        this.mSpace = this.vsm.addVirtualSpace(mSpaceName);
        this.mCamera = this.vsm.addCamera(mSpaceName);
        Vector<Camera> v = new Vector<Camera>();
        v.add(this.mCamera);
        this.mView = this.vsm.addExternalView(v, mViewName, (short)0, 800, 600, false, true);
        this.eeh = new ExplanationEventHandler(this);
        this.mView.setEventHandler(this.eeh);
    }

    void initGlyphs() {
        this.caseg1 = new VSegment(0L, 400L, 0, CAM1_COLOR, -800L, -400L);
        this.caseg2 = new VSegment(0L, 400L, 0, CAM1_COLOR, 800L, -400L);
        this.vsm.addGlyph((Glyph)this.caseg1, this.mSpace);
        this.vsm.addGlyph((Glyph)this.caseg2, this.mSpace);
        this.mCamera.stick(this.caseg1);
        this.mCamera.stick(this.caseg2);
        this.caseg3 = new VSegment(0L, 400L, 0, CAM2_COLOR, 200L, -400L);
        this.caseg4 = new VSegment(0L, 400L, 0, CAM2_COLOR, 300L, -400L);
        this.vsm.addGlyph((Glyph)this.caseg3, this.mSpace);
        this.vsm.addGlyph((Glyph)this.caseg4, this.mSpace);
        this.mCamera.stick(this.caseg3);
        this.mCamera.stick(this.caseg4);
        this.lseg = new VSegment(-5000L, 0L, 0, SEG_COLOR, -150L, 0L);
        this.vsm.addGlyph((Glyph)this.lseg, this.mSpace);
        this.cseg = new VSegment(-50L, 0L, 0, SEG_COLOR, 50L, 0L);
        this.vsm.addGlyph((Glyph)this.cseg, this.mSpace);
        this.rseg = new VSegment(150L, 0L, 0, SEG_COLOR, 5000L, 0L);
        this.vsm.addGlyph((Glyph)this.rseg, this.mSpace);
        this.lcur = new VCbCurve(-100L, 0L, 0, 50L, CUR_COLOR, 0.0f, 0L, 2.3561945f, 0L, 5.497787f);
        this.vsm.addGlyph((Glyph)this.lcur, this.mSpace);
        this.rcur = new VCbCurve(100L, 0L, 0, 50L, CUR_COLOR, 0.0f, 0L, -2.3561945f, 0L, -5.497787f);
        this.vsm.addGlyph((Glyph)this.rcur, this.mSpace);
    }

    void centerCamera() {
        this.mCamera.moveTo(0L, this.mCamera.posy);
    }

    void moveLeft() {
        this.mCamera.move(20L, 0L);
    }

    void moveRight() {
        this.mCamera.move(-20L, 0L);
    }

    void zoomin() {
        if (this.zooming) {
            this.zip2();
        } else {
            this.zip1();
        }
        this.zooming = !this.zooming;
    }

    void zoomout() {
        if (this.zooming) {
            this.zop2();
        } else {
            this.zop1();
        }
        this.zooming = !this.zooming;
    }

    void zip1() {
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 100L), this.cseg.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 50L), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)6, new Float(-0.7853981633974483), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)3, new Float(Math.sqrt(2.0)), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 50L), this.rcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)6, new Float(0.7853981633974483), this.rcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)3, new Float(Math.sqrt(2.0)), this.rcur.getID());
        this.curve();
    }

    void zip2() {
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 100L), this.lseg.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 100L), this.rseg.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 50L), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)6, new Float(0.7853981633974483), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)3, new Float(1.0 / Math.sqrt(2.0)), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 50L), this.rcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)6, new Float(-0.7853981633974483), this.rcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)3, new Float(1.0 / Math.sqrt(2.0)), this.rcur.getID());
        this.uncurve();
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 100L), this.caseg1.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 100L), this.caseg2.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 100L), this.caseg3.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, 100L), this.caseg4.getID());
    }

    void zop1() {
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -100L), this.lseg.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -100L), this.rseg.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -50L), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)6, new Float(-0.7853981633974483), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)3, new Float(Math.sqrt(2.0)), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -50L), this.rcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)6, new Float(0.7853981633974483), this.rcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)3, new Float(Math.sqrt(2.0)), this.rcur.getID());
        this.curve();
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -100L), this.caseg1.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -100L), this.caseg2.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -100L), this.caseg3.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -100L), this.caseg4.getID());
    }

    void zop2() {
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -100L), this.cseg.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -50L), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)6, new Float(0.7853981633974483), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)3, new Float(1.0 / Math.sqrt(2.0)), this.lcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)0, new LongPoint(0L, -50L), this.rcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)6, new Float(-0.7853981633974483), this.rcur.getID());
        this.vsm.animator.createGlyphAnimation((long)this.ANIM_LENGTH, 0, (short)3, new Float(1.0 / Math.sqrt(2.0)), this.rcur.getID());
        this.uncurve();
    }

    void curve() {
        Vector<PolarCoords> vl = new Vector<PolarCoords>();
        vl.add(new PolarCoords(50L, 0.0f));
        vl.add(new PolarCoords(50L, 0.0f));
        this.vsm.animator.createCbCurveCtrlPtAnimation(this.ANIM_LENGTH, (short)0, vl, this.lcur.getID(), null);
        Vector<PolarCoords> vr = new Vector<PolarCoords>();
        vr.add(new PolarCoords(50L, 0.0f));
        vr.add(new PolarCoords(50L, 0.0f));
        this.vsm.animator.createCbCurveCtrlPtAnimation(this.ANIM_LENGTH, (short)0, vr, this.rcur.getID(), null);
    }

    void uncurve() {
        Vector<PolarCoords> vl = new Vector<PolarCoords>();
        vl.add(new PolarCoords(-50L, 0.0f));
        vl.add(new PolarCoords(-50L, 0.0f));
        this.vsm.animator.createCbCurveCtrlPtAnimation(this.ANIM_LENGTH, (short)0, vl, this.lcur.getID(), null);
        Vector<PolarCoords> vr = new Vector<PolarCoords>();
        vr.add(new PolarCoords(-50L, 0.0f));
        vr.add(new PolarCoords(-50L, 0.0f));
        this.vsm.animator.createCbCurveCtrlPtAnimation(this.ANIM_LENGTH, (short)0, vr, this.rcur.getID(), null);
    }

    public static void main(String[] args) {
        new Explanation();
    }
}

