# List of rules

## Types

  * [ArrayVal](rules/ArrayVal.md)
  * [ArrayType](rules/ArrayType.md)
  * [BoolVal](rules/BoolVal.md)
  * [BoolType](rules/BoolType.md)
  * [CallableType](rules/CallableType.md)
  * [Countable](rules/Countable.md)
  * [Date](rules/Date.md)
  * [FalseVal](rules/FalseVal.md)
  * [FloatVal](rules/FloatVal.md)
  * [FloatType](rules/FloatType.md)
  * [Instance](rules/Instance.md)
  * [IntVal](rules/IntVal.md)
  * [IntType](rules/IntType.md)
  * [IterableType](rules/IterableType.md)
  * [NullType](rules/NullType.md)
  * [Numeric](rules/Numeric.md)
  * [ObjectType](rules/ObjectType.md)
  * [ResourceType](rules/ResourceType.md)
  * [ScalarVal](rules/ScalarVal.md)
  * [StringType](rules/StringType.md)
  * [TrueVal](rules/TrueVal.md)
  * [Type](rules/Type.md)
  * [Xdigit](rules/Xdigit.md)

## Generics

  * [AlwaysInvalid](rules/AlwaysInvalid.md)
  * [AlwaysValid](rules/AlwaysValid.md)
  * [Call](rules/Call.md)
  * [Callback](rules/Callback.md)
  * [FilterVar](rules/FilterVar.md)
  * [Not](rules/Not.md)
  * [Optional](rules/Optional.md)
  * [Type](rules/Type.md)
  * [When](rules/When.md)

## Comparing Values

  * [Age](rules/Age.md)
  * [Between](rules/Between.md)
  * [Equals](rules/Equals.md)
  * [Identical](rules/Identical.md)
  * [Max](rules/Max.md)
  * [Min](rules/Min.md)

## Numeric

  * [Between](rules/Between.md)
  * [BoolType](rules/BoolType.md)
  * [Even](rules/Even.md)
  * [Factor](rules/Factor.md)
  * [Fibonacci](rules/Fibonacci.md)
  * [Finite](rules/Finite.md)
  * [FloatVal](rules/FloatVal.md)
  * [FloatType](rules/FloatType.md)
  * [Infinite](rules/Infinite.md)
  * [IntVal](rules/IntVal.md)
  * [IntType](rules/IntType.md)
  * [Multiple](rules/Multiple.md)
  * [Negative](rules/Negative.md)
  * [NotEmpty](rules/NotEmpty.md)
  * [Numeric](rules/Numeric.md)
  * [Odd](rules/Odd.md)
  * [PerfectSquare](rules/PerfectSquare.md)
  * [Positive](rules/Positive.md)
  * [PrimeNumber](rules/PrimeNumber.md)
  * [Roman](rules/Roman.md)
  * [Xdigit](rules/Xdigit.md)

## String

  * [Alnum](rules/Alnum.md)
  * [Alpha](rules/Alpha.md)
  * [Between](rules/Between.md)
  * [Charset](rules/Charset.md)
  * [Cntrl](rules/Cntrl.md)
  * [Consonant](rules/Consonant.md)
  * [Contains](rules/Contains.md)
  * [Digit](rules/Digit.md)
  * [EndsWith](rules/EndsWith.md)
  * [Graph](rules/Graph.md)
  * [In](rules/In.md)
  * [Length](rules/Length.md)
  * [Lowercase](rules/Lowercase.md)
  * [NotEmpty](rules/NotEmpty.md)
  * [NoWhitespace](rules/NoWhitespace.md)
  * [PhpLabel](rules/PhpLabel.md)
  * [Prnt](rules/Prnt.md)
  * [Punct](rules/Punct.md)
  * [Regex](rules/Regex.md)
  * [ResourceType](rules/ResourceType.md)
  * [Slug](rules/Slug.md)
  * [Space](rules/Space.md)
  * [StartsWith](rules/StartsWith.md)
  * [Uppercase](rules/Uppercase.md)
  * [Version](rules/Version.md)
  * [Vowel](rules/Vowel.md)
  * [Xdigit](rules/Xdigit.md)

## Arrays

  * [ArrayVal](rules/ArrayVal.md)
  * [ArrayType](rules/ArrayType.md)
  * [Contains](rules/Contains.md)
  * [Each](rules/Each.md)
  * [EndsWith](rules/EndsWith.md)
  * [In](rules/In.md)
  * [Key](rules/Key.md)
  * [KeyNested](rules/KeyNested.md)
  * [KeySet](rules/KeySet.md)
  * [KeyValue](rules/KeyValue.md)
  * [Length](rules/Length.md)
  * [NotEmpty](rules/NotEmpty.md)
  * [StartsWith](rules/StartsWith.md)

## Objects

  * [Attribute](rules/Attribute.md)
  * [Instance](rules/Instance.md)
  * [Length](rules/Length.md)

## Date and Time

  * [Age](rules/Age.md)
  * [Between](rules/Between.md)
  * [Date](rules/Date.md)
  * [LeapDate](rules/LeapDate.md)
  * [LeapYear](rules/LeapYear.md)
  * [MinimumAge](rules/MinimumAge.md)

## Group Validators

  * [AllOf](rules/AllOf.md)
  * [NoneOf](rules/NoneOf.md)
  * [OneOf](rules/OneOf.md)

## Regional

  * [CountryCode](rules/CountryCode.md)
  * [CurrencyCode](rules/CurrencyCode.md)
  * [IdentityCard](rules/IdentityCard.md)
  * [LanguageCode](rules/LanguageCode.md)
  * [PostalCode](rules/PostalCode.md)
  * [SubdivisionCode](rules/SubdivisionCode.md)
  * [Tld](rules/Tld.md)

## Files

  * [Directory](rules/Directory.md)
  * [Executable](rules/Executable.md)
  * [Exists](rules/Exists.md)
  * [Extension](rules/Extension.md)
  * [File](rules/File.md)
  * [Image](rules/Image.md)
  * [Mimetype](rules/Mimetype.md)
  * [Readable](rules/Readable.md)
  * [Size](rules/Size.md)
  * [SymbolicLink](rules/SymbolicLink.md)
  * [Uploaded](rules/Uploaded.md)
  * [Writable](rules/Writable.md)

## Banking

  * [Bank](rules/Bank.md)
  * [BankAccount](rules/BankAccount.md)
  * [Bic](rules/Bic.md)

## Other

  * [Bsn](rules/Bsn.md)
  * [Cnh](rules/Cnh.md)
  * [Cnpj](rules/Cnpj.md)
  * [Cpf](rules/Cpf.md)
  * [Domain](rules/Domain.md)
  * [Email](rules/Email.md)
  * [HexRgbColor](rules/HexRgbColor.md)
  * [Imei](rules/Imei.md)
  * [Ip](rules/Ip.md)
  * [Json](rules/Json.md)
  * [MacAddress](rules/MacAddress.md)
  * [NfeAccessKey](rules/NfeAccessKey.md)
  * [NotBlank](rules/NotBlank.md)
  * [NotOptional](rules/NotOptional.md)
  * [Pesel](rules/Pesel.md)
  * [Phone](rules/Phone.md)
  * [Sf](rules/Sf.md)
  * [Url](rules/Url.md)
  * [VideoUrl](rules/VideoUrl.md)
  * [Zend](rules/Zend.md)

## Yes/No

  * [No](rules/No.md)
  * [Yes](rules/Yes.md)

## Alphabetically

  * [Age](rules/Age.md)
  * [AllOf](rules/AllOf.md)
  * [Alnum](rules/Alnum.md)
  * [Alpha](rules/Alpha.md)
  * [AlwaysInvalid](rules/AlwaysInvalid.md)
  * [AlwaysValid](rules/AlwaysValid.md)
  * [ArrayVal](rules/ArrayVal.md)
  * [ArrayType](rules/ArrayType.md)
  * [Attribute](rules/Attribute.md)
  * [Bank](rules/Bank.md)
  * [BankAccount](rules/BankAccount.md)
  * [Between](rules/Between.md)
  * [Bic](rules/Bic.md)
  * [BoolType](rules/BoolType.md)
  * [Bsn](rules/Bsn.md)
  * [Call](rules/Call.md)
  * [CallableType](rules/CallableType.md)
  * [Callback](rules/Callback.md)
  * [Charset](rules/Charset.md)
  * [Cnh](rules/Cnh.md)
  * [Cnpj](rules/Cnpj.md)
  * [Cntrl](rules/Cntrl.md)
  * [Consonant](rules/Consonant.md)
  * [Contains](rules/Contains.md)
  * [Countable](rules/Countable.md)
  * [CountryCode](rules/CountryCode.md)
  * [Cpf](rules/Cpf.md)
  * [CreditCard](rules/CreditCard.md)
  * [Date](rules/Date.md)
  * [Digit](rules/Digit.md)
  * [Directory](rules/Directory.md)
  * [Domain](rules/Domain.md)
  * [Each](rules/Each.md)
  * [Email](rules/Email.md)
  * [EndsWith](rules/EndsWith.md)
  * [Equals](rules/Equals.md)
  * [Even](rules/Even.md)
  * [Executable](rules/Executable.md)
  * [Exists](rules/Exists.md)
  * [Extension](rules/Extension.md)
  * [Factor](rules/Factor.md)
  * [FalseVal](rules/FalseVal.md)
  * [Fibonacci](rules/Fibonacci.md)
  * [File](rules/File.md)
  * [FilterVar](rules/FilterVar.md)
  * [Finite](rules/Finite.md)
  * [FloatVal](rules/FloatVal.md)
  * [FloatType](rules/FloatType.md)
  * [Graph](rules/Graph.md)
  * [HexRgbColor](rules/HexRgbColor.md)
  * [Identical](rules/Identical.md)
  * [IdentityCard](rules/IdentityCard.md)
  * [Image](rules/Image.md)
  * [Imei](rules/Imei.md)
  * [In](rules/In.md)
  * [Infinite](rules/Infinite.md)
  * [Instance](rules/Instance.md)
  * [IntVal](rules/IntVal.md)
  * [IntType](rules/IntType.md)
  * [Ip](rules/Ip.md)
  * [IterableType](rules/IterableType.md)
  * [Json](rules/Json.md)
  * [Key](rules/Key.md)
  * [KeyNested](rules/KeyNested.md)
  * [KeySet](rules/KeySet.md)
  * [KeyValue](rules/KeyValue.md)
  * [LanguageCode](rules/LanguageCode.md)
  * [LeapDate](rules/LeapDate.md)
  * [LeapYear](rules/LeapYear.md)
  * [Length](rules/Length.md)
  * [Lowercase](rules/Lowercase.md)
  * [MacAddress](rules/MacAddress.md)
  * [Max](rules/Max.md)
  * [Mimetype](rules/Mimetype.md)
  * [Min](rules/Min.md)
  * [MinimumAge](rules/MinimumAge.md)
  * [Multiple](rules/Multiple.md)
  * [Negative](rules/Negative.md)
  * [NfeAccessKey](rules/NfeAccessKey.md)
  * [No](rules/No.md)
  * [NoWhitespace](rules/NoWhitespace.md)
  * [NoneOf](rules/NoneOf.md)
  * [Not](rules/Not.md)
  * [NotBlank](rules/NotBlank.md)
  * [NotEmpty](rules/NotEmpty.md)
  * [NotOptional](rules/NotOptional.md)
  * [NullType](rules/NullType.md)
  * [Numeric](rules/Numeric.md)
  * [ObjectType](rules/ObjectType.md)
  * [Odd](rules/Odd.md)
  * [OneOf](rules/OneOf.md)
  * [Optional](rules/Optional.md)
  * [PerfectSquare](rules/PerfectSquare.md)
  * [Pesel](rules/Pesel.md)
  * [Phone](rules/Phone.md)
  * [PhpLabel](rules/PhpLabel.md)
  * [Positive](rules/Positive.md)
  * [PostalCode](rules/PostalCode.md)
  * [PrimeNumber](rules/PrimeNumber.md)
  * [Prnt](rules/Prnt.md)
  * [Punct](rules/Punct.md)
  * [Readable](rules/Readable.md)
  * [Regex](rules/Regex.md)
  * [ResourceType](rules/ResourceType.md)
  * [Roman](rules/Roman.md)
  * [ScalarVal](rules/ScalarVal.md)
  * [Sf](rules/Sf.md)
  * [Size](rules/Size.md)
  * [Slug](rules/Slug.md)
  * [Space](rules/Space.md)
  * [StartsWith](rules/StartsWith.md)
  * [StringType](rules/StringType.md)
  * [SubdivisionCode](rules/SubdivisionCode.md)
  * [SymbolicLink](rules/SymbolicLink.md)
  * [Tld](rules/Tld.md)
  * [TrueVal](rules/TrueVal.md)
  * [Type](rules/Type.md)
  * [Uploaded](rules/Uploaded.md)
  * [Uppercase](rules/Uppercase.md)
  * [Url](rules/Url.md)
  * [Version](rules/Version.md)
  * [VideoUrl](rules/VideoUrl.md)
  * [Vowel](rules/Vowel.md)
  * [When](rules/When.md)
  * [Writable](rules/Writable.md)
  * [Xdigit](rules/Xdigit.md)
  * [Yes](rules/Yes.md)
  * [Zend](rules/Zend.md)
