SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';

ALTER TABLE `users` 
ADD COLUMN `first_name` VARCHAR(255) NULL DEFAULT NULL AFTER `analyticsCode`,
ADD COLUMN `last_name` VARCHAR(255) NULL DEFAULT NULL AFTER `first_name`,
ADD COLUMN `address` VARCHAR(255) NULL DEFAULT NULL AFTER `last_name`,
ADD COLUMN `zip_code` VARCHAR(45) NULL DEFAULT NULL AFTER `address`,
ADD COLUMN `country` VARCHAR(100) NULL DEFAULT NULL AFTER `zip_code`,
ADD COLUMN `region` VARCHAR(100) NULL DEFAULT NULL AFTER `country`,
ADD COLUMN `city` VARCHAR(100) NULL DEFAULT NULL AFTER `region`;


CREATE TABLE IF NOT EXISTS `users_blob` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `blob` LONGBLOB NULL,
  `users_id` INT NOT NULL,
  `created` DATETIME NULL,
  `modified` DATETIME NULL,
  `type` VARCHAR(45) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_users_document_image_users1_idx` (`users_id` ASC),
  CONSTRAINT `fk_users_document_image_users1`
    FOREIGN KEY (`users_id`)
    REFERENCES `users` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;

UPDATE configurations SET  version = '6.0', modified = now() WHERE id = 1;

SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
