<?php

class IndexPage extends CMSHTMLPageBase{
	var $message = "";
	var $username;

	function doPost(){
		$action = SOY2ActionFactory::createInstance('LoginAction');
		$result = $action->run();

		//ログイン
		if($result->success()){
			SOY2PageController::redirect("");
		}else{
			//失敗したときは2秒待たせる
			sleep(2);
		}
		$this->message = CMSMessageManager::get("ADMIN_FAILURE_TO_LOGIN");
		$this->username = $result->getAttribute('username');

	}

	function IndexPage(){
		//ログインしていたらルートに飛ばす
		if(UserInfoUtil::isLoggined()){
			SOY2PageController::jump("");
		}

		WebPage::WebPage();

		//CSS読み込み
		HTMLHead::addLink("login_style",array(
				"rel" => "stylesheet",
				"type" => "text/css",
				"href" => SOY2PageController::createRelativeLink("./css/login/style.css")."?".SOYCMS_BUILD_TIME
		));
		$this->createAdd("head" ,"HTMLHead",array(
			"title" => "SOY CMS Login"
		));


		//フォームの作成
		$form = SOY2HTMLFactory::createInstance('HTMLForm');
		$form->createAdd('username','HTMLInput',array(
			'name' => 'Auth[name]',
			'value' => $this->username,
		));
		$form->createAdd('password','HTMLInput',array(
			'name' => 'Auth[password]',
			'value' => '',
		));

		$this->add('AuthForm',$form);

		//if(!strlen($this->message)) $this->message = "<a href='".SOY2PageController::createLink("ForgetPassword")."'>パスワードを忘れた場合</a>";

		$this->createAdd("message","HTMLLabel",array(
			"html" => $this->message,
			"visible" => strlen($this->message)
		));

		$this->createAdd("biglogo","HTMLModel",array(
    		"src"=>SOY2PageController::createRelativeLink("css/img/logo_big.gif")
    	));

	}

    /**
     * Overwrite CMSHTMLPageBase::getTemplateFilePath
     */
    function getTemplateFilePath(){

		if(defined("SOYCMS_LANGUAGE_DIR")){
			$dir = dirname($this->getClassPath());
			if(strlen($dir) >0) $dir .= '/';

			$soy2html_root = SOY2HTMLConfig::PageDir();
			$language_root = SOYCMS_LANGUAGE_DIR.SOY2HTMLConfig::Language()."/Login/";
			$custom_lang_html = str_replace($soy2html_root, $language_root, $dir) . get_class($this) . ".html";
			if(file_exists($custom_lang_html)){
				return $custom_lang_html;
			}
		}

		return 	parent::getTemplateFilePath();
    }
}

?>