import { HintPosition, HintStep, IntroStep, ScrollTo, TooltipPosition } from "./core/steps";
export interface Options {
    steps: Partial<IntroStep>[];
    hints: Partial<HintStep>[];
    isActive: boolean;
    nextLabel: string;
    prevLabel: string;
    skipLabel: string;
    doneLabel: string;
    hidePrev: boolean;
    hideNext: boolean;
    nextToDone: boolean;
    tooltipPosition: string;
    tooltipClass: string;
    group: string;
    highlightClass: string;
    exitOnEsc: boolean;
    exitOnOverlayClick: boolean;
    showStepNumbers: boolean;
    stepNumbersOfLabel: string;
    keyboardNavigation: boolean;
    showButtons: boolean;
    showBullets: boolean;
    showProgress: boolean;
    scrollToElement: boolean;
    scrollTo: ScrollTo;
    scrollPadding: number;
    overlayOpacity: number;
    autoPosition: boolean;
    positionPrecedence: TooltipPosition[];
    disableInteraction: boolean;
    dontShowAgain: boolean;
    dontShowAgainLabel: string;
    dontShowAgainCookie: string;
    dontShowAgainCookieDays: number;
    helperElementPadding: number;
    hintPosition: HintPosition;
    hintButtonLabel: string;
    hintShowButton: boolean;
    hintAutoRefreshInterval: number;
    hintAnimation: boolean;
    buttonClass: string;
    progressBarAdditionalClass: boolean;
}
export declare function getDefaultOptions(): Options;
export declare function setOption<K extends keyof Options>(options: Options, key: K, value: Options[K]): Options;
export declare function setOptions(options: Options, partialOptions: Partial<Options>): Options;
