/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.TextAction;
import javax.swing.text.ViewFactory;

public class DefaultEditorKit
extends EditorKit {
    private static final long serialVersionUID = 9017245433028523428L;
    public static final String backwardAction = "caret-backward";
    public static final String beepAction = "beep";
    public static final String beginAction = "caret-begin";
    public static final String beginLineAction = "caret-begin-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String beginWordAction = "caret-begin-word";
    public static final String copyAction = "copy-to-clipboard";
    public static final String cutAction = "cut-to-clipboard";
    public static final String defaultKeyTypedAction = "default-typed";
    public static final String deleteNextCharAction = "delete-next";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String downAction = "caret-down";
    public static final String endAction = "caret-end";
    public static final String endLineAction = "caret-end-line";
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String endWordAction = "caret-end-word";
    public static final String forwardAction = "caret-forward";
    public static final String insertBreakAction = "insert-break";
    public static final String insertContentAction = "insert-content";
    public static final String insertTabAction = "insert-tab";
    public static final String nextWordAction = "caret-next-word";
    public static final String pageDownAction = "page-down";
    public static final String pageUpAction = "page-up";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String previousWordAction = "caret-previous-word";
    public static final String readOnlyAction = "set-read-only";
    public static final String selectAllAction = "select-all";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionDownAction = "selection-down";
    public static final String selectionEndAction = "selection-end";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionUpAction = "selection-up";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectWordAction = "select-word";
    public static final String upAction = "caret-up";
    public static final String writableAction = "set-writable";
    private static Action[] defaultActions = new Action[]{new BeepAction(), new CopyAction(), new CutAction(), new DefaultKeyTypedAction(), new InsertBreakAction(), new InsertContentAction(), new InsertTabAction(), new PasteAction(), new TextAction("delete-next"){

        public final void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                try {
                    int pos = t.getCaret().getDot();
                    if (pos < t.getDocument().getEndPosition().getOffset()) {
                        t.getDocument().remove(t.getCaret().getDot(), 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }, new TextAction("delete-previous"){

        public final void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                try {
                    int pos = t.getCaret().getDot();
                    if (pos > t.getDocument().getStartPosition().getOffset()) {
                        t.getDocument().remove(pos - 1, 1);
                        t.getCaret().setDot(pos - 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }, new TextAction("caret-backward"){

        public final void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                t.getCaret().setDot(Math.max(t.getCaret().getDot() - 1, t.getDocument().getStartPosition().getOffset()));
            }
        }
    }, new TextAction("caret-forward"){

        public final void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                t.getCaret().setDot(Math.min(t.getCaret().getDot() + 1, t.getDocument().getEndPosition().getOffset()));
            }
        }
    }, new TextAction("selection-backward"){

        public final void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                t.getCaret().moveDot(Math.max(t.getCaret().getDot() - 1, t.getDocument().getStartPosition().getOffset()));
            }
        }
    }, new TextAction("selection-forward"){

        public final void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                t.getCaret().moveDot(Math.min(t.getCaret().getDot() + 1, t.getDocument().getEndPosition().getOffset()));
            }
        }
    }};

    public Caret createCaret() {
        return new DefaultCaret();
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public void read(InputStream in, Document document, int offset) throws BadLocationException, IOException {
        this.read(new InputStreamReader(in), document, offset);
    }

    public void read(Reader in, Document document, int offset) throws BadLocationException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(in);
        StringBuffer content = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            content.append(line);
            content.append("\n");
        }
        document.insertString(offset, content.toString(), SimpleAttributeSet.EMPTY);
    }

    public void write(OutputStream out, Document document, int offset, int len) throws BadLocationException, IOException {
        this.write(new OutputStreamWriter(out), document, offset, len);
    }

    public void write(Writer out, Document document, int offset, int len) throws BadLocationException, IOException {
        if (offset < 0 || offset > document.getLength()) {
            throw new BadLocationException("Tried to write to invalid location", offset);
        }
        if (offset + len > document.getLength()) {
            len = document.getLength() - offset;
        }
        out.write(document.getText(offset, len));
    }

    public static class BeepAction
    extends TextAction {
        public void actionPerformed(ActionEvent event) {
            Toolkit.getDefaultToolkit().beep();
        }

        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }
    }

    public static class CopyAction
    extends TextAction {
        public void actionPerformed(ActionEvent event) {
        }

        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }
    }

    public static class CutAction
    extends TextAction {
        public void actionPerformed(ActionEvent event) {
        }

        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public void actionPerformed(ActionEvent event) {
            char c = event.getActionCommand().charAt(0);
            if (Character.isISOControl(c)) {
                return;
            }
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                try {
                    t.getDocument().insertString(t.getCaret().getDot(), event.getActionCommand(), null);
                }
                catch (BadLocationException be) {
                    // empty catch block
                }
            }
        }

        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            t.replaceSelection("\n");
        }

        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public void actionPerformed(ActionEvent event) {
        }

        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }
    }

    public static class InsertTabAction
    extends TextAction {
        public void actionPerformed(ActionEvent event) {
        }

        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }
    }

    public static class PasteAction
    extends TextAction {
        public void actionPerformed(ActionEvent event) {
        }

        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }
    }
}

