class SushiNet::StoreSession < Borges::ControllerSession

  attr_accessor :items, :cart

  def add_to_cart(item)
    @cart[item] += 1
  end

  ##
  # XXX Neccessary?

  def all_items
    return @items
  end

  def find_item(search_string)
    return @items.find_all do |item|
      item.matches search_string
    end
  end

  def has_cart?
    return (not @cart.empty?)
  end

  def initialize
    @cart = Hash.new 0
    @items = ITEM_LIST
  end

  ##
  # Adapted from http://www.thaddeus.com/ftp/database/sushi.zip

  ITEM_LIST = [
    SushiNet::StoreItem.new('Aji', 'Horse Mackerel', 'This fish is pink-grey and shiny.  When it''s fresh, the flesh is almost transparent.  The texture is slippery and easy on the tongue--it should melt in your mouth.  Aji is often eaten with soy sauce containing onion, ginger and garlic.', 2.50),
    SushiNet::StoreItem.new('Akagai', 'Ark Shell Clam', 'The softest texture of any shellfish. Akagai has an attractive pink-orange color.  The taste is delicate and slightly sweet.', 3.00),
    SushiNet::StoreItem.new('Akami Maguro', 'Red Tuna', 'The lean meat near the spine of the tuna fish.  It comes in various shades of red--with the lighter, shinier varieties being the best.  For dieters, however, the redder the better.  Easy on the palatte.  The least expensive of the three types of maguro.', 1.50),
    SushiNet::StoreItem.new('Anago', 'Conger Eel', 'Anago is one of the few pre-cooked sushi.  It is grilled and basted with a thick teriyaki sauce.  The soft, slighty warm eel, the sweet soy sauce, and the vinegared rice make a particularly delicious sushi.', 3.00),
    SushiNet::StoreItem.new('Awabi', 'Abalone', 'Abalone or ''sea snail'', is another sushi favorite.  The color ranges from beige-grey to pinkish yellow.  Fresh abalone is not too rubbery, and is very subtle in flavor.', 3.00),
    SushiNet::StoreItem.new('California Roll', '', 'Rice, cucumber, crab meat, & avacado.', 2.50),
    SushiNet::StoreItem.new('Chakinzushi', 'Omlet-wrapped Sushi', 'Sushi rice in a thin omelet wrapper shaped and tied like a lady''s drawstring purse.  Sometimes a single pea or small shrimp decorates the ruffled part of the wrapper.', 3.00),
    SushiNet::StoreItem.new('Chutoro Maguro', 'Fatty Tuna', 'The moderately fatty part of the tuna belly.  It''s pink, but not the faint pink of ohtoro.  Soft, butter-like texture.  Moderately expensive.', 2.75),
    SushiNet::StoreItem.new('Ebi', 'Cooked Prawn', '', 2.25),
    SushiNet::StoreItem.new('Futo-Maki', 'Fat Rolls', 'Kampyo gourd, oboro or denbu pink powder, tamago omelet, and shiitake mushrooms. May also include bamboo shoots, cucumbers, cooked eel, cooked carrots, and cooked spinach or other greens.', 2.75),
    SushiNet::StoreItem.new('Geso Ika', 'Cuttlefish Tentacles', 'White in color, geso is boiled and brushed with thick teriyaki sauce before serving as sushi.  Its texture is chewy, and its mild flavor is complemented by the sweet-salty teriyaki.', 2.00),
    SushiNet::StoreItem.new('Hamachi', 'Yellowtail', '', 3.25),
    SushiNet::StoreItem.new('Himo Akagai', 'Ark Shell Filaments', 'This is the thread-like edges which connect the flesh to the shell.  A delicious, soft texture and mild taste.', 2.00),
    SushiNet::StoreItem.new('Hirame', 'Flounder', 'Good hirame is a sushi gourmet''s delight.  Since it''s cut from such a small part of the fish, it''s scarce and expensive.  In appearance, it''s pale pink and smooth, with no markings.  The taste is delicate and buttery.', 3.50),
    SushiNet::StoreItem.new('Hotategai', 'Scallop', 'The part of the scallop that is eaten is the edible adductor muscle that opens the animal''s shell.  It''s pale beige-yellow in color with a brown, crusty edging.  The taste is delicate, and melts in your mouth. ', 2.50),
    SushiNet::StoreItem.new('Ika', 'Cuttlefish', 'When fresh, cuttlefish is almost transparent.  It''s butter-like and melts in your mouth.  The texture is sticky.  Cuttlefish is smoky white and glistens. Also popular grilled and mixed with ginger soy sauce.  Also good with lemon for Western palettes.', 3.25),
    SushiNet::StoreItem.new('Ikura', 'Salmon Roe', 'Appealing to the eye with its bright red color.  Very appetizing with a delicate taste.', 3.25),
    SushiNet::StoreItem.new('Inarizushi', 'Stuffed Bean Curd Rolls', '', 2.00),
    SushiNet::StoreItem.new('Iwashi', 'Sardine', 'Shiny, slippery, and ''fishy,'', the taste of sardine sushi is slightly oily.  Sardine must be eaten shortly after it has been caught if it''s to be used in Sushi.  Often eaten with soy sauce mixed with ginger and onion.', 1.75),
    SushiNet::StoreItem.new('Kani', 'Crab', '', 2.50),
    SushiNet::StoreItem.new('Kappa Maki', 'Cucumber Rolls', '', 1.50),
    SushiNet::StoreItem.new('Katsuo', 'Bonito', '', 2.75),
    SushiNet::StoreItem.new('Kazunoko', 'Herring Roe', 'An expensive delicacy which is also known as ''yellow diamonds'', (because of the color and expense].  Revered in Japan, it''s usually eaten on special occasions.  An acquired taste for Westerners.', 4.75),
    SushiNet::StoreItem.new('Kisu', 'Sillago', 'A fresh Sillago has bright-gold skin. The taste is mild and delicate.', 2.25),
    SushiNet::StoreItem.new('Kobashira', 'Trough Shell (Small) Scallop', 'The edible adductor muscle that opens the shell of the aoyagi.  More prized than the aoyagi itself.', 5.00),
    SushiNet::StoreItem.new('Kohada', 'Gizzard Shad', 'This Japanese shad is a member of the herring family, and is a small silver-grey fish, with a black spotted back.  Marinated in vinegar and cross- hatched before serving.  The taste is strong, and a favorite for herring fans.', 2.75),
    SushiNet::StoreItem.new('Masago ', 'Capelin Roe', '', 3.50),
    SushiNet::StoreItem.new('Mirugai', 'Horse Clam', 'Also known as Geoduck.  This is a large, hard-shelled clam which is yellowish-white in color.  It has a slight ''shellfish'', taste and an elastic type texture. The part used in sushi is the long muscular siphon which projects from the shell.', 3.50),
    SushiNet::StoreItem.new('Ohtoro Maguro', 'Fattiest Tuna', 'Fattiest part of the fatty tuna belly.  It is light pink in color and melts in your mouth.  Mild with a rich texture.  This is the most expensive of the three types of Maguro sushi.', 3.25),
    SushiNet::StoreItem.new('Saba', 'Mackerel', '', 2.00),
    SushiNet::StoreItem.new('Sake', 'Salmon', '', 2.50),
    SushiNet::StoreItem.new('Sakura Denbu', 'Shredded Cod Fish', 'Seasoned shredded cod fish.', 2.00),
    SushiNet::StoreItem.new('Shima-Aji', 'Yellow Jack', 'A slice of white silvery shima-aji eaten with beef-steak plant and fresh ginger is delicious.  The flavor is delicate and the texture of good, fresh yellow jack is smooth and slides down easily.', 1.80),
    SushiNet::StoreItem.new('Shiro Maguro', 'Albacore Tuna', '', 3.00),
    SushiNet::StoreItem.new('Suzuki', 'Sea Bass', '', 3.00),
    SushiNet::StoreItem.new('Tai', 'Red Snapper', '', 2.50),
    SushiNet::StoreItem.new('Tekkamaki', 'Tuna Roll', 'Tuna wrapped in rice and nori.', 2.25),
    SushiNet::StoreItem.new('Tobiko ', 'Flying-Fish Roe', '', 3.50),
    SushiNet::StoreItem.new('Unagi', 'Freshwater Eel', '', 3.00),
    SushiNet::StoreItem.new('Uni', 'Sea Urchin Roe', 'A prized delicacy with its oily, rich texture.  Mustard color, paste-like topping is held in place by a band of nori seaweed.', 4.00)
  ]

end # class SushiNet::StoreSession

