/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class ReplicateScaleFilter
extends ImageFilter {
    protected int destHeight;
    protected int destWidth;
    protected int srcHeight;
    protected int srcWidth;
    protected int[] srcrows;
    protected int[] srccols;
    protected Object outpixbuf;

    public void setDimensions(int width, int height) {
        this.srcWidth = width;
        this.srcHeight = height;
        if (this.destWidth < 0 && this.destHeight < 0) {
            this.destWidth = width;
            this.destHeight = height;
        } else if (this.destWidth < 0) {
            this.destWidth = (int)((double)width * ((double)this.destHeight / (double)this.srcHeight));
        } else if (this.destHeight < 0) {
            this.destHeight = (int)((double)height * ((double)this.destWidth / (double)this.srcWidth));
        }
        if (this.consumer != null) {
            this.consumer.setDimensions(this.destWidth, this.destHeight);
        }
    }

    public void setProperties(Hashtable props) {
        props.put("filters", "ReplicateScaleFilter");
        if (this.consumer != null) {
            this.consumer.setProperties(props);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        double rx = (double)this.srcWidth / (double)this.destWidth;
        double ry = (double)this.srcHeight / (double)this.destHeight;
        int destScansize = (int)Math.round((double)scansize / rx);
        byte[] destPixels = this.replicatePixels(x, y, w, h, model, pixels, offset, scansize, rx, ry, destScansize);
        if (this.consumer != null) {
            this.consumer.setPixels((int)Math.floor((double)x / rx), (int)Math.floor((double)y / ry), (int)Math.ceil((double)w / rx), (int)Math.ceil((double)h / ry), model, destPixels, 0, destScansize);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        double rx = (double)this.srcWidth / (double)this.destWidth;
        double ry = (double)this.srcHeight / (double)this.destHeight;
        int destScansize = (int)Math.round((double)scansize / rx);
        int[] destPixels = this.replicatePixels(x, y, w, h, model, pixels, offset, scansize, rx, ry, destScansize);
        if (this.consumer != null) {
            this.consumer.setPixels((int)Math.floor((double)x / rx), (int)Math.floor((double)y / ry), (int)Math.ceil((double)w / rx), (int)Math.ceil((double)h / ry), model, destPixels, 0, destScansize);
        }
    }

    private final byte[] replicatePixels(int srcx, int srcy, int srcw, int srch, ColorModel model, byte[] srcPixels, int srcOffset, int srcScansize, double rx, double ry, int destScansize) {
        byte[] destPixels = new byte[(int)Math.ceil((double)srcw / rx) * (int)Math.ceil((double)srch / ry)];
        int i = 0;
        while (i < destPixels.length) {
            int a = (int)((double)((int)((double)i / (double)destScansize)) * ry) * srcScansize;
            int b = (int)((double)(i % destScansize) * rx);
            if (a + b + srcOffset < srcPixels.length) {
                destPixels[i] = srcPixels[a + b + srcOffset];
            }
            ++i;
        }
        return destPixels;
    }

    private final int[] replicatePixels(int srcx, int srcy, int srcw, int srch, ColorModel model, int[] srcPixels, int srcOffset, int srcScansize, double rx, double ry, int destScansize) {
        int[] destPixels = new int[(int)Math.ceil((double)srcw / rx) * (int)Math.ceil((double)srch / ry)];
        int i = 0;
        while (i < destPixels.length) {
            int a = (int)((double)((int)((double)i / (double)destScansize)) * ry) * srcScansize;
            int b = (int)((double)(i % destScansize) * rx);
            if (a + b + srcOffset < srcPixels.length) {
                destPixels[i] = srcPixels[a + b + srcOffset];
            }
            ++i;
        }
        return destPixels;
    }

    public ReplicateScaleFilter(int width, int height) {
        this.destHeight = height;
        this.destWidth = width;
    }
}

