/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Signer
extends Identity {
    private static final long serialVersionUID = -1763464102261361480L;
    private PrivateKey privateKey;

    public PrivateKey getPrivateKey() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("getSignerPrivateKey");
        }
        return this.privateKey;
    }

    public final void setKeyPair(KeyPair pair) throws InvalidParameterException, KeyException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("setSignerKeyPair");
        }
        try {
            if (pair.getPublic() == null) {
                throw new InvalidParameterException();
            }
            this.setPublicKey(pair.getPublic());
        }
        catch (KeyManagementException kme) {
            throw new KeyException();
        }
        if (pair.getPrivate() == null) {
            throw new InvalidParameterException();
        }
        this.privateKey = pair.getPrivate();
    }

    public String toString() {
        return this.getName() + ": " + this.privateKey;
    }

    private final /* synthetic */ void this() {
        this.privateKey = null;
    }

    protected Signer() {
        this.this();
    }

    public Signer(String name) {
        super(name);
        this.this();
    }

    public Signer(String name, IdentityScope scope) throws KeyManagementException {
        super(name, scope);
        this.this();
    }
}

