/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.gallery.GalleryRemote.CancellableTransferListener;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageLoaderUtil
implements PreferenceNames {
    public static final String MODULE = "ImgLoadrUtil";
    public SmartHashtable images = new SmartHashtable();
    public Image imageShowNow = null;
    public Picture pictureShowWant = null;
    public Picture pictureShowNow = null;
    public ImageLoader imageLoader = new ImageLoader();
    public static Color[] darkGray = new Color[11];
    public static Pattern breaker = Pattern.compile("<(br|BR)\\s?\\/?>");
    public static Pattern stripper = Pattern.compile("<[^<>]*>");
    int cacheSize = 10;
    boolean ignoreIMFailure = false;
    CancellableTransferListener transferListener = null;
    ImageLoaderUser imageLoaderUser = null;

    public ImageLoaderUtil(int cacheSize, ImageLoaderUser imageLoaderUser) {
        this.cacheSize = cacheSize;
        this.imageLoaderUser = imageLoaderUser;
    }

    public void setTransferListener(CancellableTransferListener transferListener) {
        this.transferListener = transferListener;
    }

    public void flushMemory() {
        this.images.clear();
        if (this.pictureShowNow != null) {
            this.pictureShowWant = null;
            this.imageShowNow = null;
            this.preparePicture(this.pictureShowNow, true, true);
            this.pictureShowNow = null;
        }
    }

    public void reduceMemory() {
        Log.log(3, MODULE, "Free memory before reduction: " + Runtime.getRuntime().freeMemory());
        Log.log(3, MODULE, "Current image cache: " + this.images.size() + " - cache size " + this.cacheSize);
        if (this.images.size() > 1 && this.cacheSize > 1) {
            this.cacheSize = this.images.size() - 1;
        }
        this.images.shrink();
        Log.log(3, MODULE, "Free memory after reduction: " + Runtime.getRuntime().freeMemory());
    }

    public void pictureReady(Image image, Picture picture) {
        if (!this.imageLoaderUser.blockPictureReady(image, picture)) {
            this.imageShowNow = image;
            this.pictureShowNow = picture;
            this.imageLoaderUser.pictureReady();
        }
    }

    public void preparePicture(Picture picture, boolean async, boolean notify) {
        if (picture == null) {
            this.pictureShowWant = null;
            this.imageLoaderUser.nullRect();
            if (notify) {
                this.pictureReady(null, null);
            }
        } else if (picture != this.pictureShowWant) {
            this.pictureShowWant = picture;
            Image r = (Image)this.images.get(picture);
            if (r != null) {
                Log.log(3, MODULE, "Cache hit: " + picture);
                if (notify) {
                    this.pictureReady(r, picture);
                }
            } else {
                Log.log(3, MODULE, "Cache miss: " + picture);
                if (async) {
                    this.imageLoader.loadPicture(picture, true);
                } else {
                    Image sizedIcon = this.getSizedIconForce(picture);
                    if (sizedIcon != null && notify) {
                        this.pictureReady(sizedIcon, picture);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getSizedIconForce(Picture picture) {
        Image r = (Image)this.images.get(picture);
        if (r != null) return r;
        Picture picture2 = picture;
        synchronized (picture2) {
            if (picture.isOnline()) {
                this.imageLoaderUser.pictureStartDownloading(picture);
                File f = ImageUtils.download(picture, this.imageLoaderUser.getImageSize(), GalleryRemote._().getCore().getMainStatusUpdate(), this.transferListener);
                this.imageLoaderUser.pictureStartProcessing(picture);
                if (f == null) return null;
                r = ImageUtils.load(f.getPath(), this.imageLoaderUser.getImageSize(), 1, this.ignoreIMFailure);
            } else {
                this.imageLoaderUser.pictureStartProcessing(picture);
                r = ImageUtils.load(picture.getSource().getPath(), this.imageLoaderUser.getImageSize(), 1, this.ignoreIMFailure);
            }
            if (r == null) {
                this.imageLoaderUser.pictureLoadError(picture);
            }
            Log.log(3, MODULE, "Adding to cache: " + picture);
            this.images.put(picture, r);
            return r;
        }
    }

    public static void paintAlignedOutline(Graphics g, String s, int textX, int textY, int thickness, int position, int wrapWidth) {
        ImageLoaderUtil.paintAlignedOutline(g, textX, textY, thickness, position, ImageLoaderUtil.wrap((Graphics2D)g, s, wrapWidth), false);
    }

    public static Point paintAlignedOutline(Graphics g, int textX, int textY, int thickness, int position, WrapInfo wrapInfo, boolean paintAtOrigin) {
        FontMetrics fm = g.getFontMetrics();
        Point boxPos = new Point();
        switch (position / 10) {
            default: {
                boxPos.y = textY;
                break;
            }
            case 2: {
                boxPos.y = textY - wrapInfo.height / 2;
                break;
            }
            case 3: {
                boxPos.y = textY - wrapInfo.height;
            }
        }
        switch (position % 10) {
            default: {
                boxPos.x = textX;
                break;
            }
            case 0: {
                boxPos.x = textX - wrapInfo.width / 2;
                break;
            }
            case 4: {
                boxPos.x = textX - wrapInfo.width;
            }
        }
        for (int i = 0; i < wrapInfo.lines.length; ++i) {
            Rectangle2D bounds = fm.getStringBounds(wrapInfo.lines[i], g);
            Point linePos = new Point(boxPos);
            if (paintAtOrigin) {
                linePos.x = thickness;
                linePos.y = thickness;
            }
            switch (position % 10) {
                default: {
                    break;
                }
                case 0: {
                    linePos.x = (int)((double)linePos.x + ((double)wrapInfo.width - bounds.getWidth()) / 2.0);
                    break;
                }
                case 4: {
                    linePos.x = (int)((double)linePos.x + ((double)wrapInfo.width - bounds.getWidth()));
                }
            }
            ImageLoaderUtil.paintOutline(g, wrapInfo.lines[i], linePos.x, (int)((double)(linePos.y + fm.getAscent()) + bounds.getHeight() * (double)i), thickness);
        }
        return boxPos;
    }

    public static WrapInfo wrap(Graphics2D g, String s, int wrapWidth) {
        WrapInfo wrapInfo = new WrapInfo();
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(s, g);
        String[] ss = s.split("\n");
        ArrayList<String> lines = new ArrayList<String>(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            int linebreak = ss[i].length() - 1;
            while (linebreak != -1 && fm.getStringBounds(ss[i].substring(0, linebreak), g).getWidth() > (double)wrapWidth) {
                linebreak = ss[i].lastIndexOf(32, linebreak - 1);
            }
            if (linebreak != -1 && linebreak != ss[i].length() - 1) {
                lines.add(ss[i].substring(0, linebreak));
                ss[i] = ss[i].substring(linebreak + 1);
                --i;
            } else {
                lines.add(ss[i]);
            }
            int width = (int)fm.getStringBounds((String)lines.get(lines.size() - 1), g).getWidth();
            if (width <= wrapInfo.width) continue;
            wrapInfo.width = width;
        }
        wrapInfo.lines = lines.toArray(new String[lines.size()]);
        wrapInfo.height = (int)bounds.getHeight() * ss.length;
        return wrapInfo;
    }

    public static void paintOutline(Graphics g, String s, int textX, int textY, int thickness) {
        if (thickness > 10) {
            thickness = 10;
        }
        if (thickness > 0) {
            g.setColor(ImageLoaderUtil.getDarkGray(thickness));
            for (int i = -thickness; i <= thickness; ++i) {
                for (int j = -thickness; j <= thickness; ++j) {
                    if (i == 0 && j == 0) continue;
                    g.drawString(s, textX + i, textY + j);
                }
            }
        }
        g.setColor(Color.white);
        g.drawString(s, textX, textY);
    }

    private static Color getDarkGray(int thickness) {
        if (darkGray[thickness] == null) {
            ImageLoaderUtil.darkGray[thickness] = new Color(64, 64, 64, 255 / thickness / thickness);
        }
        return darkGray[thickness];
    }

    public static void setSlideshowFont(Component c) {
        String fontName = GalleryRemote._().properties.getProperty("slideshowFontName");
        int defaultFontSize = (int)DialogUtil.findParentWindow(c).getGraphicsConfiguration().getBounds().getHeight() / 40;
        int fontSize = GalleryRemote._().properties.getIntProperty("slideshowFontSize", defaultFontSize);
        Font f = null;
        if (fontName != null) {
            f = new Font(fontName, 0, fontSize);
        } else if (fontSize != c.getFont().getSize()) {
            f = c.getFont().deriveFont((float)fontSize + 0.0f);
        }
        if (f != null) {
            c.setFont(f);
        }
    }

    public static String stripTags(String text) {
        if (text == null) {
            return null;
        }
        Matcher m = breaker.matcher(text);
        text = m.replaceAll("\n");
        m = stripper.matcher(text);
        text = m.replaceAll("");
        return text;
    }

    public static interface ImageLoaderUser {
        public void pictureReady();

        public boolean blockPictureReady(Image var1, Picture var2);

        public Dimension getImageSize();

        public void nullRect();

        public void pictureStartDownloading(Picture var1);

        public void pictureStartProcessing(Picture var1);

        public void pictureLoadError(Picture var1);
    }

    public class SmartHashtable
    extends HashMap {
        ArrayList touchOrder = new ArrayList();

        public Object put(Object key, Object value) {
            this.touch(key);
            super.put(key, value);
            if (ImageLoaderUtil.this.cacheSize > 0 && this.touchOrder.size() > ImageLoaderUtil.this.cacheSize) {
                this.shrink();
            }
            return value;
        }

        public Object get(Object key) {
            return this.get(key, true);
        }

        public Object get(Object key, boolean touch) {
            Object result = super.get(key);
            if (result != null && touch) {
                this.touch(key);
            }
            return result;
        }

        public void clear() {
            Iterator it = this.values().iterator();
            while (it.hasNext()) {
                Image i = (Image)it.next();
                if (i == null) continue;
                i.flush();
            }
            super.clear();
            this.touchOrder.clear();
            System.runFinalization();
            System.gc();
        }

        public void touch(Object key) {
            Log.log(3, ImageLoaderUtil.MODULE, "touch " + key);
            int i = this.touchOrder.indexOf(key);
            if (i != -1) {
                this.touchOrder.remove(i);
            }
            this.touchOrder.add(key);
        }

        public void shrink() {
            if (this.touchOrder.size() == 0) {
                Log.log(1, ImageLoaderUtil.MODULE, "Empty SmartHashtable");
                return;
            }
            Object key = this.touchOrder.get(0);
            this.touchOrder.remove(0);
            Image i = (Image)this.get(key, false);
            if (i != null) {
                i.flush();
            }
            this.remove(key);
            Log.log(3, ImageLoaderUtil.MODULE, "Shrunk " + key);
            if (ImageLoaderUtil.this.cacheSize > 0 && this.size() > ImageLoaderUtil.this.cacheSize) {
                this.shrink();
            } else {
                System.runFinalization();
                System.gc();
            }
        }
    }

    public class ImageLoader
    implements Runnable {
        Picture picture;
        boolean stillRunning = false;
        boolean notify = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.log(3, ImageLoaderUtil.MODULE, "Starting " + this.picture);
            Picture tmpPicture = null;
            Image tmpImage = null;
            while (this.picture != null) {
                ImageLoader imageLoader = this;
                synchronized (imageLoader) {
                    tmpPicture = this.picture;
                    this.picture = null;
                }
                tmpImage = ImageLoaderUtil.this.getSizedIconForce(tmpPicture);
                if (tmpImage != null) continue;
                this.notify = false;
            }
            this.stillRunning = false;
            if (this.notify) {
                ImageLoaderUtil.this.pictureReady(tmpImage, tmpPicture);
                this.notify = false;
            }
            Log.log(3, ImageLoaderUtil.MODULE, "Ending");
        }

        public void loadPicture(Picture picture, boolean notify) {
            Log.log(3, ImageLoaderUtil.MODULE, "loadPicture " + picture);
            this.picture = picture;
            if (notify) {
                this.notify = true;
            }
            if (!this.stillRunning) {
                this.stillRunning = true;
                Log.log(3, ImageLoaderUtil.MODULE, "Calling Start");
                new Thread(this).start();
            }
        }
    }

    public static class WrapInfo {
        public String[] lines;
        public int width;
        public int height;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("WrapInfo");
            sb.append("{lines=").append(this.lines == null ? "null" : Arrays.asList(this.lines).toString());
            sb.append(", width=").append(this.width);
            sb.append(", height=").append(this.height);
            sb.append('}');
            return sb.toString();
        }
    }
}

