/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.predictions;

import com.google.protobuf.ByteString;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.campagnelab.dl.varanalysis.protobuf.BaseInformationRecords;
import org.campagnelab.goby.algorithmic.dsv.DiscoverVariantPositionData;
import org.campagnelab.goby.algorithmic.dsv.SampleCountInfo;
import org.campagnelab.goby.algorithmic.indels.EquivalentIndelRegion;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.PositionBaseInfo;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;
import org.campagnelab.goby.util.BaseToStringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoHelper {
    public static final int POSITIVE_STRAND = 0;
    public static final int NEGATIVE_STRAND = 1;
    private static final Logger LOG = LoggerFactory.getLogger(ProtoHelper.class);
    private static ProgressLogger baseProgressLogger = new ProgressLogger(LOG);
    private static MutableString genomicContext;
    private static BaseToStringHelper baseConversion;
    private static Random random;
    static Int2IntMap freqMap;

    private static String defaultGenomicContext(int contextLength) {
        String defaultGenomicContext = "";
        for (int i = 0; i < contextLength; ++i) {
            defaultGenomicContext = defaultGenomicContext + "N";
        }
        return defaultGenomicContext;
    }

    public static BaseInformationRecords.BaseInformation toProto(RandomAccessSequenceInterface genome, String referenceID, SampleCountInfo[] sampleCounts, int referenceIndex, int position, DiscoverVariantPositionData list, Integer[] sampleToReaderIdxs) {
        return ProtoHelper.toProto(genome, referenceID, sampleCounts, referenceIndex, position, list, sampleToReaderIdxs, 21);
    }

    public static BaseInformationRecords.BaseInformation toProto(RandomAccessSequenceInterface genome, String referenceID, SampleCountInfo[] sampleCounts, int referenceIndex, int position, DiscoverVariantPositionData list, Integer[] sampleIndicesToProcess, int contextLength) {
        SampleCountInfo[] reducedSampleCountArray = new SampleCountInfo[sampleIndicesToProcess.length];
        IntArrayList sampleIndicesToProcessList = new IntArrayList();
        sampleIndicesToProcessList.addAll(Arrays.asList(sampleIndicesToProcess));
        Integer[] integerArray = sampleIndicesToProcess;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int originalSampleIndex = integerArray[i];
            int reducedSampleIndex = sampleIndicesToProcessList.indexOf(originalSampleIndex);
            reducedSampleCountArray[reducedSampleIndex] = sampleCounts[originalSampleIndex];
        }
        DiscoverVariantPositionData newList = new DiscoverVariantPositionData(list.getZeroBasedPosition(), list.getReferenceBase());
        ObjectListIterator objectListIterator = list.iterator();
        while (objectListIterator.hasNext()) {
            int reducedSampleIndex;
            PositionBaseInfo baseInfo = (PositionBaseInfo)objectListIterator.next();
            PositionBaseInfo copy = new PositionBaseInfo(baseInfo);
            int originalSampleIndex = baseInfo.readerIndex;
            if (!sampleIndicesToProcessList.contains(originalSampleIndex)) continue;
            copy.readerIndex = reducedSampleIndex = sampleIndicesToProcessList.indexOf(originalSampleIndex);
            newList.add(copy);
        }
        return ProtoHelper.toProto(genome, referenceID, reducedSampleCountArray, referenceIndex, position, newList, contextLength);
    }

    public static BaseInformationRecords.BaseInformation toProto(RandomAccessSequenceInterface genome, String referenceID, SampleCountInfo[] sampleCounts, int referenceIndex, int position, DiscoverVariantPositionData list, int contextLength) {
        int numSamples = sampleCounts.length;
        int maxGenotypeIndex = 0;
        for (int sampleIndex = 0; sampleIndex < numSamples; ++sampleIndex) {
            SampleCountInfo sampleCountInfo = sampleCounts[sampleIndex];
            maxGenotypeIndex = Math.max(sampleCountInfo.getGenotypeMaxIndex(), maxGenotypeIndex);
        }
        IntArrayList[][][] qualityScores = new IntArrayList[numSamples][maxGenotypeIndex][2];
        IntArrayList[][][] readMappingQuality = new IntArrayList[numSamples][maxGenotypeIndex][2];
        IntArrayList[][][] readIdxs = new IntArrayList[numSamples][maxGenotypeIndex][2];
        IntArrayList[][][] distancesToReadVariations = new IntArrayList[numSamples][maxGenotypeIndex][2];
        IntArrayList[][] distancesToStartOfRead = new IntArrayList[numSamples][maxGenotypeIndex];
        IntArrayList[][] distancesToEndOfRead = new IntArrayList[numSamples][maxGenotypeIndex];
        IntArrayList[][] numVariationsInReads = new IntArrayList[numSamples][maxGenotypeIndex];
        IntArrayList[][] insertSizes = new IntArrayList[numSamples][maxGenotypeIndex];
        IntArrayList[][] targetAlignedLengths = new IntArrayList[numSamples][maxGenotypeIndex];
        IntArrayList[][] queryAlignedLengths = new IntArrayList[numSamples][maxGenotypeIndex];
        IntArrayList[][] queryPositions = new IntArrayList[numSamples][maxGenotypeIndex];
        IntArrayList[][] pairFlags = new IntArrayList[numSamples][maxGenotypeIndex];
        for (int sampleIndex = 0; sampleIndex < numSamples; ++sampleIndex) {
            for (int genotypeIndex = 0; genotypeIndex < maxGenotypeIndex; ++genotypeIndex) {
                for (int strandIndex = 0; strandIndex < 2; ++strandIndex) {
                    qualityScores[sampleIndex][genotypeIndex][strandIndex] = new IntArrayList(1024);
                    readMappingQuality[sampleIndex][genotypeIndex][strandIndex] = new IntArrayList(1024);
                    readIdxs[sampleIndex][genotypeIndex][strandIndex] = new IntArrayList(1024);
                    distancesToReadVariations[sampleIndex][genotypeIndex][strandIndex] = new IntArrayList(1024);
                    distancesToStartOfRead[sampleIndex][genotypeIndex] = new IntArrayList(1024);
                    distancesToEndOfRead[sampleIndex][genotypeIndex] = new IntArrayList(1024);
                    numVariationsInReads[sampleIndex][genotypeIndex] = new IntArrayList(1024);
                    insertSizes[sampleIndex][genotypeIndex] = new IntArrayList(1024);
                    targetAlignedLengths[sampleIndex][genotypeIndex] = new IntArrayList(1024);
                    queryAlignedLengths[sampleIndex][genotypeIndex] = new IntArrayList(1024);
                    queryPositions[sampleIndex][genotypeIndex] = new IntArrayList(1024);
                    pairFlags[sampleIndex][genotypeIndex] = new IntArrayList(1024);
                }
            }
        }
        ObjectListIterator sampleIndex = list.iterator();
        while (sampleIndex.hasNext()) {
            PositionBaseInfo baseInfo = (PositionBaseInfo)sampleIndex.next();
            int baseIndex = sampleCounts[baseInfo.readerIndex].baseIndex(baseInfo.to);
            int sampleIndex2 = baseInfo.readerIndex;
            if (sampleIndex2 == -1) continue;
            int strandInd = baseInfo.matchesForwardStrand ? 0 : 1;
            qualityScores[sampleIndex2][baseIndex][strandInd].add(baseInfo.qualityScore & 0xFF);
            readMappingQuality[sampleIndex2][baseIndex][strandInd].add(baseInfo.readMappingQuality & 0xFF);
            numVariationsInReads[sampleIndex2][baseIndex].add(baseInfo.numVariationsInRead);
            int queryLength = baseInfo.alignmentEntry.getQueryLength();
            int distanceToStartOfRead = baseInfo.matchesForwardStrand ? baseInfo.readIndex : queryLength - baseInfo.readIndex;
            int distanceToEndOfRead = baseInfo.matchesForwardStrand ? queryLength - baseInfo.readIndex : baseInfo.readIndex;
            distancesToStartOfRead[sampleIndex2][baseIndex].add(distanceToStartOfRead);
            distancesToEndOfRead[sampleIndex2][baseIndex].add(distanceToEndOfRead);
            insertSizes[sampleIndex2][baseIndex].add(baseInfo.insertSize);
            targetAlignedLengths[sampleIndex2][baseIndex].add(baseInfo.alignmentEntry.getTargetAlignedLength());
            readIdxs[sampleIndex2][baseIndex][strandInd].add(baseInfo.readIndex);
            for (Alignments.SequenceVariation var : baseInfo.alignmentEntry.getSequenceVariationsList()) {
                int varIndex = var.getReadIndex();
                int delta = baseInfo.readIndex - varIndex;
                distancesToReadVariations[sampleIndex2][baseIndex][strandInd].add(delta);
            }
            targetAlignedLengths[sampleIndex2][baseIndex].add(baseInfo.alignmentEntry.getTargetAlignedLength());
            queryAlignedLengths[sampleIndex2][baseIndex].add(baseInfo.alignmentEntry.getQueryAlignedLength());
            queryPositions[sampleIndex2][baseIndex].add(baseInfo.alignmentEntry.getQueryPosition());
            pairFlags[sampleIndex2][baseIndex].add(baseInfo.alignmentEntry.getPairFlags());
        }
        for (int sampleIndex3 = 0; sampleIndex3 < numSamples; ++sampleIndex3) {
            Object2IntArrayMap indelIndices = new Object2IntArrayMap();
            for (int i = 5; i < maxGenotypeIndex; ++i) {
                indelIndices.put((Object)sampleCounts[0].getIndelGenotype(i), i);
            }
            if (sampleCounts[sampleIndex3].getEquivalentIndelRegions() == null) continue;
            for (EquivalentIndelRegion eqr : sampleCounts[sampleIndex3].getEquivalentIndelRegions()) {
                int baseIndex = indelIndices.getInt((Object)eqr);
                readIdxs[sampleIndex3][baseIndex][0].addAll((IntCollection)eqr.forwardReadIndices);
                readIdxs[sampleIndex3][baseIndex][1].addAll((IntCollection)eqr.reverseReadIndices);
                for (Alignments.AlignmentEntry entry : eqr.supportingEntries) {
                    int strandInd = entry.getMatchingReverseStrand() ? 1 : 0;
                    readMappingQuality[sampleIndex3][baseIndex][strandInd].add(entry.getMappingQuality() & 0xFF);
                    numVariationsInReads[sampleIndex3][baseIndex].add(entry.getSequenceVariationsCount());
                    insertSizes[sampleIndex3][baseIndex].add(entry.getInsertSize());
                    targetAlignedLengths[sampleIndex3][baseIndex].add(entry.getTargetAlignedLength());
                    Integer indelReadIndex = null;
                    for (Alignments.SequenceVariation var : entry.getSequenceVariationsList()) {
                        if (!var.getTo().equals(eqr.to) || !var.getFrom().equals(eqr.from) || !eqr.forwardReadIndices.contains(var.getReadIndex()) && !eqr.forwardReadIndices.contains(var.getReadIndex())) continue;
                        indelReadIndex = var.getReadIndex();
                    }
                    for (Alignments.SequenceVariation var : entry.getSequenceVariationsList()) {
                        if (var.getTo().equals(eqr.to) && var.getFrom().equals(eqr.from) || indelReadIndex == null) continue;
                        int varIndex = var.getReadIndex();
                        int delta = indelReadIndex - varIndex;
                        distancesToReadVariations[sampleIndex3][baseIndex][strandInd].add(delta);
                        if (!var.hasToQuality()) continue;
                        ByteString.ByteIterator byteIterator = var.getToQuality().iterator();
                        while (byteIterator.hasNext()) {
                            byte quality = (Byte)byteIterator.next();
                            qualityScores[sampleIndex3][baseIndex][strandInd].add(quality & 0xFF);
                        }
                    }
                    targetAlignedLengths[sampleIndex3][baseIndex].add(entry.getTargetAlignedLength());
                    queryAlignedLengths[sampleIndex3][baseIndex].add(entry.getQueryAlignedLength());
                    queryPositions[sampleIndex3][baseIndex].add(entry.getQueryPosition());
                    pairFlags[sampleIndex3][baseIndex].add(entry.getPairFlags());
                }
            }
        }
        BaseInformationRecords.BaseInformation.Builder builder = BaseInformationRecords.BaseInformation.newBuilder();
        builder.setMutated(false);
        builder.setPosition(position);
        builder.setReferenceId(referenceID);
        int genomeReferenceIndex = genome.getReferenceIndex(referenceID);
        ProtoHelper.transferGenomicContext(contextLength, genome, genomeReferenceIndex, position, list, builder, sampleCounts);
        builder.setReferenceIndex(referenceIndex);
        for (int sampleIndex4 = 0; sampleIndex4 < numSamples; ++sampleIndex4) {
            BaseInformationRecords.SampleInfo.Builder sampleBuilder = BaseInformationRecords.SampleInfo.newBuilder();
            if (sampleIndex4 == numSamples - 1) {
                sampleBuilder.setIsTumor(true);
            }
            SampleCountInfo sampleCountInfo = sampleCounts[sampleIndex4];
            String referenceGenotype = null;
            int genotypeMaxIndex = sampleCountInfo.getGenotypeMaxIndex();
            ProtoHelper.transfer(qualityScores[sampleIndex4], readMappingQuality[sampleIndex4], readIdxs[sampleIndex4], distancesToReadVariations[sampleIndex4], distancesToStartOfRead[sampleIndex4], distancesToEndOfRead[sampleIndex4], numVariationsInReads[sampleIndex4], insertSizes[sampleIndex4], targetAlignedLengths[sampleIndex4], queryAlignedLengths[sampleIndex4], queryPositions[sampleIndex4], pairFlags[sampleIndex4], sampleBuilder, sampleCountInfo, referenceGenotype, maxGenotypeIndex);
            sampleBuilder.setFormattedCounts(sampleCounts[sampleIndex4].toString());
            builder.addSamples(sampleBuilder.build());
        }
        baseProgressLogger.update((long)list.size());
        list.clear();
        return builder.build();
    }

    private static void transferGenomicContext(int contextLength, RandomAccessSequenceInterface genome, int genomeReferenceIndex, int position, DiscoverVariantPositionData list, BaseInformationRecords.BaseInformation.Builder builder, SampleCountInfo[] sampleCounts) {
        genomicContext.setLength(0);
        int referenceSequenceLength = genome.getLength(genomeReferenceIndex);
        if (referenceSequenceLength <= 0) {
            builder.setGenomicSequenceContext(ProtoHelper.defaultGenomicContext(contextLength));
        } else {
            int i;
            int cl = (contextLength - 1) / 2;
            int genomicStart = Math.max(position - cl, 0);
            int genomicEnd = Math.min(position + (cl + 1), referenceSequenceLength);
            int index = 0;
            for (int refPos = genomicStart; refPos < genomicEnd; ++refPos) {
                genomicContext.insert(index++, baseConversion.convert(genome.get(genomeReferenceIndex, refPos)));
            }
            for (i = genomicStart; i < 0; ++i) {
                genomicContext.insert(0, "N");
            }
            index = genomicContext.length();
            for (i = genomicEnd; i > referenceSequenceLength; --i) {
                genomicContext.insert(index++, "N");
            }
            builder.setGenomicSequenceContext(contextLength == genomicContext.length() ? genomicContext.toString() : ProtoHelper.defaultGenomicContext(contextLength));
        }
        String refBase = baseConversion.convert(list.getReferenceBase());
        if (refBase == null) {
            String referenceGenotype = sampleCounts[0].getReferenceGenotype();
            refBase = referenceGenotype.length() >= 1 ? sampleCounts[0].getReferenceGenotype().substring(0, 1) : Character.toString(genome.get(genomeReferenceIndex, position));
        }
        builder.setReferenceBase(refBase);
    }

    private static void transfer(IntArrayList[][] qualityScore, IntArrayList[][] intArrayLists, IntArrayList[][] readIdx, IntArrayList[][] distancesToReadVariations, IntArrayList[] distancesToStartOfRead, IntArrayList[] distancesToEndOfRead, IntArrayList[] numVariationsInRead, IntArrayList[] insertSize, IntArrayList[] targetAlignedLength, IntArrayList[] queryAlignedLength, IntArrayList[] queryPositions, IntArrayList[] pairFlags, BaseInformationRecords.SampleInfo.Builder sampleBuilder, SampleCountInfo sampleCountInfo, String referenceGenotype, int genotypeMaxIndex) {
        for (int genotypeIndex = 0; genotypeIndex < genotypeMaxIndex; ++genotypeIndex) {
            BaseInformationRecords.CountInfo.Builder infoBuilder = BaseInformationRecords.CountInfo.newBuilder();
            if (genotypeIndex == 0) {
                referenceGenotype = sampleCountInfo.getReferenceGenotype();
            }
            if (genotypeIndex < 5) {
                try {
                    infoBuilder.setFromSequence(referenceGenotype.substring(0, 1));
                }
                catch (NullPointerException e) {
                    infoBuilder.setFromSequence("");
                }
            } else {
                infoBuilder.setFromSequence(sampleCountInfo.getIndelGenotype(genotypeIndex).fromInContext());
            }
            infoBuilder.setToSequence(sampleCountInfo.getGenotypeString(genotypeIndex));
            infoBuilder.setMatchesReference(sampleCountInfo.isReferenceGenotype(genotypeIndex));
            infoBuilder.setGenotypeCountForwardStrand(sampleCountInfo.getGenotypeCount(genotypeIndex, true));
            infoBuilder.setGenotypeCountReverseStrand(sampleCountInfo.getGenotypeCount(genotypeIndex, false));
            infoBuilder.addAllQualityScoresForwardStrand(ProtoHelper.compressFreq((List<Integer>)qualityScore[genotypeIndex][0]));
            infoBuilder.addAllQualityScoresReverseStrand(ProtoHelper.compressFreq((List<Integer>)qualityScore[genotypeIndex][1]));
            infoBuilder.addAllReadIndicesForwardStrand(ProtoHelper.compressFreq((List<Integer>)readIdx[genotypeIndex][0]));
            infoBuilder.addAllReadIndicesReverseStrand(ProtoHelper.compressFreq((List<Integer>)readIdx[genotypeIndex][1]));
            infoBuilder.addAllDistancesToReadVariationsForwardStrand(ProtoHelper.compressFreq((List<Integer>)distancesToReadVariations[genotypeIndex][0]));
            infoBuilder.addAllDistancesToReadVariationsReverseStrand(ProtoHelper.compressFreq((List<Integer>)distancesToReadVariations[genotypeIndex][1]));
            infoBuilder.addAllReadMappingQualityForwardStrand(ProtoHelper.compressFreq((List<Integer>)intArrayLists[genotypeIndex][0]));
            infoBuilder.addAllReadMappingQualityReverseStrand(ProtoHelper.compressFreq((List<Integer>)intArrayLists[genotypeIndex][1]));
            infoBuilder.addAllNumVariationsInReads(ProtoHelper.compressFreq((List<Integer>)numVariationsInRead[genotypeIndex]));
            infoBuilder.addAllInsertSizes(ProtoHelper.compressFreq((List<Integer>)insertSize[genotypeIndex]));
            infoBuilder.addAllTargetAlignedLengths(ProtoHelper.compressFreq((List<Integer>)targetAlignedLength[genotypeIndex]));
            infoBuilder.addAllQueryAlignedLengths(ProtoHelper.compressFreq((List<Integer>)queryAlignedLength[genotypeIndex]));
            infoBuilder.addAllQueryPositions(ProtoHelper.compressFreq((List<Integer>)queryPositions[genotypeIndex]));
            infoBuilder.addAllPairFlags(ProtoHelper.compressFreq((List<Integer>)pairFlags[genotypeIndex]));
            infoBuilder.addAllDistanceToStartOfRead(ProtoHelper.compressFreq((List<Integer>)distancesToStartOfRead[genotypeIndex]));
            infoBuilder.addAllDistanceToEndOfRead(ProtoHelper.compressFreq((List<Integer>)distancesToEndOfRead[genotypeIndex]));
            infoBuilder.setIsIndel(sampleCountInfo.isIndel(genotypeIndex));
            sampleBuilder.addCounts(infoBuilder.build());
        }
    }

    public static List<BaseInformationRecords.NumberWithFrequency> compressFreq(List<Integer> numList) {
        freqMap.clear();
        for (int num : numList) {
            int freq = (Integer)freqMap.getOrDefault((Object)num, (Object)0);
            freqMap.put(num, freq + 1);
        }
        ObjectArrayList freqList = new ObjectArrayList(freqMap.size());
        for (Int2IntMap.Entry entry : freqMap.int2IntEntrySet()) {
            BaseInformationRecords.NumberWithFrequency.Builder freqBuilder = BaseInformationRecords.NumberWithFrequency.newBuilder();
            freqBuilder.setFrequency(entry.getIntValue());
            freqBuilder.setNumber(entry.getIntKey());
            freqList.add(freqBuilder.build());
        }
        return freqList;
    }

    static {
        ProtoHelper.baseProgressLogger.displayLocalSpeed = true;
        baseProgressLogger.start();
        genomicContext = new MutableString();
        baseConversion = new BaseToStringHelper();
        random = new Random();
        freqMap = new Int2IntAVLTreeMap();
    }
}

