#ifndef __STK2_LOOPER
#define __STK2_LOOPER


/* This is code aims to develop a looper object */


#include "stk_thread.h"

#include <list>
#include <string>
using namespace std;





class Stk2_Message
{
public:
    Stk2_Message(int);
    int what;
};






/** This object is used to represent a list of messages. This object is protected by
    a mutex to allow multiple threads to use it.
*/
class Stk2_Messages : public Stk_Mutex, protected list<Stk2_Message *>
{ 
public:
        /// Constructor
    Stk2_Messages();
        /// Destructor
    ~Stk2_Messages();

        /// Add a message in this list
    void AddMessage(Stk2_Message *);

        /** Poll a message (this is removed from the list). if the result
            is null, there is no message in the list */
    int PollMessage(Stk2_Message *&);
    
};



/** The Looper class. This class encapsulates a thread. When you instanciate an object, it
    creates a looper.
*/
class Stk2_Looper : public Stk_Thread, public Stk2_Messages
{
public:
        /// Constructor
    Stk2_Looper(int freq=25);
        /// Destructor
    virtual ~Stk2_Looper();

        /// This function is called frequency times per second
    virtual void Loop();
    
        /// Quit the looper
    void Quit();

        /// Send a message to the looper
    virtual void SendMessage(Stk2_Message *);
    
private:
            // Thread function
    int function();
        // Thread information
    int frequency;
    int end;
    int ended;
};


#endif
