#ifndef __STK_TIME
#define __STK_TIME

#include <stdlib.h>
#include <stdio.h>

#ifndef  WIN32 
#include <sys/time.h>
#endif

#ifdef WIN32
#include <time.h>
#include <sys/types.h>
#include <sys/timeb.h>
#endif


struct stk_time
{
	long time;
	int millitm;
};

/** This class Define a Timer. His reference time
    is the instant when the constructor is called.
 */
class Stk_Timer
{
public:
        /// Constructor: the timer start
    Stk_Timer();
        /// Give the time elapsed in millisecond
    long GetTime() const;

private:
#ifdef WIN32
	stk_time start;
#else if
        // date of birth of timer
    struct timeval start;
#endif
};



#endif
