/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import java.io.IOException;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentReaderFactory;
import org.campagnelab.goby.alignments.GenomicRange;

public class FileSlice {
    public long startOffset;
    public long endOffset;
    public String basename;

    public FileSlice(long startOffset, long endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public FileSlice(long startOffset, long endOffset, String basename) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.basename = basename;
    }

    public static FileSlice COMPLETE_FILE(String basename) {
        return new FileSlice(0L, Long.MAX_VALUE, basename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSlice getSlice(AlignmentReaderFactory factory, String basename, GenomicRange range) throws IOException {
        if (range == null) {
            return FileSlice.COMPLETE_FILE(basename);
        }
        try (AlignmentReader reader = null;){
            reader = factory.createReader(basename);
            reader.readHeader();
            DoubleIndexedIdentifier ids = new DoubleIndexedIdentifier(reader.getTargetIdentifiers());
            range.resolveChromosomeIndices(ids);
            reader.readIndex();
            long startOffset = reader.getStartByteOffset(range.startReferenceIndex, range.startPosition);
            long endOffset = reader.getEndByteOffset(range.startReferenceIndex, range.startPosition, range.endReferenceIndex, range.endPosition);
            if (startOffset == Long.MIN_VALUE) {
                startOffset = 0L;
            }
            FileSlice fileSlice = new FileSlice(startOffset, endOffset, basename);
            return fileSlice;
        }
    }
}

