<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Settings for the recentlyaccessedcourses block
 *
 * @package    block_recentlyaccessedcourses
 * @copyright  2019 Mihail Geshoski <mihail@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

if ($ADMIN->fulltree) {
    // Display Course Categories on the recently accessed courses block items.
    $settings->add(new admin_setting_configcheckbox(
        'block_recentlyaccessedcourses/displaycategories',
        get_string('displaycategories', 'block_recentlyaccessedcourses'),
        get_string('displaycategories_help', 'block_recentlyaccessedcourses'),
        1));
}
