define("tiny_html/codemirror-lazy",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.lang=_exports.basicSetup=_exports.EditorView=_exports.EditorState=void 0;class Text{lineAt(pos){if(pos<0||pos>this.length)throw new RangeError("Invalid position ".concat(pos," in document of length ").concat(this.length));return this.lineInner(pos,!1,1,0)}line(n){if(n<1||n>this.lines)throw new RangeError("Invalid line number ".concat(n," in ").concat(this.lines,"-line document"));return this.lineInner(n,!0,1,0)}replace(from,to,text){let parts=[];return this.decompose(0,from,parts,2),text.length&&text.decompose(0,text.length,parts,3),this.decompose(to,this.length,parts,1),TextNode.from(parts,this.length-(to-from)+text.length)}append(other){return this.replace(this.length,this.length,other)}slice(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.length,parts=[];return this.decompose(from,to,parts,0),TextNode.from(parts,to-from)}eq(other){if(other==this)return!0;if(other.length!=this.length||other.lines!=this.lines)return!1;let start=this.scanIdentical(other,1),end=this.length-this.scanIdentical(other,-1),a=new RawTextCursor(this),b=new RawTextCursor(other);for(let skip=start,pos=start;;){if(a.next(skip),b.next(skip),skip=0,a.lineBreak!=b.lineBreak||a.done!=b.done||a.value!=b.value)return!1;if(pos+=a.value.length,a.done||pos>=end)return!0}}iter(){return new RawTextCursor(this,arguments.length>0&&void 0!==arguments[0]?arguments[0]:1)}iterRange(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.length;return new PartialTextCursor(this,from,to)}iterLines(from,to){let inner;if(null==from)inner=this.iter();else{null==to&&(to=this.lines+1);let start=this.line(from).from;inner=this.iterRange(start,Math.max(start,to==this.lines+1?this.length:to<=1?0:this.line(to-1).to))}return new LineCursor(inner)}toString(){return this.sliceString(0)}toJSON(){let lines=[];return this.flatten(lines),lines}constructor(){}static of(text){if(0==text.length)throw new RangeError("A document must have at least one line");return 1!=text.length||text[0]?text.length<=32?new TextLeaf(text):TextNode.from(TextLeaf.split(text,[])):Text.empty}}class TextLeaf extends Text{constructor(text){let length=arguments.length>1&&void 0!==arguments[1]?arguments[1]:function(text){let length=-1;for(let line of text)length+=line.length+1;return length}(text);super(),this.text=text,this.length=length}get lines(){return this.text.length}get children(){return null}lineInner(target,isLine,line,offset){for(let i=0;;i++){let string=this.text[i],end=offset+string.length;if((isLine?line:end)>=target)return new Line(offset,end,line,string);offset=end+1,line++}}decompose(from,to,target,open){let text=from<=0&&to>=this.length?this:new TextLeaf(sliceText(this.text,from,to),Math.min(to,this.length)-Math.max(0,from));if(1&open){let prev=target.pop(),joined=appendText(text.text,prev.text.slice(),0,text.length);if(joined.length<=32)target.push(new TextLeaf(joined,prev.length+text.length));else{let mid=joined.length>>1;target.push(new TextLeaf(joined.slice(0,mid)),new TextLeaf(joined.slice(mid)))}}else target.push(text)}replace(from,to,text){if(!(text instanceof TextLeaf))return super.replace(from,to,text);let lines=appendText(this.text,appendText(text.text,sliceText(this.text,0,from)),to),newLen=this.length+text.length-(to-from);return lines.length<=32?new TextLeaf(lines,newLen):TextNode.from(TextLeaf.split(lines,[]),newLen)}sliceString(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.length,lineSep=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"\n",result="";for(let pos=0,i=0;pos<=to&&i<this.text.length;i++){let line=this.text[i],end=pos+line.length;pos>from&&i&&(result+=lineSep),from<end&&to>pos&&(result+=line.slice(Math.max(0,from-pos),to-pos)),pos=end+1}return result}flatten(target){for(let line of this.text)target.push(line)}scanIdentical(){return 0}static split(text,target){let part=[],len=-1;for(let line of text)part.push(line),len+=line.length+1,32==part.length&&(target.push(new TextLeaf(part,len)),part=[],len=-1);return len>-1&&target.push(new TextLeaf(part,len)),target}}class TextNode extends Text{constructor(children,length){super(),this.children=children,this.length=length,this.lines=0;for(let child of children)this.lines+=child.lines}lineInner(target,isLine,line,offset){for(let i=0;;i++){let child=this.children[i],end=offset+child.length,endLine=line+child.lines-1;if((isLine?endLine:end)>=target)return child.lineInner(target,isLine,line,offset);offset=end+1,line=endLine+1}}decompose(from,to,target,open){for(let i=0,pos=0;pos<=to&&i<this.children.length;i++){let child=this.children[i],end=pos+child.length;if(from<=end&&to>=pos){let childOpen=open&((pos<=from?1:0)|(end>=to?2:0));pos>=from&&end<=to&&!childOpen?target.push(child):child.decompose(from-pos,to-pos,target,childOpen)}pos=end+1}}replace(from,to,text){if(text.lines<this.lines)for(let i=0,pos=0;i<this.children.length;i++){let child=this.children[i],end=pos+child.length;if(from>=pos&&to<=end){let updated=child.replace(from-pos,to-pos,text),totalLines=this.lines-child.lines+updated.lines;if(updated.lines<totalLines>>4&&updated.lines>totalLines>>6){let copy=this.children.slice();return copy[i]=updated,new TextNode(copy,this.length-(to-from)+text.length)}return super.replace(pos,end,updated)}pos=end+1}return super.replace(from,to,text)}sliceString(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.length,lineSep=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"\n",result="";for(let i=0,pos=0;i<this.children.length&&pos<=to;i++){let child=this.children[i],end=pos+child.length;pos>from&&i&&(result+=lineSep),from<end&&to>pos&&(result+=child.sliceString(from-pos,to-pos,lineSep)),pos=end+1}return result}flatten(target){for(let child of this.children)child.flatten(target)}scanIdentical(other,dir){if(!(other instanceof TextNode))return 0;let length=0,[iA,iB,eA,eB]=dir>0?[0,0,this.children.length,other.children.length]:[this.children.length-1,other.children.length-1,-1,-1];for(;;iA+=dir,iB+=dir){if(iA==eA||iB==eB)return length;let chA=this.children[iA],chB=other.children[iB];if(chA!=chB)return length+chA.scanIdentical(chB,dir);length+=chA.length+1}}static from(children){let length=arguments.length>1&&void 0!==arguments[1]?arguments[1]:children.reduce(((l,ch)=>l+ch.length+1),-1),lines=0;for(let ch of children)lines+=ch.lines;if(lines<32){let flat=[];for(let ch of children)ch.flatten(flat);return new TextLeaf(flat,length)}let chunk=Math.max(32,lines>>5),maxChunk=chunk<<1,minChunk=chunk>>1,chunked=[],currentLines=0,currentLen=-1,currentChunk=[];function add(child){let last;if(child.lines>maxChunk&&child instanceof TextNode)for(let node of child.children)add(node);else child.lines>minChunk&&(currentLines>minChunk||!currentLines)?(flush(),chunked.push(child)):child instanceof TextLeaf&&currentLines&&(last=currentChunk[currentChunk.length-1])instanceof TextLeaf&&child.lines+last.lines<=32?(currentLines+=child.lines,currentLen+=child.length+1,currentChunk[currentChunk.length-1]=new TextLeaf(last.text.concat(child.text),last.length+1+child.length)):(currentLines+child.lines>chunk&&flush(),currentLines+=child.lines,currentLen+=child.length+1,currentChunk.push(child))}function flush(){0!=currentLines&&(chunked.push(1==currentChunk.length?currentChunk[0]:TextNode.from(currentChunk,currentLen)),currentLen=-1,currentLines=currentChunk.length=0)}for(let child of children)add(child);return flush(),1==chunked.length?chunked[0]:new TextNode(chunked,length)}}function appendText(text,target){let from=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,to=arguments.length>3&&void 0!==arguments[3]?arguments[3]:1e9;for(let pos=0,i=0,first=!0;i<text.length&&pos<=to;i++){let line=text[i],end=pos+line.length;end>=from&&(end>to&&(line=line.slice(0,to-pos)),pos<from&&(line=line.slice(from-pos)),first?(target[target.length-1]+=line,first=!1):target.push(line)),pos=end+1}return target}function sliceText(text,from,to){return appendText(text,[""],from,to)}Text.empty=new TextLeaf([""],0);class RawTextCursor{constructor(text){let dir=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.dir=dir,this.done=!1,this.lineBreak=!1,this.value="",this.nodes=[text],this.offsets=[dir>0?1:(text instanceof TextLeaf?text.text.length:text.children.length)<<1]}nextInner(skip,dir){for(this.done=this.lineBreak=!1;;){let last=this.nodes.length-1,top=this.nodes[last],offsetValue=this.offsets[last],offset=offsetValue>>1,size=top instanceof TextLeaf?top.text.length:top.children.length;if(offset==(dir>0?size:0)){if(0==last)return this.done=!0,this.value="",this;dir>0&&this.offsets[last-1]++,this.nodes.pop(),this.offsets.pop()}else if((1&offsetValue)==(dir>0?0:1)){if(this.offsets[last]+=dir,0==skip)return this.lineBreak=!0,this.value="\n",this;skip--}else if(top instanceof TextLeaf){let next=top.text[offset+(dir<0?-1:0)];if(this.offsets[last]+=dir,next.length>Math.max(0,skip))return this.value=0==skip?next:dir>0?next.slice(skip):next.slice(0,next.length-skip),this;skip-=next.length}else{let next=top.children[offset+(dir<0?-1:0)];skip>next.length?(skip-=next.length,this.offsets[last]+=dir):(dir<0&&this.offsets[last]--,this.nodes.push(next),this.offsets.push(dir>0?1:(next instanceof TextLeaf?next.text.length:next.children.length)<<1))}}}next(){let skip=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;return skip<0&&(this.nextInner(-skip,-this.dir),skip=this.value.length),this.nextInner(skip,this.dir)}}class PartialTextCursor{constructor(text,start,end){this.value="",this.done=!1,this.cursor=new RawTextCursor(text,start>end?-1:1),this.pos=start>end?text.length:0,this.from=Math.min(start,end),this.to=Math.max(start,end)}nextInner(skip,dir){if(dir<0?this.pos<=this.from:this.pos>=this.to)return this.value="",this.done=!0,this;skip+=Math.max(0,dir<0?this.pos-this.to:this.from-this.pos);let limit=dir<0?this.pos-this.from:this.to-this.pos;skip>limit&&(skip=limit),limit-=skip;let{value:value}=this.cursor.next(skip);return this.pos+=(value.length+skip)*dir,this.value=value.length<=limit?value:dir<0?value.slice(value.length-limit):value.slice(0,limit),this.done=!this.value,this}next(){let skip=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;return skip<0?skip=Math.max(skip,this.from-this.pos):skip>0&&(skip=Math.min(skip,this.to-this.pos)),this.nextInner(skip,this.cursor.dir)}get lineBreak(){return this.cursor.lineBreak&&""!=this.value}}class LineCursor{constructor(inner){this.inner=inner,this.afterBreak=!0,this.value="",this.done=!1}next(){let skip=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0,{done:done,lineBreak:lineBreak,value:value}=this.inner.next(skip);return done?(this.done=!0,this.value=""):lineBreak?this.afterBreak?this.value="":(this.afterBreak=!0,this.next()):(this.value=value,this.afterBreak=!1),this}get lineBreak(){return!1}}"undefined"!=typeof Symbol&&(Text.prototype[Symbol.iterator]=function(){return this.iter()},RawTextCursor.prototype[Symbol.iterator]=PartialTextCursor.prototype[Symbol.iterator]=LineCursor.prototype[Symbol.iterator]=function(){return this});class Line{constructor(from,to,number,text){this.from=from,this.to=to,this.number=number,this.text=text}get length(){return this.to-this.from}}let extend="lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map((s=>s?parseInt(s,36):1));for(let i=1;i<extend.length;i++)extend[i]+=extend[i-1];function isExtendingChar(code){for(let i=1;i<extend.length;i+=2)if(extend[i]>code)return extend[i-1]<=code;return!1}function isRegionalIndicator(code){return code>=127462&&code<=127487}function findClusterBreak(str,pos){let forward=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],includeExtending=!(arguments.length>3&&void 0!==arguments[3])||arguments[3];return(forward?nextClusterBreak:prevClusterBreak)(str,pos,includeExtending)}function nextClusterBreak(str,pos,includeExtending){if(pos==str.length)return pos;pos&&surrogateLow(str.charCodeAt(pos))&&surrogateHigh(str.charCodeAt(pos-1))&&pos--;let prev=codePointAt(str,pos);for(pos+=codePointSize(prev);pos<str.length;){let next=codePointAt(str,pos);if(8205==prev||8205==next||includeExtending&&isExtendingChar(next))pos+=codePointSize(next),prev=next;else{if(!isRegionalIndicator(next))break;{let countBefore=0,i=pos-2;for(;i>=0&&isRegionalIndicator(codePointAt(str,i));)countBefore++,i-=2;if(countBefore%2==0)break;pos+=2}}}return pos}function prevClusterBreak(str,pos,includeExtending){for(;pos>0;){let found=nextClusterBreak(str,pos-2,includeExtending);if(found<pos)return found;pos--}return 0}function surrogateLow(ch){return ch>=56320&&ch<57344}function surrogateHigh(ch){return ch>=55296&&ch<56320}function codePointAt(str,pos){let code0=str.charCodeAt(pos);if(!surrogateHigh(code0)||pos+1==str.length)return code0;let code1=str.charCodeAt(pos+1);return surrogateLow(code1)?code1-56320+(code0-55296<<10)+65536:code0}function fromCodePoint(code){return code<=65535?String.fromCharCode(code):(code-=65536,String.fromCharCode(55296+(code>>10),56320+(1023&code)))}function codePointSize(code){return code<65536?1:2}const DefaultSplit=/\r\n?|\n/;var MapMode=function(MapMode){return MapMode[MapMode.Simple=0]="Simple",MapMode[MapMode.TrackDel=1]="TrackDel",MapMode[MapMode.TrackBefore=2]="TrackBefore",MapMode[MapMode.TrackAfter=3]="TrackAfter",MapMode}(MapMode||(MapMode={}));class ChangeDesc{constructor(sections){this.sections=sections}get length(){let result=0;for(let i=0;i<this.sections.length;i+=2)result+=this.sections[i];return result}get newLength(){let result=0;for(let i=0;i<this.sections.length;i+=2){let ins=this.sections[i+1];result+=ins<0?this.sections[i]:ins}return result}get empty(){return 0==this.sections.length||2==this.sections.length&&this.sections[1]<0}iterGaps(f){for(let i=0,posA=0,posB=0;i<this.sections.length;){let len=this.sections[i++],ins=this.sections[i++];ins<0?(f(posA,posB,len),posB+=len):posB+=ins,posA+=len}}iterChangedRanges(f){iterChanges(this,f,arguments.length>1&&void 0!==arguments[1]&&arguments[1])}get invertedDesc(){let sections=[];for(let i=0;i<this.sections.length;){let len=this.sections[i++],ins=this.sections[i++];ins<0?sections.push(len,ins):sections.push(ins,len)}return new ChangeDesc(sections)}composeDesc(other){return this.empty?other:other.empty?this:composeSets(this,other)}mapDesc(other){let before=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return other.empty?this:mapSet(this,other,before)}mapPos(pos){let assoc=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1,mode=arguments.length>2&&void 0!==arguments[2]?arguments[2]:MapMode.Simple,posA=0,posB=0;for(let i=0;i<this.sections.length;){let len=this.sections[i++],ins=this.sections[i++],endA=posA+len;if(ins<0){if(endA>pos)return posB+(pos-posA);posB+=len}else{if(mode!=MapMode.Simple&&endA>=pos&&(mode==MapMode.TrackDel&&posA<pos&&endA>pos||mode==MapMode.TrackBefore&&posA<pos||mode==MapMode.TrackAfter&&endA>pos))return null;if(endA>pos||endA==pos&&assoc<0&&!len)return pos==posA||assoc<0?posB:posB+ins;posB+=ins}posA=endA}if(pos>posA)throw new RangeError("Position ".concat(pos," is out of range for changeset of length ").concat(posA));return posB}touchesRange(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:from;for(let i=0,pos=0;i<this.sections.length&&pos<=to;){let end=pos+this.sections[i++];if(this.sections[i++]>=0&&pos<=to&&end>=from)return!(pos<from&&end>to)||"cover";pos=end}return!1}toString(){let result="";for(let i=0;i<this.sections.length;){let len=this.sections[i++],ins=this.sections[i++];result+=(result?" ":"")+len+(ins>=0?":"+ins:"")}return result}toJSON(){return this.sections}static fromJSON(json){if(!Array.isArray(json)||json.length%2||json.some((a=>"number"!=typeof a)))throw new RangeError("Invalid JSON representation of ChangeDesc");return new ChangeDesc(json)}static create(sections){return new ChangeDesc(sections)}}class ChangeSet extends ChangeDesc{constructor(sections,inserted){super(sections),this.inserted=inserted}apply(doc){if(this.length!=doc.length)throw new RangeError("Applying change set to a document with the wrong length");return iterChanges(this,((fromA,toA,fromB,_toB,text)=>doc=doc.replace(fromB,fromB+(toA-fromA),text)),!1),doc}mapDesc(other){return mapSet(this,other,arguments.length>1&&void 0!==arguments[1]&&arguments[1],!0)}invert(doc){let sections=this.sections.slice(),inserted=[];for(let i=0,pos=0;i<sections.length;i+=2){let len=sections[i],ins=sections[i+1];if(ins>=0){sections[i]=ins,sections[i+1]=len;let index=i>>1;for(;inserted.length<index;)inserted.push(Text.empty);inserted.push(len?doc.slice(pos,pos+len):Text.empty)}pos+=len}return new ChangeSet(sections,inserted)}compose(other){return this.empty?other:other.empty?this:composeSets(this,other,!0)}map(other){let before=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return other.empty?this:mapSet(this,other,before,!0)}iterChanges(f){iterChanges(this,f,arguments.length>1&&void 0!==arguments[1]&&arguments[1])}get desc(){return ChangeDesc.create(this.sections)}filter(ranges){let resultSections=[],resultInserted=[],filteredSections=[],iter=new SectionIter(this);done:for(let i=0,pos=0;;){let next=i==ranges.length?1e9:ranges[i++];for(;pos<next||pos==next&&0==iter.len;){if(iter.done)break done;let len=Math.min(iter.len,next-pos);addSection(filteredSections,len,-1);let ins=-1==iter.ins?-1:0==iter.off?iter.ins:0;addSection(resultSections,len,ins),ins>0&&addInsert(resultInserted,resultSections,iter.text),iter.forward(len),pos+=len}let end=ranges[i++];for(;pos<end;){if(iter.done)break done;let len=Math.min(iter.len,end-pos);addSection(resultSections,len,-1),addSection(filteredSections,len,-1==iter.ins?-1:0==iter.off?iter.ins:0),iter.forward(len),pos+=len}}return{changes:new ChangeSet(resultSections,resultInserted),filtered:ChangeDesc.create(filteredSections)}}toJSON(){let parts=[];for(let i=0;i<this.sections.length;i+=2){let len=this.sections[i],ins=this.sections[i+1];ins<0?parts.push(len):0==ins?parts.push([len]):parts.push([len].concat(this.inserted[i>>1].toJSON()))}return parts}static of(changes,length,lineSep){let sections=[],inserted=[],pos=0,total=null;function flush(){let force=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(!force&&!sections.length)return;pos<length&&addSection(sections,length-pos,-1);let set=new ChangeSet(sections,inserted);total=total?total.compose(set.map(total)):set,sections=[],inserted=[],pos=0}return function process(spec){if(Array.isArray(spec))for(let sub of spec)process(sub);else if(spec instanceof ChangeSet){if(spec.length!=length)throw new RangeError("Mismatched change set length (got ".concat(spec.length,", expected ").concat(length,")"));flush(),total=total?total.compose(spec.map(total)):spec}else{let{from:from,to:to=from,insert:insert}=spec;if(from>to||from<0||to>length)throw new RangeError("Invalid change range ".concat(from," to ").concat(to," (in doc of length ").concat(length,")"));let insText=insert?"string"==typeof insert?Text.of(insert.split(lineSep||DefaultSplit)):insert:Text.empty,insLen=insText.length;if(from==to&&0==insLen)return;from<pos&&flush(),from>pos&&addSection(sections,from-pos,-1),addSection(sections,to-from,insLen),addInsert(inserted,sections,insText),pos=to}}(changes),flush(!total),total}static empty(length){return new ChangeSet(length?[length,-1]:[],[])}static fromJSON(json){if(!Array.isArray(json))throw new RangeError("Invalid JSON representation of ChangeSet");let sections=[],inserted=[];for(let i=0;i<json.length;i++){let part=json[i];if("number"==typeof part)sections.push(part,-1);else{if(!Array.isArray(part)||"number"!=typeof part[0]||part.some(((e,i)=>i&&"string"!=typeof e)))throw new RangeError("Invalid JSON representation of ChangeSet");if(1==part.length)sections.push(part[0],0);else{for(;inserted.length<i;)inserted.push(Text.empty);inserted[i]=Text.of(part.slice(1)),sections.push(part[0],inserted[i].length)}}}return new ChangeSet(sections,inserted)}static createSet(sections,inserted){return new ChangeSet(sections,inserted)}}function addSection(sections,len,ins){let forceJoin=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(0==len&&ins<=0)return;let last=sections.length-2;last>=0&&ins<=0&&ins==sections[last+1]?sections[last]+=len:0==len&&0==sections[last]?sections[last+1]+=ins:forceJoin?(sections[last]+=len,sections[last+1]+=ins):sections.push(len,ins)}function addInsert(values,sections,value){if(0==value.length)return;let index=sections.length-2>>1;if(index<values.length)values[values.length-1]=values[values.length-1].append(value);else{for(;values.length<index;)values.push(Text.empty);values.push(value)}}function iterChanges(desc,f,individual){let inserted=desc.inserted;for(let posA=0,posB=0,i=0;i<desc.sections.length;){let len=desc.sections[i++],ins=desc.sections[i++];if(ins<0)posA+=len,posB+=len;else{let endA=posA,endB=posB,text=Text.empty;for(;endA+=len,endB+=ins,ins&&inserted&&(text=text.append(inserted[i-2>>1])),!(individual||i==desc.sections.length||desc.sections[i+1]<0);)len=desc.sections[i++],ins=desc.sections[i++];f(posA,endA,posB,endB,text),posA=endA,posB=endB}}}function mapSet(setA,setB,before){let mkSet=arguments.length>3&&void 0!==arguments[3]&&arguments[3],sections=[],insert=mkSet?[]:null,a=new SectionIter(setA),b=new SectionIter(setB);for(let inserted=-1;;)if(-1==a.ins&&-1==b.ins){let len=Math.min(a.len,b.len);addSection(sections,len,-1),a.forward(len),b.forward(len)}else if(b.ins>=0&&(a.ins<0||inserted==a.i||0==a.off&&(b.len<a.len||b.len==a.len&&!before))){let len=b.len;for(addSection(sections,b.ins,-1);len;){let piece=Math.min(a.len,len);a.ins>=0&&inserted<a.i&&a.len<=piece&&(addSection(sections,0,a.ins),insert&&addInsert(insert,sections,a.text),inserted=a.i),a.forward(piece),len-=piece}b.next()}else{if(!(a.ins>=0)){if(a.done&&b.done)return insert?ChangeSet.createSet(sections,insert):ChangeDesc.create(sections);throw new Error("Mismatched change set lengths")}{let len=0,left=a.len;for(;left;)if(-1==b.ins){let piece=Math.min(left,b.len);len+=piece,left-=piece,b.forward(piece)}else{if(!(0==b.ins&&b.len<left))break;left-=b.len,b.next()}addSection(sections,len,inserted<a.i?a.ins:0),insert&&inserted<a.i&&addInsert(insert,sections,a.text),inserted=a.i,a.forward(a.len-left)}}}function composeSets(setA,setB){let mkSet=arguments.length>2&&void 0!==arguments[2]&&arguments[2],sections=[],insert=mkSet?[]:null,a=new SectionIter(setA),b=new SectionIter(setB);for(let open=!1;;){if(a.done&&b.done)return insert?ChangeSet.createSet(sections,insert):ChangeDesc.create(sections);if(0==a.ins)addSection(sections,a.len,0,open),a.next();else if(0!=b.len||b.done){if(a.done||b.done)throw new Error("Mismatched change set lengths");{let len=Math.min(a.len2,b.len),sectionLen=sections.length;if(-1==a.ins){let insB=-1==b.ins?-1:b.off?0:b.ins;addSection(sections,len,insB,open),insert&&insB&&addInsert(insert,sections,b.text)}else-1==b.ins?(addSection(sections,a.off?0:a.len,len,open),insert&&addInsert(insert,sections,a.textBit(len))):(addSection(sections,a.off?0:a.len,b.off?0:b.ins,open),insert&&!b.off&&addInsert(insert,sections,b.text));open=(a.ins>len||b.ins>=0&&b.len>len)&&(open||sections.length>sectionLen),a.forward2(len),b.forward(len)}}else addSection(sections,0,b.ins,open),insert&&addInsert(insert,sections,b.text),b.next()}}class SectionIter{constructor(set){this.set=set,this.i=0,this.next()}next(){let{sections:sections}=this.set;this.i<sections.length?(this.len=sections[this.i++],this.ins=sections[this.i++]):(this.len=0,this.ins=-2),this.off=0}get done(){return-2==this.ins}get len2(){return this.ins<0?this.len:this.ins}get text(){let{inserted:inserted}=this.set,index=this.i-2>>1;return index>=inserted.length?Text.empty:inserted[index]}textBit(len){let{inserted:inserted}=this.set,index=this.i-2>>1;return index>=inserted.length&&!len?Text.empty:inserted[index].slice(this.off,null==len?void 0:this.off+len)}forward(len){len==this.len?this.next():(this.len-=len,this.off+=len)}forward2(len){-1==this.ins?this.forward(len):len==this.ins?this.next():(this.ins-=len,this.off+=len)}}class SelectionRange{constructor(from,to,flags){this.from=from,this.to=to,this.flags=flags}get anchor(){return 16&this.flags?this.to:this.from}get head(){return 16&this.flags?this.from:this.to}get empty(){return this.from==this.to}get assoc(){return 4&this.flags?-1:8&this.flags?1:0}get bidiLevel(){let level=3&this.flags;return 3==level?null:level}get goalColumn(){let value=this.flags>>5;return 33554431==value?void 0:value}map(change){let from,to,assoc=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1;return this.empty?from=to=change.mapPos(this.from,assoc):(from=change.mapPos(this.from,1),to=change.mapPos(this.to,-1)),from==this.from&&to==this.to?this:new SelectionRange(from,to,this.flags)}extend(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:from;if(from<=this.anchor&&to>=this.anchor)return EditorSelection.range(from,to);let head=Math.abs(from-this.anchor)>Math.abs(to-this.anchor)?from:to;return EditorSelection.range(this.anchor,head)}eq(other){return this.anchor==other.anchor&&this.head==other.head}toJSON(){return{anchor:this.anchor,head:this.head}}static fromJSON(json){if(!json||"number"!=typeof json.anchor||"number"!=typeof json.head)throw new RangeError("Invalid JSON representation for SelectionRange");return EditorSelection.range(json.anchor,json.head)}static create(from,to,flags){return new SelectionRange(from,to,flags)}}class EditorSelection{constructor(ranges,mainIndex){this.ranges=ranges,this.mainIndex=mainIndex}map(change){let assoc=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1;return change.empty?this:EditorSelection.create(this.ranges.map((r=>r.map(change,assoc))),this.mainIndex)}eq(other){if(this.ranges.length!=other.ranges.length||this.mainIndex!=other.mainIndex)return!1;for(let i=0;i<this.ranges.length;i++)if(!this.ranges[i].eq(other.ranges[i]))return!1;return!0}get main(){return this.ranges[this.mainIndex]}asSingle(){return 1==this.ranges.length?this:new EditorSelection([this.main],0)}addRange(range){let main=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return EditorSelection.create([range].concat(this.ranges),main?0:this.mainIndex+1)}replaceRange(range){let which=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.mainIndex,ranges=this.ranges.slice();return ranges[which]=range,EditorSelection.create(ranges,this.mainIndex)}toJSON(){return{ranges:this.ranges.map((r=>r.toJSON())),main:this.mainIndex}}static fromJSON(json){if(!json||!Array.isArray(json.ranges)||"number"!=typeof json.main||json.main>=json.ranges.length)throw new RangeError("Invalid JSON representation for EditorSelection");return new EditorSelection(json.ranges.map((r=>SelectionRange.fromJSON(r))),json.main)}static single(anchor){let head=arguments.length>1&&void 0!==arguments[1]?arguments[1]:anchor;return new EditorSelection([EditorSelection.range(anchor,head)],0)}static create(ranges){let mainIndex=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;if(0==ranges.length)throw new RangeError("A selection needs at least one range");for(let pos=0,i=0;i<ranges.length;i++){let range=ranges[i];if(range.empty?range.from<=pos:range.from<pos)return EditorSelection.normalized(ranges.slice(),mainIndex);pos=range.to}return new EditorSelection(ranges,mainIndex)}static cursor(pos){let assoc=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,bidiLevel=arguments.length>2?arguments[2]:void 0,goalColumn=arguments.length>3?arguments[3]:void 0;return SelectionRange.create(pos,pos,(0==assoc?0:assoc<0?4:8)|(null==bidiLevel?3:Math.min(2,bidiLevel))|(null!=goalColumn?goalColumn:33554431)<<5)}static range(anchor,head,goalColumn,bidiLevel){let flags=(null!=goalColumn?goalColumn:33554431)<<5|(null==bidiLevel?3:Math.min(2,bidiLevel));return head<anchor?SelectionRange.create(head,anchor,24|flags):SelectionRange.create(anchor,head,(head>anchor?4:0)|flags)}static normalized(ranges){let mainIndex=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,main=ranges[mainIndex];ranges.sort(((a,b)=>a.from-b.from)),mainIndex=ranges.indexOf(main);for(let i=1;i<ranges.length;i++){let range=ranges[i],prev=ranges[i-1];if(range.empty?range.from<=prev.to:range.from<prev.to){let from=prev.from,to=Math.max(range.to,prev.to);i<=mainIndex&&mainIndex--,ranges.splice(--i,2,range.anchor>range.head?EditorSelection.range(to,from):EditorSelection.range(from,to))}}return new EditorSelection(ranges,mainIndex)}}function checkSelection(selection,docLength){for(let range of selection.ranges)if(range.to>docLength)throw new RangeError("Selection points outside of document")}let nextID=0;class Facet{constructor(combine,compareInput,compare,isStatic,enables){this.combine=combine,this.compareInput=compareInput,this.compare=compare,this.isStatic=isStatic,this.id=nextID++,this.default=combine([]),this.extensions="function"==typeof enables?enables(this):enables}static define(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return new Facet(config.combine||(a=>a),config.compareInput||((a,b)=>a===b),config.compare||(config.combine?(a,b)=>a===b:sameArray$1),!!config.static,config.enables)}of(value){return new FacetProvider([],this,0,value)}compute(deps,get){if(this.isStatic)throw new Error("Can't compute a static facet");return new FacetProvider(deps,this,1,get)}computeN(deps,get){if(this.isStatic)throw new Error("Can't compute a static facet");return new FacetProvider(deps,this,2,get)}from(field,get){return get||(get=x=>x),this.compute([field],(state=>get(state.field(field))))}}function sameArray$1(a,b){return a==b||a.length==b.length&&a.every(((e,i)=>e===b[i]))}class FacetProvider{constructor(dependencies,facet,type,value){this.dependencies=dependencies,this.facet=facet,this.type=type,this.value=value,this.id=nextID++}dynamicSlot(addresses){var _a;let getter=this.value,compare=this.facet.compareInput,id=this.id,idx=addresses[id]>>1,multi=2==this.type,depDoc=!1,depSel=!1,depAddrs=[];for(let dep of this.dependencies)"doc"==dep?depDoc=!0:"selection"==dep?depSel=!0:0==(1&(null!==(_a=addresses[dep.id])&&void 0!==_a?_a:1))&&depAddrs.push(addresses[dep.id]);return{create:state=>(state.values[idx]=getter(state),1),update(state,tr){if(depDoc&&tr.docChanged||depSel&&(tr.docChanged||tr.selection)||ensureAll(state,depAddrs)){let newVal=getter(state);if(multi?!compareArray(newVal,state.values[idx],compare):!compare(newVal,state.values[idx]))return state.values[idx]=newVal,1}return 0},reconfigure:(state,oldState)=>{let newVal,oldAddr=oldState.config.address[id];if(null!=oldAddr){let oldVal=getAddr(oldState,oldAddr);if(this.dependencies.every((dep=>dep instanceof Facet?oldState.facet(dep)===state.facet(dep):!(dep instanceof StateField)||oldState.field(dep,!1)==state.field(dep,!1)))||(multi?compareArray(newVal=getter(state),oldVal,compare):compare(newVal=getter(state),oldVal)))return state.values[idx]=oldVal,0}else newVal=getter(state);return state.values[idx]=newVal,1}}}}function compareArray(a,b,compare){if(a.length!=b.length)return!1;for(let i=0;i<a.length;i++)if(!compare(a[i],b[i]))return!1;return!0}function ensureAll(state,addrs){let changed=!1;for(let addr of addrs)1&ensureAddr(state,addr)&&(changed=!0);return changed}function dynamicFacetSlot(addresses,facet,providers){let providerAddrs=providers.map((p=>addresses[p.id])),providerTypes=providers.map((p=>p.type)),dynamic=providerAddrs.filter((p=>!(1&p))),idx=addresses[facet.id]>>1;function get(state){let values=[];for(let i=0;i<providerAddrs.length;i++){let value=getAddr(state,providerAddrs[i]);if(2==providerTypes[i])for(let val of value)values.push(val);else values.push(value)}return facet.combine(values)}return{create(state){for(let addr of providerAddrs)ensureAddr(state,addr);return state.values[idx]=get(state),1},update(state,tr){if(!ensureAll(state,dynamic))return 0;let value=get(state);return facet.compare(value,state.values[idx])?0:(state.values[idx]=value,1)},reconfigure(state,oldState){let depChanged=ensureAll(state,providerAddrs),oldProviders=oldState.config.facets[facet.id],oldValue=oldState.facet(facet);if(oldProviders&&!depChanged&&sameArray$1(providers,oldProviders))return state.values[idx]=oldValue,0;let value=get(state);return facet.compare(value,oldValue)?(state.values[idx]=oldValue,0):(state.values[idx]=value,1)}}}const initField=Facet.define({static:!0});class StateField{constructor(id,createF,updateF,compareF,spec){this.id=id,this.createF=createF,this.updateF=updateF,this.compareF=compareF,this.spec=spec,this.provides=void 0}static define(config){let field=new StateField(nextID++,config.create,config.update,config.compare||((a,b)=>a===b),config);return config.provide&&(field.provides=config.provide(field)),field}create(state){let init=state.facet(initField).find((i=>i.field==this));return((null==init?void 0:init.create)||this.createF)(state)}slot(addresses){let idx=addresses[this.id]>>1;return{create:state=>(state.values[idx]=this.create(state),1),update:(state,tr)=>{let oldVal=state.values[idx],value=this.updateF(oldVal,tr);return this.compareF(oldVal,value)?0:(state.values[idx]=value,1)},reconfigure:(state,oldState)=>null!=oldState.config.address[this.id]?(state.values[idx]=oldState.field(this),0):(state.values[idx]=this.create(state),1)}}init(create){return[this,initField.of({field:this,create:create})]}get extension(){return this}}const Prec__lowest=4,Prec__low=3,Prec__default=2,Prec__high=1;function prec(value){return ext=>new PrecExtension(ext,value)}const Prec={highest:prec(0),high:prec(Prec__high),default:prec(Prec__default),low:prec(Prec__low),lowest:prec(Prec__lowest)};class PrecExtension{constructor(inner,prec){this.inner=inner,this.prec=prec}}class Compartment{of(ext){return new CompartmentInstance(this,ext)}reconfigure(content){return Compartment.reconfigure.of({compartment:this,extension:content})}get(state){return state.config.compartments.get(this)}}class CompartmentInstance{constructor(compartment,inner){this.compartment=compartment,this.inner=inner}}class Configuration{constructor(base,compartments,dynamicSlots,address,staticValues,facets){for(this.base=base,this.compartments=compartments,this.dynamicSlots=dynamicSlots,this.address=address,this.staticValues=staticValues,this.facets=facets,this.statusTemplate=[];this.statusTemplate.length<dynamicSlots.length;)this.statusTemplate.push(0)}staticFacet(facet){let addr=this.address[facet.id];return null==addr?facet.default:this.staticValues[addr>>1]}static resolve(base,compartments,oldState){let fields=[],facets=Object.create(null),newCompartments=new Map;for(let ext of function(extension,compartments,newCompartments){let result=[[],[],[],[],[]],seen=new Map;function inner(ext,prec){let known=seen.get(ext);if(null!=known){if(known<=prec)return;let found=result[known].indexOf(ext);found>-1&&result[known].splice(found,1),ext instanceof CompartmentInstance&&newCompartments.delete(ext.compartment)}if(seen.set(ext,prec),Array.isArray(ext))for(let e of ext)inner(e,prec);else if(ext instanceof CompartmentInstance){if(newCompartments.has(ext.compartment))throw new RangeError("Duplicate use of compartment in extensions");let content=compartments.get(ext.compartment)||ext.inner;newCompartments.set(ext.compartment,content),inner(content,prec)}else if(ext instanceof PrecExtension)inner(ext.inner,ext.prec);else if(ext instanceof StateField)result[prec].push(ext),ext.provides&&inner(ext.provides,prec);else if(ext instanceof FacetProvider)result[prec].push(ext),ext.facet.extensions&&inner(ext.facet.extensions,Prec__default);else{let content=ext.extension;if(!content)throw new Error("Unrecognized extension value in extension set (".concat(ext,"). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks."));inner(content,prec)}}return inner(extension,Prec__default),result.reduce(((a,b)=>a.concat(b)))}(base,compartments,newCompartments))ext instanceof StateField?fields.push(ext):(facets[ext.facet.id]||(facets[ext.facet.id]=[])).push(ext);let address=Object.create(null),staticValues=[],dynamicSlots=[];for(let field of fields)address[field.id]=dynamicSlots.length<<1,dynamicSlots.push((a=>field.slot(a)));let oldFacets=null==oldState?void 0:oldState.config.facets;for(let id in facets){let providers=facets[id],facet=providers[0].facet,oldProviders=oldFacets&&oldFacets[id]||[];if(providers.every((p=>0==p.type)))if(address[facet.id]=staticValues.length<<1|1,sameArray$1(oldProviders,providers))staticValues.push(oldState.facet(facet));else{let value=facet.combine(providers.map((p=>p.value)));staticValues.push(oldState&&facet.compare(value,oldState.facet(facet))?oldState.facet(facet):value)}else{for(let p of providers)0==p.type?(address[p.id]=staticValues.length<<1|1,staticValues.push(p.value)):(address[p.id]=dynamicSlots.length<<1,dynamicSlots.push((a=>p.dynamicSlot(a))));address[facet.id]=dynamicSlots.length<<1,dynamicSlots.push((a=>dynamicFacetSlot(a,facet,providers)))}}let dynamic=dynamicSlots.map((f=>f(address)));return new Configuration(base,newCompartments,dynamic,address,staticValues,facets)}}function ensureAddr(state,addr){if(1&addr)return 2;let idx=addr>>1,status=state.status[idx];if(4==status)throw new Error("Cyclic dependency between fields and/or facets");if(2&status)return status;state.status[idx]=4;let changed=state.computeSlot(state,state.config.dynamicSlots[idx]);return state.status[idx]=2|changed}function getAddr(state,addr){return 1&addr?state.config.staticValues[addr>>1]:state.values[addr>>1]}const languageData=Facet.define(),allowMultipleSelections=Facet.define({combine:values=>values.some((v=>v)),static:!0}),lineSeparator=Facet.define({combine:values=>values.length?values[0]:void 0,static:!0}),changeFilter=Facet.define(),transactionFilter=Facet.define(),transactionExtender=Facet.define(),readOnly=Facet.define({combine:values=>!!values.length&&values[0]});class Annotation{constructor(type,value){this.type=type,this.value=value}static define(){return new AnnotationType}}class AnnotationType{of(value){return new Annotation(this,value)}}class StateEffectType{constructor(map){this.map=map}of(value){return new StateEffect(this,value)}}class StateEffect{constructor(type,value){this.type=type,this.value=value}map(mapping){let mapped=this.type.map(this.value,mapping);return void 0===mapped?void 0:mapped==this.value?this:new StateEffect(this.type,mapped)}is(type){return this.type==type}static define(){return new StateEffectType((arguments.length>0&&void 0!==arguments[0]?arguments[0]:{}).map||(v=>v))}static mapEffects(effects,mapping){if(!effects.length)return effects;let result=[];for(let effect of effects){let mapped=effect.map(mapping);mapped&&result.push(mapped)}return result}}StateEffect.reconfigure=StateEffect.define(),StateEffect.appendConfig=StateEffect.define();class Transaction{constructor(startState,changes,selection,effects,annotations,scrollIntoView){this.startState=startState,this.changes=changes,this.selection=selection,this.effects=effects,this.annotations=annotations,this.scrollIntoView=scrollIntoView,this._doc=null,this._state=null,selection&&checkSelection(selection,changes.newLength),annotations.some((a=>a.type==Transaction.time))||(this.annotations=annotations.concat(Transaction.time.of(Date.now())))}static create(startState,changes,selection,effects,annotations,scrollIntoView){return new Transaction(startState,changes,selection,effects,annotations,scrollIntoView)}get newDoc(){return this._doc||(this._doc=this.changes.apply(this.startState.doc))}get newSelection(){return this.selection||this.startState.selection.map(this.changes)}get state(){return this._state||this.startState.applyTransaction(this),this._state}annotation(type){for(let ann of this.annotations)if(ann.type==type)return ann.value}get docChanged(){return!this.changes.empty}get reconfigured(){return this.startState.config!=this.state.config}isUserEvent(event){let e=this.annotation(Transaction.userEvent);return!(!e||!(e==event||e.length>event.length&&e.slice(0,event.length)==event&&"."==e[event.length]))}}function joinRanges(a,b){let result=[];for(let iA=0,iB=0;;){let from,to;if(iA<a.length&&(iB==b.length||b[iB]>=a[iA]))from=a[iA++],to=a[iA++];else{if(!(iB<b.length))return result;from=b[iB++],to=b[iB++]}!result.length||result[result.length-1]<from?result.push(from,to):result[result.length-1]<to&&(result[result.length-1]=to)}}function mergeTransaction(a,b,sequential){var _a;let mapForA,mapForB,changes;return sequential?(mapForA=b.changes,mapForB=ChangeSet.empty(b.changes.length),changes=a.changes.compose(b.changes)):(mapForA=b.changes.map(a.changes),mapForB=a.changes.mapDesc(b.changes,!0),changes=a.changes.compose(mapForA)),{changes:changes,selection:b.selection?b.selection.map(mapForB):null===(_a=a.selection)||void 0===_a?void 0:_a.map(mapForA),effects:StateEffect.mapEffects(a.effects,mapForA).concat(StateEffect.mapEffects(b.effects,mapForB)),annotations:a.annotations.length?a.annotations.concat(b.annotations):b.annotations,scrollIntoView:a.scrollIntoView||b.scrollIntoView}}function resolveTransactionInner(state,spec,docSize){let sel=spec.selection,annotations=asArray$1(spec.annotations);return spec.userEvent&&(annotations=annotations.concat(Transaction.userEvent.of(spec.userEvent))),{changes:spec.changes instanceof ChangeSet?spec.changes:ChangeSet.of(spec.changes||[],docSize,state.facet(lineSeparator)),selection:sel&&(sel instanceof EditorSelection?sel:EditorSelection.single(sel.anchor,sel.head)),effects:asArray$1(spec.effects),annotations:annotations,scrollIntoView:!!spec.scrollIntoView}}function resolveTransaction(state,specs,filter){let s=resolveTransactionInner(state,specs.length?specs[0]:{},state.doc.length);specs.length&&!1===specs[0].filter&&(filter=!1);for(let i=1;i<specs.length;i++){!1===specs[i].filter&&(filter=!1);let seq=!!specs[i].sequential;s=mergeTransaction(s,resolveTransactionInner(state,specs[i],seq?s.changes.newLength:state.doc.length),seq)}let tr=Transaction.create(state,s.changes,s.selection,s.effects,s.annotations,s.scrollIntoView);return function(tr){let state=tr.startState,extenders=state.facet(transactionExtender),spec=tr;for(let i=extenders.length-1;i>=0;i--){let extension=extenders[i](tr);extension&&Object.keys(extension).length&&(spec=mergeTransaction(spec,resolveTransactionInner(state,extension,tr.changes.newLength),!0))}return spec==tr?tr:Transaction.create(state,tr.changes,tr.selection,spec.effects,spec.annotations,spec.scrollIntoView)}(filter?function(tr){let state=tr.startState,result=!0;for(let filter of state.facet(changeFilter)){let value=filter(tr);if(!1===value){result=!1;break}Array.isArray(value)&&(result=!0===result?value:joinRanges(result,value))}if(!0!==result){let changes,back;if(!1===result)back=tr.changes.invertedDesc,changes=ChangeSet.empty(state.doc.length);else{let filtered=tr.changes.filter(result);changes=filtered.changes,back=filtered.filtered.mapDesc(filtered.changes).invertedDesc}tr=Transaction.create(state,changes,tr.selection&&tr.selection.map(back),StateEffect.mapEffects(tr.effects,back),tr.annotations,tr.scrollIntoView)}let filters=state.facet(transactionFilter);for(let i=filters.length-1;i>=0;i--){let filtered=filters[i](tr);tr=filtered instanceof Transaction?filtered:Array.isArray(filtered)&&1==filtered.length&&filtered[0]instanceof Transaction?filtered[0]:resolveTransaction(state,asArray$1(filtered),!1)}return tr}(tr):tr)}Transaction.time=Annotation.define(),Transaction.userEvent=Annotation.define(),Transaction.addToHistory=Annotation.define(),Transaction.remote=Annotation.define();const none$2=[];function asArray$1(value){return null==value?none$2:Array.isArray(value)?value:[value]}var CharCategory=function(CharCategory){return CharCategory[CharCategory.Word=0]="Word",CharCategory[CharCategory.Space=1]="Space",CharCategory[CharCategory.Other=2]="Other",CharCategory}(CharCategory||(CharCategory={}));const nonASCIISingleCaseWordChar=/[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;let wordChar;try{wordChar=new RegExp("[\\p{Alphabetic}\\p{Number}_]","u")}catch(_){}function makeCategorizer(wordChars){return char=>{if(!/\S/.test(char))return CharCategory.Space;if(function(str){if(wordChar)return wordChar.test(str);for(let i=0;i<str.length;i++){let ch=str[i];if(/\w/.test(ch)||ch>""&&(ch.toUpperCase()!=ch.toLowerCase()||nonASCIISingleCaseWordChar.test(ch)))return!0}return!1}(char))return CharCategory.Word;for(let i=0;i<wordChars.length;i++)if(char.indexOf(wordChars[i])>-1)return CharCategory.Word;return CharCategory.Other}}class EditorState{constructor(config,doc,selection,values,computeSlot,tr){this.config=config,this.doc=doc,this.selection=selection,this.values=values,this.status=config.statusTemplate.slice(),this.computeSlot=computeSlot,tr&&(tr._state=this);for(let i=0;i<this.config.dynamicSlots.length;i++)ensureAddr(this,i<<1);this.computeSlot=null}field(field){let require=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],addr=this.config.address[field.id];if(null!=addr)return ensureAddr(this,addr),getAddr(this,addr);if(require)throw new RangeError("Field is not present in this state")}update(){for(var _len=arguments.length,specs=new Array(_len),_key=0;_key<_len;_key++)specs[_key]=arguments[_key];return resolveTransaction(this,specs,!0)}applyTransaction(tr){let startValues,conf=this.config,{base:base,compartments:compartments}=conf;for(let effect of tr.effects)effect.is(Compartment.reconfigure)?(conf&&(compartments=new Map,conf.compartments.forEach(((val,key)=>compartments.set(key,val))),conf=null),compartments.set(effect.value.compartment,effect.value.extension)):effect.is(StateEffect.reconfigure)?(conf=null,base=effect.value):effect.is(StateEffect.appendConfig)&&(conf=null,base=asArray$1(base).concat(effect.value));if(conf)startValues=tr.startState.values.slice();else{conf=Configuration.resolve(base,compartments,this),startValues=new EditorState(conf,this.doc,this.selection,conf.dynamicSlots.map((()=>null)),((state,slot)=>slot.reconfigure(state,this)),null).values}new EditorState(conf,tr.newDoc,tr.newSelection,startValues,((state,slot)=>slot.update(state,tr)),tr)}replaceSelection(text){return"string"==typeof text&&(text=this.toText(text)),this.changeByRange((range=>({changes:{from:range.from,to:range.to,insert:text},range:EditorSelection.cursor(range.from+text.length)})))}changeByRange(f){let sel=this.selection,result1=f(sel.ranges[0]),changes=this.changes(result1.changes),ranges=[result1.range],effects=asArray$1(result1.effects);for(let i=1;i<sel.ranges.length;i++){let result=f(sel.ranges[i]),newChanges=this.changes(result.changes),newMapped=newChanges.map(changes);for(let j=0;j<i;j++)ranges[j]=ranges[j].map(newMapped);let mapBy=changes.mapDesc(newChanges,!0);ranges.push(result.range.map(mapBy)),changes=changes.compose(newMapped),effects=StateEffect.mapEffects(effects,newMapped).concat(StateEffect.mapEffects(asArray$1(result.effects),mapBy))}return{changes:changes,selection:EditorSelection.create(ranges,sel.mainIndex),effects:effects}}changes(){let spec=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];return spec instanceof ChangeSet?spec:ChangeSet.of(spec,this.doc.length,this.facet(EditorState.lineSeparator))}toText(string){return Text.of(string.split(this.facet(EditorState.lineSeparator)||DefaultSplit))}sliceDoc(){let from=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0,to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.doc.length;return this.doc.sliceString(from,to,this.lineBreak)}facet(facet){let addr=this.config.address[facet.id];return null==addr?facet.default:(ensureAddr(this,addr),getAddr(this,addr))}toJSON(fields){let result={doc:this.sliceDoc(),selection:this.selection.toJSON()};if(fields)for(let prop in fields){let value=fields[prop];value instanceof StateField&&null!=this.config.address[value.id]&&(result[prop]=value.spec.toJSON(this.field(fields[prop]),this))}return result}static fromJSON(json){let config=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},fields=arguments.length>2?arguments[2]:void 0;if(!json||"string"!=typeof json.doc)throw new RangeError("Invalid JSON representation for EditorState");let fieldInit=[];if(fields)for(let prop in fields)if(Object.prototype.hasOwnProperty.call(json,prop)){let field=fields[prop],value=json[prop];fieldInit.push(field.init((state=>field.spec.fromJSON(value,state))))}return EditorState.create({doc:json.doc,selection:EditorSelection.fromJSON(json.selection),extensions:config.extensions?fieldInit.concat([config.extensions]):fieldInit})}static create(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},configuration=Configuration.resolve(config.extensions||[],new Map),doc=config.doc instanceof Text?config.doc:Text.of((config.doc||"").split(configuration.staticFacet(EditorState.lineSeparator)||DefaultSplit)),selection=config.selection?config.selection instanceof EditorSelection?config.selection:EditorSelection.single(config.selection.anchor,config.selection.head):EditorSelection.single(0);return checkSelection(selection,doc.length),configuration.staticFacet(allowMultipleSelections)||(selection=selection.asSingle()),new EditorState(configuration,doc,selection,configuration.dynamicSlots.map((()=>null)),((state,slot)=>slot.create(state)),null)}get tabSize(){return this.facet(EditorState.tabSize)}get lineBreak(){return this.facet(EditorState.lineSeparator)||"\n"}get readOnly(){return this.facet(readOnly)}phrase(phrase){for(var _len2=arguments.length,insert=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++)insert[_key2-1]=arguments[_key2];for(let map of this.facet(EditorState.phrases))if(Object.prototype.hasOwnProperty.call(map,phrase)){phrase=map[phrase];break}return insert.length&&(phrase=phrase.replace(/\$(\$|\d*)/g,((m,i)=>{if("$"==i)return"$";let n=+(i||1);return!n||n>insert.length?m:insert[n-1]}))),phrase}languageDataAt(name,pos){let side=arguments.length>2&&void 0!==arguments[2]?arguments[2]:-1,values=[];for(let provider of this.facet(languageData))for(let result of provider(this,pos,side))Object.prototype.hasOwnProperty.call(result,name)&&values.push(result[name]);return values}charCategorizer(at){return makeCategorizer(this.languageDataAt("wordChars",at).join(""))}wordAt(pos){let{text:text,from:from,length:length}=this.doc.lineAt(pos),cat=this.charCategorizer(pos),start=pos-from,end=pos-from;for(;start>0;){let prev=findClusterBreak(text,start,!1);if(cat(text.slice(prev,start))!=CharCategory.Word)break;start=prev}for(;end<length;){let next=findClusterBreak(text,end);if(cat(text.slice(end,next))!=CharCategory.Word)break;end=next}return start==end?null:EditorSelection.range(start+from,end+from)}}function combineConfig(configs,defaults){let combine=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},result={};for(let config of configs)for(let key of Object.keys(config)){let value=config[key],current=result[key];if(void 0===current)result[key]=value;else if(current===value||void 0===value);else{if(!Object.hasOwnProperty.call(combine,key))throw new Error("Config merge conflict for field "+key);result[key]=combine[key](current,value)}}for(let key in defaults)void 0===result[key]&&(result[key]=defaults[key]);return result}_exports.EditorState=EditorState,EditorState.allowMultipleSelections=allowMultipleSelections,EditorState.tabSize=Facet.define({combine:values=>values.length?values[0]:4}),EditorState.lineSeparator=lineSeparator,EditorState.readOnly=readOnly,EditorState.phrases=Facet.define({compare(a,b){let kA=Object.keys(a),kB=Object.keys(b);return kA.length==kB.length&&kA.every((k=>a[k]==b[k]))}}),EditorState.languageData=languageData,EditorState.changeFilter=changeFilter,EditorState.transactionFilter=transactionFilter,EditorState.transactionExtender=transactionExtender,Compartment.reconfigure=StateEffect.define();class RangeValue{eq(other){return this==other}range(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:from;return Range$1.create(from,to,this)}}RangeValue.prototype.startSide=RangeValue.prototype.endSide=0,RangeValue.prototype.point=!1,RangeValue.prototype.mapMode=MapMode.TrackDel;let Range$1=class Range{constructor(from,to,value){this.from=from,this.to=to,this.value=value}static create(from,to,value){return new Range(from,to,value)}};function cmpRange(a,b){return a.from-b.from||a.value.startSide-b.value.startSide}class Chunk{constructor(from,to,value,maxPoint){this.from=from,this.to=to,this.value=value,this.maxPoint=maxPoint}get length(){return this.to[this.to.length-1]}findIndex(pos,side,end){let startAt=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,arr=end?this.to:this.from;for(let lo=startAt,hi=arr.length;;){if(lo==hi)return lo;let mid=lo+hi>>1,diff=arr[mid]-pos||(end?this.value[mid].endSide:this.value[mid].startSide)-side;if(mid==lo)return diff>=0?lo:hi;diff>=0?hi=mid:lo=mid+1}}between(offset,from,to,f){for(let i=this.findIndex(from,-1e9,!0),e=this.findIndex(to,1e9,!1,i);i<e;i++)if(!1===f(this.from[i]+offset,this.to[i]+offset,this.value[i]))return!1}map(offset,changes){let value=[],from=[],to=[],newPos=-1,maxPoint=-1;for(let i=0;i<this.value.length;i++){let newFrom,newTo,val=this.value[i],curFrom=this.from[i]+offset,curTo=this.to[i]+offset;if(curFrom==curTo){let mapped=changes.mapPos(curFrom,val.startSide,val.mapMode);if(null==mapped)continue;if(newFrom=newTo=mapped,val.startSide!=val.endSide&&(newTo=changes.mapPos(curFrom,val.endSide),newTo<newFrom))continue}else if(newFrom=changes.mapPos(curFrom,val.startSide),newTo=changes.mapPos(curTo,val.endSide),newFrom>newTo||newFrom==newTo&&val.startSide>0&&val.endSide<=0)continue;(newTo-newFrom||val.endSide-val.startSide)<0||(newPos<0&&(newPos=newFrom),val.point&&(maxPoint=Math.max(maxPoint,newTo-newFrom)),value.push(val),from.push(newFrom-newPos),to.push(newTo-newPos))}return{mapped:value.length?new Chunk(from,to,value,maxPoint):null,pos:newPos}}}class RangeSet{constructor(chunkPos,chunk,nextLayer,maxPoint){this.chunkPos=chunkPos,this.chunk=chunk,this.nextLayer=nextLayer,this.maxPoint=maxPoint}static create(chunkPos,chunk,nextLayer,maxPoint){return new RangeSet(chunkPos,chunk,nextLayer,maxPoint)}get length(){let last=this.chunk.length-1;return last<0?0:Math.max(this.chunkEnd(last),this.nextLayer.length)}get size(){if(this.isEmpty)return 0;let size=this.nextLayer.size;for(let chunk of this.chunk)size+=chunk.value.length;return size}chunkEnd(index){return this.chunkPos[index]+this.chunk[index].length}update(updateSpec){let{add:add=[],sort:sort=!1,filterFrom:filterFrom=0,filterTo:filterTo=this.length}=updateSpec,filter=updateSpec.filter;if(0==add.length&&!filter)return this;if(sort&&(add=add.slice().sort(cmpRange)),this.isEmpty)return add.length?RangeSet.of(add):this;let cur=new LayerCursor(this,null,-1).goto(0),i=0,spill=[],builder=new RangeSetBuilder;for(;cur.value||i<add.length;)if(i<add.length&&(cur.from-add[i].from||cur.startSide-add[i].value.startSide)>=0){let range=add[i++];builder.addInner(range.from,range.to,range.value)||spill.push(range)}else 1==cur.rangeIndex&&cur.chunkIndex<this.chunk.length&&(i==add.length||this.chunkEnd(cur.chunkIndex)<add[i].from)&&(!filter||filterFrom>this.chunkEnd(cur.chunkIndex)||filterTo<this.chunkPos[cur.chunkIndex])&&builder.addChunk(this.chunkPos[cur.chunkIndex],this.chunk[cur.chunkIndex])?cur.nextChunk():((!filter||filterFrom>cur.to||filterTo<cur.from||filter(cur.from,cur.to,cur.value))&&(builder.addInner(cur.from,cur.to,cur.value)||spill.push(Range$1.create(cur.from,cur.to,cur.value))),cur.next());return builder.finishInner(this.nextLayer.isEmpty&&!spill.length?RangeSet.empty:this.nextLayer.update({add:spill,filter:filter,filterFrom:filterFrom,filterTo:filterTo}))}map(changes){if(changes.empty||this.isEmpty)return this;let chunks=[],chunkPos=[],maxPoint=-1;for(let i=0;i<this.chunk.length;i++){let start=this.chunkPos[i],chunk=this.chunk[i],touch=changes.touchesRange(start,start+chunk.length);if(!1===touch)maxPoint=Math.max(maxPoint,chunk.maxPoint),chunks.push(chunk),chunkPos.push(changes.mapPos(start));else if(!0===touch){let{mapped:mapped,pos:pos}=chunk.map(start,changes);mapped&&(maxPoint=Math.max(maxPoint,mapped.maxPoint),chunks.push(mapped),chunkPos.push(pos))}}let next=this.nextLayer.map(changes);return 0==chunks.length?next:new RangeSet(chunkPos,chunks,next||RangeSet.empty,maxPoint)}between(from,to,f){if(!this.isEmpty){for(let i=0;i<this.chunk.length;i++){let start=this.chunkPos[i],chunk=this.chunk[i];if(to>=start&&from<=start+chunk.length&&!1===chunk.between(start,from-start,to-start,f))return}this.nextLayer.between(from,to,f)}}iter(){let from=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;return HeapCursor.from([this]).goto(from)}get isEmpty(){return this.nextLayer==this}static iter(sets){let from=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return HeapCursor.from(sets).goto(from)}static compare(oldSets,newSets,textDiff,comparator){let minPointSize=arguments.length>4&&void 0!==arguments[4]?arguments[4]:-1,a=oldSets.filter((set=>set.maxPoint>0||!set.isEmpty&&set.maxPoint>=minPointSize)),b=newSets.filter((set=>set.maxPoint>0||!set.isEmpty&&set.maxPoint>=minPointSize)),sharedChunks=findSharedChunks(a,b,textDiff),sideA=new SpanCursor(a,sharedChunks,minPointSize),sideB=new SpanCursor(b,sharedChunks,minPointSize);textDiff.iterGaps(((fromA,fromB,length)=>compare(sideA,fromA,sideB,fromB,length,comparator))),textDiff.empty&&0==textDiff.length&&compare(sideA,0,sideB,0,0,comparator)}static eq(oldSets,newSets){let from=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,to=arguments.length>3?arguments[3]:void 0;null==to&&(to=999999999);let a=oldSets.filter((set=>!set.isEmpty&&newSets.indexOf(set)<0)),b=newSets.filter((set=>!set.isEmpty&&oldSets.indexOf(set)<0));if(a.length!=b.length)return!1;if(!a.length)return!0;let sharedChunks=findSharedChunks(a,b),sideA=new SpanCursor(a,sharedChunks,0).goto(from),sideB=new SpanCursor(b,sharedChunks,0).goto(from);for(;;){if(sideA.to!=sideB.to||!sameValues(sideA.active,sideB.active)||sideA.point&&(!sideB.point||!sideA.point.eq(sideB.point)))return!1;if(sideA.to>to)return!0;sideA.next(),sideB.next()}}static spans(sets,from,to,iterator){let cursor=new SpanCursor(sets,null,arguments.length>4&&void 0!==arguments[4]?arguments[4]:-1).goto(from),pos=from,openRanges=cursor.openStart;for(;;){let curTo=Math.min(cursor.to,to);if(cursor.point){let active=cursor.activeForPoint(cursor.to),openCount=cursor.pointFrom<from?active.length+1:Math.min(active.length,openRanges);iterator.point(pos,curTo,cursor.point,active,openCount,cursor.pointRank),openRanges=Math.min(cursor.openEnd(curTo),active.length)}else curTo>pos&&(iterator.span(pos,curTo,cursor.active,openRanges),openRanges=cursor.openEnd(curTo));if(cursor.to>to)return openRanges+(cursor.point&&cursor.to>to?1:0);pos=cursor.to,cursor.next()}}static of(ranges){let sort=arguments.length>1&&void 0!==arguments[1]&&arguments[1],build=new RangeSetBuilder;for(let range of ranges instanceof Range$1?[ranges]:sort?function(ranges){if(ranges.length>1)for(let prev=ranges[0],i=1;i<ranges.length;i++){let cur=ranges[i];if(cmpRange(prev,cur)>0)return ranges.slice().sort(cmpRange);prev=cur}return ranges}(ranges):ranges)build.add(range.from,range.to,range.value);return build.finish()}}RangeSet.empty=new RangeSet([],[],null,-1),RangeSet.empty.nextLayer=RangeSet.empty;class RangeSetBuilder{finishChunk(newArrays){this.chunks.push(new Chunk(this.from,this.to,this.value,this.maxPoint)),this.chunkPos.push(this.chunkStart),this.chunkStart=-1,this.setMaxPoint=Math.max(this.setMaxPoint,this.maxPoint),this.maxPoint=-1,newArrays&&(this.from=[],this.to=[],this.value=[])}constructor(){this.chunks=[],this.chunkPos=[],this.chunkStart=-1,this.last=null,this.lastFrom=-1e9,this.lastTo=-1e9,this.from=[],this.to=[],this.value=[],this.maxPoint=-1,this.setMaxPoint=-1,this.nextLayer=null}add(from,to,value){this.addInner(from,to,value)||(this.nextLayer||(this.nextLayer=new RangeSetBuilder)).add(from,to,value)}addInner(from,to,value){let diff=from-this.lastTo||value.startSide-this.last.endSide;if(diff<=0&&(from-this.lastFrom||value.startSide-this.last.startSide)<0)throw new Error("Ranges must be added sorted by `from` position and `startSide`");return!(diff<0)&&(250==this.from.length&&this.finishChunk(!0),this.chunkStart<0&&(this.chunkStart=from),this.from.push(from-this.chunkStart),this.to.push(to-this.chunkStart),this.last=value,this.lastFrom=from,this.lastTo=to,this.value.push(value),value.point&&(this.maxPoint=Math.max(this.maxPoint,to-from)),!0)}addChunk(from,chunk){if((from-this.lastTo||chunk.value[0].startSide-this.last.endSide)<0)return!1;this.from.length&&this.finishChunk(!0),this.setMaxPoint=Math.max(this.setMaxPoint,chunk.maxPoint),this.chunks.push(chunk),this.chunkPos.push(from);let last=chunk.value.length-1;return this.last=chunk.value[last],this.lastFrom=chunk.from[last]+from,this.lastTo=chunk.to[last]+from,!0}finish(){return this.finishInner(RangeSet.empty)}finishInner(next){if(this.from.length&&this.finishChunk(!1),0==this.chunks.length)return next;let result=RangeSet.create(this.chunkPos,this.chunks,this.nextLayer?this.nextLayer.finishInner(next):next,this.setMaxPoint);return this.from=null,result}}function findSharedChunks(a,b,textDiff){let inA=new Map;for(let set of a)for(let i=0;i<set.chunk.length;i++)set.chunk[i].maxPoint<=0&&inA.set(set.chunk[i],set.chunkPos[i]);let shared=new Set;for(let set of b)for(let i=0;i<set.chunk.length;i++){let known=inA.get(set.chunk[i]);null==known||(textDiff?textDiff.mapPos(known):known)!=set.chunkPos[i]||(null==textDiff?void 0:textDiff.touchesRange(known,known+set.chunk[i].length))||shared.add(set.chunk[i])}return shared}class LayerCursor{constructor(layer,skip,minPoint){let rank=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;this.layer=layer,this.skip=skip,this.minPoint=minPoint,this.rank=rank}get startSide(){return this.value?this.value.startSide:0}get endSide(){return this.value?this.value.endSide:0}goto(pos){let side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1e9;return this.chunkIndex=this.rangeIndex=0,this.gotoInner(pos,side,!1),this}gotoInner(pos,side,forward){for(;this.chunkIndex<this.layer.chunk.length;){let next=this.layer.chunk[this.chunkIndex];if(!(this.skip&&this.skip.has(next)||this.layer.chunkEnd(this.chunkIndex)<pos||next.maxPoint<this.minPoint))break;this.chunkIndex++,forward=!1}if(this.chunkIndex<this.layer.chunk.length){let rangeIndex=this.layer.chunk[this.chunkIndex].findIndex(pos-this.layer.chunkPos[this.chunkIndex],side,!0);(!forward||this.rangeIndex<rangeIndex)&&this.setRangeIndex(rangeIndex)}this.next()}forward(pos,side){(this.to-pos||this.endSide-side)<0&&this.gotoInner(pos,side,!0)}next(){for(;;){if(this.chunkIndex==this.layer.chunk.length){this.from=this.to=1e9,this.value=null;break}{let chunkPos=this.layer.chunkPos[this.chunkIndex],chunk=this.layer.chunk[this.chunkIndex],from=chunkPos+chunk.from[this.rangeIndex];if(this.from=from,this.to=chunkPos+chunk.to[this.rangeIndex],this.value=chunk.value[this.rangeIndex],this.setRangeIndex(this.rangeIndex+1),this.minPoint<0||this.value.point&&this.to-this.from>=this.minPoint)break}}}setRangeIndex(index){if(index==this.layer.chunk[this.chunkIndex].value.length){if(this.chunkIndex++,this.skip)for(;this.chunkIndex<this.layer.chunk.length&&this.skip.has(this.layer.chunk[this.chunkIndex]);)this.chunkIndex++;this.rangeIndex=0}else this.rangeIndex=index}nextChunk(){this.chunkIndex++,this.rangeIndex=0,this.next()}compare(other){return this.from-other.from||this.startSide-other.startSide||this.rank-other.rank||this.to-other.to||this.endSide-other.endSide}}class HeapCursor{constructor(heap){this.heap=heap}static from(sets){let skip=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,minPoint=arguments.length>2&&void 0!==arguments[2]?arguments[2]:-1,heap=[];for(let i=0;i<sets.length;i++)for(let cur=sets[i];!cur.isEmpty;cur=cur.nextLayer)cur.maxPoint>=minPoint&&heap.push(new LayerCursor(cur,skip,minPoint,i));return 1==heap.length?heap[0]:new HeapCursor(heap)}get startSide(){return this.value?this.value.startSide:0}goto(pos){let side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1e9;for(let cur of this.heap)cur.goto(pos,side);for(let i=this.heap.length>>1;i>=0;i--)heapBubble(this.heap,i);return this.next(),this}forward(pos,side){for(let cur of this.heap)cur.forward(pos,side);for(let i=this.heap.length>>1;i>=0;i--)heapBubble(this.heap,i);(this.to-pos||this.value.endSide-side)<0&&this.next()}next(){if(0==this.heap.length)this.from=this.to=1e9,this.value=null,this.rank=-1;else{let top=this.heap[0];this.from=top.from,this.to=top.to,this.value=top.value,this.rank=top.rank,top.value&&top.next(),heapBubble(this.heap,0)}}}function heapBubble(heap,index){for(let cur=heap[index];;){let childIndex=1+(index<<1);if(childIndex>=heap.length)break;let child=heap[childIndex];if(childIndex+1<heap.length&&child.compare(heap[childIndex+1])>=0&&(child=heap[childIndex+1],childIndex++),cur.compare(child)<0)break;heap[childIndex]=cur,heap[index]=child,index=childIndex}}class SpanCursor{constructor(sets,skip,minPoint){this.minPoint=minPoint,this.active=[],this.activeTo=[],this.activeRank=[],this.minActive=-1,this.point=null,this.pointFrom=0,this.pointRank=0,this.to=-1e9,this.endSide=0,this.openStart=-1,this.cursor=HeapCursor.from(sets,skip,minPoint)}goto(pos){let side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:-1e9;return this.cursor.goto(pos,side),this.active.length=this.activeTo.length=this.activeRank.length=0,this.minActive=-1,this.to=pos,this.endSide=side,this.openStart=-1,this.next(),this}forward(pos,side){for(;this.minActive>-1&&(this.activeTo[this.minActive]-pos||this.active[this.minActive].endSide-side)<0;)this.removeActive(this.minActive);this.cursor.forward(pos,side)}removeActive(index){remove(this.active,index),remove(this.activeTo,index),remove(this.activeRank,index),this.minActive=findMinIndex(this.active,this.activeTo)}addActive(trackOpen){let i=0,{value:value,to:to,rank:rank}=this.cursor;for(;i<this.activeRank.length&&this.activeRank[i]<=rank;)i++;insert(this.active,i,value),insert(this.activeTo,i,to),insert(this.activeRank,i,rank),trackOpen&&insert(trackOpen,i,this.cursor.from),this.minActive=findMinIndex(this.active,this.activeTo)}next(){let from=this.to,wasPoint=this.point;this.point=null;let trackOpen=this.openStart<0?[]:null;for(;;){let a=this.minActive;if(a>-1&&(this.activeTo[a]-this.cursor.from||this.active[a].endSide-this.cursor.startSide)<0){if(this.activeTo[a]>from){this.to=this.activeTo[a],this.endSide=this.active[a].endSide;break}this.removeActive(a),trackOpen&&remove(trackOpen,a)}else{if(!this.cursor.value){this.to=this.endSide=1e9;break}if(this.cursor.from>from){this.to=this.cursor.from,this.endSide=this.cursor.startSide;break}{let nextVal=this.cursor.value;if(nextVal.point){if(!(wasPoint&&this.cursor.to==this.to&&this.cursor.from<this.cursor.to)){this.point=nextVal,this.pointFrom=this.cursor.from,this.pointRank=this.cursor.rank,this.to=this.cursor.to,this.endSide=nextVal.endSide,this.cursor.next(),this.forward(this.to,this.endSide);break}this.cursor.next()}else this.addActive(trackOpen),this.cursor.next()}}}if(trackOpen){this.openStart=0;for(let i=trackOpen.length-1;i>=0&&trackOpen[i]<from;i--)this.openStart++}}activeForPoint(to){if(!this.active.length)return this.active;let active=[];for(let i=this.active.length-1;i>=0&&!(this.activeRank[i]<this.pointRank);i--)(this.activeTo[i]>to||this.activeTo[i]==to&&this.active[i].endSide>=this.point.endSide)&&active.push(this.active[i]);return active.reverse()}openEnd(to){let open=0;for(let i=this.activeTo.length-1;i>=0&&this.activeTo[i]>to;i--)open++;return open}}function compare(a,startA,b,startB,length,comparator){a.goto(startA),b.goto(startB);let endB=startB+length,pos=startB,dPos=startB-startA;for(;;){let diff=a.to+dPos-b.to||a.endSide-b.endSide,end=diff<0?a.to+dPos:b.to,clipEnd=Math.min(end,endB);if(a.point||b.point?a.point&&b.point&&(a.point==b.point||a.point.eq(b.point))&&sameValues(a.activeForPoint(a.to),b.activeForPoint(b.to))||comparator.comparePoint(pos,clipEnd,a.point,b.point):clipEnd>pos&&!sameValues(a.active,b.active)&&comparator.compareRange(pos,clipEnd,a.active,b.active),end>endB)break;pos=end,diff<=0&&a.next(),diff>=0&&b.next()}}function sameValues(a,b){if(a.length!=b.length)return!1;for(let i=0;i<a.length;i++)if(a[i]!=b[i]&&!a[i].eq(b[i]))return!1;return!0}function remove(array,index){for(let i=index,e=array.length-1;i<e;i++)array[i]=array[i+1];array.pop()}function insert(array,index,value){for(let i=array.length-1;i>=index;i--)array[i+1]=array[i];array[index]=value}function findMinIndex(value,array){let found=-1,foundPos=1e9;for(let i=0;i<array.length;i++)(array[i]-foundPos||value[i].endSide-value[found].endSide)<0&&(found=i,foundPos=array[i]);return found}function countColumn(string,tabSize){let to=arguments.length>2&&void 0!==arguments[2]?arguments[2]:string.length,n=0;for(let i=0;i<to;)9==string.charCodeAt(i)?(n+=tabSize-n%tabSize,i++):(n++,i=findClusterBreak(string,i));return n}function findColumn(string,col,tabSize,strict){for(let i=0,n=0;;){if(n>=col)return i;if(i==string.length)break;n+=9==string.charCodeAt(i)?tabSize-n%tabSize:1,i=findClusterBreak(string,i)}return!0===strict?-1:string.length}const COUNT="undefined"==typeof Symbol?"__ͼ":Symbol.for("ͼ"),SET="undefined"==typeof Symbol?"__styleSet"+Math.floor(1e8*Math.random()):Symbol("styleSet"),top="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:{};class StyleModule{constructor(spec,options){this.rules=[];let{finish:finish}=options||{};function splitSelector(selector){return/^@/.test(selector)?[selector]:selector.split(/,\s*/)}function render(selectors,spec,target,isKeyframes){let local=[],isAt=/^@(\w+)\b/.exec(selectors[0]),keyframes=isAt&&"keyframes"==isAt[1];if(isAt&&null==spec)return target.push(selectors[0]+";");for(let prop in spec){let value=spec[prop];if(/&/.test(prop))render(prop.split(/,\s*/).map((part=>selectors.map((sel=>part.replace(/&/,sel))))).reduce(((a,b)=>a.concat(b))),value,target);else if(value&&"object"==typeof value){if(!isAt)throw new RangeError("The value of a property ("+prop+") should be a primitive value.");render(splitSelector(prop),value,local,keyframes)}else null!=value&&local.push(prop.replace(/_.*/,"").replace(/[A-Z]/g,(l=>"-"+l.toLowerCase()))+": "+value+";")}(local.length||keyframes)&&target.push((!finish||isAt||isKeyframes?selectors:selectors.map(finish)).join(", ")+" {"+local.join(" ")+"}")}for(let prop in spec)render(splitSelector(prop),spec[prop],this.rules)}getRules(){return this.rules.join("\n")}static newName(){let id=top[COUNT]||1;return top[COUNT]=id+1,"ͼ"+id.toString(36)}static mount(root,modules){(root[SET]||new StyleSet(root)).mount(Array.isArray(modules)?modules:[modules])}}let adoptedSet=new Map;class StyleSet{constructor(root){let doc=root.ownerDocument||root,win=doc.defaultView;if(!root.head&&root.adoptedStyleSheets&&win.CSSStyleSheet){let adopted=adoptedSet.get(doc);if(adopted)return root.adoptedStyleSheets=[adopted.sheet,...root.adoptedStyleSheets],root[SET]=adopted;this.sheet=new win.CSSStyleSheet,root.adoptedStyleSheets=[this.sheet,...root.adoptedStyleSheets],adoptedSet.set(doc,this)}else{this.styleTag=doc.createElement("style");let target=root.head||root;target.insertBefore(this.styleTag,target.firstChild)}this.modules=[],root[SET]=this}mount(modules){let sheet=this.sheet,pos=0,j=0;for(let i=0;i<modules.length;i++){let mod=modules[i],index=this.modules.indexOf(mod);if(index<j&&index>-1&&(this.modules.splice(index,1),j--,index=-1),-1==index){if(this.modules.splice(j++,0,mod),sheet)for(let k=0;k<mod.rules.length;k++)sheet.insertRule(mod.rules[k],pos++)}else{for(;j<index;)pos+=this.modules[j++].rules.length;pos+=mod.rules.length,j++}}if(!sheet){let text="";for(let i=0;i<this.modules.length;i++)text+=this.modules[i].getRules()+"\n";this.styleTag.textContent=text}}}for(var base={8:"Backspace",9:"Tab",10:"Enter",12:"NumLock",13:"Enter",16:"Shift",17:"Control",18:"Alt",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",44:"PrintScreen",45:"Insert",46:"Delete",59:";",61:"=",91:"Meta",92:"Meta",106:"*",107:"+",108:",",109:"-",110:".",111:"/",144:"NumLock",145:"ScrollLock",160:"Shift",161:"Shift",162:"Control",163:"Control",164:"Alt",165:"Alt",173:"-",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'"},shift={48:")",49:"!",50:"@",51:"#",52:"$",53:"%",54:"^",55:"&",56:"*",57:"(",59:":",61:"+",173:"_",186:":",187:"+",188:"<",189:"_",190:">",191:"?",192:"~",219:"{",220:"|",221:"}",222:'"'},mac="undefined"!=typeof navigator&&/Mac/.test(navigator.platform),ie$1="undefined"!=typeof navigator&&/MSIE \d|Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(navigator.userAgent),i=0;i<10;i++)base[48+i]=base[96+i]=String(i);for(i=1;i<=24;i++)base[i+111]="F"+i;for(i=65;i<=90;i++)base[i]=String.fromCharCode(i+32),shift[i]=String.fromCharCode(i);for(var code in base)shift.hasOwnProperty(code)||(shift[code]=base[code]);function getSelection(root){let target;return target=11==root.nodeType?root.getSelection?root:root.ownerDocument:root,target.getSelection()}function contains(dom,node){return!!node&&(dom==node||dom.contains(1!=node.nodeType?node.parentNode:node))}function hasSelection(dom,selection){if(!selection.anchorNode)return!1;try{return contains(dom,selection.anchorNode)}catch(_){return!1}}function clientRectsFor(dom){return 3==dom.nodeType?textRange(dom,0,dom.nodeValue.length).getClientRects():1==dom.nodeType?dom.getClientRects():[]}function isEquivalentPosition(node,off,targetNode,targetOff){return!!targetNode&&(scanFor(node,off,targetNode,targetOff,-1)||scanFor(node,off,targetNode,targetOff,1))}function domIndex(node){for(var index=0;;index++)if(!(node=node.previousSibling))return index}function scanFor(node,off,targetNode,targetOff,dir){for(;;){if(node==targetNode&&off==targetOff)return!0;if(off==(dir<0?0:maxOffset(node))){if("DIV"==node.nodeName)return!1;let parent=node.parentNode;if(!parent||1!=parent.nodeType)return!1;off=domIndex(node)+(dir<0?0:1),node=parent}else{if(1!=node.nodeType)return!1;if(1==(node=node.childNodes[off+(dir<0?-1:0)]).nodeType&&"false"==node.contentEditable)return!1;off=dir<0?maxOffset(node):0}}}function maxOffset(node){return 3==node.nodeType?node.nodeValue.length:node.childNodes.length}function flattenRect(rect,left){let x=left?rect.left:rect.right;return{left:x,right:x,top:rect.top,bottom:rect.bottom}}function windowRect(win){return{left:0,right:win.innerWidth,top:0,bottom:win.innerHeight}}class DOMSelectionState{constructor(){this.anchorNode=null,this.anchorOffset=0,this.focusNode=null,this.focusOffset=0}eq(domSel){return this.anchorNode==domSel.anchorNode&&this.anchorOffset==domSel.anchorOffset&&this.focusNode==domSel.focusNode&&this.focusOffset==domSel.focusOffset}setRange(range){let{anchorNode:anchorNode,focusNode:focusNode}=range;this.set(anchorNode,Math.min(range.anchorOffset,anchorNode?maxOffset(anchorNode):0),focusNode,Math.min(range.focusOffset,focusNode?maxOffset(focusNode):0))}set(anchorNode,anchorOffset,focusNode,focusOffset){this.anchorNode=anchorNode,this.anchorOffset=anchorOffset,this.focusNode=focusNode,this.focusOffset=focusOffset}}let scratchRange,preventScrollSupported=null;function focusPreventScroll(dom){if(dom.setActive)return dom.setActive();if(preventScrollSupported)return dom.focus(preventScrollSupported);let stack=[];for(let cur=dom;cur&&(stack.push(cur,cur.scrollTop,cur.scrollLeft),cur!=cur.ownerDocument);cur=cur.parentNode);if(dom.focus(null==preventScrollSupported?{get preventScroll(){return preventScrollSupported={preventScroll:!0},!0}}:void 0),!preventScrollSupported){preventScrollSupported=!1;for(let i=0;i<stack.length;){let elt=stack[i++],top=stack[i++],left=stack[i++];elt.scrollTop!=top&&(elt.scrollTop=top),elt.scrollLeft!=left&&(elt.scrollLeft=left)}}}function textRange(node,from){let to=arguments.length>2&&void 0!==arguments[2]?arguments[2]:from,range=scratchRange||(scratchRange=document.createRange());return range.setEnd(node,to),range.setStart(node,from),range}function dispatchKey(elt,name,code){let options={key:name,code:name,keyCode:code,which:code,cancelable:!0},down=new KeyboardEvent("keydown",options);down.synthetic=!0,elt.dispatchEvent(down);let up=new KeyboardEvent("keyup",options);return up.synthetic=!0,elt.dispatchEvent(up),down.defaultPrevented||up.defaultPrevented}function clearAttributes(node){for(;node.attributes.length;)node.removeAttributeNode(node.attributes[0])}class DOMPos{constructor(node,offset){let precise=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];this.node=node,this.offset=offset,this.precise=precise}static before(dom,precise){return new DOMPos(dom.parentNode,domIndex(dom),precise)}static after(dom,precise){return new DOMPos(dom.parentNode,domIndex(dom)+1,precise)}}const noChildren=[];class ContentView{constructor(){this.parent=null,this.dom=null,this.dirty=2}get overrideDOMText(){return null}get posAtStart(){return this.parent?this.parent.posBefore(this):0}get posAtEnd(){return this.posAtStart+this.length}posBefore(view){let pos=this.posAtStart;for(let child of this.children){if(child==view)return pos;pos+=child.length+child.breakAfter}throw new RangeError("Invalid child in posBefore")}posAfter(view){return this.posBefore(view)+view.length}sync(view,track){if(2&this.dirty){let next,parent=this.dom,prev=null;for(let child of this.children){if(child.dirty){if(!child.dom&&(next=prev?prev.nextSibling:parent.firstChild)){let contentView=ContentView.get(next);(!contentView||!contentView.parent&&contentView.canReuseDOM(child))&&child.reuseDOM(next)}child.sync(view,track),child.dirty=0}if(next=prev?prev.nextSibling:parent.firstChild,track&&!track.written&&track.node==parent&&next!=child.dom&&(track.written=!0),child.dom.parentNode==parent)for(;next&&next!=child.dom;)next=rm$1(next);else parent.insertBefore(child.dom,next);prev=child.dom}for(next=prev?prev.nextSibling:parent.firstChild,next&&track&&track.node==parent&&(track.written=!0);next;)next=rm$1(next)}else if(1&this.dirty)for(let child of this.children)child.dirty&&(child.sync(view,track),child.dirty=0)}reuseDOM(_dom){}localPosFromDOM(node,offset){let after;if(node==this.dom)after=this.dom.childNodes[offset];else{let bias=0==maxOffset(node)?0:0==offset?-1:1;for(;;){let parent=node.parentNode;if(parent==this.dom)break;0==bias&&parent.firstChild!=parent.lastChild&&(bias=node==parent.firstChild?-1:1),node=parent}after=bias<0?node:node.nextSibling}if(after==this.dom.firstChild)return 0;for(;after&&!ContentView.get(after);)after=after.nextSibling;if(!after)return this.length;for(let i=0,pos=0;;i++){let child=this.children[i];if(child.dom==after)return pos;pos+=child.length+child.breakAfter}}domBoundsAround(from,to){let offset=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,fromI=-1,fromStart=-1,toI=-1,toEnd=-1;for(let i=0,pos=offset,prevEnd=offset;i<this.children.length;i++){let child=this.children[i],end=pos+child.length;if(pos<from&&end>to)return child.domBoundsAround(from,to,pos);if(end>=from&&-1==fromI&&(fromI=i,fromStart=pos),pos>to&&child.dom.parentNode==this.dom){toI=i,toEnd=prevEnd;break}prevEnd=end,pos=end+child.breakAfter}return{from:fromStart,to:toEnd<0?offset+this.length:toEnd,startDOM:(fromI?this.children[fromI-1].dom.nextSibling:null)||this.dom.firstChild,endDOM:toI<this.children.length&&toI>=0?this.children[toI].dom:null}}markDirty(){let andParent=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.dirty|=2,this.markParentsDirty(andParent)}markParentsDirty(childList){for(let parent=this.parent;parent;parent=parent.parent){if(childList&&(parent.dirty|=2),1&parent.dirty)return;parent.dirty|=1,childList=!1}}setParent(parent){this.parent!=parent&&(this.parent=parent,this.dirty&&this.markParentsDirty(!0))}setDOM(dom){this.dom&&(this.dom.cmView=null),this.dom=dom,dom.cmView=this}get rootView(){for(let v=this;;){let parent=v.parent;if(!parent)return v;v=parent}}replaceChildren(from,to){let children=arguments.length>2&&void 0!==arguments[2]?arguments[2]:noChildren;this.markDirty();for(let i=from;i<to;i++){let child=this.children[i];child.parent==this&&child.destroy()}this.children.splice(from,to-from,...children);for(let i=0;i<children.length;i++)children[i].setParent(this)}ignoreMutation(_rec){return!1}ignoreEvent(_event){return!1}childCursor(){let pos=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.length;return new ChildCursor(this.children,pos,this.children.length)}childPos(pos){let bias=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;return this.childCursor().findPos(pos,bias)}toString(){let name=this.constructor.name.replace("View","");return name+(this.children.length?"("+this.children.join()+")":this.length?"["+("Text"==name?this.text:this.length)+"]":"")+(this.breakAfter?"#":"")}static get(node){return node.cmView}get isEditable(){return!0}get isWidget(){return!1}get isHidden(){return!1}merge(from,to,source,hasStart,openStart,openEnd){return!1}become(other){return!1}canReuseDOM(other){return other.constructor==this.constructor}getSide(){return 0}destroy(){this.parent=null}}function rm$1(dom){let next=dom.nextSibling;return dom.parentNode.removeChild(dom),next}ContentView.prototype.breakAfter=0;class ChildCursor{constructor(children,pos,i){this.children=children,this.pos=pos,this.i=i,this.off=0}findPos(pos){let bias=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;for(;;){if(pos>this.pos||pos==this.pos&&(bias>0||0==this.i||this.children[this.i-1].breakAfter))return this.off=pos-this.pos,this;let next=this.children[--this.i];this.pos-=next.length+next.breakAfter}}}function replaceRange(parent,fromI,fromOff,toI,toOff,insert,breakAtStart,openStart,openEnd){let{children:children}=parent,before=children.length?children[fromI]:null,last=insert.length?insert[insert.length-1]:null,breakAtEnd=last?last.breakAfter:breakAtStart;if(!(fromI==toI&&before&&!breakAtStart&&!breakAtEnd&&insert.length<2&&before.merge(fromOff,toOff,insert.length?last:null,0==fromOff,openStart,openEnd))){if(toI<children.length){let after=children[toI];after&&toOff<after.length?(fromI==toI&&(after=after.split(toOff),toOff=0),!breakAtEnd&&last&&after.merge(0,toOff,last,!0,0,openEnd)?insert[insert.length-1]=after:(toOff&&after.merge(0,toOff,null,!1,0,openEnd),insert.push(after))):(null==after?void 0:after.breakAfter)&&(last?last.breakAfter=1:breakAtStart=1),toI++}for(before&&(before.breakAfter=breakAtStart,fromOff>0&&(!breakAtStart&&insert.length&&before.merge(fromOff,before.length,insert[0],!1,openStart,0)?before.breakAfter=insert.shift().breakAfter:(fromOff<before.length||before.children.length&&0==before.children[before.children.length-1].length)&&before.merge(fromOff,before.length,null,!1,openStart,0),fromI++));fromI<toI&&insert.length;)if(children[toI-1].become(insert[insert.length-1]))toI--,insert.pop(),openEnd=insert.length?0:openStart;else{if(!children[fromI].become(insert[0]))break;fromI++,insert.shift(),openStart=insert.length?0:openEnd}!insert.length&&fromI&&toI<children.length&&!children[fromI-1].breakAfter&&children[toI].merge(0,0,children[fromI-1],!1,openStart,openEnd)&&fromI--,(fromI<toI||insert.length)&&parent.replaceChildren(fromI,toI,insert)}}function mergeChildrenInto(parent,from,to,insert,openStart,openEnd){let cur=parent.childCursor(),{i:toI,off:toOff}=cur.findPos(to,1),{i:fromI,off:fromOff}=cur.findPos(from,-1),dLen=from-to;for(let view of insert)dLen+=view.length;parent.length+=dLen,replaceRange(parent,fromI,fromOff,toI,toOff,insert,0,openStart,openEnd)}let nav="undefined"!=typeof navigator?navigator:{userAgent:"",vendor:"",platform:""},doc="undefined"!=typeof document?document:{documentElement:{style:{}}};const ie_edge=/Edge\/(\d+)/.exec(nav.userAgent),ie_upto10=/MSIE \d/.test(nav.userAgent),ie_11up=/Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(nav.userAgent),ie=!!(ie_upto10||ie_11up||ie_edge),gecko=!ie&&/gecko\/(\d+)/i.test(nav.userAgent),chrome=!ie&&/Chrome\/(\d+)/.exec(nav.userAgent),webkit="webkitFontSmoothing"in doc.documentElement.style,safari=!ie&&/Apple Computer/.test(nav.vendor),ios=safari&&(/Mobile\/\w+/.test(nav.userAgent)||nav.maxTouchPoints>2);var browser={mac:ios||/Mac/.test(nav.platform),windows:/Win/.test(nav.platform),linux:/Linux|X11/.test(nav.platform),ie:ie,ie_version:ie_upto10?doc.documentMode||6:ie_11up?+ie_11up[1]:ie_edge?+ie_edge[1]:0,gecko:gecko,gecko_version:gecko?+(/Firefox\/(\d+)/.exec(nav.userAgent)||[0,0])[1]:0,chrome:!!chrome,chrome_version:chrome?+chrome[1]:0,ios:ios,android:/Android\b/.test(nav.userAgent),webkit:webkit,safari:safari,webkit_version:webkit?+(/\bAppleWebKit\/(\d+)/.exec(navigator.userAgent)||[0,0])[1]:0,tabSize:null!=doc.documentElement.style.tabSize?"tab-size":"-moz-tab-size"};class TextView extends ContentView{constructor(text){super(),this.text=text}get length(){return this.text.length}createDOM(textDOM){this.setDOM(textDOM||document.createTextNode(this.text))}sync(view,track){this.dom||this.createDOM(),this.dom.nodeValue!=this.text&&(track&&track.node==this.dom&&(track.written=!0),this.dom.nodeValue=this.text)}reuseDOM(dom){3==dom.nodeType&&this.createDOM(dom)}merge(from,to,source){return(!source||source instanceof TextView&&!(this.length-(to-from)+source.length>256))&&(this.text=this.text.slice(0,from)+(source?source.text:"")+this.text.slice(to),this.markDirty(),!0)}split(from){let result=new TextView(this.text.slice(from));return this.text=this.text.slice(0,from),this.markDirty(),result}localPosFromDOM(node,offset){return node==this.dom?offset:offset?this.text.length:0}domAtPos(pos){return new DOMPos(this.dom,pos)}domBoundsAround(_from,_to,offset){return{from:offset,to:offset+this.length,startDOM:this.dom,endDOM:this.dom.nextSibling}}coordsAt(pos,side){return textCoords(this.dom,pos,side)}}class MarkView extends ContentView{constructor(mark){let children=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],length=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;super(),this.mark=mark,this.children=children,this.length=length;for(let ch of children)ch.setParent(this)}setAttrs(dom){if(clearAttributes(dom),this.mark.class&&(dom.className=this.mark.class),this.mark.attrs)for(let name in this.mark.attrs)dom.setAttribute(name,this.mark.attrs[name]);return dom}reuseDOM(node){node.nodeName==this.mark.tagName.toUpperCase()&&(this.setDOM(node),this.dirty|=6)}sync(view,track){this.dom?4&this.dirty&&this.setAttrs(this.dom):this.setDOM(this.setAttrs(document.createElement(this.mark.tagName))),super.sync(view,track)}merge(from,to,source,_hasStart,openStart,openEnd){return(!source||!(!(source instanceof MarkView&&source.mark.eq(this.mark))||from&&openStart<=0||to<this.length&&openEnd<=0))&&(mergeChildrenInto(this,from,to,source?source.children:[],openStart-1,openEnd-1),this.markDirty(),!0)}split(from){let result=[],off=0,detachFrom=-1,i=0;for(let elt of this.children){let end=off+elt.length;end>from&&result.push(off<from?elt.split(from-off):elt),detachFrom<0&&off>=from&&(detachFrom=i),off=end,i++}let length=this.length-from;return this.length=from,detachFrom>-1&&(this.children.length=detachFrom,this.markDirty()),new MarkView(this.mark,result,length)}domAtPos(pos){return inlineDOMAtPos(this,pos)}coordsAt(pos,side){return coordsInChildren(this,pos,side)}}function textCoords(text,pos,side){let length=text.nodeValue.length;pos>length&&(pos=length);let from=pos,to=pos,flatten=0;0==pos&&side<0||pos==length&&side>=0?browser.chrome||browser.gecko||(pos?(from--,flatten=1):to<length&&(to++,flatten=-1)):side<0?from--:to<length&&to++;let rects=textRange(text,from,to).getClientRects();if(!rects.length)return null;let rect=rects[(flatten?flatten<0:side>=0)?0:rects.length-1];return browser.safari&&!flatten&&0==rect.width&&(rect=Array.prototype.find.call(rects,(r=>r.width))||rect),flatten?flattenRect(rect,flatten<0):rect||null}class WidgetView extends ContentView{constructor(widget,length,side){super(),this.widget=widget,this.length=length,this.side=side,this.prevWidget=null}static create(widget,length,side){return new(widget.customView||WidgetView)(widget,length,side)}split(from){let result=WidgetView.create(this.widget,this.length-from,this.side);return this.length-=from,result}sync(view){this.dom&&this.widget.updateDOM(this.dom,view)||(this.dom&&this.prevWidget&&this.prevWidget.destroy(this.dom),this.prevWidget=null,this.setDOM(this.widget.toDOM(view)),this.dom.contentEditable="false")}getSide(){return this.side}merge(from,to,source,hasStart,openStart,openEnd){return!(source&&(!(source instanceof WidgetView&&this.widget.compare(source.widget))||from>0&&openStart<=0||to<this.length&&openEnd<=0))&&(this.length=from+(source?source.length:0)+(this.length-to),!0)}become(other){return other instanceof WidgetView&&other.side==this.side&&this.widget.constructor==other.widget.constructor&&(this.widget.compare(other.widget)||this.markDirty(!0),this.dom&&!this.prevWidget&&(this.prevWidget=this.widget),this.widget=other.widget,this.length=other.length,!0)}ignoreMutation(){return!0}ignoreEvent(event){return this.widget.ignoreEvent(event)}get overrideDOMText(){if(0==this.length)return Text.empty;let top=this;for(;top.parent;)top=top.parent;let{view:view}=top,text=view&&view.state.doc,start=this.posAtStart;return text?text.slice(start,start+this.length):Text.empty}domAtPos(pos){return(this.length?0==pos:this.side>0)?DOMPos.before(this.dom):DOMPos.after(this.dom,pos==this.length)}domBoundsAround(){return null}coordsAt(pos,side){let custom=this.widget.coordsAt(this.dom,pos,side);if(custom)return custom;let rects=this.dom.getClientRects(),rect=null;if(!rects.length)return null;let fromBack=this.side?this.side<0:pos>0;for(let i=fromBack?rects.length-1:0;rect=rects[i],!(pos>0?0==i:i==rects.length-1||rect.top<rect.bottom);i+=fromBack?-1:1);return flattenRect(rect,!fromBack)}get isEditable(){return!1}get isWidget(){return!0}get isHidden(){return this.widget.isHidden}destroy(){super.destroy(),this.dom&&this.widget.destroy(this.dom)}}class CompositionView extends WidgetView{domAtPos(pos){let{topView:topView,text:text}=this.widget;return topView?scanCompositionTree(pos,0,topView,text,this.length-topView.length,((v,p)=>v.domAtPos(p)),((text,p)=>new DOMPos(text,Math.min(p,text.nodeValue.length)))):new DOMPos(text,Math.min(pos,text.nodeValue.length))}sync(){this.setDOM(this.widget.toDOM())}localPosFromDOM(node,offset){let{topView:topView,text:text}=this.widget;return topView?posFromDOMInCompositionTree(node,offset,topView,text,this.length-topView.length):Math.min(offset,this.length)}ignoreMutation(){return!1}get overrideDOMText(){return null}coordsAt(pos,side){let{topView:topView,text:text}=this.widget;return topView?scanCompositionTree(pos,side,topView,text,this.length-topView.length,((v,pos,side)=>v.coordsAt(pos,side)),((text,pos,side)=>textCoords(text,pos,side))):textCoords(text,pos,side)}destroy(){var _a;super.destroy(),null===(_a=this.widget.topView)||void 0===_a||_a.destroy()}get isEditable(){return!0}canReuseDOM(){return!0}}function scanCompositionTree(pos,side,view,text,dLen,enterView,fromText){if(view instanceof MarkView){for(let child=view.dom.firstChild;child;child=child.nextSibling){let desc=ContentView.get(child);if(desc){let hasComp=contains(child,text),len=desc.length+(hasComp?dLen:0);if(pos<len||pos==len&&desc.getSide()<=0)return hasComp?scanCompositionTree(pos,side,desc,text,dLen,enterView,fromText):enterView(desc,pos,side);pos-=len}else{let inner=scanCompositionNode(pos,side,child,fromText);if("number"!=typeof inner)return inner;pos=inner}}return enterView(view,view.length,-1)}return view.dom==text?fromText(text,pos,side):enterView(view,pos,side)}function scanCompositionNode(pos,side,node,fromText){if(3==node.nodeType){let len=node.nodeValue.length;if(pos<=len)return fromText(node,pos,side);pos-=len}else if(1==node.nodeType&&"false"!=node.contentEditable)for(let child=node.firstChild;child;child=child.nextSibling){let inner=scanCompositionNode(pos,side,child,fromText);if("number"!=typeof inner)return inner;pos=inner}return pos}function posFromDOMInCompositionTree(node,offset,view,text,dLen){if(view instanceof MarkView){let pos=0;for(let child=view.dom.firstChild;child;child=child.nextSibling){let childView=ContentView.get(child);if(childView){let hasComp=contains(child,text);if(contains(child,node))return pos+(hasComp?posFromDOMInCompositionTree(node,offset,childView,text,dLen):childView.localPosFromDOM(node,offset));pos+=childView.length+(hasComp?dLen:0)}else{let inner=posFromDOMInOpaqueNode(node,offset,child);if(null!=inner.result)return pos+inner.result;pos+=inner.size}}}else if(view.dom==text)return Math.min(offset,text.nodeValue.length);return view.localPosFromDOM(node,offset)}function posFromDOMInOpaqueNode(node,offset,target){if(3==target.nodeType)return node==target?{result:offset}:{size:target.nodeValue.length};if(1!=target.nodeType||"false"==target.contentEditable)return target.contains(node)?{result:0}:{size:0};{let pos=0;for(let child=target.firstChild,i=0;;child=child.nextSibling,i++){if(node==target&&i==offset)return{result:pos};if(!child)return{size:pos};let inner=posFromDOMInOpaqueNode(node,offset,child);if(null!=inner.result)return{result:offset+inner.result};pos+=inner.size}}}class WidgetBufferView extends ContentView{constructor(side){super(),this.side=side}get length(){return 0}merge(){return!1}become(other){return other instanceof WidgetBufferView&&other.side==this.side}split(){return new WidgetBufferView(this.side)}sync(){if(!this.dom){let dom=document.createElement("img");dom.className="cm-widgetBuffer",dom.setAttribute("aria-hidden","true"),this.setDOM(dom)}}getSide(){return this.side}domAtPos(pos){return this.side>0?DOMPos.before(this.dom):DOMPos.after(this.dom)}localPosFromDOM(){return 0}domBoundsAround(){return null}coordsAt(pos){return this.dom.getBoundingClientRect()}get overrideDOMText(){return Text.empty}get isHidden(){return!0}}function inlineDOMAtPos(parent,pos){let dom=parent.dom,{children:children}=parent,i=0;for(let off=0;i<children.length;i++){let child=children[i],end=off+child.length;if(!(end==off&&child.getSide()<=0)){if(pos>off&&pos<end&&child.dom.parentNode==dom)return child.domAtPos(pos-off);if(pos<=off)break;off=end}}for(let j=i;j>0;j--){let prev=children[j-1];if(prev.dom.parentNode==dom)return prev.domAtPos(prev.length)}for(let j=i;j<children.length;j++){let next=children[j];if(next.dom.parentNode==dom)return next.domAtPos(0)}return new DOMPos(dom,0)}function joinInlineInto(parent,view,open){let last,{children:children}=parent;open>0&&view instanceof MarkView&&children.length&&(last=children[children.length-1])instanceof MarkView&&last.mark.eq(view.mark)?joinInlineInto(last,view.children[0],open-1):(children.push(view),view.setParent(parent)),parent.length+=view.length}function coordsInChildren(view,pos,side){let before=null,beforePos=-1,after=null,afterPos=-1;!function scan(view,pos){for(let i=0,off=0;i<view.children.length&&off<=pos;i++){let child=view.children[i],end=off+child.length;end>=pos&&(child.children.length?scan(child,pos-off):(!after||after.isHidden&&side>0)&&(end>pos||off==end&&child.getSide()>0)?(after=child,afterPos=pos-off):(off<pos||off==end&&child.getSide()<0&&!child.isHidden)&&(before=child,beforePos=pos-off)),off=end}}(view,pos);let target=(side<0?before:after)||before||after;return target?target.coordsAt(Math.max(0,target==before?beforePos:afterPos),side):function(view){let last=view.dom.lastChild;if(!last)return view.dom.getBoundingClientRect();let rects=clientRectsFor(last);return rects[rects.length-1]||null}(view)}function combineAttrs(source,target){for(let name in source)"class"==name&&target.class?target.class+=" "+source.class:"style"==name&&target.style?target.style+=";"+source.style:target[name]=source[name];return target}function attrsEq(a,b){if(a==b)return!0;if(!a||!b)return!1;let keysA=Object.keys(a),keysB=Object.keys(b);if(keysA.length!=keysB.length)return!1;for(let key of keysA)if(-1==keysB.indexOf(key)||a[key]!==b[key])return!1;return!0}function updateAttrs(dom,prev,attrs){let changed=null;if(prev)for(let name in prev)attrs&&name in attrs||dom.removeAttribute(changed=name);if(attrs)for(let name in attrs)prev&&prev[name]==attrs[name]||dom.setAttribute(changed=name,attrs[name]);return!!changed}TextView.prototype.children=WidgetView.prototype.children=WidgetBufferView.prototype.children=noChildren;class WidgetType{eq(widget){return!1}updateDOM(dom,view){return!1}compare(other){return this==other||this.constructor==other.constructor&&this.eq(other)}get estimatedHeight(){return-1}get lineBreaks(){return 0}ignoreEvent(event){return!0}coordsAt(dom,pos,side){return null}get customView(){return null}get isHidden(){return!1}destroy(dom){}}var BlockType=function(BlockType){return BlockType[BlockType.Text=0]="Text",BlockType[BlockType.WidgetBefore=1]="WidgetBefore",BlockType[BlockType.WidgetAfter=2]="WidgetAfter",BlockType[BlockType.WidgetRange=3]="WidgetRange",BlockType}(BlockType||(BlockType={}));class Decoration extends RangeValue{constructor(startSide,endSide,widget,spec){super(),this.startSide=startSide,this.endSide=endSide,this.widget=widget,this.spec=spec}get heightRelevant(){return!1}static mark(spec){return new MarkDecoration(spec)}static widget(spec){let side=Math.max(-1e4,Math.min(1e4,spec.side||0)),block=!!spec.block;return side+=block&&!spec.inlineOrder?side>0?3e8:-4e8:side>0?1e8:-1e8,new PointDecoration(spec,side,side,block,spec.widget||null,!1)}static replace(spec){let startSide,endSide,block=!!spec.block;if(spec.isBlockGap)startSide=-5e8,endSide=4e8;else{let{start:start,end:end}=getInclusive(spec,block);startSide=(start?block?-3e8:-1:5e8)-1,endSide=1+(end?block?2e8:1:-6e8)}return new PointDecoration(spec,startSide,endSide,block,spec.widget||null,!0)}static line(spec){return new LineDecoration(spec)}static set(of){let sort=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return RangeSet.of(of,sort)}hasHeight(){return!!this.widget&&this.widget.estimatedHeight>-1}}Decoration.none=RangeSet.empty;class MarkDecoration extends Decoration{constructor(spec){let{start:start,end:end}=getInclusive(spec);super(start?-1:5e8,end?1:-6e8,null,spec),this.tagName=spec.tagName||"span",this.class=spec.class||"",this.attrs=spec.attributes||null}eq(other){return this==other||other instanceof MarkDecoration&&this.tagName==other.tagName&&this.class==other.class&&attrsEq(this.attrs,other.attrs)}range(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:from;if(from>=to)throw new RangeError("Mark decorations may not be empty");return super.range(from,to)}}MarkDecoration.prototype.point=!1;class LineDecoration extends Decoration{constructor(spec){super(-2e8,-2e8,null,spec)}eq(other){return other instanceof LineDecoration&&this.spec.class==other.spec.class&&attrsEq(this.spec.attributes,other.spec.attributes)}range(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:from;if(to!=from)throw new RangeError("Line decoration ranges must be zero-length");return super.range(from,to)}}LineDecoration.prototype.mapMode=MapMode.TrackBefore,LineDecoration.prototype.point=!0;class PointDecoration extends Decoration{constructor(spec,startSide,endSide,block,widget,isReplace){super(startSide,endSide,widget,spec),this.block=block,this.isReplace=isReplace,this.mapMode=block?startSide<=0?MapMode.TrackBefore:MapMode.TrackAfter:MapMode.TrackDel}get type(){return this.startSide<this.endSide?BlockType.WidgetRange:this.startSide<=0?BlockType.WidgetBefore:BlockType.WidgetAfter}get heightRelevant(){return this.block||!!this.widget&&(this.widget.estimatedHeight>=5||this.widget.lineBreaks>0)}eq(other){return other instanceof PointDecoration&&(a=this.widget,b=other.widget,a==b||!!(a&&b&&a.compare(b)))&&this.block==other.block&&this.startSide==other.startSide&&this.endSide==other.endSide;var a,b}range(from){let to=arguments.length>1&&void 0!==arguments[1]?arguments[1]:from;if(this.isReplace&&(from>to||from==to&&this.startSide>0&&this.endSide<=0))throw new RangeError("Invalid range for replacement decoration");if(!this.isReplace&&to!=from)throw new RangeError("Widget decorations can only have zero-length ranges");return super.range(from,to)}}function getInclusive(spec){let block=arguments.length>1&&void 0!==arguments[1]&&arguments[1],{inclusiveStart:start,inclusiveEnd:end}=spec;return null==start&&(start=spec.inclusive),null==end&&(end=spec.inclusive),{start:null!=start?start:block,end:null!=end?end:block}}function addRange(from,to,ranges){let margin=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,last=ranges.length-1;last>=0&&ranges[last]+margin>=from?ranges[last]=Math.max(ranges[last],to):ranges.push(from,to)}PointDecoration.prototype.point=!0;class LineView extends ContentView{constructor(){super(...arguments),this.children=[],this.length=0,this.prevAttrs=void 0,this.attrs=null,this.breakAfter=0}merge(from,to,source,hasStart,openStart,openEnd){if(source){if(!(source instanceof LineView))return!1;this.dom||source.transferDOM(this)}return hasStart&&this.setDeco(source?source.attrs:null),mergeChildrenInto(this,from,to,source?source.children:[],openStart,openEnd),!0}split(at){let end=new LineView;if(end.breakAfter=this.breakAfter,0==this.length)return end;let{i:i,off:off}=this.childPos(at);off&&(end.append(this.children[i].split(off),0),this.children[i].merge(off,this.children[i].length,null,!1,0,0),i++);for(let j=i;j<this.children.length;j++)end.append(this.children[j],0);for(;i>0&&0==this.children[i-1].length;)this.children[--i].destroy();return this.children.length=i,this.markDirty(),this.length=at,end}transferDOM(other){this.dom&&(this.markDirty(),other.setDOM(this.dom),other.prevAttrs=void 0===this.prevAttrs?this.attrs:this.prevAttrs,this.prevAttrs=void 0,this.dom=null)}setDeco(attrs){attrsEq(this.attrs,attrs)||(this.dom&&(this.prevAttrs=this.attrs,this.markDirty()),this.attrs=attrs)}append(child,openStart){joinInlineInto(this,child,openStart)}addLineDeco(deco){let attrs=deco.spec.attributes,cls=deco.spec.class;attrs&&(this.attrs=combineAttrs(attrs,this.attrs||{})),cls&&(this.attrs=combineAttrs({class:cls},this.attrs||{}))}domAtPos(pos){return inlineDOMAtPos(this,pos)}reuseDOM(node){"DIV"==node.nodeName&&(this.setDOM(node),this.dirty|=6)}sync(view,track){var _a;this.dom?4&this.dirty&&(clearAttributes(this.dom),this.dom.className="cm-line",this.prevAttrs=this.attrs?null:void 0):(this.setDOM(document.createElement("div")),this.dom.className="cm-line",this.prevAttrs=this.attrs?null:void 0),void 0!==this.prevAttrs&&(updateAttrs(this.dom,this.prevAttrs,this.attrs),this.dom.classList.add("cm-line"),this.prevAttrs=void 0),super.sync(view,track);let last=this.dom.lastChild;for(;last&&ContentView.get(last)instanceof MarkView;)last=last.lastChild;if(!(last&&this.length&&("BR"==last.nodeName||0!=(null===(_a=ContentView.get(last))||void 0===_a?void 0:_a.isEditable)||browser.ios&&this.children.some((ch=>ch instanceof TextView))))){let hack=document.createElement("BR");hack.cmIgnore=!0,this.dom.appendChild(hack)}}measureTextSize(){if(0==this.children.length||this.length>20)return null;let textHeight,totalWidth=0;for(let child of this.children){if(!(child instanceof TextView)||/[^ -~]/.test(child.text))return null;let rects=clientRectsFor(child.dom);if(1!=rects.length)return null;totalWidth+=rects[0].width,textHeight=rects[0].height}return totalWidth?{lineHeight:this.dom.getBoundingClientRect().height,charWidth:totalWidth/this.length,textHeight:textHeight}:null}coordsAt(pos,side){let rect=coordsInChildren(this,pos,side);if(!this.children.length&&rect&&this.parent){let{heightOracle:heightOracle}=this.parent.view.viewState,height=rect.bottom-rect.top;if(Math.abs(height-heightOracle.lineHeight)<2&&heightOracle.textHeight<height){let dist=(height-heightOracle.textHeight)/2;return{top:rect.top+dist,bottom:rect.bottom-dist,left:rect.left,right:rect.left}}}return rect}become(_other){return!1}get type(){return BlockType.Text}static find(docView,pos){for(let i=0,off=0;i<docView.children.length;i++){let block=docView.children[i],end=off+block.length;if(end>=pos){if(block instanceof LineView)return block;if(end>pos)break}off=end+block.breakAfter}return null}}class BlockWidgetView extends ContentView{constructor(widget,length,type){super(),this.widget=widget,this.length=length,this.type=type,this.breakAfter=0,this.prevWidget=null}merge(from,to,source,_takeDeco,openStart,openEnd){return!(source&&(!(source instanceof BlockWidgetView&&this.widget.compare(source.widget))||from>0&&openStart<=0||to<this.length&&openEnd<=0))&&(this.length=from+(source?source.length:0)+(this.length-to),!0)}domAtPos(pos){return 0==pos?DOMPos.before(this.dom):DOMPos.after(this.dom,pos==this.length)}split(at){let len=this.length-at;this.length=at;let end=new BlockWidgetView(this.widget,len,this.type);return end.breakAfter=this.breakAfter,end}get children(){return noChildren}sync(view){this.dom&&this.widget.updateDOM(this.dom,view)||(this.dom&&this.prevWidget&&this.prevWidget.destroy(this.dom),this.prevWidget=null,this.setDOM(this.widget.toDOM(view)),this.dom.contentEditable="false")}get overrideDOMText(){return this.parent?this.parent.view.state.doc.slice(this.posAtStart,this.posAtEnd):Text.empty}domBoundsAround(){return null}become(other){return other instanceof BlockWidgetView&&other.widget.constructor==this.widget.constructor&&(other.widget.compare(this.widget)||this.markDirty(!0),this.dom&&!this.prevWidget&&(this.prevWidget=this.widget),this.widget=other.widget,this.length=other.length,this.type=other.type,this.breakAfter=other.breakAfter,!0)}ignoreMutation(){return!0}ignoreEvent(event){return this.widget.ignoreEvent(event)}get isEditable(){return!1}get isWidget(){return!0}coordsAt(pos,side){return this.widget.coordsAt(this.dom,pos,side)}destroy(){super.destroy(),this.dom&&this.widget.destroy(this.dom)}}class ContentBuilder{constructor(doc,pos,end,disallowBlockEffectsFor){this.doc=doc,this.pos=pos,this.end=end,this.disallowBlockEffectsFor=disallowBlockEffectsFor,this.content=[],this.curLine=null,this.breakAtStart=0,this.pendingBuffer=0,this.bufferMarks=[],this.atCursorPos=!0,this.openStart=-1,this.openEnd=-1,this.text="",this.textOff=0,this.cursor=doc.iter(),this.skip=pos}posCovered(){if(0==this.content.length)return!this.breakAtStart&&this.doc.lineAt(this.pos).from!=this.pos;let last=this.content[this.content.length-1];return!(last.breakAfter||last instanceof BlockWidgetView&&last.type==BlockType.WidgetBefore)}getLine(){return this.curLine||(this.content.push(this.curLine=new LineView),this.atCursorPos=!0),this.curLine}flushBuffer(){let active=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.bufferMarks;this.pendingBuffer&&(this.curLine.append(wrapMarks(new WidgetBufferView(-1),active),active.length),this.pendingBuffer=0)}addBlockWidget(view){this.flushBuffer(),this.curLine=null,this.content.push(view)}finish(openEnd){this.pendingBuffer&&openEnd<=this.bufferMarks.length?this.flushBuffer():this.pendingBuffer=0,this.posCovered()||this.getLine()}buildText(length,active,openStart){for(;length>0;){if(this.textOff==this.text.length){let{value:value,lineBreak:lineBreak,done:done}=this.cursor.next(this.skip);if(this.skip=0,done)throw new Error("Ran out of text content when drawing inline views");if(lineBreak){this.posCovered()||this.getLine(),this.content.length?this.content[this.content.length-1].breakAfter=1:this.breakAtStart=1,this.flushBuffer(),this.curLine=null,this.atCursorPos=!0,length--;continue}this.text=value,this.textOff=0}let take=Math.min(this.text.length-this.textOff,length,512);this.flushBuffer(active.slice(active.length-openStart)),this.getLine().append(wrapMarks(new TextView(this.text.slice(this.textOff,this.textOff+take)),active),openStart),this.atCursorPos=!0,this.textOff+=take,length-=take,openStart=0}}span(from,to,active,openStart){this.buildText(to-from,active,openStart),this.pos=to,this.openStart<0&&(this.openStart=openStart)}point(from,to,deco,active,openStart,index){if(this.disallowBlockEffectsFor[index]&&deco instanceof PointDecoration){if(deco.block)throw new RangeError("Block decorations may not be specified via plugins");if(to>this.doc.lineAt(this.pos).to)throw new RangeError("Decorations that replace line breaks may not be specified via plugins")}let len=to-from;if(deco instanceof PointDecoration)if(deco.block){let{type:type}=deco;type!=BlockType.WidgetAfter||this.posCovered()||this.getLine(),this.addBlockWidget(new BlockWidgetView(deco.widget||new NullWidget("div"),len,type))}else{let view=WidgetView.create(deco.widget||new NullWidget("span"),len,len?0:deco.startSide),cursorBefore=this.atCursorPos&&!view.isEditable&&openStart<=active.length&&(from<to||deco.startSide>0),cursorAfter=!view.isEditable&&(from<to||openStart>active.length||deco.startSide<=0),line=this.getLine();2!=this.pendingBuffer||cursorBefore||view.isEditable||(this.pendingBuffer=0),this.flushBuffer(active),cursorBefore&&(line.append(wrapMarks(new WidgetBufferView(1),active),openStart),openStart=active.length+Math.max(0,openStart-active.length)),line.append(wrapMarks(view,active),openStart),this.atCursorPos=cursorAfter,this.pendingBuffer=cursorAfter?from<to||openStart>active.length?1:2:0,this.pendingBuffer&&(this.bufferMarks=active.slice())}else this.doc.lineAt(this.pos).from==this.pos&&this.getLine().addLineDeco(deco);len&&(this.textOff+len<=this.text.length?this.textOff+=len:(this.skip+=len-(this.text.length-this.textOff),this.text="",this.textOff=0),this.pos=to),this.openStart<0&&(this.openStart=openStart)}static build(text,from,to,decorations,dynamicDecorationMap){let builder=new ContentBuilder(text,from,to,dynamicDecorationMap);return builder.openEnd=RangeSet.spans(decorations,from,to,builder),builder.openStart<0&&(builder.openStart=builder.openEnd),builder.finish(builder.openEnd),builder}}function wrapMarks(view,active){for(let mark of active)view=new MarkView(mark,[view],view.length);return view}class NullWidget extends WidgetType{constructor(tag){super(),this.tag=tag}eq(other){return other.tag==this.tag}toDOM(){return document.createElement(this.tag)}updateDOM(elt){return elt.nodeName.toLowerCase()==this.tag}get isHidden(){return!0}}const clickAddsSelectionRange=Facet.define(),dragMovesSelection$1=Facet.define(),mouseSelectionStyle=Facet.define(),exceptionSink=Facet.define(),updateListener=Facet.define(),inputHandler$1=Facet.define(),focusChangeEffect=Facet.define(),perLineTextDirection=Facet.define({combine:values=>values.some((x=>x))}),nativeSelectionHidden=Facet.define({combine:values=>values.some((x=>x))});class ScrollTarget{constructor(range){let y=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"nearest",x=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"nearest",yMargin=arguments.length>3&&void 0!==arguments[3]?arguments[3]:5,xMargin=arguments.length>4&&void 0!==arguments[4]?arguments[4]:5;this.range=range,this.y=y,this.x=x,this.yMargin=yMargin,this.xMargin=xMargin}map(changes){return changes.empty?this:new ScrollTarget(this.range.map(changes),this.y,this.x,this.yMargin,this.xMargin)}}const scrollIntoView$1=StateEffect.define({map:(t,ch)=>t.map(ch)});function logException(state,exception,context){let handler=state.facet(exceptionSink);handler.length?handler[0](exception):window.onerror?window.onerror(String(exception),context,void 0,void 0,exception):context?console.error(context+":",exception):console.error(exception)}const editable=Facet.define({combine:values=>!values.length||values[0]});let nextPluginID=0;const viewPlugin=Facet.define();class ViewPlugin{constructor(id,create,domEventHandlers,buildExtensions){this.id=id,this.create=create,this.domEventHandlers=domEventHandlers,this.extension=buildExtensions(this)}static define(create,spec){const{eventHandlers:eventHandlers,provide:provide,decorations:deco}=spec||{};return new ViewPlugin(nextPluginID++,create,eventHandlers,(plugin=>{let ext=[viewPlugin.of(plugin)];return deco&&ext.push(decorations.of((view=>{let pluginInst=view.plugin(plugin);return pluginInst?deco(pluginInst):Decoration.none}))),provide&&ext.push(provide(plugin)),ext}))}static fromClass(cls,spec){return ViewPlugin.define((view=>new cls(view)),spec)}}class PluginInstance{constructor(spec){this.spec=spec,this.mustUpdate=null,this.value=null}update(view){if(this.value){if(this.mustUpdate){let update=this.mustUpdate;if(this.mustUpdate=null,this.value.update)try{this.value.update(update)}catch(e){if(logException(update.state,e,"CodeMirror plugin crashed"),this.value.destroy)try{this.value.destroy()}catch(_){}this.deactivate()}}}else if(this.spec)try{this.value=this.spec.create(view)}catch(e){logException(view.state,e,"CodeMirror plugin crashed"),this.deactivate()}return this}destroy(view){var _a;if(null===(_a=this.value)||void 0===_a?void 0:_a.destroy)try{this.value.destroy()}catch(e){logException(view.state,e,"CodeMirror plugin crashed")}}deactivate(){this.spec=this.value=null}}const editorAttributes=Facet.define(),contentAttributes=Facet.define(),decorations=Facet.define(),atomicRanges=Facet.define(),scrollMargins=Facet.define();function getScrollMargins(view){let left=0,right=0,top=0,bottom=0;for(let source of view.state.facet(scrollMargins)){let m=source(view);m&&(null!=m.left&&(left=Math.max(left,m.left)),null!=m.right&&(right=Math.max(right,m.right)),null!=m.top&&(top=Math.max(top,m.top)),null!=m.bottom&&(bottom=Math.max(bottom,m.bottom)))}return{left:left,right:right,top:top,bottom:bottom}}const styleModule=Facet.define();class ChangedRange{constructor(fromA,toA,fromB,toB){this.fromA=fromA,this.toA=toA,this.fromB=fromB,this.toB=toB}join(other){return new ChangedRange(Math.min(this.fromA,other.fromA),Math.max(this.toA,other.toA),Math.min(this.fromB,other.fromB),Math.max(this.toB,other.toB))}addToSet(set){let i=set.length,me=this;for(;i>0;i--){let range=set[i-1];if(!(range.fromA>me.toA)){if(range.toA<me.fromA)break;me=me.join(range),set.splice(i-1,1)}}return set.splice(i,0,me),set}static extendWithRanges(diff,ranges){if(0==ranges.length)return diff;let result=[];for(let dI=0,rI=0,posA=0,posB=0;;dI++){let next=dI==diff.length?null:diff[dI],off=posA-posB,end=next?next.fromB:1e9;for(;rI<ranges.length&&ranges[rI]<end;){let from=ranges[rI],to=ranges[rI+1],fromB=Math.max(posB,from),toB=Math.min(end,to);if(fromB<=toB&&new ChangedRange(fromB+off,toB+off,fromB,toB).addToSet(result),to>end)break;rI+=2}if(!next)return result;new ChangedRange(next.fromA,next.toA,next.fromB,next.toB).addToSet(result),posA=next.toA,posB=next.toB}}}class ViewUpdate{constructor(view,state,transactions){this.view=view,this.state=state,this.transactions=transactions,this.flags=0,this.startState=view.state,this.changes=ChangeSet.empty(this.startState.doc.length);for(let tr of transactions)this.changes=this.changes.compose(tr.changes);let changedRanges=[];this.changes.iterChangedRanges(((fromA,toA,fromB,toB)=>changedRanges.push(new ChangedRange(fromA,toA,fromB,toB)))),this.changedRanges=changedRanges}static create(view,state,transactions){return new ViewUpdate(view,state,transactions)}get viewportChanged(){return(4&this.flags)>0}get heightChanged(){return(2&this.flags)>0}get geometryChanged(){return this.docChanged||(10&this.flags)>0}get focusChanged(){return(1&this.flags)>0}get docChanged(){return!this.changes.empty}get selectionSet(){return this.transactions.some((tr=>tr.selection))}get empty(){return 0==this.flags&&0==this.transactions.length}}var Direction=function(Direction){return Direction[Direction.LTR=0]="LTR",Direction[Direction.RTL=1]="RTL",Direction}(Direction||(Direction={}));const LTR=Direction.LTR,RTL=Direction.RTL;function dec(str){let result=[];for(let i=0;i<str.length;i++)result.push(1<<+str[i]);return result}const LowTypes=dec("88888888888888888888888888888888888666888888787833333333337888888000000000000000000000000008888880000000000000000000000000088888888888888888888888888888888888887866668888088888663380888308888800000000000000000000000800000000000000000000000000000008"),ArabicTypes=dec("4444448826627288999999999992222222222222222222222222222222222222222222222229999999999999999999994444444444644222822222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222999999949999999229989999223333333333"),Brackets=Object.create(null),BracketStack=[];for(let p of["()","[]","{}"]){let l=p.charCodeAt(0),r=p.charCodeAt(1);Brackets[l]=r,Brackets[r]=-l}const BidiRE=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\ufb50-\ufdff]/;class BidiSpan{constructor(from,to,level){this.from=from,this.to=to,this.level=level}get dir(){return this.level%2?RTL:LTR}side(end,dir){return this.dir==dir==end?this.to:this.from}static find(order,index,level,assoc){let maybe=-1;for(let i=0;i<order.length;i++){let span=order[i];if(span.from<=index&&span.to>=index){if(span.level==level)return i;(maybe<0||(0!=assoc?assoc<0?span.from<index:span.to>index:order[maybe].level>span.level))&&(maybe=i)}}if(maybe<0)throw new RangeError("Index out of range");return maybe}}const types=[];function trivialOrder(length){return[new BidiSpan(0,length,0)]}let movedOver="";function moveVisually(line,order,dir,start,forward){var _a;let startIndex=start.head-line.from,spanI=-1;if(0==startIndex){if(!forward||!line.length)return null;order[0].level!=dir&&(startIndex=order[0].side(!1,dir),spanI=0)}else if(startIndex==line.length){if(forward)return null;let last=order[order.length-1];last.level!=dir&&(startIndex=last.side(!0,dir),spanI=order.length-1)}spanI<0&&(spanI=BidiSpan.find(order,startIndex,null!==(_a=start.bidiLevel)&&void 0!==_a?_a:-1,start.assoc));let span=order[spanI];startIndex==span.side(forward,dir)&&(span=order[spanI+=forward?1:-1],startIndex=span.side(!forward,dir));let indexForward=forward==(span.dir==dir),nextIndex=findClusterBreak(line.text,startIndex,indexForward);if(movedOver=line.text.slice(Math.min(startIndex,nextIndex),Math.max(startIndex,nextIndex)),nextIndex!=span.side(forward,dir))return EditorSelection.cursor(nextIndex+line.from,indexForward?-1:1,span.level);let nextSpan=spanI==(forward?order.length-1:0)?null:order[spanI+(forward?1:-1)];return nextSpan||span.level==dir?nextSpan&&nextSpan.level<span.level?EditorSelection.cursor(nextSpan.side(!forward,dir)+line.from,forward?1:-1,nextSpan.level):EditorSelection.cursor(nextIndex+line.from,forward?-1:1,span.level):EditorSelection.cursor(forward?line.to:line.from,forward?-1:1,dir)}class DOMReader{constructor(points,state){this.points=points,this.text="",this.lineSeparator=state.facet(EditorState.lineSeparator)}append(text){this.text+=text}lineBreak(){this.text+="￿"}readRange(start,end){if(!start)return this;let parent=start.parentNode;for(let cur=start;;){this.findPointBefore(parent,cur);let oldLen=this.text.length;this.readNode(cur);let next=cur.nextSibling;if(next==end)break;let view=ContentView.get(cur),nextView=ContentView.get(next);(view&&nextView?view.breakAfter:(view?view.breakAfter:isBlockElement(cur))||isBlockElement(next)&&("BR"!=cur.nodeName||cur.cmIgnore)&&this.text.length>oldLen)&&this.lineBreak(),cur=next}return this.findPointBefore(parent,end),this}readTextNode(node){let text=node.nodeValue;for(let point of this.points)point.node==node&&(point.pos=this.text.length+Math.min(point.offset,text.length));for(let off=0,re=this.lineSeparator?null:/\r\n?|\n/g;;){let m,nextBreak=-1,breakSize=1;if(this.lineSeparator?(nextBreak=text.indexOf(this.lineSeparator,off),breakSize=this.lineSeparator.length):(m=re.exec(text))&&(nextBreak=m.index,breakSize=m[0].length),this.append(text.slice(off,nextBreak<0?text.length:nextBreak)),nextBreak<0)break;if(this.lineBreak(),breakSize>1)for(let point of this.points)point.node==node&&point.pos>this.text.length&&(point.pos-=breakSize-1);off=nextBreak+breakSize}}readNode(node){if(node.cmIgnore)return;let view=ContentView.get(node),fromView=view&&view.overrideDOMText;if(null!=fromView){this.findPointInside(node,fromView.length);for(let i=fromView.iter();!i.next().done;)i.lineBreak?this.lineBreak():this.append(i.value)}else 3==node.nodeType?this.readTextNode(node):"BR"==node.nodeName?node.nextSibling&&this.lineBreak():1==node.nodeType&&this.readRange(node.firstChild,null)}findPointBefore(node,next){for(let point of this.points)point.node==node&&node.childNodes[point.offset]==next&&(point.pos=this.text.length)}findPointInside(node,maxLen){for(let point of this.points)(3==node.nodeType?point.node==node:node.contains(point.node))&&(point.pos=this.text.length+Math.min(maxLen,point.offset))}}function isBlockElement(node){return 1==node.nodeType&&/^(DIV|P|LI|UL|OL|BLOCKQUOTE|DD|DT|H\d|SECTION|PRE)$/.test(node.nodeName)}class DOMPoint{constructor(node,offset){this.node=node,this.offset=offset,this.pos=-1}}class DocView extends ContentView{constructor(view){super(),this.view=view,this.compositionDeco=Decoration.none,this.decorations=[],this.dynamicDecorationMap=[],this.minWidth=0,this.minWidthFrom=0,this.minWidthTo=0,this.impreciseAnchor=null,this.impreciseHead=null,this.forceSelection=!1,this.lastUpdate=Date.now(),this.setDOM(view.contentDOM),this.children=[new LineView],this.children[0].setParent(this),this.updateDeco(),this.updateInner([new ChangedRange(0,0,0,view.state.doc.length)],0)}get length(){return this.view.state.doc.length}update(update){let changedRanges=update.changedRanges;this.minWidth>0&&changedRanges.length&&(changedRanges.every((_ref=>{let{fromA:fromA,toA:toA}=_ref;return toA<this.minWidthFrom||fromA>this.minWidthTo}))?(this.minWidthFrom=update.changes.mapPos(this.minWidthFrom,1),this.minWidthTo=update.changes.mapPos(this.minWidthTo,1)):this.minWidth=this.minWidthFrom=this.minWidthTo=0),this.view.inputState.composing<0?this.compositionDeco=Decoration.none:(update.transactions.length||this.dirty)&&(this.compositionDeco=function(view,changes){let surrounding=compositionSurroundingNode(view);if(!surrounding)return Decoration.none;let{from:from,to:to,node:node,text:textNode}=surrounding,newFrom=changes.mapPos(from,1),newTo=Math.max(newFrom,changes.mapPos(to,-1)),{state:state}=view,reader=new DOMReader([],state);3==node.nodeType?reader.readTextNode(node):reader.readRange(node.firstChild,null);let{text:text}=reader;if(text.indexOf("￿")>-1)return Decoration.none;if(newTo-newFrom<text.length)if(state.doc.sliceString(newFrom,Math.min(state.doc.length,newFrom+text.length))==text)newTo=newFrom+text.length;else{if(state.doc.sliceString(Math.max(0,newTo-text.length),newTo)!=text)return Decoration.none;newFrom=newTo-text.length}else if(state.doc.sliceString(newFrom,newTo)!=text)return Decoration.none;let topView=ContentView.get(node);topView instanceof CompositionView?topView=topView.widget.topView:topView&&(topView.parent=null);return Decoration.set(Decoration.replace({widget:new CompositionWidget(node,textNode,topView),inclusive:!0}).range(newFrom,newTo))}(this.view,update.changes)),(browser.ie||browser.chrome)&&!this.compositionDeco.size&&update&&update.state.doc.lines!=update.startState.doc.lines&&(this.forceSelection=!0);let decoDiff=function(a,b,diff){let comp=new DecorationComparator$1;return RangeSet.compare(a,b,diff,comp),comp.changes}(this.decorations,this.updateDeco(),update.changes);return changedRanges=ChangedRange.extendWithRanges(changedRanges,decoDiff),(0!=this.dirty||0!=changedRanges.length)&&(this.updateInner(changedRanges,update.startState.doc.length),update.transactions.length&&(this.lastUpdate=Date.now()),!0)}updateInner(changes,oldLength){this.view.viewState.mustMeasureContent=!0,this.updateChildren(changes,oldLength);let{observer:observer}=this.view;observer.ignore((()=>{this.dom.style.height=this.view.viewState.contentHeight+"px",this.dom.style.flexBasis=this.minWidth?this.minWidth+"px":"";let track=browser.chrome||browser.ios?{node:observer.selectionRange.focusNode,written:!1}:void 0;this.sync(this.view,track),this.dirty=0,track&&(track.written||observer.selectionRange.focusNode!=track.node)&&(this.forceSelection=!0),this.dom.style.height=""}));let gaps=[];if(this.view.viewport.from||this.view.viewport.to<this.view.state.doc.length)for(let child of this.children)child instanceof BlockWidgetView&&child.widget instanceof BlockGapWidget&&gaps.push(child.dom);observer.updateGaps(gaps)}updateChildren(changes,oldLength){let cursor=this.childCursor(oldLength);for(let i=changes.length-1;;i--){let next=i>=0?changes[i]:null;if(!next)break;let{fromA:fromA,toA:toA,fromB:fromB,toB:toB}=next,{content:content,breakAtStart:breakAtStart,openStart:openStart,openEnd:openEnd}=ContentBuilder.build(this.view.state.doc,fromB,toB,this.decorations,this.dynamicDecorationMap),{i:toI,off:toOff}=cursor.findPos(toA,1),{i:fromI,off:fromOff}=cursor.findPos(fromA,-1);replaceRange(this,fromI,fromOff,toI,toOff,content,breakAtStart,openStart,openEnd)}}updateSelection(){let fromPointer=arguments.length>1&&void 0!==arguments[1]&&arguments[1];!(arguments.length>0&&void 0!==arguments[0]&&arguments[0])&&this.view.observer.selectionRange.focusNode||this.view.observer.readSelectionRange();let activeElt=this.view.root.activeElement,focused=activeElt==this.dom,selectionNotFocus=!focused&&hasSelection(this.dom,this.view.observer.selectionRange)&&!(activeElt&&this.dom.contains(activeElt));if(!(focused||fromPointer||selectionNotFocus))return;let force=this.forceSelection;this.forceSelection=!1;let main=this.view.state.selection.main,anchor=this.domAtPos(main.anchor),head=main.empty?anchor:this.domAtPos(main.head);if(browser.gecko&&main.empty&&!this.compositionDeco.size&&(1==(pos=anchor).node.nodeType&&pos.node.firstChild&&(0==pos.offset||"false"==pos.node.childNodes[pos.offset-1].contentEditable)&&(pos.offset==pos.node.childNodes.length||"false"==pos.node.childNodes[pos.offset].contentEditable))){let dummy=document.createTextNode("");this.view.observer.ignore((()=>anchor.node.insertBefore(dummy,anchor.node.childNodes[anchor.offset]||null))),anchor=head=new DOMPos(dummy,0),force=!0}var pos;let domSel=this.view.observer.selectionRange;!force&&domSel.focusNode&&isEquivalentPosition(anchor.node,anchor.offset,domSel.anchorNode,domSel.anchorOffset)&&isEquivalentPosition(head.node,head.offset,domSel.focusNode,domSel.focusOffset)||(this.view.observer.ignore((()=>{browser.android&&browser.chrome&&this.dom.contains(domSel.focusNode)&&function(node,inside){for(let cur=node;cur&&cur!=inside;cur=cur.assignedSlot||cur.parentNode)if(1==cur.nodeType&&"false"==cur.contentEditable)return!0;return!1}(domSel.focusNode,this.dom)&&(this.dom.blur(),this.dom.focus({preventScroll:!0}));let rawSel=getSelection(this.view.root);if(rawSel)if(main.empty){if(browser.gecko){let nextTo=(node=anchor.node,offset=anchor.offset,1!=node.nodeType?0:(offset&&"false"==node.childNodes[offset-1].contentEditable?1:0)|(offset<node.childNodes.length&&"false"==node.childNodes[offset].contentEditable?2:0));if(nextTo&&3!=nextTo){let text=nearbyTextNode(anchor.node,anchor.offset,1==nextTo?1:-1);text&&(anchor=new DOMPos(text,1==nextTo?0:text.nodeValue.length))}}rawSel.collapse(anchor.node,anchor.offset),null!=main.bidiLevel&&null!=domSel.cursorBidiLevel&&(domSel.cursorBidiLevel=main.bidiLevel)}else if(rawSel.extend){rawSel.collapse(anchor.node,anchor.offset);try{rawSel.extend(head.node,head.offset)}catch(_){}}else{let range=document.createRange();main.anchor>main.head&&([anchor,head]=[head,anchor]),range.setEnd(head.node,head.offset),range.setStart(anchor.node,anchor.offset),rawSel.removeAllRanges(),rawSel.addRange(range)}else;var node,offset;selectionNotFocus&&this.view.root.activeElement==this.dom&&(this.dom.blur(),activeElt&&activeElt.focus())})),this.view.observer.setSelectionRange(anchor,head)),this.impreciseAnchor=anchor.precise?null:new DOMPos(domSel.anchorNode,domSel.anchorOffset),this.impreciseHead=head.precise?null:new DOMPos(domSel.focusNode,domSel.focusOffset)}enforceCursorAssoc(){if(this.compositionDeco.size)return;let{view:view}=this,cursor=view.state.selection.main,sel=getSelection(view.root),{anchorNode:anchorNode,anchorOffset:anchorOffset}=view.observer.selectionRange;if(!(sel&&cursor.empty&&cursor.assoc&&sel.modify))return;let line=LineView.find(this,cursor.head);if(!line)return;let lineStart=line.posAtStart;if(cursor.head==lineStart||cursor.head==lineStart+line.length)return;let before=this.coordsAt(cursor.head,-1),after=this.coordsAt(cursor.head,1);if(!before||!after||before.bottom>after.top)return;let dom=this.domAtPos(cursor.head+cursor.assoc);sel.collapse(dom.node,dom.offset),sel.modify("move",cursor.assoc<0?"forward":"backward","lineboundary"),view.observer.readSelectionRange();let newRange=view.observer.selectionRange;view.docView.posFromDOM(newRange.anchorNode,newRange.anchorOffset)!=cursor.from&&sel.collapse(anchorNode,anchorOffset)}nearest(dom){for(let cur=dom;cur;){let domView=ContentView.get(cur);if(domView&&domView.rootView==this)return domView;cur=cur.parentNode}return null}posFromDOM(node,offset){let view=this.nearest(node);if(!view)throw new RangeError("Trying to find position for a DOM position outside of the document");return view.localPosFromDOM(node,offset)+view.posAtStart}domAtPos(pos){let{i:i,off:off}=this.childCursor().findPos(pos,-1);for(;i<this.children.length-1;){let child=this.children[i];if(off<child.length||child instanceof LineView)break;i++,off=0}return this.children[i].domAtPos(off)}coordsAt(pos,side){for(let off=this.length,i=this.children.length-1;;i--){let child=this.children[i],start=off-child.breakAfter-child.length;if(pos>start||pos==start&&child.type!=BlockType.WidgetBefore&&child.type!=BlockType.WidgetAfter&&(!i||2==side||this.children[i-1].breakAfter||this.children[i-1].type==BlockType.WidgetBefore&&side>-2))return child.coordsAt(pos-start,side);off=start}}measureVisibleLineHeights(viewport){let result=[],{from:from,to:to}=viewport,contentWidth=this.view.contentDOM.clientWidth,isWider=contentWidth>Math.max(this.view.scrollDOM.clientWidth,this.minWidth)+1,widest=-1,ltr=this.view.textDirection==Direction.LTR;for(let pos=0,i=0;i<this.children.length;i++){let child=this.children[i],end=pos+child.length;if(end>to)break;if(pos>=from){let childRect=child.dom.getBoundingClientRect();if(result.push(childRect.height),isWider){let last=child.dom.lastChild,rects=last?clientRectsFor(last):[];if(rects.length){let rect=rects[rects.length-1],width=ltr?rect.right-childRect.left:childRect.right-rect.left;width>widest&&(widest=width,this.minWidth=contentWidth,this.minWidthFrom=pos,this.minWidthTo=end)}}}pos=end+child.breakAfter}return result}textDirectionAt(pos){let{i:i}=this.childPos(pos,1);return"rtl"==getComputedStyle(this.children[i].dom).direction?Direction.RTL:Direction.LTR}measureTextSize(){for(let child of this.children)if(child instanceof LineView){let measure=child.measureTextSize();if(measure)return measure}let lineHeight,charWidth,textHeight,dummy=document.createElement("div");return dummy.className="cm-line",dummy.style.width="99999px",dummy.textContent="abc def ghi jkl mno pqr stu",this.view.observer.ignore((()=>{this.dom.appendChild(dummy);let rect=clientRectsFor(dummy.firstChild)[0];lineHeight=dummy.getBoundingClientRect().height,charWidth=rect?rect.width/27:7,textHeight=rect?rect.height:lineHeight,dummy.remove()})),{lineHeight:lineHeight,charWidth:charWidth,textHeight:textHeight}}childCursor(){let pos=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.length,i=this.children.length;return i&&(pos-=this.children[--i].length),new ChildCursor(this.children,pos,i)}computeBlockGapDeco(){let deco=[],vs=this.view.viewState;for(let pos=0,i=0;;i++){let next=i==vs.viewports.length?null:vs.viewports[i],end=next?next.from-1:this.length;if(end>pos){let height=vs.lineBlockAt(end).bottom-vs.lineBlockAt(pos).top;deco.push(Decoration.replace({widget:new BlockGapWidget(height),block:!0,inclusive:!0,isBlockGap:!0}).range(pos,end))}if(!next)break;pos=next.to+1}return Decoration.set(deco)}updateDeco(){let allDeco=this.view.state.facet(decorations).map(((d,i)=>(this.dynamicDecorationMap[i]="function"==typeof d)?d(this.view):d));for(let i=allDeco.length;i<allDeco.length+3;i++)this.dynamicDecorationMap[i]=!1;return this.decorations=[...allDeco,this.compositionDeco,this.computeBlockGapDeco(),this.view.viewState.lineGapDeco]}scrollIntoView(target){let other,{range:range}=target,rect=this.coordsAt(range.head,range.empty?range.assoc:range.head>range.anchor?-1:1);if(!rect)return;!range.empty&&(other=this.coordsAt(range.anchor,range.anchor>range.head?-1:1))&&(rect={left:Math.min(rect.left,other.left),top:Math.min(rect.top,other.top),right:Math.max(rect.right,other.right),bottom:Math.max(rect.bottom,other.bottom)});let margins=getScrollMargins(this.view),targetRect={left:rect.left-margins.left,top:rect.top-margins.top,right:rect.right+margins.right,bottom:rect.bottom+margins.bottom};!function(dom,rect,side,x,y,xMargin,yMargin,ltr){let doc=dom.ownerDocument,win=doc.defaultView||window;for(let cur=dom;cur;)if(1==cur.nodeType){let bounding,top=cur==doc.body;if(top)bounding=windowRect(win);else{if(cur.scrollHeight<=cur.clientHeight&&cur.scrollWidth<=cur.clientWidth){cur=cur.assignedSlot||cur.parentNode;continue}let rect=cur.getBoundingClientRect();bounding={left:rect.left,right:rect.left+cur.clientWidth,top:rect.top,bottom:rect.top+cur.clientHeight}}let moveX=0,moveY=0;if("nearest"==y)rect.top<bounding.top?(moveY=-(bounding.top-rect.top+yMargin),side>0&&rect.bottom>bounding.bottom+moveY&&(moveY=rect.bottom-bounding.bottom+moveY+yMargin)):rect.bottom>bounding.bottom&&(moveY=rect.bottom-bounding.bottom+yMargin,side<0&&rect.top-moveY<bounding.top&&(moveY=-(bounding.top+moveY-rect.top+yMargin)));else{let rectHeight=rect.bottom-rect.top,boundingHeight=bounding.bottom-bounding.top;moveY=("center"==y&&rectHeight<=boundingHeight?rect.top+rectHeight/2-boundingHeight/2:"start"==y||"center"==y&&side<0?rect.top-yMargin:rect.bottom-boundingHeight+yMargin)-bounding.top}if("nearest"==x?rect.left<bounding.left?(moveX=-(bounding.left-rect.left+xMargin),side>0&&rect.right>bounding.right+moveX&&(moveX=rect.right-bounding.right+moveX+xMargin)):rect.right>bounding.right&&(moveX=rect.right-bounding.right+xMargin,side<0&&rect.left<bounding.left+moveX&&(moveX=-(bounding.left+moveX-rect.left+xMargin))):moveX=("center"==x?rect.left+(rect.right-rect.left)/2-(bounding.right-bounding.left)/2:"start"==x==ltr?rect.left-xMargin:rect.right-(bounding.right-bounding.left)+xMargin)-bounding.left,moveX||moveY)if(top)win.scrollBy(moveX,moveY);else{let movedX=0,movedY=0;if(moveY){let start=cur.scrollTop;cur.scrollTop+=moveY,movedY=cur.scrollTop-start}if(moveX){let start=cur.scrollLeft;cur.scrollLeft+=moveX,movedX=cur.scrollLeft-start}rect={left:rect.left-movedX,top:rect.top-movedY,right:rect.right-movedX,bottom:rect.bottom-movedY},movedX&&Math.abs(movedX-moveX)<1&&(x="nearest"),movedY&&Math.abs(movedY-moveY)<1&&(y="nearest")}if(top)break;cur=cur.assignedSlot||cur.parentNode}else{if(11!=cur.nodeType)break;cur=cur.host}}(this.view.scrollDOM,targetRect,range.head<range.anchor?-1:1,target.x,target.y,target.xMargin,target.yMargin,this.view.textDirection==Direction.LTR)}}class BlockGapWidget extends WidgetType{constructor(height){super(),this.height=height}toDOM(){let elt=document.createElement("div");return this.updateDOM(elt),elt}eq(other){return other.height==this.height}updateDOM(elt){return elt.style.height=this.height+"px",!0}get estimatedHeight(){return this.height}}function compositionSurroundingNode(view){let sel=view.observer.selectionRange,textNode=sel.focusNode&&nearbyTextNode(sel.focusNode,sel.focusOffset,0);if(!textNode)return null;let cView=view.docView.nearest(textNode);if(!cView)return null;if(cView instanceof LineView){let topNode=textNode;for(;topNode.parentNode!=cView.dom;)topNode=topNode.parentNode;let prev=topNode.previousSibling;for(;prev&&!ContentView.get(prev);)prev=prev.previousSibling;let pos=prev?ContentView.get(prev).posAtEnd:cView.posAtStart;return{from:pos,to:pos,node:topNode,text:textNode}}{for(;;){let{parent:parent}=cView;if(!parent)return null;if(parent instanceof LineView)break;cView=parent}let from=cView.posAtStart;return{from:from,to:from+cView.length,node:cView.dom,text:textNode}}}class CompositionWidget extends WidgetType{constructor(top,text,topView){super(),this.top=top,this.text=text,this.topView=topView}eq(other){return this.top==other.top&&this.text==other.text}toDOM(){return this.top}ignoreEvent(){return!1}get customView(){return CompositionView}}function nearbyTextNode(startNode,startOffset,side){if(side<=0)for(let node=startNode,offset=startOffset;;){if(3==node.nodeType)return node;if(!(1==node.nodeType&&offset>0))break;node=node.childNodes[offset-1],offset=maxOffset(node)}if(side>=0)for(let node=startNode,offset=startOffset;;){if(3==node.nodeType)return node;if(!(1==node.nodeType&&offset<node.childNodes.length&&side>=0))break;node=node.childNodes[offset],offset=0}return null}class DecorationComparator$1{constructor(){this.changes=[]}compareRange(from,to){addRange(from,to,this.changes)}comparePoint(from,to){addRange(from,to,this.changes)}}function getdx(x,rect){return rect.left>x?rect.left-x:Math.max(0,x-rect.right)}function getdy(y,rect){return rect.top>y?rect.top-y:Math.max(0,y-rect.bottom)}function yOverlap(a,b){return a.top<b.bottom-1&&a.bottom>b.top+1}function upTop(rect,top){return top<rect.top?{top:top,left:rect.left,right:rect.right,bottom:rect.bottom}:rect}function upBot(rect,bottom){return bottom>rect.bottom?{top:rect.top,left:rect.left,right:rect.right,bottom:bottom}:rect}function domPosAtCoords(parent,x,y){let closest,closestRect,closestX,closestY,above,below,aboveRect,belowRect,closestOverlap=!1;for(let child=parent.firstChild;child;child=child.nextSibling){let rects=clientRectsFor(child);for(let i=0;i<rects.length;i++){let rect=rects[i];closestRect&&yOverlap(closestRect,rect)&&(rect=upTop(upBot(rect,closestRect.bottom),closestRect.top));let dx=getdx(x,rect),dy=getdy(y,rect);if(0==dx&&0==dy)return 3==child.nodeType?domPosInText(child,x,y):domPosAtCoords(child,x,y);if(!closest||closestY>dy||closestY==dy&&closestX>dx){closest=child,closestRect=rect,closestX=dx,closestY=dy;let side=dy?y<rect.top?-1:1:dx?x<rect.left?-1:1:0;closestOverlap=!side||(side>0?i<rects.length-1:i>0)}0==dx?y>rect.bottom&&(!aboveRect||aboveRect.bottom<rect.bottom)?(above=child,aboveRect=rect):y<rect.top&&(!belowRect||belowRect.top>rect.top)&&(below=child,belowRect=rect):aboveRect&&yOverlap(aboveRect,rect)?aboveRect=upBot(aboveRect,rect.bottom):belowRect&&yOverlap(belowRect,rect)&&(belowRect=upTop(belowRect,rect.top))}}if(aboveRect&&aboveRect.bottom>=y?(closest=above,closestRect=aboveRect):belowRect&&belowRect.top<=y&&(closest=below,closestRect=belowRect),!closest)return{node:parent,offset:0};let clipX=Math.max(closestRect.left,Math.min(closestRect.right,x));return 3==closest.nodeType?domPosInText(closest,clipX,y):closestOverlap&&"false"!=closest.contentEditable?domPosAtCoords(closest,clipX,y):{node:parent,offset:Array.prototype.indexOf.call(parent.childNodes,closest)+(x>=(closestRect.left+closestRect.right)/2?1:0)}}function domPosInText(node,x,y){let len=node.nodeValue.length,closestOffset=-1,closestDY=1e9,generalSide=0;for(let i=0;i<len;i++){let rects=textRange(node,i,i+1).getClientRects();for(let j=0;j<rects.length;j++){let rect=rects[j];if(rect.top==rect.bottom)continue;generalSide||(generalSide=x-rect.left);let dy=(rect.top>y?rect.top-y:y-rect.bottom)-1;if(rect.left-1<=x&&rect.right+1>=x&&dy<closestDY){let right=x>=(rect.left+rect.right)/2,after=right;if(browser.chrome||browser.gecko){textRange(node,i).getBoundingClientRect().left==rect.right&&(after=!right)}if(dy<=0)return{node:node,offset:i+(after?1:0)};closestOffset=i+(after?1:0),closestDY=dy}}}return{node:node,offset:closestOffset>-1?closestOffset:generalSide>0?node.nodeValue.length:0}}function posAtCoords(view,coords,precise){let bias=arguments.length>3&&void 0!==arguments[3]?arguments[3]:-1;var _a,_b;let block,content=view.contentDOM.getBoundingClientRect(),docTop=content.top+view.viewState.paddingTop,{docHeight:docHeight}=view.viewState,{x:x,y:y}=coords,yOffset=y-docTop;if(yOffset<0)return 0;if(yOffset>docHeight)return view.state.doc.length;for(let halfLine=view.viewState.heightOracle.textHeight/2,bounced=!1;block=view.elementAtHeight(yOffset),block.type!=BlockType.Text;)for(;yOffset=bias>0?block.bottom+halfLine:block.top-halfLine,!(yOffset>=0&&yOffset<=docHeight);){if(bounced)return precise?null:0;bounced=!0,bias=-bias}y=docTop+yOffset;let lineStart=block.from;if(lineStart<view.viewport.from)return 0==view.viewport.from?0:precise?null:posAtCoordsImprecise(view,content,block,x,y);if(lineStart>view.viewport.to)return view.viewport.to==view.state.doc.length?view.state.doc.length:precise?null:posAtCoordsImprecise(view,content,block,x,y);let doc=view.dom.ownerDocument,root=view.root.elementFromPoint?view.root:doc,element=root.elementFromPoint(x,y);element&&!view.contentDOM.contains(element)&&(element=null),element||(x=Math.max(content.left+1,Math.min(content.right-1,x)),element=root.elementFromPoint(x,y),element&&!view.contentDOM.contains(element)&&(element=null));let node,offset=-1;if(element&&0!=(null===(_a=view.docView.nearest(element))||void 0===_a?void 0:_a.isEditable))if(doc.caretPositionFromPoint){let pos=doc.caretPositionFromPoint(x,y);pos&&({offsetNode:node,offset:offset}=pos)}else if(doc.caretRangeFromPoint){let range=doc.caretRangeFromPoint(x,y);range&&(({startContainer:node,startOffset:offset}=range),(!view.contentDOM.contains(node)||browser.safari&&isSuspiciousSafariCaretResult(node,offset,x)||browser.chrome&&isSuspiciousChromeCaretResult(node,offset,x))&&(node=void 0))}if(!node||!view.docView.dom.contains(node)){let line=LineView.find(view.docView,lineStart);if(!line)return yOffset>block.top+block.height/2?block.to:block.from;({node:node,offset:offset}=domPosAtCoords(line.dom,x,y))}let nearest=view.docView.nearest(node);if(!nearest)return null;if(nearest.isWidget&&1==(null===(_b=nearest.dom)||void 0===_b?void 0:_b.nodeType)){let rect=nearest.dom.getBoundingClientRect();return coords.y<rect.top||coords.y<=rect.bottom&&coords.x<=(rect.left+rect.right)/2?nearest.posAtStart:nearest.posAtEnd}return nearest.localPosFromDOM(node,offset)+nearest.posAtStart}function posAtCoordsImprecise(view,contentRect,block,x,y){let into=Math.round((x-contentRect.left)*view.defaultCharacterWidth);if(view.lineWrapping&&block.height>1.5*view.defaultLineHeight){let textHeight=view.viewState.heightOracle.textHeight;into+=Math.floor((y-block.top-.5*(view.defaultLineHeight-textHeight))/textHeight)*view.viewState.heightOracle.lineLength}let content=view.state.sliceDoc(block.from,block.to);return block.from+findColumn(content,into,view.state.tabSize)}function isSuspiciousSafariCaretResult(node,offset,x){let len;if(3!=node.nodeType||offset!=(len=node.nodeValue.length))return!1;for(let next=node.nextSibling;next;next=next.nextSibling)if(1!=next.nodeType||"BR"!=next.nodeName)return!1;return textRange(node,len-1,len).getBoundingClientRect().left>x}function isSuspiciousChromeCaretResult(node,offset,x){if(0!=offset)return!1;for(let cur=node;;){let parent=cur.parentNode;if(!parent||1!=parent.nodeType||parent.firstChild!=cur)return!1;if(parent.classList.contains("cm-line"))break;cur=parent}return x-(1==node.nodeType?node.getBoundingClientRect():textRange(node,0,Math.max(node.nodeValue.length,1)).getBoundingClientRect()).left>5}function blockAt(view,pos){let line=view.lineBlockAt(pos);if(Array.isArray(line.type))for(let l of line.type)if(l.to>pos||l.to==pos&&(l.to==line.to||l.type==BlockType.Text))return l;return line}function moveByChar(view,start,forward,by){let line=view.state.doc.lineAt(start.head),spans=view.bidiSpans(line),direction=view.textDirectionAt(line.from);for(let cur=start,check=null;;){let next=moveVisually(line,spans,direction,cur,forward),char=movedOver;if(!next){if(line.number==(forward?view.state.doc.lines:1))return cur;char="\n",line=view.state.doc.line(line.number+(forward?1:-1)),spans=view.bidiSpans(line),next=EditorSelection.cursor(forward?line.from:line.to)}if(check){if(!check(char))return cur}else{if(!by)return next;check=by(char)}cur=next}}function skipAtomicRanges(atoms,pos,bias){for(;;){let moved=0;for(let set of atoms)set.between(pos-1,pos+1,((from,to,value)=>{if(pos>from&&pos<to){let side=moved||bias||(pos-from<to-pos?-1:1);pos=side<0?from:to,moved=side}}));if(!moved)return pos}}function skipAtoms(view,oldPos,pos){let newPos=skipAtomicRanges(view.state.facet(atomicRanges).map((f=>f(view))),pos.from,oldPos.head>pos.from?-1:1);return newPos==pos.from?pos:EditorSelection.cursor(newPos,newPos<pos.from?1:-1)}class InputState{constructor(view){this.lastKeyCode=0,this.lastKeyTime=0,this.lastTouchTime=0,this.lastFocusTime=0,this.lastScrollTop=0,this.lastScrollLeft=0,this.chromeScrollHack=-1,this.pendingIOSKey=void 0,this.lastSelectionOrigin=null,this.lastSelectionTime=0,this.lastEscPress=0,this.lastContextMenu=0,this.scrollHandlers=[],this.registeredEvents=[],this.customHandlers=[],this.composing=-1,this.compositionFirstChange=null,this.compositionEndedAt=0,this.compositionPendingKey=!1,this.compositionPendingChange=!1,this.mouseSelection=null;let handleEvent=(handler,event)=>{this.ignoreDuringComposition(event)||"keydown"==event.type&&this.keydown(view,event)||(this.mustFlushObserver(event)&&view.observer.forceFlush(),this.runCustomHandlers(event.type,view,event)?event.preventDefault():handler(view,event))};for(let type in handlers){let handler=handlers[type];view.contentDOM.addEventListener(type,(event=>{eventBelongsToEditor(view,event)&&handleEvent(handler,event)}),handlerOptions[type]),this.registeredEvents.push(type)}view.scrollDOM.addEventListener("mousedown",(event=>{if(event.target==view.scrollDOM&&event.clientY>view.contentDOM.getBoundingClientRect().bottom&&(handleEvent(handlers.mousedown,event),!event.defaultPrevented&&2==event.button)){let start=view.contentDOM.style.minHeight;view.contentDOM.style.minHeight="100%",setTimeout((()=>view.contentDOM.style.minHeight=start),200)}})),view.scrollDOM.addEventListener("drop",(event=>{event.target==view.scrollDOM&&event.clientY>view.contentDOM.getBoundingClientRect().bottom&&handleEvent(handlers.drop,event)})),browser.chrome&&102==browser.chrome_version&&view.scrollDOM.addEventListener("wheel",(()=>{this.chromeScrollHack<0?view.contentDOM.style.pointerEvents="none":window.clearTimeout(this.chromeScrollHack),this.chromeScrollHack=setTimeout((()=>{this.chromeScrollHack=-1,view.contentDOM.style.pointerEvents=""}),100)}),{passive:!0}),this.notifiedFocused=view.hasFocus,browser.safari&&view.contentDOM.addEventListener("input",(()=>null))}setSelectionOrigin(origin){this.lastSelectionOrigin=origin,this.lastSelectionTime=Date.now()}ensureHandlers(view,plugins){var _a;let handlers;this.customHandlers=[];for(let plugin of plugins)if(handlers=null===(_a=plugin.update(view).spec)||void 0===_a?void 0:_a.domEventHandlers){this.customHandlers.push({plugin:plugin.value,handlers:handlers});for(let type in handlers)this.registeredEvents.indexOf(type)<0&&"scroll"!=type&&(this.registeredEvents.push(type),view.contentDOM.addEventListener(type,(event=>{eventBelongsToEditor(view,event)&&this.runCustomHandlers(type,view,event)&&event.preventDefault()})))}}runCustomHandlers(type,view,event){for(let set of this.customHandlers){let handler=set.handlers[type];if(handler)try{if(handler.call(set.plugin,event,view)||event.defaultPrevented)return!0}catch(e){logException(view.state,e)}}return!1}runScrollHandlers(view,event){this.lastScrollTop=view.scrollDOM.scrollTop,this.lastScrollLeft=view.scrollDOM.scrollLeft;for(let set of this.customHandlers){let handler=set.handlers.scroll;if(handler)try{handler.call(set.plugin,event,view)}catch(e){logException(view.state,e)}}}keydown(view,event){if(this.lastKeyCode=event.keyCode,this.lastKeyTime=Date.now(),9==event.keyCode&&Date.now()<this.lastEscPress+2e3)return!0;if(27!=event.keyCode&&modifierCodes.indexOf(event.keyCode)<0&&(view.inputState.lastEscPress=0),browser.android&&browser.chrome&&!event.synthetic&&(13==event.keyCode||8==event.keyCode))return view.observer.delayAndroidKey(event.key,event.keyCode),!0;let pending;return!(!browser.ios||event.synthetic||event.altKey||event.metaKey||!((pending=PendingKeys.find((key=>key.keyCode==event.keyCode)))&&!event.ctrlKey||EmacsyPendingKeys.indexOf(event.key)>-1&&event.ctrlKey&&!event.shiftKey))&&(this.pendingIOSKey=pending||event,setTimeout((()=>this.flushIOSKey(view)),250),!0)}flushIOSKey(view){let key=this.pendingIOSKey;return!!key&&(this.pendingIOSKey=void 0,dispatchKey(view.contentDOM,key.key,key.keyCode))}ignoreDuringComposition(event){return!!/^key/.test(event.type)&&(this.composing>0||!!(browser.safari&&!browser.ios&&this.compositionPendingKey&&Date.now()-this.compositionEndedAt<100)&&(this.compositionPendingKey=!1,!0))}mustFlushObserver(event){return"keydown"==event.type&&229!=event.keyCode}startMouseSelection(mouseSelection){this.mouseSelection&&this.mouseSelection.destroy(),this.mouseSelection=mouseSelection}update(update){this.mouseSelection&&this.mouseSelection.update(update),update.transactions.length&&(this.lastKeyCode=this.lastSelectionTime=0)}destroy(){this.mouseSelection&&this.mouseSelection.destroy()}}const PendingKeys=[{key:"Backspace",keyCode:8,inputType:"deleteContentBackward"},{key:"Enter",keyCode:13,inputType:"insertParagraph"},{key:"Delete",keyCode:46,inputType:"deleteContentForward"}],EmacsyPendingKeys="dthko",modifierCodes=[16,17,18,20,91,92,224,225];function dragScrollSpeed(dist){return.7*Math.max(0,dist)+8}class MouseSelection{constructor(view,startEvent,style,mustSelect){this.view=view,this.style=style,this.mustSelect=mustSelect,this.scrollSpeed={x:0,y:0},this.scrolling=-1,this.lastEvent=startEvent,this.scrollParent=function(dom){let doc=dom.ownerDocument;for(let cur=dom.parentNode;cur&&cur!=doc.body;)if(1==cur.nodeType){if(cur.scrollHeight>cur.clientHeight||cur.scrollWidth>cur.clientWidth)return cur;cur=cur.assignedSlot||cur.parentNode}else{if(11!=cur.nodeType)break;cur=cur.host}return null}(view.contentDOM),this.atoms=view.state.facet(atomicRanges).map((f=>f(view)));let doc=view.contentDOM.ownerDocument;doc.addEventListener("mousemove",this.move=this.move.bind(this)),doc.addEventListener("mouseup",this.up=this.up.bind(this)),this.extend=startEvent.shiftKey,this.multiple=view.state.facet(EditorState.allowMultipleSelections)&&function(view,event){let facet=view.state.facet(clickAddsSelectionRange);return facet.length?facet[0](event):browser.mac?event.metaKey:event.ctrlKey}(view,startEvent),this.dragging=!(!function(view,event){let{main:main}=view.state.selection;if(main.empty)return!1;let sel=getSelection(view.root);if(!sel||0==sel.rangeCount)return!0;let rects=sel.getRangeAt(0).getClientRects();for(let i=0;i<rects.length;i++){let rect=rects[i];if(rect.left<=event.clientX&&rect.right>=event.clientX&&rect.top<=event.clientY&&rect.bottom>=event.clientY)return!0}return!1}(view,startEvent)||1!=getClickType(startEvent))&&null}start(event){!1===this.dragging&&(event.preventDefault(),this.select(event))}move(event){var _a;if(0==event.buttons)return this.destroy();if(!1!==this.dragging)return;this.select(this.lastEvent=event);let sx=0,sy=0,rect=(null===(_a=this.scrollParent)||void 0===_a?void 0:_a.getBoundingClientRect())||{left:0,top:0,right:this.view.win.innerWidth,bottom:this.view.win.innerHeight},margins=getScrollMargins(this.view);event.clientX-margins.left<=rect.left+6?sx=-dragScrollSpeed(rect.left-event.clientX):event.clientX+margins.right>=rect.right-6&&(sx=dragScrollSpeed(event.clientX-rect.right)),event.clientY-margins.top<=rect.top+6?sy=-dragScrollSpeed(rect.top-event.clientY):event.clientY+margins.bottom>=rect.bottom-6&&(sy=dragScrollSpeed(event.clientY-rect.bottom)),this.setScrollSpeed(sx,sy)}up(event){null==this.dragging&&this.select(this.lastEvent),this.dragging||event.preventDefault(),this.destroy()}destroy(){this.setScrollSpeed(0,0);let doc=this.view.contentDOM.ownerDocument;doc.removeEventListener("mousemove",this.move),doc.removeEventListener("mouseup",this.up),this.view.inputState.mouseSelection=null}setScrollSpeed(sx,sy){this.scrollSpeed={x:sx,y:sy},sx||sy?this.scrolling<0&&(this.scrolling=setInterval((()=>this.scroll()),50)):this.scrolling>-1&&(clearInterval(this.scrolling),this.scrolling=-1)}scroll(){this.scrollParent?(this.scrollParent.scrollLeft+=this.scrollSpeed.x,this.scrollParent.scrollTop+=this.scrollSpeed.y):this.view.win.scrollBy(this.scrollSpeed.x,this.scrollSpeed.y),!1===this.dragging&&this.select(this.lastEvent)}skipAtoms(sel){let ranges=null;for(let i=0;i<sel.ranges.length;i++){let range=sel.ranges[i],updated=null;if(range.empty){let pos=skipAtomicRanges(this.atoms,range.from,0);pos!=range.from&&(updated=EditorSelection.cursor(pos,-1))}else{let from=skipAtomicRanges(this.atoms,range.from,-1),to=skipAtomicRanges(this.atoms,range.to,1);from==range.from&&to==range.to||(updated=EditorSelection.range(range.from==range.anchor?from:to,range.from==range.head?from:to))}updated&&(ranges||(ranges=sel.ranges.slice()),ranges[i]=updated)}return ranges?EditorSelection.create(ranges,sel.mainIndex):sel}select(event){let{view:view}=this,selection=this.skipAtoms(this.style.get(event,this.extend,this.multiple));!this.mustSelect&&selection.eq(view.state.selection)&&selection.main.assoc==view.state.selection.main.assoc||this.view.dispatch({selection:selection,userEvent:"select.pointer"}),this.mustSelect=!1}update(update){update.docChanged&&this.dragging&&(this.dragging=this.dragging.map(update.changes)),this.style.update(update)&&setTimeout((()=>this.select(this.lastEvent)),20)}}function eventBelongsToEditor(view,event){if(!event.bubbles)return!0;if(event.defaultPrevented)return!1;for(let cView,node=event.target;node!=view.contentDOM;node=node.parentNode)if(!node||11==node.nodeType||(cView=ContentView.get(node))&&cView.ignoreEvent(event))return!1;return!0}const handlers=Object.create(null),handlerOptions=Object.create(null),brokenClipboardAPI=browser.ie&&browser.ie_version<15||browser.ios&&browser.webkit_version<604;function doPaste(view,input){let changes,{state:state}=view,i=1,text=state.toText(input),byLine=text.lines==state.selection.ranges.length;if(null!=lastLinewiseCopy&&state.selection.ranges.every((r=>r.empty))&&lastLinewiseCopy==text.toString()){let lastLine=-1;changes=state.changeByRange((range=>{let line=state.doc.lineAt(range.from);if(line.from==lastLine)return{range:range};lastLine=line.from;let insert=state.toText((byLine?text.line(i++).text:input)+state.lineBreak);return{changes:{from:line.from,insert:insert},range:EditorSelection.cursor(range.from+insert.length)}}))}else changes=byLine?state.changeByRange((range=>{let line=text.line(i++);return{changes:{from:range.from,to:range.to,insert:line.text},range:EditorSelection.cursor(range.from+line.length)}})):state.replaceSelection(text);view.dispatch(changes,{userEvent:"input.paste",scrollIntoView:!0})}function rangeForClick(view,pos,bias,type){if(1==type)return EditorSelection.cursor(pos,bias);if(2==type)return function(state,pos){let bias=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1,categorize=state.charCategorizer(pos),line=state.doc.lineAt(pos),linePos=pos-line.from;if(0==line.length)return EditorSelection.cursor(pos);0==linePos?bias=1:linePos==line.length&&(bias=-1);let from=linePos,to=linePos;bias<0?from=findClusterBreak(line.text,linePos,!1):to=findClusterBreak(line.text,linePos);let cat=categorize(line.text.slice(from,to));for(;from>0;){let prev=findClusterBreak(line.text,from,!1);if(categorize(line.text.slice(prev,from))!=cat)break;from=prev}for(;to<line.length;){let next=findClusterBreak(line.text,to);if(categorize(line.text.slice(to,next))!=cat)break;to=next}return EditorSelection.range(from+line.from,to+line.from)}(view.state,pos,bias);{let visual=LineView.find(view.docView,pos),line=view.state.doc.lineAt(visual?visual.posAtEnd:pos),from=visual?visual.posAtStart:line.from,to=visual?visual.posAtEnd:line.to;return to<view.state.doc.length&&to==line.to&&to++,EditorSelection.range(from,to)}}handlers.keydown=(view,event)=>{view.inputState.setSelectionOrigin("select"),27==event.keyCode&&(view.inputState.lastEscPress=Date.now())},handlers.touchstart=(view,e)=>{view.inputState.lastTouchTime=Date.now(),view.inputState.setSelectionOrigin("select.pointer")},handlers.touchmove=view=>{view.inputState.setSelectionOrigin("select.pointer")},handlerOptions.touchstart=handlerOptions.touchmove={passive:!0},handlers.mousedown=(view,event)=>{if(view.observer.flush(),view.inputState.lastTouchTime>Date.now()-2e3)return;let style=null;for(let makeStyle of view.state.facet(mouseSelectionStyle))if(style=makeStyle(view,event),style)break;if(style||0!=event.button||(style=function(view,event){let start=queryPos(view,event),type=getClickType(event),startSel=view.state.selection;return{update(update){update.docChanged&&(start.pos=update.changes.mapPos(start.pos),startSel=startSel.map(update.changes))},get(event,extend,multiple){let removed,cur=queryPos(view,event),range=rangeForClick(view,cur.pos,cur.bias,type);if(start.pos!=cur.pos&&!extend){let startRange=rangeForClick(view,start.pos,start.bias,type),from=Math.min(startRange.from,range.from),to=Math.max(startRange.to,range.to);range=from<range.from?EditorSelection.range(from,to):EditorSelection.range(to,from)}return extend?startSel.replaceRange(startSel.main.extend(range.from,range.to)):multiple&&1==type&&startSel.ranges.length>1&&(removed=function(sel,pos){for(let i=0;i<sel.ranges.length;i++){let{from:from,to:to}=sel.ranges[i];if(from<=pos&&to>=pos)return EditorSelection.create(sel.ranges.slice(0,i).concat(sel.ranges.slice(i+1)),sel.mainIndex==i?0:sel.mainIndex-(sel.mainIndex>i?1:0))}return null}(startSel,cur.pos))?removed:multiple?startSel.addRange(range):EditorSelection.create([range])}}}(view,event)),style){let mustFocus=view.root.activeElement!=view.contentDOM;view.inputState.startMouseSelection(new MouseSelection(view,event,style,mustFocus)),mustFocus&&view.observer.ignore((()=>focusPreventScroll(view.contentDOM))),view.inputState.mouseSelection&&view.inputState.mouseSelection.start(event)}};let insideY=(y,rect)=>y>=rect.top&&y<=rect.bottom,inside=(x,y,rect)=>insideY(y,rect)&&x>=rect.left&&x<=rect.right;function findPositionSide(view,pos,x,y){let line=LineView.find(view.docView,pos);if(!line)return 1;let off=pos-line.posAtStart;if(0==off)return 1;if(off==line.length)return-1;let before=line.coordsAt(off,-1);if(before&&inside(x,y,before))return-1;let after=line.coordsAt(off,1);return after&&inside(x,y,after)?1:before&&insideY(y,before)?-1:1}function queryPos(view,event){let pos=view.posAtCoords({x:event.clientX,y:event.clientY},!1);return{pos:pos,bias:findPositionSide(view,pos,event.clientX,event.clientY)}}const BadMouseDetail=browser.ie&&browser.ie_version<=11;let lastMouseDown=null,lastMouseDownCount=0,lastMouseDownTime=0;function getClickType(event){if(!BadMouseDetail)return event.detail;let last=lastMouseDown,lastTime=lastMouseDownTime;return lastMouseDown=event,lastMouseDownTime=Date.now(),lastMouseDownCount=!last||lastTime>Date.now()-400&&Math.abs(last.clientX-event.clientX)<2&&Math.abs(last.clientY-event.clientY)<2?(lastMouseDownCount+1)%3:1}function dropText(view,event,text,direct){if(!text)return;let dropPos=view.posAtCoords({x:event.clientX,y:event.clientY},!1);event.preventDefault();let{mouseSelection:mouseSelection}=view.inputState,del=direct&&mouseSelection&&mouseSelection.dragging&&function(view,event){let facet=view.state.facet(dragMovesSelection$1);return facet.length?facet[0](event):browser.mac?!event.altKey:!event.ctrlKey}(view,event)?{from:mouseSelection.dragging.from,to:mouseSelection.dragging.to}:null,ins={from:dropPos,insert:text},changes=view.state.changes(del?[del,ins]:ins);view.focus(),view.dispatch({changes:changes,selection:{anchor:changes.mapPos(dropPos,-1),head:changes.mapPos(dropPos,1)},userEvent:del?"move.drop":"input.drop"})}handlers.dragstart=(view,event)=>{let{selection:{main:main}}=view.state,{mouseSelection:mouseSelection}=view.inputState;mouseSelection&&(mouseSelection.dragging=main),event.dataTransfer&&(event.dataTransfer.setData("Text",view.state.sliceDoc(main.from,main.to)),event.dataTransfer.effectAllowed="copyMove")},handlers.drop=(view,event)=>{if(!event.dataTransfer)return;if(view.state.readOnly)return event.preventDefault();let files=event.dataTransfer.files;if(files&&files.length){event.preventDefault();let text=Array(files.length),read=0,finishFile=()=>{++read==files.length&&dropText(view,event,text.filter((s=>null!=s)).join(view.state.lineBreak),!1)};for(let i=0;i<files.length;i++){let reader=new FileReader;reader.onerror=finishFile,reader.onload=()=>{/[\x00-\x08\x0e-\x1f]{2}/.test(reader.result)||(text[i]=reader.result),finishFile()},reader.readAsText(files[i])}}else dropText(view,event,event.dataTransfer.getData("Text"),!0)},handlers.paste=(view,event)=>{if(view.state.readOnly)return event.preventDefault();view.observer.flush();let data=brokenClipboardAPI?null:event.clipboardData;data?(doPaste(view,data.getData("text/plain")||data.getData("text/uri-text")),event.preventDefault()):function(view){let parent=view.dom.parentNode;if(!parent)return;let target=parent.appendChild(document.createElement("textarea"));target.style.cssText="position: fixed; left: -10000px; top: 10px",target.focus(),setTimeout((()=>{view.focus(),target.remove(),doPaste(view,target.value)}),50)}(view)};let lastLinewiseCopy=null;handlers.copy=handlers.cut=(view,event)=>{let{text:text,ranges:ranges,linewise:linewise}=function(state){let content=[],ranges=[],linewise=!1;for(let range of state.selection.ranges)range.empty||(content.push(state.sliceDoc(range.from,range.to)),ranges.push(range));if(!content.length){let upto=-1;for(let{from:from}of state.selection.ranges){let line=state.doc.lineAt(from);line.number>upto&&(content.push(line.text),ranges.push({from:line.from,to:Math.min(state.doc.length,line.to+1)})),upto=line.number}linewise=!0}return{text:content.join(state.lineBreak),ranges:ranges,linewise:linewise}}(view.state);if(!text&&!linewise)return;lastLinewiseCopy=linewise?text:null;let data=brokenClipboardAPI?null:event.clipboardData;data?(event.preventDefault(),data.clearData(),data.setData("text/plain",text)):function(view,text){let parent=view.dom.parentNode;if(!parent)return;let target=parent.appendChild(document.createElement("textarea"));target.style.cssText="position: fixed; left: -10000px; top: 10px",target.value=text,target.focus(),target.selectionEnd=text.length,target.selectionStart=0,setTimeout((()=>{target.remove(),view.focus()}),50)}(view,text),"cut"!=event.type||view.state.readOnly||view.dispatch({changes:ranges,scrollIntoView:!0,userEvent:"delete.cut"})};const isFocusChange=Annotation.define();function focusChangeTransaction(state,focus){let effects=[];for(let getEffect of state.facet(focusChangeEffect)){let effect=getEffect(state,focus);effect&&effects.push(effect)}return effects?state.update({effects:effects,annotations:isFocusChange.of(!0)}):null}function updateForFocusChange(view){setTimeout((()=>{let focus=view.hasFocus;if(focus!=view.inputState.notifiedFocused){let tr=focusChangeTransaction(view.state,focus);tr?view.dispatch(tr):view.update([])}}),10)}handlers.focus=view=>{view.inputState.lastFocusTime=Date.now(),view.scrollDOM.scrollTop||!view.inputState.lastScrollTop&&!view.inputState.lastScrollLeft||(view.scrollDOM.scrollTop=view.inputState.lastScrollTop,view.scrollDOM.scrollLeft=view.inputState.lastScrollLeft),updateForFocusChange(view)},handlers.blur=view=>{view.observer.clearSelectionRange(),updateForFocusChange(view)},handlers.compositionstart=handlers.compositionupdate=view=>{null==view.inputState.compositionFirstChange&&(view.inputState.compositionFirstChange=!0),view.inputState.composing<0&&(view.inputState.composing=0)},handlers.compositionend=view=>{view.inputState.composing=-1,view.inputState.compositionEndedAt=Date.now(),view.inputState.compositionPendingKey=!0,view.inputState.compositionPendingChange=view.observer.pendingRecords().length>0,view.inputState.compositionFirstChange=null,browser.chrome&&browser.android?view.observer.flushSoon():view.inputState.compositionPendingChange?Promise.resolve().then((()=>view.observer.flush())):setTimeout((()=>{view.inputState.composing<0&&view.docView.compositionDeco.size&&view.update([])}),50)},handlers.contextmenu=view=>{view.inputState.lastContextMenu=Date.now()},handlers.beforeinput=(view,event)=>{var _a;let pending;if(browser.chrome&&browser.android&&(pending=PendingKeys.find((key=>key.inputType==event.inputType)))&&(view.observer.delayAndroidKey(pending.key,pending.keyCode),"Backspace"==pending.key||"Delete"==pending.key)){let startViewHeight=(null===(_a=window.visualViewport)||void 0===_a?void 0:_a.height)||0;setTimeout((()=>{var _a;((null===(_a=window.visualViewport)||void 0===_a?void 0:_a.height)||0)>startViewHeight+10&&view.hasFocus&&(view.contentDOM.blur(),view.focus())}),100)}};const wrappingWhiteSpace=["pre-wrap","normal","pre-line","break-spaces"];class HeightOracle{constructor(lineWrapping){this.lineWrapping=lineWrapping,this.doc=Text.empty,this.heightSamples={},this.lineHeight=14,this.charWidth=7,this.textHeight=14,this.lineLength=30,this.heightChanged=!1}heightForGap(from,to){let lines=this.doc.lineAt(to).number-this.doc.lineAt(from).number+1;return this.lineWrapping&&(lines+=Math.max(0,Math.ceil((to-from-lines*this.lineLength*.5)/this.lineLength))),this.lineHeight*lines}heightForLine(length){if(!this.lineWrapping)return this.lineHeight;return(1+Math.max(0,Math.ceil((length-this.lineLength)/(this.lineLength-5))))*this.lineHeight}setDoc(doc){return this.doc=doc,this}mustRefreshForWrapping(whiteSpace){return wrappingWhiteSpace.indexOf(whiteSpace)>-1!=this.lineWrapping}mustRefreshForHeights(lineHeights){let newHeight=!1;for(let i=0;i<lineHeights.length;i++){let h=lineHeights[i];h<0?i++:this.heightSamples[Math.floor(10*h)]||(newHeight=!0,this.heightSamples[Math.floor(10*h)]=!0)}return newHeight}refresh(whiteSpace,lineHeight,charWidth,textHeight,lineLength,knownHeights){let lineWrapping=wrappingWhiteSpace.indexOf(whiteSpace)>-1,changed=Math.round(lineHeight)!=Math.round(this.lineHeight)||this.lineWrapping!=lineWrapping;if(this.lineWrapping=lineWrapping,this.lineHeight=lineHeight,this.charWidth=charWidth,this.textHeight=textHeight,this.lineLength=lineLength,changed){this.heightSamples={};for(let i=0;i<knownHeights.length;i++){let h=knownHeights[i];h<0?i++:this.heightSamples[Math.floor(10*h)]=!0}}return changed}}class MeasuredHeights{constructor(from,heights){this.from=from,this.heights=heights,this.index=0}get more(){return this.index<this.heights.length}}class BlockInfo{constructor(from,length,top,height,_content){this.from=from,this.length=length,this.top=top,this.height=height,this._content=_content}get type(){return"number"==typeof this._content?BlockType.Text:Array.isArray(this._content)?this._content:this._content.type}get to(){return this.from+this.length}get bottom(){return this.top+this.height}get widget(){return this._content instanceof PointDecoration?this._content.widget:null}get widgetLineBreaks(){return"number"==typeof this._content?this._content:0}join(other){let content=(Array.isArray(this._content)?this._content:[this]).concat(Array.isArray(other._content)?other._content:[other]);return new BlockInfo(this.from,this.length+other.length,this.top,this.height+other.height,content)}}var QueryType$1=function(QueryType){return QueryType[QueryType.ByPos=0]="ByPos",QueryType[QueryType.ByHeight=1]="ByHeight",QueryType[QueryType.ByPosNoHeight=2]="ByPosNoHeight",QueryType}(QueryType$1||(QueryType$1={}));class HeightMap{constructor(length,height){let flags=arguments.length>2&&void 0!==arguments[2]?arguments[2]:2;this.length=length,this.height=height,this.flags=flags}get outdated(){return(2&this.flags)>0}set outdated(value){this.flags=(value?2:0)|-3&this.flags}setHeight(oracle,height){this.height!=height&&(Math.abs(this.height-height)>.001&&(oracle.heightChanged=!0),this.height=height)}replace(_from,_to,nodes){return HeightMap.of(nodes)}decomposeLeft(_to,result){result.push(this)}decomposeRight(_from,result){result.push(this)}applyChanges(decorations,oldDoc,oracle,changes){let me=this,doc=oracle.doc;for(let i=changes.length-1;i>=0;i--){let{fromA:fromA,toA:toA,fromB:fromB,toB:toB}=changes[i],start=me.lineAt(fromA,QueryType$1.ByPosNoHeight,oracle.setDoc(oldDoc),0,0),end=start.to>=toA?start:me.lineAt(toA,QueryType$1.ByPosNoHeight,oracle,0,0);for(toB+=end.to-toA,toA=end.to;i>0&&start.from<=changes[i-1].toA;)fromA=changes[i-1].fromA,fromB=changes[i-1].fromB,i--,fromA<start.from&&(start=me.lineAt(fromA,QueryType$1.ByPosNoHeight,oracle,0,0));fromB+=start.from-fromA,fromA=start.from;let nodes=NodeBuilder.build(oracle.setDoc(doc),decorations,fromB,toB);me=me.replace(fromA,toA,nodes)}return me.updateHeight(oracle,0)}static empty(){return new HeightMapText(0,0)}static of(nodes){if(1==nodes.length)return nodes[0];let i=0,j=nodes.length,before=0,after=0;for(;;)if(i==j)if(before>2*after){let split=nodes[i-1];split.break?nodes.splice(--i,1,split.left,null,split.right):nodes.splice(--i,1,split.left,split.right),j+=1+split.break,before-=split.size}else{if(!(after>2*before))break;{let split=nodes[j];split.break?nodes.splice(j,1,split.left,null,split.right):nodes.splice(j,1,split.left,split.right),j+=2+split.break,after-=split.size}}else if(before<after){let next=nodes[i++];next&&(before+=next.size)}else{let next=nodes[--j];next&&(after+=next.size)}let brk=0;return null==nodes[i-1]?(brk=1,i--):null==nodes[i]&&(brk=1,j++),new HeightMapBranch(HeightMap.of(nodes.slice(0,i)),brk,HeightMap.of(nodes.slice(j)))}}HeightMap.prototype.size=1;class HeightMapBlock extends HeightMap{constructor(length,height,deco){super(length,height),this.deco=deco}blockAt(_height,_oracle,top,offset){return new BlockInfo(offset,this.length,top,this.height,this.deco||0)}lineAt(_value,_type,oracle,top,offset){return this.blockAt(0,oracle,top,offset)}forEachLine(from,to,oracle,top,offset,f){from<=offset+this.length&&to>=offset&&f(this.blockAt(0,oracle,top,offset))}updateHeight(oracle){let offset=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,measured=arguments.length>3?arguments[3]:void 0;return measured&&measured.from<=offset&&measured.more&&this.setHeight(oracle,measured.heights[measured.index++]),this.outdated=!1,this}toString(){return"block(".concat(this.length,")")}}class HeightMapText extends HeightMapBlock{constructor(length,height){super(length,height,null),this.collapsed=0,this.widgetHeight=0,this.breaks=0}blockAt(_height,_oracle,top,offset){return new BlockInfo(offset,this.length,top,this.height,this.breaks)}replace(_from,_to,nodes){let node=nodes[0];return 1==nodes.length&&(node instanceof HeightMapText||node instanceof HeightMapGap&&4&node.flags)&&Math.abs(this.length-node.length)<10?(node instanceof HeightMapGap?node=new HeightMapText(node.length,this.height):node.height=this.height,this.outdated||(node.outdated=!1),node):HeightMap.of(nodes)}updateHeight(oracle){let offset=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,force=arguments.length>2&&void 0!==arguments[2]&&arguments[2],measured=arguments.length>3?arguments[3]:void 0;return measured&&measured.from<=offset&&measured.more?this.setHeight(oracle,measured.heights[measured.index++]):(force||this.outdated)&&this.setHeight(oracle,Math.max(this.widgetHeight,oracle.heightForLine(this.length-this.collapsed))+this.breaks*oracle.lineHeight),this.outdated=!1,this}toString(){return"line(".concat(this.length).concat(this.collapsed?-this.collapsed:"").concat(this.widgetHeight?":"+this.widgetHeight:"",")")}}class HeightMapGap extends HeightMap{constructor(length){super(length,0)}heightMetrics(oracle,offset){let perLine,firstLine=oracle.doc.lineAt(offset).number,lastLine=oracle.doc.lineAt(offset+this.length).number,lines=lastLine-firstLine+1,perChar=0;if(oracle.lineWrapping){let totalPerLine=Math.min(this.height,oracle.lineHeight*lines);perLine=totalPerLine/lines,this.length>lines+1&&(perChar=(this.height-totalPerLine)/(this.length-lines-1))}else perLine=this.height/lines;return{firstLine:firstLine,lastLine:lastLine,perLine:perLine,perChar:perChar}}blockAt(height,oracle,top,offset){let{firstLine:firstLine,lastLine:lastLine,perLine:perLine,perChar:perChar}=this.heightMetrics(oracle,offset);if(oracle.lineWrapping){let guess=offset+Math.round(Math.max(0,Math.min(1,(height-top)/this.height))*this.length),line=oracle.doc.lineAt(guess),lineHeight=perLine+line.length*perChar,lineTop=Math.max(top,height-lineHeight/2);return new BlockInfo(line.from,line.length,lineTop,lineHeight,0)}{let line=Math.max(0,Math.min(lastLine-firstLine,Math.floor((height-top)/perLine))),{from:from,length:length}=oracle.doc.line(firstLine+line);return new BlockInfo(from,length,top+perLine*line,perLine,0)}}lineAt(value,type,oracle,top,offset){if(type==QueryType$1.ByHeight)return this.blockAt(value,oracle,top,offset);if(type==QueryType$1.ByPosNoHeight){let{from:from,to:to}=oracle.doc.lineAt(value);return new BlockInfo(from,to-from,0,0,0)}let{firstLine:firstLine,perLine:perLine,perChar:perChar}=this.heightMetrics(oracle,offset),line=oracle.doc.lineAt(value),lineHeight=perLine+line.length*perChar,linesAbove=line.number-firstLine,lineTop=top+perLine*linesAbove+perChar*(line.from-offset-linesAbove);return new BlockInfo(line.from,line.length,Math.max(top,Math.min(lineTop,top+this.height-lineHeight)),lineHeight,0)}forEachLine(from,to,oracle,top,offset,f){from=Math.max(from,offset),to=Math.min(to,offset+this.length);let{firstLine:firstLine,perLine:perLine,perChar:perChar}=this.heightMetrics(oracle,offset);for(let pos=from,lineTop=top;pos<=to;){let line=oracle.doc.lineAt(pos);if(pos==from){let linesAbove=line.number-firstLine;lineTop+=perLine*linesAbove+perChar*(from-offset-linesAbove)}let lineHeight=perLine+perChar*line.length;f(new BlockInfo(line.from,line.length,lineTop,lineHeight,0)),lineTop+=lineHeight,pos=line.to+1}}replace(from,to,nodes){let after=this.length-to;if(after>0){let last=nodes[nodes.length-1];last instanceof HeightMapGap?nodes[nodes.length-1]=new HeightMapGap(last.length+after):nodes.push(null,new HeightMapGap(after-1))}if(from>0){let first=nodes[0];first instanceof HeightMapGap?nodes[0]=new HeightMapGap(from+first.length):nodes.unshift(new HeightMapGap(from-1),null)}return HeightMap.of(nodes)}decomposeLeft(to,result){result.push(new HeightMapGap(to-1),null)}decomposeRight(from,result){result.push(null,new HeightMapGap(this.length-from-1))}updateHeight(oracle){let offset=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,force=arguments.length>2&&void 0!==arguments[2]&&arguments[2],measured=arguments.length>3?arguments[3]:void 0,end=offset+this.length;if(measured&&measured.from<=offset+this.length&&measured.more){let nodes=[],pos=Math.max(offset,measured.from),singleHeight=-1;for(measured.from>offset&&nodes.push(new HeightMapGap(measured.from-offset-1).updateHeight(oracle,offset));pos<=end&&measured.more;){let len=oracle.doc.lineAt(pos).length;nodes.length&&nodes.push(null);let height=measured.heights[measured.index++];-1==singleHeight?singleHeight=height:Math.abs(height-singleHeight)>=.001&&(singleHeight=-2);let line=new HeightMapText(len,height);line.outdated=!1,nodes.push(line),pos+=len+1}pos<=end&&nodes.push(null,new HeightMapGap(end-pos).updateHeight(oracle,pos));let result=HeightMap.of(nodes);return(singleHeight<0||Math.abs(result.height-this.height)>=.001||Math.abs(singleHeight-this.heightMetrics(oracle,offset).perLine)>=.001)&&(oracle.heightChanged=!0),result}return(force||this.outdated)&&(this.setHeight(oracle,oracle.heightForGap(offset,offset+this.length)),this.outdated=!1),this}toString(){return"gap(".concat(this.length,")")}}class HeightMapBranch extends HeightMap{constructor(left,brk,right){super(left.length+brk+right.length,left.height+right.height,brk|(left.outdated||right.outdated?2:0)),this.left=left,this.right=right,this.size=left.size+right.size}get break(){return 1&this.flags}blockAt(height,oracle,top,offset){let mid=top+this.left.height;return height<mid?this.left.blockAt(height,oracle,top,offset):this.right.blockAt(height,oracle,mid,offset+this.left.length+this.break)}lineAt(value,type,oracle,top,offset){let rightTop=top+this.left.height,rightOffset=offset+this.left.length+this.break,left=type==QueryType$1.ByHeight?value<rightTop:value<rightOffset,base=left?this.left.lineAt(value,type,oracle,top,offset):this.right.lineAt(value,type,oracle,rightTop,rightOffset);if(this.break||(left?base.to<rightOffset:base.from>rightOffset))return base;let subQuery=type==QueryType$1.ByPosNoHeight?QueryType$1.ByPosNoHeight:QueryType$1.ByPos;return left?base.join(this.right.lineAt(rightOffset,subQuery,oracle,rightTop,rightOffset)):this.left.lineAt(rightOffset,subQuery,oracle,top,offset).join(base)}forEachLine(from,to,oracle,top,offset,f){let rightTop=top+this.left.height,rightOffset=offset+this.left.length+this.break;if(this.break)from<rightOffset&&this.left.forEachLine(from,to,oracle,top,offset,f),to>=rightOffset&&this.right.forEachLine(from,to,oracle,rightTop,rightOffset,f);else{let mid=this.lineAt(rightOffset,QueryType$1.ByPos,oracle,top,offset);from<mid.from&&this.left.forEachLine(from,mid.from-1,oracle,top,offset,f),mid.to>=from&&mid.from<=to&&f(mid),to>mid.to&&this.right.forEachLine(mid.to+1,to,oracle,rightTop,rightOffset,f)}}replace(from,to,nodes){let rightStart=this.left.length+this.break;if(to<rightStart)return this.balanced(this.left.replace(from,to,nodes),this.right);if(from>this.left.length)return this.balanced(this.left,this.right.replace(from-rightStart,to-rightStart,nodes));let result=[];from>0&&this.decomposeLeft(from,result);let left=result.length;for(let node of nodes)result.push(node);if(from>0&&mergeGaps(result,left-1),to<this.length){let right=result.length;this.decomposeRight(to,result),mergeGaps(result,right)}return HeightMap.of(result)}decomposeLeft(to,result){let left=this.left.length;if(to<=left)return this.left.decomposeLeft(to,result);result.push(this.left),this.break&&(left++,to>=left&&result.push(null)),to>left&&this.right.decomposeLeft(to-left,result)}decomposeRight(from,result){let left=this.left.length,right=left+this.break;if(from>=right)return this.right.decomposeRight(from-right,result);from<left&&this.left.decomposeRight(from,result),this.break&&from<right&&result.push(null),result.push(this.right)}balanced(left,right){return left.size>2*right.size||right.size>2*left.size?HeightMap.of(this.break?[left,null,right]:[left,right]):(this.left=left,this.right=right,this.height=left.height+right.height,this.outdated=left.outdated||right.outdated,this.size=left.size+right.size,this.length=left.length+this.break+right.length,this)}updateHeight(oracle){let offset=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,force=arguments.length>2&&void 0!==arguments[2]&&arguments[2],measured=arguments.length>3?arguments[3]:void 0,{left:left,right:right}=this,rightStart=offset+left.length+this.break,rebalance=null;return measured&&measured.from<=offset+left.length&&measured.more?rebalance=left=left.updateHeight(oracle,offset,force,measured):left.updateHeight(oracle,offset,force),measured&&measured.from<=rightStart+right.length&&measured.more?rebalance=right=right.updateHeight(oracle,rightStart,force,measured):right.updateHeight(oracle,rightStart,force),rebalance?this.balanced(left,right):(this.height=this.left.height+this.right.height,this.outdated=!1,this)}toString(){return this.left+(this.break?" ":"-")+this.right}}function mergeGaps(nodes,around){let before,after;null==nodes[around]&&(before=nodes[around-1])instanceof HeightMapGap&&(after=nodes[around+1])instanceof HeightMapGap&&nodes.splice(around-1,3,new HeightMapGap(before.length+1+after.length))}class NodeBuilder{constructor(pos,oracle){this.pos=pos,this.oracle=oracle,this.nodes=[],this.lineStart=-1,this.lineEnd=-1,this.covering=null,this.writtenTo=pos}get isCovered(){return this.covering&&this.nodes[this.nodes.length-1]==this.covering}span(_from,to){if(this.lineStart>-1){let end=Math.min(to,this.lineEnd),last=this.nodes[this.nodes.length-1];last instanceof HeightMapText?last.length+=end-this.pos:(end>this.pos||!this.isCovered)&&this.nodes.push(new HeightMapText(end-this.pos,-1)),this.writtenTo=end,to>end&&(this.nodes.push(null),this.writtenTo++,this.lineStart=-1)}this.pos=to}point(from,to,deco){if(from<to||deco.heightRelevant){let height=deco.widget?deco.widget.estimatedHeight:0,breaks=deco.widget?deco.widget.lineBreaks:0;height<0&&(height=this.oracle.lineHeight);let len=to-from;deco.block?this.addBlock(new HeightMapBlock(len,height,deco)):(len||breaks||height>=5)&&this.addLineDeco(height,breaks,len)}else to>from&&this.span(from,to);this.lineEnd>-1&&this.lineEnd<this.pos&&(this.lineEnd=this.oracle.doc.lineAt(this.pos).to)}enterLine(){if(this.lineStart>-1)return;let{from:from,to:to}=this.oracle.doc.lineAt(this.pos);this.lineStart=from,this.lineEnd=to,this.writtenTo<from&&((this.writtenTo<from-1||null==this.nodes[this.nodes.length-1])&&this.nodes.push(this.blankContent(this.writtenTo,from-1)),this.nodes.push(null)),this.pos>from&&this.nodes.push(new HeightMapText(this.pos-from,-1)),this.writtenTo=this.pos}blankContent(from,to){let gap=new HeightMapGap(to-from);return this.oracle.doc.lineAt(from).to==to&&(gap.flags|=4),gap}ensureLine(){this.enterLine();let last=this.nodes.length?this.nodes[this.nodes.length-1]:null;if(last instanceof HeightMapText)return last;let line=new HeightMapText(0,-1);return this.nodes.push(line),line}addBlock(block){var _a;this.enterLine();let type=null===(_a=block.deco)||void 0===_a?void 0:_a.type;type!=BlockType.WidgetAfter||this.isCovered||this.ensureLine(),this.nodes.push(block),this.writtenTo=this.pos=this.pos+block.length,type!=BlockType.WidgetBefore&&(this.covering=block)}addLineDeco(height,breaks,length){let line=this.ensureLine();line.length+=length,line.collapsed+=length,line.widgetHeight=Math.max(line.widgetHeight,height),line.breaks+=breaks,this.writtenTo=this.pos=this.pos+length}finish(from){let last=0==this.nodes.length?null:this.nodes[this.nodes.length-1];!(this.lineStart>-1)||last instanceof HeightMapText||this.isCovered?(this.writtenTo<this.pos||null==last)&&this.nodes.push(this.blankContent(this.writtenTo,this.pos)):this.nodes.push(new HeightMapText(0,-1));let pos=from;for(let node of this.nodes)node instanceof HeightMapText&&node.updateHeight(this.oracle,pos),pos+=node?node.length:1;return this.nodes}static build(oracle,decorations,from,to){let builder=new NodeBuilder(from,oracle);return RangeSet.spans(decorations,from,to,builder,0),builder.finish(from)}}class DecorationComparator{constructor(){this.changes=[]}compareRange(){}comparePoint(from,to,a,b){(from<to||a&&a.heightRelevant||b&&b.heightRelevant)&&addRange(from,to,this.changes,5)}}function visiblePixelRange(dom,paddingTop){let rect=dom.getBoundingClientRect(),doc=dom.ownerDocument,win=doc.defaultView||window,left=Math.max(0,rect.left),right=Math.min(win.innerWidth,rect.right),top=Math.max(0,rect.top),bottom=Math.min(win.innerHeight,rect.bottom);for(let parent=dom.parentNode;parent&&parent!=doc.body;)if(1==parent.nodeType){let elt=parent,style=window.getComputedStyle(elt);if((elt.scrollHeight>elt.clientHeight||elt.scrollWidth>elt.clientWidth)&&"visible"!=style.overflow){let parentRect=elt.getBoundingClientRect();left=Math.max(left,parentRect.left),right=Math.min(right,parentRect.right),top=Math.max(top,parentRect.top),bottom=parent==dom.parentNode?parentRect.bottom:Math.min(bottom,parentRect.bottom)}parent="absolute"==style.position||"fixed"==style.position?elt.offsetParent:elt.parentNode}else{if(11!=parent.nodeType)break;parent=parent.host}return{left:left-rect.left,right:Math.max(left,right)-rect.left,top:top-(rect.top+paddingTop),bottom:Math.max(top,bottom)-(rect.top+paddingTop)}}function fullPixelRange(dom,paddingTop){let rect=dom.getBoundingClientRect();return{left:0,right:rect.right-rect.left,top:paddingTop,bottom:rect.bottom-(rect.top+paddingTop)}}class LineGap{constructor(from,to,size){this.from=from,this.to=to,this.size=size}static same(a,b){if(a.length!=b.length)return!1;for(let i=0;i<a.length;i++){let gA=a[i],gB=b[i];if(gA.from!=gB.from||gA.to!=gB.to||gA.size!=gB.size)return!1}return!0}draw(wrapping){return Decoration.replace({widget:new LineGapWidget(this.size,wrapping)}).range(this.from,this.to)}}class LineGapWidget extends WidgetType{constructor(size,vertical){super(),this.size=size,this.vertical=vertical}eq(other){return other.size==this.size&&other.vertical==this.vertical}toDOM(){let elt=document.createElement("div");return this.vertical?elt.style.height=this.size+"px":(elt.style.width=this.size+"px",elt.style.height="2px",elt.style.display="inline-block"),elt}get estimatedHeight(){return this.vertical?this.size:-1}}class ViewState{constructor(state){this.state=state,this.pixelViewport={left:0,right:window.innerWidth,top:0,bottom:0},this.inView=!0,this.paddingTop=0,this.paddingBottom=0,this.contentDOMWidth=0,this.contentDOMHeight=0,this.editorHeight=0,this.editorWidth=0,this.scrollTop=0,this.scrolledToBottom=!0,this.scrollAnchorPos=0,this.scrollAnchorHeight=-1,this.scaler=IdScaler,this.scrollTarget=null,this.printing=!1,this.mustMeasureContent=!0,this.defaultTextDirection=Direction.LTR,this.visibleRanges=[],this.mustEnforceCursorAssoc=!1;let guessWrapping=state.facet(contentAttributes).some((v=>"function"!=typeof v&&"cm-lineWrapping"==v.class));this.heightOracle=new HeightOracle(guessWrapping),this.stateDeco=state.facet(decorations).filter((d=>"function"!=typeof d)),this.heightMap=HeightMap.empty().applyChanges(this.stateDeco,Text.empty,this.heightOracle.setDoc(state.doc),[new ChangedRange(0,0,0,state.doc.length)]),this.viewport=this.getViewport(0,null),this.updateViewportLines(),this.updateForViewport(),this.lineGaps=this.ensureLineGaps([]),this.lineGapDeco=Decoration.set(this.lineGaps.map((gap=>gap.draw(!1)))),this.computeVisibleRanges()}updateForViewport(){let viewports=[this.viewport],{main:main}=this.state.selection;for(let i=0;i<=1;i++){let pos=i?main.head:main.anchor;if(!viewports.some((_ref2=>{let{from:from,to:to}=_ref2;return pos>=from&&pos<=to}))){let{from:from,to:to}=this.lineBlockAt(pos);viewports.push(new Viewport(from,to))}}this.viewports=viewports.sort(((a,b)=>a.from-b.from)),this.scaler=this.heightMap.height<=7e6?IdScaler:new BigScaler(this.heightOracle,this.heightMap,this.viewports)}updateViewportLines(){this.viewportLines=[],this.heightMap.forEachLine(this.viewport.from,this.viewport.to,this.heightOracle.setDoc(this.state.doc),0,0,(block=>{this.viewportLines.push(1==this.scaler.scale?block:scaleBlock(block,this.scaler))}))}update(update){let scrollTarget=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;this.state=update.state;let prevDeco=this.stateDeco;this.stateDeco=this.state.facet(decorations).filter((d=>"function"!=typeof d));let contentChanges=update.changedRanges,heightChanges=ChangedRange.extendWithRanges(contentChanges,function(a,b,diff){let comp=new DecorationComparator;return RangeSet.compare(a,b,diff,comp,0),comp.changes}(prevDeco,this.stateDeco,update?update.changes:ChangeSet.empty(this.state.doc.length))),prevHeight=this.heightMap.height,scrollAnchor=this.scrolledToBottom?null:this.lineBlockAtHeight(this.scrollTop);this.heightMap=this.heightMap.applyChanges(this.stateDeco,update.startState.doc,this.heightOracle.setDoc(this.state.doc),heightChanges),this.heightMap.height!=prevHeight&&(update.flags|=2),scrollAnchor?(this.scrollAnchorPos=update.changes.mapPos(scrollAnchor.from,-1),this.scrollAnchorHeight=scrollAnchor.top):(this.scrollAnchorPos=-1,this.scrollAnchorHeight=this.heightMap.height);let viewport=heightChanges.length?this.mapViewport(this.viewport,update.changes):this.viewport;(scrollTarget&&(scrollTarget.range.head<viewport.from||scrollTarget.range.head>viewport.to)||!this.viewportIsAppropriate(viewport))&&(viewport=this.getViewport(0,scrollTarget));let updateLines=!update.changes.empty||2&update.flags||viewport.from!=this.viewport.from||viewport.to!=this.viewport.to;this.viewport=viewport,this.updateForViewport(),updateLines&&this.updateViewportLines(),(this.lineGaps.length||this.viewport.to-this.viewport.from>4e3)&&this.updateLineGaps(this.ensureLineGaps(this.mapLineGaps(this.lineGaps,update.changes))),update.flags|=this.computeVisibleRanges(),scrollTarget&&(this.scrollTarget=scrollTarget),!this.mustEnforceCursorAssoc&&update.selectionSet&&update.view.lineWrapping&&update.state.selection.main.empty&&update.state.selection.main.assoc&&!update.state.facet(nativeSelectionHidden)&&(this.mustEnforceCursorAssoc=!0)}measure(view){let dom=view.contentDOM,style=window.getComputedStyle(dom),oracle=this.heightOracle,whiteSpace=style.whiteSpace;this.defaultTextDirection="rtl"==style.direction?Direction.RTL:Direction.LTR;let refresh=this.heightOracle.mustRefreshForWrapping(whiteSpace),domRect=dom.getBoundingClientRect(),measureContent=refresh||this.mustMeasureContent||this.contentDOMHeight!=domRect.height;this.contentDOMHeight=domRect.height,this.mustMeasureContent=!1;let result=0,bias=0,paddingTop=parseInt(style.paddingTop)||0,paddingBottom=parseInt(style.paddingBottom)||0;this.paddingTop==paddingTop&&this.paddingBottom==paddingBottom||(this.paddingTop=paddingTop,this.paddingBottom=paddingBottom,result|=10),this.editorWidth!=view.scrollDOM.clientWidth&&(oracle.lineWrapping&&(measureContent=!0),this.editorWidth=view.scrollDOM.clientWidth,result|=8),this.scrollTop!=view.scrollDOM.scrollTop&&(this.scrollAnchorHeight=-1,this.scrollTop=view.scrollDOM.scrollTop),this.scrolledToBottom=this.scrollTop>view.scrollDOM.scrollHeight-view.scrollDOM.clientHeight-4;let pixelViewport=(this.printing?fullPixelRange:visiblePixelRange)(dom,this.paddingTop),dTop=pixelViewport.top-this.pixelViewport.top,dBottom=pixelViewport.bottom-this.pixelViewport.bottom;this.pixelViewport=pixelViewport;let inView=this.pixelViewport.bottom>this.pixelViewport.top&&this.pixelViewport.right>this.pixelViewport.left;if(inView!=this.inView&&(this.inView=inView,inView&&(measureContent=!0)),!this.inView&&!this.scrollTarget)return 0;let contentWidth=domRect.width;if(this.contentDOMWidth==contentWidth&&this.editorHeight==view.scrollDOM.clientHeight||(this.contentDOMWidth=domRect.width,this.editorHeight=view.scrollDOM.clientHeight,result|=8),measureContent){let lineHeights=view.docView.measureVisibleLineHeights(this.viewport);if(oracle.mustRefreshForHeights(lineHeights)&&(refresh=!0),refresh||oracle.lineWrapping&&Math.abs(contentWidth-this.contentDOMWidth)>oracle.charWidth){let{lineHeight:lineHeight,charWidth:charWidth,textHeight:textHeight}=view.docView.measureTextSize();refresh=lineHeight>0&&oracle.refresh(whiteSpace,lineHeight,charWidth,textHeight,contentWidth/charWidth,lineHeights),refresh&&(view.docView.minWidth=0,result|=8)}dTop>0&&dBottom>0?bias=Math.max(dTop,dBottom):dTop<0&&dBottom<0&&(bias=Math.min(dTop,dBottom)),oracle.heightChanged=!1;for(let vp of this.viewports){let heights=vp.from==this.viewport.from?lineHeights:view.docView.measureVisibleLineHeights(vp);this.heightMap=(refresh?HeightMap.empty().applyChanges(this.stateDeco,Text.empty,this.heightOracle,[new ChangedRange(0,0,0,view.state.doc.length)]):this.heightMap).updateHeight(oracle,0,refresh,new MeasuredHeights(vp.from,heights))}oracle.heightChanged&&(result|=2)}let viewportChange=!this.viewportIsAppropriate(this.viewport,bias)||this.scrollTarget&&(this.scrollTarget.range.head<this.viewport.from||this.scrollTarget.range.head>this.viewport.to);return viewportChange&&(this.viewport=this.getViewport(bias,this.scrollTarget)),this.updateForViewport(),(2&result||viewportChange)&&this.updateViewportLines(),(this.lineGaps.length||this.viewport.to-this.viewport.from>4e3)&&this.updateLineGaps(this.ensureLineGaps(refresh?[]:this.lineGaps,view)),result|=this.computeVisibleRanges(),this.mustEnforceCursorAssoc&&(this.mustEnforceCursorAssoc=!1,view.docView.enforceCursorAssoc()),result}get visibleTop(){return this.scaler.fromDOM(this.pixelViewport.top)}get visibleBottom(){return this.scaler.fromDOM(this.pixelViewport.bottom)}getViewport(bias,scrollTarget){let marginTop=.5-Math.max(-.5,Math.min(.5,bias/1e3/2)),map=this.heightMap,oracle=this.heightOracle,{visibleTop:visibleTop,visibleBottom:visibleBottom}=this,viewport=new Viewport(map.lineAt(visibleTop-1e3*marginTop,QueryType$1.ByHeight,oracle,0,0).from,map.lineAt(visibleBottom+1e3*(1-marginTop),QueryType$1.ByHeight,oracle,0,0).to);if(scrollTarget){let{head:head}=scrollTarget.range;if(head<viewport.from||head>viewport.to){let topPos,viewHeight=Math.min(this.editorHeight,this.pixelViewport.bottom-this.pixelViewport.top),block=map.lineAt(head,QueryType$1.ByPos,oracle,0,0);topPos="center"==scrollTarget.y?(block.top+block.bottom)/2-viewHeight/2:"start"==scrollTarget.y||"nearest"==scrollTarget.y&&head<viewport.from?block.top:block.bottom-viewHeight,viewport=new Viewport(map.lineAt(topPos-500,QueryType$1.ByHeight,oracle,0,0).from,map.lineAt(topPos+viewHeight+500,QueryType$1.ByHeight,oracle,0,0).to)}}return viewport}mapViewport(viewport,changes){let from=changes.mapPos(viewport.from,-1),to=changes.mapPos(viewport.to,1);return new Viewport(this.heightMap.lineAt(from,QueryType$1.ByPos,this.heightOracle,0,0).from,this.heightMap.lineAt(to,QueryType$1.ByPos,this.heightOracle,0,0).to)}viewportIsAppropriate(_ref3){let{from:from,to:to}=_ref3,bias=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;if(!this.inView)return!0;let{top:top}=this.heightMap.lineAt(from,QueryType$1.ByPos,this.heightOracle,0,0),{bottom:bottom}=this.heightMap.lineAt(to,QueryType$1.ByPos,this.heightOracle,0,0),{visibleTop:visibleTop,visibleBottom:visibleBottom}=this;return(0==from||top<=visibleTop-Math.max(10,Math.min(-bias,250)))&&(to==this.state.doc.length||bottom>=visibleBottom+Math.max(10,Math.min(bias,250)))&&top>visibleTop-2e3&&bottom<visibleBottom+2e3}mapLineGaps(gaps,changes){if(!gaps.length||changes.empty)return gaps;let mapped=[];for(let gap of gaps)changes.touchesRange(gap.from,gap.to)||mapped.push(new LineGap(changes.mapPos(gap.from),changes.mapPos(gap.to),gap.size));return mapped}ensureLineGaps(current,mayMeasure){let wrapping=this.heightOracle.lineWrapping,margin=wrapping?1e4:2e3,halfMargin=margin>>1,doubleMargin=margin<<1;if(this.defaultTextDirection!=Direction.LTR&&!wrapping)return[];let gaps=[],addGap=(from,to,line,structure)=>{if(to-from<halfMargin)return;let sel=this.state.selection.main,avoid=[sel.from];sel.empty||avoid.push(sel.to);for(let pos of avoid)if(pos>from&&pos<to)return addGap(from,pos-10,line,structure),void addGap(pos+10,to,line,structure);let gap=function(array,f){for(let val of array)if(f(val))return val;return}(current,(gap=>gap.from>=line.from&&gap.to<=line.to&&Math.abs(gap.from-from)<halfMargin&&Math.abs(gap.to-to)<halfMargin&&!avoid.some((pos=>gap.from<pos&&gap.to>pos))));if(!gap){if(to<line.to&&mayMeasure&&wrapping&&mayMeasure.visibleRanges.some((r=>r.from<=to&&r.to>=to))){let lineStart=mayMeasure.moveToLineBoundary(EditorSelection.cursor(to),!1,!0).head;lineStart>from&&(to=lineStart)}gap=new LineGap(from,to,this.gapSize(line,from,to,structure))}gaps.push(gap)};for(let line of this.viewportLines){if(line.length<doubleMargin)continue;let structure=lineStructure(line.from,line.to,this.stateDeco);if(structure.total<doubleMargin)continue;let viewFrom,viewTo,target=this.scrollTarget?this.scrollTarget.range.head:null;if(wrapping){let top,bot,marginHeight=margin/this.heightOracle.lineLength*this.heightOracle.lineHeight;if(null!=target){let targetFrac=findFraction(structure,target),spaceFrac=((this.visibleBottom-this.visibleTop)/2+marginHeight)/line.height;top=targetFrac-spaceFrac,bot=targetFrac+spaceFrac}else top=(this.visibleTop-line.top-marginHeight)/line.height,bot=(this.visibleBottom-line.top+marginHeight)/line.height;viewFrom=findPosition(structure,top),viewTo=findPosition(structure,bot)}else{let left,right,totalWidth=structure.total*this.heightOracle.charWidth,marginWidth=margin*this.heightOracle.charWidth;if(null!=target){let targetFrac=findFraction(structure,target),spaceFrac=((this.pixelViewport.right-this.pixelViewport.left)/2+marginWidth)/totalWidth;left=targetFrac-spaceFrac,right=targetFrac+spaceFrac}else left=(this.pixelViewport.left-marginWidth)/totalWidth,right=(this.pixelViewport.right+marginWidth)/totalWidth;viewFrom=findPosition(structure,left),viewTo=findPosition(structure,right)}viewFrom>line.from&&addGap(line.from,viewFrom,line,structure),viewTo<line.to&&addGap(viewTo,line.to,line,structure)}return gaps}gapSize(line,from,to,structure){let fraction=findFraction(structure,to)-findFraction(structure,from);return this.heightOracle.lineWrapping?line.height*fraction:structure.total*this.heightOracle.charWidth*fraction}updateLineGaps(gaps){LineGap.same(gaps,this.lineGaps)||(this.lineGaps=gaps,this.lineGapDeco=Decoration.set(gaps.map((gap=>gap.draw(this.heightOracle.lineWrapping)))))}computeVisibleRanges(){let deco=this.stateDeco;this.lineGaps.length&&(deco=deco.concat(this.lineGapDeco));let ranges=[];RangeSet.spans(deco,this.viewport.from,this.viewport.to,{span(from,to){ranges.push({from:from,to:to})},point(){}},20);let changed=ranges.length!=this.visibleRanges.length||this.visibleRanges.some(((r,i)=>r.from!=ranges[i].from||r.to!=ranges[i].to));return this.visibleRanges=ranges,changed?4:0}lineBlockAt(pos){return pos>=this.viewport.from&&pos<=this.viewport.to&&this.viewportLines.find((b=>b.from<=pos&&b.to>=pos))||scaleBlock(this.heightMap.lineAt(pos,QueryType$1.ByPos,this.heightOracle,0,0),this.scaler)}lineBlockAtHeight(height){return scaleBlock(this.heightMap.lineAt(this.scaler.fromDOM(height),QueryType$1.ByHeight,this.heightOracle,0,0),this.scaler)}elementAtHeight(height){return scaleBlock(this.heightMap.blockAt(this.scaler.fromDOM(height),this.heightOracle,0,0),this.scaler)}get docHeight(){return this.scaler.toDOM(this.heightMap.height)}get contentHeight(){return this.docHeight+this.paddingTop+this.paddingBottom}}class Viewport{constructor(from,to){this.from=from,this.to=to}}function lineStructure(from,to,stateDeco){let ranges=[],pos=from,total=0;return RangeSet.spans(stateDeco,from,to,{span(){},point(from,to){from>pos&&(ranges.push({from:pos,to:from}),total+=from-pos),pos=to}},20),pos<to&&(ranges.push({from:pos,to:to}),total+=to-pos),{total:total,ranges:ranges}}function findPosition(_ref4,ratio){let{total:total,ranges:ranges}=_ref4;if(ratio<=0)return ranges[0].from;if(ratio>=1)return ranges[ranges.length-1].to;let dist=Math.floor(total*ratio);for(let i=0;;i++){let{from:from,to:to}=ranges[i],size=to-from;if(dist<=size)return from+dist;dist-=size}}function findFraction(structure,pos){let counted=0;for(let{from:from,to:to}of structure.ranges){if(pos<=to){counted+=pos-from;break}counted+=to-from}return counted/structure.total}const IdScaler={toDOM:n=>n,fromDOM:n=>n,scale:1};class BigScaler{constructor(oracle,heightMap,viewports){let vpHeight=0,base=0,domBase=0;this.viewports=viewports.map((_ref5=>{let{from:from,to:to}=_ref5,top=heightMap.lineAt(from,QueryType$1.ByPos,oracle,0,0).top,bottom=heightMap.lineAt(to,QueryType$1.ByPos,oracle,0,0).bottom;return vpHeight+=bottom-top,{from:from,to:to,top:top,bottom:bottom,domTop:0,domBottom:0}})),this.scale=(7e6-vpHeight)/(heightMap.height-vpHeight);for(let obj of this.viewports)obj.domTop=domBase+(obj.top-base)*this.scale,domBase=obj.domBottom=obj.domTop+(obj.bottom-obj.top),base=obj.bottom}toDOM(n){for(let i=0,base=0,domBase=0;;i++){let vp=i<this.viewports.length?this.viewports[i]:null;if(!vp||n<vp.top)return domBase+(n-base)*this.scale;if(n<=vp.bottom)return vp.domTop+(n-vp.top);base=vp.bottom,domBase=vp.domBottom}}fromDOM(n){for(let i=0,base=0,domBase=0;;i++){let vp=i<this.viewports.length?this.viewports[i]:null;if(!vp||n<vp.domTop)return base+(n-domBase)/this.scale;if(n<=vp.domBottom)return vp.top+(n-vp.domTop);base=vp.bottom,domBase=vp.domBottom}}}function scaleBlock(block,scaler){if(1==scaler.scale)return block;let bTop=scaler.toDOM(block.top),bBottom=scaler.toDOM(block.bottom);return new BlockInfo(block.from,block.length,bTop,bBottom-bTop,Array.isArray(block._content)?block._content.map((b=>scaleBlock(b,scaler))):block._content)}const theme=Facet.define({combine:strs=>strs.join(" ")}),darkTheme=Facet.define({combine:values=>values.indexOf(!0)>-1}),baseThemeID=StyleModule.newName(),baseLightID=StyleModule.newName(),baseDarkID=StyleModule.newName(),lightDarkIDs={"&light":"."+baseLightID,"&dark":"."+baseDarkID};function buildTheme(main,spec,scopes){return new StyleModule(spec,{finish:sel=>/&/.test(sel)?sel.replace(/&\w*/,(m=>{if("&"==m)return main;if(!scopes||!scopes[m])throw new RangeError("Unsupported selector: ".concat(m));return scopes[m]})):main+" "+sel})}const baseTheme$1$3=buildTheme("."+baseThemeID,{"&":{position:"relative !important",boxSizing:"border-box","&.cm-focused":{outline:"1px dotted #212121"},display:"flex !important",flexDirection:"column"},".cm-scroller":{display:"flex !important",alignItems:"flex-start !important",fontFamily:"monospace",lineHeight:1.4,height:"100%",overflowX:"auto",position:"relative",zIndex:0},".cm-content":{margin:0,flexGrow:2,flexShrink:0,display:"block",whiteSpace:"pre",wordWrap:"normal",boxSizing:"border-box",padding:"4px 0",outline:"none","&[contenteditable=true]":{WebkitUserModify:"read-write-plaintext-only"}},".cm-lineWrapping":{whiteSpace_fallback:"pre-wrap",whiteSpace:"break-spaces",wordBreak:"break-word",overflowWrap:"anywhere",flexShrink:1},"&light .cm-content":{caretColor:"black"},"&dark .cm-content":{caretColor:"white"},".cm-line":{display:"block",padding:"0 2px 0 6px"},".cm-layer":{position:"absolute",left:0,top:0,contain:"size style","& > *":{position:"absolute"}},"&light .cm-selectionBackground":{background:"#d9d9d9"},"&dark .cm-selectionBackground":{background:"#222"},"&light.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground":{background:"#d7d4f0"},"&dark.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground":{background:"#233"},".cm-cursorLayer":{pointerEvents:"none"},"&.cm-focused > .cm-scroller > .cm-cursorLayer":{animation:"steps(1) cm-blink 1.2s infinite"},"@keyframes cm-blink":{"0%":{},"50%":{opacity:0},"100%":{}},"@keyframes cm-blink2":{"0%":{},"50%":{opacity:0},"100%":{}},".cm-cursor, .cm-dropCursor":{borderLeft:"1.2px solid black",marginLeft:"-0.6px",pointerEvents:"none"},".cm-cursor":{display:"none"},"&dark .cm-cursor":{borderLeftColor:"#444"},".cm-dropCursor":{position:"absolute"},"&.cm-focused > .cm-scroller > .cm-cursorLayer .cm-cursor":{display:"block"},"&light .cm-activeLine":{backgroundColor:"#cceeff44"},"&dark .cm-activeLine":{backgroundColor:"#99eeff33"},"&light .cm-specialChar":{color:"red"},"&dark .cm-specialChar":{color:"#f78"},".cm-gutters":{flexShrink:0,display:"flex",height:"100%",boxSizing:"border-box",left:0,zIndex:200},"&light .cm-gutters":{backgroundColor:"#f5f5f5",color:"#6c6c6c",borderRight:"1px solid #ddd"},"&dark .cm-gutters":{backgroundColor:"#333338",color:"#ccc"},".cm-gutter":{display:"flex !important",flexDirection:"column",flexShrink:0,boxSizing:"border-box",minHeight:"100%",overflow:"hidden"},".cm-gutterElement":{boxSizing:"border-box"},".cm-lineNumbers .cm-gutterElement":{padding:"0 3px 0 5px",minWidth:"20px",textAlign:"right",whiteSpace:"nowrap"},"&light .cm-activeLineGutter":{backgroundColor:"#e2f2ff"},"&dark .cm-activeLineGutter":{backgroundColor:"#222227"},".cm-panels":{boxSizing:"border-box",position:"sticky",left:0,right:0},"&light .cm-panels":{backgroundColor:"#f5f5f5",color:"black"},"&light .cm-panels-top":{borderBottom:"1px solid #ddd"},"&light .cm-panels-bottom":{borderTop:"1px solid #ddd"},"&dark .cm-panels":{backgroundColor:"#333338",color:"white"},".cm-tab":{display:"inline-block",overflow:"hidden",verticalAlign:"bottom"},".cm-widgetBuffer":{verticalAlign:"text-top",height:"1em",width:0,display:"inline"},".cm-placeholder":{color:"#888",display:"inline-block",verticalAlign:"top"},".cm-highlightSpace:before":{content:"attr(data-display)",position:"absolute",pointerEvents:"none",color:"#888"},".cm-highlightTab":{backgroundImage:'url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="200" height="20"><path stroke="%23888" stroke-width="1" fill="none" d="M1 10H196L190 5M190 15L196 10M197 4L197 16"/></svg>\')',backgroundSize:"auto 100%",backgroundPosition:"right 90%",backgroundRepeat:"no-repeat"},".cm-trailingSpace":{backgroundColor:"#ff332255"},".cm-button":{verticalAlign:"middle",color:"inherit",fontSize:"70%",padding:".2em 1em",borderRadius:"1px"},"&light .cm-button":{backgroundImage:"linear-gradient(#eff1f5, #d9d9df)",border:"1px solid #888","&:active":{backgroundImage:"linear-gradient(#b4b4b4, #d0d3d6)"}},"&dark .cm-button":{backgroundImage:"linear-gradient(#393939, #111)",border:"1px solid #888","&:active":{backgroundImage:"linear-gradient(#111, #333)"}},".cm-textfield":{verticalAlign:"middle",color:"inherit",fontSize:"70%",border:"1px solid silver",padding:".2em .5em"},"&light .cm-textfield":{backgroundColor:"white"},"&dark .cm-textfield":{border:"1px solid #555",backgroundColor:"inherit"}},lightDarkIDs);class DOMChange{constructor(view,start,end,typeOver){this.typeOver=typeOver,this.bounds=null,this.text="";let{impreciseHead:iHead,impreciseAnchor:iAnchor}=view.docView;if(view.state.readOnly&&start>-1)this.newSel=null;else if(start>-1&&(this.bounds=view.docView.domBoundsAround(start,end,0))){let selPoints=iHead||iAnchor?[]:function(view){let result=[];if(view.root.activeElement!=view.contentDOM)return result;let{anchorNode:anchorNode,anchorOffset:anchorOffset,focusNode:focusNode,focusOffset:focusOffset}=view.observer.selectionRange;anchorNode&&(result.push(new DOMPoint(anchorNode,anchorOffset)),focusNode==anchorNode&&focusOffset==anchorOffset||result.push(new DOMPoint(focusNode,focusOffset)));return result}(view),reader=new DOMReader(selPoints,view.state);reader.readRange(this.bounds.startDOM,this.bounds.endDOM),this.text=reader.text,this.newSel=function(points,base){if(0==points.length)return null;let anchor=points[0].pos,head=2==points.length?points[1].pos:anchor;return anchor>-1&&head>-1?EditorSelection.single(anchor+base,head+base):null}(selPoints,this.bounds.from)}else{let domSel=view.observer.selectionRange,head=iHead&&iHead.node==domSel.focusNode&&iHead.offset==domSel.focusOffset||!contains(view.contentDOM,domSel.focusNode)?view.state.selection.main.head:view.docView.posFromDOM(domSel.focusNode,domSel.focusOffset),anchor=iAnchor&&iAnchor.node==domSel.anchorNode&&iAnchor.offset==domSel.anchorOffset||!contains(view.contentDOM,domSel.anchorNode)?view.state.selection.main.anchor:view.docView.posFromDOM(domSel.anchorNode,domSel.anchorOffset);this.newSel=EditorSelection.single(anchor,head)}}}function applyDOMChange(view,domChange){let change,{newSel:newSel}=domChange,sel=view.state.selection.main,lastKey=view.inputState.lastKeyTime>Date.now()-100?view.inputState.lastKeyCode:-1;if(domChange.bounds){let{from:from,to:to}=domChange.bounds,preferredPos=sel.from,preferredSide=null;(8===lastKey||browser.android&&domChange.text.length<to-from)&&(preferredPos=sel.to,preferredSide="end");let diff=function(a,b,preferredPos,preferredSide){let minLen=Math.min(a.length,b.length),from=0;for(;from<minLen&&a.charCodeAt(from)==b.charCodeAt(from);)from++;if(from==minLen&&a.length==b.length)return null;let toA=a.length,toB=b.length;for(;toA>0&&toB>0&&a.charCodeAt(toA-1)==b.charCodeAt(toB-1);)toA--,toB--;if("end"==preferredSide){preferredPos-=toA+Math.max(0,from-Math.min(toA,toB))-from}if(toA<from&&a.length<b.length){from-=preferredPos<=from&&preferredPos>=toA?from-preferredPos:0,toB=from+(toB-toA),toA=from}else if(toB<from){from-=preferredPos<=from&&preferredPos>=toB?from-preferredPos:0,toA=from+(toA-toB),toB=from}return{from:from,toA:toA,toB:toB}}(view.state.doc.sliceString(from,to,"￿"),domChange.text,preferredPos-from,preferredSide);diff&&(browser.chrome&&13==lastKey&&diff.toB==diff.from+2&&"￿￿"==domChange.text.slice(diff.from,diff.toB)&&diff.toB--,change={from:from+diff.from,to:from+diff.toA,insert:Text.of(domChange.text.slice(diff.from,diff.toB).split("￿"))})}else newSel&&(!view.hasFocus&&view.state.facet(editable)||newSel.main.eq(sel))&&(newSel=null);if(!change&&!newSel)return!1;if(!change&&domChange.typeOver&&!sel.empty&&newSel&&newSel.main.empty?change={from:sel.from,to:sel.to,insert:view.state.doc.slice(sel.from,sel.to)}:change&&change.from>=sel.from&&change.to<=sel.to&&(change.from!=sel.from||change.to!=sel.to)&&sel.to-sel.from-(change.to-change.from)<=4?change={from:sel.from,to:sel.to,insert:view.state.doc.slice(sel.from,change.from).append(change.insert).append(view.state.doc.slice(change.to,sel.to))}:(browser.mac||browser.android)&&change&&change.from==change.to&&change.from==sel.head-1&&/^\. ?$/.test(change.insert.toString())&&"off"==view.contentDOM.getAttribute("autocorrect")?(newSel&&2==change.insert.length&&(newSel=EditorSelection.single(newSel.main.anchor-1,newSel.main.head-1)),change={from:sel.from,to:sel.to,insert:Text.of([" "])}):browser.chrome&&change&&change.from==change.to&&change.from==sel.head&&"\n "==change.insert.toString()&&view.lineWrapping&&(newSel&&(newSel=EditorSelection.single(newSel.main.anchor-1,newSel.main.head-1)),change={from:sel.from,to:sel.to,insert:Text.of([" "])}),change){let startState=view.state;if(browser.ios&&view.inputState.flushIOSKey(view))return!0;if(browser.android&&(change.from==sel.from&&change.to==sel.to&&1==change.insert.length&&2==change.insert.lines&&dispatchKey(view.contentDOM,"Enter",13)||(change.from==sel.from-1&&change.to==sel.to&&0==change.insert.length||8==lastKey&&change.insert.length<change.to-change.from)&&dispatchKey(view.contentDOM,"Backspace",8)||change.from==sel.from&&change.to==sel.to+1&&0==change.insert.length&&dispatchKey(view.contentDOM,"Delete",46)))return!0;let tr,text=change.insert.toString();if(view.state.facet(inputHandler$1).some((h=>h(view,change.from,change.to,text))))return!0;if(view.inputState.composing>=0&&view.inputState.composing++,change.from>=sel.from&&change.to<=sel.to&&change.to-change.from>=(sel.to-sel.from)/3&&(!newSel||newSel.main.empty&&newSel.main.from==change.from+change.insert.length)&&view.inputState.composing<0){let before=sel.from<change.from?startState.sliceDoc(sel.from,change.from):"",after=sel.to>change.to?startState.sliceDoc(change.to,sel.to):"";tr=startState.replaceSelection(view.state.toText(before+change.insert.sliceString(0,void 0,view.state.lineBreak)+after))}else{let changes=startState.changes(change),mainSel=newSel&&newSel.main.to<=changes.newLength?newSel.main:void 0;if(startState.selection.ranges.length>1&&view.inputState.composing>=0&&change.to<=sel.to&&change.to>=sel.to-10){let replaced=view.state.sliceDoc(change.from,change.to),compositionRange=compositionSurroundingNode(view)||view.state.doc.lineAt(sel.head),offset=sel.to-change.to,size=sel.to-sel.from;tr=startState.changeByRange((range=>{if(range.from==sel.from&&range.to==sel.to)return{changes:changes,range:mainSel||range.map(changes)};let to=range.to-offset,from=to-replaced.length;if(range.to-range.from!=size||view.state.sliceDoc(from,to)!=replaced||compositionRange&&range.to>=compositionRange.from&&range.from<=compositionRange.to)return{range:range};let rangeChanges=startState.changes({from:from,to:to,insert:change.insert}),selOff=range.to-sel.to;return{changes:rangeChanges,range:mainSel?EditorSelection.range(Math.max(0,mainSel.anchor+selOff),Math.max(0,mainSel.head+selOff)):range.map(rangeChanges)}}))}else tr={changes:changes,selection:mainSel&&startState.selection.replaceRange(mainSel)}}let userEvent="input.type";return(view.composing||view.inputState.compositionPendingChange&&view.inputState.compositionEndedAt>Date.now()-50)&&(view.inputState.compositionPendingChange=!1,userEvent+=".compose",view.inputState.compositionFirstChange&&(userEvent+=".start",view.inputState.compositionFirstChange=!1)),view.dispatch(tr,{scrollIntoView:!0,userEvent:userEvent}),!0}if(newSel&&!newSel.main.eq(sel)){let scrollIntoView=!1,userEvent="select";return view.inputState.lastSelectionTime>Date.now()-50&&("select"==view.inputState.lastSelectionOrigin&&(scrollIntoView=!0),userEvent=view.inputState.lastSelectionOrigin),view.dispatch({selection:newSel,scrollIntoView:scrollIntoView,userEvent:userEvent}),!0}return!1}const observeOptions={childList:!0,characterData:!0,subtree:!0,attributes:!0,characterDataOldValue:!0},useCharData=browser.ie&&browser.ie_version<=11;class DOMObserver{constructor(view){this.view=view,this.active=!1,this.selectionRange=new DOMSelectionState,this.selectionChanged=!1,this.delayedFlush=-1,this.resizeTimeout=-1,this.queue=[],this.delayedAndroidKey=null,this.flushingAndroidKey=-1,this.lastChange=0,this.scrollTargets=[],this.intersection=null,this.resizeScroll=null,this.resizeContent=null,this.intersecting=!1,this.gapIntersection=null,this.gaps=[],this.parentCheck=-1,this.dom=view.contentDOM,this.observer=new MutationObserver((mutations=>{for(let mut of mutations)this.queue.push(mut);(browser.ie&&browser.ie_version<=11||browser.ios&&view.composing)&&mutations.some((m=>"childList"==m.type&&m.removedNodes.length||"characterData"==m.type&&m.oldValue.length>m.target.nodeValue.length))?this.flushSoon():this.flush()})),useCharData&&(this.onCharData=event=>{this.queue.push({target:event.target,type:"characterData",oldValue:event.prevValue}),this.flushSoon()}),this.onSelectionChange=this.onSelectionChange.bind(this),this.onResize=this.onResize.bind(this),this.onPrint=this.onPrint.bind(this),this.onScroll=this.onScroll.bind(this),"function"==typeof ResizeObserver&&(this.resizeScroll=new ResizeObserver((()=>{var _a;(null===(_a=this.view.docView)||void 0===_a?void 0:_a.lastUpdate)<Date.now()-75&&this.onResize()})),this.resizeScroll.observe(view.scrollDOM),this.resizeContent=new ResizeObserver((()=>this.view.requestMeasure())),this.resizeContent.observe(view.contentDOM)),this.addWindowListeners(this.win=view.win),this.start(),"function"==typeof IntersectionObserver&&(this.intersection=new IntersectionObserver((entries=>{this.parentCheck<0&&(this.parentCheck=setTimeout(this.listenForScroll.bind(this),1e3)),entries.length>0&&entries[entries.length-1].intersectionRatio>0!=this.intersecting&&(this.intersecting=!this.intersecting,this.intersecting!=this.view.inView&&this.onScrollChanged(document.createEvent("Event")))}),{threshold:[0,.001]}),this.intersection.observe(this.dom),this.gapIntersection=new IntersectionObserver((entries=>{entries.length>0&&entries[entries.length-1].intersectionRatio>0&&this.onScrollChanged(document.createEvent("Event"))}),{})),this.listenForScroll(),this.readSelectionRange()}onScrollChanged(e){this.view.inputState.runScrollHandlers(this.view,e),this.intersecting&&this.view.measure()}onScroll(e){this.intersecting&&this.flush(!1),this.onScrollChanged(e)}onResize(){this.resizeTimeout<0&&(this.resizeTimeout=setTimeout((()=>{this.resizeTimeout=-1,this.view.requestMeasure()}),50))}onPrint(){this.view.viewState.printing=!0,this.view.measure(),setTimeout((()=>{this.view.viewState.printing=!1,this.view.requestMeasure()}),500)}updateGaps(gaps){if(this.gapIntersection&&(gaps.length!=this.gaps.length||this.gaps.some(((g,i)=>g!=gaps[i])))){this.gapIntersection.disconnect();for(let gap of gaps)this.gapIntersection.observe(gap);this.gaps=gaps}}onSelectionChange(event){let wasChanged=this.selectionChanged;if(!this.readSelectionRange()||this.delayedAndroidKey)return;let{view:view}=this,sel=this.selectionRange;if(view.state.facet(editable)?view.root.activeElement!=this.dom:!hasSelection(view.dom,sel))return;let context=sel.anchorNode&&view.docView.nearest(sel.anchorNode);context&&context.ignoreEvent(event)?wasChanged||(this.selectionChanged=!1):(browser.ie&&browser.ie_version<=11||browser.android&&browser.chrome)&&!view.state.selection.main.empty&&sel.focusNode&&isEquivalentPosition(sel.focusNode,sel.focusOffset,sel.anchorNode,sel.anchorOffset)?this.flushSoon():this.flush(!1)}readSelectionRange(){let{view:view}=this,range=browser.safari&&11==view.root.nodeType&&function(doc){let elt=doc.activeElement;for(;elt&&elt.shadowRoot;)elt=elt.shadowRoot.activeElement;return elt}(this.dom.ownerDocument)==this.dom&&function(view){let found=null;function read(event){event.preventDefault(),event.stopImmediatePropagation(),found=event.getTargetRanges()[0]}if(view.contentDOM.addEventListener("beforeinput",read,!0),view.dom.ownerDocument.execCommand("indent"),view.contentDOM.removeEventListener("beforeinput",read,!0),!found)return null;let anchorNode=found.startContainer,anchorOffset=found.startOffset,focusNode=found.endContainer,focusOffset=found.endOffset,curAnchor=view.docView.domAtPos(view.state.selection.main.anchor);isEquivalentPosition(curAnchor.node,curAnchor.offset,focusNode,focusOffset)&&([anchorNode,anchorOffset,focusNode,focusOffset]=[focusNode,focusOffset,anchorNode,anchorOffset]);return{anchorNode:anchorNode,anchorOffset:anchorOffset,focusNode:focusNode,focusOffset:focusOffset}}(this.view)||getSelection(view.root);if(!range||this.selectionRange.eq(range))return!1;let local=hasSelection(this.dom,range);return local&&!this.selectionChanged&&view.inputState.lastFocusTime>Date.now()-200&&view.inputState.lastTouchTime<Date.now()-300&&function(doc,selection){let node=selection.focusNode,offset=selection.focusOffset;if(!node||selection.anchorNode!=node||selection.anchorOffset!=offset)return!1;for(offset=Math.min(offset,maxOffset(node));;)if(offset){if(1!=node.nodeType)return!1;let prev=node.childNodes[offset-1];"false"==prev.contentEditable?offset--:(node=prev,offset=maxOffset(node))}else{if(node==doc)return!0;offset=domIndex(node),node=node.parentNode}}(this.dom,range)?(this.view.inputState.lastFocusTime=0,view.docView.updateSelection(),!1):(this.selectionRange.setRange(range),local&&(this.selectionChanged=!0),!0)}setSelectionRange(anchor,head){this.selectionRange.set(anchor.node,anchor.offset,head.node,head.offset),this.selectionChanged=!1}clearSelectionRange(){this.selectionRange.set(null,0,null,0)}listenForScroll(){this.parentCheck=-1;let i=0,changed=null;for(let dom=this.dom;dom;)if(1==dom.nodeType)!changed&&i<this.scrollTargets.length&&this.scrollTargets[i]==dom?i++:changed||(changed=this.scrollTargets.slice(0,i)),changed&&changed.push(dom),dom=dom.assignedSlot||dom.parentNode;else{if(11!=dom.nodeType)break;dom=dom.host}if(i<this.scrollTargets.length&&!changed&&(changed=this.scrollTargets.slice(0,i)),changed){for(let dom of this.scrollTargets)dom.removeEventListener("scroll",this.onScroll);for(let dom of this.scrollTargets=changed)dom.addEventListener("scroll",this.onScroll)}}ignore(f){if(!this.active)return f();try{return this.stop(),f()}finally{this.start(),this.clear()}}start(){this.active||(this.observer.observe(this.dom,observeOptions),useCharData&&this.dom.addEventListener("DOMCharacterDataModified",this.onCharData),this.active=!0)}stop(){this.active&&(this.active=!1,this.observer.disconnect(),useCharData&&this.dom.removeEventListener("DOMCharacterDataModified",this.onCharData))}clear(){this.processRecords(),this.queue.length=0,this.selectionChanged=!1}delayAndroidKey(key,keyCode){var _a;if(!this.delayedAndroidKey){let flush=()=>{let key=this.delayedAndroidKey;if(key){this.clearDelayedAndroidKey(),this.view.inputState.lastKeyCode=key.keyCode,this.view.inputState.lastKeyTime=Date.now(),!this.flush()&&key.force&&dispatchKey(this.dom,key.key,key.keyCode)}};this.flushingAndroidKey=this.view.win.requestAnimationFrame(flush)}this.delayedAndroidKey&&"Enter"!=key||(this.delayedAndroidKey={key:key,keyCode:keyCode,force:this.lastChange<Date.now()-50||!!(null===(_a=this.delayedAndroidKey)||void 0===_a?void 0:_a.force)})}clearDelayedAndroidKey(){this.win.cancelAnimationFrame(this.flushingAndroidKey),this.delayedAndroidKey=null,this.flushingAndroidKey=-1}flushSoon(){this.delayedFlush<0&&(this.delayedFlush=this.view.win.requestAnimationFrame((()=>{this.delayedFlush=-1,this.flush()})))}forceFlush(){this.delayedFlush>=0&&(this.view.win.cancelAnimationFrame(this.delayedFlush),this.delayedFlush=-1),this.flush()}pendingRecords(){for(let mut of this.observer.takeRecords())this.queue.push(mut);return this.queue}processRecords(){let records=this.pendingRecords();records.length&&(this.queue=[]);let from=-1,to=-1,typeOver=!1;for(let record of records){let range=this.readMutation(record);range&&(range.typeOver&&(typeOver=!0),-1==from?({from:from,to:to}=range):(from=Math.min(range.from,from),to=Math.max(range.to,to)))}return{from:from,to:to,typeOver:typeOver}}readChange(){let{from:from,to:to,typeOver:typeOver}=this.processRecords(),newSel=this.selectionChanged&&hasSelection(this.dom,this.selectionRange);return from<0&&!newSel?null:(from>-1&&(this.lastChange=Date.now()),this.view.inputState.lastFocusTime=0,this.selectionChanged=!1,new DOMChange(this.view,from,to,typeOver))}flush(){let readSelection=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];if(this.delayedFlush>=0||this.delayedAndroidKey)return!1;readSelection&&this.readSelectionRange();let domChange=this.readChange();if(!domChange)return!1;let startState=this.view.state,handled=applyDOMChange(this.view,domChange);return this.view.state==startState&&this.view.update([]),handled}readMutation(rec){let cView=this.view.docView.nearest(rec.target);if(!cView||cView.ignoreMutation(rec))return null;if(cView.markDirty("attributes"==rec.type),"attributes"==rec.type&&(cView.dirty|=4),"childList"==rec.type){let childBefore=findChild(cView,rec.previousSibling||rec.target.previousSibling,-1),childAfter=findChild(cView,rec.nextSibling||rec.target.nextSibling,1);return{from:childBefore?cView.posAfter(childBefore):cView.posAtStart,to:childAfter?cView.posBefore(childAfter):cView.posAtEnd,typeOver:!1}}return"characterData"==rec.type?{from:cView.posAtStart,to:cView.posAtEnd,typeOver:rec.target.nodeValue==rec.oldValue}:null}setWindow(win){win!=this.win&&(this.removeWindowListeners(this.win),this.win=win,this.addWindowListeners(this.win))}addWindowListeners(win){win.addEventListener("resize",this.onResize),win.addEventListener("beforeprint",this.onPrint),win.addEventListener("scroll",this.onScroll),win.document.addEventListener("selectionchange",this.onSelectionChange)}removeWindowListeners(win){win.removeEventListener("scroll",this.onScroll),win.removeEventListener("resize",this.onResize),win.removeEventListener("beforeprint",this.onPrint),win.document.removeEventListener("selectionchange",this.onSelectionChange)}destroy(){var _a,_b,_c,_d;this.stop(),null===(_a=this.intersection)||void 0===_a||_a.disconnect(),null===(_b=this.gapIntersection)||void 0===_b||_b.disconnect(),null===(_c=this.resizeScroll)||void 0===_c||_c.disconnect(),null===(_d=this.resizeContent)||void 0===_d||_d.disconnect();for(let dom of this.scrollTargets)dom.removeEventListener("scroll",this.onScroll);this.removeWindowListeners(this.win),clearTimeout(this.parentCheck),clearTimeout(this.resizeTimeout),this.win.cancelAnimationFrame(this.delayedFlush),this.win.cancelAnimationFrame(this.flushingAndroidKey)}}function findChild(cView,dom,dir){for(;dom;){let curView=ContentView.get(dom);if(curView&&curView.parent==cView)return curView;let parent=dom.parentNode;dom=parent!=cView.dom?parent:dir>0?dom.nextSibling:dom.previousSibling}return null}class EditorView{constructor(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.plugins=[],this.pluginMap=new Map,this.editorAttrs={},this.contentAttrs={},this.bidiCache=[],this.destroyed=!1,this.updateState=2,this.measureScheduled=-1,this.measureRequests=[],this.contentDOM=document.createElement("div"),this.scrollDOM=document.createElement("div"),this.scrollDOM.tabIndex=-1,this.scrollDOM.className="cm-scroller",this.scrollDOM.appendChild(this.contentDOM),this.announceDOM=document.createElement("div"),this.announceDOM.style.cssText="position: fixed; top: -10000px",this.announceDOM.setAttribute("aria-live","polite"),this.dom=document.createElement("div"),this.dom.appendChild(this.announceDOM),this.dom.appendChild(this.scrollDOM),this._dispatch=config.dispatch||(tr=>this.update([tr])),this.dispatch=this.dispatch.bind(this),this._root=config.root||function(node){for(;node;){if(node&&(9==node.nodeType||11==node.nodeType&&node.host))return node;node=node.assignedSlot||node.parentNode}return null}(config.parent)||document,this.viewState=new ViewState(config.state||EditorState.create(config)),this.plugins=this.state.facet(viewPlugin).map((spec=>new PluginInstance(spec)));for(let plugin of this.plugins)plugin.update(this);this.observer=new DOMObserver(this),this.inputState=new InputState(this),this.inputState.ensureHandlers(this,this.plugins),this.docView=new DocView(this),this.mountStyles(),this.updateAttrs(),this.updateState=0,this.requestMeasure(),config.parent&&config.parent.appendChild(this.dom)}get state(){return this.viewState.state}get viewport(){return this.viewState.viewport}get visibleRanges(){return this.viewState.visibleRanges}get inView(){return this.viewState.inView}get composing(){return this.inputState.composing>0}get compositionStarted(){return this.inputState.composing>=0}get root(){return this._root}get win(){return this.dom.ownerDocument.defaultView||window}dispatch(){let tr=1==arguments.length&&(arguments.length<=0?void 0:arguments[0])instanceof Transaction?arguments.length<=0?void 0:arguments[0]:this.state.update(...arguments);this._dispatch(tr,this)}update(transactions){if(0!=this.updateState)throw new Error("Calls to EditorView.update are not allowed while an update is in progress");let update,redrawn=!1,attrsChanged=!1,state=this.state;for(let tr of transactions){if(tr.startState!=state)throw new RangeError("Trying to update state with a transaction that doesn't start from the previous state.");state=tr.state}if(this.destroyed)return void(this.viewState.state=state);let focus=this.hasFocus,focusFlag=0,dispatchFocus=null;transactions.some((tr=>tr.annotation(isFocusChange)))?(this.inputState.notifiedFocused=focus,focusFlag=1):focus!=this.inputState.notifiedFocused&&(this.inputState.notifiedFocused=focus,dispatchFocus=focusChangeTransaction(state,focus),dispatchFocus||(focusFlag=1));let pendingKey=this.observer.delayedAndroidKey,domChange=null;if(pendingKey?(this.observer.clearDelayedAndroidKey(),domChange=this.observer.readChange(),(domChange&&!this.state.doc.eq(state.doc)||!this.state.selection.eq(state.selection))&&(domChange=null)):this.observer.clear(),state.facet(EditorState.phrases)!=this.state.facet(EditorState.phrases))return this.setState(state);update=ViewUpdate.create(this,state,transactions),update.flags|=focusFlag;let scrollTarget=this.viewState.scrollTarget;try{this.updateState=2;for(let tr of transactions){if(scrollTarget&&(scrollTarget=scrollTarget.map(tr.changes)),tr.scrollIntoView){let{main:main}=tr.state.selection;scrollTarget=new ScrollTarget(main.empty?main:EditorSelection.cursor(main.head,main.head>main.anchor?-1:1))}for(let e of tr.effects)e.is(scrollIntoView$1)&&(scrollTarget=e.value)}this.viewState.update(update,scrollTarget),this.bidiCache=CachedOrder.update(this.bidiCache,update.changes),update.empty||(this.updatePlugins(update),this.inputState.update(update)),redrawn=this.docView.update(update),this.state.facet(styleModule)!=this.styleModules&&this.mountStyles(),attrsChanged=this.updateAttrs(),this.showAnnouncements(transactions),this.docView.updateSelection(redrawn,transactions.some((tr=>tr.isUserEvent("select.pointer"))))}finally{this.updateState=0}if(update.startState.facet(theme)!=update.state.facet(theme)&&(this.viewState.mustMeasureContent=!0),(redrawn||attrsChanged||scrollTarget||this.viewState.mustEnforceCursorAssoc||this.viewState.mustMeasureContent)&&this.requestMeasure(),!update.empty)for(let listener of this.state.facet(updateListener))listener(update);(dispatchFocus||domChange)&&Promise.resolve().then((()=>{dispatchFocus&&this.state==dispatchFocus.startState&&this.dispatch(dispatchFocus),domChange&&!applyDOMChange(this,domChange)&&pendingKey.force&&dispatchKey(this.contentDOM,pendingKey.key,pendingKey.keyCode)}))}setState(newState){if(0!=this.updateState)throw new Error("Calls to EditorView.setState are not allowed while an update is in progress");if(this.destroyed)return void(this.viewState.state=newState);this.updateState=2;let hadFocus=this.hasFocus;try{for(let plugin of this.plugins)plugin.destroy(this);this.viewState=new ViewState(newState),this.plugins=newState.facet(viewPlugin).map((spec=>new PluginInstance(spec))),this.pluginMap.clear();for(let plugin of this.plugins)plugin.update(this);this.docView=new DocView(this),this.inputState.ensureHandlers(this,this.plugins),this.mountStyles(),this.updateAttrs(),this.bidiCache=[]}finally{this.updateState=0}hadFocus&&this.focus(),this.requestMeasure()}updatePlugins(update){let prevSpecs=update.startState.facet(viewPlugin),specs=update.state.facet(viewPlugin);if(prevSpecs!=specs){let newPlugins=[];for(let spec of specs){let found=prevSpecs.indexOf(spec);if(found<0)newPlugins.push(new PluginInstance(spec));else{let plugin=this.plugins[found];plugin.mustUpdate=update,newPlugins.push(plugin)}}for(let plugin of this.plugins)plugin.mustUpdate!=update&&plugin.destroy(this);this.plugins=newPlugins,this.pluginMap.clear(),this.inputState.ensureHandlers(this,this.plugins)}else for(let p of this.plugins)p.mustUpdate=update;for(let i=0;i<this.plugins.length;i++)this.plugins[i].update(this)}measure(){let flush=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];if(this.destroyed)return;this.measureScheduled>-1&&this.win.cancelAnimationFrame(this.measureScheduled),this.measureScheduled=0,flush&&this.observer.forceFlush();let updated=null,sDOM=this.scrollDOM,{scrollTop:scrollTop}=sDOM,{scrollAnchorPos:scrollAnchorPos,scrollAnchorHeight:scrollAnchorHeight}=this.viewState;if(this.viewState.scrollAnchorHeight=-1,scrollAnchorHeight<0||scrollTop!=this.viewState.scrollTop)if(scrollTop>sDOM.scrollHeight-sDOM.clientHeight-4)scrollAnchorPos=-1,scrollAnchorHeight=this.viewState.heightMap.height;else{let block=this.viewState.lineBlockAtHeight(scrollTop);scrollAnchorPos=block.from,scrollAnchorHeight=block.top}try{for(let i=0;;i++){this.updateState=1;let oldViewport=this.viewport,changed=this.viewState.measure(this);if(!changed&&!this.measureRequests.length&&null==this.viewState.scrollTarget)break;if(i>5){console.warn(this.measureRequests.length?"Measure loop restarted more than 5 times":"Viewport failed to stabilize");break}let measuring=[];4&changed||([this.measureRequests,measuring]=[measuring,this.measureRequests]);let measured=measuring.map((m=>{try{return m.read(this)}catch(e){return logException(this.state,e),BadMeasure}})),update=ViewUpdate.create(this,this.state,[]),redrawn=!1,scrolled=!1;update.flags|=changed,updated?updated.flags|=changed:updated=update,this.updateState=2,update.empty||(this.updatePlugins(update),this.inputState.update(update),this.updateAttrs(),redrawn=this.docView.update(update));for(let i=0;i<measuring.length;i++)if(measured[i]!=BadMeasure)try{let m=measuring[i];m.write&&m.write(measured[i],this)}catch(e){logException(this.state,e)}if(this.viewState.editorHeight)if(this.viewState.scrollTarget)this.docView.scrollIntoView(this.viewState.scrollTarget),this.viewState.scrollTarget=null,scrolled=!0;else if(scrollAnchorHeight>-1){let diff=(scrollAnchorPos<0?this.viewState.heightMap.height:this.viewState.lineBlockAt(scrollAnchorPos).top)-scrollAnchorHeight;(diff>1||diff<-1)&&(sDOM.scrollTop=scrollTop+diff,scrolled=!0)}if(redrawn&&this.docView.updateSelection(!0),this.viewport.from==oldViewport.from&&this.viewport.to==oldViewport.to&&!scrolled&&0==this.measureRequests.length)break;scrollAnchorHeight=-1}}finally{this.updateState=0,this.measureScheduled=-1}if(updated&&!updated.empty)for(let listener of this.state.facet(updateListener))listener(updated)}get themeClasses(){return baseThemeID+" "+(this.state.facet(darkTheme)?baseDarkID:baseLightID)+" "+this.state.facet(theme)}updateAttrs(){let editorAttrs=attrsFromFacet(this,editorAttributes,{class:"cm-editor"+(this.hasFocus?" cm-focused ":" ")+this.themeClasses}),contentAttrs={spellcheck:"false",autocorrect:"off",autocapitalize:"off",translate:"no",contenteditable:this.state.facet(editable)?"true":"false",class:"cm-content",style:"".concat(browser.tabSize,": ").concat(this.state.tabSize),role:"textbox","aria-multiline":"true"};this.state.readOnly&&(contentAttrs["aria-readonly"]="true"),attrsFromFacet(this,contentAttributes,contentAttrs);let changed=this.observer.ignore((()=>{let changedContent=updateAttrs(this.contentDOM,this.contentAttrs,contentAttrs),changedEditor=updateAttrs(this.dom,this.editorAttrs,editorAttrs);return changedContent||changedEditor}));return this.editorAttrs=editorAttrs,this.contentAttrs=contentAttrs,changed}showAnnouncements(trs){let first=!0;for(let tr of trs)for(let effect of tr.effects)if(effect.is(EditorView.announce)){first&&(this.announceDOM.textContent=""),first=!1,this.announceDOM.appendChild(document.createElement("div")).textContent=effect.value}}mountStyles(){this.styleModules=this.state.facet(styleModule),StyleModule.mount(this.root,this.styleModules.concat(baseTheme$1$3).reverse())}readMeasured(){if(2==this.updateState)throw new Error("Reading the editor layout isn't allowed during an update");0==this.updateState&&this.measureScheduled>-1&&this.measure(!1)}requestMeasure(request){if(this.measureScheduled<0&&(this.measureScheduled=this.win.requestAnimationFrame((()=>this.measure()))),request){if(this.measureRequests.indexOf(request)>-1)return;if(null!=request.key)for(let i=0;i<this.measureRequests.length;i++)if(this.measureRequests[i].key===request.key)return void(this.measureRequests[i]=request);this.measureRequests.push(request)}}plugin(plugin){let known=this.pluginMap.get(plugin);return(void 0===known||known&&known.spec!=plugin)&&this.pluginMap.set(plugin,known=this.plugins.find((p=>p.spec==plugin))||null),known&&known.update(this).value}get documentTop(){return this.contentDOM.getBoundingClientRect().top+this.viewState.paddingTop}get documentPadding(){return{top:this.viewState.paddingTop,bottom:this.viewState.paddingBottom}}elementAtHeight(height){return this.readMeasured(),this.viewState.elementAtHeight(height)}lineBlockAtHeight(height){return this.readMeasured(),this.viewState.lineBlockAtHeight(height)}get viewportLineBlocks(){return this.viewState.viewportLines}lineBlockAt(pos){return this.viewState.lineBlockAt(pos)}get contentHeight(){return this.viewState.contentHeight}moveByChar(start,forward,by){return skipAtoms(this,start,moveByChar(this,start,forward,by))}moveByGroup(start,forward){return skipAtoms(this,start,moveByChar(this,start,forward,(initial=>function(view,pos,start){let categorize=view.state.charCategorizer(pos),cat=categorize(start);return next=>{let nextCat=categorize(next);return cat==CharCategory.Space&&(cat=nextCat),cat==nextCat}}(this,start.head,initial))))}moveToLineBoundary(start,forward){return function(view,start,forward,includeWrap){let line=blockAt(view,start.head),coords=includeWrap&&line.type==BlockType.Text&&(view.lineWrapping||line.widgetLineBreaks)?view.coordsAtPos(start.assoc<0&&start.head>line.from?start.head-1:start.head):null;if(coords){let editorRect=view.dom.getBoundingClientRect(),direction=view.textDirectionAt(line.from),pos=view.posAtCoords({x:forward==(direction==Direction.LTR)?editorRect.right-1:editorRect.left+1,y:(coords.top+coords.bottom)/2});if(null!=pos)return EditorSelection.cursor(pos,forward?-1:1)}return EditorSelection.cursor(forward?line.to:line.from,forward?-1:1)}(this,start,forward,!(arguments.length>2&&void 0!==arguments[2])||arguments[2])}moveVertically(start,forward,distance){return skipAtoms(this,start,function(view,start,forward,distance){let startPos=start.head,dir=forward?1:-1;if(startPos==(forward?view.state.doc.length:0))return EditorSelection.cursor(startPos,start.assoc);let startY,goal=start.goalColumn,rect=view.contentDOM.getBoundingClientRect(),startCoords=view.coordsAtPos(startPos),docTop=view.documentTop;if(startCoords)null==goal&&(goal=startCoords.left-rect.left),startY=dir<0?startCoords.top:startCoords.bottom;else{let line=view.viewState.lineBlockAt(startPos);null==goal&&(goal=Math.min(rect.right-rect.left,view.defaultCharacterWidth*(startPos-line.from))),startY=(dir<0?line.top:line.bottom)+docTop}let resolvedGoal=rect.left+goal,dist=null!=distance?distance:view.viewState.heightOracle.textHeight>>1;for(let extra=0;;extra+=10){let curY=startY+(dist+extra)*dir,pos=posAtCoords(view,{x:resolvedGoal,y:curY},!1,dir);if(curY<rect.top||curY>rect.bottom||(dir<0?pos<startPos:pos>startPos))return EditorSelection.cursor(pos,start.assoc,void 0,goal)}}(this,start,forward,distance))}domAtPos(pos){return this.docView.domAtPos(pos)}posAtDOM(node){let offset=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return this.docView.posFromDOM(node,offset)}posAtCoords(coords){let precise=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return this.readMeasured(),posAtCoords(this,coords,precise)}coordsAtPos(pos){let side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;this.readMeasured();let rect=this.docView.coordsAt(pos,side);if(!rect||rect.left==rect.right)return rect;let line=this.state.doc.lineAt(pos),order=this.bidiSpans(line);return flattenRect(rect,order[BidiSpan.find(order,pos-line.from,-1,side)].dir==Direction.LTR==side>0)}get defaultCharacterWidth(){return this.viewState.heightOracle.charWidth}get defaultLineHeight(){return this.viewState.heightOracle.lineHeight}get textDirection(){return this.viewState.defaultTextDirection}textDirectionAt(pos){return!this.state.facet(perLineTextDirection)||pos<this.viewport.from||pos>this.viewport.to?this.textDirection:(this.readMeasured(),this.docView.textDirectionAt(pos))}get lineWrapping(){return this.viewState.heightOracle.lineWrapping}bidiSpans(line){if(line.length>MaxBidiLine)return trivialOrder(line.length);let dir=this.textDirectionAt(line.from);for(let entry of this.bidiCache)if(entry.from==line.from&&entry.dir==dir)return entry.order;let order=function(line,direction){let len=line.length,outerType=direction==LTR?1:2,oppositeType=direction==LTR?2:1;if(!line||1==outerType&&!BidiRE.test(line))return trivialOrder(len);for(let i=0,prev=outerType,prevStrong=outerType;i<len;i++){let type=(ch=line.charCodeAt(i))<=247?LowTypes[ch]:1424<=ch&&ch<=1524?2:1536<=ch&&ch<=1785?ArabicTypes[ch-1536]:1774<=ch&&ch<=2220?4:8192<=ch&&ch<=8203?256:64336<=ch&&ch<=65023?4:8204==ch?256:1;512==type?type=prev:8==type&&4==prevStrong&&(type=16),types[i]=4==type?2:type,7&type&&(prevStrong=type),prev=type}var ch;for(let i=0,prev=outerType,prevStrong=outerType;i<len;i++){let type=types[i];if(128==type)i<len-1&&prev==types[i+1]&&24&prev?type=types[i]=prev:types[i]=256;else if(64==type){let end=i+1;for(;end<len&&64==types[end];)end++;let replace=i&&8==prev||end<len&&8==types[end]?1==prevStrong?1:8:256;for(let j=i;j<end;j++)types[j]=replace;i=end-1}else 8==type&&1==prevStrong&&(types[i]=1);prev=type,7&type&&(prevStrong=type)}for(let ch,br,type,i=0,sI=0,context=0;i<len;i++)if(br=Brackets[ch=line.charCodeAt(i)])if(br<0){for(let sJ=sI-3;sJ>=0;sJ-=3)if(BracketStack[sJ+1]==-br){let flags=BracketStack[sJ+2],type=2&flags?outerType:4&flags?1&flags?oppositeType:outerType:0;type&&(types[i]=types[BracketStack[sJ]]=type),sI=sJ;break}}else{if(189==BracketStack.length)break;BracketStack[sI++]=i,BracketStack[sI++]=ch,BracketStack[sI++]=context}else if(2==(type=types[i])||1==type){let embed=type==outerType;context=embed?0:1;for(let sJ=sI-3;sJ>=0;sJ-=3){let cur=BracketStack[sJ+2];if(2&cur)break;if(embed)BracketStack[sJ+2]|=2;else{if(4&cur)break;BracketStack[sJ+2]|=4}}}for(let i=0;i<len;i++)if(256==types[i]){let end=i+1;for(;end<len&&256==types[end];)end++;let beforeL=1==(i?types[i-1]:outerType),replace=beforeL==(1==(end<len?types[end]:outerType))?beforeL?1:2:outerType;for(let j=i;j<end;j++)types[j]=replace;i=end-1}let order=[];if(1==outerType)for(let i=0;i<len;){let start=i,rtl=1!=types[i++];for(;i<len&&rtl==(1!=types[i]);)i++;if(rtl)for(let j=i;j>start;){let end=j,l=2!=types[--j];for(;j>start&&l==(2!=types[j-1]);)j--;order.push(new BidiSpan(j,end,l?2:1))}else order.push(new BidiSpan(start,i,0))}else for(let i=0;i<len;){let start=i,rtl=2==types[i++];for(;i<len&&rtl==(2==types[i]);)i++;order.push(new BidiSpan(start,i,rtl?1:2))}return order}(line.text,dir);return this.bidiCache.push(new CachedOrder(line.from,line.to,dir,order)),order}get hasFocus(){var _a;return(this.dom.ownerDocument.hasFocus()||browser.safari&&(null===(_a=this.inputState)||void 0===_a?void 0:_a.lastContextMenu)>Date.now()-3e4)&&this.root.activeElement==this.contentDOM}focus(){this.observer.ignore((()=>{focusPreventScroll(this.contentDOM),this.docView.updateSelection()}))}setRoot(root){this._root!=root&&(this._root=root,this.observer.setWindow((9==root.nodeType?root:root.ownerDocument).defaultView||window),this.mountStyles())}destroy(){for(let plugin of this.plugins)plugin.destroy(this);this.plugins=[],this.inputState.destroy(),this.dom.remove(),this.observer.destroy(),this.measureScheduled>-1&&this.win.cancelAnimationFrame(this.measureScheduled),this.destroyed=!0}static scrollIntoView(pos){let options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return scrollIntoView$1.of(new ScrollTarget("number"==typeof pos?EditorSelection.cursor(pos):pos,options.y,options.x,options.yMargin,options.xMargin))}static domEventHandlers(handlers){return ViewPlugin.define((()=>({})),{eventHandlers:handlers})}static theme(spec,options){let prefix=StyleModule.newName(),result=[theme.of(prefix),styleModule.of(buildTheme(".".concat(prefix),spec))];return options&&options.dark&&result.push(darkTheme.of(!0)),result}static baseTheme(spec){return Prec.lowest(styleModule.of(buildTheme("."+baseThemeID,spec,lightDarkIDs)))}static findFromDOM(dom){var _a;let content=dom.querySelector(".cm-content"),cView=content&&ContentView.get(content)||ContentView.get(dom);return(null===(_a=null==cView?void 0:cView.rootView)||void 0===_a?void 0:_a.view)||null}}_exports.EditorView=EditorView,EditorView.styleModule=styleModule,EditorView.inputHandler=inputHandler$1,EditorView.focusChangeEffect=focusChangeEffect,EditorView.perLineTextDirection=perLineTextDirection,EditorView.exceptionSink=exceptionSink,EditorView.updateListener=updateListener,EditorView.editable=editable,EditorView.mouseSelectionStyle=mouseSelectionStyle,EditorView.dragMovesSelection=dragMovesSelection$1,EditorView.clickAddsSelectionRange=clickAddsSelectionRange,EditorView.decorations=decorations,EditorView.atomicRanges=atomicRanges,EditorView.scrollMargins=scrollMargins,EditorView.darkTheme=darkTheme,EditorView.contentAttributes=contentAttributes,EditorView.editorAttributes=editorAttributes,EditorView.lineWrapping=EditorView.contentAttributes.of({class:"cm-lineWrapping"}),EditorView.announce=StateEffect.define();const MaxBidiLine=4096,BadMeasure={};class CachedOrder{constructor(from,to,dir,order){this.from=from,this.to=to,this.dir=dir,this.order=order}static update(cache,changes){if(changes.empty)return cache;let result=[],lastDir=cache.length?cache[cache.length-1].dir:Direction.LTR;for(let i=Math.max(0,cache.length-10);i<cache.length;i++){let entry=cache[i];entry.dir!=lastDir||changes.touchesRange(entry.from,entry.to)||result.push(new CachedOrder(changes.mapPos(entry.from,1),changes.mapPos(entry.to,-1),entry.dir,entry.order))}return result}}function attrsFromFacet(view,facet,base){for(let sources=view.state.facet(facet),i=sources.length-1;i>=0;i--){let source=sources[i],value="function"==typeof source?source(view):source;value&&combineAttrs(value,base)}return base}const currentPlatform=browser.mac?"mac":browser.windows?"win":browser.linux?"linux":"key";function normalizeKeyName(name,platform){const parts=name.split(/-(?!$)/);let alt,ctrl,shift,meta,result=parts[parts.length-1];"Space"==result&&(result=" ");for(let i=0;i<parts.length-1;++i){const mod=parts[i];if(/^(cmd|meta|m)$/i.test(mod))meta=!0;else if(/^a(lt)?$/i.test(mod))alt=!0;else if(/^(c|ctrl|control)$/i.test(mod))ctrl=!0;else if(/^s(hift)?$/i.test(mod))shift=!0;else{if(!/^mod$/i.test(mod))throw new Error("Unrecognized modifier name: "+mod);"mac"==platform?meta=!0:ctrl=!0}}return alt&&(result="Alt-"+result),ctrl&&(result="Ctrl-"+result),meta&&(result="Meta-"+result),shift&&(result="Shift-"+result),result}function modifiers(name,event,shift){return event.altKey&&(name="Alt-"+name),event.ctrlKey&&(name="Ctrl-"+name),event.metaKey&&(name="Meta-"+name),!1!==shift&&event.shiftKey&&(name="Shift-"+name),name}const handleKeyEvents=Prec.default(EditorView.domEventHandlers({keydown:(event,view)=>runHandlers(getKeymap(view.state),event,view,"editor")})),keymap=Facet.define({enables:handleKeyEvents}),Keymaps=new WeakMap;function getKeymap(state){let bindings=state.facet(keymap),map=Keymaps.get(bindings);return map||Keymaps.set(bindings,map=function(bindings){let platform=arguments.length>1&&void 0!==arguments[1]?arguments[1]:currentPlatform,bound=Object.create(null),isPrefix=Object.create(null),checkPrefix=(name,is)=>{let current=isPrefix[name];if(null==current)isPrefix[name]=is;else if(current!=is)throw new Error("Key binding "+name+" is used both as a regular binding and as a multi-stroke prefix")},add=(scope,key,command,preventDefault)=>{var _a,_b;let scopeObj=bound[scope]||(bound[scope]=Object.create(null)),parts=key.split(/ (?!$)/).map((k=>normalizeKeyName(k,platform)));for(let i=1;i<parts.length;i++){let prefix=parts.slice(0,i).join(" ");checkPrefix(prefix,!0),scopeObj[prefix]||(scopeObj[prefix]={preventDefault:!0,run:[view=>{let ourObj=storedPrefix={view:view,prefix:prefix,scope:scope};return setTimeout((()=>{storedPrefix==ourObj&&(storedPrefix=null)}),4e3),!0}]})}let full=parts.join(" ");checkPrefix(full,!1);let binding=scopeObj[full]||(scopeObj[full]={preventDefault:!1,run:(null===(_b=null===(_a=scopeObj._any)||void 0===_a?void 0:_a.run)||void 0===_b?void 0:_b.slice())||[]});command&&binding.run.push(command),preventDefault&&(binding.preventDefault=!0)};for(let b of bindings){let scopes=b.scope?b.scope.split(" "):["editor"];if(b.any)for(let scope of scopes){let scopeObj=bound[scope]||(bound[scope]=Object.create(null));scopeObj._any||(scopeObj._any={preventDefault:!1,run:[]});for(let key in scopeObj)scopeObj[key].run.push(b.any)}let name=b[platform]||b.key;if(name)for(let scope of scopes)add(scope,name,b.run,b.preventDefault),b.shift&&add(scope,"Shift-"+name,b.shift,b.preventDefault)}return bound}(bindings.reduce(((a,b)=>a.concat(b)),[]))),map}let storedPrefix=null;function runHandlers(map,event,view,scope){let name=function(event){var name=!(mac&&event.metaKey&&event.shiftKey&&!event.ctrlKey&&!event.altKey||ie$1&&event.shiftKey&&event.key&&1==event.key.length||"Unidentified"==event.key)&&event.key||(event.shiftKey?shift:base)[event.keyCode]||event.key||"Unidentified";return"Esc"==name&&(name="Escape"),"Del"==name&&(name="Delete"),"Left"==name&&(name="ArrowLeft"),"Up"==name&&(name="ArrowUp"),"Right"==name&&(name="ArrowRight"),"Down"==name&&(name="ArrowDown"),name}(event),isChar=codePointSize(codePointAt(name,0))==name.length&&" "!=name,prefix="",fallthrough=!1;storedPrefix&&storedPrefix.view==view&&storedPrefix.scope==scope&&(prefix=storedPrefix.prefix+" ",(fallthrough=modifierCodes.indexOf(event.keyCode)<0)&&(storedPrefix=null));let baseName,shiftName,ran=new Set,runFor=binding=>{if(binding){for(let cmd of binding.run)if(!ran.has(cmd)&&(ran.add(cmd),cmd(view,event)))return!0;binding.preventDefault&&(fallthrough=!0)}return!1},scopeObj=map[scope];if(scopeObj){if(runFor(scopeObj[prefix+modifiers(name,event,!isChar)]))return!0;if(isChar&&(event.altKey||event.metaKey||event.ctrlKey)&&!(browser.windows&&event.ctrlKey&&event.altKey)&&(baseName=base[event.keyCode])&&baseName!=name){if(runFor(scopeObj[prefix+modifiers(baseName,event,!0)]))return!0;if(event.shiftKey&&(shiftName=shift[event.keyCode])!=name&&shiftName!=baseName&&runFor(scopeObj[prefix+modifiers(shiftName,event,!1)]))return!0}else if(isChar&&event.shiftKey&&runFor(scopeObj[prefix+modifiers(name,event,!0)]))return!0;if(runFor(scopeObj._any))return!0}return fallthrough}class RectangleMarker{constructor(className,left,top,width,height){this.className=className,this.left=left,this.top=top,this.width=width,this.height=height}draw(){let elt=document.createElement("div");return elt.className=this.className,this.adjust(elt),elt}update(elt,prev){return prev.className==this.className&&(this.adjust(elt),!0)}adjust(elt){elt.style.left=this.left+"px",elt.style.top=this.top+"px",null!=this.width&&(elt.style.width=this.width+"px"),elt.style.height=this.height+"px"}eq(p){return this.left==p.left&&this.top==p.top&&this.width==p.width&&this.height==p.height&&this.className==p.className}static forRange(view,className,range){if(range.empty){let pos=view.coordsAtPos(range.head,range.assoc||1);if(!pos)return[];let base=getBase(view);return[new RectangleMarker(className,pos.left-base.left,pos.top-base.top,null,pos.bottom-pos.top)]}return function(view,className,range){if(range.to<=view.viewport.from||range.from>=view.viewport.to)return[];let from=Math.max(range.from,view.viewport.from),to=Math.min(range.to,view.viewport.to),ltr=view.textDirection==Direction.LTR,content=view.contentDOM,contentRect=content.getBoundingClientRect(),base=getBase(view),lineElt=content.querySelector(".cm-line"),lineStyle=lineElt&&window.getComputedStyle(lineElt),leftSide=contentRect.left+(lineStyle?parseInt(lineStyle.paddingLeft)+Math.min(0,parseInt(lineStyle.textIndent)):0),rightSide=contentRect.right-(lineStyle?parseInt(lineStyle.paddingRight):0),startBlock=blockAt(view,from),endBlock=blockAt(view,to),visualStart=startBlock.type==BlockType.Text?startBlock:null,visualEnd=endBlock.type==BlockType.Text?endBlock:null;visualStart&&(view.lineWrapping||startBlock.widgetLineBreaks)&&(visualStart=wrappedLine(view,from,visualStart));visualEnd&&(view.lineWrapping||endBlock.widgetLineBreaks)&&(visualEnd=wrappedLine(view,to,visualEnd));if(visualStart&&visualEnd&&visualStart.from==visualEnd.from)return pieces(drawForLine(range.from,range.to,visualStart));{let top=visualStart?drawForLine(range.from,null,visualStart):drawForWidget(startBlock,!1),bottom=visualEnd?drawForLine(null,range.to,visualEnd):drawForWidget(endBlock,!0),between=[];return(visualStart||startBlock).to<(visualEnd||endBlock).from-(visualStart&&visualEnd?1:0)||startBlock.widgetLineBreaks>1&&top.bottom+view.defaultLineHeight/2<bottom.top?between.push(piece(leftSide,top.bottom,rightSide,bottom.top)):top.bottom<bottom.top&&view.elementAtHeight((top.bottom+bottom.top)/2).type==BlockType.Text&&(top.bottom=bottom.top=(top.bottom+bottom.top)/2),pieces(top).concat(between).concat(pieces(bottom))}function piece(left,top,right,bottom){return new RectangleMarker(className,left-base.left,top-base.top-.01,right-left,bottom-top+.01)}function pieces(_ref6){let{top:top,bottom:bottom,horizontal:horizontal}=_ref6,pieces=[];for(let i=0;i<horizontal.length;i+=2)pieces.push(piece(horizontal[i],top,horizontal[i+1],bottom));return pieces}function drawForLine(from,to,line){let top=1e9,bottom=-1e9,horizontal=[];function addSpan(from,fromOpen,to,toOpen,dir){let fromCoords=view.coordsAtPos(from,from==line.to?-2:2),toCoords=view.coordsAtPos(to,to==line.from?2:-2);fromCoords&&toCoords&&(top=Math.min(fromCoords.top,toCoords.top,top),bottom=Math.max(fromCoords.bottom,toCoords.bottom,bottom),dir==Direction.LTR?horizontal.push(ltr&&fromOpen?leftSide:fromCoords.left,ltr&&toOpen?rightSide:toCoords.right):horizontal.push(!ltr&&toOpen?leftSide:toCoords.left,!ltr&&fromOpen?rightSide:fromCoords.right))}let start=null!=from?from:line.from,end=null!=to?to:line.to;for(let r of view.visibleRanges)if(r.to>start&&r.from<end)for(let pos=Math.max(r.from,start),endPos=Math.min(r.to,end);;){let docLine=view.state.doc.lineAt(pos);for(let span of view.bidiSpans(docLine)){let spanFrom=span.from+docLine.from,spanTo=span.to+docLine.from;if(spanFrom>=endPos)break;spanTo>pos&&addSpan(Math.max(spanFrom,pos),null==from&&spanFrom<=start,Math.min(spanTo,endPos),null==to&&spanTo>=end,span.dir)}if(pos=docLine.to+1,pos>=endPos)break}return 0==horizontal.length&&addSpan(start,null==from,end,null==to,view.textDirection),{top:top,bottom:bottom,horizontal:horizontal}}function drawForWidget(block,top){let y=contentRect.top+(top?block.top:block.bottom);return{top:y,bottom:y,horizontal:[]}}}(view,className,range)}}function getBase(view){let rect=view.scrollDOM.getBoundingClientRect();return{left:(view.textDirection==Direction.LTR?rect.left:rect.right-view.scrollDOM.clientWidth)-view.scrollDOM.scrollLeft,top:rect.top-view.scrollDOM.scrollTop}}function wrappedLine(view,pos,inside){let range=EditorSelection.cursor(pos);return{from:Math.max(inside.from,view.moveToLineBoundary(range,!1,!0).from),to:Math.min(inside.to,view.moveToLineBoundary(range,!0,!0).from),type:BlockType.Text}}class LayerView{constructor(view,layer){this.view=view,this.layer=layer,this.drawn=[],this.measureReq={read:this.measure.bind(this),write:this.draw.bind(this)},this.dom=view.scrollDOM.appendChild(document.createElement("div")),this.dom.classList.add("cm-layer"),layer.above&&this.dom.classList.add("cm-layer-above"),layer.class&&this.dom.classList.add(layer.class),this.dom.setAttribute("aria-hidden","true"),this.setOrder(view.state),view.requestMeasure(this.measureReq),layer.mount&&layer.mount(this.dom,view)}update(update){update.startState.facet(layerOrder)!=update.state.facet(layerOrder)&&this.setOrder(update.state),(this.layer.update(update,this.dom)||update.geometryChanged)&&update.view.requestMeasure(this.measureReq)}setOrder(state){let pos=0,order=state.facet(layerOrder);for(;pos<order.length&&order[pos]!=this.layer;)pos++;this.dom.style.zIndex=String((this.layer.above?150:-1)-pos)}measure(){return this.layer.markers(this.view)}draw(markers){if(markers.length!=this.drawn.length||markers.some(((p,i)=>{return a=p,b=this.drawn[i],!(a.constructor==b.constructor&&a.eq(b));var a,b}))){let old=this.dom.firstChild,oldI=0;for(let marker of markers)marker.update&&old&&marker.constructor&&this.drawn[oldI].constructor&&marker.update(old,this.drawn[oldI])?(old=old.nextSibling,oldI++):this.dom.insertBefore(marker.draw(),old);for(;old;){let next=old.nextSibling;old.remove(),old=next}this.drawn=markers}}destroy(){this.layer.destroy&&this.layer.destroy(this.dom,this.view),this.dom.remove()}}const layerOrder=Facet.define();function layer(config){return[ViewPlugin.define((v=>new LayerView(v,config))),layerOrder.of(config)]}const CanHidePrimary=!browser.ios,selectionConfig=Facet.define({combine:configs=>combineConfig(configs,{cursorBlinkRate:1200,drawRangeCursor:!0},{cursorBlinkRate:(a,b)=>Math.min(a,b),drawRangeCursor:(a,b)=>a||b})});function drawSelection(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return[selectionConfig.of(config),cursorLayer,selectionLayer,hideNativeSelection,nativeSelectionHidden.of(!0)]}function configChanged(update){return update.startState.facet(selectionConfig)!=update.state.facet(selectionConfig)}const cursorLayer=layer({above:!0,markers(view){let{state:state}=view,conf=state.facet(selectionConfig),cursors=[];for(let r of state.selection.ranges){let prim=r==state.selection.main;if(r.empty?!prim||CanHidePrimary:conf.drawRangeCursor){let className=prim?"cm-cursor cm-cursor-primary":"cm-cursor cm-cursor-secondary",cursor=r.empty?r:EditorSelection.cursor(r.head,r.head>r.anchor?-1:1);for(let piece of RectangleMarker.forRange(view,className,cursor))cursors.push(piece)}}return cursors},update(update,dom){update.transactions.some((tr=>tr.selection))&&(dom.style.animationName="cm-blink"==dom.style.animationName?"cm-blink2":"cm-blink");let confChange=configChanged(update);return confChange&&setBlinkRate(update.state,dom),update.docChanged||update.selectionSet||confChange},mount(dom,view){setBlinkRate(view.state,dom)},class:"cm-cursorLayer"});function setBlinkRate(state,dom){dom.style.animationDuration=state.facet(selectionConfig).cursorBlinkRate+"ms"}const selectionLayer=layer({above:!1,markers:view=>view.state.selection.ranges.map((r=>r.empty?[]:RectangleMarker.forRange(view,"cm-selectionBackground",r))).reduce(((a,b)=>a.concat(b))),update:(update,dom)=>update.docChanged||update.selectionSet||update.viewportChanged||configChanged(update),class:"cm-selectionLayer"}),themeSpec={".cm-line":{"& ::selection":{backgroundColor:"transparent !important"},"&::selection":{backgroundColor:"transparent !important"}}};CanHidePrimary&&(themeSpec[".cm-line"].caretColor="transparent !important");const hideNativeSelection=Prec.highest(EditorView.theme(themeSpec)),setDropCursorPos=StateEffect.define({map:(pos,mapping)=>null==pos?null:mapping.mapPos(pos)}),dropCursorPos=StateField.define({create:()=>null,update:(pos,tr)=>(null!=pos&&(pos=tr.changes.mapPos(pos)),tr.effects.reduce(((pos,e)=>e.is(setDropCursorPos)?e.value:pos),pos))}),drawDropCursor=ViewPlugin.fromClass(class{constructor(view){this.view=view,this.cursor=null,this.measureReq={read:this.readPos.bind(this),write:this.drawCursor.bind(this)}}update(update){var _a;let cursorPos=update.state.field(dropCursorPos);null==cursorPos?null!=this.cursor&&(null===(_a=this.cursor)||void 0===_a||_a.remove(),this.cursor=null):(this.cursor||(this.cursor=this.view.scrollDOM.appendChild(document.createElement("div")),this.cursor.className="cm-dropCursor"),(update.startState.field(dropCursorPos)!=cursorPos||update.docChanged||update.geometryChanged)&&this.view.requestMeasure(this.measureReq))}readPos(){let pos=this.view.state.field(dropCursorPos),rect=null!=pos&&this.view.coordsAtPos(pos);if(!rect)return null;let outer=this.view.scrollDOM.getBoundingClientRect();return{left:rect.left-outer.left+this.view.scrollDOM.scrollLeft,top:rect.top-outer.top+this.view.scrollDOM.scrollTop,height:rect.bottom-rect.top}}drawCursor(pos){this.cursor&&(pos?(this.cursor.style.left=pos.left+"px",this.cursor.style.top=pos.top+"px",this.cursor.style.height=pos.height+"px"):this.cursor.style.left="-100000px")}destroy(){this.cursor&&this.cursor.remove()}setDropPos(pos){this.view.state.field(dropCursorPos)!=pos&&this.view.dispatch({effects:setDropCursorPos.of(pos)})}},{eventHandlers:{dragover(event){this.setDropPos(this.view.posAtCoords({x:event.clientX,y:event.clientY}))},dragleave(event){event.target!=this.view.contentDOM&&this.view.contentDOM.contains(event.relatedTarget)||this.setDropPos(null)},dragend(){this.setDropPos(null)},drop(){this.setDropPos(null)}}});function iterMatches(doc,re,from,to,f){re.lastIndex=0;for(let m,cursor=doc.iterRange(from,to),pos=from;!cursor.next().done;pos+=cursor.value.length)if(!cursor.lineBreak)for(;m=re.exec(cursor.value);)f(pos+m.index,m)}class MatchDecorator{constructor(config){const{regexp:regexp,decoration:decoration,decorate:decorate,boundary:boundary,maxLength:maxLength=1e3}=config;if(!regexp.global)throw new RangeError("The regular expression given to MatchDecorator should have its 'g' flag set");if(this.regexp=regexp,decorate)this.addMatch=(match,view,from,add)=>decorate(add,from,from+match[0].length,match,view);else if("function"==typeof decoration)this.addMatch=(match,view,from,add)=>{let deco=decoration(match,view,from);deco&&add(from,from+match[0].length,deco)};else{if(!decoration)throw new RangeError("Either 'decorate' or 'decoration' should be provided to MatchDecorator");this.addMatch=(match,_view,from,add)=>add(from,from+match[0].length,decoration)}this.boundary=boundary,this.maxLength=maxLength}createDeco(view){let build=new RangeSetBuilder,add=build.add.bind(build);for(let{from:from,to:to}of function(view,maxLength){let visible=view.visibleRanges;if(1==visible.length&&visible[0].from==view.viewport.from&&visible[0].to==view.viewport.to)return visible;let result=[];for(let{from:from,to:to}of visible)from=Math.max(view.state.doc.lineAt(from).from,from-maxLength),to=Math.min(view.state.doc.lineAt(to).to,to+maxLength),result.length&&result[result.length-1].to>=from?result[result.length-1].to=to:result.push({from:from,to:to});return result}(view,this.maxLength))iterMatches(view.state.doc,this.regexp,from,to,((from,m)=>this.addMatch(m,view,from,add)));return build.finish()}updateDeco(update,deco){let changeFrom=1e9,changeTo=-1;return update.docChanged&&update.changes.iterChanges(((_f,_t,from,to)=>{to>update.view.viewport.from&&from<update.view.viewport.to&&(changeFrom=Math.min(from,changeFrom),changeTo=Math.max(to,changeTo))})),update.viewportChanged||changeTo-changeFrom>1e3?this.createDeco(update.view):changeTo>-1?this.updateRange(update.view,deco.map(update.changes),changeFrom,changeTo):deco}updateRange(view,deco,updateFrom,updateTo){for(let r of view.visibleRanges){let from=Math.max(r.from,updateFrom),to=Math.min(r.to,updateTo);if(to>from){let fromLine=view.state.doc.lineAt(from),toLine=fromLine.to<to?view.state.doc.lineAt(to):fromLine,start=Math.max(r.from,fromLine.from),end=Math.min(r.to,toLine.to);if(this.boundary){for(;from>fromLine.from;from--)if(this.boundary.test(fromLine.text[from-1-fromLine.from])){start=from;break}for(;to<toLine.to;to++)if(this.boundary.test(toLine.text[to-toLine.from])){end=to;break}}let m,ranges=[],add=(from,to,deco)=>ranges.push(deco.range(from,to));if(fromLine==toLine)for(this.regexp.lastIndex=start-fromLine.from;(m=this.regexp.exec(fromLine.text))&&m.index<end-fromLine.from;)this.addMatch(m,view,m.index+fromLine.from,add);else iterMatches(view.state.doc,this.regexp,start,end,((from,m)=>this.addMatch(m,view,from,add)));deco=deco.update({filterFrom:start,filterTo:end,filter:(from,to)=>from<start||to>end,add:ranges})}}return deco}}const UnicodeRegexpSupport=null!=/x/.unicode?"gu":"g",Specials=new RegExp("[\0-\b\n--­؜​‎‏\u2028\u2029‭‮⁦⁧⁩\ufeff￹-￼]",UnicodeRegexpSupport),Names={0:"null",7:"bell",8:"backspace",10:"newline",11:"vertical tab",13:"carriage return",27:"escape",8203:"zero width space",8204:"zero width non-joiner",8205:"zero width joiner",8206:"left-to-right mark",8207:"right-to-left mark",8232:"line separator",8237:"left-to-right override",8238:"right-to-left override",8294:"left-to-right isolate",8295:"right-to-left isolate",8297:"pop directional isolate",8233:"paragraph separator",65279:"zero width no-break space",65532:"object replacement"};let _supportsTabSize=null;const specialCharConfig=Facet.define({combine(configs){let config=combineConfig(configs,{render:null,specialChars:Specials,addSpecialChars:null});return(config.replaceTabs=!function(){var _a;if(null==_supportsTabSize&&"undefined"!=typeof document&&document.body){let styles=document.body.style;_supportsTabSize=null!=(null!==(_a=styles.tabSize)&&void 0!==_a?_a:styles.MozTabSize)}return _supportsTabSize||!1}())&&(config.specialChars=new RegExp("\t|"+config.specialChars.source,UnicodeRegexpSupport)),config.addSpecialChars&&(config.specialChars=new RegExp(config.specialChars.source+"|"+config.addSpecialChars.source,UnicodeRegexpSupport)),config}});function highlightSpecialChars(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return[specialCharConfig.of(config),specialCharPlugin()]}let _plugin=null;function specialCharPlugin(){return _plugin||(_plugin=ViewPlugin.fromClass(class{constructor(view){this.view=view,this.decorations=Decoration.none,this.decorationCache=Object.create(null),this.decorator=this.makeDecorator(view.state.facet(specialCharConfig)),this.decorations=this.decorator.createDeco(view)}makeDecorator(conf){return new MatchDecorator({regexp:conf.specialChars,decoration:(m,view,pos)=>{let{doc:doc}=view.state,code=codePointAt(m[0],0);if(9==code){let line=doc.lineAt(pos),size=view.state.tabSize,col=countColumn(line.text,size,pos-line.from);return Decoration.replace({widget:new TabWidget((size-col%size)*this.view.defaultCharacterWidth)})}return this.decorationCache[code]||(this.decorationCache[code]=Decoration.replace({widget:new SpecialCharWidget(conf,code)}))},boundary:conf.replaceTabs?void 0:/[^]/})}update(update){let conf=update.state.facet(specialCharConfig);update.startState.facet(specialCharConfig)!=conf?(this.decorator=this.makeDecorator(conf),this.decorations=this.decorator.createDeco(update.view)):this.decorations=this.decorator.updateDeco(update,this.decorations)}},{decorations:v=>v.decorations}))}class SpecialCharWidget extends WidgetType{constructor(options,code){super(),this.options=options,this.code=code}eq(other){return other.code==this.code}toDOM(view){let ph=function(code){return code>=32?"•":10==code?"␤":String.fromCharCode(9216+code)}(this.code),desc=view.state.phrase("Control character")+" "+(Names[this.code]||"0x"+this.code.toString(16)),custom=this.options.render&&this.options.render(this.code,desc,ph);if(custom)return custom;let span=document.createElement("span");return span.textContent=ph,span.title=desc,span.setAttribute("aria-label",desc),span.className="cm-specialChar",span}ignoreEvent(){return!1}}class TabWidget extends WidgetType{constructor(width){super(),this.width=width}eq(other){return other.width==this.width}toDOM(){let span=document.createElement("span");return span.textContent="\t",span.className="cm-tab",span.style.width=this.width+"px",span}ignoreEvent(){return!1}}const lineDeco=Decoration.line({class:"cm-activeLine"}),activeLineHighlighter=ViewPlugin.fromClass(class{constructor(view){this.decorations=this.getDeco(view)}update(update){(update.docChanged||update.selectionSet)&&(this.decorations=this.getDeco(update.view))}getDeco(view){let lastLineStart=-1,deco=[];for(let r of view.state.selection.ranges){let line=view.lineBlockAt(r.head);line.from>lastLineStart&&(deco.push(lineDeco.range(line.from)),lastLineStart=line.from)}return Decoration.set(deco)}},{decorations:v=>v.decorations});function getPos(view,event){let offset=view.posAtCoords({x:event.clientX,y:event.clientY},!1),line=view.state.doc.lineAt(offset),off=offset-line.from,col=off>2e3?-1:off==line.length?function(view,x){let ref=view.coordsAtPos(view.viewport.from);return ref?Math.round(Math.abs((ref.left-x)/view.defaultCharacterWidth)):-1}(view,event.clientX):countColumn(line.text,view.state.tabSize,offset-line.from);return{line:line.number,col:col,off:off}}function rectangleSelectionStyle(view,event){let start=getPos(view,event),startSel=view.state.selection;return start?{update(update){if(update.docChanged){let newStart=update.changes.mapPos(update.startState.doc.line(start.line).from),newLine=update.state.doc.lineAt(newStart);start={line:newLine.number,col:start.col,off:Math.min(start.off,newLine.length)},startSel=startSel.map(update.changes)}},get(event,_extend,multiple){let cur=getPos(view,event);if(!cur)return startSel;let ranges=function(state,a,b){let startLine=Math.min(a.line,b.line),endLine=Math.max(a.line,b.line),ranges=[];if(a.off>2e3||b.off>2e3||a.col<0||b.col<0){let startOff=Math.min(a.off,b.off),endOff=Math.max(a.off,b.off);for(let i=startLine;i<=endLine;i++){let line=state.doc.line(i);line.length<=endOff&&ranges.push(EditorSelection.range(line.from+startOff,line.to+endOff))}}else{let startCol=Math.min(a.col,b.col),endCol=Math.max(a.col,b.col);for(let i=startLine;i<=endLine;i++){let line=state.doc.line(i),start=findColumn(line.text,startCol,state.tabSize,!0);if(start<0)ranges.push(EditorSelection.cursor(line.to));else{let end=findColumn(line.text,endCol,state.tabSize);ranges.push(EditorSelection.range(line.from+start,line.from+end))}}}return ranges}(view.state,start,cur);return ranges.length?multiple?EditorSelection.create(ranges.concat(startSel.ranges)):EditorSelection.create(ranges):startSel}}:null}function rectangularSelection(options){let filter=(null==options?void 0:options.eventFilter)||(e=>e.altKey&&0==e.button);return EditorView.mouseSelectionStyle.of(((view,event)=>filter(event)?rectangleSelectionStyle(view,event):null))}const keys={Alt:[18,e=>!!e.altKey],Control:[17,e=>!!e.ctrlKey],Shift:[16,e=>!!e.shiftKey],Meta:[91,e=>!!e.metaKey]},showCrosshair={style:"cursor: crosshair"};function crosshairCursor(){let options=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},[code,getter]=keys[options.key||"Alt"],plugin=ViewPlugin.fromClass(class{constructor(view){this.view=view,this.isDown=!1}set(isDown){this.isDown!=isDown&&(this.isDown=isDown,this.view.update([]))}},{eventHandlers:{keydown(e){this.set(e.keyCode==code||getter(e))},keyup(e){e.keyCode!=code&&getter(e)||this.set(!1)},mousemove(e){this.set(getter(e))}}});return[plugin,EditorView.contentAttributes.of((view=>{var _a;return(null===(_a=view.plugin(plugin))||void 0===_a?void 0:_a.isDown)?showCrosshair:null}))]}class TooltipViewManager{constructor(view,facet,createTooltipView){this.facet=facet,this.createTooltipView=createTooltipView,this.input=view.state.facet(facet),this.tooltips=this.input.filter((t=>t)),this.tooltipViews=this.tooltips.map(createTooltipView)}update(update){var _a;let input=update.state.facet(this.facet),tooltips=input.filter((x=>x));if(input===this.input){for(let t of this.tooltipViews)t.update&&t.update(update);return!1}let tooltipViews=[];for(let i=0;i<tooltips.length;i++){let tip=tooltips[i],known=-1;if(tip){for(let i=0;i<this.tooltips.length;i++){let other=this.tooltips[i];other&&other.create==tip.create&&(known=i)}if(known<0)tooltipViews[i]=this.createTooltipView(tip);else{let tooltipView=tooltipViews[i]=this.tooltipViews[known];tooltipView.update&&tooltipView.update(update)}}}for(let t of this.tooltipViews)tooltipViews.indexOf(t)<0&&(t.dom.remove(),null===(_a=t.destroy)||void 0===_a||_a.call(t));return this.input=input,this.tooltips=tooltips,this.tooltipViews=tooltipViews,!0}}function windowSpace(view){let{win:win}=view;return{top:0,left:0,bottom:win.innerHeight,right:win.innerWidth}}const tooltipConfig=Facet.define({combine:values=>{var _a,_b,_c;return{position:browser.ios?"absolute":(null===(_a=values.find((conf=>conf.position)))||void 0===_a?void 0:_a.position)||"fixed",parent:(null===(_b=values.find((conf=>conf.parent)))||void 0===_b?void 0:_b.parent)||null,tooltipSpace:(null===(_c=values.find((conf=>conf.tooltipSpace)))||void 0===_c?void 0:_c.tooltipSpace)||windowSpace}}}),knownHeight=new WeakMap,tooltipPlugin=ViewPlugin.fromClass(class{constructor(view){this.view=view,this.inView=!0,this.lastTransaction=0,this.measureTimeout=-1;let config=view.state.facet(tooltipConfig);this.position=config.position,this.parent=config.parent,this.classes=view.themeClasses,this.createContainer(),this.measureReq={read:this.readMeasure.bind(this),write:this.writeMeasure.bind(this),key:this},this.manager=new TooltipViewManager(view,showTooltip,(t=>this.createTooltip(t))),this.intersectionObserver="function"==typeof IntersectionObserver?new IntersectionObserver((entries=>{Date.now()>this.lastTransaction-50&&entries.length>0&&entries[entries.length-1].intersectionRatio<1&&this.measureSoon()}),{threshold:[1]}):null,this.observeIntersection(),view.win.addEventListener("resize",this.measureSoon=this.measureSoon.bind(this)),this.maybeMeasure()}createContainer(){this.parent?(this.container=document.createElement("div"),this.container.style.position="relative",this.container.className=this.view.themeClasses,this.parent.appendChild(this.container)):this.container=this.view.dom}observeIntersection(){if(this.intersectionObserver){this.intersectionObserver.disconnect();for(let tooltip of this.manager.tooltipViews)this.intersectionObserver.observe(tooltip.dom)}}measureSoon(){this.measureTimeout<0&&(this.measureTimeout=setTimeout((()=>{this.measureTimeout=-1,this.maybeMeasure()}),50))}update(update){update.transactions.length&&(this.lastTransaction=Date.now());let updated=this.manager.update(update);updated&&this.observeIntersection();let shouldMeasure=updated||update.geometryChanged,newConfig=update.state.facet(tooltipConfig);if(newConfig.position!=this.position){this.position=newConfig.position;for(let t of this.manager.tooltipViews)t.dom.style.position=this.position;shouldMeasure=!0}if(newConfig.parent!=this.parent){this.parent&&this.container.remove(),this.parent=newConfig.parent,this.createContainer();for(let t of this.manager.tooltipViews)this.container.appendChild(t.dom);shouldMeasure=!0}else this.parent&&this.view.themeClasses!=this.classes&&(this.classes=this.container.className=this.view.themeClasses);shouldMeasure&&this.maybeMeasure()}createTooltip(tooltip){let tooltipView=tooltip.create(this.view);if(tooltipView.dom.classList.add("cm-tooltip"),tooltip.arrow&&!tooltipView.dom.querySelector(".cm-tooltip > .cm-tooltip-arrow")){let arrow=document.createElement("div");arrow.className="cm-tooltip-arrow",tooltipView.dom.appendChild(arrow)}return tooltipView.dom.style.position=this.position,tooltipView.dom.style.top="-10000px",this.container.appendChild(tooltipView.dom),tooltipView.mount&&tooltipView.mount(this.view),tooltipView}destroy(){var _a,_b;this.view.win.removeEventListener("resize",this.measureSoon);for(let tooltipView of this.manager.tooltipViews)tooltipView.dom.remove(),null===(_a=tooltipView.destroy)||void 0===_a||_a.call(tooltipView);null===(_b=this.intersectionObserver)||void 0===_b||_b.disconnect(),clearTimeout(this.measureTimeout)}readMeasure(){let editor=this.view.dom.getBoundingClientRect();return{editor:editor,parent:this.parent?this.container.getBoundingClientRect():editor,pos:this.manager.tooltips.map(((t,i)=>{let tv=this.manager.tooltipViews[i];return tv.getCoords?tv.getCoords(t.pos):this.view.coordsAtPos(t.pos)})),size:this.manager.tooltipViews.map((_ref7=>{let{dom:dom}=_ref7;return dom.getBoundingClientRect()})),space:this.view.state.facet(tooltipConfig).tooltipSpace(this.view)}}writeMeasure(measured){var _a;let{editor:editor,space:space}=measured,others=[];for(let i=0;i<this.manager.tooltips.length;i++){let tooltip=this.manager.tooltips[i],tView=this.manager.tooltipViews[i],{dom:dom}=tView,pos=measured.pos[i],size=measured.size[i];if(!pos||pos.bottom<=Math.max(editor.top,space.top)||pos.top>=Math.min(editor.bottom,space.bottom)||pos.right<Math.max(editor.left,space.left)-.1||pos.left>Math.min(editor.right,space.right)+.1){dom.style.top="-10000px";continue}let arrow=tooltip.arrow?tView.dom.querySelector(".cm-tooltip-arrow"):null,arrowHeight=arrow?7:0,width=size.right-size.left,height=null!==(_a=knownHeight.get(tView))&&void 0!==_a?_a:size.bottom-size.top,offset=tView.offset||noOffset,ltr=this.view.textDirection==Direction.LTR,left=size.width>space.right-space.left?ltr?space.left:space.right-size.width:ltr?Math.min(pos.left-(arrow?14:0)+offset.x,space.right-width):Math.max(space.left,pos.left-width+(arrow?14:0)-offset.x),above=!!tooltip.above;!tooltip.strictSide&&(above?pos.top-(size.bottom-size.top)-offset.y<space.top:pos.bottom+(size.bottom-size.top)+offset.y>space.bottom)&&above==space.bottom-pos.bottom>pos.top-space.top&&(above=!above);let spaceVert=(above?pos.top-space.top:space.bottom-pos.bottom)-arrowHeight;if(spaceVert<height&&!1!==tView.resize){if(spaceVert<this.view.defaultLineHeight){dom.style.top="-10000px";continue}knownHeight.set(tView,height),dom.style.height=(height=spaceVert)+"px"}else dom.style.height&&(dom.style.height="");let top=above?pos.top-height-arrowHeight-offset.y:pos.bottom+arrowHeight+offset.y,right=left+width;if(!0!==tView.overlap)for(let r of others)r.left<right&&r.right>left&&r.top<top+height&&r.bottom>top&&(top=above?r.top-height-2-arrowHeight:r.bottom+arrowHeight+2);"absolute"==this.position?(dom.style.top=top-measured.parent.top+"px",dom.style.left=left-measured.parent.left+"px"):(dom.style.top=top+"px",dom.style.left=left+"px"),arrow&&(arrow.style.left="".concat(pos.left+(ltr?offset.x:-offset.x)-(left+14-7),"px")),!0!==tView.overlap&&others.push({left:left,top:top,right:right,bottom:top+height}),dom.classList.toggle("cm-tooltip-above",above),dom.classList.toggle("cm-tooltip-below",!above),tView.positioned&&tView.positioned(measured.space)}}maybeMeasure(){if(this.manager.tooltips.length&&(this.view.inView&&this.view.requestMeasure(this.measureReq),this.inView!=this.view.inView&&(this.inView=this.view.inView,!this.inView)))for(let tv of this.manager.tooltipViews)tv.dom.style.top="-10000px"}},{eventHandlers:{scroll(){this.maybeMeasure()}}}),baseTheme$4=EditorView.baseTheme({".cm-tooltip":{zIndex:100,boxSizing:"border-box"},"&light .cm-tooltip":{border:"1px solid #bbb",backgroundColor:"#f5f5f5"},"&light .cm-tooltip-section:not(:first-child)":{borderTop:"1px solid #bbb"},"&dark .cm-tooltip":{backgroundColor:"#333338",color:"white"},".cm-tooltip-arrow":{height:"".concat(7,"px"),width:"".concat(14,"px"),position:"absolute",zIndex:-1,overflow:"hidden","&:before, &:after":{content:"''",position:"absolute",width:0,height:0,borderLeft:"".concat(7,"px solid transparent"),borderRight:"".concat(7,"px solid transparent")},".cm-tooltip-above &":{bottom:"-".concat(7,"px"),"&:before":{borderTop:"".concat(7,"px solid #bbb")},"&:after":{borderTop:"".concat(7,"px solid #f5f5f5"),bottom:"1px"}},".cm-tooltip-below &":{top:"-".concat(7,"px"),"&:before":{borderBottom:"".concat(7,"px solid #bbb")},"&:after":{borderBottom:"".concat(7,"px solid #f5f5f5"),top:"1px"}}},"&dark .cm-tooltip .cm-tooltip-arrow":{"&:before":{borderTopColor:"#333338",borderBottomColor:"#333338"},"&:after":{borderTopColor:"transparent",borderBottomColor:"transparent"}}}),noOffset={x:0,y:0},showTooltip=Facet.define({enables:[tooltipPlugin,baseTheme$4]}),showHoverTooltip=Facet.define();class HoverTooltipHost{constructor(view){this.view=view,this.mounted=!1,this.dom=document.createElement("div"),this.dom.classList.add("cm-tooltip-hover"),this.manager=new TooltipViewManager(view,showHoverTooltip,(t=>this.createHostedView(t)))}static create(view){return new HoverTooltipHost(view)}createHostedView(tooltip){let hostedView=tooltip.create(this.view);return hostedView.dom.classList.add("cm-tooltip-section"),this.dom.appendChild(hostedView.dom),this.mounted&&hostedView.mount&&hostedView.mount(this.view),hostedView}mount(view){for(let hostedView of this.manager.tooltipViews)hostedView.mount&&hostedView.mount(view);this.mounted=!0}positioned(space){for(let hostedView of this.manager.tooltipViews)hostedView.positioned&&hostedView.positioned(space)}update(update){this.manager.update(update)}destroy(){var _a;for(let t of this.manager.tooltipViews)null===(_a=t.destroy)||void 0===_a||_a.call(t)}}const showHoverTooltipHost=showTooltip.compute([showHoverTooltip],(state=>{let tooltips=state.facet(showHoverTooltip).filter((t=>t));return 0===tooltips.length?null:{pos:Math.min(...tooltips.map((t=>t.pos))),end:Math.max(...tooltips.filter((t=>null!=t.end)).map((t=>t.end))),create:HoverTooltipHost.create,above:tooltips[0].above,arrow:tooltips.some((t=>t.arrow))}}));class HoverPlugin{constructor(view,source,field,setHover,hoverTime){this.view=view,this.source=source,this.field=field,this.setHover=setHover,this.hoverTime=hoverTime,this.hoverTimeout=-1,this.restartTimeout=-1,this.pending=null,this.lastMove={x:0,y:0,target:view.dom,time:0},this.checkHover=this.checkHover.bind(this),view.dom.addEventListener("mouseleave",this.mouseleave=this.mouseleave.bind(this)),view.dom.addEventListener("mousemove",this.mousemove=this.mousemove.bind(this))}update(){this.pending&&(this.pending=null,clearTimeout(this.restartTimeout),this.restartTimeout=setTimeout((()=>this.startHover()),20))}get active(){return this.view.state.field(this.field)}checkHover(){if(this.hoverTimeout=-1,this.active)return;let hovered=Date.now()-this.lastMove.time;hovered<this.hoverTime?this.hoverTimeout=setTimeout(this.checkHover,this.hoverTime-hovered):this.startHover()}startHover(){clearTimeout(this.restartTimeout);let{lastMove:lastMove}=this,pos=this.view.contentDOM.contains(lastMove.target)?this.view.posAtCoords(lastMove):null;if(null==pos)return;let posCoords=this.view.coordsAtPos(pos);if(null==posCoords||lastMove.y<posCoords.top||lastMove.y>posCoords.bottom||lastMove.x<posCoords.left-this.view.defaultCharacterWidth||lastMove.x>posCoords.right+this.view.defaultCharacterWidth)return;let bidi=this.view.bidiSpans(this.view.state.doc.lineAt(pos)).find((s=>s.from<=pos&&s.to>=pos)),rtl=bidi&&bidi.dir==Direction.RTL?-1:1,open=this.source(this.view,pos,lastMove.x<posCoords.left?-rtl:rtl);if(null==open?void 0:open.then){let pending=this.pending={pos:pos};open.then((result=>{this.pending==pending&&(this.pending=null,result&&this.view.dispatch({effects:this.setHover.of(result)}))}),(e=>logException(this.view.state,e,"hover tooltip")))}else open&&this.view.dispatch({effects:this.setHover.of(open)})}mousemove(event){var _a;this.lastMove={x:event.clientX,y:event.clientY,target:event.target,time:Date.now()},this.hoverTimeout<0&&(this.hoverTimeout=setTimeout(this.checkHover,this.hoverTime));let tooltip=this.active;if(tooltip&&!isInTooltip(this.lastMove.target)||this.pending){let{pos:pos}=tooltip||this.pending,end=null!==(_a=null==tooltip?void 0:tooltip.end)&&void 0!==_a?_a:pos;(pos==end?this.view.posAtCoords(this.lastMove)==pos:function(view,from,to,x,y,margin){let range=document.createRange(),fromDOM=view.domAtPos(from),toDOM=view.domAtPos(to);range.setEnd(toDOM.node,toDOM.offset),range.setStart(fromDOM.node,fromDOM.offset);let rects=range.getClientRects();range.detach();for(let i=0;i<rects.length;i++){let rect=rects[i];if(Math.max(rect.top-y,y-rect.bottom,rect.left-x,x-rect.right)<=margin)return!0}return!1}(this.view,pos,end,event.clientX,event.clientY,6))||(this.view.dispatch({effects:this.setHover.of(null)}),this.pending=null)}}mouseleave(e){clearTimeout(this.hoverTimeout),this.hoverTimeout=-1,this.active&&!isInTooltip(e.relatedTarget)&&this.view.dispatch({effects:this.setHover.of(null)})}destroy(){clearTimeout(this.hoverTimeout),this.view.dom.removeEventListener("mouseleave",this.mouseleave),this.view.dom.removeEventListener("mousemove",this.mousemove)}}function isInTooltip(elt){for(let cur=elt;cur;cur=cur.parentNode)if(1==cur.nodeType&&cur.classList.contains("cm-tooltip"))return!0;return!1}function getTooltip(view,tooltip){let plugin=view.plugin(tooltipPlugin);if(!plugin)return null;let found=plugin.manager.tooltips.indexOf(tooltip);return found<0?null:plugin.manager.tooltipViews[found]}const closeHoverTooltipEffect=StateEffect.define(),panelConfig=Facet.define({combine(configs){let topContainer,bottomContainer;for(let c of configs)topContainer=topContainer||c.topContainer,bottomContainer=bottomContainer||c.bottomContainer;return{topContainer:topContainer,bottomContainer:bottomContainer}}});function getPanel(view,panel){let plugin=view.plugin(panelPlugin),index=plugin?plugin.specs.indexOf(panel):-1;return index>-1?plugin.panels[index]:null}const panelPlugin=ViewPlugin.fromClass(class{constructor(view){this.input=view.state.facet(showPanel),this.specs=this.input.filter((s=>s)),this.panels=this.specs.map((spec=>spec(view)));let conf=view.state.facet(panelConfig);this.top=new PanelGroup(view,!0,conf.topContainer),this.bottom=new PanelGroup(view,!1,conf.bottomContainer),this.top.sync(this.panels.filter((p=>p.top))),this.bottom.sync(this.panels.filter((p=>!p.top)));for(let p of this.panels)p.dom.classList.add("cm-panel"),p.mount&&p.mount()}update(update){let conf=update.state.facet(panelConfig);this.top.container!=conf.topContainer&&(this.top.sync([]),this.top=new PanelGroup(update.view,!0,conf.topContainer)),this.bottom.container!=conf.bottomContainer&&(this.bottom.sync([]),this.bottom=new PanelGroup(update.view,!1,conf.bottomContainer)),this.top.syncClasses(),this.bottom.syncClasses();let input=update.state.facet(showPanel);if(input!=this.input){let specs=input.filter((x=>x)),panels=[],top=[],bottom=[],mount=[];for(let spec of specs){let panel,known=this.specs.indexOf(spec);known<0?(panel=spec(update.view),mount.push(panel)):(panel=this.panels[known],panel.update&&panel.update(update)),panels.push(panel),(panel.top?top:bottom).push(panel)}this.specs=specs,this.panels=panels,this.top.sync(top),this.bottom.sync(bottom);for(let p of mount)p.dom.classList.add("cm-panel"),p.mount&&p.mount()}else for(let p of this.panels)p.update&&p.update(update)}destroy(){this.top.sync([]),this.bottom.sync([])}},{provide:plugin=>EditorView.scrollMargins.of((view=>{let value=view.plugin(plugin);return value&&{top:value.top.scrollMargin(),bottom:value.bottom.scrollMargin()}}))});class PanelGroup{constructor(view,top,container){this.view=view,this.top=top,this.container=container,this.dom=void 0,this.classes="",this.panels=[],this.syncClasses()}sync(panels){for(let p of this.panels)p.destroy&&panels.indexOf(p)<0&&p.destroy();this.panels=panels,this.syncDOM()}syncDOM(){if(0==this.panels.length)return void(this.dom&&(this.dom.remove(),this.dom=void 0));if(!this.dom){this.dom=document.createElement("div"),this.dom.className=this.top?"cm-panels cm-panels-top":"cm-panels cm-panels-bottom",this.dom.style[this.top?"top":"bottom"]="0";let parent=this.container||this.view.dom;parent.insertBefore(this.dom,this.top?parent.firstChild:null)}let curDOM=this.dom.firstChild;for(let panel of this.panels)if(panel.dom.parentNode==this.dom){for(;curDOM!=panel.dom;)curDOM=rm(curDOM);curDOM=curDOM.nextSibling}else this.dom.insertBefore(panel.dom,curDOM);for(;curDOM;)curDOM=rm(curDOM)}scrollMargin(){return!this.dom||this.container?0:Math.max(0,this.top?this.dom.getBoundingClientRect().bottom-Math.max(0,this.view.scrollDOM.getBoundingClientRect().top):Math.min(innerHeight,this.view.scrollDOM.getBoundingClientRect().bottom)-this.dom.getBoundingClientRect().top)}syncClasses(){if(this.container&&this.classes!=this.view.themeClasses){for(let cls of this.classes.split(" "))cls&&this.container.classList.remove(cls);for(let cls of(this.classes=this.view.themeClasses).split(" "))cls&&this.container.classList.add(cls)}}}function rm(node){let next=node.nextSibling;return node.remove(),next}const showPanel=Facet.define({enables:panelPlugin});class GutterMarker extends RangeValue{compare(other){return this==other||this.constructor==other.constructor&&this.eq(other)}eq(other){return!1}destroy(dom){}}GutterMarker.prototype.elementClass="",GutterMarker.prototype.toDOM=void 0,GutterMarker.prototype.mapMode=MapMode.TrackBefore,GutterMarker.prototype.startSide=GutterMarker.prototype.endSide=-1,GutterMarker.prototype.point=!0;const gutterLineClass=Facet.define(),defaults$1={class:"",renderEmptyElements:!1,elementStyle:"",markers:()=>RangeSet.empty,lineMarker:()=>null,widgetMarker:()=>null,lineMarkerChange:null,initialSpacer:null,updateSpacer:null,domEventHandlers:{}},activeGutters=Facet.define();function gutter(config){return[gutters(),activeGutters.of(Object.assign(Object.assign({},defaults$1),config))]}const unfixGutters=Facet.define({combine:values=>values.some((x=>x))});function gutters(config){let result=[gutterView];return config&&!1===config.fixed&&result.push(unfixGutters.of(!0)),result}const gutterView=ViewPlugin.fromClass(class{constructor(view){this.view=view,this.prevViewport=view.viewport,this.dom=document.createElement("div"),this.dom.className="cm-gutters",this.dom.setAttribute("aria-hidden","true"),this.dom.style.minHeight=this.view.contentHeight+"px",this.gutters=view.state.facet(activeGutters).map((conf=>new SingleGutterView(view,conf)));for(let gutter of this.gutters)this.dom.appendChild(gutter.dom);this.fixed=!view.state.facet(unfixGutters),this.fixed&&(this.dom.style.position="sticky"),this.syncGutters(!1),view.scrollDOM.insertBefore(this.dom,view.contentDOM)}update(update){if(this.updateGutters(update)){let vpA=this.prevViewport,vpB=update.view.viewport,vpOverlap=Math.min(vpA.to,vpB.to)-Math.max(vpA.from,vpB.from);this.syncGutters(vpOverlap<.8*(vpB.to-vpB.from))}update.geometryChanged&&(this.dom.style.minHeight=this.view.contentHeight+"px"),this.view.state.facet(unfixGutters)!=!this.fixed&&(this.fixed=!this.fixed,this.dom.style.position=this.fixed?"sticky":""),this.prevViewport=update.view.viewport}syncGutters(detach){let after=this.dom.nextSibling;detach&&this.dom.remove();let lineClasses=RangeSet.iter(this.view.state.facet(gutterLineClass),this.view.viewport.from),classSet=[],contexts=this.gutters.map((gutter=>new UpdateContext(gutter,this.view.viewport,-this.view.documentPadding.top)));for(let line of this.view.viewportLineBlocks)if(classSet.length&&(classSet=[]),Array.isArray(line.type)){let first=!0;for(let b of line.type)if(b.type==BlockType.Text&&first){advanceCursor(lineClasses,classSet,b.from);for(let cx of contexts)cx.line(this.view,b,classSet);first=!1}else if(b.widget)for(let cx of contexts)cx.widget(this.view,b)}else if(line.type==BlockType.Text){advanceCursor(lineClasses,classSet,line.from);for(let cx of contexts)cx.line(this.view,line,classSet)}for(let cx of contexts)cx.finish();detach&&this.view.scrollDOM.insertBefore(this.dom,after)}updateGutters(update){let prev=update.startState.facet(activeGutters),cur=update.state.facet(activeGutters),change=update.docChanged||update.heightChanged||update.viewportChanged||!RangeSet.eq(update.startState.facet(gutterLineClass),update.state.facet(gutterLineClass),update.view.viewport.from,update.view.viewport.to);if(prev==cur)for(let gutter of this.gutters)gutter.update(update)&&(change=!0);else{change=!0;let gutters=[];for(let conf of cur){let known=prev.indexOf(conf);known<0?gutters.push(new SingleGutterView(this.view,conf)):(this.gutters[known].update(update),gutters.push(this.gutters[known]))}for(let g of this.gutters)g.dom.remove(),gutters.indexOf(g)<0&&g.destroy();for(let g of gutters)this.dom.appendChild(g.dom);this.gutters=gutters}return change}destroy(){for(let view of this.gutters)view.destroy();this.dom.remove()}},{provide:plugin=>EditorView.scrollMargins.of((view=>{let value=view.plugin(plugin);return value&&0!=value.gutters.length&&value.fixed?view.textDirection==Direction.LTR?{left:value.dom.offsetWidth}:{right:value.dom.offsetWidth}:null}))});function asArray(val){return Array.isArray(val)?val:[val]}function advanceCursor(cursor,collect,pos){for(;cursor.value&&cursor.from<=pos;)cursor.from==pos&&collect.push(cursor.value),cursor.next()}class UpdateContext{constructor(gutter,viewport,height){this.gutter=gutter,this.height=height,this.i=0,this.cursor=RangeSet.iter(gutter.markers,viewport.from)}addElement(view,block,markers){let{gutter:gutter}=this,above=block.top-this.height;if(this.i==gutter.elements.length){let newElt=new GutterElement(view,block.height,above,markers);gutter.elements.push(newElt),gutter.dom.appendChild(newElt.dom)}else gutter.elements[this.i].update(view,block.height,above,markers);this.height=block.bottom,this.i++}line(view,line,extraMarkers){let localMarkers=[];advanceCursor(this.cursor,localMarkers,line.from),extraMarkers.length&&(localMarkers=localMarkers.concat(extraMarkers));let forLine=this.gutter.config.lineMarker(view,line,localMarkers);forLine&&localMarkers.unshift(forLine);let gutter=this.gutter;(0!=localMarkers.length||gutter.config.renderEmptyElements)&&this.addElement(view,line,localMarkers)}widget(view,block){let marker=this.gutter.config.widgetMarker(view,block.widget,block);marker&&this.addElement(view,block,[marker])}finish(){let gutter=this.gutter;for(;gutter.elements.length>this.i;){let last=gutter.elements.pop();gutter.dom.removeChild(last.dom),last.destroy()}}}class SingleGutterView{constructor(view,config){this.view=view,this.config=config,this.elements=[],this.spacer=null,this.dom=document.createElement("div"),this.dom.className="cm-gutter"+(this.config.class?" "+this.config.class:"");for(let prop in config.domEventHandlers)this.dom.addEventListener(prop,(event=>{let y,target=event.target;if(target!=this.dom&&this.dom.contains(target)){for(;target.parentNode!=this.dom;)target=target.parentNode;let rect=target.getBoundingClientRect();y=(rect.top+rect.bottom)/2}else y=event.clientY;let line=view.lineBlockAtHeight(y-view.documentTop);config.domEventHandlers[prop](view,line,event)&&event.preventDefault()}));this.markers=asArray(config.markers(view)),config.initialSpacer&&(this.spacer=new GutterElement(view,0,0,[config.initialSpacer(view)]),this.dom.appendChild(this.spacer.dom),this.spacer.dom.style.cssText+="visibility: hidden; pointer-events: none")}update(update){let prevMarkers=this.markers;if(this.markers=asArray(this.config.markers(update.view)),this.spacer&&this.config.updateSpacer){let updated=this.config.updateSpacer(this.spacer.markers[0],update);updated!=this.spacer.markers[0]&&this.spacer.update(update.view,0,0,[updated])}let vp=update.view.viewport;return!RangeSet.eq(this.markers,prevMarkers,vp.from,vp.to)||!!this.config.lineMarkerChange&&this.config.lineMarkerChange(update)}destroy(){for(let elt of this.elements)elt.destroy()}}class GutterElement{constructor(view,height,above,markers){this.height=-1,this.above=0,this.markers=[],this.dom=document.createElement("div"),this.dom.className="cm-gutterElement",this.update(view,height,above,markers)}update(view,height,above,markers){this.height!=height&&(this.dom.style.height=(this.height=height)+"px"),this.above!=above&&(this.dom.style.marginTop=(this.above=above)?above+"px":""),function(a,b){if(a.length!=b.length)return!1;for(let i=0;i<a.length;i++)if(!a[i].compare(b[i]))return!1;return!0}(this.markers,markers)||this.setMarkers(view,markers)}setMarkers(view,markers){let cls="cm-gutterElement",domPos=this.dom.firstChild;for(let iNew=0,iOld=0;;){let skipTo=iOld,marker=iNew<markers.length?markers[iNew++]:null,matched=!1;if(marker){let c=marker.elementClass;c&&(cls+=" "+c);for(let i=iOld;i<this.markers.length;i++)if(this.markers[i].compare(marker)){skipTo=i,matched=!0;break}}else skipTo=this.markers.length;for(;iOld<skipTo;){let next=this.markers[iOld++];if(next.toDOM){next.destroy(domPos);let after=domPos.nextSibling;domPos.remove(),domPos=after}}if(!marker)break;marker.toDOM&&(matched?domPos=domPos.nextSibling:this.dom.insertBefore(marker.toDOM(view),domPos)),matched&&iOld++}this.dom.className=cls,this.markers=markers}destroy(){this.setMarkers(null,[])}}const lineNumberMarkers=Facet.define(),lineNumberConfig=Facet.define({combine:values=>combineConfig(values,{formatNumber:String,domEventHandlers:{}},{domEventHandlers(a,b){let result=Object.assign({},a);for(let event in b){let exists=result[event],add=b[event];result[event]=exists?(view,line,event)=>exists(view,line,event)||add(view,line,event):add}return result}})});class NumberMarker extends GutterMarker{constructor(number){super(),this.number=number}eq(other){return this.number==other.number}toDOM(){return document.createTextNode(this.number)}}function formatNumber(view,number){return view.state.facet(lineNumberConfig).formatNumber(number,view.state)}const lineNumberGutter=activeGutters.compute([lineNumberConfig],(state=>({class:"cm-lineNumbers",renderEmptyElements:!1,markers:view=>view.state.facet(lineNumberMarkers),lineMarker:(view,line,others)=>others.some((m=>m.toDOM))?null:new NumberMarker(formatNumber(view,view.state.doc.lineAt(line.from).number)),widgetMarker:()=>null,lineMarkerChange:update=>update.startState.facet(lineNumberConfig)!=update.state.facet(lineNumberConfig),initialSpacer:view=>new NumberMarker(formatNumber(view,maxLineNumber(view.state.doc.lines))),updateSpacer(spacer,update){let max=formatNumber(update.view,maxLineNumber(update.view.state.doc.lines));return max==spacer.number?spacer:new NumberMarker(max)},domEventHandlers:state.facet(lineNumberConfig).domEventHandlers})));function lineNumbers(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return[lineNumberConfig.of(config),gutters(),lineNumberGutter]}function maxLineNumber(lines){let last=9;for(;last<lines;)last=10*last+9;return last}const activeLineGutterMarker=new class extends GutterMarker{constructor(){super(...arguments),this.elementClass="cm-activeLineGutter"}},activeLineGutterHighlighter=gutterLineClass.compute(["selection"],(state=>{let marks=[],last=-1;for(let range of state.selection.ranges){let linePos=state.doc.lineAt(range.head).from;linePos>last&&(last=linePos,marks.push(activeLineGutterMarker.range(linePos)))}return RangeSet.of(marks)}));const DefaultBufferLength=1024;let nextPropID=0;class Range{constructor(from,to){this.from=from,this.to=to}}class NodeProp{constructor(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};this.id=nextPropID++,this.perNode=!!config.perNode,this.deserialize=config.deserialize||(()=>{throw new Error("This node type doesn't define a deserialize function")})}add(match){if(this.perNode)throw new RangeError("Can't add per-node props to node types");return"function"!=typeof match&&(match=NodeType.match(match)),type=>{let result=match(type);return void 0===result?null:[this,result]}}}NodeProp.closedBy=new NodeProp({deserialize:str=>str.split(" ")}),NodeProp.openedBy=new NodeProp({deserialize:str=>str.split(" ")}),NodeProp.group=new NodeProp({deserialize:str=>str.split(" ")}),NodeProp.contextHash=new NodeProp({perNode:!0}),NodeProp.lookAhead=new NodeProp({perNode:!0}),NodeProp.mounted=new NodeProp({perNode:!0});class MountedTree{constructor(tree,overlay,parser){this.tree=tree,this.overlay=overlay,this.parser=parser}}const noProps=Object.create(null);class NodeType{constructor(name,props,id){let flags=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0;this.name=name,this.props=props,this.id=id,this.flags=flags}static define(spec){let props=spec.props&&spec.props.length?Object.create(null):noProps,flags=(spec.top?1:0)|(spec.skipped?2:0)|(spec.error?4:0)|(null==spec.name?8:0),type=new NodeType(spec.name||"",props,spec.id,flags);if(spec.props)for(let src of spec.props)if(Array.isArray(src)||(src=src(type)),src){if(src[0].perNode)throw new RangeError("Can't store a per-node prop on a node type");props[src[0].id]=src[1]}return type}prop(prop){return this.props[prop.id]}get isTop(){return(1&this.flags)>0}get isSkipped(){return(2&this.flags)>0}get isError(){return(4&this.flags)>0}get isAnonymous(){return(8&this.flags)>0}is(name){if("string"==typeof name){if(this.name==name)return!0;let group=this.prop(NodeProp.group);return!!group&&group.indexOf(name)>-1}return this.id==name}static match(map){let direct=Object.create(null);for(let prop in map)for(let name of prop.split(" "))direct[name]=map[prop];return node=>{for(let groups=node.prop(NodeProp.group),i=-1;i<(groups?groups.length:0);i++){let found=direct[i<0?node.name:groups[i]];if(found)return found}}}}NodeType.none=new NodeType("",Object.create(null),0,8);class NodeSet{constructor(types){this.types=types;for(let i=0;i<types.length;i++)if(types[i].id!=i)throw new RangeError("Node type ids should correspond to array positions when creating a node set")}extend(){let newTypes=[];for(var _len3=arguments.length,props=new Array(_len3),_key3=0;_key3<_len3;_key3++)props[_key3]=arguments[_key3];for(let type of this.types){let newProps=null;for(let source of props){let add=source(type);add&&(newProps||(newProps=Object.assign({},type.props)),newProps[add[0].id]=add[1])}newTypes.push(newProps?new NodeType(type.name,newProps,type.id,type.flags):type)}return new NodeSet(newTypes)}}const CachedNode=new WeakMap,CachedInnerNode=new WeakMap;var IterMode;!function(IterMode){IterMode[IterMode.ExcludeBuffers=1]="ExcludeBuffers",IterMode[IterMode.IncludeAnonymous=2]="IncludeAnonymous",IterMode[IterMode.IgnoreMounts=4]="IgnoreMounts",IterMode[IterMode.IgnoreOverlays=8]="IgnoreOverlays"}(IterMode||(IterMode={}));class Tree{constructor(type,children,positions,length,props){if(this.type=type,this.children=children,this.positions=positions,this.length=length,this.props=null,props&&props.length){this.props=Object.create(null);for(let[prop,value]of props)this.props["number"==typeof prop?prop:prop.id]=value}}toString(){let mounted=this.prop(NodeProp.mounted);if(mounted&&!mounted.overlay)return mounted.tree.toString();let children="";for(let ch of this.children){let str=ch.toString();str&&(children&&(children+=","),children+=str)}return this.type.name?(/\W/.test(this.type.name)&&!this.type.isError?JSON.stringify(this.type.name):this.type.name)+(children.length?"("+children+")":""):children}cursor(){let mode=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;return new TreeCursor(this.topNode,mode)}cursorAt(pos){let side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,scope=CachedNode.get(this)||this.topNode,cursor=new TreeCursor(scope);return cursor.moveTo(pos,side),CachedNode.set(this,cursor._tree),cursor}get topNode(){return new TreeNode(this,0,0,null)}resolve(pos){let side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,node=resolveNode(CachedNode.get(this)||this.topNode,pos,side,!1);return CachedNode.set(this,node),node}resolveInner(pos){let side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,node=resolveNode(CachedInnerNode.get(this)||this.topNode,pos,side,!0);return CachedInnerNode.set(this,node),node}iterate(spec){let{enter:enter,leave:leave,from:from=0,to:to=this.length}=spec,mode=spec.mode||0,anon=(mode&IterMode.IncludeAnonymous)>0;for(let c=this.cursor(mode|IterMode.IncludeAnonymous);;){let entered=!1;if(c.from<=to&&c.to>=from&&(!anon&&c.type.isAnonymous||!1!==enter(c))){if(c.firstChild())continue;entered=!0}for(;entered&&leave&&(anon||!c.type.isAnonymous)&&leave(c),!c.nextSibling();){if(!c.parent())return;entered=!0}}}prop(prop){return prop.perNode?this.props?this.props[prop.id]:void 0:this.type.prop(prop)}get propValues(){let result=[];if(this.props)for(let id in this.props)result.push([+id,this.props[id]]);return result}balance(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return this.children.length<=8?this:balanceRange(NodeType.none,this.children,this.positions,0,this.children.length,0,this.length,((children,positions,length)=>new Tree(this.type,children,positions,length,this.propValues)),config.makeTree||((children,positions,length)=>new Tree(NodeType.none,children,positions,length)))}static build(data){return function(data){var _a;let{buffer:buffer,nodeSet:nodeSet,maxBufferLength:maxBufferLength=DefaultBufferLength,reused:reused=[],minRepeatType:minRepeatType=nodeSet.types.length}=data,cursor=Array.isArray(buffer)?new FlatBufferCursor(buffer,buffer.length):buffer,types=nodeSet.types,contextHash=0,lookAhead=0;function takeNode(parentStart,minPos,children,positions,inRepeat){let{id:id,start:start,end:end,size:size}=cursor,lookAheadAtStart=lookAhead;for(;size<0;){if(cursor.next(),-1==size){let node=reused[id];return children.push(node),void positions.push(start-parentStart)}if(-3==size)return void(contextHash=id);if(-4==size)return void(lookAhead=id);throw new RangeError("Unrecognized record size: ".concat(size))}let node,buffer,type=types[id],startPos=start-parentStart;if(end-start<=maxBufferLength&&(buffer=findBufferSize(cursor.pos-minPos,inRepeat))){let data=new Uint16Array(buffer.size-buffer.skip),endPos=cursor.pos-buffer.size,index=data.length;for(;cursor.pos>endPos;)index=copyToBuffer(buffer.start,data,index);node=new TreeBuffer(data,end-buffer.start,nodeSet),startPos=buffer.start-parentStart}else{let endPos=cursor.pos-size;cursor.next();let localChildren=[],localPositions=[],localInRepeat=id>=minRepeatType?id:-1,lastGroup=0,lastEnd=end;for(;cursor.pos>endPos;)localInRepeat>=0&&cursor.id==localInRepeat&&cursor.size>=0?(cursor.end<=lastEnd-maxBufferLength&&(makeRepeatLeaf(localChildren,localPositions,start,lastGroup,cursor.end,lastEnd,localInRepeat,lookAheadAtStart),lastGroup=localChildren.length,lastEnd=cursor.end),cursor.next()):takeNode(start,endPos,localChildren,localPositions,localInRepeat);if(localInRepeat>=0&&lastGroup>0&&lastGroup<localChildren.length&&makeRepeatLeaf(localChildren,localPositions,start,lastGroup,start,lastEnd,localInRepeat,lookAheadAtStart),localChildren.reverse(),localPositions.reverse(),localInRepeat>-1&&lastGroup>0){let make=makeBalanced(type);node=balanceRange(type,localChildren,localPositions,0,localChildren.length,0,end-start,make,make)}else node=makeTree(type,localChildren,localPositions,end-start,lookAheadAtStart-end)}children.push(node),positions.push(startPos)}function makeBalanced(type){return(children,positions,length)=>{let last,lookAheadProp,lookAhead=0,lastI=children.length-1;if(lastI>=0&&(last=children[lastI])instanceof Tree){if(!lastI&&last.type==type&&last.length==length)return last;(lookAheadProp=last.prop(NodeProp.lookAhead))&&(lookAhead=positions[lastI]+last.length+lookAheadProp)}return makeTree(type,children,positions,length,lookAhead)}}function makeRepeatLeaf(children,positions,base,i,from,to,type,lookAhead){let localChildren=[],localPositions=[];for(;children.length>i;)localChildren.push(children.pop()),localPositions.push(positions.pop()+base-from);children.push(makeTree(nodeSet.types[type],localChildren,localPositions,to-from,lookAhead-to)),positions.push(from-base)}function makeTree(type,children,positions,length){let lookAhead=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,props=arguments.length>5?arguments[5]:void 0;if(contextHash){let pair=[NodeProp.contextHash,contextHash];props=props?[pair].concat(props):[pair]}if(lookAhead>25){let pair=[NodeProp.lookAhead,lookAhead];props=props?[pair].concat(props):[pair]}return new Tree(type,children,positions,length,props)}function findBufferSize(maxSize,inRepeat){let fork=cursor.fork(),size=0,start=0,skip=0,minStart=fork.end-maxBufferLength,result={size:0,start:0,skip:0};scan:for(let minPos=fork.pos-maxSize;fork.pos>minPos;){let nodeSize=fork.size;if(fork.id==inRepeat&&nodeSize>=0){result.size=size,result.start=start,result.skip=skip,skip+=4,size+=4,fork.next();continue}let startPos=fork.pos-nodeSize;if(nodeSize<0||startPos<minPos||fork.start<minStart)break;let localSkipped=fork.id>=minRepeatType?4:0,nodeStart=fork.start;for(fork.next();fork.pos>startPos;){if(fork.size<0){if(-3!=fork.size)break scan;localSkipped+=4}else fork.id>=minRepeatType&&(localSkipped+=4);fork.next()}start=nodeStart,size+=nodeSize,skip+=localSkipped}return(inRepeat<0||size==maxSize)&&(result.size=size,result.start=start,result.skip=skip),result.size>4?result:void 0}function copyToBuffer(bufferStart,buffer,index){let{id:id,start:start,end:end,size:size}=cursor;if(cursor.next(),size>=0&&id<minRepeatType){let startIndex=index;if(size>4){let endPos=cursor.pos-(size-4);for(;cursor.pos>endPos;)index=copyToBuffer(bufferStart,buffer,index)}buffer[--index]=startIndex,buffer[--index]=end-bufferStart,buffer[--index]=start-bufferStart,buffer[--index]=id}else-3==size?contextHash=id:-4==size&&(lookAhead=id);return index}let children=[],positions=[];for(;cursor.pos>0;)takeNode(data.start||0,data.bufferStart||0,children,positions,-1);let length=null!==(_a=data.length)&&void 0!==_a?_a:children.length?positions[0]+children[0].length:0;return new Tree(types[data.topID],children.reverse(),positions.reverse(),length)}(data)}}Tree.empty=new Tree(NodeType.none,[],[],0);class FlatBufferCursor{constructor(buffer,index){this.buffer=buffer,this.index=index}get id(){return this.buffer[this.index-4]}get start(){return this.buffer[this.index-3]}get end(){return this.buffer[this.index-2]}get size(){return this.buffer[this.index-1]}get pos(){return this.index}next(){this.index-=4}fork(){return new FlatBufferCursor(this.buffer,this.index)}}class TreeBuffer{constructor(buffer,length,set){this.buffer=buffer,this.length=length,this.set=set}get type(){return NodeType.none}toString(){let result=[];for(let index=0;index<this.buffer.length;)result.push(this.childString(index)),index=this.buffer[index+3];return result.join(",")}childString(index){let id=this.buffer[index],endIndex=this.buffer[index+3],type=this.set.types[id],result=type.name;if(/\W/.test(result)&&!type.isError&&(result=JSON.stringify(result)),endIndex==(index+=4))return result;let children=[];for(;index<endIndex;)children.push(this.childString(index)),index=this.buffer[index+3];return result+"("+children.join(",")+")"}findChild(startIndex,endIndex,dir,pos,side){let{buffer:buffer}=this,pick=-1;for(let i=startIndex;i!=endIndex&&!(checkSide(side,pos,buffer[i+1],buffer[i+2])&&(pick=i,dir>0));i=buffer[i+3]);return pick}slice(startI,endI,from){let b=this.buffer,copy=new Uint16Array(endI-startI),len=0;for(let i=startI,j=0;i<endI;){copy[j++]=b[i++],copy[j++]=b[i++]-from;let to=copy[j++]=b[i++]-from;copy[j++]=b[i++]-startI,len=Math.max(len,to)}return new TreeBuffer(copy,len,this.set)}}function checkSide(side,pos,from,to){switch(side){case-2:return from<pos;case-1:return to>=pos&&from<pos;case 0:return from<pos&&to>pos;case 1:return from<=pos&&to>pos;case 2:return to>pos;case 4:return!0}}function enterUnfinishedNodesBefore(node,pos){let scan=node.childBefore(pos);for(;scan;){let last=scan.lastChild;if(!last||last.to!=scan.to)break;last.type.isError&&last.from==last.to?(node=scan,scan=last.prevSibling):scan=last}return node}function resolveNode(node,pos,side,overlays){for(var _a;node.from==node.to||(side<1?node.from>=pos:node.from>pos)||(side>-1?node.to<=pos:node.to<pos);){let parent=!overlays&&node instanceof TreeNode&&node.index<0?null:node.parent;if(!parent)return node;node=parent}let mode=overlays?0:IterMode.IgnoreOverlays;if(overlays)for(let scan=node,parent=scan.parent;parent;scan=parent,parent=scan.parent)scan instanceof TreeNode&&scan.index<0&&(null===(_a=parent.enter(pos,side,mode))||void 0===_a?void 0:_a.from)!=scan.from&&(node=parent);for(;;){let inner=node.enter(pos,side,mode);if(!inner)return node;node=inner}}class TreeNode{constructor(_tree,from,index,_parent){this._tree=_tree,this.from=from,this.index=index,this._parent=_parent}get type(){return this._tree.type}get name(){return this._tree.type.name}get to(){return this.from+this._tree.length}nextChild(i,dir,pos,side){let mode=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0;for(let parent=this;;){for(let{children:children,positions:positions}=parent._tree,e=dir>0?children.length:-1;i!=e;i+=dir){let next=children[i],start=positions[i]+parent.from;if(checkSide(side,pos,start,start+next.length))if(next instanceof TreeBuffer){if(mode&IterMode.ExcludeBuffers)continue;let index=next.findChild(0,next.buffer.length,dir,pos-start,side);if(index>-1)return new BufferNode(new BufferContext(parent,next,i,start),null,index)}else if(mode&IterMode.IncludeAnonymous||!next.type.isAnonymous||hasChild(next)){let mounted;if(!(mode&IterMode.IgnoreMounts)&&next.props&&(mounted=next.prop(NodeProp.mounted))&&!mounted.overlay)return new TreeNode(mounted.tree,start,i,parent);let inner=new TreeNode(next,start,i,parent);return mode&IterMode.IncludeAnonymous||!inner.type.isAnonymous?inner:inner.nextChild(dir<0?next.children.length-1:0,dir,pos,side)}}if(mode&IterMode.IncludeAnonymous||!parent.type.isAnonymous)return null;if(i=parent.index>=0?parent.index+dir:dir<0?-1:parent._parent._tree.children.length,parent=parent._parent,!parent)return null}}get firstChild(){return this.nextChild(0,1,0,4)}get lastChild(){return this.nextChild(this._tree.children.length-1,-1,0,4)}childAfter(pos){return this.nextChild(0,1,pos,2)}childBefore(pos){return this.nextChild(this._tree.children.length-1,-1,pos,-2)}enter(pos,side){let mounted,mode=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;if(!(mode&IterMode.IgnoreOverlays)&&(mounted=this._tree.prop(NodeProp.mounted))&&mounted.overlay){let rPos=pos-this.from;for(let{from:from,to:to}of mounted.overlay)if((side>0?from<=rPos:from<rPos)&&(side<0?to>=rPos:to>rPos))return new TreeNode(mounted.tree,mounted.overlay[0].from+this.from,-1,this)}return this.nextChild(0,1,pos,side,mode)}nextSignificantParent(){let val=this;for(;val.type.isAnonymous&&val._parent;)val=val._parent;return val}get parent(){return this._parent?this._parent.nextSignificantParent():null}get nextSibling(){return this._parent&&this.index>=0?this._parent.nextChild(this.index+1,1,0,4):null}get prevSibling(){return this._parent&&this.index>=0?this._parent.nextChild(this.index-1,-1,0,4):null}cursor(){return new TreeCursor(this,arguments.length>0&&void 0!==arguments[0]?arguments[0]:0)}get tree(){return this._tree}toTree(){return this._tree}resolve(pos){return resolveNode(this,pos,arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,!1)}resolveInner(pos){return resolveNode(this,pos,arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,!0)}enterUnfinishedNodesBefore(pos){return enterUnfinishedNodesBefore(this,pos)}getChild(type){let r=getChildren(this,type,arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,arguments.length>2&&void 0!==arguments[2]?arguments[2]:null);return r.length?r[0]:null}getChildren(type){return getChildren(this,type,arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,arguments.length>2&&void 0!==arguments[2]?arguments[2]:null)}toString(){return this._tree.toString()}get node(){return this}matchContext(context){return matchNodeContext(this,context)}}function getChildren(node,type,before,after){let cur=node.cursor(),result=[];if(!cur.firstChild())return result;if(null!=before)for(;!cur.type.is(before);)if(!cur.nextSibling())return result;for(;;){if(null!=after&&cur.type.is(after))return result;if(cur.type.is(type)&&result.push(cur.node),!cur.nextSibling())return null==after?result:[]}}function matchNodeContext(node,context){let i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:context.length-1;for(let p=node.parent;i>=0;p=p.parent){if(!p)return!1;if(!p.type.isAnonymous){if(context[i]&&context[i]!=p.name)return!1;i--}}return!0}class BufferContext{constructor(parent,buffer,index,start){this.parent=parent,this.buffer=buffer,this.index=index,this.start=start}}class BufferNode{get name(){return this.type.name}get from(){return this.context.start+this.context.buffer.buffer[this.index+1]}get to(){return this.context.start+this.context.buffer.buffer[this.index+2]}constructor(context,_parent,index){this.context=context,this._parent=_parent,this.index=index,this.type=context.buffer.set.types[context.buffer.buffer[index]]}child(dir,pos,side){let{buffer:buffer}=this.context,index=buffer.findChild(this.index+4,buffer.buffer[this.index+3],dir,pos-this.context.start,side);return index<0?null:new BufferNode(this.context,this,index)}get firstChild(){return this.child(1,0,4)}get lastChild(){return this.child(-1,0,4)}childAfter(pos){return this.child(1,pos,2)}childBefore(pos){return this.child(-1,pos,-2)}enter(pos,side){if((arguments.length>2&&void 0!==arguments[2]?arguments[2]:0)&IterMode.ExcludeBuffers)return null;let{buffer:buffer}=this.context,index=buffer.findChild(this.index+4,buffer.buffer[this.index+3],side>0?1:-1,pos-this.context.start,side);return index<0?null:new BufferNode(this.context,this,index)}get parent(){return this._parent||this.context.parent.nextSignificantParent()}externalSibling(dir){return this._parent?null:this.context.parent.nextChild(this.context.index+dir,dir,0,4)}get nextSibling(){let{buffer:buffer}=this.context,after=buffer.buffer[this.index+3];return after<(this._parent?buffer.buffer[this._parent.index+3]:buffer.buffer.length)?new BufferNode(this.context,this._parent,after):this.externalSibling(1)}get prevSibling(){let{buffer:buffer}=this.context,parentStart=this._parent?this._parent.index+4:0;return this.index==parentStart?this.externalSibling(-1):new BufferNode(this.context,this._parent,buffer.findChild(parentStart,this.index,-1,0,4))}cursor(){return new TreeCursor(this,arguments.length>0&&void 0!==arguments[0]?arguments[0]:0)}get tree(){return null}toTree(){let children=[],positions=[],{buffer:buffer}=this.context,startI=this.index+4,endI=buffer.buffer[this.index+3];if(endI>startI){let from=buffer.buffer[this.index+1];children.push(buffer.slice(startI,endI,from)),positions.push(0)}return new Tree(this.type,children,positions,this.to-this.from)}resolve(pos){return resolveNode(this,pos,arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,!1)}resolveInner(pos){return resolveNode(this,pos,arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,!0)}enterUnfinishedNodesBefore(pos){return enterUnfinishedNodesBefore(this,pos)}toString(){return this.context.buffer.childString(this.index)}getChild(type){let r=getChildren(this,type,arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,arguments.length>2&&void 0!==arguments[2]?arguments[2]:null);return r.length?r[0]:null}getChildren(type){return getChildren(this,type,arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,arguments.length>2&&void 0!==arguments[2]?arguments[2]:null)}get node(){return this}matchContext(context){return matchNodeContext(this,context)}}class TreeCursor{get name(){return this.type.name}constructor(node){let mode=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;if(this.mode=mode,this.buffer=null,this.stack=[],this.index=0,this.bufferNode=null,node instanceof TreeNode)this.yieldNode(node);else{this._tree=node.context.parent,this.buffer=node.context;for(let n=node._parent;n;n=n._parent)this.stack.unshift(n.index);this.bufferNode=node,this.yieldBuf(node.index)}}yieldNode(node){return!!node&&(this._tree=node,this.type=node.type,this.from=node.from,this.to=node.to,!0)}yieldBuf(index,type){this.index=index;let{start:start,buffer:buffer}=this.buffer;return this.type=type||buffer.set.types[buffer.buffer[index]],this.from=start+buffer.buffer[index+1],this.to=start+buffer.buffer[index+2],!0}yield(node){return!!node&&(node instanceof TreeNode?(this.buffer=null,this.yieldNode(node)):(this.buffer=node.context,this.yieldBuf(node.index,node.type)))}toString(){return this.buffer?this.buffer.buffer.childString(this.index):this._tree.toString()}enterChild(dir,pos,side){if(!this.buffer)return this.yield(this._tree.nextChild(dir<0?this._tree._tree.children.length-1:0,dir,pos,side,this.mode));let{buffer:buffer}=this.buffer,index=buffer.findChild(this.index+4,buffer.buffer[this.index+3],dir,pos-this.buffer.start,side);return!(index<0)&&(this.stack.push(this.index),this.yieldBuf(index))}firstChild(){return this.enterChild(1,0,4)}lastChild(){return this.enterChild(-1,0,4)}childAfter(pos){return this.enterChild(1,pos,2)}childBefore(pos){return this.enterChild(-1,pos,-2)}enter(pos,side){let mode=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.mode;return this.buffer?!(mode&IterMode.ExcludeBuffers)&&this.enterChild(1,pos,side):this.yield(this._tree.enter(pos,side,mode))}parent(){if(!this.buffer)return this.yieldNode(this.mode&IterMode.IncludeAnonymous?this._tree._parent:this._tree.parent);if(this.stack.length)return this.yieldBuf(this.stack.pop());let parent=this.mode&IterMode.IncludeAnonymous?this.buffer.parent:this.buffer.parent.nextSignificantParent();return this.buffer=null,this.yieldNode(parent)}sibling(dir){if(!this.buffer)return!!this._tree._parent&&this.yield(this._tree.index<0?null:this._tree._parent.nextChild(this._tree.index+dir,dir,0,4,this.mode));let{buffer:buffer}=this.buffer,d=this.stack.length-1;if(dir<0){let parentStart=d<0?0:this.stack[d]+4;if(this.index!=parentStart)return this.yieldBuf(buffer.findChild(parentStart,this.index,-1,0,4))}else{let after=buffer.buffer[this.index+3];if(after<(d<0?buffer.buffer.length:buffer.buffer[this.stack[d]+3]))return this.yieldBuf(after)}return d<0&&this.yield(this.buffer.parent.nextChild(this.buffer.index+dir,dir,0,4,this.mode))}nextSibling(){return this.sibling(1)}prevSibling(){return this.sibling(-1)}atLastNode(dir){let index,parent,{buffer:buffer}=this;if(buffer){if(dir>0){if(this.index<buffer.buffer.buffer.length)return!1}else for(let i=0;i<this.index;i++)if(buffer.buffer.buffer[i+3]<this.index)return!1;({index:index,parent:parent}=buffer)}else({index:index,_parent:parent}=this._tree);for(;parent;({index:index,_parent:parent}=parent))if(index>-1)for(let i=index+dir,e=dir<0?-1:parent._tree.children.length;i!=e;i+=dir){let child=parent._tree.children[i];if(this.mode&IterMode.IncludeAnonymous||child instanceof TreeBuffer||!child.type.isAnonymous||hasChild(child))return!1}return!0}move(dir,enter){if(enter&&this.enterChild(dir,0,4))return!0;for(;;){if(this.sibling(dir))return!0;if(this.atLastNode(dir)||!this.parent())return!1}}next(){let enter=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];return this.move(1,enter)}prev(){let enter=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];return this.move(-1,enter)}moveTo(pos){let side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;for(;(this.from==this.to||(side<1?this.from>=pos:this.from>pos)||(side>-1?this.to<=pos:this.to<pos))&&this.parent(););for(;this.enterChild(1,pos,side););return this}get node(){if(!this.buffer)return this._tree;let cache=this.bufferNode,result=null,depth=0;if(cache&&cache.context==this.buffer)scan:for(let index=this.index,d=this.stack.length;d>=0;){for(let c=cache;c;c=c._parent)if(c.index==index){if(index==this.index)return c;result=c,depth=d+1;break scan}index=this.stack[--d]}for(let i=depth;i<this.stack.length;i++)result=new BufferNode(this.buffer,result,this.stack[i]);return this.bufferNode=new BufferNode(this.buffer,result,this.index)}get tree(){return this.buffer?null:this._tree._tree}iterate(enter,leave){for(let depth=0;;){let mustLeave=!1;if(this.type.isAnonymous||!1!==enter(this)){if(this.firstChild()){depth++;continue}this.type.isAnonymous||(mustLeave=!0)}for(;mustLeave&&leave&&leave(this),mustLeave=this.type.isAnonymous,!this.nextSibling();){if(!depth)return;this.parent(),depth--,mustLeave=!0}}}matchContext(context){if(!this.buffer)return matchNodeContext(this.node,context);let{buffer:buffer}=this.buffer,{types:types}=buffer.set;for(let i=context.length-1,d=this.stack.length-1;i>=0;d--){if(d<0)return matchNodeContext(this.node,context,i);let type=types[buffer.buffer[this.stack[d]]];if(!type.isAnonymous){if(context[i]&&context[i]!=type.name)return!1;i--}}return!0}}function hasChild(tree){return tree.children.some((ch=>ch instanceof TreeBuffer||!ch.type.isAnonymous||hasChild(ch)))}const nodeSizeCache=new WeakMap;function nodeSize(balanceType,node){if(!balanceType.isAnonymous||node instanceof TreeBuffer||node.type!=balanceType)return 1;let size=nodeSizeCache.get(node);if(null==size){size=1;for(let child of node.children){if(child.type!=balanceType||!(child instanceof Tree)){size=1;break}size+=nodeSize(balanceType,child)}nodeSizeCache.set(node,size)}return size}function balanceRange(balanceType,children,positions,from,to,start,length,mkTop,mkTree){let total=0;for(let i=from;i<to;i++)total+=nodeSize(balanceType,children[i]);let maxChild=Math.ceil(1.5*total/8),localChildren=[],localPositions=[];return function divide(children,positions,from,to,offset){for(let i=from;i<to;){let groupFrom=i,groupStart=positions[i],groupSize=nodeSize(balanceType,children[i]);for(i++;i<to;i++){let nextSize=nodeSize(balanceType,children[i]);if(groupSize+nextSize>=maxChild)break;groupSize+=nextSize}if(i==groupFrom+1){if(groupSize>maxChild){let only=children[groupFrom];divide(only.children,only.positions,0,only.children.length,positions[groupFrom]+offset);continue}localChildren.push(children[groupFrom])}else{let length=positions[i-1]+children[i-1].length-groupStart;localChildren.push(balanceRange(balanceType,children,positions,groupFrom,i,groupStart,length,null,mkTree))}localPositions.push(groupStart+offset-start)}}(children,positions,from,to,0),(mkTop||mkTree)(localChildren,localPositions,length)}class NodeWeakMap{constructor(){this.map=new WeakMap}setBuffer(buffer,index,value){let inner=this.map.get(buffer);inner||this.map.set(buffer,inner=new Map),inner.set(index,value)}getBuffer(buffer,index){let inner=this.map.get(buffer);return inner&&inner.get(index)}set(node,value){node instanceof BufferNode?this.setBuffer(node.context.buffer,node.index,value):node instanceof TreeNode&&this.map.set(node.tree,value)}get(node){return node instanceof BufferNode?this.getBuffer(node.context.buffer,node.index):node instanceof TreeNode?this.map.get(node.tree):void 0}cursorSet(cursor,value){cursor.buffer?this.setBuffer(cursor.buffer.buffer,cursor.index,value):this.map.set(cursor.tree,value)}cursorGet(cursor){return cursor.buffer?this.getBuffer(cursor.buffer.buffer,cursor.index):this.map.get(cursor.tree)}}class TreeFragment{constructor(from,to,tree,offset){let openStart=arguments.length>4&&void 0!==arguments[4]&&arguments[4],openEnd=arguments.length>5&&void 0!==arguments[5]&&arguments[5];this.from=from,this.to=to,this.tree=tree,this.offset=offset,this.open=(openStart?1:0)|(openEnd?2:0)}get openStart(){return(1&this.open)>0}get openEnd(){return(2&this.open)>0}static addTree(tree){let fragments=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],partial=arguments.length>2&&void 0!==arguments[2]&&arguments[2],result=[new TreeFragment(0,tree.length,tree,0,!1,partial)];for(let f of fragments)f.to>tree.length&&result.push(f);return result}static applyChanges(fragments,changes){let minGap=arguments.length>2&&void 0!==arguments[2]?arguments[2]:128;if(!changes.length)return fragments;let result=[],fI=1,nextF=fragments.length?fragments[0]:null;for(let cI=0,pos=0,off=0;;cI++){let nextC=cI<changes.length?changes[cI]:null,nextPos=nextC?nextC.fromA:1e9;if(nextPos-pos>=minGap)for(;nextF&&nextF.from<nextPos;){let cut=nextF;if(pos>=cut.from||nextPos<=cut.to||off){let fFrom=Math.max(cut.from,pos)-off,fTo=Math.min(cut.to,nextPos)-off;cut=fFrom>=fTo?null:new TreeFragment(fFrom,fTo,cut.tree,cut.offset+off,cI>0,!!nextC)}if(cut&&result.push(cut),nextF.to>nextPos)break;nextF=fI<fragments.length?fragments[fI++]:null}if(!nextC)break;pos=nextC.toA,off=nextC.toA-nextC.toB}return result}}class Parser{startParse(input,fragments,ranges){return"string"==typeof input&&(input=new StringInput(input)),ranges=ranges?ranges.length?ranges.map((r=>new Range(r.from,r.to))):[new Range(0,0)]:[new Range(0,input.length)],this.createParse(input,fragments||[],ranges)}parse(input,fragments,ranges){let parse=this.startParse(input,fragments,ranges);for(;;){let done=parse.advance();if(done)return done}}}class StringInput{constructor(string){this.string=string}get length(){return this.string.length}chunk(from){return this.string.slice(from)}get lineChunks(){return!1}read(from,to){return this.string.slice(from,to)}}function parseMixed(nest){return(parse,input,fragments,ranges)=>new MixedParse(parse,nest,input,fragments,ranges)}class InnerParse{constructor(parser,parse,overlay,target,ranges){if(this.parser=parser,this.parse=parse,this.overlay=overlay,this.target=target,this.ranges=ranges,!ranges.length||ranges.some((r=>r.from>=r.to)))throw new RangeError("Invalid inner parse ranges given: "+JSON.stringify(ranges))}}class ActiveOverlay{constructor(parser,predicate,mounts,index,start,target,prev){this.parser=parser,this.predicate=predicate,this.mounts=mounts,this.index=index,this.start=start,this.target=target,this.prev=prev,this.depth=0,this.ranges=[]}}const stoppedInner=new NodeProp({perNode:!0});class MixedParse{constructor(base,nest,input,fragments,ranges){this.nest=nest,this.input=input,this.fragments=fragments,this.ranges=ranges,this.inner=[],this.innerDone=0,this.baseTree=null,this.stoppedAt=null,this.baseParse=base}advance(){if(this.baseParse){let done=this.baseParse.advance();if(!done)return null;if(this.baseParse=null,this.baseTree=done,this.startInner(),null!=this.stoppedAt)for(let inner of this.inner)inner.parse.stopAt(this.stoppedAt)}if(this.innerDone==this.inner.length){let result=this.baseTree;return null!=this.stoppedAt&&(result=new Tree(result.type,result.children,result.positions,result.length,result.propValues.concat([[stoppedInner,this.stoppedAt]]))),result}let inner=this.inner[this.innerDone],done=inner.parse.advance();if(done){this.innerDone++;let props=Object.assign(Object.create(null),inner.target.props);props[NodeProp.mounted.id]=new MountedTree(done,inner.overlay,inner.parser),inner.target.props=props}return null}get parsedPos(){if(this.baseParse)return 0;let pos=this.input.length;for(let i=this.innerDone;i<this.inner.length;i++)this.inner[i].ranges[0].from<pos&&(pos=Math.min(pos,this.inner[i].parse.parsedPos));return pos}stopAt(pos){if(this.stoppedAt=pos,this.baseParse)this.baseParse.stopAt(pos);else for(let i=this.innerDone;i<this.inner.length;i++)this.inner[i].parse.stopAt(pos)}startInner(){let fragmentCursor=new FragmentCursor$1(this.fragments),overlay=null,covered=null,cursor=new TreeCursor(new TreeNode(this.baseTree,this.ranges[0].from,0,null),IterMode.IncludeAnonymous|IterMode.IgnoreMounts);scan:for(let nest,isCovered;null==this.stoppedAt||cursor.from<this.stoppedAt;){let range,enter=!0;if(fragmentCursor.hasNode(cursor)){if(overlay){let match=overlay.mounts.find((m=>m.frag.from<=cursor.from&&m.frag.to>=cursor.to&&m.mount.overlay));if(match)for(let r of match.mount.overlay){let from=r.from+match.pos,to=r.to+match.pos;from>=cursor.from&&to<=cursor.to&&!overlay.ranges.some((r=>r.from<to&&r.to>from))&&overlay.ranges.push({from:from,to:to})}}enter=!1}else if(covered&&(isCovered=checkCover(covered.ranges,cursor.from,cursor.to)))enter=2!=isCovered;else if(!cursor.type.isAnonymous&&cursor.from<cursor.to&&(nest=this.nest(cursor,this.input))){cursor.tree||materialize(cursor);let oldMounts=fragmentCursor.findMounts(cursor.from,nest.parser);if("function"==typeof nest.overlay)overlay=new ActiveOverlay(nest.parser,nest.overlay,oldMounts,this.inner.length,cursor.from,cursor.tree,overlay);else{let ranges=punchRanges(this.ranges,nest.overlay||[new Range(cursor.from,cursor.to)]);ranges.length&&this.inner.push(new InnerParse(nest.parser,nest.parser.startParse(this.input,enterFragments(oldMounts,ranges),ranges),nest.overlay?nest.overlay.map((r=>new Range(r.from-cursor.from,r.to-cursor.from))):null,cursor.tree,ranges)),nest.overlay?ranges.length&&(covered={ranges:ranges,depth:0,prev:covered}):enter=!1}}else overlay&&(range=overlay.predicate(cursor))&&(!0===range&&(range=new Range(cursor.from,cursor.to)),range.from<range.to&&overlay.ranges.push(range));if(enter&&cursor.firstChild())overlay&&overlay.depth++,covered&&covered.depth++;else for(;!cursor.nextSibling();){if(!cursor.parent())break scan;if(overlay&&!--overlay.depth){let ranges=punchRanges(this.ranges,overlay.ranges);ranges.length&&this.inner.splice(overlay.index,0,new InnerParse(overlay.parser,overlay.parser.startParse(this.input,enterFragments(overlay.mounts,ranges),ranges),overlay.ranges.map((r=>new Range(r.from-overlay.start,r.to-overlay.start))),overlay.target,ranges)),overlay=overlay.prev}covered&&!--covered.depth&&(covered=covered.prev)}}}}function checkCover(covered,from,to){for(let range of covered){if(range.from>=to)break;if(range.to>from)return range.from<=from&&range.to>=to?2:1}return 0}function sliceBuf(buf,startI,endI,nodes,positions,off){if(startI<endI){let from=buf.buffer[startI+1];nodes.push(buf.slice(startI,endI,from)),positions.push(from-off)}}function materialize(cursor){let{node:node}=cursor,depth=0;do{cursor.parent(),depth++}while(!cursor.tree);let i=0,base=cursor.tree,off=0;for(;off=base.positions[i]+cursor.from,!(off<=node.from&&off+base.children[i].length>=node.to);i++);let buf=base.children[i],b=buf.buffer;base.children[i]=function split(startI,endI,type,innerOffset,length){let i=startI;for(;b[i+2]+off<=node.from;)i=b[i+3];let children=[],positions=[];sliceBuf(buf,startI,i,children,positions,innerOffset);let from=b[i+1],to=b[i+2],isTarget=from+off==node.from&&to+off==node.to&&b[i]==node.type.id;return children.push(isTarget?node.toTree():split(i+4,b[i+3],buf.set.types[b[i]],from,to-from)),positions.push(from-innerOffset),sliceBuf(buf,b[i+3],endI,children,positions,innerOffset),new Tree(type,children,positions,length)}(0,b.length,NodeType.none,0,buf.length);for(let d=0;d<=depth;d++)cursor.childAfter(node.from)}class StructureCursor{constructor(root,offset){this.offset=offset,this.done=!1,this.cursor=root.cursor(IterMode.IncludeAnonymous|IterMode.IgnoreMounts)}moveTo(pos){let{cursor:cursor}=this,p=pos-this.offset;for(;!this.done&&cursor.from<p;)cursor.to>=pos&&cursor.enter(p,1,IterMode.IgnoreOverlays|IterMode.ExcludeBuffers)||cursor.next(!1)||(this.done=!0)}hasNode(cursor){if(this.moveTo(cursor.from),!this.done&&this.cursor.from+this.offset==cursor.from&&this.cursor.tree)for(let tree=this.cursor.tree;;){if(tree==cursor.tree)return!0;if(!(tree.children.length&&0==tree.positions[0]&&tree.children[0]instanceof Tree))break;tree=tree.children[0]}return!1}}let FragmentCursor$1=class{constructor(fragments){var _a;if(this.fragments=fragments,this.curTo=0,this.fragI=0,fragments.length){let first=this.curFrag=fragments[0];this.curTo=null!==(_a=first.tree.prop(stoppedInner))&&void 0!==_a?_a:first.to,this.inner=new StructureCursor(first.tree,-first.offset)}else this.curFrag=this.inner=null}hasNode(node){for(;this.curFrag&&node.from>=this.curTo;)this.nextFrag();return this.curFrag&&this.curFrag.from<=node.from&&this.curTo>=node.to&&this.inner.hasNode(node)}nextFrag(){var _a;if(this.fragI++,this.fragI==this.fragments.length)this.curFrag=this.inner=null;else{let frag=this.curFrag=this.fragments[this.fragI];this.curTo=null!==(_a=frag.tree.prop(stoppedInner))&&void 0!==_a?_a:frag.to,this.inner=new StructureCursor(frag.tree,-frag.offset)}}findMounts(pos,parser){var _a;let result=[];if(this.inner){this.inner.cursor.moveTo(pos,1);for(let pos=this.inner.cursor.node;pos;pos=pos.parent){let mount=null===(_a=pos.tree)||void 0===_a?void 0:_a.prop(NodeProp.mounted);if(mount&&mount.parser==parser)for(let i=this.fragI;i<this.fragments.length;i++){let frag=this.fragments[i];if(frag.from>=pos.to)break;frag.tree==this.curFrag.tree&&result.push({frag:frag,pos:pos.from-frag.offset,mount:mount})}}}return result}};function punchRanges(outer,ranges){let copy=null,current=ranges;for(let i=1,j=0;i<outer.length;i++){let gapFrom=outer[i-1].to,gapTo=outer[i].from;for(;j<current.length;j++){let r=current[j];if(r.from>=gapTo)break;r.to<=gapFrom||(copy||(current=copy=ranges.slice()),r.from<gapFrom?(copy[j]=new Range(r.from,gapFrom),r.to>gapTo&&copy.splice(j+1,0,new Range(gapTo,r.to))):r.to>gapTo?copy[j--]=new Range(gapTo,r.to):copy.splice(j--,1))}}return current}function findCoverChanges(a,b,from,to){let iA=0,iB=0,inA=!1,inB=!1,pos=-1e9,result=[];for(;;){let nextA=iA==a.length?1e9:inA?a[iA].to:a[iA].from,nextB=iB==b.length?1e9:inB?b[iB].to:b[iB].from;if(inA!=inB){let start=Math.max(pos,from),end=Math.min(nextA,nextB,to);start<end&&result.push(new Range(start,end))}if(pos=Math.min(nextA,nextB),1e9==pos)break;nextA==pos&&(inA?(inA=!1,iA++):inA=!0),nextB==pos&&(inB?(inB=!1,iB++):inB=!0)}return result}function enterFragments(mounts,ranges){let result=[];for(let{pos:pos,mount:mount,frag:frag}of mounts){let startPos=pos+(mount.overlay?mount.overlay[0].from:0),endPos=startPos+mount.tree.length,from=Math.max(frag.from,startPos),to=Math.min(frag.to,endPos);if(mount.overlay){let changes=findCoverChanges(ranges,mount.overlay.map((r=>new Range(r.from+pos,r.to+pos))),from,to);for(let i=0,pos=from;;i++){let last=i==changes.length,end=last?to:changes[i].from;if(end>pos&&result.push(new TreeFragment(pos,end,mount.tree,-startPos,frag.from>=pos||frag.openStart,frag.to<=end||frag.openEnd)),last)break;pos=changes[i].to}}else result.push(new TreeFragment(from,to,mount.tree,-startPos,frag.from>=startPos||frag.openStart,frag.to<=endPos||frag.openEnd))}return result}let nextTagID=0;class Tag{constructor(set,base,modified){this.set=set,this.base=base,this.modified=modified,this.id=nextTagID++}static define(parent){if(null==parent?void 0:parent.base)throw new Error("Can not derive from a modified tag");let tag=new Tag([],null,[]);if(tag.set.push(tag),parent)for(let t of parent.set)tag.set.push(t);return tag}static defineModifier(){let mod=new Modifier;return tag=>tag.modified.indexOf(mod)>-1?tag:Modifier.get(tag.base||tag,tag.modified.concat(mod).sort(((a,b)=>a.id-b.id)))}}let nextModifierID=0;class Modifier{constructor(){this.instances=[],this.id=nextModifierID++}static get(base,mods){if(!mods.length)return base;let exists=mods[0].instances.find((t=>{return t.base==base&&(a=mods,b=t.modified,a.length==b.length&&a.every(((x,i)=>x==b[i])));var a,b}));if(exists)return exists;let set=[],tag=new Tag(set,base,mods);for(let m of mods)m.instances.push(tag);let configs=function(array){let sets=[[]];for(let i=0;i<array.length;i++)for(let j=0,e=sets.length;j<e;j++)sets.push(sets[j].concat(array[i]));return sets.sort(((a,b)=>b.length-a.length))}(mods);for(let parent of base.set)if(!parent.modified.length)for(let config of configs)set.push(Modifier.get(parent,config));return tag}}function styleTags(spec){let byName=Object.create(null);for(let prop in spec){let tags=spec[prop];Array.isArray(tags)||(tags=[tags]);for(let part of prop.split(" "))if(part){let pieces=[],mode=2,rest=part;for(let pos=0;;){if("..."==rest&&pos>0&&pos+3==part.length){mode=1;break}let m=/^"(?:[^"\\]|\\.)*?"|[^\/!]+/.exec(rest);if(!m)throw new RangeError("Invalid path: "+part);if(pieces.push("*"==m[0]?"":'"'==m[0][0]?JSON.parse(m[0]):m[0]),pos+=m[0].length,pos==part.length)break;let next=part[pos++];if(pos==part.length&&"!"==next){mode=0;break}if("/"!=next)throw new RangeError("Invalid path: "+part);rest=part.slice(pos)}let last=pieces.length-1,inner=pieces[last];if(!inner)throw new RangeError("Invalid path: "+part);let rule=new Rule(tags,mode,last>0?pieces.slice(0,last):null);byName[inner]=rule.sort(byName[inner])}}return ruleNodeProp.add(byName)}const ruleNodeProp=new NodeProp;class Rule{constructor(tags,mode,context,next){this.tags=tags,this.mode=mode,this.context=context,this.next=next}get opaque(){return 0==this.mode}get inherit(){return 1==this.mode}sort(other){return!other||other.depth<this.depth?(this.next=other,this):(other.next=this.sort(other.next),other)}get depth(){return this.context?this.context.length:0}}function tagHighlighter(tags,options){let map=Object.create(null);for(let style of tags)if(Array.isArray(style.tag))for(let tag of style.tag)map[tag.id]=style.class;else map[style.tag.id]=style.class;let{scope:scope,all:all=null}=options||{};return{style:tags=>{let cls=all;for(let tag of tags)for(let sub of tag.set){let tagClass=map[sub.id];if(tagClass){cls=cls?cls+" "+tagClass:tagClass;break}}return cls},scope:scope}}function highlightTree(tree,highlighter,putStyle){let from=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,to=arguments.length>4&&void 0!==arguments[4]?arguments[4]:tree.length,builder=new HighlightBuilder(from,Array.isArray(highlighter)?highlighter:[highlighter],putStyle);builder.highlightRange(tree.cursor(),from,to,"",builder.highlighters),builder.flush(to)}Rule.empty=new Rule([],2,null);class HighlightBuilder{constructor(at,highlighters,span){this.at=at,this.highlighters=highlighters,this.span=span,this.class=""}startSpan(at,cls){cls!=this.class&&(this.flush(at),at>this.at&&(this.at=at),this.class=cls)}flush(to){to>this.at&&this.class&&this.span(this.at,to,this.class)}highlightRange(cursor,from,to,inheritedClass,highlighters){let{type:type,from:start,to:end}=cursor;if(start>=to||end<=from)return;type.isTop&&(highlighters=this.highlighters.filter((h=>!h.scope||h.scope(type))));let cls=inheritedClass,rule=function(node){let rule=node.type.prop(ruleNodeProp);for(;rule&&rule.context&&!node.matchContext(rule.context);)rule=rule.next;return rule||null}(cursor)||Rule.empty,tagCls=function(highlighters,tags){let result=null;for(let highlighter of highlighters){let value=highlighter.style(tags);value&&(result=result?result+" "+value:value)}return result}(highlighters,rule.tags);if(tagCls&&(cls&&(cls+=" "),cls+=tagCls,1==rule.mode&&(inheritedClass+=(inheritedClass?" ":"")+tagCls)),this.startSpan(Math.max(from,start),cls),rule.opaque)return;let mounted=cursor.tree&&cursor.tree.prop(NodeProp.mounted);if(mounted&&mounted.overlay){let inner=cursor.node.enter(mounted.overlay[0].from+start,1),innerHighlighters=this.highlighters.filter((h=>!h.scope||h.scope(mounted.tree.type))),hasChild=cursor.firstChild();for(let i=0,pos=start;;i++){let next=i<mounted.overlay.length?mounted.overlay[i]:null,nextPos=next?next.from+start:end,rangeFrom=Math.max(from,pos),rangeTo=Math.min(to,nextPos);if(rangeFrom<rangeTo&&hasChild)for(;cursor.from<rangeTo&&(this.highlightRange(cursor,rangeFrom,rangeTo,inheritedClass,highlighters),this.startSpan(Math.min(rangeTo,cursor.to),cls),!(cursor.to>=nextPos)&&cursor.nextSibling()););if(!next||nextPos>to)break;pos=next.to+start,pos>from&&(this.highlightRange(inner.cursor(),Math.max(from,next.from+start),Math.min(to,pos),"",innerHighlighters),this.startSpan(Math.min(to,pos),cls))}hasChild&&cursor.parent()}else if(cursor.firstChild()){mounted&&(inheritedClass="");do{if(!(cursor.to<=from)){if(cursor.from>=to)break;this.highlightRange(cursor,from,to,inheritedClass,highlighters),this.startSpan(Math.min(to,cursor.to),cls)}}while(cursor.nextSibling());cursor.parent()}}}const t=Tag.define,comment=t(),name=t(),typeName=t(name),propertyName=t(name),literal=t(),string=t(literal),number=t(literal),content=t(),heading=t(content),keyword=t(),operator=t(),punctuation=t(),bracket=t(punctuation),meta=t(),tags$1={comment:comment,lineComment:t(comment),blockComment:t(comment),docComment:t(comment),name:name,variableName:t(name),typeName:typeName,tagName:t(typeName),propertyName:propertyName,attributeName:t(propertyName),className:t(name),labelName:t(name),namespace:t(name),macroName:t(name),literal:literal,string:string,docString:t(string),character:t(string),attributeValue:t(string),number:number,integer:t(number),float:t(number),bool:t(literal),regexp:t(literal),escape:t(literal),color:t(literal),url:t(literal),keyword:keyword,self:t(keyword),null:t(keyword),atom:t(keyword),unit:t(keyword),modifier:t(keyword),operatorKeyword:t(keyword),controlKeyword:t(keyword),definitionKeyword:t(keyword),moduleKeyword:t(keyword),operator:operator,derefOperator:t(operator),arithmeticOperator:t(operator),logicOperator:t(operator),bitwiseOperator:t(operator),compareOperator:t(operator),updateOperator:t(operator),definitionOperator:t(operator),typeOperator:t(operator),controlOperator:t(operator),punctuation:punctuation,separator:t(punctuation),bracket:bracket,angleBracket:t(bracket),squareBracket:t(bracket),paren:t(bracket),brace:t(bracket),content:content,heading:heading,heading1:t(heading),heading2:t(heading),heading3:t(heading),heading4:t(heading),heading5:t(heading),heading6:t(heading),contentSeparator:t(content),list:t(content),quote:t(content),emphasis:t(content),strong:t(content),link:t(content),monospace:t(content),strikethrough:t(content),inserted:t(),deleted:t(),changed:t(),invalid:t(),meta:meta,documentMeta:t(meta),annotation:t(meta),processingInstruction:t(meta),definition:Tag.defineModifier(),constant:Tag.defineModifier(),function:Tag.defineModifier(),standard:Tag.defineModifier(),local:Tag.defineModifier(),special:Tag.defineModifier()};var _a;tagHighlighter([{tag:tags$1.link,class:"tok-link"},{tag:tags$1.heading,class:"tok-heading"},{tag:tags$1.emphasis,class:"tok-emphasis"},{tag:tags$1.strong,class:"tok-strong"},{tag:tags$1.keyword,class:"tok-keyword"},{tag:tags$1.atom,class:"tok-atom"},{tag:tags$1.bool,class:"tok-bool"},{tag:tags$1.url,class:"tok-url"},{tag:tags$1.labelName,class:"tok-labelName"},{tag:tags$1.inserted,class:"tok-inserted"},{tag:tags$1.deleted,class:"tok-deleted"},{tag:tags$1.literal,class:"tok-literal"},{tag:tags$1.string,class:"tok-string"},{tag:tags$1.number,class:"tok-number"},{tag:[tags$1.regexp,tags$1.escape,tags$1.special(tags$1.string)],class:"tok-string2"},{tag:tags$1.variableName,class:"tok-variableName"},{tag:tags$1.local(tags$1.variableName),class:"tok-variableName tok-local"},{tag:tags$1.definition(tags$1.variableName),class:"tok-variableName tok-definition"},{tag:tags$1.special(tags$1.variableName),class:"tok-variableName2"},{tag:tags$1.definition(tags$1.propertyName),class:"tok-propertyName tok-definition"},{tag:tags$1.typeName,class:"tok-typeName"},{tag:tags$1.namespace,class:"tok-namespace"},{tag:tags$1.className,class:"tok-className"},{tag:tags$1.macroName,class:"tok-macroName"},{tag:tags$1.propertyName,class:"tok-propertyName"},{tag:tags$1.operator,class:"tok-operator"},{tag:tags$1.comment,class:"tok-comment"},{tag:tags$1.meta,class:"tok-meta"},{tag:tags$1.invalid,class:"tok-invalid"},{tag:tags$1.punctuation,class:"tok-punctuation"}]);const languageDataProp=new NodeProp;function defineLanguageFacet(baseData){return Facet.define({combine:baseData?values=>values.concat(baseData):void 0})}const sublanguageProp=new NodeProp;class Language{constructor(data,parser){let extraExtensions=arguments.length>2&&void 0!==arguments[2]?arguments[2]:[],name=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"";this.data=data,this.name=name,EditorState.prototype.hasOwnProperty("tree")||Object.defineProperty(EditorState.prototype,"tree",{get(){return syntaxTree(this)}}),this.parser=parser,this.extension=[language.of(this),EditorState.languageData.of(((state,pos,side)=>{let top=topNodeAt(state,pos,side),data=top.type.prop(languageDataProp);if(!data)return[];let base=state.facet(data),sub=top.type.prop(sublanguageProp);if(sub){let innerNode=top.resolve(pos-top.from,side);for(let sublang of sub)if(sublang.test(innerNode,state)){let data=state.facet(sublang.facet);return"replace"==sublang.type?data:data.concat(base)}}return base}))].concat(extraExtensions)}isActiveAt(state,pos){return topNodeAt(state,pos,arguments.length>2&&void 0!==arguments[2]?arguments[2]:-1).type.prop(languageDataProp)==this.data}findRegions(state){let lang=state.facet(language);if((null==lang?void 0:lang.data)==this.data)return[{from:0,to:state.doc.length}];if(!lang||!lang.allowsNesting)return[];let result=[],explore=(tree,from)=>{if(tree.prop(languageDataProp)==this.data)return void result.push({from:from,to:from+tree.length});let mount=tree.prop(NodeProp.mounted);if(mount){if(mount.tree.prop(languageDataProp)==this.data){if(mount.overlay)for(let r of mount.overlay)result.push({from:r.from+from,to:r.to+from});else result.push({from:from,to:from+tree.length});return}if(mount.overlay){let size=result.length;if(explore(mount.tree,mount.overlay[0].from+from),result.length>size)return}}for(let i=0;i<tree.children.length;i++){let ch=tree.children[i];ch instanceof Tree&&explore(ch,tree.positions[i]+from)}};return explore(syntaxTree(state),0),result}get allowsNesting(){return!0}}function topNodeAt(state,pos,side){let topLang=state.facet(language),tree=syntaxTree(state).topNode;if(!topLang||topLang.allowsNesting)for(let node=tree;node;node=node.enter(pos,side,IterMode.ExcludeBuffers))node.type.isTop&&(tree=node);return tree}Language.setState=StateEffect.define();class LRLanguage extends Language{constructor(data,parser,name){super(data,parser,[],name),this.parser=parser}static define(spec){let data=defineLanguageFacet(spec.languageData);return new LRLanguage(data,spec.parser.configure({props:[languageDataProp.add((type=>type.isTop?data:void 0))]}),spec.name)}configure(options,name){return new LRLanguage(this.data,this.parser.configure(options),name||this.name)}get allowsNesting(){return this.parser.hasWrappers()}}function syntaxTree(state){let field=state.field(Language.state,!1);return field?field.tree:Tree.empty}class DocInput{constructor(doc){this.doc=doc,this.cursorPos=0,this.string="",this.cursor=doc.iter()}get length(){return this.doc.length}syncTo(pos){return this.string=this.cursor.next(pos-this.cursorPos).value,this.cursorPos=pos+this.string.length,this.cursorPos-this.string.length}chunk(pos){return this.syncTo(pos),this.string}get lineChunks(){return!0}read(from,to){let stringStart=this.cursorPos-this.string.length;return from<stringStart||to>=this.cursorPos?this.doc.sliceString(from,to):this.string.slice(from-stringStart,to-stringStart)}}let currentContext=null;class ParseContext{constructor(parser,state){let fragments=arguments.length>2&&void 0!==arguments[2]?arguments[2]:[],tree=arguments.length>3?arguments[3]:void 0,treeLen=arguments.length>4?arguments[4]:void 0,viewport=arguments.length>5?arguments[5]:void 0,skipped=arguments.length>6?arguments[6]:void 0,scheduleOn=arguments.length>7?arguments[7]:void 0;this.parser=parser,this.state=state,this.fragments=fragments,this.tree=tree,this.treeLen=treeLen,this.viewport=viewport,this.skipped=skipped,this.scheduleOn=scheduleOn,this.parse=null,this.tempSkipped=[]}static create(parser,state,viewport){return new ParseContext(parser,state,[],Tree.empty,0,viewport,[],null)}startParse(){return this.parser.startParse(new DocInput(this.state.doc),this.fragments)}work(until,upto){return null!=upto&&upto>=this.state.doc.length&&(upto=void 0),this.tree!=Tree.empty&&this.isDone(null!=upto?upto:this.state.doc.length)?(this.takeTree(),!0):this.withContext((()=>{var _a;if("number"==typeof until){let endTime=Date.now()+until;until=()=>Date.now()>endTime}for(this.parse||(this.parse=this.startParse()),null!=upto&&(null==this.parse.stoppedAt||this.parse.stoppedAt>upto)&&upto<this.state.doc.length&&this.parse.stopAt(upto);;){let done=this.parse.advance();if(done){if(this.fragments=this.withoutTempSkipped(TreeFragment.addTree(done,this.fragments,null!=this.parse.stoppedAt)),this.treeLen=null!==(_a=this.parse.stoppedAt)&&void 0!==_a?_a:this.state.doc.length,this.tree=done,this.parse=null,!(this.treeLen<(null!=upto?upto:this.state.doc.length)))return!0;this.parse=this.startParse()}if(until())return!1}}))}takeTree(){let pos,tree;this.parse&&(pos=this.parse.parsedPos)>=this.treeLen&&((null==this.parse.stoppedAt||this.parse.stoppedAt>pos)&&this.parse.stopAt(pos),this.withContext((()=>{for(;!(tree=this.parse.advance()););})),this.treeLen=pos,this.tree=tree,this.fragments=this.withoutTempSkipped(TreeFragment.addTree(this.tree,this.fragments,!0)),this.parse=null)}withContext(f){let prev=currentContext;currentContext=this;try{return f()}finally{currentContext=prev}}withoutTempSkipped(fragments){for(let r;r=this.tempSkipped.pop();)fragments=cutFragments(fragments,r.from,r.to);return fragments}changes(changes,newState){let{fragments:fragments,tree:tree,treeLen:treeLen,viewport:viewport,skipped:skipped}=this;if(this.takeTree(),!changes.empty){let ranges=[];if(changes.iterChangedRanges(((fromA,toA,fromB,toB)=>ranges.push({fromA:fromA,toA:toA,fromB:fromB,toB:toB}))),fragments=TreeFragment.applyChanges(fragments,ranges),tree=Tree.empty,treeLen=0,viewport={from:changes.mapPos(viewport.from,-1),to:changes.mapPos(viewport.to,1)},this.skipped.length){skipped=[];for(let r of this.skipped){let from=changes.mapPos(r.from,1),to=changes.mapPos(r.to,-1);from<to&&skipped.push({from:from,to:to})}}}return new ParseContext(this.parser,newState,fragments,tree,treeLen,viewport,skipped,this.scheduleOn)}updateViewport(viewport){if(this.viewport.from==viewport.from&&this.viewport.to==viewport.to)return!1;this.viewport=viewport;let startLen=this.skipped.length;for(let i=0;i<this.skipped.length;i++){let{from:from,to:to}=this.skipped[i];from<viewport.to&&to>viewport.from&&(this.fragments=cutFragments(this.fragments,from,to),this.skipped.splice(i--,1))}return!(this.skipped.length>=startLen)&&(this.reset(),!0)}reset(){this.parse&&(this.takeTree(),this.parse=null)}skipUntilInView(from,to){this.skipped.push({from:from,to:to})}static getSkippingParser(until){return new class extends Parser{createParse(input,fragments,ranges){let from=ranges[0].from,to=ranges[ranges.length-1].to;return{parsedPos:from,advance(){let cx=currentContext;if(cx){for(let r of ranges)cx.tempSkipped.push(r);until&&(cx.scheduleOn=cx.scheduleOn?Promise.all([cx.scheduleOn,until]):until)}return this.parsedPos=to,new Tree(NodeType.none,[],[],to-from)},stoppedAt:null,stopAt(){}}}}}isDone(upto){upto=Math.min(upto,this.state.doc.length);let frags=this.fragments;return this.treeLen>=upto&&frags.length&&0==frags[0].from&&frags[0].to>=upto}static get(){return currentContext}}function cutFragments(fragments,from,to){return TreeFragment.applyChanges(fragments,[{fromA:from,toA:to,fromB:from,toB:to}])}class LanguageState{constructor(context){this.context=context,this.tree=context.tree}apply(tr){if(!tr.docChanged&&this.tree==this.context.tree)return this;let newCx=this.context.changes(tr.changes,tr.state),upto=this.context.treeLen==tr.startState.doc.length?void 0:Math.max(tr.changes.mapPos(this.context.treeLen),newCx.viewport.to);return newCx.work(20,upto)||newCx.takeTree(),new LanguageState(newCx)}static init(state){let vpTo=Math.min(3e3,state.doc.length),parseState=ParseContext.create(state.facet(language).parser,state,{from:0,to:vpTo});return parseState.work(20,vpTo)||parseState.takeTree(),new LanguageState(parseState)}}Language.state=StateField.define({create:LanguageState.init,update(value,tr){for(let e of tr.effects)if(e.is(Language.setState))return e.value;return tr.startState.facet(language)!=tr.state.facet(language)?LanguageState.init(tr.state):value.apply(tr)}});let requestIdle=callback=>{let timeout=setTimeout((()=>callback()),500);return()=>clearTimeout(timeout)};"undefined"!=typeof requestIdleCallback&&(requestIdle=callback=>{let idle=-1,timeout=setTimeout((()=>{idle=requestIdleCallback(callback,{timeout:400})}),100);return()=>idle<0?clearTimeout(timeout):cancelIdleCallback(idle)});const isInputPending="undefined"!=typeof navigator&&(null===(_a=navigator.scheduling)||void 0===_a?void 0:_a.isInputPending)?()=>navigator.scheduling.isInputPending():null,parseWorker=ViewPlugin.fromClass(class{constructor(view){this.view=view,this.working=null,this.workScheduled=0,this.chunkEnd=-1,this.chunkBudget=-1,this.work=this.work.bind(this),this.scheduleWork()}update(update){let cx=this.view.state.field(Language.state).context;(cx.updateViewport(update.view.viewport)||this.view.viewport.to>cx.treeLen)&&this.scheduleWork(),update.docChanged&&(this.view.hasFocus&&(this.chunkBudget+=50),this.scheduleWork()),this.checkAsyncSchedule(cx)}scheduleWork(){if(this.working)return;let{state:state}=this.view,field=state.field(Language.state);field.tree==field.context.tree&&field.context.isDone(state.doc.length)||(this.working=requestIdle(this.work))}work(deadline){this.working=null;let now=Date.now();if(this.chunkEnd<now&&(this.chunkEnd<0||this.view.hasFocus)&&(this.chunkEnd=now+3e4,this.chunkBudget=3e3),this.chunkBudget<=0)return;let{state:state,viewport:{to:vpTo}}=this.view,field=state.field(Language.state);if(field.tree==field.context.tree&&field.context.isDone(vpTo+1e5))return;let endTime=Date.now()+Math.min(this.chunkBudget,100,deadline&&!isInputPending?Math.max(25,deadline.timeRemaining()-5):1e9),viewportFirst=field.context.treeLen<vpTo&&state.doc.length>vpTo+1e3,done=field.context.work((()=>isInputPending&&isInputPending()||Date.now()>endTime),vpTo+(viewportFirst?0:1e5));this.chunkBudget-=Date.now()-now,(done||this.chunkBudget<=0)&&(field.context.takeTree(),this.view.dispatch({effects:Language.setState.of(new LanguageState(field.context))})),this.chunkBudget>0&&(!done||viewportFirst)&&this.scheduleWork(),this.checkAsyncSchedule(field.context)}checkAsyncSchedule(cx){cx.scheduleOn&&(this.workScheduled++,cx.scheduleOn.then((()=>this.scheduleWork())).catch((err=>logException(this.view.state,err))).then((()=>this.workScheduled--)),cx.scheduleOn=null)}destroy(){this.working&&this.working()}isWorking(){return!!(this.working||this.workScheduled>0)}},{eventHandlers:{focus(){this.scheduleWork()}}}),language=Facet.define({combine:languages=>languages.length?languages[0]:null,enables:language=>[Language.state,parseWorker,EditorView.contentAttributes.compute([language],(state=>{let lang=state.facet(language);return lang&&lang.name?{"data-language":lang.name}:{}}))]});class LanguageSupport{constructor(language){let support=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];this.language=language,this.support=support,this.extension=[language,support]}}const indentService=Facet.define(),indentUnit=Facet.define({combine:values=>{if(!values.length)return"  ";let unit=values[0];if(!unit||/\S/.test(unit)||Array.from(unit).some((e=>e!=unit[0])))throw new Error("Invalid indent unit: "+JSON.stringify(values[0]));return unit}});function getIndentUnit(state){let unit=state.facet(indentUnit);return 9==unit.charCodeAt(0)?state.tabSize*unit.length:unit.length}function indentString(state,cols){let result="",ts=state.tabSize,ch=state.facet(indentUnit)[0];if("\t"==ch){for(;cols>=ts;)result+="\t",cols-=ts;ch=" "}for(let i=0;i<cols;i++)result+=ch;return result}function getIndentation(context,pos){context instanceof EditorState&&(context=new IndentContext(context));for(let service of context.state.facet(indentService)){let result=service(context,pos);if(void 0!==result)return result}let tree=syntaxTree(context.state);return tree?function(cx,ast,pos){return indentFrom(ast.resolveInner(pos).enterUnfinishedNodesBefore(pos),pos,cx)}(context,tree,pos):null}class IndentContext{constructor(state){let options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.state=state,this.options=options,this.unit=getIndentUnit(state)}lineAt(pos){let bias=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,line=this.state.doc.lineAt(pos),{simulateBreak:simulateBreak,simulateDoubleBreak:simulateDoubleBreak}=this.options;return null!=simulateBreak&&simulateBreak>=line.from&&simulateBreak<=line.to?simulateDoubleBreak&&simulateBreak==pos?{text:"",from:pos}:(bias<0?simulateBreak<pos:simulateBreak<=pos)?{text:line.text.slice(simulateBreak-line.from),from:simulateBreak}:{text:line.text.slice(0,simulateBreak-line.from),from:line.from}:line}textAfterPos(pos){let bias=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;if(this.options.simulateDoubleBreak&&pos==this.options.simulateBreak)return"";let{text:text,from:from}=this.lineAt(pos,bias);return text.slice(pos-from,Math.min(text.length,pos+100-from))}column(pos){let bias=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,{text:text,from:from}=this.lineAt(pos,bias),result=this.countColumn(text,pos-from),override=this.options.overrideIndentation?this.options.overrideIndentation(from):-1;return override>-1&&(result+=override-this.countColumn(text,text.search(/\S|$/))),result}countColumn(line){let pos=arguments.length>1&&void 0!==arguments[1]?arguments[1]:line.length;return countColumn(line,this.state.tabSize,pos)}lineIndent(pos){let bias=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,{text:text,from:from}=this.lineAt(pos,bias),override=this.options.overrideIndentation;if(override){let overriden=override(from);if(overriden>-1)return overriden}return this.countColumn(text,text.search(/\S|$/))}get simulatedBreak(){return this.options.simulateBreak||null}}const indentNodeProp=new NodeProp;function indentStrategy(tree){let strategy=tree.type.prop(indentNodeProp);if(strategy)return strategy;let close,first=tree.firstChild;if(first&&(close=first.type.prop(NodeProp.closedBy))){let last=tree.lastChild,closed=last&&close.indexOf(last.name)>-1;return cx=>delimitedStrategy(cx,!0,1,void 0,closed&&!function(cx){return cx.pos==cx.options.simulateBreak&&cx.options.simulateDoubleBreak}(cx)?last.from:void 0)}return null==tree.parent?topIndent:null}function indentFrom(node,pos,base){for(;node;node=node.parent){let strategy=indentStrategy(node);if(strategy)return strategy(TreeIndentContext.create(base,pos,node))}return null}function topIndent(){return 0}class TreeIndentContext extends IndentContext{constructor(base,pos,node){super(base.state,base.options),this.base=base,this.pos=pos,this.node=node}static create(base,pos,node){return new TreeIndentContext(base,pos,node)}get textAfter(){return this.textAfterPos(this.pos)}get baseIndent(){return this.baseIndentFor(this.node)}baseIndentFor(node){let line=this.state.doc.lineAt(node.from);for(;;){let atBreak=node.resolve(line.from);for(;atBreak.parent&&atBreak.parent.from==atBreak.from;)atBreak=atBreak.parent;if(isParent(atBreak,node))break;line=this.state.doc.lineAt(atBreak.from)}return this.lineIndent(line.from)}continue(){let parent=this.node.parent;return parent?indentFrom(parent,this.pos,this.base):0}}function isParent(parent,of){for(let cur=of;cur;cur=cur.parent)if(parent==cur)return!0;return!1}function delimitedStrategy(context,align,units,closing,closedAt){let after=context.textAfter,space=after.match(/^\s*/)[0].length,closed=closing&&after.slice(space,space+closing.length)==closing||closedAt==context.pos+space,aligned=align?function(context){let tree=context.node,openToken=tree.childAfter(tree.from),last=tree.lastChild;if(!openToken)return null;let sim=context.options.simulateBreak,openLine=context.state.doc.lineAt(openToken.from),lineEnd=null==sim||sim<=openLine.from?openLine.to:Math.min(openLine.to,sim);for(let pos=openToken.to;;){let next=tree.childAfter(pos);if(!next||next==last)return null;if(!next.type.isSkipped)return next.from<lineEnd?openToken:null;pos=next.to}}(context):null;return aligned?closed?context.column(aligned.from):context.column(aligned.to):context.baseIndent+(closed?0:context.unit*units)}function continuedIndent(){let{except:except,units:units=1}=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return context=>{let matchExcept=except&&except.test(context.textAfter);return context.baseIndent+(matchExcept?0:units*context.unit)}}const foldService=Facet.define(),foldNodeProp=new NodeProp;function foldInside(node){let first=node.firstChild,last=node.lastChild;return first&&first.to<last.from?{from:first.to,to:last.type.isError?node.to:last.from}:null}function isUnfinished(node){let ch=node.lastChild;return ch&&ch.to==node.to&&ch.type.isError}function foldable(state,lineStart,lineEnd){for(let service of state.facet(foldService)){let result=service(state,lineStart,lineEnd);if(result)return result}return function(state,start,end){let tree=syntaxTree(state);if(tree.length<end)return null;let found=null;for(let cur=tree.resolveInner(end,1);cur;cur=cur.parent){if(cur.to<=end||cur.from>end)continue;if(found&&cur.from<start)break;let prop=cur.type.prop(foldNodeProp);if(prop&&(cur.to<tree.length-50||tree.length==state.doc.length||!isUnfinished(cur))){let value=prop(cur,state);value&&value.from<=end&&value.from>=start&&value.to>end&&(found=value)}}return found}(state,lineStart,lineEnd)}function mapRange(range,mapping){let from=mapping.mapPos(range.from,1),to=mapping.mapPos(range.to,-1);return from>=to?void 0:{from:from,to:to}}const foldEffect=StateEffect.define({map:mapRange}),unfoldEffect=StateEffect.define({map:mapRange});function selectedLines(view){let lines=[];for(let{head:head}of view.state.selection.ranges)lines.some((l=>l.from<=head&&l.to>=head))||lines.push(view.lineBlockAt(head));return lines}const foldState=StateField.define({create:()=>Decoration.none,update(folded,tr){folded=folded.map(tr.changes);for(let e of tr.effects)e.is(foldEffect)&&!foldExists(folded,e.value.from,e.value.to)?folded=folded.update({add:[foldWidget.range(e.value.from,e.value.to)]}):e.is(unfoldEffect)&&(folded=folded.update({filter:(from,to)=>e.value.from!=from||e.value.to!=to,filterFrom:e.value.from,filterTo:e.value.to}));if(tr.selection){let onSelection=!1,{head:head}=tr.selection.main;folded.between(head,head,((a,b)=>{a<head&&b>head&&(onSelection=!0)})),onSelection&&(folded=folded.update({filterFrom:head,filterTo:head,filter:(a,b)=>b<=head||a>=head}))}return folded},provide:f=>EditorView.decorations.from(f),toJSON(folded,state){let ranges=[];return folded.between(0,state.doc.length,((from,to)=>{ranges.push(from,to)})),ranges},fromJSON(value){if(!Array.isArray(value)||value.length%2)throw new RangeError("Invalid JSON for fold state");let ranges=[];for(let i=0;i<value.length;){let from=value[i++],to=value[i++];if("number"!=typeof from||"number"!=typeof to)throw new RangeError("Invalid JSON for fold state");ranges.push(foldWidget.range(from,to))}return Decoration.set(ranges,!0)}});function findFold(state,from,to){var _a;let found=null;return null===(_a=state.field(foldState,!1))||void 0===_a||_a.between(from,to,((from,to)=>{(!found||found.from>from)&&(found={from:from,to:to})})),found}function foldExists(folded,from,to){let found=!1;return folded.between(from,from,((a,b)=>{a==from&&b==to&&(found=!0)})),found}function maybeEnable(state,other){return state.field(foldState,!1)?other:other.concat(StateEffect.appendConfig.of(codeFolding()))}function announceFold(view,range){let fold=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],lineFrom=view.state.doc.lineAt(range.from).number,lineTo=view.state.doc.lineAt(range.to).number;return EditorView.announce.of("".concat(view.state.phrase(fold?"Folded lines":"Unfolded lines")," ").concat(lineFrom," ").concat(view.state.phrase("to")," ").concat(lineTo,"."))}const foldKeymap=[{key:"Ctrl-Shift-[",mac:"Cmd-Alt-[",run:view=>{for(let line of selectedLines(view)){let range=foldable(view.state,line.from,line.to);if(range)return view.dispatch({effects:maybeEnable(view.state,[foldEffect.of(range),announceFold(view,range)])}),!0}return!1}},{key:"Ctrl-Shift-]",mac:"Cmd-Alt-]",run:view=>{if(!view.state.field(foldState,!1))return!1;let effects=[];for(let line of selectedLines(view)){let folded=findFold(view.state,line.from,line.to);folded&&effects.push(unfoldEffect.of(folded),announceFold(view,folded,!1))}return effects.length&&view.dispatch({effects:effects}),effects.length>0}},{key:"Ctrl-Alt-[",run:view=>{let{state:state}=view,effects=[];for(let pos=0;pos<state.doc.length;){let line=view.lineBlockAt(pos),range=foldable(state,line.from,line.to);range&&effects.push(foldEffect.of(range)),pos=(range?view.lineBlockAt(range.to):line).to+1}return effects.length&&view.dispatch({effects:maybeEnable(view.state,effects)}),!!effects.length}},{key:"Ctrl-Alt-]",run:view=>{let field=view.state.field(foldState,!1);if(!field||!field.size)return!1;let effects=[];return field.between(0,view.state.doc.length,((from,to)=>{effects.push(unfoldEffect.of({from:from,to:to}))})),view.dispatch({effects:effects}),!0}}],defaultConfig={placeholderDOM:null,placeholderText:"…"},foldConfig=Facet.define({combine:values=>combineConfig(values,defaultConfig)});function codeFolding(config){let result=[foldState,baseTheme$1$2];return config&&result.push(foldConfig.of(config)),result}const foldWidget=Decoration.replace({widget:new class extends WidgetType{toDOM(view){let{state:state}=view,conf=state.facet(foldConfig),onclick=event=>{let line=view.lineBlockAt(view.posAtDOM(event.target)),folded=findFold(view.state,line.from,line.to);folded&&view.dispatch({effects:unfoldEffect.of(folded)}),event.preventDefault()};if(conf.placeholderDOM)return conf.placeholderDOM(view,onclick);let element=document.createElement("span");return element.textContent=conf.placeholderText,element.setAttribute("aria-label",state.phrase("folded code")),element.title=state.phrase("unfold"),element.className="cm-foldPlaceholder",element.onclick=onclick,element}}}),foldGutterDefaults={openText:"⌄",closedText:"›",markerDOM:null,domEventHandlers:{},foldingChanged:()=>!1};class FoldMarker extends GutterMarker{constructor(config,open){super(),this.config=config,this.open=open}eq(other){return this.config==other.config&&this.open==other.open}toDOM(view){if(this.config.markerDOM)return this.config.markerDOM(this.open);let span=document.createElement("span");return span.textContent=this.open?this.config.openText:this.config.closedText,span.title=view.state.phrase(this.open?"Fold line":"Unfold line"),span}}function foldGutter(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},fullConfig=Object.assign(Object.assign({},foldGutterDefaults),config),canFold=new FoldMarker(fullConfig,!0),canUnfold=new FoldMarker(fullConfig,!1),markers=ViewPlugin.fromClass(class{constructor(view){this.from=view.viewport.from,this.markers=this.buildMarkers(view)}update(update){(update.docChanged||update.viewportChanged||update.startState.facet(language)!=update.state.facet(language)||update.startState.field(foldState,!1)!=update.state.field(foldState,!1)||syntaxTree(update.startState)!=syntaxTree(update.state)||fullConfig.foldingChanged(update))&&(this.markers=this.buildMarkers(update.view))}buildMarkers(view){let builder=new RangeSetBuilder;for(let line of view.viewportLineBlocks){let mark=findFold(view.state,line.from,line.to)?canUnfold:foldable(view.state,line.from,line.to)?canFold:null;mark&&builder.add(line.from,line.from,mark)}return builder.finish()}}),{domEventHandlers:domEventHandlers}=fullConfig;return[markers,gutter({class:"cm-foldGutter",markers(view){var _a;return(null===(_a=view.plugin(markers))||void 0===_a?void 0:_a.markers)||RangeSet.empty},initialSpacer:()=>new FoldMarker(fullConfig,!1),domEventHandlers:Object.assign(Object.assign({},domEventHandlers),{click:(view,line,event)=>{if(domEventHandlers.click&&domEventHandlers.click(view,line,event))return!0;let folded=findFold(view.state,line.from,line.to);if(folded)return view.dispatch({effects:unfoldEffect.of(folded)}),!0;let range=foldable(view.state,line.from,line.to);return!!range&&(view.dispatch({effects:foldEffect.of(range)}),!0)}})}),codeFolding()]}const baseTheme$1$2=EditorView.baseTheme({".cm-foldPlaceholder":{backgroundColor:"#eee",border:"1px solid #ddd",color:"#888",borderRadius:".2em",margin:"0 1px",padding:"0 1px",cursor:"pointer"},".cm-foldGutter span":{padding:"0 1px",cursor:"pointer"}});class HighlightStyle{constructor(specs,options){let modSpec;function def(spec){let cls=StyleModule.newName();return(modSpec||(modSpec=Object.create(null)))["."+cls]=spec,cls}this.specs=specs;const all="string"==typeof options.all?options.all:options.all?def(options.all):void 0,scopeOpt=options.scope;this.scope=scopeOpt instanceof Language?type=>type.prop(languageDataProp)==scopeOpt.data:scopeOpt?type=>type==scopeOpt:void 0,this.style=tagHighlighter(specs.map((style=>({tag:style.tag,class:style.class||def(Object.assign({},style,{tag:null}))}))),{all:all}).style,this.module=modSpec?new StyleModule(modSpec):null,this.themeType=options.themeType}static define(specs,options){return new HighlightStyle(specs,options||{})}}const highlighterFacet=Facet.define(),fallbackHighlighter=Facet.define({combine:values=>values.length?[values[0]]:null});function getHighlighters(state){let main=state.facet(highlighterFacet);return main.length?main:state.facet(fallbackHighlighter)}function syntaxHighlighting(highlighter,options){let themeType,ext=[treeHighlighter];return highlighter instanceof HighlightStyle&&(highlighter.module&&ext.push(EditorView.styleModule.of(highlighter.module)),themeType=highlighter.themeType),(null==options?void 0:options.fallback)?ext.push(fallbackHighlighter.of(highlighter)):themeType?ext.push(highlighterFacet.computeN([EditorView.darkTheme],(state=>state.facet(EditorView.darkTheme)==("dark"==themeType)?[highlighter]:[]))):ext.push(highlighterFacet.of(highlighter)),ext}const treeHighlighter=Prec.high(ViewPlugin.fromClass(class{constructor(view){this.markCache=Object.create(null),this.tree=syntaxTree(view.state),this.decorations=this.buildDeco(view,getHighlighters(view.state))}update(update){let tree=syntaxTree(update.state),highlighters=getHighlighters(update.state),styleChange=highlighters!=getHighlighters(update.startState);tree.length<update.view.viewport.to&&!styleChange&&tree.type==this.tree.type?this.decorations=this.decorations.map(update.changes):(tree!=this.tree||update.viewportChanged||styleChange)&&(this.tree=tree,this.decorations=this.buildDeco(update.view,highlighters))}buildDeco(view,highlighters){if(!highlighters||!this.tree.length)return Decoration.none;let builder=new RangeSetBuilder;for(let{from:from,to:to}of view.visibleRanges)highlightTree(this.tree,highlighters,((from,to,style)=>{builder.add(from,to,this.markCache[style]||(this.markCache[style]=Decoration.mark({class:style})))}),from,to);return builder.finish()}},{decorations:v=>v.decorations})),defaultHighlightStyle=HighlightStyle.define([{tag:tags$1.meta,color:"#404740"},{tag:tags$1.link,textDecoration:"underline"},{tag:tags$1.heading,textDecoration:"underline",fontWeight:"bold"},{tag:tags$1.emphasis,fontStyle:"italic"},{tag:tags$1.strong,fontWeight:"bold"},{tag:tags$1.strikethrough,textDecoration:"line-through"},{tag:tags$1.keyword,color:"#708"},{tag:[tags$1.atom,tags$1.bool,tags$1.url,tags$1.contentSeparator,tags$1.labelName],color:"#219"},{tag:[tags$1.literal,tags$1.inserted],color:"#164"},{tag:[tags$1.string,tags$1.deleted],color:"#a11"},{tag:[tags$1.regexp,tags$1.escape,tags$1.special(tags$1.string)],color:"#e40"},{tag:tags$1.definition(tags$1.variableName),color:"#00f"},{tag:tags$1.local(tags$1.variableName),color:"#30a"},{tag:[tags$1.typeName,tags$1.namespace],color:"#085"},{tag:tags$1.className,color:"#167"},{tag:[tags$1.special(tags$1.variableName),tags$1.macroName],color:"#256"},{tag:tags$1.definition(tags$1.propertyName),color:"#00c"},{tag:tags$1.comment,color:"#940"},{tag:tags$1.invalid,color:"#f00"}]),baseTheme$3=EditorView.baseTheme({"&.cm-focused .cm-matchingBracket":{backgroundColor:"#328c8252"},"&.cm-focused .cm-nonmatchingBracket":{backgroundColor:"#bb555544"}}),bracketMatchingConfig=Facet.define({combine:configs=>combineConfig(configs,{afterCursor:!0,brackets:"()[]{}",maxScanDistance:1e4,renderMatch:defaultRenderMatch})}),matchingMark=Decoration.mark({class:"cm-matchingBracket"}),nonmatchingMark=Decoration.mark({class:"cm-nonmatchingBracket"});function defaultRenderMatch(match){let decorations=[],mark=match.matched?matchingMark:nonmatchingMark;return decorations.push(mark.range(match.start.from,match.start.to)),match.end&&decorations.push(mark.range(match.end.from,match.end.to)),decorations}const bracketMatchingState=StateField.define({create:()=>Decoration.none,update(deco,tr){if(!tr.docChanged&&!tr.selection)return deco;let decorations=[],config=tr.state.facet(bracketMatchingConfig);for(let range of tr.state.selection.ranges){if(!range.empty)continue;let match=matchBrackets(tr.state,range.head,-1,config)||range.head>0&&matchBrackets(tr.state,range.head-1,1,config)||config.afterCursor&&(matchBrackets(tr.state,range.head,1,config)||range.head<tr.state.doc.length&&matchBrackets(tr.state,range.head+1,-1,config));match&&(decorations=decorations.concat(config.renderMatch(match,tr.state)))}return Decoration.set(decorations,!0)},provide:f=>EditorView.decorations.from(f)}),bracketMatchingUnique=[bracketMatchingState,baseTheme$3];function bracketMatching(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return[bracketMatchingConfig.of(config),bracketMatchingUnique]}const bracketMatchingHandle=new NodeProp;function matchingNodes(node,dir,brackets){let byProp=node.prop(dir<0?NodeProp.openedBy:NodeProp.closedBy);if(byProp)return byProp;if(1==node.name.length){let index=brackets.indexOf(node.name);if(index>-1&&index%2==(dir<0?1:0))return[brackets[index+dir]]}return null}function findHandle(node){let hasHandle=node.type.prop(bracketMatchingHandle);return hasHandle?hasHandle(node.node):node}function matchBrackets(state,pos,dir){let config=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},maxScanDistance=config.maxScanDistance||1e4,brackets=config.brackets||"()[]{}",tree=syntaxTree(state),node=tree.resolveInner(pos,dir);for(let cur=node;cur;cur=cur.parent){let matches=matchingNodes(cur.type,dir,brackets);if(matches&&cur.from<cur.to){let handle=findHandle(cur);if(handle&&(dir>0?pos>=handle.from&&pos<handle.to:pos>handle.from&&pos<=handle.to))return matchMarkedBrackets(state,pos,dir,cur,handle,matches,brackets)}}return matchPlainBrackets(state,pos,dir,tree,node.type,maxScanDistance,brackets)}function matchMarkedBrackets(_state,_pos,dir,token,handle,matching,brackets){let parent=token.parent,firstToken={from:handle.from,to:handle.to},depth=0,cursor=null==parent?void 0:parent.cursor();if(cursor&&(dir<0?cursor.childBefore(token.from):cursor.childAfter(token.to)))do{if(dir<0?cursor.to<=token.from:cursor.from>=token.to){if(0==depth&&matching.indexOf(cursor.type.name)>-1&&cursor.from<cursor.to){let endHandle=findHandle(cursor);return{start:firstToken,end:endHandle?{from:endHandle.from,to:endHandle.to}:void 0,matched:!0}}if(matchingNodes(cursor.type,dir,brackets))depth++;else if(matchingNodes(cursor.type,-dir,brackets)){if(0==depth){let endHandle=findHandle(cursor);return{start:firstToken,end:endHandle&&endHandle.from<endHandle.to?{from:endHandle.from,to:endHandle.to}:void 0,matched:!1}}depth--}}}while(dir<0?cursor.prevSibling():cursor.nextSibling());return{start:firstToken,matched:!1}}function matchPlainBrackets(state,pos,dir,tree,tokenType,maxScanDistance,brackets){let startCh=dir<0?state.sliceDoc(pos-1,pos):state.sliceDoc(pos,pos+1),bracket=brackets.indexOf(startCh);if(bracket<0||bracket%2==0!=dir>0)return null;let startToken={from:dir<0?pos-1:pos,to:dir>0?pos+1:pos},iter=state.doc.iterRange(pos,dir>0?state.doc.length:0),depth=0;for(let distance=0;!iter.next().done&&distance<=maxScanDistance;){let text=iter.value;dir<0&&(distance+=text.length);let basePos=pos+distance*dir;for(let pos=dir>0?0:text.length-1,end=dir>0?text.length:-1;pos!=end;pos+=dir){let found=brackets.indexOf(text[pos]);if(!(found<0||tree.resolveInner(basePos+pos,1).type!=tokenType))if(found%2==0==dir>0)depth++;else{if(1==depth)return{start:startToken,end:{from:basePos+pos,to:basePos+pos+1},matched:found>>1==bracket>>1};depth--}}dir>0&&(distance+=text.length)}return iter.done?{start:startToken,matched:!1}:null}const noTokens=Object.create(null),typeArray=[NodeType.none],warned=[],defaultTable=Object.create(null);for(let[legacyName,name]of[["variable","variableName"],["variable-2","variableName.special"],["string-2","string.special"],["def","variableName.definition"],["tag","tagName"],["attribute","attributeName"],["type","typeName"],["builtin","variableName.standard"],["qualifier","modifier"],["error","invalid"],["header","heading"],["property","propertyName"]])defaultTable[legacyName]=createTokenType(noTokens,name);function warnForPart(part,msg){warned.indexOf(part)>-1||(warned.push(part),console.warn(msg))}function createTokenType(extra,tagStr){let tag=null;for(let part of tagStr.split(".")){let value=extra[part]||tags$1[part];value?"function"==typeof value?tag?tag=value(tag):warnForPart(part,"Modifier ".concat(part," used at start of tag")):tag?warnForPart(part,"Tag ".concat(part," used as modifier")):tag=value:warnForPart(part,"Unknown highlighting tag ".concat(part))}if(!tag)return 0;let name=tagStr.replace(/ /g,"_"),type=NodeType.define({id:typeArray.length,name:name,props:[styleTags({[name]:tag})]});return typeArray.push(type),type.id}function command(f,option){return _ref9=>{let{state:state,dispatch:dispatch}=_ref9;if(state.readOnly)return!1;let tr=f(option,state);return!!tr&&(dispatch(state.update(tr)),!0)}}const toggleLineComment=command((function(option,state){let ranges=arguments.length>2&&void 0!==arguments[2]?arguments[2]:state.selection.ranges,lines=[],prevLine=-1;for(let{from:from,to:to}of ranges){let startI=lines.length,minIndent=1e9,token=getConfig(state,from).line;if(token){for(let pos=from;pos<=to;){let line=state.doc.lineAt(pos);if(line.from>prevLine&&(from==to||to>line.from)){prevLine=line.from;let indent=/^\s*/.exec(line.text)[0].length,empty=indent==line.length,comment=line.text.slice(indent,indent+token.length)==token?indent:-1;indent<line.text.length&&indent<minIndent&&(minIndent=indent),lines.push({line:line,comment:comment,token:token,indent:indent,empty:empty,single:!1})}pos=line.to+1}if(minIndent<1e9)for(let i=startI;i<lines.length;i++)lines[i].indent<lines[i].line.text.length&&(lines[i].indent=minIndent);lines.length==startI+1&&(lines[startI].single=!0)}}if(2!=option&&lines.some((l=>l.comment<0&&(!l.empty||l.single)))){let changes=[];for(let{line:line,token:token,indent:indent,empty:empty,single:single}of lines)!single&&empty||changes.push({from:line.from+indent,insert:token+" "});let changeSet=state.changes(changes);return{changes:changeSet,selection:state.selection.map(changeSet,1)}}if(1!=option&&lines.some((l=>l.comment>=0))){let changes=[];for(let{line:line,comment:comment,token:token}of lines)if(comment>=0){let from=line.from+comment,to=from+token.length;" "==line.text[to-line.from]&&to++,changes.push({from:from,to:to})}return{changes:changes}}return null}),0),toggleBlockComment=command(changeBlockComment,0),toggleBlockCommentByLine=command(((o,s)=>changeBlockComment(o,s,function(state){let ranges=[];for(let r of state.selection.ranges){let fromLine=state.doc.lineAt(r.from),toLine=r.to<=fromLine.to?fromLine:state.doc.lineAt(r.to),last=ranges.length-1;last>=0&&ranges[last].to>fromLine.from?ranges[last].to=toLine.to:ranges.push({from:fromLine.from+/^\s*/.exec(fromLine.text)[0].length,to:toLine.to})}return ranges}(s))),0);function getConfig(state,pos){let data=state.languageDataAt("commentTokens",pos);return data.length?data[0]:{}}function findBlockComment(state,_ref10,from,to){let startText,endText,{open:open,close:close}=_ref10,textBefore=state.sliceDoc(from-50,from),textAfter=state.sliceDoc(to,to+50),spaceBefore=/\s*$/.exec(textBefore)[0].length,spaceAfter=/^\s*/.exec(textAfter)[0].length,beforeOff=textBefore.length-spaceBefore;if(textBefore.slice(beforeOff-open.length,beforeOff)==open&&textAfter.slice(spaceAfter,spaceAfter+close.length)==close)return{open:{pos:from-spaceBefore,margin:spaceBefore&&1},close:{pos:to+spaceAfter,margin:spaceAfter&&1}};to-from<=100?startText=endText=state.sliceDoc(from,to):(startText=state.sliceDoc(from,from+50),endText=state.sliceDoc(to-50,to));let startSpace=/^\s*/.exec(startText)[0].length,endSpace=/\s*$/.exec(endText)[0].length,endOff=endText.length-endSpace-close.length;return startText.slice(startSpace,startSpace+open.length)==open&&endText.slice(endOff,endOff+close.length)==close?{open:{pos:from+startSpace+open.length,margin:/\s/.test(startText.charAt(startSpace+open.length))?1:0},close:{pos:to-endSpace-close.length,margin:/\s/.test(endText.charAt(endOff-1))?1:0}}:null}function changeBlockComment(option,state){let ranges=arguments.length>2&&void 0!==arguments[2]?arguments[2]:state.selection.ranges,tokens=ranges.map((r=>getConfig(state,r.from).block));if(!tokens.every((c=>c)))return null;let comments=ranges.map(((r,i)=>findBlockComment(state,tokens[i],r.from,r.to)));if(2!=option&&!comments.every((c=>c)))return{changes:state.changes(ranges.map(((range,i)=>comments[i]?[]:[{from:range.from,insert:tokens[i].open+" "},{from:range.to,insert:" "+tokens[i].close}])))};if(1!=option&&comments.some((c=>c))){let changes=[];for(let comment,i=0;i<comments.length;i++)if(comment=comments[i]){let token=tokens[i],{open:open,close:close}=comment;changes.push({from:open.pos-token.open.length,to:open.pos+open.margin},{from:close.pos-close.margin,to:close.pos+token.close.length})}return{changes:changes}}return null}const fromHistory=Annotation.define(),isolateHistory=Annotation.define(),invertedEffects=Facet.define(),historyConfig=Facet.define({combine:configs=>combineConfig(configs,{minDepth:100,newGroupDelay:500,joinToEvent:(_t,isAdjacent)=>isAdjacent},{minDepth:Math.max,newGroupDelay:Math.min,joinToEvent:(a,b)=>(tr,adj)=>a(tr,adj)||b(tr,adj)})});const historyField_=StateField.define({create:()=>HistoryState.empty,update(state,tr){let config=tr.state.facet(historyConfig),fromHist=tr.annotation(fromHistory);if(fromHist){let selection=tr.docChanged?EditorSelection.single(function(changes){let end=0;return changes.iterChangedRanges(((_,to)=>end=to)),end}(tr.changes)):void 0,item=HistEvent.fromTransaction(tr,selection),from=fromHist.side,other=0==from?state.undone:state.done;return other=item?updateBranch(other,other.length,config.minDepth,item):addSelection(other,tr.startState.selection),new HistoryState(0==from?fromHist.rest:other,0==from?other:fromHist.rest)}let isolate=tr.annotation(isolateHistory);if("full"!=isolate&&"before"!=isolate||(state=state.isolate()),!1===tr.annotation(Transaction.addToHistory))return tr.changes.empty?state:state.addMapping(tr.changes.desc);let event=HistEvent.fromTransaction(tr),time=tr.annotation(Transaction.time),userEvent=tr.annotation(Transaction.userEvent);return event?state=state.addChanges(event,time,userEvent,config,tr):tr.selection&&(state=state.addSelection(tr.startState.selection,time,userEvent,config.newGroupDelay)),"full"!=isolate&&"after"!=isolate||(state=state.isolate()),state},toJSON:value=>({done:value.done.map((e=>e.toJSON())),undone:value.undone.map((e=>e.toJSON()))}),fromJSON:json=>new HistoryState(json.done.map(HistEvent.fromJSON),json.undone.map(HistEvent.fromJSON))});function history(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return[historyField_,historyConfig.of(config),EditorView.domEventHandlers({beforeinput(e,view){let command="historyUndo"==e.inputType?undo:"historyRedo"==e.inputType?redo:null;return!!command&&(e.preventDefault(),command(view))}})]}function cmd(side,selection){return function(_ref11){let{state:state,dispatch:dispatch}=_ref11;if(!selection&&state.readOnly)return!1;let historyState=state.field(historyField_,!1);if(!historyState)return!1;let tr=historyState.pop(side,state,selection);return!!tr&&(dispatch(tr),!0)}}const undo=cmd(0,!1),redo=cmd(1,!1),undoSelection=cmd(0,!0),redoSelection=cmd(1,!0);class HistEvent{constructor(changes,effects,mapped,startSelection,selectionsAfter){this.changes=changes,this.effects=effects,this.mapped=mapped,this.startSelection=startSelection,this.selectionsAfter=selectionsAfter}setSelAfter(after){return new HistEvent(this.changes,this.effects,this.mapped,this.startSelection,after)}toJSON(){var _a,_b,_c;return{changes:null===(_a=this.changes)||void 0===_a?void 0:_a.toJSON(),mapped:null===(_b=this.mapped)||void 0===_b?void 0:_b.toJSON(),startSelection:null===(_c=this.startSelection)||void 0===_c?void 0:_c.toJSON(),selectionsAfter:this.selectionsAfter.map((s=>s.toJSON()))}}static fromJSON(json){return new HistEvent(json.changes&&ChangeSet.fromJSON(json.changes),[],json.mapped&&ChangeDesc.fromJSON(json.mapped),json.startSelection&&EditorSelection.fromJSON(json.startSelection),json.selectionsAfter.map(EditorSelection.fromJSON))}static fromTransaction(tr,selection){let effects=none$1;for(let invert of tr.startState.facet(invertedEffects)){let result=invert(tr);result.length&&(effects=effects.concat(result))}return!effects.length&&tr.changes.empty?null:new HistEvent(tr.changes.invert(tr.startState.doc),effects,void 0,selection||tr.startState.selection,none$1)}static selection(selections){return new HistEvent(void 0,none$1,void 0,void 0,selections)}}function updateBranch(branch,to,maxLen,newEvent){let start=to+1>maxLen+20?to-maxLen-1:0,newBranch=branch.slice(start,to);return newBranch.push(newEvent),newBranch}function conc(a,b){return a.length?b.length?a.concat(b):a:b}const none$1=[];function addSelection(branch,selection){if(branch.length){let lastEvent=branch[branch.length-1],sels=lastEvent.selectionsAfter.slice(Math.max(0,lastEvent.selectionsAfter.length-200));return sels.length&&sels[sels.length-1].eq(selection)?branch:(sels.push(selection),updateBranch(branch,branch.length-1,1e9,lastEvent.setSelAfter(sels)))}return[HistEvent.selection([selection])]}function popSelection(branch){let last=branch[branch.length-1],newBranch=branch.slice();return newBranch[branch.length-1]=last.setSelAfter(last.selectionsAfter.slice(0,last.selectionsAfter.length-1)),newBranch}function addMappingToBranch(branch,mapping){if(!branch.length)return branch;let length=branch.length,selections=none$1;for(;length;){let event=mapEvent(branch[length-1],mapping,selections);if(event.changes&&!event.changes.empty||event.effects.length){let result=branch.slice(0,length);return result[length-1]=event,result}mapping=event.mapped,length--,selections=event.selectionsAfter}return selections.length?[HistEvent.selection(selections)]:none$1}function mapEvent(event,mapping,extraSelections){let selections=conc(event.selectionsAfter.length?event.selectionsAfter.map((s=>s.map(mapping))):none$1,extraSelections);if(!event.changes)return HistEvent.selection(selections);let mappedChanges=event.changes.map(mapping),before=mapping.mapDesc(event.changes,!0),fullMapping=event.mapped?event.mapped.composeDesc(before):before;return new HistEvent(mappedChanges,StateEffect.mapEffects(event.effects,mapping),fullMapping,event.startSelection.map(before),selections)}const joinableUserEvent=/^(input\.type|delete)($|\.)/;class HistoryState{constructor(done,undone){let prevTime=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,prevUserEvent=arguments.length>3&&void 0!==arguments[3]?arguments[3]:void 0;this.done=done,this.undone=undone,this.prevTime=prevTime,this.prevUserEvent=prevUserEvent}isolate(){return this.prevTime?new HistoryState(this.done,this.undone):this}addChanges(event,time,userEvent,config,tr){let done=this.done,lastEvent=done[done.length-1];return done=lastEvent&&lastEvent.changes&&!lastEvent.changes.empty&&event.changes&&(!userEvent||joinableUserEvent.test(userEvent))&&(!lastEvent.selectionsAfter.length&&time-this.prevTime<config.newGroupDelay&&config.joinToEvent(tr,function(a,b){let ranges=[],isAdjacent=!1;return a.iterChangedRanges(((f,t)=>ranges.push(f,t))),b.iterChangedRanges(((_f,_t,f,t)=>{for(let i=0;i<ranges.length;){let from=ranges[i++],to=ranges[i++];t>=from&&f<=to&&(isAdjacent=!0)}})),isAdjacent}(lastEvent.changes,event.changes))||"input.type.compose"==userEvent)?updateBranch(done,done.length-1,config.minDepth,new HistEvent(event.changes.compose(lastEvent.changes),conc(event.effects,lastEvent.effects),lastEvent.mapped,lastEvent.startSelection,none$1)):updateBranch(done,done.length,config.minDepth,event),new HistoryState(done,none$1,time,userEvent)}addSelection(selection,time,userEvent,newGroupDelay){let last=this.done.length?this.done[this.done.length-1].selectionsAfter:none$1;return last.length>0&&time-this.prevTime<newGroupDelay&&userEvent==this.prevUserEvent&&userEvent&&/^select($|\.)/.test(userEvent)&&(a=last[last.length-1],b=selection,a.ranges.length==b.ranges.length&&0===a.ranges.filter(((r,i)=>r.empty!=b.ranges[i].empty)).length)?this:new HistoryState(addSelection(this.done,selection),this.undone,time,userEvent);var a,b}addMapping(mapping){return new HistoryState(addMappingToBranch(this.done,mapping),addMappingToBranch(this.undone,mapping),this.prevTime,this.prevUserEvent)}pop(side,state,selection){let branch=0==side?this.done:this.undone;if(0==branch.length)return null;let event=branch[branch.length-1];if(selection&&event.selectionsAfter.length)return state.update({selection:event.selectionsAfter[event.selectionsAfter.length-1],annotations:fromHistory.of({side:side,rest:popSelection(branch)}),userEvent:0==side?"select.undo":"select.redo",scrollIntoView:!0});if(event.changes){let rest=1==branch.length?none$1:branch.slice(0,branch.length-1);return event.mapped&&(rest=addMappingToBranch(rest,event.mapped)),state.update({changes:event.changes,selection:event.startSelection,effects:event.effects,annotations:fromHistory.of({side:side,rest:rest}),filter:!1,userEvent:0==side?"undo":"redo",scrollIntoView:!0})}return null}}HistoryState.empty=new HistoryState(none$1,none$1);const historyKeymap=[{key:"Mod-z",run:undo,preventDefault:!0},{key:"Mod-y",mac:"Mod-Shift-z",run:redo,preventDefault:!0},{linux:"Ctrl-Shift-z",run:redo,preventDefault:!0},{key:"Mod-u",run:undoSelection,preventDefault:!0},{key:"Alt-u",mac:"Mod-Shift-u",run:redoSelection,preventDefault:!0}];function updateSel(sel,by){return EditorSelection.create(sel.ranges.map(by),sel.mainIndex)}function setSel(state,selection){return state.update({selection:selection,scrollIntoView:!0,userEvent:"select"})}function moveSel(_ref12,how){let{state:state,dispatch:dispatch}=_ref12,selection=updateSel(state.selection,how);return!selection.eq(state.selection)&&(dispatch(setSel(state,selection)),!0)}function rangeEnd(range,forward){return EditorSelection.cursor(forward?range.to:range.from)}function cursorByChar(view,forward){return moveSel(view,(range=>range.empty?view.moveByChar(range,forward):rangeEnd(range,forward)))}function ltrAtCursor(view){return view.textDirectionAt(view.state.selection.main.head)==Direction.LTR}const cursorCharLeft=view=>cursorByChar(view,!ltrAtCursor(view)),cursorCharRight=view=>cursorByChar(view,ltrAtCursor(view));function cursorByGroup(view,forward){return moveSel(view,(range=>range.empty?view.moveByGroup(range,forward):rangeEnd(range,forward)))}function interestingNode(state,node,bracketProp){if(node.type.prop(bracketProp))return!0;let len=node.to-node.from;return len&&(len>2||/[^\s,.;:]/.test(state.sliceDoc(node.from,node.to)))||node.firstChild}function moveBySyntax(state,start,forward){let match,newPos,pos=syntaxTree(state).resolveInner(start.head),bracketProp=forward?NodeProp.closedBy:NodeProp.openedBy;for(let at=start.head;;){let next=forward?pos.childAfter(at):pos.childBefore(at);if(!next)break;interestingNode(state,next,bracketProp)?pos=next:at=forward?next.to:next.from}return newPos=pos.type.prop(bracketProp)&&(match=forward?matchBrackets(state,pos.from,1):matchBrackets(state,pos.to,-1))&&match.matched?forward?match.end.to:match.end.from:forward?pos.to:pos.from,EditorSelection.cursor(newPos,forward?-1:1)}function cursorByLine(view,forward){return moveSel(view,(range=>{if(!range.empty)return rangeEnd(range,forward);let moved=view.moveVertically(range,forward);return moved.head!=range.head?moved:view.moveToLineBoundary(range,forward)}))}const cursorLineUp=view=>cursorByLine(view,!1),cursorLineDown=view=>cursorByLine(view,!0);function pageInfo(view){let height,selfScroll=view.scrollDOM.clientHeight<view.scrollDOM.scrollHeight-2,marginTop=0,marginBottom=0;if(selfScroll){for(let source of view.state.facet(EditorView.scrollMargins)){let margins=source(view);(null==margins?void 0:margins.top)&&(marginTop=Math.max(null==margins?void 0:margins.top,marginTop)),(null==margins?void 0:margins.bottom)&&(marginBottom=Math.max(null==margins?void 0:margins.bottom,marginBottom))}height=view.scrollDOM.clientHeight-marginTop-marginBottom}else height=(view.dom.ownerDocument.defaultView||window).innerHeight;return{marginTop:marginTop,marginBottom:marginBottom,selfScroll:selfScroll,height:Math.max(view.defaultLineHeight,height-5)}}function cursorByPage(view,forward){let effect,page=pageInfo(view),{state:state}=view,selection=updateSel(state.selection,(range=>range.empty?view.moveVertically(range,forward,page.height):rangeEnd(range,forward)));if(selection.eq(state.selection))return!1;if(page.selfScroll){let startPos=view.coordsAtPos(state.selection.main.head),scrollRect=view.scrollDOM.getBoundingClientRect(),scrollTop=scrollRect.top+page.marginTop,scrollBottom=scrollRect.bottom-page.marginBottom;startPos&&startPos.top>scrollTop&&startPos.bottom<scrollBottom&&(effect=EditorView.scrollIntoView(selection.main.head,{y:"start",yMargin:startPos.top-scrollTop}))}return view.dispatch(setSel(state,selection),{effects:effect}),!0}const cursorPageUp=view=>cursorByPage(view,!1),cursorPageDown=view=>cursorByPage(view,!0);function moveByLineBoundary(view,start,forward){let line=view.lineBlockAt(start.head),moved=view.moveToLineBoundary(start,forward);if(moved.head==start.head&&moved.head!=(forward?line.to:line.from)&&(moved=view.moveToLineBoundary(start,forward,!1)),!forward&&moved.head==line.from&&line.length){let space=/^\s*/.exec(view.state.sliceDoc(line.from,Math.min(line.from+100,line.to)))[0].length;space&&start.head!=line.from+space&&(moved=EditorSelection.cursor(line.from+space))}return moved}function extendSel(view,how){let selection=updateSel(view.state.selection,(range=>{let head=how(range);return EditorSelection.range(range.anchor,head.head,head.goalColumn,head.bidiLevel||void 0)}));return!selection.eq(view.state.selection)&&(view.dispatch(setSel(view.state,selection)),!0)}function selectByChar(view,forward){return extendSel(view,(range=>view.moveByChar(range,forward)))}const selectCharLeft=view=>selectByChar(view,!ltrAtCursor(view)),selectCharRight=view=>selectByChar(view,ltrAtCursor(view));function selectByGroup(view,forward){return extendSel(view,(range=>view.moveByGroup(range,forward)))}function selectByLine(view,forward){return extendSel(view,(range=>view.moveVertically(range,forward)))}const selectLineUp=view=>selectByLine(view,!1),selectLineDown=view=>selectByLine(view,!0);function selectByPage(view,forward){return extendSel(view,(range=>view.moveVertically(range,forward,pageInfo(view).height)))}const selectPageUp=view=>selectByPage(view,!1),selectPageDown=view=>selectByPage(view,!0),cursorDocStart=_ref14=>{let{state:state,dispatch:dispatch}=_ref14;return dispatch(setSel(state,{anchor:0})),!0},cursorDocEnd=_ref15=>{let{state:state,dispatch:dispatch}=_ref15;return dispatch(setSel(state,{anchor:state.doc.length})),!0},selectDocStart=_ref16=>{let{state:state,dispatch:dispatch}=_ref16;return dispatch(setSel(state,{anchor:state.selection.main.anchor,head:0})),!0},selectDocEnd=_ref17=>{let{state:state,dispatch:dispatch}=_ref17;return dispatch(setSel(state,{anchor:state.selection.main.anchor,head:state.doc.length})),!0};function deleteBy(target,by){if(target.state.readOnly)return!1;let event="delete.selection",{state:state}=target,changes=state.changeByRange((range=>{let{from:from,to:to}=range;if(from==to){let towards=by(from);towards<from?(event="delete.backward",towards=skipAtomic(target,towards,!1)):towards>from&&(event="delete.forward",towards=skipAtomic(target,towards,!0)),from=Math.min(from,towards),to=Math.max(to,towards)}else from=skipAtomic(target,from,!1),to=skipAtomic(target,to,!0);return from==to?{range:range}:{changes:{from:from,to:to},range:EditorSelection.cursor(from)}}));return!changes.changes.empty&&(target.dispatch(state.update(changes,{scrollIntoView:!0,userEvent:event,effects:"delete.selection"==event?EditorView.announce.of(state.phrase("Selection deleted")):void 0})),!0)}function skipAtomic(target,pos,forward){if(target instanceof EditorView)for(let ranges of target.state.facet(EditorView.atomicRanges).map((f=>f(target))))ranges.between(pos,pos,((from,to)=>{from<pos&&to>pos&&(pos=forward?to:from)}));return pos}const deleteByChar=(target,forward)=>deleteBy(target,(pos=>{let before,targetPos,{state:state}=target,line=state.doc.lineAt(pos);if(!forward&&pos>line.from&&pos<line.from+200&&!/[^ \t]/.test(before=line.text.slice(0,pos-line.from))){if("\t"==before[before.length-1])return pos-1;let drop=countColumn(before,state.tabSize)%getIndentUnit(state)||getIndentUnit(state);for(let i=0;i<drop&&" "==before[before.length-1-i];i++)pos--;targetPos=pos}else targetPos=findClusterBreak(line.text,pos-line.from,forward,forward)+line.from,targetPos==pos&&line.number!=(forward?state.doc.lines:1)&&(targetPos+=forward?1:-1);return targetPos})),deleteCharBackward=view=>deleteByChar(view,!1),deleteCharForward=view=>deleteByChar(view,!0),deleteByGroup=(target,forward)=>deleteBy(target,(start=>{let pos=start,{state:state}=target,line=state.doc.lineAt(pos),categorize=state.charCategorizer(pos);for(let cat=null;;){if(pos==(forward?line.to:line.from)){pos==start&&line.number!=(forward?state.doc.lines:1)&&(pos+=forward?1:-1);break}let next=findClusterBreak(line.text,pos-line.from,forward)+line.from,nextChar=line.text.slice(Math.min(pos,next)-line.from,Math.max(pos,next)-line.from),nextCat=categorize(nextChar);if(null!=cat&&nextCat!=cat)break;" "==nextChar&&pos==start||(cat=nextCat),pos=next}return pos})),deleteGroupBackward=target=>deleteByGroup(target,!1),deleteToLineEnd=view=>deleteBy(view,(pos=>{let lineEnd=view.lineBlockAt(pos).to;return pos<lineEnd?lineEnd:Math.min(view.state.doc.length,pos+1)}));function selectedLineBlocks(state){let blocks=[],upto=-1;for(let range of state.selection.ranges){let startLine=state.doc.lineAt(range.from),endLine=state.doc.lineAt(range.to);if(range.empty||range.to!=endLine.from||(endLine=state.doc.lineAt(range.to-1)),upto>=startLine.number){let prev=blocks[blocks.length-1];prev.to=endLine.to,prev.ranges.push(range)}else blocks.push({from:startLine.from,to:endLine.to,ranges:[range]});upto=endLine.number+1}return blocks}function moveLine(state,dispatch,forward){if(state.readOnly)return!1;let changes=[],ranges=[];for(let block of selectedLineBlocks(state)){if(forward?block.to==state.doc.length:0==block.from)continue;let nextLine=state.doc.lineAt(forward?block.to+1:block.from-1),size=nextLine.length+1;if(forward){changes.push({from:block.to,to:nextLine.to},{from:block.from,insert:nextLine.text+state.lineBreak});for(let r of block.ranges)ranges.push(EditorSelection.range(Math.min(state.doc.length,r.anchor+size),Math.min(state.doc.length,r.head+size)))}else{changes.push({from:nextLine.from,to:block.from},{from:block.to,insert:state.lineBreak+nextLine.text});for(let r of block.ranges)ranges.push(EditorSelection.range(r.anchor-size,r.head-size))}}return!!changes.length&&(dispatch(state.update({changes:changes,scrollIntoView:!0,selection:EditorSelection.create(ranges,state.selection.mainIndex),userEvent:"move.line"})),!0)}function copyLine(state,dispatch,forward){if(state.readOnly)return!1;let changes=[];for(let block of selectedLineBlocks(state))forward?changes.push({from:block.from,insert:state.doc.slice(block.from,block.to)+state.lineBreak}):changes.push({from:block.to,insert:state.lineBreak+state.doc.slice(block.from,block.to)});return dispatch(state.update({changes:changes,scrollIntoView:!0,userEvent:"input.copyline"})),!0}const insertNewlineAndIndent=newlineAndIndent(!1),insertBlankLine=newlineAndIndent(!0);function newlineAndIndent(atEof){return _ref30=>{let{state:state,dispatch:dispatch}=_ref30;if(state.readOnly)return!1;let changes=state.changeByRange((range=>{let{from:from,to:to}=range,line=state.doc.lineAt(from),explode=!atEof&&from==to&&function(state,pos){if(/\(\)|\[\]|\{\}/.test(state.sliceDoc(pos-1,pos+1)))return{from:pos,to:pos};let closedBy,context=syntaxTree(state).resolveInner(pos),before=context.childBefore(pos),after=context.childAfter(pos);return before&&after&&before.to<=pos&&after.from>=pos&&(closedBy=before.type.prop(NodeProp.closedBy))&&closedBy.indexOf(after.name)>-1&&state.doc.lineAt(before.to).from==state.doc.lineAt(after.from).from?{from:before.to,to:after.from}:null}(state,from);atEof&&(from=to=(to<=line.to?line:state.doc.lineAt(to)).to);let cx=new IndentContext(state,{simulateBreak:from,simulateDoubleBreak:!!explode}),indent=getIndentation(cx,from);for(null==indent&&(indent=/^\s*/.exec(state.doc.lineAt(from).text)[0].length);to<line.to&&/\s/.test(line.text[to-line.from]);)to++;explode?({from:from,to:to}=explode):from>line.from&&from<line.from+100&&!/\S/.test(line.text.slice(0,from))&&(from=line.from);let insert=["",indentString(state,indent)];return explode&&insert.push(indentString(state,cx.lineIndent(line.from,-1))),{changes:{from:from,to:to,insert:Text.of(insert)},range:EditorSelection.cursor(from+1+insert[1].length)}}));return dispatch(state.update(changes,{scrollIntoView:!0,userEvent:"input"})),!0}}function changeBySelectedLine(state,f){let atLine=-1;return state.changeByRange((range=>{let changes=[];for(let pos=range.from;pos<=range.to;){let line=state.doc.lineAt(pos);line.number>atLine&&(range.empty||range.to>line.from)&&(f(line,changes,range),atLine=line.number),pos=line.to+1}let changeSet=state.changes(changes);return{changes:changes,range:EditorSelection.range(changeSet.mapPos(range.anchor,1),changeSet.mapPos(range.head,1))}}))}const standardKeymap=[{key:"ArrowLeft",run:cursorCharLeft,shift:selectCharLeft,preventDefault:!0},{key:"Mod-ArrowLeft",mac:"Alt-ArrowLeft",run:view=>cursorByGroup(view,!ltrAtCursor(view)),shift:view=>selectByGroup(view,!ltrAtCursor(view)),preventDefault:!0},{mac:"Cmd-ArrowLeft",run:view=>moveSel(view,(range=>moveByLineBoundary(view,range,!ltrAtCursor(view)))),shift:view=>extendSel(view,(range=>moveByLineBoundary(view,range,!ltrAtCursor(view)))),preventDefault:!0},{key:"ArrowRight",run:cursorCharRight,shift:selectCharRight,preventDefault:!0},{key:"Mod-ArrowRight",mac:"Alt-ArrowRight",run:view=>cursorByGroup(view,ltrAtCursor(view)),shift:view=>selectByGroup(view,ltrAtCursor(view)),preventDefault:!0},{mac:"Cmd-ArrowRight",run:view=>moveSel(view,(range=>moveByLineBoundary(view,range,ltrAtCursor(view)))),shift:view=>extendSel(view,(range=>moveByLineBoundary(view,range,ltrAtCursor(view)))),preventDefault:!0},{key:"ArrowUp",run:cursorLineUp,shift:selectLineUp,preventDefault:!0},{mac:"Cmd-ArrowUp",run:cursorDocStart,shift:selectDocStart},{mac:"Ctrl-ArrowUp",run:cursorPageUp,shift:selectPageUp},{key:"ArrowDown",run:cursorLineDown,shift:selectLineDown,preventDefault:!0},{mac:"Cmd-ArrowDown",run:cursorDocEnd,shift:selectDocEnd},{mac:"Ctrl-ArrowDown",run:cursorPageDown,shift:selectPageDown},{key:"PageUp",run:cursorPageUp,shift:selectPageUp},{key:"PageDown",run:cursorPageDown,shift:selectPageDown},{key:"Home",run:view=>moveSel(view,(range=>moveByLineBoundary(view,range,!1))),shift:view=>extendSel(view,(range=>moveByLineBoundary(view,range,!1))),preventDefault:!0},{key:"Mod-Home",run:cursorDocStart,shift:selectDocStart},{key:"End",run:view=>moveSel(view,(range=>moveByLineBoundary(view,range,!0))),shift:view=>extendSel(view,(range=>moveByLineBoundary(view,range,!0))),preventDefault:!0},{key:"Mod-End",run:cursorDocEnd,shift:selectDocEnd},{key:"Enter",run:insertNewlineAndIndent},{key:"Mod-a",run:_ref18=>{let{state:state,dispatch:dispatch}=_ref18;return dispatch(state.update({selection:{anchor:0,head:state.doc.length},userEvent:"select"})),!0}},{key:"Backspace",run:deleteCharBackward,shift:deleteCharBackward},{key:"Delete",run:deleteCharForward},{key:"Mod-Backspace",mac:"Alt-Backspace",run:deleteGroupBackward},{key:"Mod-Delete",mac:"Alt-Delete",run:target=>deleteByGroup(target,!0)},{mac:"Mod-Backspace",run:view=>deleteBy(view,(pos=>{let lineStart=view.lineBlockAt(pos).from;return pos>lineStart?lineStart:Math.max(0,pos-1)}))},{mac:"Mod-Delete",run:deleteToLineEnd}].concat([{key:"Ctrl-b",run:cursorCharLeft,shift:selectCharLeft,preventDefault:!0},{key:"Ctrl-f",run:cursorCharRight,shift:selectCharRight},{key:"Ctrl-p",run:cursorLineUp,shift:selectLineUp},{key:"Ctrl-n",run:cursorLineDown,shift:selectLineDown},{key:"Ctrl-a",run:view=>moveSel(view,(range=>EditorSelection.cursor(view.lineBlockAt(range.head).from,1))),shift:view=>extendSel(view,(range=>EditorSelection.cursor(view.lineBlockAt(range.head).from)))},{key:"Ctrl-e",run:view=>moveSel(view,(range=>EditorSelection.cursor(view.lineBlockAt(range.head).to,-1))),shift:view=>extendSel(view,(range=>EditorSelection.cursor(view.lineBlockAt(range.head).to)))},{key:"Ctrl-d",run:deleteCharForward},{key:"Ctrl-h",run:deleteCharBackward},{key:"Ctrl-k",run:deleteToLineEnd},{key:"Ctrl-Alt-h",run:deleteGroupBackward},{key:"Ctrl-o",run:_ref23=>{let{state:state,dispatch:dispatch}=_ref23;if(state.readOnly)return!1;let changes=state.changeByRange((range=>({changes:{from:range.from,to:range.to,insert:Text.of(["",""])},range:EditorSelection.cursor(range.from)})));return dispatch(state.update(changes,{scrollIntoView:!0,userEvent:"input"})),!0}},{key:"Ctrl-t",run:_ref24=>{let{state:state,dispatch:dispatch}=_ref24;if(state.readOnly)return!1;let changes=state.changeByRange((range=>{if(!range.empty||0==range.from||range.from==state.doc.length)return{range:range};let pos=range.from,line=state.doc.lineAt(pos),from=pos==line.from?pos-1:findClusterBreak(line.text,pos-line.from,!1)+line.from,to=pos==line.to?pos+1:findClusterBreak(line.text,pos-line.from,!0)+line.from;return{changes:{from:from,to:to,insert:state.doc.slice(pos,to).append(state.doc.slice(from,pos))},range:EditorSelection.cursor(to)}}));return!changes.changes.empty&&(dispatch(state.update(changes,{scrollIntoView:!0,userEvent:"move.character"})),!0)}},{key:"Ctrl-v",run:cursorPageDown}].map((b=>({mac:b.key,run:b.run,shift:b.shift})))),defaultKeymap=[{key:"Alt-ArrowLeft",mac:"Ctrl-ArrowLeft",run:view=>moveSel(view,(range=>moveBySyntax(view.state,range,!ltrAtCursor(view)))),shift:view=>extendSel(view,(range=>moveBySyntax(view.state,range,!ltrAtCursor(view))))},{key:"Alt-ArrowRight",mac:"Ctrl-ArrowRight",run:view=>moveSel(view,(range=>moveBySyntax(view.state,range,ltrAtCursor(view)))),shift:view=>extendSel(view,(range=>moveBySyntax(view.state,range,ltrAtCursor(view))))},{key:"Alt-ArrowUp",run:_ref25=>{let{state:state,dispatch:dispatch}=_ref25;return moveLine(state,dispatch,!1)}},{key:"Shift-Alt-ArrowUp",run:_ref27=>{let{state:state,dispatch:dispatch}=_ref27;return copyLine(state,dispatch,!1)}},{key:"Alt-ArrowDown",run:_ref26=>{let{state:state,dispatch:dispatch}=_ref26;return moveLine(state,dispatch,!0)}},{key:"Shift-Alt-ArrowDown",run:_ref28=>{let{state:state,dispatch:dispatch}=_ref28;return copyLine(state,dispatch,!0)}},{key:"Escape",run:_ref22=>{let{state:state,dispatch:dispatch}=_ref22,cur=state.selection,selection=null;return cur.ranges.length>1?selection=EditorSelection.create([cur.main]):cur.main.empty||(selection=EditorSelection.create([EditorSelection.cursor(cur.main.head)])),!!selection&&(dispatch(setSel(state,selection)),!0)}},{key:"Mod-Enter",run:insertBlankLine},{key:"Alt-l",mac:"Ctrl-l",run:_ref19=>{let{state:state,dispatch:dispatch}=_ref19,ranges=selectedLineBlocks(state).map((_ref20=>{let{from:from,to:to}=_ref20;return EditorSelection.range(from,Math.min(to+1,state.doc.length))}));return dispatch(state.update({selection:EditorSelection.create(ranges),userEvent:"select"})),!0}},{key:"Mod-i",run:_ref21=>{let{state:state,dispatch:dispatch}=_ref21,selection=updateSel(state.selection,(range=>{var _a;let context=syntaxTree(state).resolveInner(range.head,1);for(;!(context.from<range.from&&context.to>=range.to||context.to>range.to&&context.from<=range.from)&&(null===(_a=context.parent)||void 0===_a?void 0:_a.parent);)context=context.parent;return EditorSelection.range(context.to,context.from)}));return dispatch(setSel(state,selection)),!0},preventDefault:!0},{key:"Mod-[",run:_ref33=>{let{state:state,dispatch:dispatch}=_ref33;return!state.readOnly&&(dispatch(state.update(changeBySelectedLine(state,((line,changes)=>{let space=/^\s*/.exec(line.text)[0];if(!space)return;let col=countColumn(space,state.tabSize),keep=0,insert=indentString(state,Math.max(0,col-getIndentUnit(state)));for(;keep<space.length&&keep<insert.length&&space.charCodeAt(keep)==insert.charCodeAt(keep);)keep++;changes.push({from:line.from+keep,to:line.from+space.length,insert:insert.slice(keep)})})),{userEvent:"delete.dedent"})),!0)}},{key:"Mod-]",run:_ref32=>{let{state:state,dispatch:dispatch}=_ref32;return!state.readOnly&&(dispatch(state.update(changeBySelectedLine(state,((line,changes)=>{changes.push({from:line.from,insert:state.facet(indentUnit)})})),{userEvent:"input.indent"})),!0)}},{key:"Mod-Alt-\\",run:_ref31=>{let{state:state,dispatch:dispatch}=_ref31;if(state.readOnly)return!1;let updated=Object.create(null),context=new IndentContext(state,{overrideIndentation:start=>{let found=updated[start];return null==found?-1:found}}),changes=changeBySelectedLine(state,((line,changes,range)=>{let indent=getIndentation(context,line.from);if(null==indent)return;/\S/.test(line.text)||(indent=0);let cur=/^\s*/.exec(line.text)[0],norm=indentString(state,indent);(cur!=norm||range.from<line.from+cur.length)&&(updated[line.from]=indent,changes.push({from:line.from,to:line.from+cur.length,insert:norm}))}));return changes.changes.empty||dispatch(state.update(changes,{userEvent:"indent"})),!0}},{key:"Shift-Mod-k",run:view=>{if(view.state.readOnly)return!1;let{state:state}=view,changes=state.changes(selectedLineBlocks(state).map((_ref29=>{let{from:from,to:to}=_ref29;return from>0?from--:to<state.doc.length&&to++,{from:from,to:to}}))),selection=updateSel(state.selection,(range=>view.moveVertically(range,!0))).map(changes);return view.dispatch({changes:changes,selection:selection,scrollIntoView:!0,userEvent:"delete.line"}),!0}},{key:"Shift-Mod-\\",run:_ref13=>{let{state:state,dispatch:dispatch}=_ref13;return function(state,dispatch,extend){let found=!1,selection=updateSel(state.selection,(range=>{let matching=matchBrackets(state,range.head,-1)||matchBrackets(state,range.head,1)||range.head>0&&matchBrackets(state,range.head-1,1)||range.head<state.doc.length&&matchBrackets(state,range.head+1,-1);if(!matching||!matching.end)return range;found=!0;let head=matching.start.from==range.head?matching.end.to:matching.end.from;return extend?EditorSelection.range(range.anchor,head):EditorSelection.cursor(head)}));return!!found&&(dispatch(setSel(state,selection)),!0)}(state,dispatch,!1)}},{key:"Mod-/",run:target=>{let{state:state}=target,line=state.doc.lineAt(state.selection.main.from),config=getConfig(target.state,line.from);return config.line?toggleLineComment(target):!!config.block&&toggleBlockCommentByLine(target)}},{key:"Alt-A",run:toggleBlockComment}].concat(standardKeymap);function crelt(){var elt=arguments[0];"string"==typeof elt&&(elt=document.createElement(elt));var i=1,next=arguments[1];if(next&&"object"==typeof next&&null==next.nodeType&&!Array.isArray(next)){for(var name in next)if(Object.prototype.hasOwnProperty.call(next,name)){var value=next[name];"string"==typeof value?elt.setAttribute(name,value):null!=value&&(elt[name]=value)}i++}for(;i<arguments.length;i++)add(elt,arguments[i]);return elt}function add(elt,child){if("string"==typeof child)elt.appendChild(document.createTextNode(child));else if(null==child);else if(null!=child.nodeType)elt.appendChild(child);else{if(!Array.isArray(child))throw new RangeError("Unsupported child node: "+child);for(var i=0;i<child.length;i++)add(elt,child[i])}}const basicNormalize="function"==typeof String.prototype.normalize?x=>x.normalize("NFKD"):x=>x;class SearchCursor{constructor(text,query){let from=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,to=arguments.length>3&&void 0!==arguments[3]?arguments[3]:text.length,normalize=arguments.length>4?arguments[4]:void 0,test=arguments.length>5?arguments[5]:void 0;this.test=test,this.value={from:0,to:0},this.done=!1,this.matches=[],this.buffer="",this.bufferPos=0,this.iter=text.iterRange(from,to),this.bufferStart=from,this.normalize=normalize?x=>normalize(basicNormalize(x)):basicNormalize,this.query=this.normalize(query)}peek(){if(this.bufferPos==this.buffer.length){if(this.bufferStart+=this.buffer.length,this.iter.next(),this.iter.done)return-1;this.bufferPos=0,this.buffer=this.iter.value}return codePointAt(this.buffer,this.bufferPos)}next(){for(;this.matches.length;)this.matches.pop();return this.nextOverlapping()}nextOverlapping(){for(;;){let next=this.peek();if(next<0)return this.done=!0,this;let str=fromCodePoint(next),start=this.bufferStart+this.bufferPos;this.bufferPos+=codePointSize(next);let norm=this.normalize(str);for(let i=0,pos=start;;i++){let code=norm.charCodeAt(i),match=this.match(code,pos);if(match)return this.value=match,this;if(i==norm.length-1)break;pos==start&&i<str.length&&str.charCodeAt(i)==code&&pos++}}}match(code,pos){let match=null;for(let i=0;i<this.matches.length;i+=2){let index=this.matches[i],keep=!1;this.query.charCodeAt(index)==code&&(index==this.query.length-1?match={from:this.matches[i+1],to:pos+1}:(this.matches[i]++,keep=!0)),keep||(this.matches.splice(i,2),i-=2)}return this.query.charCodeAt(0)==code&&(1==this.query.length?match={from:pos,to:pos+1}:this.matches.push(1,pos)),match&&this.test&&!this.test(match.from,match.to,this.buffer,this.bufferPos)&&(match=null),match}}"undefined"!=typeof Symbol&&(SearchCursor.prototype[Symbol.iterator]=function(){return this});const empty={from:-1,to:-1,match:/.*/.exec("")},baseFlags="gm"+(null==/x/.unicode?"":"u");class RegExpCursor{constructor(text,query,options){let from=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,to=arguments.length>4&&void 0!==arguments[4]?arguments[4]:text.length;if(this.text=text,this.to=to,this.curLine="",this.done=!1,this.value=empty,/\\[sWDnr]|\n|\r|\[\^/.test(query))return new MultilineRegExpCursor(text,query,options,from,to);this.re=new RegExp(query,baseFlags+((null==options?void 0:options.ignoreCase)?"i":"")),this.test=null==options?void 0:options.test,this.iter=text.iter();let startLine=text.lineAt(from);this.curLineStart=startLine.from,this.matchPos=toCharEnd(text,from),this.getLine(this.curLineStart)}getLine(skip){this.iter.next(skip),this.iter.lineBreak?this.curLine="":(this.curLine=this.iter.value,this.curLineStart+this.curLine.length>this.to&&(this.curLine=this.curLine.slice(0,this.to-this.curLineStart)),this.iter.next())}nextLine(){this.curLineStart=this.curLineStart+this.curLine.length+1,this.curLineStart>this.to?this.curLine="":this.getLine(0)}next(){for(let off=this.matchPos-this.curLineStart;;){this.re.lastIndex=off;let match=this.matchPos<=this.to&&this.re.exec(this.curLine);if(match){let from=this.curLineStart+match.index,to=from+match[0].length;if(this.matchPos=toCharEnd(this.text,to+(from==to?1:0)),from==this.curLineStart+this.curLine.length&&this.nextLine(),(from<to||from>this.value.to)&&(!this.test||this.test(from,to,match)))return this.value={from:from,to:to,match:match},this;off=this.matchPos-this.curLineStart}else{if(!(this.curLineStart+this.curLine.length<this.to))return this.done=!0,this;this.nextLine(),off=0}}}}const flattened=new WeakMap;class FlattenedDoc{constructor(from,text){this.from=from,this.text=text}get to(){return this.from+this.text.length}static get(doc,from,to){let cached=flattened.get(doc);if(!cached||cached.from>=to||cached.to<=from){let flat=new FlattenedDoc(from,doc.sliceString(from,to));return flattened.set(doc,flat),flat}if(cached.from==from&&cached.to==to)return cached;let{text:text,from:cachedFrom}=cached;return cachedFrom>from&&(text=doc.sliceString(from,cachedFrom)+text,cachedFrom=from),cached.to<to&&(text+=doc.sliceString(cached.to,to)),flattened.set(doc,new FlattenedDoc(cachedFrom,text)),new FlattenedDoc(from,text.slice(from-cachedFrom,to-cachedFrom))}}class MultilineRegExpCursor{constructor(text,query,options,from,to){this.text=text,this.to=to,this.done=!1,this.value=empty,this.matchPos=toCharEnd(text,from),this.re=new RegExp(query,baseFlags+((null==options?void 0:options.ignoreCase)?"i":"")),this.test=null==options?void 0:options.test,this.flat=FlattenedDoc.get(text,from,this.chunkEnd(from+5e3))}chunkEnd(pos){return pos>=this.to?this.to:this.text.lineAt(pos).to}next(){for(;;){let off=this.re.lastIndex=this.matchPos-this.flat.from,match=this.re.exec(this.flat.text);if(match&&!match[0]&&match.index==off&&(this.re.lastIndex=off+1,match=this.re.exec(this.flat.text)),match){let from=this.flat.from+match.index,to=from+match[0].length;if((this.flat.to>=this.to||match.index+match[0].length<=this.flat.text.length-10)&&(!this.test||this.test(from,to,match)))return this.value={from:from,to:to,match:match},this.matchPos=toCharEnd(this.text,to+(from==to?1:0)),this}if(this.flat.to==this.to)return this.done=!0,this;this.flat=FlattenedDoc.get(this.text,this.flat.from,this.chunkEnd(this.flat.from+2*this.flat.text.length))}}}function toCharEnd(text,pos){if(pos>=text.length)return pos;let next,line=text.lineAt(pos);for(;pos<line.to&&(next=line.text.charCodeAt(pos-line.from))>=56320&&next<57344;)pos++;return pos}function createLineDialog(view){let input=crelt("input",{class:"cm-textfield",name:"line"});function go(){let match=/^([+-])?(\d+)?(:\d+)?(%)?$/.exec(input.value);if(!match)return;let{state:state}=view,startLine=state.doc.lineAt(state.selection.main.head),[,sign,ln,cl,percent]=match,col=cl?+cl.slice(1):0,line=ln?+ln:startLine.number;if(ln&&percent){let pc=line/100;sign&&(pc=pc*("-"==sign?-1:1)+startLine.number/state.doc.lines),line=Math.round(state.doc.lines*pc)}else ln&&sign&&(line=line*("-"==sign?-1:1)+startLine.number);let docLine=state.doc.line(Math.max(1,Math.min(state.doc.lines,line)));view.dispatch({effects:dialogEffect.of(!1),selection:EditorSelection.cursor(docLine.from+Math.max(0,Math.min(col,docLine.length))),scrollIntoView:!0}),view.focus()}return{dom:crelt("form",{class:"cm-gotoLine",onkeydown:event=>{27==event.keyCode?(event.preventDefault(),view.dispatch({effects:dialogEffect.of(!1)}),view.focus()):13==event.keyCode&&(event.preventDefault(),go())},onsubmit:event=>{event.preventDefault(),go()}},crelt("label",view.state.phrase("Go to line"),": ",input)," ",crelt("button",{class:"cm-button",type:"submit"},view.state.phrase("go")))}}"undefined"!=typeof Symbol&&(RegExpCursor.prototype[Symbol.iterator]=MultilineRegExpCursor.prototype[Symbol.iterator]=function(){return this});const dialogEffect=StateEffect.define(),dialogField=StateField.define({create:()=>!0,update(value,tr){for(let e of tr.effects)e.is(dialogEffect)&&(value=e.value);return value},provide:f=>showPanel.from(f,(val=>val?createLineDialog:null))}),baseTheme$1$1=EditorView.baseTheme({".cm-panel.cm-gotoLine":{padding:"2px 6px 4px","& label":{fontSize:"80%"}}}),defaultHighlightOptions={highlightWordAroundCursor:!1,minSelectionLength:1,maxMatches:100,wholeWords:!1},highlightConfig=Facet.define({combine:options=>combineConfig(options,defaultHighlightOptions,{highlightWordAroundCursor:(a,b)=>a||b,minSelectionLength:Math.min,maxMatches:Math.min})});function highlightSelectionMatches(options){let ext=[defaultTheme,matchHighlighter];return options&&ext.push(highlightConfig.of(options)),ext}const matchDeco=Decoration.mark({class:"cm-selectionMatch"}),mainMatchDeco=Decoration.mark({class:"cm-selectionMatch cm-selectionMatch-main"});function insideWordBoundaries(check,state,from,to){return!(0!=from&&check(state.sliceDoc(from-1,from))==CharCategory.Word||to!=state.doc.length&&check(state.sliceDoc(to,to+1))==CharCategory.Word)}const matchHighlighter=ViewPlugin.fromClass(class{constructor(view){this.decorations=this.getDeco(view)}update(update){(update.selectionSet||update.docChanged||update.viewportChanged)&&(this.decorations=this.getDeco(update.view))}getDeco(view){let conf=view.state.facet(highlightConfig),{state:state}=view,sel=state.selection;if(sel.ranges.length>1)return Decoration.none;let query,range=sel.main,check=null;if(range.empty){if(!conf.highlightWordAroundCursor)return Decoration.none;let word=state.wordAt(range.head);if(!word)return Decoration.none;check=state.charCategorizer(range.head),query=state.sliceDoc(word.from,word.to)}else{let len=range.to-range.from;if(len<conf.minSelectionLength||len>200)return Decoration.none;if(conf.wholeWords){if(query=state.sliceDoc(range.from,range.to),check=state.charCategorizer(range.head),!insideWordBoundaries(check,state,range.from,range.to)||!function(check,state,from,to){return check(state.sliceDoc(from,from+1))==CharCategory.Word&&check(state.sliceDoc(to-1,to))==CharCategory.Word}(check,state,range.from,range.to))return Decoration.none}else if(query=state.sliceDoc(range.from,range.to).trim(),!query)return Decoration.none}let deco=[];for(let part of view.visibleRanges){let cursor=new SearchCursor(state.doc,query,part.from,part.to);for(;!cursor.next().done;){let{from:from,to:to}=cursor.value;if((!check||insideWordBoundaries(check,state,from,to))&&(range.empty&&from<=range.from&&to>=range.to?deco.push(mainMatchDeco.range(from,to)):(from>=range.to||to<=range.from)&&deco.push(matchDeco.range(from,to)),deco.length>conf.maxMatches))return Decoration.none}}return Decoration.set(deco)}},{decorations:v=>v.decorations}),defaultTheme=EditorView.baseTheme({".cm-selectionMatch":{backgroundColor:"#99ff7780"},".cm-searchMatch .cm-selectionMatch":{backgroundColor:"transparent"}});const searchConfigFacet=Facet.define({combine:configs=>combineConfig(configs,{top:!1,caseSensitive:!1,literal:!1,regexp:!1,wholeWord:!1,createPanel:view=>new SearchPanel(view),scrollToMatch:range=>EditorView.scrollIntoView(range)})});class SearchQuery{constructor(config){this.search=config.search,this.caseSensitive=!!config.caseSensitive,this.literal=!!config.literal,this.regexp=!!config.regexp,this.replace=config.replace||"",this.valid=!!this.search&&(!this.regexp||function(source){try{return new RegExp(source,baseFlags),!0}catch(_a){return!1}}(this.search)),this.unquoted=this.unquote(this.search),this.wholeWord=!!config.wholeWord}unquote(text){return this.literal?text:text.replace(/\\([nrt\\])/g,((_,ch)=>"n"==ch?"\n":"r"==ch?"\r":"t"==ch?"\t":"\\"))}eq(other){return this.search==other.search&&this.replace==other.replace&&this.caseSensitive==other.caseSensitive&&this.regexp==other.regexp&&this.wholeWord==other.wholeWord}create(){return this.regexp?new RegExpQuery(this):new StringQuery(this)}getCursor(state){let from=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,to=arguments.length>2?arguments[2]:void 0,st=state.doc?state:EditorState.create({doc:state});return null==to&&(to=st.doc.length),this.regexp?regexpCursor(this,st,from,to):stringCursor(this,st,from,to)}}class QueryType{constructor(spec){this.spec=spec}}function stringCursor(spec,state,from,to){return new SearchCursor(state.doc,spec.unquoted,from,to,spec.caseSensitive?void 0:x=>x.toLowerCase(),spec.wholeWord?function(doc,categorizer){return(from,to,buf,bufPos)=>((bufPos>from||bufPos+buf.length<to)&&(bufPos=Math.max(0,from-2),buf=doc.sliceString(bufPos,Math.min(doc.length,to+2))),!(categorizer(charBefore(buf,from-bufPos))==CharCategory.Word&&categorizer(charAfter(buf,from-bufPos))==CharCategory.Word||categorizer(charAfter(buf,to-bufPos))==CharCategory.Word&&categorizer(charBefore(buf,to-bufPos))==CharCategory.Word))}(state.doc,state.charCategorizer(state.selection.main.head)):void 0)}class StringQuery extends QueryType{constructor(spec){super(spec)}nextMatch(state,curFrom,curTo){let cursor=stringCursor(this.spec,state,curTo,state.doc.length).nextOverlapping();return cursor.done&&(cursor=stringCursor(this.spec,state,0,curFrom).nextOverlapping()),cursor.done?null:cursor.value}prevMatchInRange(state,from,to){for(let pos=to;;){let start=Math.max(from,pos-1e4-this.spec.unquoted.length),cursor=stringCursor(this.spec,state,start,pos),range=null;for(;!cursor.nextOverlapping().done;)range=cursor.value;if(range)return range;if(start==from)return null;pos-=1e4}}prevMatch(state,curFrom,curTo){return this.prevMatchInRange(state,0,curFrom)||this.prevMatchInRange(state,curTo,state.doc.length)}getReplacement(_result){return this.spec.unquote(this.spec.replace)}matchAll(state,limit){let cursor=stringCursor(this.spec,state,0,state.doc.length),ranges=[];for(;!cursor.next().done;){if(ranges.length>=limit)return null;ranges.push(cursor.value)}return ranges}highlight(state,from,to,add){let cursor=stringCursor(this.spec,state,Math.max(0,from-this.spec.unquoted.length),Math.min(to+this.spec.unquoted.length,state.doc.length));for(;!cursor.next().done;)add(cursor.value.from,cursor.value.to)}}function regexpCursor(spec,state,from,to){return new RegExpCursor(state.doc,spec.search,{ignoreCase:!spec.caseSensitive,test:spec.wholeWord?(categorizer=state.charCategorizer(state.selection.main.head),(_from,_to,match)=>!match[0].length||(categorizer(charBefore(match.input,match.index))!=CharCategory.Word||categorizer(charAfter(match.input,match.index))!=CharCategory.Word)&&(categorizer(charAfter(match.input,match.index+match[0].length))!=CharCategory.Word||categorizer(charBefore(match.input,match.index+match[0].length))!=CharCategory.Word)):void 0},from,to);var categorizer}function charBefore(str,index){return str.slice(findClusterBreak(str,index,!1),index)}function charAfter(str,index){return str.slice(index,findClusterBreak(str,index))}class RegExpQuery extends QueryType{nextMatch(state,curFrom,curTo){let cursor=regexpCursor(this.spec,state,curTo,state.doc.length).next();return cursor.done&&(cursor=regexpCursor(this.spec,state,0,curFrom).next()),cursor.done?null:cursor.value}prevMatchInRange(state,from,to){for(let size=1;;size++){let start=Math.max(from,to-1e4*size),cursor=regexpCursor(this.spec,state,start,to),range=null;for(;!cursor.next().done;)range=cursor.value;if(range&&(start==from||range.from>start+10))return range;if(start==from)return null}}prevMatch(state,curFrom,curTo){return this.prevMatchInRange(state,0,curFrom)||this.prevMatchInRange(state,curTo,state.doc.length)}getReplacement(result){return this.spec.unquote(this.spec.replace.replace(/\$([$&\d+])/g,((m,i)=>"$"==i?"$":"&"==i?result.match[0]:"0"!=i&&+i<result.match.length?result.match[i]:m)))}matchAll(state,limit){let cursor=regexpCursor(this.spec,state,0,state.doc.length),ranges=[];for(;!cursor.next().done;){if(ranges.length>=limit)return null;ranges.push(cursor.value)}return ranges}highlight(state,from,to,add){let cursor=regexpCursor(this.spec,state,Math.max(0,from-250),Math.min(to+250,state.doc.length));for(;!cursor.next().done;)add(cursor.value.from,cursor.value.to)}}const setSearchQuery=StateEffect.define(),togglePanel$1=StateEffect.define(),searchState=StateField.define({create:state=>new SearchState(defaultQuery(state).create(),null),update(value,tr){for(let effect of tr.effects)effect.is(setSearchQuery)?value=new SearchState(effect.value.create(),value.panel):effect.is(togglePanel$1)&&(value=new SearchState(value.query,effect.value?createSearchPanel:null));return value},provide:f=>showPanel.from(f,(val=>val.panel))});class SearchState{constructor(query,panel){this.query=query,this.panel=panel}}const matchMark=Decoration.mark({class:"cm-searchMatch"}),selectedMatchMark=Decoration.mark({class:"cm-searchMatch cm-searchMatch-selected"}),searchHighlighter=ViewPlugin.fromClass(class{constructor(view){this.view=view,this.decorations=this.highlight(view.state.field(searchState))}update(update){let state=update.state.field(searchState);(state!=update.startState.field(searchState)||update.docChanged||update.selectionSet||update.viewportChanged)&&(this.decorations=this.highlight(state))}highlight(_ref36){let{query:query,panel:panel}=_ref36;if(!panel||!query.spec.valid)return Decoration.none;let{view:view}=this,builder=new RangeSetBuilder;for(let i=0,ranges=view.visibleRanges,l=ranges.length;i<l;i++){let{from:from,to:to}=ranges[i];for(;i<l-1&&to>ranges[i+1].from-500;)to=ranges[++i].to;query.highlight(view.state,from,to,((from,to)=>{let selected=view.state.selection.ranges.some((r=>r.from==from&&r.to==to));builder.add(from,to,selected?selectedMatchMark:matchMark)}))}return builder.finish()}},{decorations:v=>v.decorations});function searchCommand(f){return view=>{let state=view.state.field(searchState,!1);return state&&state.query.spec.valid?f(view,state):openSearchPanel(view)}}const findNext=searchCommand(((view,_ref37)=>{let{query:query}=_ref37,{to:to}=view.state.selection.main,next=query.nextMatch(view.state,to,to);if(!next)return!1;let selection=EditorSelection.single(next.from,next.to),config=view.state.facet(searchConfigFacet);return view.dispatch({selection:selection,effects:[announceMatch(view,next),config.scrollToMatch(selection.main,view)],userEvent:"select.search"}),selectSearchInput(view),!0})),findPrevious=searchCommand(((view,_ref38)=>{let{query:query}=_ref38,{state:state}=view,{from:from}=state.selection.main,prev=query.prevMatch(state,from,from);if(!prev)return!1;let selection=EditorSelection.single(prev.from,prev.to),config=view.state.facet(searchConfigFacet);return view.dispatch({selection:selection,effects:[announceMatch(view,prev),config.scrollToMatch(selection.main,view)],userEvent:"select.search"}),selectSearchInput(view),!0})),selectMatches=searchCommand(((view,_ref39)=>{let{query:query}=_ref39,ranges=query.matchAll(view.state,1e3);return!(!ranges||!ranges.length)&&(view.dispatch({selection:EditorSelection.create(ranges.map((r=>EditorSelection.range(r.from,r.to)))),userEvent:"select.search.matches"}),!0)})),replaceNext=searchCommand(((view,_ref41)=>{let{query:query}=_ref41,{state:state}=view,{from:from,to:to}=state.selection.main;if(state.readOnly)return!1;let next=query.nextMatch(state,from,from);if(!next)return!1;let selection,replacement,changes=[],effects=[];if(next.from==from&&next.to==to&&(replacement=state.toText(query.getReplacement(next)),changes.push({from:next.from,to:next.to,insert:replacement}),next=query.nextMatch(state,next.from,next.to),effects.push(EditorView.announce.of(state.phrase("replaced match on line $",state.doc.lineAt(from).number)+"."))),next){let off=0==changes.length||changes[0].from>=next.to?0:next.to-next.from-replacement.length;selection=EditorSelection.single(next.from-off,next.to-off),effects.push(announceMatch(view,next)),effects.push(state.facet(searchConfigFacet).scrollToMatch(selection.main,view))}return view.dispatch({changes:changes,selection:selection,effects:effects,userEvent:"input.replace"}),!0})),replaceAll=searchCommand(((view,_ref42)=>{let{query:query}=_ref42;if(view.state.readOnly)return!1;let changes=query.matchAll(view.state,1e9).map((match=>{let{from:from,to:to}=match;return{from:from,to:to,insert:query.getReplacement(match)}}));if(!changes.length)return!1;let announceText=view.state.phrase("replaced $ matches",changes.length)+".";return view.dispatch({changes:changes,effects:EditorView.announce.of(announceText),userEvent:"input.replace.all"}),!0}));function createSearchPanel(view){return view.state.facet(searchConfigFacet).createPanel(view)}function defaultQuery(state,fallback){var _a,_b,_c,_d,_e;let sel=state.selection.main,selText=sel.empty||sel.to>sel.from+100?"":state.sliceDoc(sel.from,sel.to);if(fallback&&!selText)return fallback;let config=state.facet(searchConfigFacet);return new SearchQuery({search:(null!==(_a=null==fallback?void 0:fallback.literal)&&void 0!==_a?_a:config.literal)?selText:selText.replace(/\n/g,"\\n"),caseSensitive:null!==(_b=null==fallback?void 0:fallback.caseSensitive)&&void 0!==_b?_b:config.caseSensitive,literal:null!==(_c=null==fallback?void 0:fallback.literal)&&void 0!==_c?_c:config.literal,regexp:null!==(_d=null==fallback?void 0:fallback.regexp)&&void 0!==_d?_d:config.regexp,wholeWord:null!==(_e=null==fallback?void 0:fallback.wholeWord)&&void 0!==_e?_e:config.wholeWord})}function getSearchInput(view){let panel=getPanel(view,createSearchPanel);return panel&&panel.dom.querySelector("[main-field]")}function selectSearchInput(view){let input=getSearchInput(view);input&&input==view.root.activeElement&&input.select()}const openSearchPanel=view=>{let state=view.state.field(searchState,!1);if(state&&state.panel){let searchInput=getSearchInput(view);if(searchInput&&searchInput!=view.root.activeElement){let query=defaultQuery(view.state,state.query.spec);query.valid&&view.dispatch({effects:setSearchQuery.of(query)}),searchInput.focus(),searchInput.select()}}else view.dispatch({effects:[togglePanel$1.of(!0),state?setSearchQuery.of(defaultQuery(view.state,state.query.spec)):StateEffect.appendConfig.of(searchExtensions)]});return!0},closeSearchPanel=view=>{let state=view.state.field(searchState,!1);if(!state||!state.panel)return!1;let panel=getPanel(view,createSearchPanel);return panel&&panel.dom.contains(view.root.activeElement)&&view.focus(),view.dispatch({effects:togglePanel$1.of(!1)}),!0},searchKeymap=[{key:"Mod-f",run:openSearchPanel,scope:"editor search-panel"},{key:"F3",run:findNext,shift:findPrevious,scope:"editor search-panel",preventDefault:!0},{key:"Mod-g",run:findNext,shift:findPrevious,scope:"editor search-panel",preventDefault:!0},{key:"Escape",run:closeSearchPanel,scope:"editor search-panel"},{key:"Mod-Shift-l",run:_ref40=>{let{state:state,dispatch:dispatch}=_ref40,sel=state.selection;if(sel.ranges.length>1||sel.main.empty)return!1;let{from:from,to:to}=sel.main,ranges=[],main=0;for(let cur=new SearchCursor(state.doc,state.sliceDoc(from,to));!cur.next().done;){if(ranges.length>1e3)return!1;cur.value.from==from&&(main=ranges.length),ranges.push(EditorSelection.range(cur.value.from,cur.value.to))}return dispatch(state.update({selection:EditorSelection.create(ranges,main),userEvent:"select.search.matches"})),!0}},{key:"Alt-g",run:view=>{let panel=getPanel(view,createLineDialog);if(!panel){let effects=[dialogEffect.of(!0)];null==view.state.field(dialogField,!1)&&effects.push(StateEffect.appendConfig.of([dialogField,baseTheme$1$1])),view.dispatch({effects:effects}),panel=getPanel(view,createLineDialog)}return panel&&panel.dom.querySelector("input").focus(),!0}},{key:"Mod-d",run:_ref35=>{let{state:state,dispatch:dispatch}=_ref35,{ranges:ranges}=state.selection;if(ranges.some((sel=>sel.from===sel.to)))return(_ref34=>{let{state:state,dispatch:dispatch}=_ref34,{selection:selection}=state,newSel=EditorSelection.create(selection.ranges.map((range=>state.wordAt(range.head)||EditorSelection.cursor(range.head))),selection.mainIndex);return!newSel.eq(selection)&&(dispatch(state.update({selection:newSel})),!0)})({state:state,dispatch:dispatch});let searchedText=state.sliceDoc(ranges[0].from,ranges[0].to);if(state.selection.ranges.some((r=>state.sliceDoc(r.from,r.to)!=searchedText)))return!1;let range=function(state,query){let{main:main,ranges:ranges}=state.selection,word=state.wordAt(main.head),fullWord=word&&word.from==main.from&&word.to==main.to;for(let cycled=!1,cursor=new SearchCursor(state.doc,query,ranges[ranges.length-1].to);;){if(cursor.next(),!cursor.done){if(cycled&&ranges.some((r=>r.from==cursor.value.from)))continue;if(fullWord){let word=state.wordAt(cursor.value.from);if(!word||word.from!=cursor.value.from||word.to!=cursor.value.to)continue}return cursor.value}if(cycled)return null;cursor=new SearchCursor(state.doc,query,0,Math.max(0,ranges[ranges.length-1].from-1)),cycled=!0}}(state,searchedText);return!!range&&(dispatch(state.update({selection:state.selection.addRange(EditorSelection.range(range.from,range.to),!1),effects:EditorView.scrollIntoView(range.to)})),!0)},preventDefault:!0}];class SearchPanel{constructor(view){this.view=view;let query=this.query=view.state.field(searchState).query.spec;function button(name,onclick,content){return crelt("button",{class:"cm-button",name:name,onclick:onclick,type:"button"},content)}this.commit=this.commit.bind(this),this.searchField=crelt("input",{value:query.search,placeholder:phrase(view,"Find"),"aria-label":phrase(view,"Find"),class:"cm-textfield",name:"search",form:"","main-field":"true",onchange:this.commit,onkeyup:this.commit}),this.replaceField=crelt("input",{value:query.replace,placeholder:phrase(view,"Replace"),"aria-label":phrase(view,"Replace"),class:"cm-textfield",name:"replace",form:"",onchange:this.commit,onkeyup:this.commit}),this.caseField=crelt("input",{type:"checkbox",name:"case",form:"",checked:query.caseSensitive,onchange:this.commit}),this.reField=crelt("input",{type:"checkbox",name:"re",form:"",checked:query.regexp,onchange:this.commit}),this.wordField=crelt("input",{type:"checkbox",name:"word",form:"",checked:query.wholeWord,onchange:this.commit}),this.dom=crelt("div",{onkeydown:e=>this.keydown(e),class:"cm-search"},[this.searchField,button("next",(()=>findNext(view)),[phrase(view,"next")]),button("prev",(()=>findPrevious(view)),[phrase(view,"previous")]),button("select",(()=>selectMatches(view)),[phrase(view,"all")]),crelt("label",null,[this.caseField,phrase(view,"match case")]),crelt("label",null,[this.reField,phrase(view,"regexp")]),crelt("label",null,[this.wordField,phrase(view,"by word")]),...view.state.readOnly?[]:[crelt("br"),this.replaceField,button("replace",(()=>replaceNext(view)),[phrase(view,"replace")]),button("replaceAll",(()=>replaceAll(view)),[phrase(view,"replace all")])],crelt("button",{name:"close",onclick:()=>closeSearchPanel(view),"aria-label":phrase(view,"close"),type:"button"},["×"])])}commit(){let query=new SearchQuery({search:this.searchField.value,caseSensitive:this.caseField.checked,regexp:this.reField.checked,wholeWord:this.wordField.checked,replace:this.replaceField.value});query.eq(this.query)||(this.query=query,this.view.dispatch({effects:setSearchQuery.of(query)}))}keydown(e){var view,event,scope;view=this.view,event=e,scope="search-panel",runHandlers(getKeymap(view.state),event,view,scope)?e.preventDefault():13==e.keyCode&&e.target==this.searchField?(e.preventDefault(),(e.shiftKey?findPrevious:findNext)(this.view)):13==e.keyCode&&e.target==this.replaceField&&(e.preventDefault(),replaceNext(this.view))}update(update){for(let tr of update.transactions)for(let effect of tr.effects)effect.is(setSearchQuery)&&!effect.value.eq(this.query)&&this.setQuery(effect.value)}setQuery(query){this.query=query,this.searchField.value=query.search,this.replaceField.value=query.replace,this.caseField.checked=query.caseSensitive,this.reField.checked=query.regexp,this.wordField.checked=query.wholeWord}mount(){this.searchField.select()}get pos(){return 80}get top(){return this.view.state.facet(searchConfigFacet).top}}function phrase(view,phrase){return view.state.phrase(phrase)}const Break=/[\s\.,:;?!]/;function announceMatch(view,_ref43){let{from:from,to:to}=_ref43,line=view.state.doc.lineAt(from),lineEnd=view.state.doc.lineAt(to).to,start=Math.max(line.from,from-30),end=Math.min(lineEnd,to+30),text=view.state.sliceDoc(start,end);if(start!=line.from)for(let i=0;i<30;i++)if(!Break.test(text[i+1])&&Break.test(text[i])){text=text.slice(i);break}if(end!=lineEnd)for(let i=text.length-1;i>text.length-30;i--)if(!Break.test(text[i-1])&&Break.test(text[i])){text=text.slice(0,i);break}return EditorView.announce.of("".concat(view.state.phrase("current match"),". ").concat(text," ").concat(view.state.phrase("on line")," ").concat(line.number,"."))}const baseTheme$2=EditorView.baseTheme({".cm-panel.cm-search":{padding:"2px 6px 4px",position:"relative","& [name=close]":{position:"absolute",top:"0",right:"4px",backgroundColor:"inherit",border:"none",font:"inherit",padding:0,margin:0},"& input, & button, & label":{margin:".2em .6em .2em 0"},"& input[type=checkbox]":{marginRight:".2em"},"& label":{fontSize:"80%",whiteSpace:"pre"}},"&light .cm-searchMatch":{backgroundColor:"#ffff0054"},"&dark .cm-searchMatch":{backgroundColor:"#00ffff8a"},"&light .cm-searchMatch-selected":{backgroundColor:"#ff6a0054"},"&dark .cm-searchMatch-selected":{backgroundColor:"#ff00ff8a"}}),searchExtensions=[searchState,Prec.lowest(searchHighlighter),baseTheme$2];class CompletionContext{constructor(state,pos,explicit){this.state=state,this.pos=pos,this.explicit=explicit,this.abortListeners=[]}tokenBefore(types){let token=syntaxTree(this.state).resolveInner(this.pos,-1);for(;token&&types.indexOf(token.name)<0;)token=token.parent;return token?{from:token.from,to:this.pos,text:this.state.sliceDoc(token.from,this.pos),type:token.type}:null}matchBefore(expr){let line=this.state.doc.lineAt(this.pos),start=Math.max(line.from,this.pos-250),str=line.text.slice(start-line.from,this.pos-line.from),found=str.search(ensureAnchor(expr,!1));return found<0?null:{from:start+found,to:this.pos,text:str.slice(found)}}get aborted(){return null==this.abortListeners}addEventListener(type,listener){"abort"==type&&this.abortListeners&&this.abortListeners.push(listener)}}function toSet(chars){let flat=Object.keys(chars).join(""),words=/\w/.test(flat);return words&&(flat=flat.replace(/\w/g,"")),"[".concat(words?"\\w":"").concat(flat.replace(/[^\w\s]/g,"\\$&"),"]")}function completeFromList(list){let options=list.map((o=>"string"==typeof o?{label:o}:o)),[validFor,match]=options.every((o=>/^\w+$/.test(o.label)))?[/\w*$/,/\w+$/]:function(options){let first=Object.create(null),rest=Object.create(null);for(let{label:label}of options){first[label[0]]=!0;for(let i=1;i<label.length;i++)rest[label[i]]=!0}let source=toSet(first)+toSet(rest)+"*$";return[new RegExp("^"+source),new RegExp(source)]}(options);return context=>{let token=context.matchBefore(match);return token||context.explicit?{from:token?token.from:context.pos,options:options,validFor:validFor}:null}}function ifNotIn(nodes,source){return context=>{for(let pos=syntaxTree(context.state).resolveInner(context.pos,-1);pos;pos=pos.parent){if(nodes.indexOf(pos.name)>-1)return null;if(pos.type.isTop)break}return source(context)}}class Option{constructor(completion,source,match,score){this.completion=completion,this.source=source,this.match=match,this.score=score}}function cur(state){return state.selection.main.from}function ensureAnchor(expr,start){var _a;let{source:source}=expr,addStart=start&&"^"!=source[0],addEnd="$"!=source[source.length-1];return addStart||addEnd?new RegExp("".concat(addStart?"^":"","(?:").concat(source,")").concat(addEnd?"$":""),null!==(_a=expr.flags)&&void 0!==_a?_a:expr.ignoreCase?"i":""):expr}const pickedCompletion=Annotation.define();const SourceCache=new WeakMap;function asSource(source){if(!Array.isArray(source))return source;let known=SourceCache.get(source);return known||SourceCache.set(source,known=completeFromList(source)),known}const startCompletionEffect=StateEffect.define(),closeCompletionEffect=StateEffect.define();class FuzzyMatcher{constructor(pattern){this.pattern=pattern,this.chars=[],this.folded=[],this.any=[],this.precise=[],this.byWord=[];for(let p=0;p<pattern.length;){let char=codePointAt(pattern,p),size=codePointSize(char);this.chars.push(char);let part=pattern.slice(p,p+size),upper=part.toUpperCase();this.folded.push(codePointAt(upper==part?part.toLowerCase():upper,0)),p+=size}this.astral=pattern.length!=this.chars.length}match(word){if(0==this.pattern.length)return[-100];if(word.length<this.pattern.length)return null;let{chars:chars,folded:folded,any:any,precise:precise,byWord:byWord}=this;if(1==chars.length){let first=codePointAt(word,0),firstSize=codePointSize(first),score=firstSize==word.length?0:-100;if(first==chars[0]);else{if(first!=folded[0])return null;score+=-200}return[score,0,firstSize]}let direct=word.indexOf(this.pattern);if(0==direct)return[word.length==this.pattern.length?0:-100,0,this.pattern.length];let len=chars.length,anyTo=0;if(direct<0){for(let i=0,e=Math.min(word.length,200);i<e&&anyTo<len;){let next=codePointAt(word,i);next!=chars[anyTo]&&next!=folded[anyTo]||(any[anyTo++]=i),i+=codePointSize(next)}if(anyTo<len)return null}let preciseTo=0,byWordTo=0,byWordFolded=!1,adjacentTo=0,adjacentStart=-1,adjacentEnd=-1,hasLower=/[a-z]/.test(word),wordAdjacent=!0;for(let i=0,e=Math.min(word.length,200),prevType=0;i<e&&byWordTo<len;){let next=codePointAt(word,i);direct<0&&(preciseTo<len&&next==chars[preciseTo]&&(precise[preciseTo++]=i),adjacentTo<len&&(next==chars[adjacentTo]||next==folded[adjacentTo]?(0==adjacentTo&&(adjacentStart=i),adjacentEnd=i+1,adjacentTo++):adjacentTo=0));let ch,type=next<255?next>=48&&next<=57||next>=97&&next<=122?2:next>=65&&next<=90?1:0:(ch=fromCodePoint(next))!=ch.toLowerCase()?1:ch!=ch.toUpperCase()?2:0;(!i||1==type&&hasLower||0==prevType&&0!=type)&&(chars[byWordTo]==next||folded[byWordTo]==next&&(byWordFolded=!0)?byWord[byWordTo++]=i:byWord.length&&(wordAdjacent=!1)),prevType=type,i+=codePointSize(next)}return byWordTo==len&&0==byWord[0]&&wordAdjacent?this.result((byWordFolded?-200:0)-100,byWord,word):adjacentTo==len&&0==adjacentStart?[-200-word.length+(adjacentEnd==word.length?0:-100),0,adjacentEnd]:direct>-1?[-700-word.length,direct,direct+this.pattern.length]:adjacentTo==len?[-900-word.length,adjacentStart,adjacentEnd]:byWordTo==len?this.result((byWordFolded?-200:0)-100-700+(wordAdjacent?0:-1100),byWord,word):2==chars.length?null:this.result((any[0]?-700:0)-200-1100,any,word)}result(score,positions,word){let result=[score-word.length],i=1;for(let pos of positions){let to=pos+(this.astral?codePointSize(codePointAt(word,pos)):1);i>1&&result[i-1]==pos?result[i-1]=to:(result[i++]=pos,result[i++]=to)}return result}}const completionConfig=Facet.define({combine:configs=>combineConfig(configs,{activateOnTyping:!0,selectOnOpen:!0,override:null,closeOnBlur:!0,maxRenderedOptions:100,defaultKeymap:!0,tooltipClass:()=>"",optionClass:()=>"",aboveCursor:!1,icons:!0,addToOptions:[],positionInfo:defaultPositionInfo,compareCompletions:(a,b)=>a.label.localeCompare(b.label),interactionDelay:75},{defaultKeymap:(a,b)=>a&&b,closeOnBlur:(a,b)=>a&&b,icons:(a,b)=>a&&b,tooltipClass:(a,b)=>c=>joinClass(a(c),b(c)),optionClass:(a,b)=>c=>joinClass(a(c),b(c)),addToOptions:(a,b)=>a.concat(b)})});function joinClass(a,b){return a?b?a+" "+b:a:b}function defaultPositionInfo(view,list,option,info,space){let offset,maxWidth,rtl=view.textDirection==Direction.RTL,left=rtl,narrow=!1,side="top",spaceLeft=list.left-space.left,spaceRight=space.right-list.right,infoWidth=info.right-info.left,infoHeight=info.bottom-info.top;if(left&&spaceLeft<Math.min(infoWidth,spaceRight)?left=!1:!left&&spaceRight<Math.min(infoWidth,spaceLeft)&&(left=!0),infoWidth<=(left?spaceLeft:spaceRight))offset=Math.max(space.top,Math.min(option.top,space.bottom-infoHeight))-list.top,maxWidth=Math.min(400,left?spaceLeft:spaceRight);else{narrow=!0,maxWidth=Math.min(400,(rtl?list.right:space.right-list.left)-30);let spaceBelow=space.bottom-list.bottom;spaceBelow>=infoHeight||spaceBelow>list.top?offset=option.bottom-list.top:(side="bottom",offset=list.bottom-option.top)}return{style:"".concat(side,": ").concat(offset,"px; max-width: ").concat(maxWidth,"px"),class:"cm-completionInfo-"+(narrow?rtl?"left-narrow":"right-narrow":left?"left":"right")}}function rangeAroundSelected(total,selected,max){if(total<=max)return{from:0,to:total};if(selected<0&&(selected=0),selected<=total>>1){let off=Math.floor(selected/max);return{from:off*max,to:(off+1)*max}}let off=Math.floor((total-selected)/max);return{from:total-(off+1)*max,to:total-off*max}}class CompletionTooltip{constructor(view,stateField,applyCompletion){this.view=view,this.stateField=stateField,this.applyCompletion=applyCompletion,this.info=null,this.infoDestroy=null,this.placeInfoReq={read:()=>this.measureInfo(),write:pos=>this.placeInfo(pos),key:this},this.space=null,this.currentClass="";let cState=view.state.field(stateField),{options:options,selected:selected}=cState.open,config=view.state.facet(completionConfig);this.optionContent=function(config){let content=config.addToOptions.slice();return config.icons&&content.push({render(completion){let icon=document.createElement("div");return icon.classList.add("cm-completionIcon"),completion.type&&icon.classList.add(...completion.type.split(/\s+/g).map((cls=>"cm-completionIcon-"+cls))),icon.setAttribute("aria-hidden","true"),icon},position:20}),content.push({render(completion,_s,match){let labelElt=document.createElement("span");labelElt.className="cm-completionLabel";let{label:label}=completion,off=0;for(let j=1;j<match.length;){let from=match[j++],to=match[j++];from>off&&labelElt.appendChild(document.createTextNode(label.slice(off,from)));let span=labelElt.appendChild(document.createElement("span"));span.appendChild(document.createTextNode(label.slice(from,to))),span.className="cm-completionMatchedText",off=to}return off<label.length&&labelElt.appendChild(document.createTextNode(label.slice(off))),labelElt},position:50},{render(completion){if(!completion.detail)return null;let detailElt=document.createElement("span");return detailElt.className="cm-completionDetail",detailElt.textContent=completion.detail,detailElt},position:80}),content.sort(((a,b)=>a.position-b.position)).map((a=>a.render))}(config),this.optionClass=config.optionClass,this.tooltipClass=config.tooltipClass,this.range=rangeAroundSelected(options.length,selected,config.maxRenderedOptions),this.dom=document.createElement("div"),this.dom.className="cm-tooltip-autocomplete",this.updateTooltipClass(view.state),this.dom.addEventListener("mousedown",(e=>{for(let match,dom=e.target;dom&&dom!=this.dom;dom=dom.parentNode)if("LI"==dom.nodeName&&(match=/-(\d+)$/.exec(dom.id))&&+match[1]<options.length)return this.applyCompletion(view,options[+match[1]]),void e.preventDefault()})),this.dom.addEventListener("focusout",(e=>{let state=view.state.field(this.stateField,!1);state&&state.tooltip&&view.state.facet(completionConfig).closeOnBlur&&e.relatedTarget!=view.contentDOM&&view.dispatch({effects:closeCompletionEffect.of(null)})})),this.list=this.dom.appendChild(this.createListBox(options,cState.id,this.range)),this.list.addEventListener("scroll",(()=>{this.info&&this.view.requestMeasure(this.placeInfoReq)}))}mount(){this.updateSel()}update(update){var _a,_b,_c;let cState=update.state.field(this.stateField),prevState=update.startState.field(this.stateField);this.updateTooltipClass(update.state),cState!=prevState&&(this.updateSel(),(null===(_a=cState.open)||void 0===_a?void 0:_a.disabled)!=(null===(_b=prevState.open)||void 0===_b?void 0:_b.disabled)&&this.dom.classList.toggle("cm-tooltip-autocomplete-disabled",!!(null===(_c=cState.open)||void 0===_c?void 0:_c.disabled)))}updateTooltipClass(state){let cls=this.tooltipClass(state);if(cls!=this.currentClass){for(let c of this.currentClass.split(" "))c&&this.dom.classList.remove(c);for(let c of cls.split(" "))c&&this.dom.classList.add(c);this.currentClass=cls}}positioned(space){this.space=space,this.info&&this.view.requestMeasure(this.placeInfoReq)}updateSel(){let cState=this.view.state.field(this.stateField),open=cState.open;if((open.selected>-1&&open.selected<this.range.from||open.selected>=this.range.to)&&(this.range=rangeAroundSelected(open.options.length,open.selected,this.view.state.facet(completionConfig).maxRenderedOptions),this.list.remove(),this.list=this.dom.appendChild(this.createListBox(open.options,cState.id,this.range)),this.list.addEventListener("scroll",(()=>{this.info&&this.view.requestMeasure(this.placeInfoReq)}))),this.updateSelectedOption(open.selected)){this.destroyInfo();let{completion:completion}=open.options[open.selected],{info:info}=completion;if(!info)return;let infoResult="string"==typeof info?document.createTextNode(info):info(completion);if(!infoResult)return;"then"in infoResult?infoResult.then((obj=>{obj&&this.view.state.field(this.stateField,!1)==cState&&this.addInfoPane(obj,completion)})).catch((e=>logException(this.view.state,e,"completion info"))):this.addInfoPane(infoResult,completion)}}addInfoPane(content,completion){this.destroyInfo();let wrap=this.info=document.createElement("div");if(wrap.className="cm-tooltip cm-completionInfo",null!=content.nodeType)wrap.appendChild(content),this.infoDestroy=null;else{let{dom:dom,destroy:destroy}=content;wrap.appendChild(dom),this.infoDestroy=destroy||null}this.dom.appendChild(wrap),this.view.requestMeasure(this.placeInfoReq)}updateSelectedOption(selected){let set=null;for(let opt=this.list.firstChild,i=this.range.from;opt;opt=opt.nextSibling,i++)"LI"==opt.nodeName&&opt.id?i==selected?opt.hasAttribute("aria-selected")||(opt.setAttribute("aria-selected","true"),set=opt):opt.hasAttribute("aria-selected")&&opt.removeAttribute("aria-selected"):i--;return set&&function(container,element){let parent=container.getBoundingClientRect(),self=element.getBoundingClientRect();self.top<parent.top?container.scrollTop-=parent.top-self.top:self.bottom>parent.bottom&&(container.scrollTop+=self.bottom-parent.bottom)}(this.list,set),set}measureInfo(){let sel=this.dom.querySelector("[aria-selected]");if(!sel||!this.info)return null;let listRect=this.dom.getBoundingClientRect(),infoRect=this.info.getBoundingClientRect(),selRect=sel.getBoundingClientRect(),space=this.space;if(!space){let win=this.dom.ownerDocument.defaultView||window;space={left:0,top:0,right:win.innerWidth,bottom:win.innerHeight}}return selRect.top>Math.min(space.bottom,listRect.bottom)-10||selRect.bottom<Math.max(space.top,listRect.top)+10?null:this.view.state.facet(completionConfig).positionInfo(this.view,listRect,selRect,infoRect,space)}placeInfo(pos){this.info&&(pos?(pos.style&&(this.info.style.cssText=pos.style),this.info.className="cm-tooltip cm-completionInfo "+(pos.class||"")):this.info.style.cssText="top: -1e6px")}createListBox(options,id,range){const ul=document.createElement("ul");ul.id=id,ul.setAttribute("role","listbox"),ul.setAttribute("aria-expanded","true"),ul.setAttribute("aria-label",this.view.state.phrase("Completions"));let curSection=null;for(let i=range.from;i<range.to;i++){let{completion:completion,match:match}=options[i],{section:section}=completion;if(section){let name="string"==typeof section?section:section.name;if(name!=curSection&&(i>range.from||0==range.from))if(curSection=name,"string"!=typeof section&&section.header)ul.appendChild(section.header(section));else{ul.appendChild(document.createElement("completion-section")).textContent=name}}const li=ul.appendChild(document.createElement("li"));li.id=id+"-"+i,li.setAttribute("role","option");let cls=this.optionClass(completion);cls&&(li.className=cls);for(let source of this.optionContent){let node=source(completion,this.view.state,match);node&&li.appendChild(node)}}return range.from&&ul.classList.add("cm-completionListIncompleteTop"),range.to<options.length&&ul.classList.add("cm-completionListIncompleteBottom"),ul}destroyInfo(){this.info&&(this.infoDestroy&&this.infoDestroy(),this.info.remove(),this.info=null)}destroy(){this.destroyInfo()}}function completionTooltip(stateField,applyCompletion){return view=>new CompletionTooltip(view,stateField,applyCompletion)}function score(option){return 100*(option.boost||0)+(option.apply?10:0)+(option.info?5:0)+(option.type?1:0)}class CompletionDialog{constructor(options,attrs,tooltip,timestamp,selected,disabled){this.options=options,this.attrs=attrs,this.tooltip=tooltip,this.timestamp=timestamp,this.selected=selected,this.disabled=disabled}setSelected(selected,id){return selected==this.selected||selected>=this.options.length?this:new CompletionDialog(this.options,makeAttrs(id,selected),this.tooltip,this.timestamp,selected,this.disabled)}static build(active,state,id,prev,conf){let options=function(active,state){let options=[],sections=null,addOption=option=>{options.push(option);let{section:section}=option.completion;if(section){sections||(sections=[]);let name="string"==typeof section?section:section.name;sections.some((s=>s.name==name))||sections.push("string"==typeof section?{name:name}:section)}};for(let a of active)if(a.hasResult())if(!1===a.result.filter){let getMatch=a.result.getMatch;for(let option of a.result.options){let match=[1e9-options.length];if(getMatch)for(let n of getMatch(option))match.push(n);addOption(new Option(option,a.source,match,match[0]))}}else{let match,matcher=new FuzzyMatcher(state.sliceDoc(a.from,a.to));for(let option of a.result.options)(match=matcher.match(option.label))&&addOption(new Option(option,a.source,match,match[0]+(option.boost||0)))}if(sections){let sectionOrder=Object.create(null),pos=0,cmp=(a,b)=>{var _a,_b;return(null!==(_a=a.rank)&&void 0!==_a?_a:1e9)-(null!==(_b=b.rank)&&void 0!==_b?_b:1e9)||(a.name<b.name?-1:1)};for(let s of sections.sort(cmp))pos-=1e5,sectionOrder[s.name]=pos;for(let option of options){let{section:section}=option.completion;section&&(option.score+=sectionOrder["string"==typeof section?section:section.name])}}let result=[],prev=null,compare=state.facet(completionConfig).compareCompletions;for(let opt of options.sort(((a,b)=>b.score-a.score||compare(a.completion,b.completion)))){let cur=opt.completion;!prev||prev.label!=cur.label||prev.detail!=cur.detail||null!=prev.type&&null!=cur.type&&prev.type!=cur.type||prev.apply!=cur.apply||prev.boost!=cur.boost?result.push(opt):score(opt.completion)>score(prev)&&(result[result.length-1]=opt),prev=opt.completion}return result}(active,state);if(!options.length)return prev&&active.some((a=>1==a.state))?new CompletionDialog(prev.options,prev.attrs,prev.tooltip,prev.timestamp,prev.selected,!0):null;let selected=state.facet(completionConfig).selectOnOpen?0:-1;if(prev&&prev.selected!=selected&&-1!=prev.selected){let selectedValue=prev.options[prev.selected].completion;for(let i=0;i<options.length;i++)if(options[i].completion==selectedValue){selected=i;break}}return new CompletionDialog(options,makeAttrs(id,selected),{pos:active.reduce(((a,b)=>b.hasResult()?Math.min(a,b.from):a),1e8),create:completionTooltip(completionState,applyCompletion),above:conf.aboveCursor},prev?prev.timestamp:Date.now(),selected,!1)}map(changes){return new CompletionDialog(this.options,this.attrs,Object.assign(Object.assign({},this.tooltip),{pos:changes.mapPos(this.tooltip.pos)}),this.timestamp,this.selected,this.disabled)}}class CompletionState{constructor(active,id,open){this.active=active,this.id=id,this.open=open}static start(){return new CompletionState(none,"cm-ac-"+Math.floor(2e6*Math.random()).toString(36),null)}update(tr){let{state:state}=tr,conf=state.facet(completionConfig),active=(conf.override||state.languageDataAt("autocomplete",cur(state)).map(asSource)).map((source=>(this.active.find((s=>s.source==source))||new ActiveSource(source,this.active.some((a=>0!=a.state))?1:0)).update(tr,conf)));active.length==this.active.length&&active.every(((a,i)=>a==this.active[i]))&&(active=this.active);let open=this.open;open&&tr.docChanged&&(open=open.map(tr.changes)),tr.selection||active.some((a=>a.hasResult()&&tr.changes.touchesRange(a.from,a.to)))||!function(a,b){if(a==b)return!0;for(let iA=0,iB=0;;){for(;iA<a.length&&!a[iA].hasResult;)iA++;for(;iB<b.length&&!b[iB].hasResult;)iB++;let endA=iA==a.length,endB=iB==b.length;if(endA||endB)return endA==endB;if(a[iA++].result!=b[iB++].result)return!1}}(active,this.active)?open=CompletionDialog.build(active,state,this.id,open,conf):open&&open.disabled&&!active.some((a=>1==a.state))&&(open=null),!open&&active.every((a=>1!=a.state))&&active.some((a=>a.hasResult()))&&(active=active.map((a=>a.hasResult()?new ActiveSource(a.source,0):a)));for(let effect of tr.effects)effect.is(setSelectedEffect)&&(open=open&&open.setSelected(effect.value,this.id));return active==this.active&&open==this.open?this:new CompletionState(active,this.id,open)}get tooltip(){return this.open?this.open.tooltip:null}get attrs(){return this.open?this.open.attrs:baseAttrs}}const baseAttrs={"aria-autocomplete":"list"};function makeAttrs(id,selected){let result={"aria-autocomplete":"list","aria-haspopup":"listbox","aria-controls":id};return selected>-1&&(result["aria-activedescendant"]=id+"-"+selected),result}const none=[];function getUserEvent(tr){return tr.isUserEvent("input.type")?"input":tr.isUserEvent("delete.backward")?"delete":null}class ActiveSource{constructor(source,state){let explicitPos=arguments.length>2&&void 0!==arguments[2]?arguments[2]:-1;this.source=source,this.state=state,this.explicitPos=explicitPos}hasResult(){return!1}update(tr,conf){let event=getUserEvent(tr),value=this;event?value=value.handleUserEvent(tr,event,conf):tr.docChanged?value=value.handleChange(tr):tr.selection&&0!=value.state&&(value=new ActiveSource(value.source,0));for(let effect of tr.effects)if(effect.is(startCompletionEffect))value=new ActiveSource(value.source,1,effect.value?cur(tr.state):-1);else if(effect.is(closeCompletionEffect))value=new ActiveSource(value.source,0);else if(effect.is(setActiveEffect))for(let active of effect.value)active.source==value.source&&(value=active);return value}handleUserEvent(tr,type,conf){return"delete"!=type&&conf.activateOnTyping?new ActiveSource(this.source,1):this.map(tr.changes)}handleChange(tr){return tr.changes.touchesRange(cur(tr.startState))?new ActiveSource(this.source,0):this.map(tr.changes)}map(changes){return changes.empty||this.explicitPos<0?this:new ActiveSource(this.source,this.state,changes.mapPos(this.explicitPos))}}class ActiveResult extends ActiveSource{constructor(source,explicitPos,result,from,to){super(source,2,explicitPos),this.result=result,this.from=from,this.to=to}hasResult(){return!0}handleUserEvent(tr,type,conf){var _a;let from=tr.changes.mapPos(this.from),to=tr.changes.mapPos(this.to,1),pos=cur(tr.state);if((this.explicitPos<0?pos<=from:pos<this.from)||pos>to||"delete"==type&&cur(tr.startState)==this.from)return new ActiveSource(this.source,"input"==type&&conf.activateOnTyping?1:0);let updated,explicitPos=this.explicitPos<0?-1:tr.changes.mapPos(this.explicitPos);return function(validFor,state,from,to){if(!validFor)return!1;let text=state.sliceDoc(from,to);return"function"==typeof validFor?validFor(text,from,to,state):ensureAnchor(validFor,!0).test(text)}(this.result.validFor,tr.state,from,to)?new ActiveResult(this.source,explicitPos,this.result,from,to):this.result.update&&(updated=this.result.update(this.result,from,to,new CompletionContext(tr.state,pos,explicitPos>=0)))?new ActiveResult(this.source,explicitPos,updated,updated.from,null!==(_a=updated.to)&&void 0!==_a?_a:cur(tr.state)):new ActiveSource(this.source,1,explicitPos)}handleChange(tr){return tr.changes.touchesRange(this.from,this.to)?new ActiveSource(this.source,0):this.map(tr.changes)}map(mapping){return mapping.empty?this:new ActiveResult(this.source,this.explicitPos<0?-1:mapping.mapPos(this.explicitPos),this.result,mapping.mapPos(this.from),mapping.mapPos(this.to,1))}}const setActiveEffect=StateEffect.define({map:(sources,mapping)=>sources.map((s=>s.map(mapping)))}),setSelectedEffect=StateEffect.define(),completionState=StateField.define({create:()=>CompletionState.start(),update:(value,tr)=>value.update(tr),provide:f=>[showTooltip.from(f,(val=>val.tooltip)),EditorView.contentAttributes.from(f,(state=>state.attrs))]});function applyCompletion(view,option){const apply=option.completion.apply||option.completion.label;let result=view.state.field(completionState).active.find((a=>a.source==option.source));return result instanceof ActiveResult&&("string"==typeof apply?view.dispatch(Object.assign(Object.assign({},function(state,text,from,to){let{main:main}=state.selection,fromOff=from-main.from,toOff=to-main.from;return Object.assign(Object.assign({},state.changeByRange((range=>range!=main&&from!=to&&state.sliceDoc(range.from+fromOff,range.from+toOff)!=state.sliceDoc(from,to)?{range:range}:{changes:{from:range.from+fromOff,to:to==main.from?range.to:range.from+toOff,insert:text},range:EditorSelection.cursor(range.from+fromOff+text.length)}))),{userEvent:"input.complete"})}(view.state,apply,result.from,result.to)),{annotations:pickedCompletion.of(option.completion)})):apply(view,option.completion,result.from,result.to),!0)}function moveCompletionSelection(forward){let by=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"option";return view=>{let cState=view.state.field(completionState,!1);if(!cState||!cState.open||cState.open.disabled||Date.now()-cState.open.timestamp<view.state.facet(completionConfig).interactionDelay)return!1;let tooltip,step=1;"page"==by&&(tooltip=getTooltip(view,cState.open.tooltip))&&(step=Math.max(2,Math.floor(tooltip.dom.offsetHeight/tooltip.dom.querySelector("li").offsetHeight)-1));let{length:length}=cState.open.options,selected=cState.open.selected>-1?cState.open.selected+step*(forward?1:-1):forward?0:length-1;return selected<0?selected="page"==by?0:length-1:selected>=length&&(selected="page"==by?length-1:0),view.dispatch({effects:setSelectedEffect.of(selected)}),!0}}class RunningQuery{constructor(active,context){this.active=active,this.context=context,this.time=Date.now(),this.updates=[],this.done=void 0}}const completionPlugin=ViewPlugin.fromClass(class{constructor(view){this.view=view,this.debounceUpdate=-1,this.running=[],this.debounceAccept=-1,this.composing=0;for(let active of view.state.field(completionState).active)1==active.state&&this.startQuery(active)}update(update){let cState=update.state.field(completionState);if(!update.selectionSet&&!update.docChanged&&update.startState.field(completionState)==cState)return;let doesReset=update.transactions.some((tr=>(tr.selection||tr.docChanged)&&!getUserEvent(tr)));for(let i=0;i<this.running.length;i++){let query=this.running[i];if(doesReset||query.updates.length+update.transactions.length>50&&Date.now()-query.time>1e3){for(let handler of query.context.abortListeners)try{handler()}catch(e){logException(this.view.state,e)}query.context.abortListeners=null,this.running.splice(i--,1)}else query.updates.push(...update.transactions)}if(this.debounceUpdate>-1&&clearTimeout(this.debounceUpdate),this.debounceUpdate=cState.active.some((a=>1==a.state&&!this.running.some((q=>q.active.source==a.source))))?setTimeout((()=>this.startUpdate()),50):-1,0!=this.composing)for(let tr of update.transactions)"input"==getUserEvent(tr)?this.composing=2:2==this.composing&&tr.selection&&(this.composing=3)}startUpdate(){this.debounceUpdate=-1;let{state:state}=this.view,cState=state.field(completionState);for(let active of cState.active)1!=active.state||this.running.some((r=>r.active.source==active.source))||this.startQuery(active)}startQuery(active){let{state:state}=this.view,pos=cur(state),context=new CompletionContext(state,pos,active.explicitPos==pos),pending=new RunningQuery(active,context);this.running.push(pending),Promise.resolve(active.source(context)).then((result=>{pending.context.aborted||(pending.done=result||null,this.scheduleAccept())}),(err=>{this.view.dispatch({effects:closeCompletionEffect.of(null)}),logException(this.view.state,err)}))}scheduleAccept(){this.running.every((q=>void 0!==q.done))?this.accept():this.debounceAccept<0&&(this.debounceAccept=setTimeout((()=>this.accept()),50))}accept(){var _a;this.debounceAccept>-1&&clearTimeout(this.debounceAccept),this.debounceAccept=-1;let updated=[],conf=this.view.state.facet(completionConfig);for(let i=0;i<this.running.length;i++){let query=this.running[i];if(void 0===query.done)continue;if(this.running.splice(i--,1),query.done){let active=new ActiveResult(query.active.source,query.active.explicitPos,query.done,query.done.from,null!==(_a=query.done.to)&&void 0!==_a?_a:cur(query.updates.length?query.updates[0].startState:this.view.state));for(let tr of query.updates)active=active.update(tr,conf);if(active.hasResult()){updated.push(active);continue}}let current=this.view.state.field(completionState).active.find((a=>a.source==query.active.source));if(current&&1==current.state)if(null==query.done){let active=new ActiveSource(query.active.source,0);for(let tr of query.updates)active=active.update(tr,conf);1!=active.state&&updated.push(active)}else this.startQuery(current)}updated.length&&this.view.dispatch({effects:setActiveEffect.of(updated)})}},{eventHandlers:{blur(event){let state=this.view.state.field(completionState,!1);if(state&&state.tooltip&&this.view.state.facet(completionConfig).closeOnBlur){let dialog=state.open&&getTooltip(this.view,state.open.tooltip);dialog&&dialog.dom.contains(event.relatedTarget)||this.view.dispatch({effects:closeCompletionEffect.of(null)})}},compositionstart(){this.composing=1},compositionend(){3==this.composing&&setTimeout((()=>this.view.dispatch({effects:startCompletionEffect.of(!1)})),20),this.composing=0}}}),baseTheme$1=EditorView.baseTheme({".cm-tooltip.cm-tooltip-autocomplete":{"& > ul":{fontFamily:"monospace",whiteSpace:"nowrap",overflow:"hidden auto",maxWidth_fallback:"700px",maxWidth:"min(700px, 95vw)",minWidth:"250px",maxHeight:"10em",height:"100%",listStyle:"none",margin:0,padding:0,"& > li, & > completion-section":{padding:"1px 3px",lineHeight:1.2},"& > li":{overflowX:"hidden",textOverflow:"ellipsis",cursor:"pointer"},"& > completion-section":{display:"list-item",borderBottom:"1px solid silver",paddingLeft:"0.5em",opacity:.7}}},"&light .cm-tooltip-autocomplete ul li[aria-selected]":{background:"#17c",color:"white"},"&light .cm-tooltip-autocomplete-disabled ul li[aria-selected]":{background:"#777"},"&dark .cm-tooltip-autocomplete ul li[aria-selected]":{background:"#347",color:"white"},"&dark .cm-tooltip-autocomplete-disabled ul li[aria-selected]":{background:"#444"},".cm-completionListIncompleteTop:before, .cm-completionListIncompleteBottom:after":{content:'"···"',opacity:.5,display:"block",textAlign:"center"},".cm-tooltip.cm-completionInfo":{position:"absolute",padding:"3px 9px",width:"max-content",maxWidth:"".concat(400,"px"),boxSizing:"border-box"},".cm-completionInfo.cm-completionInfo-left":{right:"100%"},".cm-completionInfo.cm-completionInfo-right":{left:"100%"},".cm-completionInfo.cm-completionInfo-left-narrow":{right:"".concat(30,"px")},".cm-completionInfo.cm-completionInfo-right-narrow":{left:"".concat(30,"px")},"&light .cm-snippetField":{backgroundColor:"#00000022"},"&dark .cm-snippetField":{backgroundColor:"#ffffff22"},".cm-snippetFieldPosition":{verticalAlign:"text-top",width:0,height:"1.15em",display:"inline-block",margin:"0 -0.7px -.7em",borderLeft:"1.4px dotted #888"},".cm-completionMatchedText":{textDecoration:"underline"},".cm-completionDetail":{marginLeft:"0.5em",fontStyle:"italic"},".cm-completionIcon":{fontSize:"90%",width:".8em",display:"inline-block",textAlign:"center",paddingRight:".6em",opacity:"0.6",boxSizing:"content-box"},".cm-completionIcon-function, .cm-completionIcon-method":{"&:after":{content:"'ƒ'"}},".cm-completionIcon-class":{"&:after":{content:"'○'"}},".cm-completionIcon-interface":{"&:after":{content:"'◌'"}},".cm-completionIcon-variable":{"&:after":{content:"'𝑥'"}},".cm-completionIcon-constant":{"&:after":{content:"'𝐶'"}},".cm-completionIcon-type":{"&:after":{content:"'𝑡'"}},".cm-completionIcon-enum":{"&:after":{content:"'∪'"}},".cm-completionIcon-property":{"&:after":{content:"'□'"}},".cm-completionIcon-keyword":{"&:after":{content:"'🔑︎'"}},".cm-completionIcon-namespace":{"&:after":{content:"'▢'"}},".cm-completionIcon-text":{"&:after":{content:"'abc'",fontSize:"50%",verticalAlign:"middle"}}});class FieldPos{constructor(field,line,from,to){this.field=field,this.line=line,this.from=from,this.to=to}}class FieldRange{constructor(field,from,to){this.field=field,this.from=from,this.to=to}map(changes){let from=changes.mapPos(this.from,-1,MapMode.TrackDel),to=changes.mapPos(this.to,1,MapMode.TrackDel);return null==from||null==to?null:new FieldRange(this.field,from,to)}}class Snippet{constructor(lines,fieldPositions){this.lines=lines,this.fieldPositions=fieldPositions}instantiate(state,pos){let text=[],lineStart=[pos],lineObj=state.doc.lineAt(pos),baseIndent=/^\s*/.exec(lineObj.text)[0];for(let line of this.lines){if(text.length){let indent=baseIndent,tabs=/^\t*/.exec(line)[0].length;for(let i=0;i<tabs;i++)indent+=state.facet(indentUnit);lineStart.push(pos+indent.length-tabs),line=indent+line.slice(tabs)}text.push(line),pos+=line.length+1}let ranges=this.fieldPositions.map((pos=>new FieldRange(pos.field,lineStart[pos.line]+pos.from,lineStart[pos.line]+pos.to)));return{text:text,ranges:ranges}}static parse(template){let m,fields=[],lines=[],positions=[];for(let line of template.split(/\r\n?|\n/)){for(;m=/[#$]\{(?:(\d+)(?::([^}]*))?|([^}]*))\}/.exec(line);){let seq=m[1]?+m[1]:null,name=m[2]||m[3]||"",found=-1;for(let i=0;i<fields.length;i++)(null!=seq?fields[i].seq==seq:name&&fields[i].name==name)&&(found=i);if(found<0){let i=0;for(;i<fields.length&&(null==seq||null!=fields[i].seq&&fields[i].seq<seq);)i++;fields.splice(i,0,{seq:seq,name:name}),found=i;for(let pos of positions)pos.field>=found&&pos.field++}positions.push(new FieldPos(found,lines.length,m.index,m.index+name.length)),line=line.slice(0,m.index)+name+line.slice(m.index+m[0].length)}for(let esc;esc=/\\([{}])/.exec(line);){line=line.slice(0,esc.index)+esc[1]+line.slice(esc.index+esc[0].length);for(let pos of positions)pos.line==lines.length&&pos.from>esc.index&&(pos.from--,pos.to--)}lines.push(line)}return new Snippet(lines,positions)}}let fieldMarker=Decoration.widget({widget:new class extends WidgetType{toDOM(){let span=document.createElement("span");return span.className="cm-snippetFieldPosition",span}ignoreEvent(){return!1}}}),fieldRange=Decoration.mark({class:"cm-snippetField"});class ActiveSnippet{constructor(ranges,active){this.ranges=ranges,this.active=active,this.deco=Decoration.set(ranges.map((r=>(r.from==r.to?fieldMarker:fieldRange).range(r.from,r.to))))}map(changes){let ranges=[];for(let r of this.ranges){let mapped=r.map(changes);if(!mapped)return null;ranges.push(mapped)}return new ActiveSnippet(ranges,this.active)}selectionInsideField(sel){return sel.ranges.every((range=>this.ranges.some((r=>r.field==this.active&&r.from<=range.from&&r.to>=range.to))))}}const setActive=StateEffect.define({map:(value,changes)=>value&&value.map(changes)}),moveToField=StateEffect.define(),snippetState=StateField.define({create:()=>null,update(value,tr){for(let effect of tr.effects){if(effect.is(setActive))return effect.value;if(effect.is(moveToField)&&value)return new ActiveSnippet(value.ranges,effect.value)}return value&&tr.docChanged&&(value=value.map(tr.changes)),value&&tr.selection&&!value.selectionInsideField(tr.selection)&&(value=null),value},provide:f=>EditorView.decorations.from(f,(val=>val?val.deco:Decoration.none))});function fieldSelection(ranges,field){return EditorSelection.create(ranges.filter((r=>r.field==field)).map((r=>EditorSelection.range(r.from,r.to))))}function snippet(template){let snippet=Snippet.parse(template);return(editor,completion,from,to)=>{let{text:text,ranges:ranges}=snippet.instantiate(editor.state,from),spec={changes:{from:from,to:to,insert:Text.of(text)},scrollIntoView:!0,annotations:completion?pickedCompletion.of(completion):void 0};if(ranges.length&&(spec.selection=fieldSelection(ranges,0)),ranges.length>1){let active=new ActiveSnippet(ranges,0),effects=spec.effects=[setActive.of(active)];void 0===editor.state.field(snippetState,!1)&&effects.push(StateEffect.appendConfig.of([snippetState,addSnippetKeymap,snippetPointerHandler,baseTheme$1]))}editor.dispatch(editor.state.update(spec))}}function moveField(dir){return _ref44=>{let{state:state,dispatch:dispatch}=_ref44,active=state.field(snippetState,!1);if(!active||dir<0&&0==active.active)return!1;let next=active.active+dir,last=dir>0&&!active.ranges.some((r=>r.field==next+dir));return dispatch(state.update({selection:fieldSelection(active.ranges,next),effects:setActive.of(last?null:new ActiveSnippet(active.ranges,next))})),!0}}const defaultSnippetKeymap=[{key:"Tab",run:moveField(1),shift:moveField(-1)},{key:"Escape",run:_ref45=>{let{state:state,dispatch:dispatch}=_ref45;return!!state.field(snippetState,!1)&&(dispatch(state.update({effects:setActive.of(null)})),!0)}}],snippetKeymap=Facet.define({combine:maps=>maps.length?maps[0]:defaultSnippetKeymap}),addSnippetKeymap=Prec.highest(keymap.compute([snippetKeymap],(state=>state.facet(snippetKeymap))));function snippetCompletion(template,completion){return Object.assign(Object.assign({},completion),{apply:snippet(template)})}const snippetPointerHandler=EditorView.domEventHandlers({mousedown(event,view){let pos,active=view.state.field(snippetState,!1);if(!active||null==(pos=view.posAtCoords({x:event.clientX,y:event.clientY})))return!1;let match=active.ranges.find((r=>r.from<=pos&&r.to>=pos));return!(!match||match.field==active.active)&&(view.dispatch({selection:fieldSelection(active.ranges,match.field),effects:setActive.of(active.ranges.some((r=>r.field>match.field))?new ActiveSnippet(active.ranges,match.field):null)}),!0)}}),defaults={brackets:["(","[","{","'",'"'],before:")]}:;>",stringPrefixes:[]},closeBracketEffect=StateEffect.define({map(value,mapping){let mapped=mapping.mapPos(value,-1,MapMode.TrackAfter);return null==mapped?void 0:mapped}}),closedBracket=new class extends RangeValue{};closedBracket.startSide=1,closedBracket.endSide=-1;const bracketState=StateField.define({create:()=>RangeSet.empty,update(value,tr){if(tr.selection){let lineStart=tr.state.doc.lineAt(tr.selection.main.head).from,prevLineStart=tr.startState.doc.lineAt(tr.startState.selection.main.head).from;lineStart!=tr.changes.mapPos(prevLineStart,-1)&&(value=RangeSet.empty)}value=value.map(tr.changes);for(let effect of tr.effects)effect.is(closeBracketEffect)&&(value=value.update({add:[closedBracket.range(effect.value,effect.value+1)]}));return value}});function closing(ch){for(let i=0;i<"()[]{}<>".length;i+=2)if("()[]{}<>".charCodeAt(i)==ch)return"()[]{}<>".charAt(i+1);return fromCodePoint(ch<128?ch:ch+1)}function config(state,pos){return state.languageDataAt("closeBrackets",pos)[0]||defaults}const android$1="object"==typeof navigator&&/Android\b/.test(navigator.userAgent),inputHandler=EditorView.inputHandler.of(((view,from,to,insert)=>{if((android$1?view.composing:view.compositionStarted)||view.state.readOnly)return!1;let sel=view.state.selection.main;if(insert.length>2||2==insert.length&&1==codePointSize(codePointAt(insert,0))||from!=sel.from||to!=sel.to)return!1;let tr=function(state,bracket){let conf=config(state,state.selection.main.head),tokens=conf.brackets||defaults.brackets;for(let tok of tokens){let closed=closing(codePointAt(tok,0));if(bracket==tok)return closed==tok?handleSame(state,tok,tokens.indexOf(tok+tok+tok)>-1,conf):handleOpen(state,tok,closed,conf.before||defaults.before);if(bracket==closed&&closedBracketAt(state,state.selection.main.from))return handleClose(state,tok,closed)}return null}(view.state,insert);return!!tr&&(view.dispatch(tr),!0)})),closeBracketsKeymap=[{key:"Backspace",run:_ref46=>{let{state:state,dispatch:dispatch}=_ref46;if(state.readOnly)return!1;let tokens=config(state,state.selection.main.head).brackets||defaults.brackets,dont=null,changes=state.changeByRange((range=>{if(range.empty){let before=function(doc,pos){let prev=doc.sliceString(pos-2,pos);return codePointSize(codePointAt(prev,0))==prev.length?prev:prev.slice(1)}(state.doc,range.head);for(let token of tokens)if(token==before&&nextChar(state.doc,range.head)==closing(codePointAt(token,0)))return{changes:{from:range.head-token.length,to:range.head+token.length},range:EditorSelection.cursor(range.head-token.length)}}return{range:dont=range}}));return dont||dispatch(state.update(changes,{scrollIntoView:!0,userEvent:"delete.backward"})),!dont}}];function closedBracketAt(state,pos){let found=!1;return state.field(bracketState).between(0,state.doc.length,(from=>{from==pos&&(found=!0)})),found}function nextChar(doc,pos){let next=doc.sliceString(pos,pos+2);return next.slice(0,codePointSize(codePointAt(next,0)))}function handleOpen(state,open,close,closeBefore){let dont=null,changes=state.changeByRange((range=>{if(!range.empty)return{changes:[{insert:open,from:range.from},{insert:close,from:range.to}],effects:closeBracketEffect.of(range.to+open.length),range:EditorSelection.range(range.anchor+open.length,range.head+open.length)};let next=nextChar(state.doc,range.head);return!next||/\s/.test(next)||closeBefore.indexOf(next)>-1?{changes:{insert:open+close,from:range.head},effects:closeBracketEffect.of(range.head+open.length),range:EditorSelection.cursor(range.head+open.length)}:{range:dont=range}}));return dont?null:state.update(changes,{scrollIntoView:!0,userEvent:"input.type"})}function handleClose(state,_open,close){let dont=null,changes=state.changeByRange((range=>range.empty&&nextChar(state.doc,range.head)==close?{changes:{from:range.head,to:range.head+close.length,insert:close},range:EditorSelection.cursor(range.head+close.length)}:dont={range:range}));return dont?null:state.update(changes,{scrollIntoView:!0,userEvent:"input.type"})}function handleSame(state,token,allowTriple,config){let stringPrefixes=config.stringPrefixes||defaults.stringPrefixes,dont=null,changes=state.changeByRange((range=>{if(!range.empty)return{changes:[{insert:token,from:range.from},{insert:token,from:range.to}],effects:closeBracketEffect.of(range.to+token.length),range:EditorSelection.range(range.anchor+token.length,range.head+token.length)};let start,pos=range.head,next=nextChar(state.doc,pos);if(next==token){if(nodeStart(state,pos))return{changes:{insert:token+token,from:pos},effects:closeBracketEffect.of(pos+token.length),range:EditorSelection.cursor(pos+token.length)};if(closedBracketAt(state,pos)){let content=allowTriple&&state.sliceDoc(pos,pos+3*token.length)==token+token+token?token+token+token:token;return{changes:{from:pos,to:pos+content.length,insert:content},range:EditorSelection.cursor(pos+content.length)}}}else{if(allowTriple&&state.sliceDoc(pos-2*token.length,pos)==token+token&&(start=canStartStringAt(state,pos-2*token.length,stringPrefixes))>-1&&nodeStart(state,start))return{changes:{insert:token+token+token+token,from:pos},effects:closeBracketEffect.of(pos+token.length),range:EditorSelection.cursor(pos+token.length)};if(state.charCategorizer(pos)(next)!=CharCategory.Word&&canStartStringAt(state,pos,stringPrefixes)>-1&&!function(state,pos,quoteToken,prefixes){let node=syntaxTree(state).resolveInner(pos,-1),maxPrefix=prefixes.reduce(((m,p)=>Math.max(m,p.length)),0);for(let i=0;i<5;i++){let start=state.sliceDoc(node.from,Math.min(node.to,node.from+quoteToken.length+maxPrefix)),quotePos=start.indexOf(quoteToken);if(!quotePos||quotePos>-1&&prefixes.indexOf(start.slice(0,quotePos))>-1){let first=node.firstChild;for(;first&&first.from==node.from&&first.to-first.from>quoteToken.length+quotePos;){if(state.sliceDoc(first.to-quoteToken.length,first.to)==quoteToken)return!1;first=first.firstChild}return!0}let parent=node.to==pos&&node.parent;if(!parent)break;node=parent}return!1}(state,pos,token,stringPrefixes))return{changes:{insert:token+token,from:pos},effects:closeBracketEffect.of(pos+token.length),range:EditorSelection.cursor(pos+token.length)}}return{range:dont=range}}));return dont?null:state.update(changes,{scrollIntoView:!0,userEvent:"input.type"})}function nodeStart(state,pos){let tree=syntaxTree(state).resolveInner(pos+1);return tree.parent&&tree.from==pos}function canStartStringAt(state,pos,prefixes){let charCat=state.charCategorizer(pos);if(charCat(state.sliceDoc(pos-1,pos))!=CharCategory.Word)return pos;for(let prefix of prefixes){let start=pos-prefix.length;if(state.sliceDoc(start,pos)==prefix&&charCat(state.sliceDoc(start-1,start))!=CharCategory.Word)return start}return-1}function autocompletion(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return[completionState,completionConfig.of(config),completionPlugin,completionKeymapExt,baseTheme$1]}const completionKeymap=[{key:"Ctrl-Space",run:view=>!!view.state.field(completionState,!1)&&(view.dispatch({effects:startCompletionEffect.of(!0)}),!0)},{key:"Escape",run:view=>{let cState=view.state.field(completionState,!1);return!(!cState||!cState.active.some((a=>0!=a.state)))&&(view.dispatch({effects:closeCompletionEffect.of(null)}),!0)}},{key:"ArrowDown",run:moveCompletionSelection(!0)},{key:"ArrowUp",run:moveCompletionSelection(!1)},{key:"PageDown",run:moveCompletionSelection(!0,"page")},{key:"PageUp",run:moveCompletionSelection(!1,"page")},{key:"Enter",run:view=>{let cState=view.state.field(completionState,!1);return!(view.state.readOnly||!cState||!cState.open||cState.open.selected<0||cState.open.disabled||Date.now()-cState.open.timestamp<view.state.facet(completionConfig).interactionDelay)&&applyCompletion(view,cState.open.options[cState.open.selected])}}],completionKeymapExt=Prec.highest(keymap.computeN([completionConfig],(state=>state.facet(completionConfig).defaultKeymap?[completionKeymap]:[])));class SelectedDiagnostic{constructor(from,to,diagnostic){this.from=from,this.to=to,this.diagnostic=diagnostic}}class LintState{constructor(diagnostics,panel,selected){this.diagnostics=diagnostics,this.panel=panel,this.selected=selected}static init(diagnostics,panel,state){let markedDiagnostics=diagnostics,diagnosticFilter=state.facet(lintConfig).markerFilter;diagnosticFilter&&(markedDiagnostics=diagnosticFilter(markedDiagnostics));let ranges=Decoration.set(markedDiagnostics.map((d=>d.from==d.to||d.from==d.to-1&&state.doc.lineAt(d.from).to==d.from?Decoration.widget({widget:new DiagnosticWidget(d),diagnostic:d}).range(d.from):Decoration.mark({attributes:{class:"cm-lintRange cm-lintRange-"+d.severity},diagnostic:d}).range(d.from,d.to))),!0);return new LintState(ranges,panel,findDiagnostic(ranges))}}function findDiagnostic(diagnostics){let diagnostic=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,after=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,found=null;return diagnostics.between(after,1e9,((from,to,_ref47)=>{let{spec:spec}=_ref47;if(!diagnostic||spec.diagnostic==diagnostic)return found=new SelectedDiagnostic(from,to,spec.diagnostic),!1})),found}const setDiagnosticsEffect=StateEffect.define(),togglePanel=StateEffect.define(),movePanelSelection=StateEffect.define(),lintState=StateField.define({create:()=>new LintState(Decoration.none,null,null),update(value,tr){if(tr.docChanged){let mapped=value.diagnostics.map(tr.changes),selected=null;if(value.selected){let selPos=tr.changes.mapPos(value.selected.from,1);selected=findDiagnostic(mapped,value.selected.diagnostic,selPos)||findDiagnostic(mapped,null,selPos)}value=new LintState(mapped,value.panel,selected)}for(let effect of tr.effects)effect.is(setDiagnosticsEffect)?value=LintState.init(effect.value,value.panel,tr.state):effect.is(togglePanel)?value=new LintState(value.diagnostics,effect.value?LintPanel.open:null,value.selected):effect.is(movePanelSelection)&&(value=new LintState(value.diagnostics,value.panel,effect.value));return value},provide:f=>[showPanel.from(f,(val=>val.panel)),EditorView.decorations.from(f,(s=>s.diagnostics))]}),activeMark=Decoration.mark({class:"cm-lintRange cm-lintRange-active"});function diagnosticsTooltip(view,diagnostics){return crelt("ul",{class:"cm-tooltip-lint"},diagnostics.map((d=>renderDiagnostic(view,d,!1))))}const closeLintPanel=view=>{let field=view.state.field(lintState,!1);return!(!field||!field.panel)&&(view.dispatch({effects:togglePanel.of(!1)}),!0)},lintKeymap=[{key:"Mod-Shift-m",run:view=>{let field=view.state.field(lintState,!1);var state,effects;field&&field.panel||view.dispatch({effects:(state=view.state,effects=[togglePanel.of(!0)],state.field(lintState,!1)?effects:effects.concat(StateEffect.appendConfig.of(lintExtensions)))});let panel=getPanel(view,LintPanel.open);return panel&&panel.dom.querySelector(".cm-panel-lint ul").focus(),!0},preventDefault:!0},{key:"F8",run:view=>{let field=view.state.field(lintState,!1);if(!field)return!1;let sel=view.state.selection.main,next=field.diagnostics.iter(sel.to+1);return!(!next.value&&(next=field.diagnostics.iter(0),!next.value||next.from==sel.from&&next.to==sel.to))&&(view.dispatch({selection:{anchor:next.from,head:next.to},scrollIntoView:!0}),!0)}}],lintConfig=Facet.define({combine:input=>Object.assign({sources:input.map((i=>i.source))},combineConfig(input.map((i=>i.config)),{delay:750,markerFilter:null,tooltipFilter:null,needsRefresh:null},{needsRefresh:(a,b)=>a?b?u=>a(u)||b(u):a:b}))});function assignKeys(actions){let assigned=[];if(actions)actions:for(let{name:name}of actions){for(let i=0;i<name.length;i++){let ch=name[i];if(/[a-zA-Z]/.test(ch)&&!assigned.some((c=>c.toLowerCase()==ch.toLowerCase()))){assigned.push(ch);continue actions}}assigned.push("")}return assigned}function renderDiagnostic(view,diagnostic,inPanel){var _a;let keys=inPanel?assignKeys(diagnostic.actions):[];return crelt("li",{class:"cm-diagnostic cm-diagnostic-"+diagnostic.severity},crelt("span",{class:"cm-diagnosticText"},diagnostic.renderMessage?diagnostic.renderMessage():diagnostic.message),null===(_a=diagnostic.actions)||void 0===_a?void 0:_a.map(((action,i)=>{let fired=!1,click=e=>{if(e.preventDefault(),fired)return;fired=!0;let found=findDiagnostic(view.state.field(lintState).diagnostics,diagnostic);found&&action.apply(view,found.from,found.to)},{name:name}=action,keyIndex=keys[i]?name.indexOf(keys[i]):-1,nameElt=keyIndex<0?name:[name.slice(0,keyIndex),crelt("u",name.slice(keyIndex,keyIndex+1)),name.slice(keyIndex+1)];return crelt("button",{type:"button",class:"cm-diagnosticAction",onclick:click,onmousedown:click,"aria-label":" Action: ".concat(name).concat(keyIndex<0?"":' (access key "'.concat(keys[i],')"'),".")},nameElt)})),diagnostic.source&&crelt("div",{class:"cm-diagnosticSource"},diagnostic.source))}class DiagnosticWidget extends WidgetType{constructor(diagnostic){super(),this.diagnostic=diagnostic}eq(other){return other.diagnostic==this.diagnostic}toDOM(){return crelt("span",{class:"cm-lintPoint cm-lintPoint-"+this.diagnostic.severity})}}class PanelItem{constructor(view,diagnostic){this.diagnostic=diagnostic,this.id="item_"+Math.floor(4294967295*Math.random()).toString(16),this.dom=renderDiagnostic(view,diagnostic,!0),this.dom.id=this.id,this.dom.setAttribute("role","option")}}class LintPanel{constructor(view){this.view=view,this.items=[];this.list=crelt("ul",{tabIndex:0,role:"listbox","aria-label":this.view.state.phrase("Diagnostics"),onkeydown:event=>{if(27==event.keyCode)closeLintPanel(this.view),this.view.focus();else if(38==event.keyCode||33==event.keyCode)this.moveSelection((this.selectedIndex-1+this.items.length)%this.items.length);else if(40==event.keyCode||34==event.keyCode)this.moveSelection((this.selectedIndex+1)%this.items.length);else if(36==event.keyCode)this.moveSelection(0);else if(35==event.keyCode)this.moveSelection(this.items.length-1);else if(13==event.keyCode)this.view.focus();else{if(!(event.keyCode>=65&&event.keyCode<=90&&this.selectedIndex>=0))return;{let{diagnostic:diagnostic}=this.items[this.selectedIndex],keys=assignKeys(diagnostic.actions);for(let i=0;i<keys.length;i++)if(keys[i].toUpperCase().charCodeAt(0)==event.keyCode){let found=findDiagnostic(this.view.state.field(lintState).diagnostics,diagnostic);found&&diagnostic.actions[i].apply(view,found.from,found.to)}}}event.preventDefault()},onclick:event=>{for(let i=0;i<this.items.length;i++)this.items[i].dom.contains(event.target)&&this.moveSelection(i)}}),this.dom=crelt("div",{class:"cm-panel-lint"},this.list,crelt("button",{type:"button",name:"close","aria-label":this.view.state.phrase("close"),onclick:()=>closeLintPanel(this.view)},"×")),this.update()}get selectedIndex(){let selected=this.view.state.field(lintState).selected;if(!selected)return-1;for(let i=0;i<this.items.length;i++)if(this.items[i].diagnostic==selected.diagnostic)return i;return-1}update(){let{diagnostics:diagnostics,selected:selected}=this.view.state.field(lintState),i=0,needsSync=!1,newSelectedItem=null;for(diagnostics.between(0,this.view.state.doc.length,((_start,_end,_ref49)=>{let item,{spec:spec}=_ref49,found=-1;for(let j=i;j<this.items.length;j++)if(this.items[j].diagnostic==spec.diagnostic){found=j;break}found<0?(item=new PanelItem(this.view,spec.diagnostic),this.items.splice(i,0,item),needsSync=!0):(item=this.items[found],found>i&&(this.items.splice(i,found-i),needsSync=!0)),selected&&item.diagnostic==selected.diagnostic?item.dom.hasAttribute("aria-selected")||(item.dom.setAttribute("aria-selected","true"),newSelectedItem=item):item.dom.hasAttribute("aria-selected")&&item.dom.removeAttribute("aria-selected"),i++}));i<this.items.length&&!(1==this.items.length&&this.items[0].diagnostic.from<0);)needsSync=!0,this.items.pop();0==this.items.length&&(this.items.push(new PanelItem(this.view,{from:-1,to:-1,severity:"info",message:this.view.state.phrase("No diagnostics")})),needsSync=!0),newSelectedItem?(this.list.setAttribute("aria-activedescendant",newSelectedItem.id),this.view.requestMeasure({key:this,read:()=>({sel:newSelectedItem.dom.getBoundingClientRect(),panel:this.list.getBoundingClientRect()}),write:_ref50=>{let{sel:sel,panel:panel}=_ref50;sel.top<panel.top?this.list.scrollTop-=panel.top-sel.top:sel.bottom>panel.bottom&&(this.list.scrollTop+=sel.bottom-panel.bottom)}})):this.selectedIndex<0&&this.list.removeAttribute("aria-activedescendant"),needsSync&&this.sync()}sync(){let domPos=this.list.firstChild;function rm(){let prev=domPos;domPos=prev.nextSibling,prev.remove()}for(let item of this.items)if(item.dom.parentNode==this.list){for(;domPos!=item.dom;)rm();domPos=item.dom.nextSibling}else this.list.insertBefore(item.dom,domPos);for(;domPos;)rm()}moveSelection(selectedIndex){if(this.selectedIndex<0)return;let selection=findDiagnostic(this.view.state.field(lintState).diagnostics,this.items[selectedIndex].diagnostic);selection&&this.view.dispatch({selection:{anchor:selection.from,head:selection.to},scrollIntoView:!0,effects:movePanelSelection.of(selection)})}static open(view){return new LintPanel(view)}}function underline(color){return function(content){return'url(\'data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" '.concat(arguments.length>1&&void 0!==arguments[1]?arguments[1]:'viewBox="0 0 40 40"',">").concat(encodeURIComponent(content),"</svg>')")}('<path d="m0 2.5 l2 -1.5 l1 0 l2 1.5 l1 0" stroke="'.concat(color,'" fill="none" stroke-width=".7"/>'),'width="6" height="3"')}const baseTheme=EditorView.baseTheme({".cm-diagnostic":{padding:"3px 6px 3px 8px",marginLeft:"-1px",display:"block",whiteSpace:"pre-wrap"},".cm-diagnostic-error":{borderLeft:"5px solid #d11"},".cm-diagnostic-warning":{borderLeft:"5px solid orange"},".cm-diagnostic-info":{borderLeft:"5px solid #999"},".cm-diagnosticAction":{font:"inherit",border:"none",padding:"2px 4px",backgroundColor:"#444",color:"white",borderRadius:"3px",marginLeft:"8px",cursor:"pointer"},".cm-diagnosticSource":{fontSize:"70%",opacity:.7},".cm-lintRange":{backgroundPosition:"left bottom",backgroundRepeat:"repeat-x",paddingBottom:"0.7px"},".cm-lintRange-error":{backgroundImage:underline("#d11")},".cm-lintRange-warning":{backgroundImage:underline("orange")},".cm-lintRange-info":{backgroundImage:underline("#999")},".cm-lintRange-active":{backgroundColor:"#ffdd9980"},".cm-tooltip-lint":{padding:0,margin:0},".cm-lintPoint":{position:"relative","&:after":{content:'""',position:"absolute",bottom:0,left:"-2px",borderLeft:"3px solid transparent",borderRight:"3px solid transparent",borderBottom:"4px solid #d11"}},".cm-lintPoint-warning":{"&:after":{borderBottomColor:"orange"}},".cm-lintPoint-info":{"&:after":{borderBottomColor:"#999"}},".cm-panel.cm-panel-lint":{position:"relative","& ul":{maxHeight:"100px",overflowY:"auto","& [aria-selected]":{backgroundColor:"#ddd","& u":{textDecoration:"underline"}},"&:focus [aria-selected]":{background_fallback:"#bdf",backgroundColor:"Highlight",color_fallback:"white",color:"HighlightText"},"& u":{textDecoration:"none"},padding:0,margin:0},"& [name=close]":{position:"absolute",top:"0",right:"2px",background:"inherit",border:"none",font:"inherit",padding:0,margin:0}}}),lintExtensions=[lintState,EditorView.decorations.compute([lintState],(state=>{let{selected:selected,panel:panel}=state.field(lintState);return selected&&panel&&selected.from!=selected.to?Decoration.set([activeMark.range(selected.from,selected.to)]):Decoration.none})),function(source){let options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},setHover=StateEffect.define(),hoverState=StateField.define({create:()=>null,update(value,tr){if(value&&(options.hideOnChange&&(tr.docChanged||tr.selection)||options.hideOn&&options.hideOn(tr,value)))return null;if(value&&tr.docChanged){let newPos=tr.changes.mapPos(value.pos,-1,MapMode.TrackDel);if(null==newPos)return null;let copy=Object.assign(Object.create(null),value);copy.pos=newPos,null!=value.end&&(copy.end=tr.changes.mapPos(value.end)),value=copy}for(let effect of tr.effects)effect.is(setHover)&&(value=effect.value),effect.is(closeHoverTooltipEffect)&&(value=null);return value},provide:f=>showHoverTooltip.from(f)});return[hoverState,ViewPlugin.define((view=>new HoverPlugin(view,source,hoverState,setHover,options.hoverTime||300))),showHoverTooltipHost]}((function(view,pos,side){let{diagnostics:diagnostics}=view.state.field(lintState),found=[],stackStart=2e8,stackEnd=0;diagnostics.between(pos-(side<0?1:0),pos+(side>0?1:0),((from,to,_ref48)=>{let{spec:spec}=_ref48;pos>=from&&pos<=to&&(from==to||(pos>from||side>0)&&(pos<to||side<0))&&(found.push(spec.diagnostic),stackStart=Math.min(from,stackStart),stackEnd=Math.max(to,stackEnd))}));let diagnosticFilter=view.state.facet(lintConfig).tooltipFilter;return diagnosticFilter&&(found=diagnosticFilter(found)),found.length?{pos:stackStart,end:stackEnd,above:view.state.doc.lineAt(stackStart).to<stackEnd,create:()=>({dom:diagnosticsTooltip(view,found)})}:null}),{hideOn:function(tr,tooltip){let line=tr.startState.doc.lineAt(tooltip.pos);return!(!tr.effects.some((e=>e.is(setDiagnosticsEffect)))&&!tr.changes.touchesRange(line.from,line.to))}}),baseTheme],basicSetup=[lineNumbers(),activeLineGutterHighlighter,highlightSpecialChars(),history(),foldGutter(),drawSelection(),[dropCursorPos,drawDropCursor],EditorState.allowMultipleSelections.of(!0),EditorState.transactionFilter.of((tr=>{if(!tr.docChanged||!tr.isUserEvent("input.type")&&!tr.isUserEvent("input.complete"))return tr;let rules=tr.startState.languageDataAt("indentOnInput",tr.startState.selection.main.head);if(!rules.length)return tr;let doc=tr.newDoc,{head:head}=tr.newSelection.main,line=doc.lineAt(head);if(head>line.from+200)return tr;let lineStart=doc.sliceString(line.from,head);if(!rules.some((r=>r.test(lineStart))))return tr;let{state:state}=tr,last=-1,changes=[];for(let{head:head}of state.selection.ranges){let line=state.doc.lineAt(head);if(line.from==last)continue;last=line.from;let indent=getIndentation(state,line.from);if(null==indent)continue;let cur=/^\s*/.exec(line.text)[0],norm=indentString(state,indent);cur!=norm&&changes.push({from:line.from,to:line.from+cur.length,insert:norm})}return changes.length?[tr,{changes:changes,sequential:!0}]:tr})),syntaxHighlighting(defaultHighlightStyle,{fallback:!0}),bracketMatching(),[inputHandler,bracketState],autocompletion(),rectangularSelection(),crosshairCursor(),activeLineHighlighter,highlightSelectionMatches(),keymap.of([...closeBracketsKeymap,...defaultKeymap,...searchKeymap,...historyKeymap,...foldKeymap,...completionKeymap,...lintKeymap])];_exports.basicSetup=basicSetup;class Stack{constructor(p,stack,state,reducePos,pos,score,buffer,bufferBase,curContext){let lookAhead=arguments.length>9&&void 0!==arguments[9]?arguments[9]:0,parent=arguments.length>10?arguments[10]:void 0;this.p=p,this.stack=stack,this.state=state,this.reducePos=reducePos,this.pos=pos,this.score=score,this.buffer=buffer,this.bufferBase=bufferBase,this.curContext=curContext,this.lookAhead=lookAhead,this.parent=parent}toString(){return"[".concat(this.stack.filter(((_,i)=>i%3==0)).concat(this.state),"]@").concat(this.pos).concat(this.score?"!"+this.score:"")}static start(p,state){let pos=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,cx=p.parser.context;return new Stack(p,[],state,pos,pos,0,[],0,cx?new StackContext(cx,cx.start):null,0,null)}get context(){return this.curContext?this.curContext.context:null}pushState(state,start){this.stack.push(this.state,start,this.bufferBase+this.buffer.length),this.state=state}reduce(action){var _a;let depth=action>>19,type=65535&action,{parser:parser}=this.p,dPrec=parser.dynamicPrecedence(type);if(dPrec&&(this.score+=dPrec),0==depth)return this.pushState(parser.getGoto(this.state,type,!0),this.reducePos),type<parser.minRepeatTerm&&this.storeNode(type,this.reducePos,this.reducePos,4,!0),void this.reduceContext(type,this.reducePos);let base=this.stack.length-3*(depth-1)-(262144&action?6:0),start=base?this.stack[base-2]:this.p.ranges[0].from,size=this.reducePos-start;size>=2e3&&!(null===(_a=this.p.parser.nodeSet.types[type])||void 0===_a?void 0:_a.isAnonymous)&&(start==this.p.lastBigReductionStart?(this.p.bigReductionCount++,this.p.lastBigReductionSize=size):this.p.lastBigReductionSize<size&&(this.p.bigReductionCount=1,this.p.lastBigReductionStart=start,this.p.lastBigReductionSize=size));let bufferBase=base?this.stack[base-1]:0,count=this.bufferBase+this.buffer.length-bufferBase;if(type<parser.minRepeatTerm||131072&action){let pos=parser.stateFlag(this.state,1)?this.pos:this.reducePos;this.storeNode(type,start,pos,count+4,!0)}if(262144&action)this.state=this.stack[base];else{let baseStateID=this.stack[base-3];this.state=parser.getGoto(baseStateID,type,!0)}for(;this.stack.length>base;)this.stack.pop();this.reduceContext(type,start)}storeNode(term,start,end){let size=arguments.length>3&&void 0!==arguments[3]?arguments[3]:4,isReduce=arguments.length>4&&void 0!==arguments[4]&&arguments[4];if(0==term&&(!this.stack.length||this.stack[this.stack.length-1]<this.buffer.length+this.bufferBase)){let cur=this,top=this.buffer.length;if(0==top&&cur.parent&&(top=cur.bufferBase-cur.parent.bufferBase,cur=cur.parent),top>0&&0==cur.buffer[top-4]&&cur.buffer[top-1]>-1){if(start==end)return;if(cur.buffer[top-2]>=start)return void(cur.buffer[top-2]=end)}}if(isReduce&&this.pos!=end){let index=this.buffer.length;if(index>0&&0!=this.buffer[index-4])for(;index>0&&this.buffer[index-2]>end;)this.buffer[index]=this.buffer[index-4],this.buffer[index+1]=this.buffer[index-3],this.buffer[index+2]=this.buffer[index-2],this.buffer[index+3]=this.buffer[index-1],index-=4,size>4&&(size-=4);this.buffer[index]=term,this.buffer[index+1]=start,this.buffer[index+2]=end,this.buffer[index+3]=size}else this.buffer.push(term,start,end,size)}shift(action,next,nextEnd){let start=this.pos;if(131072&action)this.pushState(65535&action,this.pos);else if(0==(262144&action)){let nextState=action,{parser:parser}=this.p;(nextEnd>this.pos||next<=parser.maxNode)&&(this.pos=nextEnd,parser.stateFlag(nextState,1)||(this.reducePos=nextEnd)),this.pushState(nextState,start),this.shiftContext(next,start),next<=parser.maxNode&&this.buffer.push(next,start,nextEnd,4)}else this.pos=nextEnd,this.shiftContext(next,start),next<=this.p.parser.maxNode&&this.buffer.push(next,start,nextEnd,4)}apply(action,next,nextEnd){65536&action?this.reduce(action):this.shift(action,next,nextEnd)}useNode(value,next){let index=this.p.reused.length-1;(index<0||this.p.reused[index]!=value)&&(this.p.reused.push(value),index++);let start=this.pos;this.reducePos=this.pos=start+value.length,this.pushState(next,start),this.buffer.push(index,start,this.reducePos,-1),this.curContext&&this.updateContext(this.curContext.tracker.reuse(this.curContext.context,value,this,this.p.stream.reset(this.pos-value.length)))}split(){let parent=this,off=parent.buffer.length;for(;off>0&&parent.buffer[off-2]>parent.reducePos;)off-=4;let buffer=parent.buffer.slice(off),base=parent.bufferBase+off;for(;parent&&base==parent.bufferBase;)parent=parent.parent;return new Stack(this.p,this.stack.slice(),this.state,this.reducePos,this.pos,this.score,buffer,base,this.curContext,this.lookAhead,parent)}recoverByDelete(next,nextEnd){let isNode=next<=this.p.parser.maxNode;isNode&&this.storeNode(next,this.pos,nextEnd,4),this.storeNode(0,this.pos,nextEnd,isNode?8:4),this.pos=this.reducePos=nextEnd,this.score-=190}canShift(term){for(let sim=new SimulatedStack(this);;){let action=this.p.parser.stateSlot(sim.state,4)||this.p.parser.hasAction(sim.state,term);if(0==action)return!1;if(0==(65536&action))return!0;sim.reduce(action)}}recoverByInsert(next){if(this.stack.length>=300)return[];let nextStates=this.p.parser.nextStates(this.state);if(nextStates.length>8||this.stack.length>=120){let best=[];for(let s,i=0;i<nextStates.length;i+=2)(s=nextStates[i+1])!=this.state&&this.p.parser.hasAction(s,next)&&best.push(nextStates[i],s);if(this.stack.length<120)for(let i=0;best.length<8&&i<nextStates.length;i+=2){let s=nextStates[i+1];best.some(((v,i)=>1&i&&v==s))||best.push(nextStates[i],s)}nextStates=best}let result=[];for(let i=0;i<nextStates.length&&result.length<4;i+=2){let s=nextStates[i+1];if(s==this.state)continue;let stack=this.split();stack.pushState(s,this.pos),stack.storeNode(0,stack.pos,stack.pos,4,!0),stack.shiftContext(nextStates[i],this.pos),stack.score-=200,result.push(stack)}return result}forceReduce(){let{parser:parser}=this.p,reduce=parser.stateSlot(this.state,5);if(0==(65536&reduce))return!1;if(!parser.validAction(this.state,reduce)){let depth=reduce>>19,term=65535&reduce,target=this.stack.length-3*depth;if(target<0||parser.getGoto(this.stack[target],term,!1)<0){let backup=this.findForcedReduction();if(null==backup)return!1;reduce=backup}this.storeNode(0,this.reducePos,this.reducePos,4,!0),this.score-=100}return this.reducePos=this.pos,this.reduce(reduce),!0}findForcedReduction(){let{parser:parser}=this.p,seen=[],explore=(state,depth)=>{if(!seen.includes(state))return seen.push(state),parser.allActions(state,(action=>{if(393216&action);else if(65536&action){let rDepth=(action>>19)-depth;if(rDepth>1){let term=65535&action,target=this.stack.length-3*rDepth;if(target>=0&&parser.getGoto(this.stack[target],term,!1)>=0)return rDepth<<19|65536|term}}else{let found=explore(action,depth+1);if(null!=found)return found}}))};return explore(this.state,0)}forceAll(){for(;!this.p.parser.stateFlag(this.state,2);)if(!this.forceReduce()){this.storeNode(0,this.pos,this.pos,4,!0);break}return this}get deadEnd(){if(3!=this.stack.length)return!1;let{parser:parser}=this.p;return 65535==parser.data[parser.stateSlot(this.state,1)]&&!parser.stateSlot(this.state,4)}restart(){this.state=this.stack[0],this.stack.length=0}sameState(other){if(this.state!=other.state||this.stack.length!=other.stack.length)return!1;for(let i=0;i<this.stack.length;i+=3)if(this.stack[i]!=other.stack[i])return!1;return!0}get parser(){return this.p.parser}dialectEnabled(dialectID){return this.p.parser.dialect.flags[dialectID]}shiftContext(term,start){this.curContext&&this.updateContext(this.curContext.tracker.shift(this.curContext.context,term,this,this.p.stream.reset(start)))}reduceContext(term,start){this.curContext&&this.updateContext(this.curContext.tracker.reduce(this.curContext.context,term,this,this.p.stream.reset(start)))}emitContext(){let last=this.buffer.length-1;(last<0||-3!=this.buffer[last])&&this.buffer.push(this.curContext.hash,this.pos,this.pos,-3)}emitLookAhead(){let last=this.buffer.length-1;(last<0||-4!=this.buffer[last])&&this.buffer.push(this.lookAhead,this.pos,this.pos,-4)}updateContext(context){if(context!=this.curContext.context){let newCx=new StackContext(this.curContext.tracker,context);newCx.hash!=this.curContext.hash&&this.emitContext(),this.curContext=newCx}}setLookAhead(lookAhead){lookAhead>this.lookAhead&&(this.emitLookAhead(),this.lookAhead=lookAhead)}close(){this.curContext&&this.curContext.tracker.strict&&this.emitContext(),this.lookAhead>0&&this.emitLookAhead()}}class StackContext{constructor(tracker,context){this.tracker=tracker,this.context=context,this.hash=tracker.strict?tracker.hash(context):0}}var Recover;!function(Recover){Recover[Recover.Insert=200]="Insert",Recover[Recover.Delete=190]="Delete",Recover[Recover.Reduce=100]="Reduce",Recover[Recover.MaxNext=4]="MaxNext",Recover[Recover.MaxInsertStackDepth=300]="MaxInsertStackDepth",Recover[Recover.DampenInsertStackDepth=120]="DampenInsertStackDepth",Recover[Recover.MinBigReduction=2e3]="MinBigReduction"}(Recover||(Recover={}));class SimulatedStack{constructor(start){this.start=start,this.state=start.state,this.stack=start.stack,this.base=this.stack.length}reduce(action){let term=65535&action,depth=action>>19;0==depth?(this.stack==this.start.stack&&(this.stack=this.stack.slice()),this.stack.push(this.state,0,0),this.base+=3):this.base-=3*(depth-1);let goto=this.start.p.parser.getGoto(this.stack[this.base-3],term,!0);this.state=goto}}class StackBufferCursor{constructor(stack,pos,index){this.stack=stack,this.pos=pos,this.index=index,this.buffer=stack.buffer,0==this.index&&this.maybeNext()}static create(stack){let pos=arguments.length>1&&void 0!==arguments[1]?arguments[1]:stack.bufferBase+stack.buffer.length;return new StackBufferCursor(stack,pos,pos-stack.bufferBase)}maybeNext(){let next=this.stack.parent;null!=next&&(this.index=this.stack.bufferBase-next.bufferBase,this.stack=next,this.buffer=next.buffer)}get id(){return this.buffer[this.index-4]}get start(){return this.buffer[this.index-3]}get end(){return this.buffer[this.index-2]}get size(){return this.buffer[this.index-1]}next(){this.index-=4,this.pos-=4,0==this.index&&this.maybeNext()}fork(){return new StackBufferCursor(this.stack,this.pos,this.index)}}function decodeArray(input){let Type=arguments.length>1&&void 0!==arguments[1]?arguments[1]:Uint16Array;if("string"!=typeof input)return input;let array=null;for(let pos=0,out=0;pos<input.length;){let value=0;for(;;){let next=input.charCodeAt(pos++),stop=!1;if(126==next){value=65535;break}next>=92&&next--,next>=34&&next--;let digit=next-32;if(digit>=46&&(digit-=46,stop=!0),value+=digit,stop)break;value*=46}array?array[out++]=value:array=new Type(value)}return array}class CachedToken{constructor(){this.start=-1,this.value=-1,this.end=-1,this.extended=-1,this.lookAhead=0,this.mask=0,this.context=0}}const nullToken=new CachedToken;class InputStream{constructor(input,ranges){this.input=input,this.ranges=ranges,this.chunk="",this.chunkOff=0,this.chunk2="",this.chunk2Pos=0,this.next=-1,this.token=nullToken,this.rangeIndex=0,this.pos=this.chunkPos=ranges[0].from,this.range=ranges[0],this.end=ranges[ranges.length-1].to,this.readNext()}resolveOffset(offset,assoc){let range=this.range,index=this.rangeIndex,pos=this.pos+offset;for(;pos<range.from;){if(!index)return null;let next=this.ranges[--index];pos-=range.from-next.to,range=next}for(;assoc<0?pos>range.to:pos>=range.to;){if(index==this.ranges.length-1)return null;let next=this.ranges[++index];pos+=next.from-range.to,range=next}return pos}clipPos(pos){if(pos>=this.range.from&&pos<this.range.to)return pos;for(let range of this.ranges)if(range.to>pos)return Math.max(pos,range.from);return this.end}peek(offset){let pos,result,idx=this.chunkOff+offset;if(idx>=0&&idx<this.chunk.length)pos=this.pos+offset,result=this.chunk.charCodeAt(idx);else{let resolved=this.resolveOffset(offset,1);if(null==resolved)return-1;if(pos=resolved,pos>=this.chunk2Pos&&pos<this.chunk2Pos+this.chunk2.length)result=this.chunk2.charCodeAt(pos-this.chunk2Pos);else{let i=this.rangeIndex,range=this.range;for(;range.to<=pos;)range=this.ranges[++i];this.chunk2=this.input.chunk(this.chunk2Pos=pos),pos+this.chunk2.length>range.to&&(this.chunk2=this.chunk2.slice(0,range.to-pos)),result=this.chunk2.charCodeAt(0)}}return pos>=this.token.lookAhead&&(this.token.lookAhead=pos+1),result}acceptToken(token){let endOffset=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,end=endOffset?this.resolveOffset(endOffset,-1):this.pos;if(null==end||end<this.token.start)throw new RangeError("Token end out of bounds");this.token.value=token,this.token.end=end}getChunk(){if(this.pos>=this.chunk2Pos&&this.pos<this.chunk2Pos+this.chunk2.length){let{chunk:chunk,chunkPos:chunkPos}=this;this.chunk=this.chunk2,this.chunkPos=this.chunk2Pos,this.chunk2=chunk,this.chunk2Pos=chunkPos,this.chunkOff=this.pos-this.chunkPos}else{this.chunk2=this.chunk,this.chunk2Pos=this.chunkPos;let nextChunk=this.input.chunk(this.pos),end=this.pos+nextChunk.length;this.chunk=end>this.range.to?nextChunk.slice(0,this.range.to-this.pos):nextChunk,this.chunkPos=this.pos,this.chunkOff=0}}readNext(){return this.chunkOff>=this.chunk.length&&(this.getChunk(),this.chunkOff==this.chunk.length)?this.next=-1:this.next=this.chunk.charCodeAt(this.chunkOff)}advance(){let n=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;for(this.chunkOff+=n;this.pos+n>=this.range.to;){if(this.rangeIndex==this.ranges.length-1)return this.setDone();n-=this.range.to-this.pos,this.range=this.ranges[++this.rangeIndex],this.pos=this.range.from}return this.pos+=n,this.pos>=this.token.lookAhead&&(this.token.lookAhead=this.pos+1),this.readNext()}setDone(){return this.pos=this.chunkPos=this.end,this.range=this.ranges[this.rangeIndex=this.ranges.length-1],this.chunk="",this.next=-1}reset(pos,token){if(token?(this.token=token,token.start=pos,token.lookAhead=pos+1,token.value=token.extended=-1):this.token=nullToken,this.pos!=pos){if(this.pos=pos,pos==this.end)return this.setDone(),this;for(;pos<this.range.from;)this.range=this.ranges[--this.rangeIndex];for(;pos>=this.range.to;)this.range=this.ranges[++this.rangeIndex];pos>=this.chunkPos&&pos<this.chunkPos+this.chunk.length?this.chunkOff=pos-this.chunkPos:(this.chunk="",this.chunkOff=0),this.readNext()}return this}read(from,to){if(from>=this.chunkPos&&to<=this.chunkPos+this.chunk.length)return this.chunk.slice(from-this.chunkPos,to-this.chunkPos);if(from>=this.chunk2Pos&&to<=this.chunk2Pos+this.chunk2.length)return this.chunk2.slice(from-this.chunk2Pos,to-this.chunk2Pos);if(from>=this.range.from&&to<=this.range.to)return this.input.read(from,to);let result="";for(let r of this.ranges){if(r.from>=to)break;r.to>from&&(result+=this.input.read(Math.max(r.from,from),Math.min(r.to,to)))}return result}}class TokenGroup{constructor(data,id){this.data=data,this.id=id}token(input,stack){let{parser:parser}=stack.p;readToken(this.data,input,stack,this.id,parser.data,parser.tokenPrecTable)}}TokenGroup.prototype.contextual=TokenGroup.prototype.fallback=TokenGroup.prototype.extend=!1;class LocalTokenGroup{constructor(data,precTable,elseToken){this.precTable=precTable,this.elseToken=elseToken,this.data="string"==typeof data?decodeArray(data):data}token(input,stack){let start=input.pos,skipped=0;for(;;){let nextPos=input.resolveOffset(1,-1);if(readToken(this.data,input,stack,0,this.data,this.precTable),input.token.value>-1)break;if(null==this.elseToken)return;if(null==nextPos)break;input.reset(nextPos,input.token),skipped++}skipped&&(input.reset(start,input.token),input.acceptToken(this.elseToken,skipped))}}LocalTokenGroup.prototype.contextual=TokenGroup.prototype.fallback=TokenGroup.prototype.extend=!1;class ExternalTokenizer{constructor(token){let options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this.token=token,this.contextual=!!options.contextual,this.fallback=!!options.fallback,this.extend=!!options.extend}}function readToken(data,input,stack,group,precTable,precOffset){let state=0,groupMask=1<<group,{dialect:dialect}=stack.p.parser;scan:for(;0!=(groupMask&data[state]);){let accEnd=data[state+1];for(let i=state+3;i<accEnd;i+=2)if((data[i+1]&groupMask)>0){let term=data[i];if(dialect.allows(term)&&(-1==input.token.value||input.token.value==term||overrides(term,input.token.value,precTable,precOffset))){input.acceptToken(term);break}}let next=input.next,low=0,high=data[state+2];if(!(input.next<0&&high>low&&65535==data[accEnd+3*high-3]&&65535==data[accEnd+3*high-3])){for(;low<high;){let mid=low+high>>1,index=accEnd+mid+(mid<<1),from=data[index],to=data[index+1]||65536;if(next<from)high=mid;else{if(!(next>=to)){state=data[index+2],input.advance();continue scan}low=mid+1}}break}state=data[accEnd+3*high-1]}}function findOffset(data,start,term){for(let next,i=start;65535!=(next=data[i]);i++)if(next==term)return i-start;return-1}function overrides(token,prev,tableData,tableOffset){let iPrev=findOffset(tableData,tableOffset,prev);return iPrev<0||findOffset(tableData,tableOffset,token)<iPrev}const verbose="undefined"!=typeof process&&process.env&&/\bparse\b/.test(process.env.LOG);let stackIDs=null;var Safety,Rec;function cutAt(tree,pos,side){let cursor=tree.cursor(IterMode.IncludeAnonymous);for(cursor.moveTo(pos);;)if(!(side<0?cursor.childBefore(pos):cursor.childAfter(pos)))for(;;){if((side<0?cursor.to<pos:cursor.from>pos)&&!cursor.type.isError)return side<0?Math.max(0,Math.min(cursor.to-1,pos-25)):Math.min(tree.length,Math.max(cursor.from+1,pos+25));if(side<0?cursor.prevSibling():cursor.nextSibling())break;if(!cursor.parent())return side<0?0:tree.length}}!function(Safety){Safety[Safety.Margin=25]="Margin"}(Safety||(Safety={}));class FragmentCursor{constructor(fragments,nodeSet){this.fragments=fragments,this.nodeSet=nodeSet,this.i=0,this.fragment=null,this.safeFrom=-1,this.safeTo=-1,this.trees=[],this.start=[],this.index=[],this.nextFragment()}nextFragment(){let fr=this.fragment=this.i==this.fragments.length?null:this.fragments[this.i++];if(fr){for(this.safeFrom=fr.openStart?cutAt(fr.tree,fr.from+fr.offset,1)-fr.offset:fr.from,this.safeTo=fr.openEnd?cutAt(fr.tree,fr.to+fr.offset,-1)-fr.offset:fr.to;this.trees.length;)this.trees.pop(),this.start.pop(),this.index.pop();this.trees.push(fr.tree),this.start.push(-fr.offset),this.index.push(0),this.nextStart=this.safeFrom}else this.nextStart=1e9}nodeAt(pos){if(pos<this.nextStart)return null;for(;this.fragment&&this.safeTo<=pos;)this.nextFragment();if(!this.fragment)return null;for(;;){let last=this.trees.length-1;if(last<0)return this.nextFragment(),null;let top=this.trees[last],index=this.index[last];if(index==top.children.length){this.trees.pop(),this.start.pop(),this.index.pop();continue}let next=top.children[index],start=this.start[last]+top.positions[index];if(start>pos)return this.nextStart=start,null;if(next instanceof Tree){if(start==pos){if(start<this.safeFrom)return null;let end=start+next.length;if(end<=this.safeTo){let lookAhead=next.prop(NodeProp.lookAhead);if(!lookAhead||end+lookAhead<this.fragment.to)return next}}this.index[last]++,start+next.length>=Math.max(this.safeFrom,pos)&&(this.trees.push(next),this.start.push(start),this.index.push(0))}else this.index[last]++,this.nextStart=start+next.length}}}class TokenCache{constructor(parser,stream){this.stream=stream,this.tokens=[],this.mainToken=null,this.actions=[],this.tokens=parser.tokenizers.map((_=>new CachedToken))}getActions(stack){let actionIndex=0,main=null,{parser:parser}=stack.p,{tokenizers:tokenizers}=parser,mask=parser.stateSlot(stack.state,3),context=stack.curContext?stack.curContext.hash:0,lookAhead=0;for(let i=0;i<tokenizers.length;i++){if(0==(1<<i&mask))continue;let tokenizer=tokenizers[i],token=this.tokens[i];if((!main||tokenizer.fallback)&&((tokenizer.contextual||token.start!=stack.pos||token.mask!=mask||token.context!=context)&&(this.updateCachedToken(token,tokenizer,stack),token.mask=mask,token.context=context),token.lookAhead>token.end+25&&(lookAhead=Math.max(token.lookAhead,lookAhead)),0!=token.value)){let startIndex=actionIndex;if(token.extended>-1&&(actionIndex=this.addActions(stack,token.extended,token.end,actionIndex)),actionIndex=this.addActions(stack,token.value,token.end,actionIndex),!tokenizer.extend&&(main=token,actionIndex>startIndex))break}}for(;this.actions.length>actionIndex;)this.actions.pop();return lookAhead&&stack.setLookAhead(lookAhead),main||stack.pos!=this.stream.end||(main=new CachedToken,main.value=stack.p.parser.eofTerm,main.start=main.end=stack.pos,actionIndex=this.addActions(stack,main.value,main.end,actionIndex)),this.mainToken=main,this.actions}getMainToken(stack){if(this.mainToken)return this.mainToken;let main=new CachedToken,{pos:pos,p:p}=stack;return main.start=pos,main.end=Math.min(pos+1,p.stream.end),main.value=pos==p.stream.end?p.parser.eofTerm:0,main}updateCachedToken(token,tokenizer,stack){let start=this.stream.clipPos(stack.pos);if(tokenizer.token(this.stream.reset(start,token),stack),token.value>-1){let{parser:parser}=stack.p;for(let i=0;i<parser.specialized.length;i++)if(parser.specialized[i]==token.value){let result=parser.specializers[i](this.stream.read(token.start,token.end),stack);if(result>=0&&stack.p.parser.dialect.allows(result>>1)){0==(1&result)?token.value=result>>1:token.extended=result>>1;break}}}else token.value=0,token.end=this.stream.clipPos(start+1)}putAction(action,token,end,index){for(let i=0;i<index;i+=3)if(this.actions[i]==action)return index;return this.actions[index++]=action,this.actions[index++]=token,this.actions[index++]=end,index}addActions(stack,token,end,index){let{state:state}=stack,{parser:parser}=stack.p,{data:data}=parser;for(let set=0;set<2;set++)for(let i=parser.stateSlot(state,set?2:1);;i+=3){if(65535==data[i]){if(1!=data[i+1]){0==index&&2==data[i+1]&&(index=this.putAction(pair(data,i+2),token,end,index));break}i=pair(data,i+2)}data[i]==token&&(index=this.putAction(pair(data,i+1),token,end,index))}return index}}!function(Rec){Rec[Rec.Distance=5]="Distance",Rec[Rec.MaxRemainingPerStep=3]="MaxRemainingPerStep",Rec[Rec.MinBufferLengthPrune=500]="MinBufferLengthPrune",Rec[Rec.ForceReduceLimit=10]="ForceReduceLimit",Rec[Rec.CutDepth=15e3]="CutDepth",Rec[Rec.CutTo=9e3]="CutTo",Rec[Rec.MaxLeftAssociativeReductionCount=300]="MaxLeftAssociativeReductionCount",Rec[Rec.MaxStackCount=12]="MaxStackCount"}(Rec||(Rec={}));class Parse{constructor(parser,input,fragments,ranges){this.parser=parser,this.input=input,this.ranges=ranges,this.recovering=0,this.nextStackID=9812,this.minStackPos=0,this.reused=[],this.stoppedAt=null,this.lastBigReductionStart=-1,this.lastBigReductionSize=0,this.bigReductionCount=0,this.stream=new InputStream(input,ranges),this.tokens=new TokenCache(parser,this.stream),this.topTerm=parser.top[1];let{from:from}=ranges[0];this.stacks=[Stack.start(this,parser.top[0],from)],this.fragments=fragments.length&&this.stream.end-from>4*parser.bufferLength?new FragmentCursor(fragments,parser.nodeSet):null}get parsedPos(){return this.minStackPos}advance(){let stopped,stoppedTokens,stacks=this.stacks,pos=this.minStackPos,newStacks=this.stacks=[];if(this.bigReductionCount>300&&1==stacks.length){let[s]=stacks;for(;s.forceReduce()&&s.stack.length&&s.stack[s.stack.length-2]>=this.lastBigReductionStart;);this.bigReductionCount=this.lastBigReductionSize=0}for(let i=0;i<stacks.length;i++){let stack=stacks[i];for(;;){if(this.tokens.mainToken=null,stack.pos>pos)newStacks.push(stack);else{if(this.advanceStack(stack,newStacks,stacks))continue;{stopped||(stopped=[],stoppedTokens=[]),stopped.push(stack);let tok=this.tokens.getMainToken(stack);stoppedTokens.push(tok.value,tok.end)}}break}}if(!newStacks.length){let finished=stopped&&function(stacks){let best=null;for(let stack of stacks){let stopped=stack.p.stoppedAt;(stack.pos==stack.p.stream.end||null!=stopped&&stack.pos>stopped)&&stack.p.parser.stateFlag(stack.state,2)&&(!best||best.score<stack.score)&&(best=stack)}return best}(stopped);if(finished)return this.stackToTree(finished);if(this.parser.strict)throw verbose&&stopped&&console.log("Stuck with token "+(this.tokens.mainToken?this.parser.getName(this.tokens.mainToken.value):"none")),new SyntaxError("No parse at "+pos);this.recovering||(this.recovering=5)}if(this.recovering&&stopped){let finished=null!=this.stoppedAt&&stopped[0].pos>this.stoppedAt?stopped[0]:this.runRecovery(stopped,stoppedTokens,newStacks);if(finished)return this.stackToTree(finished.forceAll())}if(this.recovering){let maxRemaining=1==this.recovering?1:3*this.recovering;if(newStacks.length>maxRemaining)for(newStacks.sort(((a,b)=>b.score-a.score));newStacks.length>maxRemaining;)newStacks.pop();newStacks.some((s=>s.reducePos>pos))&&this.recovering--}else if(newStacks.length>1){outer:for(let i=0;i<newStacks.length-1;i++){let stack=newStacks[i];for(let j=i+1;j<newStacks.length;j++){let other=newStacks[j];if(stack.sameState(other)||stack.buffer.length>500&&other.buffer.length>500){if(!((stack.score-other.score||stack.buffer.length-other.buffer.length)>0)){newStacks.splice(i--,1);continue outer}newStacks.splice(j--,1)}}}newStacks.length>12&&newStacks.splice(12,newStacks.length-12)}this.minStackPos=newStacks[0].pos;for(let i=1;i<newStacks.length;i++)newStacks[i].pos<this.minStackPos&&(this.minStackPos=newStacks[i].pos);return null}stopAt(pos){if(null!=this.stoppedAt&&this.stoppedAt<pos)throw new RangeError("Can't move stoppedAt forward");this.stoppedAt=pos}advanceStack(stack,stacks,split){let start=stack.pos,{parser:parser}=this,base=verbose?this.stackID(stack)+" -> ":"";if(null!=this.stoppedAt&&start>this.stoppedAt)return stack.forceReduce()?stack:null;if(this.fragments){let strictCx=stack.curContext&&stack.curContext.tracker.strict,cxHash=strictCx?stack.curContext.hash:0;for(let cached=this.fragments.nodeAt(start);cached;){let match=this.parser.nodeSet.types[cached.type.id]==cached.type?parser.getGoto(stack.state,cached.type.id):-1;if(match>-1&&cached.length&&(!strictCx||(cached.prop(NodeProp.contextHash)||0)==cxHash))return stack.useNode(cached,match),verbose&&console.log(base+this.stackID(stack)+" (via reuse of ".concat(parser.getName(cached.type.id),")")),!0;if(!(cached instanceof Tree)||0==cached.children.length||cached.positions[0]>0)break;let inner=cached.children[0];if(!(inner instanceof Tree&&0==cached.positions[0]))break;cached=inner}}let defaultReduce=parser.stateSlot(stack.state,4);if(defaultReduce>0)return stack.reduce(defaultReduce),verbose&&console.log(base+this.stackID(stack)+" (via always-reduce ".concat(parser.getName(65535&defaultReduce),")")),!0;if(stack.stack.length>=15e3)for(;stack.stack.length>9e3&&stack.forceReduce(););let actions=this.tokens.getActions(stack);for(let i=0;i<actions.length;){let action=actions[i++],term=actions[i++],end=actions[i++],last=i==actions.length||!split,localStack=last?stack:stack.split();if(localStack.apply(action,term,end),verbose&&console.log(base+this.stackID(localStack)+" (via ".concat(0==(65536&action)?"shift":"reduce of ".concat(parser.getName(65535&action))," for ").concat(parser.getName(term)," @ ").concat(start).concat(localStack==stack?"":", split",")")),last)return!0;localStack.pos>start?stacks.push(localStack):split.push(localStack)}return!1}advanceFully(stack,newStacks){let pos=stack.pos;for(;;){if(!this.advanceStack(stack,null,null))return!1;if(stack.pos>pos)return pushStackDedup(stack,newStacks),!0}}runRecovery(stacks,tokens,newStacks){let finished=null,restarted=!1;for(let i=0;i<stacks.length;i++){let stack=stacks[i],token=tokens[i<<1],tokenEnd=tokens[1+(i<<1)],base=verbose?this.stackID(stack)+" -> ":"";if(stack.deadEnd){if(restarted)continue;if(restarted=!0,stack.restart(),verbose&&console.log(base+this.stackID(stack)+" (restarted)"),this.advanceFully(stack,newStacks))continue}let force=stack.split(),forceBase=base;for(let j=0;force.forceReduce()&&j<10;j++){if(verbose&&console.log(forceBase+this.stackID(force)+" (via force-reduce)"),this.advanceFully(force,newStacks))break;verbose&&(forceBase=this.stackID(force)+" -> ")}for(let insert of stack.recoverByInsert(token))verbose&&console.log(base+this.stackID(insert)+" (via recover-insert)"),this.advanceFully(insert,newStacks);this.stream.end>stack.pos?(tokenEnd==stack.pos&&(tokenEnd++,token=0),stack.recoverByDelete(token,tokenEnd),verbose&&console.log(base+this.stackID(stack)+" (via recover-delete ".concat(this.parser.getName(token),")")),pushStackDedup(stack,newStacks)):(!finished||finished.score<stack.score)&&(finished=stack)}return finished}stackToTree(stack){return stack.close(),Tree.build({buffer:StackBufferCursor.create(stack),nodeSet:this.parser.nodeSet,topID:this.topTerm,maxBufferLength:this.parser.bufferLength,reused:this.reused,start:this.ranges[0].from,length:stack.pos-this.ranges[0].from,minRepeatType:this.parser.minRepeatTerm})}stackID(stack){let id=(stackIDs||(stackIDs=new WeakMap)).get(stack);return id||stackIDs.set(stack,id=String.fromCodePoint(this.nextStackID++)),id+stack}}function pushStackDedup(stack,newStacks){for(let i=0;i<newStacks.length;i++){let other=newStacks[i];if(other.pos==stack.pos&&other.sameState(stack))return void(newStacks[i].score<stack.score&&(newStacks[i]=stack))}newStacks.push(stack)}class Dialect{constructor(source,flags,disabled){this.source=source,this.flags=flags,this.disabled=disabled}allows(term){return!this.disabled||0==this.disabled[term]}}const id=x=>x;class ContextTracker{constructor(spec){this.start=spec.start,this.shift=spec.shift||id,this.reduce=spec.reduce||id,this.reuse=spec.reuse||id,this.hash=spec.hash||(()=>0),this.strict=!1!==spec.strict}}class LRParser extends Parser{constructor(spec){if(super(),this.wrappers=[],14!=spec.version)throw new RangeError("Parser version (".concat(spec.version,") doesn't match runtime version (",14,")"));let nodeNames=spec.nodeNames.split(" ");this.minRepeatTerm=nodeNames.length;for(let i=0;i<spec.repeatNodeCount;i++)nodeNames.push("");let topTerms=Object.keys(spec.topRules).map((r=>spec.topRules[r][1])),nodeProps=[];for(let i=0;i<nodeNames.length;i++)nodeProps.push([]);function setProp(nodeID,prop,value){nodeProps[nodeID].push([prop,prop.deserialize(String(value))])}if(spec.nodeProps)for(let propSpec of spec.nodeProps){let prop=propSpec[0];"string"==typeof prop&&(prop=NodeProp[prop]);for(let i=1;i<propSpec.length;){let next=propSpec[i++];if(next>=0)setProp(next,prop,propSpec[i++]);else{let value=propSpec[i+-next];for(let j=-next;j>0;j--)setProp(propSpec[i++],prop,value);i++}}}this.nodeSet=new NodeSet(nodeNames.map(((name,i)=>NodeType.define({name:i>=this.minRepeatTerm?void 0:name,id:i,props:nodeProps[i],top:topTerms.indexOf(i)>-1,error:0==i,skipped:spec.skippedNodes&&spec.skippedNodes.indexOf(i)>-1})))),spec.propSources&&(this.nodeSet=this.nodeSet.extend(...spec.propSources)),this.strict=!1,this.bufferLength=DefaultBufferLength;let tokenArray=decodeArray(spec.tokenData);this.context=spec.context,this.specializerSpecs=spec.specialized||[],this.specialized=new Uint16Array(this.specializerSpecs.length);for(let i=0;i<this.specializerSpecs.length;i++)this.specialized[i]=this.specializerSpecs[i].term;this.specializers=this.specializerSpecs.map(getSpecializer),this.states=decodeArray(spec.states,Uint32Array),this.data=decodeArray(spec.stateData),this.goto=decodeArray(spec.goto),this.maxTerm=spec.maxTerm,this.tokenizers=spec.tokenizers.map((value=>"number"==typeof value?new TokenGroup(tokenArray,value):value)),this.topRules=spec.topRules,this.dialects=spec.dialects||{},this.dynamicPrecedences=spec.dynamicPrecedences||null,this.tokenPrecTable=spec.tokenPrec,this.termNames=spec.termNames||null,this.maxNode=this.nodeSet.types.length-1,this.dialect=this.parseDialect(),this.top=this.topRules[Object.keys(this.topRules)[0]]}createParse(input,fragments,ranges){let parse=new Parse(this,input,fragments,ranges);for(let w of this.wrappers)parse=w(parse,input,fragments,ranges);return parse}getGoto(state,term){let loose=arguments.length>2&&void 0!==arguments[2]&&arguments[2],table=this.goto;if(term>=table[0])return-1;for(let pos=table[term+1];;){let groupTag=table[pos++],last=1&groupTag,target=table[pos++];if(last&&loose)return target;for(let end=pos+(groupTag>>1);pos<end;pos++)if(table[pos]==state)return target;if(last)return-1}}hasAction(state,terminal){let data=this.data;for(let set=0;set<2;set++)for(let next,i=this.stateSlot(state,set?2:1);;i+=3){if(65535==(next=data[i])){if(1!=data[i+1]){if(2==data[i+1])return pair(data,i+2);break}next=data[i=pair(data,i+2)]}if(next==terminal||0==next)return pair(data,i+1)}return 0}stateSlot(state,slot){return this.states[6*state+slot]}stateFlag(state,flag){return(this.stateSlot(state,0)&flag)>0}validAction(state,action){return!!this.allActions(state,(a=>a==action||null))}allActions(state,action){let deflt=this.stateSlot(state,4),result=deflt?action(deflt):void 0;for(let i=this.stateSlot(state,1);null==result;i+=3){if(65535==this.data[i]){if(1!=this.data[i+1])break;i=pair(this.data,i+2)}result=action(pair(this.data,i+1))}return result}nextStates(state){let result=[];for(let i=this.stateSlot(state,1);;i+=3){if(65535==this.data[i]){if(1!=this.data[i+1])break;i=pair(this.data,i+2)}if(0==(1&this.data[i+2])){let value=this.data[i+1];result.some(((v,i)=>1&i&&v==value))||result.push(this.data[i],value)}}return result}configure(config){let copy=Object.assign(Object.create(LRParser.prototype),this);if(config.props&&(copy.nodeSet=this.nodeSet.extend(...config.props)),config.top){let info=this.topRules[config.top];if(!info)throw new RangeError("Invalid top rule name ".concat(config.top));copy.top=info}return config.tokenizers&&(copy.tokenizers=this.tokenizers.map((t=>{let found=config.tokenizers.find((r=>r.from==t));return found?found.to:t}))),config.specializers&&(copy.specializers=this.specializers.slice(),copy.specializerSpecs=this.specializerSpecs.map(((s,i)=>{let found=config.specializers.find((r=>r.from==s.external));if(!found)return s;let spec=Object.assign(Object.assign({},s),{external:found.to});return copy.specializers[i]=getSpecializer(spec),spec}))),config.contextTracker&&(copy.context=config.contextTracker),config.dialect&&(copy.dialect=this.parseDialect(config.dialect)),null!=config.strict&&(copy.strict=config.strict),config.wrap&&(copy.wrappers=copy.wrappers.concat(config.wrap)),null!=config.bufferLength&&(copy.bufferLength=config.bufferLength),copy}hasWrappers(){return this.wrappers.length>0}getName(term){return this.termNames?this.termNames[term]:String(term<=this.maxNode&&this.nodeSet.types[term].name||term)}get eofTerm(){return this.maxNode+1}get topNode(){return this.nodeSet.types[this.top[1]]}dynamicPrecedence(term){let prec=this.dynamicPrecedences;return null==prec?0:prec[term]||0}parseDialect(dialect){let values=Object.keys(this.dialects),flags=values.map((()=>!1));if(dialect)for(let part of dialect.split(" ")){let id=values.indexOf(part);id>=0&&(flags[id]=!0)}let disabled=null;for(let i=0;i<values.length;i++)if(!flags[i])for(let id,j=this.dialects[values[i]];65535!=(id=this.data[j++]);)(disabled||(disabled=new Uint8Array(this.maxTerm+1)))[id]=1;return new Dialect(dialect,flags,disabled)}static deserialize(spec){return new LRParser(spec)}}function pair(data,off){return data[off]|data[off+1]<<16}function getSpecializer(spec){if(spec.external){let mask=spec.extend?1:0;return(value,stack)=>spec.external(value,stack)<<1|mask}return spec.get}const selfClosers$1={area:!0,base:!0,br:!0,col:!0,command:!0,embed:!0,frame:!0,hr:!0,img:!0,input:!0,keygen:!0,link:!0,meta:!0,param:!0,source:!0,track:!0,wbr:!0,menuitem:!0},implicitlyClosed={dd:!0,li:!0,optgroup:!0,option:!0,p:!0,rp:!0,rt:!0,tbody:!0,td:!0,tfoot:!0,th:!0,tr:!0},closeOnOpen={dd:{dd:!0,dt:!0},dt:{dd:!0,dt:!0},li:{li:!0},option:{option:!0,optgroup:!0},optgroup:{optgroup:!0},p:{address:!0,article:!0,aside:!0,blockquote:!0,dir:!0,div:!0,dl:!0,fieldset:!0,footer:!0,form:!0,h1:!0,h2:!0,h3:!0,h4:!0,h5:!0,h6:!0,header:!0,hgroup:!0,hr:!0,menu:!0,nav:!0,ol:!0,p:!0,pre:!0,section:!0,table:!0,ul:!0},rp:{rp:!0,rt:!0},rt:{rp:!0,rt:!0},tbody:{tbody:!0,tfoot:!0},td:{td:!0,th:!0},tfoot:{tbody:!0},th:{td:!0,th:!0},thead:{tbody:!0,tfoot:!0},tr:{tr:!0}};function isSpace$1(ch){return 9==ch||10==ch||13==ch||32==ch}let cachedName$1=null,cachedInput$1=null,cachedPos$1=0;function tagNameAfter$1(input,offset){let pos=input.pos+offset;if(cachedPos$1==pos&&cachedInput$1==input)return cachedName$1;let next=input.peek(offset);for(;isSpace$1(next);)next=input.peek(++offset);let name="";for(;45==(ch=next)||46==ch||58==ch||ch>=65&&ch<=90||95==ch||ch>=97&&ch<=122||ch>=161;)name+=String.fromCharCode(next),next=input.peek(++offset);var ch;return cachedInput$1=input,cachedPos$1=pos,cachedName$1=name?name.toLowerCase():next==question||next==bang?void 0:null}const question=63,bang=33;function ElementContext$1(name,parent){this.name=name,this.parent=parent,this.hash=parent?parent.hash:0;for(let i=0;i<name.length;i++)this.hash+=(this.hash<<4)+name.charCodeAt(i)+(name.charCodeAt(i)<<8)}const startTagTerms=[6,10,7,8,9],elementContext$1=new ContextTracker({start:null,shift:(context,term,stack,input)=>startTagTerms.indexOf(term)>-1?new ElementContext$1(tagNameAfter$1(input,1)||"",context):context,reduce:(context,term)=>20==term&&context?context.parent:context,reuse(context,node,stack,input){let type=node.type.id;return 6==type||36==type?new ElementContext$1(tagNameAfter$1(input,1)||"",context):context},hash:context=>context?context.hash:0,strict:!1}),tagStart=new ExternalTokenizer(((input,stack)=>{if(60!=input.next)return void(input.next<0&&stack.context&&input.acceptToken(57));input.advance();let close=47==input.next;close&&input.advance();let name=tagNameAfter$1(input,0);if(void 0===name)return;if(!name)return input.acceptToken(close?14:6);let parent=stack.context?stack.context.name:null;if(close){if(name==parent)return input.acceptToken(11);if(parent&&implicitlyClosed[parent])return input.acceptToken(57,-2);if(stack.dialectEnabled(0))return input.acceptToken(12);for(let cx=stack.context;cx;cx=cx.parent)if(cx.name==name)return;input.acceptToken(13)}else{if("script"==name)return input.acceptToken(7);if("style"==name)return input.acceptToken(8);if("textarea"==name)return input.acceptToken(9);if(selfClosers$1.hasOwnProperty(name))return input.acceptToken(10);parent&&closeOnOpen[parent]&&closeOnOpen[parent][name]?input.acceptToken(57,-1):input.acceptToken(6)}}),{contextual:!0}),commentContent$2=new ExternalTokenizer((input=>{for(let dashes=0,i=0;;i++){if(input.next<0){i&&input.acceptToken(58);break}if(45==input.next)dashes++;else{if(62==input.next&&dashes>=2){i>3&&input.acceptToken(58,-2);break}dashes=0}input.advance()}}));const endTag=new ExternalTokenizer(((input,stack)=>{if(47==input.next&&62==input.peek(1)){let selfClosing=stack.dialectEnabled(1)||function(context){for(;context;context=context.parent)if("svg"==context.name||"math"==context.name)return!0;return!1}(stack.context);input.acceptToken(selfClosing?5:4,2)}else 62==input.next&&input.acceptToken(4,1)}));function contentTokenizer(tag,textToken,endToken){let lastState=2+tag.length;return new ExternalTokenizer((input=>{for(let state=0,matchedLen=0,i=0;;i++){if(input.next<0){i&&input.acceptToken(textToken);break}if(0==state&&60==input.next||1==state&&47==input.next||state>=2&&state<lastState&&input.next==tag.charCodeAt(state-2))state++,matchedLen++;else if(2!=state&&state!=lastState||!isSpace$1(input.next)){if(state==lastState&&62==input.next){i>matchedLen?input.acceptToken(textToken,-matchedLen):input.acceptToken(endToken,-(matchedLen-2));break}if((10==input.next||13==input.next)&&i){input.acceptToken(textToken,1);break}state=matchedLen=0}else matchedLen++;input.advance()}}))}const scriptTokens=contentTokenizer("script",54,1),styleTokens=contentTokenizer("style",55,2),textareaTokens=contentTokenizer("textarea",56,3),htmlHighlighting=styleTags({"Text RawText":tags$1.content,"StartTag StartCloseTag SelfClosingEndTag EndTag":tags$1.angleBracket,TagName:tags$1.tagName,"MismatchedCloseTag/TagName":[tags$1.tagName,tags$1.invalid],AttributeName:tags$1.attributeName,"AttributeValue UnquotedAttributeValue":tags$1.attributeValue,Is:tags$1.definitionOperator,"EntityReference CharacterReference":tags$1.character,Comment:tags$1.blockComment,ProcessingInst:tags$1.processingInstruction,DoctypeDecl:tags$1.documentMeta}),parser$3=LRParser.deserialize({version:14,states:",xOVO!rOOO!WQ#tO'#CqO!]Q#tO'#CzO!bQ#tO'#C}O!gQ#tO'#DQO!lQ#tO'#DSO!qOaO'#CpO!|ObO'#CpO#XOdO'#CpO$eO!rO'#CpOOO`'#Cp'#CpO$lO$fO'#DTO$tQ#tO'#DVO$yQ#tO'#DWOOO`'#Dk'#DkOOO`'#DY'#DYQVO!rOOO%OQ&rO,59]O%WQ&rO,59fO%`Q&rO,59iO%hQ&rO,59lO%sQ&rO,59nOOOa'#D^'#D^O%{OaO'#CxO&WOaO,59[OOOb'#D_'#D_O&`ObO'#C{O&kObO,59[OOOd'#D`'#D`O&sOdO'#DOO'OOdO,59[OOO`'#Da'#DaO'WO!rO,59[O'_Q#tO'#DROOO`,59[,59[OOOp'#Db'#DbO'dO$fO,59oOOO`,59o,59oO'lQ#|O,59qO'qQ#|O,59rOOO`-E7W-E7WO'vQ&rO'#CsOOQW'#DZ'#DZO(UQ&rO1G.wOOOa1G.w1G.wO(^Q&rO1G/QOOOb1G/Q1G/QO(fQ&rO1G/TOOOd1G/T1G/TO(nQ&rO1G/WOOO`1G/W1G/WOOO`1G/Y1G/YO(yQ&rO1G/YOOOa-E7[-E7[O)RQ#tO'#CyOOO`1G.v1G.vOOOb-E7]-E7]O)WQ#tO'#C|OOOd-E7^-E7^O)]Q#tO'#DPOOO`-E7_-E7_O)bQ#|O,59mOOOp-E7`-E7`OOO`1G/Z1G/ZOOO`1G/]1G/]OOO`1G/^1G/^O)gQ,UO,59_OOQW-E7X-E7XOOOa7+$c7+$cOOOb7+$l7+$lOOOd7+$o7+$oOOO`7+$r7+$rOOO`7+$t7+$tO)rQ#|O,59eO)wQ#|O,59hO)|Q#|O,59kOOO`1G/X1G/XO*RO7[O'#CvO*dOMhO'#CvOOQW1G.y1G.yOOO`1G/P1G/POOO`1G/S1G/SOOO`1G/V1G/VOOOO'#D['#D[O*uO7[O,59bOOQW,59b,59bOOOO'#D]'#D]O+WOMhO,59bOOOO-E7Y-E7YOOQW1G.|1G.|OOOO-E7Z-E7Z",stateData:"+s~O!^OS~OUSOVPOWQOXROYTO[]O][O^^O`^Oa^Ob^Oc^Ox^O{_O!dZO~OfaO~OfbO~OfcO~OfdO~OfeO~O!WfOPlP!ZlP~O!XiOQoP!ZoP~O!YlORrP!ZrP~OUSOVPOWQOXROYTOZqO[]O][O^^O`^Oa^Ob^Oc^Ox^O!dZO~O!ZrO~P#dO![sO!euO~OfvO~OfwO~OS|OhyO~OS!OOhyO~OS!QOhyO~OS!SOT!TOhyO~OS!TOhyO~O!WfOPlX!ZlX~OP!WO!Z!XO~O!XiOQoX!ZoX~OQ!ZO!Z!XO~O!YlORrX!ZrX~OR!]O!Z!XO~O!Z!XO~P#dOf!_O~O![sO!e!aO~OS!bO~OS!cO~Oi!dOSgXhgXTgX~OS!fOhyO~OS!gOhyO~OS!hOhyO~OS!iOT!jOhyO~OS!jOhyO~Of!kO~Of!lO~Of!mO~OS!nO~Ok!qO!`!oO!b!pO~OS!rO~OS!sO~OS!tO~Oa!uOb!uOc!uO!`!wO!a!uO~Oa!xOb!xOc!xO!b!wO!c!xO~Oa!uOb!uOc!uO!`!{O!a!uO~Oa!xOb!xOc!xO!b!{O!c!xO~OT~bac!dx{!d~",goto:"%p!`PPPPPPPPPPPPPPPPPPPP!a!gP!mPP!yP!|#P#S#Y#]#`#f#i#l#r#x!aP!a!aP$O$U$l$r$x%O%U%[%bPPPPPPPP%hX^OX`pXUOX`pezabcde{}!P!R!UR!q!dRhUR!XhXVOX`pRkVR!XkXWOX`pRnWR!XnXXOX`pQrXR!XpXYOX`pQ`ORx`Q{aQ}bQ!PcQ!RdQ!UeZ!e{}!P!R!UQ!v!oR!z!vQ!y!pR!|!yQgUR!VgQjVR!YjQmWR![mQpXR!^pQtZR!`tS_O`ToXp",nodeNames:"⚠ StartCloseTag StartCloseTag StartCloseTag EndTag SelfClosingEndTag StartTag StartTag StartTag StartTag StartTag StartCloseTag StartCloseTag StartCloseTag IncompleteCloseTag Document Text EntityReference CharacterReference InvalidEntity Element OpenTag TagName Attribute AttributeName Is AttributeValue UnquotedAttributeValue ScriptText CloseTag OpenTag StyleText CloseTag OpenTag TextareaText CloseTag OpenTag CloseTag SelfClosingTag Comment ProcessingInst MismatchedCloseTag CloseTag DoctypeDecl",maxTerm:67,context:elementContext$1,nodeProps:[["closedBy",-10,1,2,3,7,8,9,10,11,12,13,"EndTag",6,"EndTag SelfClosingEndTag",-4,21,30,33,36,"CloseTag"],["openedBy",4,"StartTag StartCloseTag",5,"StartTag",-4,29,32,35,37,"OpenTag"],["group",-9,14,17,18,19,20,39,40,41,42,"Entity",16,"Entity TextContent",-3,28,31,34,"TextContent Entity"]],propSources:[htmlHighlighting],skippedNodes:[0],repeatNodeCount:9,tokenData:"#%g!aR!YOX$qXY,QYZ,QZ[$q[]&X]^,Q^p$qpq,Qqr-_rs4ysv-_vw5iwxJ^x}-_}!OKP!O!P-_!P!Q$q!Q![-_![!]!!O!]!^-_!^!_!&W!_!`#$o!`!a&X!a!c-_!c!}!!O!}#R-_#R#S!!O#S#T3V#T#o!!O#o#s-_#s$f$q$f%W-_%W%o!!O%o%p-_%p&a!!O&a&b-_&b1p!!O1p4U-_4U4d!!O4d4e-_4e$IS!!O$IS$I`-_$I`$Ib!!O$Ib$Kh-_$Kh%#t!!O%#t&/x-_&/x&Et!!O&Et&FV-_&FV;'S!!O;'S;:j!&Q;:j;=`4s<%l?&r-_?&r?Ah!!O?Ah?BY$q?BY?Mn!!O?MnO$q!Z$|c`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr$qrs&}sv$qvw+Pwx(tx!^$q!^!_*V!_!a&X!a#S$q#S#T&X#T;'S$q;'S;=`+z<%lO$q!R&bX`P!a`!cpOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&Xq'UV`P!cpOv&}wx'kx!^&}!^!_(V!_;'S&};'S;=`(n<%lO&}P'pT`POv'kw!^'k!_;'S'k;'S;=`(P<%lO'kP(SP;=`<%l'kp([S!cpOv(Vx;'S(V;'S;=`(h<%lO(Vp(kP;=`<%l(Vq(qP;=`<%l&}a({W`P!a`Or(trs'ksv(tw!^(t!^!_)e!_;'S(t;'S;=`*P<%lO(t`)jT!a`Or)esv)ew;'S)e;'S;=`)y<%lO)e`)|P;=`<%l)ea*SP;=`<%l(t!Q*^V!a`!cpOr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!Q*vP;=`<%l*V!R*|P;=`<%l&XW+UYkWOX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+PW+wP;=`<%l+P!Z+}P;=`<%l$q!a,]``P!a`!cp!^^OX&XXY,QYZ,QZ]&X]^,Q^p&Xpq,Qqr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X!_-ljhS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx!P-_!P!Q$q!Q!^-_!^!_1n!_!a&X!a#S-_#S#T3V#T#s-_#s$f$q$f;'S-_;'S;=`4s<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q[/echSkWOX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!^!_0p!a#S/^#S#T0p#T#s/^#s$f+P$f;'S/^;'S;=`1h<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+PS0uXhSqr0psw0px!P0p!Q!_0p!a#s0p$f;'S0p;'S;=`1b<%l?Ah0p?BY?Mn0pS1eP;=`<%l0p[1kP;=`<%l/^!U1wbhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!U3SP;=`<%l1n!V3bchS`P!a`!cpOq&Xqr3Vrs&}sv3Vvw0pwx(tx!P3V!P!Q&X!Q!^3V!^!_1n!_!a&X!a#s3V#s$f&X$f;'S3V;'S;=`4m<%l?Ah3V?Ah?BY&X?BY?Mn3V?MnO&X!V4pP;=`<%l3V!_4vP;=`<%l-_!Z5SV!`h`P!cpOv&}wx'kx!^&}!^!_(V!_;'S&};'S;=`(n<%lO&}!_5rjhSkWc!ROX7dXZ8qZ[7d[^8q^p7dqr:crs8qst@Ttw:cwx8qx!P:c!P!Q7d!Q!]:c!]!^/^!^!_=p!_!a8q!a#S:c#S#T=p#T#s:c#s$f7d$f;'S:c;'S;=`?}<%l?Ah:c?Ah?BY7d?BY?Mn:c?MnO7d!Z7ibkWOX7dXZ8qZ[7d[^8q^p7dqr7drs8qst+Ptw7dwx8qx!]7d!]!^9f!^!a8q!a#S7d#S#T8q#T;'S7d;'S;=`:]<%lO7d!R8tVOp8qqs8qt!]8q!]!^9Z!^;'S8q;'S;=`9`<%lO8q!R9`Oa!R!R9cP;=`<%l8q!Z9mYkWa!ROX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+P!Z:`P;=`<%l7d!_:jjhSkWOX7dXZ8qZ[7d[^8q^p7dqr:crs8qst/^tw:cwx8qx!P:c!P!Q7d!Q!]:c!]!^<[!^!_=p!_!a8q!a#S:c#S#T=p#T#s:c#s$f7d$f;'S:c;'S;=`?}<%l?Ah:c?Ah?BY7d?BY?Mn:c?MnO7d!_<echSkWa!ROX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!^!_0p!a#S/^#S#T0p#T#s/^#s$f+P$f;'S/^;'S;=`1h<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+P!V=udhSOp8qqr=prs8qst0ptw=pwx8qx!P=p!P!Q8q!Q!]=p!]!^?T!^!_=p!_!a8q!a#s=p#s$f8q$f;'S=p;'S;=`?w<%l?Ah=p?Ah?BY8q?BY?Mn=p?MnO8q!V?[XhSa!Rqr0psw0px!P0p!Q!_0p!a#s0p$f;'S0p;'S;=`1b<%l?Ah0p?BY?Mn0p!V?zP;=`<%l=p!_@QP;=`<%l:c!_@[ihSkWOXAyXZCTZ[Ay[^CT^pAyqrDrrsCTswDrwxCTx!PDr!P!QAy!Q!]Dr!]!^/^!^!_G|!_!aCT!a#SDr#S#TG|#T#sDr#s$fAy$f;'SDr;'S;=`JW<%l?AhDr?Ah?BYAy?BY?MnDr?MnOAy!ZBOakWOXAyXZCTZ[Ay[^CT^pAyqrAyrsCTswAywxCTx!]Ay!]!^Cu!^!aCT!a#SAy#S#TCT#T;'SAy;'S;=`Dl<%lOAy!RCWUOpCTq!]CT!]!^Cj!^;'SCT;'S;=`Co<%lOCT!RCoOb!R!RCrP;=`<%lCT!ZC|YkWb!ROX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+P!ZDoP;=`<%lAy!_DyihSkWOXAyXZCTZ[Ay[^CT^pAyqrDrrsCTswDrwxCTx!PDr!P!QAy!Q!]Dr!]!^Fh!^!_G|!_!aCT!a#SDr#S#TG|#T#sDr#s$fAy$f;'SDr;'S;=`JW<%l?AhDr?Ah?BYAy?BY?MnDr?MnOAy!_FqchSkWb!ROX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!^!_0p!a#S/^#S#T0p#T#s/^#s$f+P$f;'S/^;'S;=`1h<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+P!VHRchSOpCTqrG|rsCTswG|wxCTx!PG|!P!QCT!Q!]G|!]!^I^!^!_G|!_!aCT!a#sG|#s$fCT$f;'SG|;'S;=`JQ<%l?AhG|?Ah?BYCT?BY?MnG|?MnOCT!VIeXhSb!Rqr0psw0px!P0p!Q!_0p!a#s0p$f;'S0p;'S;=`1b<%l?Ah0p?BY?Mn0p!VJTP;=`<%lG|!_JZP;=`<%lDr!ZJgW!bx`P!a`Or(trs'ksv(tw!^(t!^!_)e!_;'S(t;'S;=`*P<%lO(t!aK^lhS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx}-_}!OMU!O!P-_!P!Q$q!Q!^-_!^!_1n!_!a&X!a#S-_#S#T3V#T#s-_#s$f$q$f;'S-_;'S;=`4s<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q!aMckhS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx!P-_!P!Q$q!Q!^-_!^!_1n!_!`&X!`!a! W!a#S-_#S#T3V#T#s-_#s$f$q$f;'S-_;'S;=`4s<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q!T! cX`P!a`!cp!eQOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X!a!!_!ZhSfQ`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx}-_}!O!!O!O!P!!O!P!Q$q!Q![!!O![!]!!O!]!^-_!^!_1n!_!a&X!a!c-_!c!}!!O!}#R-_#R#S!!O#S#T3V#T#o!!O#o#s-_#s$f$q$f$}-_$}%O!!O%O%W-_%W%o!!O%o%p-_%p&a!!O&a&b-_&b1p!!O1p4U!!O4U4d!!O4d4e-_4e$IS!!O$IS$I`-_$I`$Ib!!O$Ib$Je-_$Je$Jg!!O$Jg$Kh-_$Kh%#t!!O%#t&/x-_&/x&Et!!O&Et&FV-_&FV;'S!!O;'S;:j!&Q;:j;=`4s<%l?&r-_?&r?Ah!!O?Ah?BY$q?BY?Mn!!O?MnO$q!a!&TP;=`<%l!!O!V!&achS!a`!cpOq*Vqr!'lrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a!b!Ey!b#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!'uhhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex}1n}!O!)a!O!P1n!P!Q*V!Q!_1n!_!a*V!a!f1n!f!g!,]!g#W1n#W#X!<y#X#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!)jdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex}1n}!O!*x!O!P1n!P!Q*V!Q!_1n!_!a*V!a#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!+TbhS!a`!cp!dPOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!,fdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a!q1n!q!r!-t!r#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!-}dhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a!e1n!e!f!/]!f#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!/fdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a!v1n!v!w!0t!w#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!0}dhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a!{1n!{!|!2]!|#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!2fdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a!r1n!r!s!3t!s#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!3}dhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a!g1n!g!h!5]!h#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!5fchS!a`!cpOq!6qqr!5]rs!7hsv!5]vw!;`wx!9[x!P!5]!P!Q!6q!Q!_!5]!_!`!6q!`!a!:j!a#s!5]#s$f!6q$f;'S!5];'S;=`!<s<%l?Ah!5]?Ah?BY!6q?BY?Mn!5]?MnO!6q!R!6xY!a`!cpOr!6qrs!7hsv!6qvw!8Swx!9[x!`!6q!`!a!:j!a;'S!6q;'S;=`!;Y<%lO!6qq!7mV!cpOv!7hvx!8Sx!`!7h!`!a!8q!a;'S!7h;'S;=`!9U<%lO!7hP!8VTO!`!8S!`!a!8f!a;'S!8S;'S;=`!8k<%lO!8SP!8kO{PP!8nP;=`<%l!8Sq!8xS!cp{POv(Vx;'S(V;'S;=`(h<%lO(Vq!9XP;=`<%l!7ha!9aX!a`Or!9[rs!8Ssv!9[vw!8Sw!`!9[!`!a!9|!a;'S!9[;'S;=`!:d<%lO!9[a!:TT!a`{POr)esv)ew;'S)e;'S;=`)y<%lO)ea!:gP;=`<%l!9[!R!:sV!a`!cp{POr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!R!;]P;=`<%l!6qT!;ebhSOq!8Sqr!;`rs!8Ssw!;`wx!8Sx!P!;`!P!Q!8S!Q!_!;`!_!`!8S!`!a!8f!a#s!;`#s$f!8S$f;'S!;`;'S;=`!<m<%l?Ah!;`?Ah?BY!8S?BY?Mn!;`?MnO!8ST!<pP;=`<%l!;`!V!<vP;=`<%l!5]!V!=SdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a#c1n#c#d!>b#d#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!>kdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a#V1n#V#W!?y#W#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!@SdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a#h1n#h#i!Ab#i#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!AkdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a#m1n#m#n!By#n#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!CSdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a#d1n#d#e!Db#e#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!DkdhS!a`!cpOq*Vqr1nrs(Vsv1nvw0pwx)ex!P1n!P!Q*V!Q!_1n!_!a*V!a#X1n#X#Y!5]#Y#s1n#s$f*V$f;'S1n;'S;=`3P<%l?Ah1n?Ah?BY*V?BY?Mn1n?MnO*V!V!FSchS!a`!cpOq!G_qr!Eyrs!HUsv!Eyvw!Ncwx!Jvx!P!Ey!P!Q!G_!Q!_!Ey!_!a!G_!a!b##T!b#s!Ey#s$f!G_$f;'S!Ey;'S;=`#$i<%l?Ah!Ey?Ah?BY!G_?BY?Mn!Ey?MnO!G_!R!GfY!a`!cpOr!G_rs!HUsv!G_vw!Hpwx!Jvx!a!G_!a!b!Lv!b;'S!G_;'S;=`!N]<%lO!G_q!HZV!cpOv!HUvx!Hpx!a!HU!a!b!Iq!b;'S!HU;'S;=`!Jp<%lO!HUP!HsTO!a!Hp!a!b!IS!b;'S!Hp;'S;=`!Ik<%lO!HpP!IVTO!`!Hp!`!a!If!a;'S!Hp;'S;=`!Ik<%lO!HpP!IkOxPP!InP;=`<%l!Hpq!IvV!cpOv!HUvx!Hpx!`!HU!`!a!J]!a;'S!HU;'S;=`!Jp<%lO!HUq!JdS!cpxPOv(Vx;'S(V;'S;=`(h<%lO(Vq!JsP;=`<%l!HUa!J{X!a`Or!Jvrs!Hpsv!Jvvw!Hpw!a!Jv!a!b!Kh!b;'S!Jv;'S;=`!Lp<%lO!Jva!KmX!a`Or!Jvrs!Hpsv!Jvvw!Hpw!`!Jv!`!a!LY!a;'S!Jv;'S;=`!Lp<%lO!Jva!LaT!a`xPOr)esv)ew;'S)e;'S;=`)y<%lO)ea!LsP;=`<%l!Jv!R!L}Y!a`!cpOr!G_rs!HUsv!G_vw!Hpwx!Jvx!`!G_!`!a!Mm!a;'S!G_;'S;=`!N]<%lO!G_!R!MvV!a`!cpxPOr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!R!N`P;=`<%l!G_T!NhbhSOq!Hpqr!Ncrs!Hpsw!Ncwx!Hpx!P!Nc!P!Q!Hp!Q!_!Nc!_!a!Hp!a!b# p!b#s!Nc#s$f!Hp$f;'S!Nc;'S;=`#!}<%l?Ah!Nc?Ah?BY!Hp?BY?Mn!Nc?MnO!HpT# ubhSOq!Hpqr!Ncrs!Hpsw!Ncwx!Hpx!P!Nc!P!Q!Hp!Q!_!Nc!_!`!Hp!`!a!If!a#s!Nc#s$f!Hp$f;'S!Nc;'S;=`#!}<%l?Ah!Nc?Ah?BY!Hp?BY?Mn!Nc?MnO!HpT##QP;=`<%l!Nc!V##^chS!a`!cpOq!G_qr!Eyrs!HUsv!Eyvw!Ncwx!Jvx!P!Ey!P!Q!G_!Q!_!Ey!_!`!G_!`!a!Mm!a#s!Ey#s$f!G_$f;'S!Ey;'S;=`#$i<%l?Ah!Ey?Ah?BY!G_?BY?Mn!Ey?MnO!G_!V#$lP;=`<%l!Ey!V#$zXiS`P!a`!cpOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X",tokenizers:[scriptTokens,styleTokens,textareaTokens,endTag,tagStart,commentContent$2,0,1,2,3,4,5],topRules:{Document:[0,15]},dialects:{noMatch:0,selfClosing:485},tokenPrec:487});function getAttrs(openTag,input){let attrs=Object.create(null);for(let att of openTag.getChildren(23)){let name=att.getChild(24),value=att.getChild(26)||att.getChild(27);name&&(attrs[input.read(name.from,name.to)]=value?26==value.type.id?input.read(value.from+1,value.to-1):input.read(value.from,value.to):"")}return attrs}function findTagName(openTag,input){let tagNameNode=openTag.getChild(22);return tagNameNode?input.read(tagNameNode.from,tagNameNode.to):" "}function maybeNest(node,input,tags){let attrs;for(let tag of tags)if(!tag.attrs||tag.attrs(attrs||(attrs=getAttrs(node.node.parent.firstChild,input))))return{parser:tag.parser};return null}function configureNesting(){let tags=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],attributes=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],script=[],style=[],textarea=[],other=[];for(let tag of tags){("script"==tag.tag?script:"style"==tag.tag?style:"textarea"==tag.tag?textarea:other).push(tag)}let attrs=attributes.length?Object.create(null):null;for(let attr of attributes)(attrs[attr.name]||(attrs[attr.name]=[])).push(attr);return parseMixed(((node,input)=>{let id=node.type.id;if(28==id)return maybeNest(node,input,script);if(31==id)return maybeNest(node,input,style);if(34==id)return maybeNest(node,input,textarea);if(20==id&&other.length){let attrs,n=node.node,open=n.firstChild,tagName=open&&findTagName(open,input);if(tagName)for(let tag of other)if(tag.tag==tagName&&(!tag.attrs||tag.attrs(attrs||(attrs=getAttrs(n,input))))){let close=n.lastChild;return{parser:tag.parser,overlay:[{from:open.to,to:37==close.type.id?close.from:n.to}]}}}if(attrs&&23==id){let nameNode,n=node.node;if(nameNode=n.firstChild){let matches=attrs[input.read(nameNode.from,nameNode.to)];if(matches)for(let attr of matches){if(attr.tagName&&attr.tagName!=findTagName(n.parent,input))continue;let value=n.lastChild;if(26==value.type.id){let from=value.from+1,last=value.lastChild,to=value.to-(last&&last.isError?0:1);if(to>from)return{parser:attr.parser,overlay:[{from:from,to:to}]}}else if(27==value.type.id)return{parser:attr.parser,overlay:[{from:value.from,to:value.to}]}}}}return null}))}const space$1=[9,10,11,12,13,32,133,160,5760,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8232,8233,8239,8287,12288];function isAlpha(ch){return ch>=65&&ch<=90||ch>=97&&ch<=122||ch>=161}const identifiers=new ExternalTokenizer(((input,stack)=>{for(let inside=!1,dashes=0,i=0;;i++){let{next:next}=input;if(!(isAlpha(next)||45==next||95==next||inside&&(ch=next,ch>=48&&ch<=57))){inside&&input.acceptToken(40==next?96:2==dashes&&stack.canShift(2)?2:97);break}!inside&&(45!=next||i>0)&&(inside=!0),dashes===i&&45==next&&dashes++,input.advance()}var ch})),descendant=new ExternalTokenizer((input=>{if(space$1.includes(input.peek(-1))){let{next:next}=input;(isAlpha(next)||95==next||35==next||46==next||91==next||58==next||45==next)&&input.acceptToken(95)}})),unitToken=new ExternalTokenizer((input=>{if(!space$1.includes(input.peek(-1))){let{next:next}=input;if(37==next&&(input.advance(),input.acceptToken(1)),isAlpha(next)){do{input.advance()}while(isAlpha(input.next));input.acceptToken(1)}}})),cssHighlighting=styleTags({"AtKeyword import charset namespace keyframes media supports":tags$1.definitionKeyword,"from to selector":tags$1.keyword,NamespaceName:tags$1.namespace,KeyframeName:tags$1.labelName,KeyframeRangeName:tags$1.operatorKeyword,TagName:tags$1.tagName,ClassName:tags$1.className,PseudoClassName:tags$1.constant(tags$1.className),IdName:tags$1.labelName,"FeatureName PropertyName":tags$1.propertyName,AttributeName:tags$1.attributeName,NumberLiteral:tags$1.number,KeywordQuery:tags$1.keyword,UnaryQueryOp:tags$1.operatorKeyword,"CallTag ValueName":tags$1.atom,VariableName:tags$1.variableName,Callee:tags$1.operatorKeyword,Unit:tags$1.unit,"UniversalSelector NestingSelector":tags$1.definitionOperator,MatchOp:tags$1.compareOperator,"ChildOp SiblingOp, LogicOp":tags$1.logicOperator,BinOp:tags$1.arithmeticOperator,Important:tags$1.modifier,Comment:tags$1.blockComment,ColorLiteral:tags$1.color,"ParenthesizedContent StringLiteral":tags$1.string,":":tags$1.punctuation,"PseudoOp #":tags$1.derefOperator,"; ,":tags$1.separator,"( )":tags$1.paren,"[ ]":tags$1.squareBracket,"{ }":tags$1.brace}),spec_callee={__proto__:null,lang:32,"nth-child":32,"nth-last-child":32,"nth-of-type":32,"nth-last-of-type":32,dir:32,"host-context":32,url:60,"url-prefix":60,domain:60,regexp:60,selector:134},spec_AtKeyword={__proto__:null,"@import":114,"@media":138,"@charset":142,"@namespace":146,"@keyframes":152,"@supports":164},spec_identifier$1={__proto__:null,not:128,only:128},parser$2=LRParser.deserialize({version:14,states:"8`QYQ[OOO#_Q[OOOOQP'#Cd'#CdOOQP'#Cc'#CcO#fQ[O'#CfO$YQXO'#CaO$aQ[O'#ChO$lQ[O'#DPO$qQ[O'#DTOOQP'#Ee'#EeO$vQdO'#DeO%bQ[O'#DrO$vQdO'#DtO%sQ[O'#DvO&OQ[O'#DyO&WQ[O'#EPO&fQ[O'#EROOQS'#Ed'#EdOOQS'#ET'#ETQYQ[OOO&mQXO'#CdO'bQWO'#DaO'gQWO'#EkO'rQ[O'#EkQOQWOOOOQP'#Cg'#CgOOQP,59Q,59QO#fQ[O,59QO'|Q[O'#EWO(hQWO,58{O(pQ[O,59SO$lQ[O,59kO$qQ[O,59oO'|Q[O,59sO'|Q[O,59uO'|Q[O,59vO({Q[O'#D`OOQS,58{,58{OOQP'#Ck'#CkOOQO'#C}'#C}OOQP,59S,59SO)SQWO,59SO)XQWO,59SOOQP'#DR'#DROOQP,59k,59kOOQO'#DV'#DVO)^Q`O,59oOOQS'#Cp'#CpO$vQdO'#CqO)fQvO'#CsO*sQtO,5:POOQO'#Cx'#CxO)XQWO'#CwO+XQWO'#CyOOQS'#Eh'#EhOOQO'#Dh'#DhO+^Q[O'#DoO+lQWO'#ElO&WQ[O'#DmO+zQWO'#DpOOQO'#Em'#EmO(kQWO,5:^O,PQpO,5:`OOQS'#Dx'#DxO,XQWO,5:bO,^Q[O,5:bOOQO'#D{'#D{O,fQWO,5:eO,kQWO,5:kO,sQWO,5:mOOQS-E8R-E8RO$vQdO,59{O,{Q[O'#EYO-YQWO,5;VO-YQWO,5;VOOQP1G.l1G.lO.PQXO,5:rOOQO-E8U-E8UOOQS1G.g1G.gOOQP1G.n1G.nO)SQWO1G.nO)XQWO1G.nOOQP1G/V1G/VO.^Q`O1G/ZO.wQXO1G/_O/_QXO1G/aO/uQXO1G/bO0]QWO,59zO0bQ[O'#DOO0iQdO'#CoOOQP1G/Z1G/ZO$vQdO1G/ZO0pQpO,59]OOQS,59_,59_O$vQdO,59aO0xQWO1G/kOOQS,59c,59cO0}Q!bO,59eO1VQWO'#DhO1bQWO,5:TO1gQWO,5:ZO&WQ[O,5:VO&WQ[O'#EZO1oQWO,5;WO1zQWO,5:XO'|Q[O,5:[OOQS1G/x1G/xOOQS1G/z1G/zOOQS1G/|1G/|O2]QWO1G/|O2bQdO'#D|OOQS1G0P1G0POOQS1G0V1G0VOOQS1G0X1G0XO2mQtO1G/gOOQO,5:t,5:tO3TQ[O,5:tOOQO-E8W-E8WO3bQWO1G0qOOQP7+$Y7+$YOOQP7+$u7+$uO$vQdO7+$uOOQS1G/f1G/fO3mQXO'#EjO3tQWO,59jO3yQtO'#EUO4nQdO'#EgO4xQWO,59ZO4}QpO7+$uOOQS1G.w1G.wOOQS1G.{1G.{OOQS7+%V7+%VO5VQWO1G/PO$vQdO1G/oOOQO1G/u1G/uOOQO1G/q1G/qO5[QWO,5:uOOQO-E8X-E8XO5jQXO1G/vOOQS7+%h7+%hO5qQYO'#CsOOQO'#EO'#EOO5|Q`O'#D}OOQO'#D}'#D}O6XQWO'#E[O6aQdO,5:hOOQS,5:h,5:hO6lQtO'#EXO$vQdO'#EXO7jQdO7+%ROOQO7+%R7+%ROOQO1G0`1G0`O7}QpO<<HaO8VQWO,5;UOOQP1G/U1G/UOOQS-E8S-E8SO$vQdO'#EVO8_QWO,5;ROOQT1G.u1G.uOOQP<<Ha<<HaOOQS7+$k7+$kO8gQdO7+%ZOOQO7+%b7+%bOOQO,5:i,5:iO2eQdO'#E]O6XQWO,5:vOOQS,5:v,5:vOOQS-E8Y-E8YOOQS1G0S1G0SO8nQtO,5:sOOQS-E8V-E8VOOQO<<Hm<<HmOOQPAN={AN={O9lQdO,5:qOOQO-E8T-E8TOOQO<<Hu<<HuOOQO,5:w,5:wOOQO-E8Z-E8ZOOQS1G0b1G0b",stateData:":O~O#VOSROS~OUXOXXO]UO^UOtVOxWO!Y`O!ZYO!gZO!i[O!k]O!n^O!t_O#TQO#YSO~OQeOUXOXXO]UO^UOtVOxWO!Y`O!ZYO!gZO!i[O!k]O!n^O!t_O#TdO#YSO~O#Q#_P~P!ZO#TiO~O]nO^nOplOtoOxpO|qO!PsO#RrO#YkO~O!RtO~P#kO`zO#SwO#TvO~O#T{O~O#T}O~OQ!WOb!QOf!WOh!WOn!VO#S!TO#T!PO#]!RO~Ob!YO!b![O!e!]O#T!XO!R#`P~Oh!bOn!VO#T!aO~Oh!dO#T!dO~Ob!YO!b![O!e!]O#T!XO~O!W#`P~P%bO]WX]!UX^WXpWXtWXxWX|WX!PWX!RWX#RWX#YWX~O]!iO~O!W!jO#Q#_X!Q#_X~O#Q#_X!Q#_X~P!ZOUXOXXO]UO^UOtVOxWO#TQO#YSO~OplO!RtO~O`!sO#SwO#TvO~O!Q#_P~P!ZOb!zO~Ob!{O~Ov!|Oz!}O~OP#PObgXjgX!WgX!bgX!egX#TgXagXQgXfgXhgXngXpgX!VgX#QgX#SgX#]gXvgX!QgX~Ob!YOj#QO!b![O!e!]O#T!XO!W#`P~Ob#TO~Ob!YO!b![O!e!]O#T#UO~Op#YO!`#XO!R#`X!W#`X~Ob#]O~Oj#QO!W#_O~O!W#`O~Oh#aOn!VO~O!R#bO~O!RtO!`#XO~O!RtO!W#eO~O!W!|X#Q!|X!Q!|X~P!ZO!W!jO#Q#_a!Q#_a~O]nO^nOtoOxpO|qO!PsO#RrO#YkO~Op!za!R!zaa!za~P-eOv#lOz#mO~O]nO^nOtoOxpO#YkO~Op{i|{i!P{i!R{i#R{ia{i~P.fOp}i|}i!P}i!R}i#R}ia}i~P.fOp!Oi|!Oi!P!Oi!R!Oi#R!Oia!Oi~P.fO!Q#nO~Oa#^P~P'|Oa#ZP~P$vOa#uOj#QO~O!W#wO~Oh#xOo#xO~O]!^Xa![X!`![X~O]#yO~Oa#zO!`#XO~Op#YO!R#`a!W#`a~O!`#XOp!aa!R!aa!W!aaa!aa~O!W$PO~O!Q$WO#T$RO#]$QO~Oj#QOp$YO!V$[O!W!Ti#Q!Ti!Q!Ti~P$vO!W!|a#Q!|a!Q!|a~P!ZO!W!jO#Q#_i!Q#_i~Oa#^X~P#kOa$`O~Oj#QOQ!xXa!xXb!xXf!xXh!xXn!xXp!xX#S!xX#T!xX#]!xX~Op$bOa#ZX~P$vOa$dO~Oj#QOv$eO~Oa$fO~O!`#XOp!}a!R!}a!W!}a~Oa$hO~P-eOP#POpgX!RgX~O#]$QOp!qX!R!qX~Op$jO!RtO~O!Q$nO#T$RO#]$QO~Oj#QOQ!{Xb!{Xf!{Xh!{Xn!{Xp!{X!V!{X!W!{X#Q!{X#S!{X#T!{X#]!{X!Q!{X~Op$YO!V$qO!W!Tq#Q!Tq!Q!Tq~P$vOj#QOv$rO~OplOa#^a~Op$bOa#Za~Oa$uO~P$vOj#QOQ!{ab!{af!{ah!{an!{ap!{a!V!{a!W!{a#Q!{a#S!{a#T!{a#]!{a!Q!{a~Oa!yap!ya~P$vO#VoR#]j!Pj~",goto:",z#bPPPPP#cP#l#{P#l$[#lPP$bPPP$h$q$qP%TP$qP$q%o&RPPP&k&q#lP&wP#lP&}P#lP#l#lPPP'T'j'wPP#cPP(O(O(Y(OP(OP(O(OP#cP#cP#cP(]#cP(`(c(f(m#cP#cP(r)R)a)g)q)w*R*X*_PPPPPP*e*nP+Z+^P,S,V,],f_aOPcgt!j#hkXOPcglqrst!j!z#]#hkROPcglqrst!j!z#]#hQjSR!mkQxUR!qnQ!qzQ#S!UR#k!sq!WY[!Q!i!{!}#Q#f#m#r#y$Y$Z$b$g$sp!WY[!Q!i!{!}#Q#f#m#r#y$Y$Z$b$g$sU$T#b$V$jR$i$Sq!UY[!Q!i!{!}#Q#f#m#r#y$Y$Z$b$g$sp!WY[!Q!i!{!}#Q#f#m#r#y$Y$Z$b$g$sQ!b]R#a!cQyUR!rnQ!qyR#k!rQ|VR!toQ!OWR!upQuTQ!pmQ#^!_Q#d!fQ#e!gQ$l$UR$x$kSfPtQ!lgQ#g!jR$]#hZePgt!j#ha!^Z_`!S!Y![#X#YR#V!YR!c]R!e^R#c!eS$U#b$VR$v$jV$S#b$V$jQcOSgPtU!hcg#hR#h!jQ#r!{U$a#r$g$sQ$g#yR$s$bQ$c#rR$t$cQmTS!om$_R$_#oQ$Z#fR$p$ZQ!kfS#i!k#jR#j!lQ#Z!ZR#}#ZQ$V#bR$m$VQ$k$UR$w$k_bOPcgt!j#h^TOPcgt!j#hQ!nlQ!vqQ!wrQ!xsQ#o!zR$O#]R#s!{Q!SYQ!`[Q#O!QQ#f!i[#q!{#r#y$b$g$sQ#t!}Q#v#QS$X#f$ZQ$^#mR$o$YR#p!zQhPR!ytQ!_ZQ!g`R#R!SU!ZZ`!SQ!f_Q#W!YQ#[![Q#{#XR#|#Y",nodeNames:"⚠ Unit VariableName Comment StyleSheet RuleSet UniversalSelector TagSelector TagName NestingSelector ClassSelector ClassName PseudoClassSelector : :: PseudoClassName PseudoClassName ) ( ArgList ValueName ParenthesizedValue ColorLiteral NumberLiteral StringLiteral BinaryExpression BinOp CallExpression Callee CallLiteral CallTag ParenthesizedContent , PseudoClassName ArgList IdSelector # IdName ] AttributeSelector [ AttributeName MatchOp ChildSelector ChildOp DescendantSelector SiblingSelector SiblingOp } { Block Declaration PropertyName Important ; ImportStatement AtKeyword import KeywordQuery FeatureQuery FeatureName BinaryQuery LogicOp UnaryQuery UnaryQueryOp ParenthesizedQuery SelectorQuery selector MediaStatement media CharsetStatement charset NamespaceStatement namespace NamespaceName KeyframesStatement keyframes KeyframeName KeyframeList KeyframeSelector KeyframeRangeName SupportsStatement supports AtRule Styles",maxTerm:109,nodeProps:[["openedBy",17,"(",48,"{"],["closedBy",18,")",49,"}"]],propSources:[cssHighlighting],skippedNodes:[0,3],repeatNodeCount:9,tokenData:"Lq~R!^OX$}X^%u^p$}pq%uqr)Xrs.Rst/utu6duv$}vw7^wx7oxy9^yz9oz{9t{|:_|}?Q}!O?c!O!P@Q!P!Q@i!Q![Cu![!]Dp!]!^El!^!_$}!_!`E}!`!aF`!a!b$}!b!cG[!c!}$}!}#OHt#O#P$}#P#QIV#Q#R6d#R#T$}#T#UIh#U#c$}#c#dJy#d#o$}#o#pK`#p#q6d#q#rKq#r#sLS#s#y$}#y#z%u#z$f$}$f$g%u$g#BY$}#BY#BZ%u#BZ$IS$}$IS$I_%u$I_$I|$}$I|$JO%u$JO$JT$}$JT$JU%u$JU$KV$}$KV$KW%u$KW&FU$}&FU&FV%u&FV;'S$};'S;=`Lk<%lO$}W%QSOy%^z;'S%^;'S;=`%o<%lO%^W%cSoWOy%^z;'S%^;'S;=`%o<%lO%^W%rP;=`<%l%^~%zh#V~OX%^X^'f^p%^pq'fqy%^z#y%^#y#z'f#z$f%^$f$g'f$g#BY%^#BY#BZ'f#BZ$IS%^$IS$I_'f$I_$I|%^$I|$JO'f$JO$JT%^$JT$JU'f$JU$KV%^$KV$KW'f$KW&FU%^&FU&FV'f&FV;'S%^;'S;=`%o<%lO%^~'mh#V~oWOX%^X^'f^p%^pq'fqy%^z#y%^#y#z'f#z$f%^$f$g'f$g#BY%^#BY#BZ'f#BZ$IS%^$IS$I_'f$I_$I|%^$I|$JO'f$JO$JT%^$JT$JU'f$JU$KV%^$KV$KW'f$KW&FU%^&FU&FV'f&FV;'S%^;'S;=`%o<%lO%^^)[UOy%^z#]%^#]#^)n#^;'S%^;'S;=`%o<%lO%^^)sUoWOy%^z#a%^#a#b*V#b;'S%^;'S;=`%o<%lO%^^*[UoWOy%^z#d%^#d#e*n#e;'S%^;'S;=`%o<%lO%^^*sUoWOy%^z#c%^#c#d+V#d;'S%^;'S;=`%o<%lO%^^+[UoWOy%^z#f%^#f#g+n#g;'S%^;'S;=`%o<%lO%^^+sUoWOy%^z#h%^#h#i,V#i;'S%^;'S;=`%o<%lO%^^,[UoWOy%^z#T%^#T#U,n#U;'S%^;'S;=`%o<%lO%^^,sUoWOy%^z#b%^#b#c-V#c;'S%^;'S;=`%o<%lO%^^-[UoWOy%^z#h%^#h#i-n#i;'S%^;'S;=`%o<%lO%^^-uS!VUoWOy%^z;'S%^;'S;=`%o<%lO%^~.UWOY.RZr.Rrs.ns#O.R#O#P.s#P;'S.R;'S;=`/o<%lO.R~.sOh~~.vRO;'S.R;'S;=`/P;=`O.R~/SXOY.RZr.Rrs.ns#O.R#O#P.s#P;'S.R;'S;=`/o;=`<%l.R<%lO.R~/rP;=`<%l.R_/zYtPOy%^z!Q%^!Q![0j![!c%^!c!i0j!i#T%^#T#Z0j#Z;'S%^;'S;=`%o<%lO%^^0oYoWOy%^z!Q%^!Q![1_![!c%^!c!i1_!i#T%^#T#Z1_#Z;'S%^;'S;=`%o<%lO%^^1dYoWOy%^z!Q%^!Q![2S![!c%^!c!i2S!i#T%^#T#Z2S#Z;'S%^;'S;=`%o<%lO%^^2ZYfUoWOy%^z!Q%^!Q![2y![!c%^!c!i2y!i#T%^#T#Z2y#Z;'S%^;'S;=`%o<%lO%^^3QYfUoWOy%^z!Q%^!Q![3p![!c%^!c!i3p!i#T%^#T#Z3p#Z;'S%^;'S;=`%o<%lO%^^3uYoWOy%^z!Q%^!Q![4e![!c%^!c!i4e!i#T%^#T#Z4e#Z;'S%^;'S;=`%o<%lO%^^4lYfUoWOy%^z!Q%^!Q![5[![!c%^!c!i5[!i#T%^#T#Z5[#Z;'S%^;'S;=`%o<%lO%^^5aYoWOy%^z!Q%^!Q![6P![!c%^!c!i6P!i#T%^#T#Z6P#Z;'S%^;'S;=`%o<%lO%^^6WSfUoWOy%^z;'S%^;'S;=`%o<%lO%^Y6gUOy%^z!_%^!_!`6y!`;'S%^;'S;=`%o<%lO%^Y7QSzQoWOy%^z;'S%^;'S;=`%o<%lO%^X7cSXPOy%^z;'S%^;'S;=`%o<%lO%^~7rWOY7oZw7owx.nx#O7o#O#P8[#P;'S7o;'S;=`9W<%lO7o~8_RO;'S7o;'S;=`8h;=`O7o~8kXOY7oZw7owx.nx#O7o#O#P8[#P;'S7o;'S;=`9W;=`<%l7o<%lO7o~9ZP;=`<%l7o_9cSbVOy%^z;'S%^;'S;=`%o<%lO%^~9tOa~_9{UUPjSOy%^z!_%^!_!`6y!`;'S%^;'S;=`%o<%lO%^_:fWjS!PPOy%^z!O%^!O!P;O!P!Q%^!Q![>T![;'S%^;'S;=`%o<%lO%^^;TUoWOy%^z!Q%^!Q![;g![;'S%^;'S;=`%o<%lO%^^;nYoW#]UOy%^z!Q%^!Q![;g![!g%^!g!h<^!h#X%^#X#Y<^#Y;'S%^;'S;=`%o<%lO%^^<cYoWOy%^z{%^{|=R|}%^}!O=R!O!Q%^!Q![=j![;'S%^;'S;=`%o<%lO%^^=WUoWOy%^z!Q%^!Q![=j![;'S%^;'S;=`%o<%lO%^^=qUoW#]UOy%^z!Q%^!Q![=j![;'S%^;'S;=`%o<%lO%^^>[[oW#]UOy%^z!O%^!O!P;g!P!Q%^!Q![>T![!g%^!g!h<^!h#X%^#X#Y<^#Y;'S%^;'S;=`%o<%lO%^_?VSpVOy%^z;'S%^;'S;=`%o<%lO%^^?hWjSOy%^z!O%^!O!P;O!P!Q%^!Q![>T![;'S%^;'S;=`%o<%lO%^_@VU#YPOy%^z!Q%^!Q![;g![;'S%^;'S;=`%o<%lO%^~@nTjSOy%^z{@}{;'S%^;'S;=`%o<%lO%^~ASUoWOy@}yzAfz{Bm{;'S@};'S;=`Co<%lO@}~AiTOzAfz{Ax{;'SAf;'S;=`Bg<%lOAf~A{VOzAfz{Ax{!PAf!P!QBb!Q;'SAf;'S;=`Bg<%lOAf~BgOR~~BjP;=`<%lAf~BrWoWOy@}yzAfz{Bm{!P@}!P!QC[!Q;'S@};'S;=`Co<%lO@}~CcSoWR~Oy%^z;'S%^;'S;=`%o<%lO%^~CrP;=`<%l@}^Cz[#]UOy%^z!O%^!O!P;g!P!Q%^!Q![>T![!g%^!g!h<^!h#X%^#X#Y<^#Y;'S%^;'S;=`%o<%lO%^XDuU]POy%^z![%^![!]EX!];'S%^;'S;=`%o<%lO%^XE`S^PoWOy%^z;'S%^;'S;=`%o<%lO%^_EqS!WVOy%^z;'S%^;'S;=`%o<%lO%^YFSSzQOy%^z;'S%^;'S;=`%o<%lO%^XFeU|POy%^z!`%^!`!aFw!a;'S%^;'S;=`%o<%lO%^XGOS|PoWOy%^z;'S%^;'S;=`%o<%lO%^XG_WOy%^z!c%^!c!}Gw!}#T%^#T#oGw#o;'S%^;'S;=`%o<%lO%^XHO[!YPoWOy%^z}%^}!OGw!O!Q%^!Q![Gw![!c%^!c!}Gw!}#T%^#T#oGw#o;'S%^;'S;=`%o<%lO%^XHySxPOy%^z;'S%^;'S;=`%o<%lO%^^I[SvUOy%^z;'S%^;'S;=`%o<%lO%^XIkUOy%^z#b%^#b#cI}#c;'S%^;'S;=`%o<%lO%^XJSUoWOy%^z#W%^#W#XJf#X;'S%^;'S;=`%o<%lO%^XJmS!`PoWOy%^z;'S%^;'S;=`%o<%lO%^XJ|UOy%^z#f%^#f#gJf#g;'S%^;'S;=`%o<%lO%^ZKeS!RROy%^z;'S%^;'S;=`%o<%lO%^_KvS!QVOy%^z;'S%^;'S;=`%o<%lO%^ZLXU!PPOy%^z!_%^!_!`6y!`;'S%^;'S;=`%o<%lO%^WLnP;=`<%l$}",tokenizers:[descendant,unitToken,identifiers,0,1,2,3],topRules:{StyleSheet:[0,4],Styles:[1,84]},specialized:[{term:96,get:value=>spec_callee[value]||-1},{term:56,get:value=>spec_AtKeyword[value]||-1},{term:97,get:value=>spec_identifier$1[value]||-1}],tokenPrec:1142});let _properties=null;function properties(){if(!_properties&&"object"==typeof document&&document.body){let{style:style}=document.body,names=[],seen=new Set;for(let prop in style)"cssText"!=prop&&"cssFloat"!=prop&&"string"==typeof style[prop]&&(/[A-Z]/.test(prop)&&(prop=prop.replace(/[A-Z]/g,(ch=>"-"+ch.toLowerCase()))),seen.has(prop)||(names.push(prop),seen.add(prop)));_properties=names.sort().map((name=>({type:"property",label:name})))}return _properties||[]}const pseudoClasses=["active","after","any-link","autofill","backdrop","before","checked","cue","default","defined","disabled","empty","enabled","file-selector-button","first","first-child","first-letter","first-line","first-of-type","focus","focus-visible","focus-within","fullscreen","has","host","host-context","hover","in-range","indeterminate","invalid","is","lang","last-child","last-of-type","left","link","marker","modal","not","nth-child","nth-last-child","nth-last-of-type","nth-of-type","only-child","only-of-type","optional","out-of-range","part","placeholder","placeholder-shown","read-only","read-write","required","right","root","scope","selection","slotted","target","target-text","valid","visited","where"].map((name=>({type:"class",label:name}))),values=["above","absolute","activeborder","additive","activecaption","after-white-space","ahead","alias","all","all-scroll","alphabetic","alternate","always","antialiased","appworkspace","asterisks","attr","auto","auto-flow","avoid","avoid-column","avoid-page","avoid-region","axis-pan","background","backwards","baseline","below","bidi-override","blink","block","block-axis","bold","bolder","border","border-box","both","bottom","break","break-all","break-word","bullets","button","button-bevel","buttonface","buttonhighlight","buttonshadow","buttontext","calc","capitalize","caps-lock-indicator","caption","captiontext","caret","cell","center","checkbox","circle","cjk-decimal","clear","clip","close-quote","col-resize","collapse","color","color-burn","color-dodge","column","column-reverse","compact","condensed","contain","content","contents","content-box","context-menu","continuous","copy","counter","counters","cover","crop","cross","crosshair","currentcolor","cursive","cyclic","darken","dashed","decimal","decimal-leading-zero","default","default-button","dense","destination-atop","destination-in","destination-out","destination-over","difference","disc","discard","disclosure-closed","disclosure-open","document","dot-dash","dot-dot-dash","dotted","double","down","e-resize","ease","ease-in","ease-in-out","ease-out","element","ellipse","ellipsis","embed","end","ethiopic-abegede-gez","ethiopic-halehame-aa-er","ethiopic-halehame-gez","ew-resize","exclusion","expanded","extends","extra-condensed","extra-expanded","fantasy","fast","fill","fill-box","fixed","flat","flex","flex-end","flex-start","footnotes","forwards","from","geometricPrecision","graytext","grid","groove","hand","hard-light","help","hidden","hide","higher","highlight","highlighttext","horizontal","hsl","hsla","hue","icon","ignore","inactiveborder","inactivecaption","inactivecaptiontext","infinite","infobackground","infotext","inherit","initial","inline","inline-axis","inline-block","inline-flex","inline-grid","inline-table","inset","inside","intrinsic","invert","italic","justify","keep-all","landscape","large","larger","left","level","lighter","lighten","line-through","linear","linear-gradient","lines","list-item","listbox","listitem","local","logical","loud","lower","lower-hexadecimal","lower-latin","lower-norwegian","lowercase","ltr","luminosity","manipulation","match","matrix","matrix3d","medium","menu","menutext","message-box","middle","min-intrinsic","mix","monospace","move","multiple","multiple_mask_images","multiply","n-resize","narrower","ne-resize","nesw-resize","no-close-quote","no-drop","no-open-quote","no-repeat","none","normal","not-allowed","nowrap","ns-resize","numbers","numeric","nw-resize","nwse-resize","oblique","opacity","open-quote","optimizeLegibility","optimizeSpeed","outset","outside","outside-shape","overlay","overline","padding","padding-box","painted","page","paused","perspective","pinch-zoom","plus-darker","plus-lighter","pointer","polygon","portrait","pre","pre-line","pre-wrap","preserve-3d","progress","push-button","radial-gradient","radio","read-only","read-write","read-write-plaintext-only","rectangle","region","relative","repeat","repeating-linear-gradient","repeating-radial-gradient","repeat-x","repeat-y","reset","reverse","rgb","rgba","ridge","right","rotate","rotate3d","rotateX","rotateY","rotateZ","round","row","row-resize","row-reverse","rtl","run-in","running","s-resize","sans-serif","saturation","scale","scale3d","scaleX","scaleY","scaleZ","screen","scroll","scrollbar","scroll-position","se-resize","self-start","self-end","semi-condensed","semi-expanded","separate","serif","show","single","skew","skewX","skewY","skip-white-space","slide","slider-horizontal","slider-vertical","sliderthumb-horizontal","sliderthumb-vertical","slow","small","small-caps","small-caption","smaller","soft-light","solid","source-atop","source-in","source-out","source-over","space","space-around","space-between","space-evenly","spell-out","square","start","static","status-bar","stretch","stroke","stroke-box","sub","subpixel-antialiased","svg_masks","super","sw-resize","symbolic","symbols","system-ui","table","table-caption","table-cell","table-column","table-column-group","table-footer-group","table-header-group","table-row","table-row-group","text","text-bottom","text-top","textarea","textfield","thick","thin","threeddarkshadow","threedface","threedhighlight","threedlightshadow","threedshadow","to","top","transform","translate","translate3d","translateX","translateY","translateZ","transparent","ultra-condensed","ultra-expanded","underline","unidirectional-pan","unset","up","upper-latin","uppercase","url","var","vertical","vertical-text","view-box","visible","visibleFill","visiblePainted","visibleStroke","visual","w-resize","wait","wave","wider","window","windowframe","windowtext","words","wrap","wrap-reverse","x-large","x-small","xor","xx-large","xx-small"].map((name=>({type:"keyword",label:name}))).concat(["aliceblue","antiquewhite","aqua","aquamarine","azure","beige","bisque","black","blanchedalmond","blue","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dodgerblue","firebrick","floralwhite","forestgreen","fuchsia","gainsboro","ghostwhite","gold","goldenrod","gray","grey","green","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightsteelblue","lightyellow","lime","limegreen","linen","magenta","maroon","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","navy","oldlace","olive","olivedrab","orange","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","purple","rebeccapurple","red","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","silver","skyblue","slateblue","slategray","snow","springgreen","steelblue","tan","teal","thistle","tomato","turquoise","violet","wheat","white","whitesmoke","yellow","yellowgreen"].map((name=>({type:"constant",label:name})))),tags=["a","abbr","address","article","aside","b","bdi","bdo","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","dd","del","details","dfn","dialog","div","dl","dt","em","figcaption","figure","footer","form","header","hgroup","h1","h2","h3","h4","h5","h6","hr","html","i","iframe","img","input","ins","kbd","label","legend","li","main","meter","nav","ol","output","p","pre","ruby","section","select","small","source","span","strong","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","tr","u","ul"].map((name=>({type:"type",label:name}))),identifier$1=/^(\w[\w-]*|-\w[\w-]*|)$/,variable=/^-(-[\w-]*)?$/;const VariablesByNode=new NodeWeakMap,declSelector=["Declaration"];function astTop(node){for(let cur=node;;){if(cur.type.isTop)return cur;if(!(cur=cur.parent))return node}}function variableNames(doc,node,isVariable){if(node.to-node.from>4096){let known=VariablesByNode.get(node);if(known)return known;let result=[],seen=new Set,cursor=node.cursor(IterMode.IncludeAnonymous);if(cursor.firstChild())do{for(let option of variableNames(doc,cursor.node,isVariable))seen.has(option.label)||(seen.add(option.label),result.push(option))}while(cursor.nextSibling());return VariablesByNode.set(node,result),result}{let result=[],seen=new Set;return node.cursor().iterate((node=>{var _a;if(isVariable(node)&&node.matchContext(declSelector)&&":"==(null===(_a=node.node.nextSibling)||void 0===_a?void 0:_a.name)){let name=doc.sliceString(node.from,node.to);seen.has(name)||(seen.add(name),result.push({label:name,type:"variable"}))}})),result}}const cssCompletionSource=(isVariable=n=>"VariableName"==n.name,context=>{let{state:state,pos:pos}=context,node=syntaxTree(state).resolveInner(pos,-1),isDash=node.type.isError&&node.from==node.to-1&&"-"==state.doc.sliceString(node.from,node.to);if("PropertyName"==node.name||(isDash||"TagName"==node.name)&&/^(Block|Styles)$/.test(node.resolve(node.to).name))return{from:node.from,options:properties(),validFor:identifier$1};if("ValueName"==node.name)return{from:node.from,options:values,validFor:identifier$1};if("PseudoClassName"==node.name)return{from:node.from,options:pseudoClasses,validFor:identifier$1};if(isVariable(node)||(context.explicit||isDash)&&function(node,doc){var _a;if(("("==node.name||node.type.isError)&&(node=node.parent||node),"ArgList"!=node.name)return!1;let callee=null===(_a=node.parent)||void 0===_a?void 0:_a.firstChild;return"Callee"==(null==callee?void 0:callee.name)&&"var"==doc.sliceString(callee.from,callee.to)}(node,state.doc))return{from:isVariable(node)||isDash?node.from:pos,options:variableNames(state.doc,astTop(node),isVariable),validFor:variable};if("TagName"==node.name){for(let{parent:parent}=node;parent;parent=parent.parent)if("Block"==parent.name)return{from:node.from,options:properties(),validFor:identifier$1};return{from:node.from,options:tags,validFor:identifier$1}}if(!context.explicit)return null;let above=node.resolve(pos),before=above.childBefore(pos);return before&&":"==before.name&&"PseudoClassSelector"==above.name?{from:pos,options:pseudoClasses,validFor:identifier$1}:before&&":"==before.name&&"Declaration"==above.name||"ArgList"==above.name?{from:pos,options:values,validFor:identifier$1}:"Block"==above.name||"Styles"==above.name?{from:pos,options:properties(),validFor:identifier$1}:null});var isVariable;const cssLanguage=LRLanguage.define({name:"css",parser:parser$2.configure({props:[indentNodeProp.add({Declaration:continuedIndent()}),foldNodeProp.add({Block:foldInside})]}),languageData:{commentTokens:{block:{open:"/*",close:"*/"}},indentOnInput:/^\s*\}$/,wordChars:"-"}});function css(){return new LanguageSupport(cssLanguage,cssLanguage.data.of({autocomplete:cssCompletionSource}))}const space=[9,10,11,12,13,32,133,160,5760,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8232,8233,8239,8287,12288],trackNewline=new ContextTracker({start:!1,shift:(context,term)=>3==term||4==term||305==term?context:306==term,strict:!1}),insertSemicolon=new ExternalTokenizer(((input,stack)=>{let{next:next}=input;(125==next||-1==next||stack.context)&&stack.canShift(303)&&input.acceptToken(303)}),{contextual:!0,fallback:!0}),noSemicolon=new ExternalTokenizer(((input,stack)=>{let after,{next:next}=input;space.indexOf(next)>-1||(47!=next||47!=(after=input.peek(1))&&42!=after)&&125!=next&&59!=next&&-1!=next&&!stack.context&&stack.canShift(302)&&input.acceptToken(302)}),{contextual:!0}),incdecToken=new ExternalTokenizer(((input,stack)=>{let{next:next}=input;if((43==next||45==next)&&(input.advance(),next==input.next)){input.advance();let mayPostfix=!stack.context&&stack.canShift(1);input.acceptToken(mayPostfix?1:2)}}),{contextual:!0}),jsHighlight=styleTags({"get set async static":tags$1.modifier,"for while do if else switch try catch finally return throw break continue default case":tags$1.controlKeyword,"in of await yield void typeof delete instanceof":tags$1.operatorKeyword,"let var const function class extends":tags$1.definitionKeyword,"import export from":tags$1.moduleKeyword,"with debugger as new":tags$1.keyword,TemplateString:tags$1.special(tags$1.string),super:tags$1.atom,BooleanLiteral:tags$1.bool,this:tags$1.self,null:tags$1.null,Star:tags$1.modifier,VariableName:tags$1.variableName,"CallExpression/VariableName TaggedTemplateExpression/VariableName":tags$1.function(tags$1.variableName),VariableDefinition:tags$1.definition(tags$1.variableName),Label:tags$1.labelName,PropertyName:tags$1.propertyName,PrivatePropertyName:tags$1.special(tags$1.propertyName),"CallExpression/MemberExpression/PropertyName":tags$1.function(tags$1.propertyName),"FunctionDeclaration/VariableDefinition":tags$1.function(tags$1.definition(tags$1.variableName)),"ClassDeclaration/VariableDefinition":tags$1.definition(tags$1.className),PropertyDefinition:tags$1.definition(tags$1.propertyName),PrivatePropertyDefinition:tags$1.definition(tags$1.special(tags$1.propertyName)),UpdateOp:tags$1.updateOperator,LineComment:tags$1.lineComment,BlockComment:tags$1.blockComment,Number:tags$1.number,String:tags$1.string,Escape:tags$1.escape,ArithOp:tags$1.arithmeticOperator,LogicOp:tags$1.logicOperator,BitOp:tags$1.bitwiseOperator,CompareOp:tags$1.compareOperator,RegExp:tags$1.regexp,Equals:tags$1.definitionOperator,Arrow:tags$1.function(tags$1.punctuation),": Spread":tags$1.punctuation,"( )":tags$1.paren,"[ ]":tags$1.squareBracket,"{ }":tags$1.brace,"InterpolationStart InterpolationEnd":tags$1.special(tags$1.brace),".":tags$1.derefOperator,", ;":tags$1.separator,"@":tags$1.meta,TypeName:tags$1.typeName,TypeDefinition:tags$1.definition(tags$1.typeName),"type enum interface implements namespace module declare":tags$1.definitionKeyword,"abstract global Privacy readonly override":tags$1.modifier,"is keyof unique infer":tags$1.operatorKeyword,JSXAttributeValue:tags$1.attributeValue,JSXText:tags$1.content,"JSXStartTag JSXStartCloseTag JSXSelfCloseEndTag JSXEndTag":tags$1.angleBracket,"JSXIdentifier JSXNameSpacedName":tags$1.tagName,"JSXAttribute/JSXIdentifier JSXAttribute/JSXNameSpacedName":tags$1.attributeName,"JSXBuiltin/JSXIdentifier":tags$1.standard(tags$1.tagName)}),spec_identifier={__proto__:null,export:14,as:19,from:27,default:30,async:35,function:36,extends:46,this:50,true:58,false:58,null:70,void:74,typeof:78,super:96,new:130,delete:146,yield:155,await:159,class:164,public:221,private:221,protected:221,readonly:223,instanceof:242,satisfies:245,in:246,const:248,import:280,keyof:335,unique:339,infer:345,is:381,abstract:401,implements:403,type:405,let:408,var:410,interface:417,enum:421,namespace:427,module:429,declare:433,global:437,for:456,of:465,while:468,with:472,do:476,if:480,else:482,switch:486,case:492,try:498,catch:502,finally:506,return:510,throw:514,break:518,continue:522,debugger:526},spec_word={__proto__:null,async:117,get:119,set:121,declare:181,public:183,private:183,protected:183,static:185,abstract:187,override:189,readonly:195,accessor:197,new:385},spec_LessThan={__proto__:null,"<":137},parser$1=LRParser.deserialize({version:14,states:"$6[O`QUOOO%QQUOOO'TQWOOP(bOSOOO*pQ(CjO'#CfO*wOpO'#CgO+VO!bO'#CgO+eO07`O'#DZO-vQUO'#DaO.WQUO'#DlO%QQUO'#DvO0[QUO'#EOOOQ(CY'#EW'#EWO0uQSO'#ETOOQO'#Ei'#EiOOQO'#Ib'#IbO0}QSO'#GkO1YQSO'#EhO1_QSO'#EhO3aQ(CjO'#JcO6QQ(CjO'#JdO6nQSO'#FWO6sQ#tO'#FoOOQ(CY'#F`'#F`O7OO&jO'#F`O7^Q,UO'#FvO8tQSO'#FuOOQ(CY'#Jd'#JdOOQ(CW'#Jc'#JcOOQQ'#KO'#KOO8yQSO'#IOO9OQ(C[O'#IPOOQQ'#JP'#JPOOQQ'#IT'#ITQ`QUOOO%QQUO'#DnO9WQUO'#DzO%QQUO'#D|O9_QSO'#GkO9dQ,UO'#ClO9rQSO'#EgO9}QSO'#ErO:SQ,UO'#F_O:qQSO'#GkO:vQSO'#GoO;RQSO'#GoO;aQSO'#GrO;aQSO'#GsO;aQSO'#GuO9_QSO'#GxO<QQSO'#G{O=cQSO'#CbO=sQSO'#HXO={QSO'#H_O={QSO'#HaO`QUO'#HcO={QSO'#HeO={QSO'#HhO>QQSO'#HnO>VQ(C]O'#HtO%QQUO'#HvO>bQ(C]O'#HxO>mQ(C]O'#HzO9OQ(C[O'#H|O>xQ(CjO'#CfO?zQWO'#DfQOQSOOO@bQSO'#EPO9dQ,UO'#EgO@mQSO'#EgO@xQ`O'#F_OOQQ'#Cd'#CdOOQ(CW'#Dk'#DkOOQ(CW'#Jg'#JgO%QQUO'#JgOOQO'#Jk'#JkOOQO'#I_'#I_OAxQWO'#E`OOQ(CW'#E_'#E_OBtQ(C`O'#E`OCOQWO'#ESOOQO'#Jj'#JjOCdQWO'#JkODqQWO'#ESOCOQWO'#E`PEOO?MpO'#C`POOO)CDn)CDnOOOO'#IU'#IUOEZOpO,59ROOQ(CY,59R,59ROOOO'#IV'#IVOEiO!bO,59RO%QQUO'#D]OOOO'#IX'#IXOEwO07`O,59uOOQ(CY,59u,59uOFVQUO'#IYOFjQSO'#JeOHlQbO'#JeO+sQUO'#JeOHsQSO,59{OIZQSO'#EiOIhQSO'#JsOIsQSO'#JrOIsQSO'#JrOI{QSO,5;VOJQQSO'#JqOOQ(CY,5:W,5:WOJXQUO,5:WOLYQ(CjO,5:bOLyQSO,5:jOMdQ(C[O'#JpOMkQSO'#JoO:vQSO'#JoONPQSO'#JoONXQSO,5;UON^QSO'#JoO!!fQbO'#JdOOQ(CY'#Cf'#CfO%QQUO'#EOO!#UQ`O,5:oOOQO'#Jl'#JlOOQO-E<`-E<`O9_QSO,5=VO!#lQSO,5=VO!#qQUO,5;SO!%tQ,UO'#EdO!'XQSO,5;SO!(qQ,UO'#DpO!(xQUO'#DuO!)SQWO,5;]O!)[QWO,5;]O%QQUO,5;]OOQQ'#FO'#FOOOQQ'#FQ'#FQO%QQUO,5;^O%QQUO,5;^O%QQUO,5;^O%QQUO,5;^O%QQUO,5;^O%QQUO,5;^O%QQUO,5;^O%QQUO,5;^O%QQUO,5;^O%QQUO,5;^O%QQUO,5;^OOQQ'#FU'#FUO!)jQUO,5;oOOQ(CY,5;t,5;tOOQ(CY,5;u,5;uO!+mQSO,5;uOOQ(CY,5;v,5;vO%QQUO'#IfO!+uQ(C[O,5<cO!%tQ,UO,5;^O!,dQ,UO,5;^O%QQUO,5;rO!,kQ#tO'#FeO!-hQ#tO'#JwO!-SQ#tO'#JwO!-oQ#tO'#JwOOQO'#Jw'#JwO!.TQ#tO,5;}OOOO,5<Z,5<ZO!.fQUO'#FqOOOO'#Ie'#IeO7OO&jO,5;zO!.mQ#tO'#FsOOQ(CY,5;z,5;zO!/^Q7[O'#CrOOQ(CY'#Cv'#CvO!/qQSO'#CvO!/vO07`O'#CzO!0dQ,UO,5<`O!0kQSO,5<bO!2QQMhO'#GQO!2_QSO'#GRO!2dQSO'#GRO!2iQMhO'#GVO!3hQWO'#GZO!4ZQ7[O'#J^OOQ(CY'#J^'#J^O!4eQSO'#J]O!4sQSO'#J[O!4{QSO'#CqOOQ(CY'#Ct'#CtOOQ(CY'#DO'#DOOOQ(CY'#DQ'#DQO0xQSO'#DSO!'^Q,UO'#FxO!'^Q,UO'#FzO!5TQSO'#F|O!5YQSO'#F}O!2dQSO'#GTO!'^Q,UO'#GYO!5_QSO'#EjO!5|QSO,5<aO`QUO,5>jOOQQ'#JX'#JXOOQQ,5>k,5>kOOQQ-E<R-E<RO!7{Q(CjO,5:YO!:iQ(CjO,5:fO%QQUO,5:fO!=SQ(CjO,5:hOOQ(CW'#Co'#CoO!=sQ,UO,5=VO!>RQ(C[O'#JYO8tQSO'#JYO!>dQ(C[O,59WO!>oQWO,59WO!>wQ,UO,59WO9dQ,UO,59WO!?SQSO,5;SO!?[QSO'#HWO!?mQSO'#KSO%QQUO,5;wO!?uQWO,5;yO!?zQSO,5=qO!@PQSO,5=qO!@UQSO,5=qO9OQ(C[O,5=qO!@dQSO'#EkO!A^QWO'#ElOOQ(CW'#Jq'#JqO!AeQ(C[O'#KPO9OQ(C[O,5=ZO;aQSO,5=aOOQO'#Cr'#CrO!ApQWO,5=^O!AxQ,UO,5=_O!BTQSO,5=aO!BYQ`O,5=dO>QQSO'#G}O9_QSO'#HPO!BbQSO'#HPO9dQ,UO'#HRO!BgQSO'#HROOQQ,5=g,5=gO!BlQSO'#HSO!BtQSO'#ClO!ByQSO,58|O!CTQSO,58|O!E]QUO,58|OOQQ,58|,58|O!EjQ(C[O,58|O%QQUO,58|O!EuQUO'#HZOOQQ'#H['#H[OOQQ'#H]'#H]O`QUO,5=sO!FVQSO,5=sO`QUO,5=yO`QUO,5={O!F[QSO,5=}O`QUO,5>PO!FaQSO,5>SO!FfQUO,5>YOOQQ,5>`,5>`O%QQUO,5>`O9OQ(C[O,5>bOOQQ,5>d,5>dO!JmQSO,5>dOOQQ,5>f,5>fO!JmQSO,5>fOOQQ,5>h,5>hO!JrQWO'#DXO%QQUO'#JgO!KaQWO'#JgO!LOQWO'#DgO!LaQWO'#DgO!NrQUO'#DgO!NyQSO'#JfO# RQSO,5:QO# WQSO'#EmO# fQSO'#JtO# nQSO,5;WO# sQWO'#DgO#!QQWO'#EROOQ(CY,5:k,5:kO%QQUO,5:kO#!XQSO,5:kO>QQSO,5;RO!>oQWO,5;RO!>wQ,UO,5;RO9dQ,UO,5;RO#!aQSO,5@RO#!fQ!LQO,5:oOOQO-E<]-E<]O##lQ(C`O,5:zOCOQWO,5:nO##vQWO,5:nOCOQWO,5:zO!>dQ(C[O,5:nOOQ(CW'#Ec'#EcOOQO,5:z,5:zO%QQUO,5:zO#$TQ(C[O,5:zO#$`Q(C[O,5:zO!>oQWO,5:nOOQO,5;Q,5;QO#$nQ(C[O,5:zPOOO'#IS'#ISP#%SO?MpO,58zPOOO,58z,58zOOOO-E<S-E<SOOQ(CY1G.m1G.mOOOO-E<T-E<TO#%_Q`O,59wOOOO-E<V-E<VOOQ(CY1G/a1G/aO#%dQbO,5>tO+sQUO,5>tOOQO,5>z,5>zO#%nQUO'#IYOOQO-E<W-E<WO#%{QSO,5@PO#&TQbO,5@PO#&[QSO,5@^OOQ(CY1G/g1G/gO%QQUO,5@_O#&dQSO'#I`OOQO-E<^-E<^O#&[QSO,5@^OOQ(CW1G0q1G0qOOQ(CY1G/r1G/rOOQ(CY1G0U1G0UO%QQUO,5@[O#&xQ(C[O,5@[O#'ZQ(C[O,5@[O#'bQSO,5@ZO:vQSO,5@ZO#'jQSO,5@ZO#'xQSO'#IcO#'bQSO,5@ZOOQ(CW1G0p1G0pO!)SQWO,5:qO!)_QWO,5:qOOQO,5:s,5:sO#(jQSO,5:sO#(rQ,UO1G2qO9_QSO1G2qOOQ(CY1G0n1G0nO#)QQ(CjO1G0nO#*VQ(ChO,5;OOOQ(CY'#GP'#GPO#*sQ(CjO'#J^O!#qQUO1G0nO#,{Q,UO'#JhO#-VQSO,5:[O#-[QbO'#JiO%QQUO'#JiO#-fQSO,5:aOOQ(CY'#DX'#DXOOQ(CY1G0w1G0wO%QQUO1G0wOOQ(CY1G1a1G1aO#-kQSO1G0wO#0SQ(CjO1G0xO#0ZQ(CjO1G0xO#2tQ(CjO1G0xO#2{Q(CjO1G0xO#5VQ(CjO1G0xO#5mQ(CjO1G0xO#8gQ(CjO1G0xO#8nQ(CjO1G0xO#;XQ(CjO1G0xO#;`Q(CjO1G0xO#=WQ(CjO1G0xO#@WQ$IUO'#CfO#BUQ$IUO1G1ZO#B]Q$IUO'#JdO!+pQSO1G1aO#BmQ(CjO,5?QOOQ(CW-E<d-E<dO#CaQ(CjO1G0xOOQ(CY1G0x1G0xO#ElQ(CjO1G1^O#F`Q#tO,5<RO#FhQ#tO,5<SO#FpQ#tO'#FjO#GXQSO'#FiOOQO'#Jx'#JxOOQO'#Id'#IdO#G^Q#tO1G1iOOQ(CY1G1i1G1iOOOO1G1t1G1tO#GoQ$IUO'#JcO#GyQSO,5<]O!)jQUO,5<]OOOO-E<c-E<cOOQ(CY1G1f1G1fO#HOQWO'#JwOOQ(CY,5<_,5<_O#HWQWO,5<_OOQ(CY,59b,59bO!%tQ,UO'#C|OOOO'#IW'#IWO#H]O07`O,59fOOQ(CY,59f,59fO%QQUO1G1zO!5YQSO'#IhO#HhQSO,5<sOOQ(CY,5<p,5<pOOQO'#Gf'#GfO!'^Q,UO,5=POOQO'#Gh'#GhO!'^Q,UO,5=RO!%tQ,UO,5=TOOQO1G1|1G1|O#HvQ`O'#CoO#IZQ`O,5<lO#IbQSO'#J{O9_QSO'#J{O#IpQSO,5<nO!'^Q,UO,5<mO#IuQSO'#GSO#JQQSO,5<mO#JVQ`O'#GPO#JdQ`O'#J|O#JnQSO'#J|O!%tQ,UO'#J|O#JsQSO,5<qO#JxQWO'#G[O!3cQWO'#G[O#KZQSO'#G^O#K`QSO'#G`O!2dQSO'#GcO#KeQ(C[O'#IjO#KpQWO,5<uOOQ(CY,5<u,5<uO#KwQWO'#G[O#LVQWO'#G]O#L_QWO'#G]OOQ(CY,5=U,5=UO!'^Q,UO,5?wO!'^Q,UO,5?wO#LdQSO'#IkO#LoQSO,5?vO#LwQSO,59]O#MhQ,UO,59nOOQ(CY,59n,59nO#NZQ,UO,5<dO#N|Q,UO,5<fO?rQSO,5<hOOQ(CY,5<i,5<iO$ WQSO,5<oO$ ]Q,UO,5<tO$ mQSO'#JoO!#qQUO1G1{O$ rQSO1G1{OOQQ1G4U1G4UOOQ(CY1G/t1G/tO!+mQSO1G/tO$#qQ(CjO1G0QOOQQ1G2q1G2qO!%tQ,UO1G2qO%QQUO1G2qO$$bQSO1G2qO$$mQ,UO'#EdOOQ(CW,5?t,5?tO$$wQ(C[O,5?tOOQQ1G.r1G.rO!>dQ(C[O1G.rO!>oQWO1G.rO!>wQ,UO1G.rO$%YQSO1G0nO$%_QSO'#CfO$%jQSO'#KTO$%rQSO,5=rO$%wQSO'#KTO$%|QSO'#KTO$&XQSO'#IsO$&gQSO,5@nO$&oQbO1G1cOOQ(CY1G1e1G1eO9_QSO1G3]O?rQSO1G3]O$&vQSO1G3]O$&{QSO1G3]OOQQ1G3]1G3]O:vQSO'#JrO:vQSO'#EmO%QQUO'#EmO:vQSO'#ImO$'QQ(C[O,5@kOOQQ1G2u1G2uO!BTQSO1G2{O!%tQ,UO1G2xO$']QSO1G2xOOQQ1G2y1G2yO!%tQ,UO1G2yO$'bQSO1G2yO$'jQWO'#GwOOQQ1G2{1G2{O!3cQWO'#IoO!BYQ`O1G3OOOQQ1G3O1G3OOOQQ,5=i,5=iO$'rQ,UO,5=kO9_QSO,5=kO#K`QSO,5=mO8tQSO,5=mO!>oQWO,5=mO!>wQ,UO,5=mO9dQ,UO,5=mO$(QQSO'#KRO$(]QSO,5=nOOQQ1G.h1G.hO$(bQ(C[O1G.hO?rQSO1G.hO$(mQSO1G.hO9OQ(C[O1G.hO$*rQbO,5@pO$+SQSO,5@pO$+_QUO,5=uO$+fQSO,5=uO:vQSO,5@pOOQQ1G3_1G3_O`QUO1G3_OOQQ1G3e1G3eOOQQ1G3g1G3gO={QSO1G3iO$+kQUO1G3kO$/lQUO'#HjOOQQ1G3n1G3nO$/yQSO'#HpO>QQSO'#HrOOQQ1G3t1G3tO$0RQUO1G3tO9OQ(C[O1G3zOOQQ1G3|1G3|OOQ(CW'#GW'#GWO9OQ(C[O1G4OO9OQ(C[O1G4QO$4VQSO,5@RO!)jQUO,5;XO:vQSO,5;XO>QQSO,5:RO!)jQUO,5:RO!>oQWO,5:RO$4[Q$IUO,5:ROOQO,5;X,5;XO$4fQWO'#IZO$4|QSO,5@QOOQ(CY1G/l1G/lO$5UQWO'#IaO$5`QSO,5@`OOQ(CW1G0r1G0rO!LaQWO,5:ROOQO'#I^'#I^O$5hQWO,5:mOOQ(CY,5:m,5:mO#![QSO1G0VOOQ(CY1G0V1G0VO%QQUO1G0VOOQ(CY1G0m1G0mO>QQSO1G0mO!>oQWO1G0mO!>wQ,UO1G0mOOQ(CW1G5m1G5mO!>dQ(C[O1G0YOOQO1G0f1G0fO%QQUO1G0fO$5oQ(C[O1G0fO$5zQ(C[O1G0fO!>oQWO1G0YOCOQWO1G0YO$6YQ(C[O1G0fOOQO1G0Y1G0YO$6nQ(CjO1G0fPOOO-E<Q-E<QPOOO1G.f1G.fOOOO1G/c1G/cO$6xQ`O,5<cO$7QQbO1G4`OOQO1G4f1G4fO%QQUO,5>tO$7[QSO1G5kO$7dQSO1G5xO$7lQbO1G5yO:vQSO,5>zO$7vQ(CjO1G5vO%QQUO1G5vO$8WQ(C[O1G5vO$8iQSO1G5uO$8iQSO1G5uO:vQSO1G5uO$8qQSO,5>}O:vQSO,5>}OOQO,5>},5>}O$9VQSO,5>}O$ mQSO,5>}OOQO-E<a-E<aOOQO1G0]1G0]OOQO1G0_1G0_O!+pQSO1G0_OOQQ7+(]7+(]O!%tQ,UO7+(]O%QQUO7+(]O$9eQSO7+(]O$9pQ,UO7+(]O$:OQ(CjO,59nO$<WQ(CjO,5<dO$>cQ(CjO,5<fO$@nQ(CjO,5<tOOQ(CY7+&Y7+&YO$CPQ(CjO7+&YO$CsQ,UO'#I[O$C}QSO,5@SOOQ(CY1G/v1G/vO$DVQUO'#I]O$DdQSO,5@TO$DlQbO,5@TOOQ(CY1G/{1G/{O$DvQSO7+&cOOQ(CY7+&c7+&cO$D{Q$IUO,5:bO%QQUO7+&uO$EVQ$IUO,5:YO$EdQ$IUO,5:fO$EnQ$IUO,5:hOOQ(CY7+&{7+&{OOQO1G1m1G1mOOQO1G1n1G1nO$ExQ#tO,5<UO!)jQUO,5<TOOQO-E<b-E<bOOQ(CY7+'T7+'TOOOO7+'`7+'`OOOO1G1w1G1wO$FTQSO1G1wOOQ(CY1G1y1G1yO$FYQ`O,59hOOOO-E<U-E<UOOQ(CY1G/Q1G/QO$FaQ(CjO7+'fOOQ(CY,5?S,5?SO$GTQSO,5?SOOQ(CY1G2_1G2_P$GYQSO'#IhPOQ(CY-E<f-E<fO$G|Q,UO1G2kO$HoQ,UO1G2mO$HyQ`O1G2oOOQ(CY1G2W1G2WO$IQQSO'#IgO$I`QSO,5@gO$I`QSO,5@gO$IhQSO,5@gO$IsQSO,5@gOOQO1G2Y1G2YO$JRQ,UO1G2XO!'^Q,UO1G2XO$JcQMhO'#IiO$JsQSO,5@hO!%tQ,UO,5@hO$J{Q`O,5@hOOQ(CY1G2]1G2]OOQ(CW,5<v,5<vOOQ(CW,5<w,5<wO$ mQSO,5<wOBoQSO,5<wO!>oQWO,5<vOOQO'#G_'#G_O$KVQSO,5<xOOQ(CW,5<z,5<zO$ mQSO,5<}OOQO,5?U,5?UOOQO-E<h-E<hOOQ(CY1G2a1G2aO!3cQWO,5<vO$K_QSO,5<wO#KZQSO,5<xO!3cQWO,5<wO$KjQ,UO1G5cO$KtQ,UO1G5cOOQO,5?V,5?VOOQO-E<i-E<iOOQO1G.w1G.wO!?uQWO,59pO%QQUO,59pO$LRQSO1G2SO!'^Q,UO1G2ZO$LWQ(CjO7+'gOOQ(CY7+'g7+'gO!#qQUO7+'gOOQ(CY7+%`7+%`O$LzQ`O'#J}O#![QSO7+(]O$MUQbO7+(]O$9hQSO7+(]O$M]Q(ChO'#CfO$MpQ(ChO,5<{O$NbQSO,5<{OOQ(CW1G5`1G5`OOQQ7+$^7+$^O!>dQ(C[O7+$^O!>oQWO7+$^O!#qQUO7+&YO$NgQSO'#IrO$N{QSO,5@oOOQO1G3^1G3^O9_QSO,5@oO$N{QSO,5@oO% TQSO,5@oOOQO,5?_,5?_OOQO-E<q-E<qOOQ(CY7+&}7+&}O% YQSO7+(wO9OQ(C[O7+(wO9_QSO7+(wO?rQSO7+(wO% _QSO,5;XOOQ(CW,5?X,5?XOOQ(CW-E<k-E<kOOQQ7+(g7+(gO% dQ(ChO7+(dO!%tQ,UO7+(dO% nQ`O7+(eOOQQ7+(e7+(eO!%tQ,UO7+(eO% uQSO'#KQO%!QQSO,5=cOOQO,5?Z,5?ZOOQO-E<m-E<mOOQQ7+(j7+(jO%#aQWO'#HQOOQQ1G3V1G3VO!%tQ,UO1G3VO%QQUO1G3VO%#hQSO1G3VO%#sQ,UO1G3VO9OQ(C[O1G3XO#K`QSO1G3XO8tQSO1G3XO!>oQWO1G3XO!>wQ,UO1G3XO%$RQSO'#IqO%$^QSO,5@mO%$fQWO,5@mOOQ(CW1G3Y1G3YOOQQ7+$S7+$SO?rQSO7+$SO9OQ(C[O7+$SO%$qQSO7+$SO%QQUO1G6[O%QQUO1G6]O%$vQUO1G3aO%$}QSO1G3aO%%SQUO1G3aO%%ZQ(C[O1G6[OOQQ7+(y7+(yO9OQ(C[O7+)TO`QUO7+)VOOQQ'#KW'#KWOOQQ'#It'#ItO%%eQUO,5>UOOQQ,5>U,5>UO%QQUO'#HkO%%rQSO'#HmOOQQ,5>[,5>[O:vQSO,5>[OOQQ,5>^,5>^OOQQ7+)`7+)`OOQQ7+)f7+)fOOQQ7+)j7+)jOOQQ7+)l7+)lO%%wQWO1G5mO%&]Q$IUO1G0sO%&gQSO1G0sOOQO1G/m1G/mO%&rQ$IUO1G/mO>QQSO1G/mO!)jQUO'#DgOOQO,5>u,5>uOOQO-E<X-E<XOOQO,5>{,5>{OOQO-E<_-E<_O!>oQWO1G/mOOQO-E<[-E<[OOQ(CY1G0X1G0XOOQ(CY7+%q7+%qO#![QSO7+%qOOQ(CY7+&X7+&XO>QQSO7+&XO!>oQWO7+&XOOQO7+%t7+%tO$6nQ(CjO7+&QOOQO7+&Q7+&QO%QQUO7+&QO%&|Q(C[O7+&QO!>dQ(C[O7+%tO!>oQWO7+%tO%'XQ(C[O7+&QO%'gQ(CjO7++bO%QQUO7++bO%'wQSO7++aO%'wQSO7++aOOQO1G4i1G4iO:vQSO1G4iO%(PQSO1G4iOOQO7+%y7+%yO#![QSO<<KwO$MUQbO<<KwO%(_QSO<<KwOOQQ<<Kw<<KwO!%tQ,UO<<KwO%QQUO<<KwO%(gQSO<<KwO%(rQ(CjO1G2kO%*}Q(CjO1G2mO%-YQ(CjO1G2XO%/kQ,UO,5>vOOQO-E<Y-E<YO%/uQbO,5>wO%QQUO,5>wOOQO-E<Z-E<ZO%0PQSO1G5oOOQ(CY<<I}<<I}O%0XQ$IUO1G0nO%2cQ$IUO1G0xO%2jQ$IUO1G0xO%4nQ$IUO1G0xO%4uQ$IUO1G0xO%6jQ$IUO1G0xO%7QQ$IUO1G0xO%9eQ$IUO1G0xO%9lQ$IUO1G0xO%;pQ$IUO1G0xO%;wQ$IUO1G0xO%=oQ$IUO1G0xO%>SQ(CjO<<JaO%?XQ$IUO1G0xO%@}Q$IUO'#J^O%CQQ$IUO1G1^O%C_Q$IUO1G0QO!)jQUO'#FlOOQO'#Jy'#JyOOQO1G1p1G1pO%CiQSO1G1oO%CnQ$IUO,5?QOOOO7+'c7+'cOOOO1G/S1G/SOOQ(CY1G4n1G4nO!'^Q,UO7+(ZO%CxQSO,5?RO9_QSO,5?ROOQO-E<e-E<eO%DWQSO1G6RO%DWQSO1G6RO%D`QSO1G6RO%DkQ,UO7+'sO%D{Q`O,5?TO%EVQSO,5?TO!%tQ,UO,5?TOOQO-E<g-E<gO%E[Q`O1G6SO%EfQSO1G6SOOQ(CW1G2c1G2cO$ mQSO1G2cOOQ(CW1G2b1G2bO%EnQSO1G2dO!%tQ,UO1G2dOOQ(CW1G2i1G2iO!>oQWO1G2bOBoQSO1G2cO%EsQSO1G2dO%E{QSO1G2cO!'^Q,UO7+*}OOQ(CY1G/[1G/[O%FWQSO1G/[OOQ(CY7+'n7+'nO%F]Q,UO7+'uO%FmQ(CjO<<KROOQ(CY<<KR<<KRO!%tQ,UO'#IlO%GaQSO,5@iO!%tQ,UO1G2gOOQQ<<Gx<<GxO!>dQ(C[O<<GxO%GiQ(CjO<<ItOOQ(CY<<It<<ItOOQO,5?^,5?^O%H]QSO,5?^O$%|QSO,5?^OOQO-E<p-E<pO%HbQSO1G6ZO%HbQSO1G6ZO9_QSO1G6ZO?rQSO<<LcOOQQ<<Lc<<LcO%HjQSO<<LcO9OQ(C[O<<LcO%HoQSO1G0sOOQQ<<LO<<LOO% dQ(ChO<<LOOOQQ<<LP<<LPO% nQ`O<<LPO%HtQWO'#InO%IPQSO,5@lO!)jQUO,5@lOOQQ1G2}1G2}O%IXQUO'#JgOOQO'#Ip'#IpO9OQ(C[O'#IpO%IcQWO,5=lOOQQ,5=l,5=lO%IjQWO'#E`O%JOQSO7+(qO%JTQSO7+(qOOQQ7+(q7+(qO!%tQ,UO7+(qO%QQUO7+(qO%J]QSO7+(qOOQQ7+(s7+(sO9OQ(C[O7+(sO#K`QSO7+(sO8tQSO7+(sO!>oQWO7+(sO%JhQSO,5?]OOQO-E<o-E<oOOQO'#HT'#HTO%JsQSO1G6XO9OQ(C[O<<GnOOQQ<<Gn<<GnO?rQSO<<GnO%J{QSO7++vO%KQQSO7++wOOQQ7+({7+({O%KVQSO7+({O%K[QUO7+({O%KcQSO7+({O%QQUO7++vO%QQUO7++wOOQQ<<Lo<<LoOOQQ<<Lq<<LqOOQQ-E<r-E<rOOQQ1G3p1G3pO%KhQSO,5>VOOQQ,5>X,5>XO%KmQSO1G3vO:vQSO7+&_O!)jQUO7+&_OOQO7+%X7+%XO%KrQ$IUO1G5yO>QQSO7+%XOOQ(CY<<I]<<I]OOQ(CY<<Is<<IsO>QQSO<<IsOOQO<<Il<<IlO$6nQ(CjO<<IlO%QQUO<<IlOOQO<<I`<<I`O!>dQ(C[O<<I`O%K|Q(C[O<<IlO%LXQ(CjO<<N|O%LiQSO<<N{OOQO7+*T7+*TO:vQSO7+*TOOQQANAcANAcO%LqQSOANAcO!%tQ,UOANAcO#![QSOANAcO$MUQbOANAcO%QQUOANAcO%LyQ(CjO7+'sO& [Q(CjO7+'uO&#mQbO1G4cO&#wQ$IUO7+&YO&$UQ$IUO,59nO&&XQ$IUO,5<dO&([Q$IUO,5<fO&*_Q$IUO,5<tO&,TQ$IUO7+'fO&,bQ$IUO7+'gO&,oQSO,5<WOOQO7+'Z7+'ZO&,tQ,UO<<KuOOQO1G4m1G4mO&,{QSO1G4mO&-WQSO1G4mO&-fQSO7++mO&-fQSO7++mO!%tQ,UO1G4oO&-nQ`O1G4oO&-xQSO7++nOOQ(CW7+'}7+'}O$ mQSO7+(OO&.QQ`O7+(OOOQ(CW7+'|7+'|O$ mQSO7+'}O&.XQSO7+(OO!%tQ,UO7+(OOBoQSO7+'}O&.^Q,UO<<NiOOQ(CY7+$v7+$vO&.hQ`O,5?WOOQO-E<j-E<jO&.rQ(ChO7+(ROOQQAN=dAN=dO9_QSO1G4xOOQO1G4x1G4xO&/SQSO1G4xO&/XQSO7++uO&/XQSO7++uO9OQ(C[OANA}O?rQSOANA}OOQQANA}ANA}OOQQANAjANAjOOQQANAkANAkO&/aQSO,5?YOOQO-E<l-E<lO&/lQ$IUO1G6WO&1|QbO'#CfOOQO,5?[,5?[OOQO-E<n-E<nOOQQ1G3W1G3WO%IXQUO,5<xOOQQ<<L]<<L]O!%tQ,UO<<L]O%JOQSO<<L]O&2WQSO<<L]O%QQUO<<L]OOQQ<<L_<<L_O9OQ(C[O<<L_O#K`QSO<<L_O8tQSO<<L_O&2`QWO1G4wO&2kQSO7++sOOQQAN=YAN=YO9OQ(C[OAN=YOOQQ<= b<= bOOQQ<= c<= cOOQQ<<Lg<<LgO&2sQSO<<LgO&2xQUO<<LgO&3PQSO<= bO&3UQSO<= cOOQQ1G3q1G3qO>QQSO7+)bO&3ZQSO<<IyO&3fQ$IUO<<IyOOQO<<Hs<<HsOOQ(CYAN?_AN?_OOQOAN?WAN?WO$6nQ(CjOAN?WOOQOAN>zAN>zO%QQUOAN?WOOQO<<Mo<<MoOOQQG26}G26}O!%tQ,UOG26}O#![QSOG26}O&3pQSOG26}O$MUQbOG26}O&3xQ$IUO<<JaO&4VQ$IUO1G2XO&5{Q$IUO1G2kO&8OQ$IUO1G2mO&:RQ$IUO<<KRO&:`Q$IUO<<ItOOQO1G1r1G1rO!'^Q,UOANAaOOQO7+*X7+*XO&:mQSO7+*XO&:xQSO<= XO&;QQ`O7+*ZOOQ(CW<<Kj<<KjO$ mQSO<<KjOOQ(CW<<Ki<<KiO&;[Q`O<<KjO$ mQSO<<KiOOQO7+*d7+*dO9_QSO7+*dO&;cQSO<= aOOQQG27iG27iO9OQ(C[OG27iO!)jQUO1G4tO&;kQSO7++rO%JOQSOANAwOOQQANAwANAwO!%tQ,UOANAwO&;sQSOANAwOOQQANAyANAyO9OQ(C[OANAyO#K`QSOANAyOOQO'#HU'#HUOOQO7+*c7+*cOOQQG22tG22tOOQQANBRANBRO&;{QSOANBROOQQAND|AND|OOQQAND}AND}OOQQ<<L|<<L|O!)jQUOAN?eOOQOG24rG24rO$6nQ(CjOG24rO#![QSOLD,iOOQQLD,iLD,iO!%tQ,UOLD,iO&<QQSOLD,iO&<YQ$IUO7+'sO&>OQ$IUO7+'uO&?tQ,UOG26{OOQO<<Ms<<MsOOQ(CWANAUANAUO$ mQSOANAUOOQ(CWANATANATOOQO<<NO<<NOOOQQLD-TLD-TO&@UQ$IUO7+*`OOQQG27cG27cO%JOQSOG27cO!%tQ,UOG27cOOQQG27eG27eO9OQ(C[OG27eOOQQG27mG27mO&@`Q$IUOG25POOQOLD*^LD*^OOQQ!$(!T!$(!TO#![QSO!$(!TO!%tQ,UO!$(!TO&@jQ(CjOG26{OOQ(CWG26pG26pOOQQLD,}LD,}O%JOQSOLD,}OOQQLD-PLD-POOQQ!)9Eo!)9EoO#![QSO!)9EoOOQQ!$(!i!$(!iOOQQ!.K;Z!.K;ZO&B{Q$IUOG26{O!)jQUO'#DvO0uQSO'#ETO&DqQbO'#JcO!)jQUO'#DnO&DxQUO'#DzO!)jQUO'#D|O&EPQbO'#CfO&GgQbO'#CfO&GwQUO,5;SO!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO,5;^O!)jQUO'#IfO&IzQSO,5<cO&JSQ,UO,5;^O&KgQ,UO,5;^O!)jQUO,5;rO0xQSO'#DSO0xQSO'#DSO!%tQ,UO'#FxO&JSQ,UO'#FxO!%tQ,UO'#FzO&JSQ,UO'#FzO!%tQ,UO'#GYO&JSQ,UO'#GYO!)jQUO,5:fO!)jQUO,5@_O&GwQUO1G0nO&KnQ$IUO'#CfO!)jQUO1G1zO!%tQ,UO,5=PO&JSQ,UO,5=PO!%tQ,UO,5=RO&JSQ,UO,5=RO!%tQ,UO,5<mO&JSQ,UO,5<mO&GwQUO1G1{O!)jQUO7+&uO!%tQ,UO1G2XO&JSQ,UO1G2XO!%tQ,UO1G2ZO&JSQ,UO1G2ZO&GwQUO7+'gO&GwQUO7+&YO!%tQ,UOANAaO&JSQ,UOANAaO&KxQSO'#EhO&K}QSO'#EhO&LVQSO'#FWO&L[QSO'#ErO&LaQSO'#JsO&LlQSO'#JqO&LwQSO,5;SO&L|Q,UO,5<`O&MTQSO'#GRO&MYQSO'#GRO&M_QSO,5<aO&MgQSO,5;SO&MoQ$IUO1G1ZO&MvQSO,5<mO&M{QSO,5<mO&NQQSO,5<oO&NVQSO,5<oO&N[QSO1G1{O&NaQSO1G0nO&NfQ,UO<<KuO&NmQ,UO<<KuO7^Q,UO'#FvO8tQSO'#FuO@mQSO'#EgO!)jQUO,5;oO!2dQSO'#GRO!2dQSO'#GRO!2dQSO'#GTO!2dQSO'#GTO!'^Q,UO7+(ZO!'^Q,UO7+(ZO$HyQ`O1G2oO$HyQ`O1G2oO!%tQ,UO,5=TO!%tQ,UO,5=T",stateData:"' v~O'mOS'nOSROS'oRQ~OPYOQYOV!TO^pOaxObwOikOkYOlkOmkOskOuYOwYO|WO!QkO!RkO!XXO!csO!hZO!kYO!lYO!mYO!otO!quO!tvO!x]O#p}O$QzO$UfO%`{O%b!OO%d|O%e|O%h!PO%j!QO%m!RO%n!RO%p!SO%|!UO&S!VO&U!WO&W!XO&Y!YO&]!ZO&c![O&i!]O&k!^O&m!_O&o!`O&q!aO'tSO'vTO'yUO(RVO(a[O(niO~OPYOQYOa!gOb!fOikOkYOlkOmkOskOuYOwYO|WO!QkO!RkO!X!cO!csO!hZO!kYO!lYO!mYO!otO!quO!t!eO$Q!hO$UfO't!bO'vTO'yUO(RVO(a[O(niO~O^!sOl!kO|!lO![!uO!]!rO!^!rO!x9mO!|!mO!}!mO#O!tO#P!mO#Q!mO#T!vO#U!vO'u!iO'vTO'yUO(U!jO(a!pO~O'o!wO~OPYXXYX^YXkYXyYXzYX|YX!VYX!eYX!fYX!hYX!lYX#XYX#dcX#gYX#hYX#iYX#jYX#kYX#lYX#mYX#nYX#oYX#qYX#sYX#uYX#vYX#{YX'kYX(RYX(bYX(iYX(jYX~O!a$zX~P(gO[!yO'v!{O'w!yO'x!{O~O[!|O'x!{O'y!{O'z!|O~Oq#OO!O#PO(S#PO(T#RO~OPYOQYOa!gOb!fOikOkYOlkOmkOskOuYOwYO|WO!QkO!RkO!X!cO!csO!hZO!kYO!lYO!mYO!otO!quO!t!eO$Q!hO$UfO't9rO'vTO'yUO(RVO(a[O(niO~O!U#VO!V#SO!S(XP!S(fP~P+sO!W#_O~P`OPYOQYOa!gOb!fOkYOlkOmkOskOuYOwYO|WO!QkO!RkO!X!cO!csO!hZO!kYO!lYO!mYO!otO!quO!t!eO$Q!hO$UfO'vTO'yUO(RVO(a[O(niO~Oi#iO!U#eO!x]O#b#hO#c#eO't9sO!g(cP~P._O!h#kO't#jO~O!t#oO!x]O%`#pO~O#d#qO~O!a#rO#d#qO~OP$YOX$aOk#}Oy#vOz#wO|#xO!V$^O!e$PO!f#tO!h#uO!l$YO#g#{O#h#|O#i#|O#j#|O#k$OO#l$PO#m$PO#n$`O#o$PO#q$QO#s$SO#u$UO#v$VO(RVO(b$WO(i#yO(j#zO~O^(VX'k(VX'i(VX!g(VX!S(VX!X(VX%a(VX!a(VX~P1gO#X$bO#{$bOP(WXX(WXk(WXy(WXz(WX|(WX!V(WX!e(WX!h(WX!l(WX#g(WX#h(WX#i(WX#j(WX#k(WX#l(WX#m(WX#n(WX#o(WX#q(WX#s(WX#u(WX#v(WX(R(WX(b(WX(i(WX(j(WX!X(WX%a(WX~O^(WX!f(WX'k(WX'i(WX!S(WX!g(WXo(WX!a(WX~P3}O#X$bO~O$W$dO$Y$cO$a$iO~O!X$jO$UfO$d$kO$f$mO~Oi%POk$qOl$pOm$pOs%QOu%ROw%SO|$xO!X$yO!c%XO!h$uO#c%YO$Q%VO$m%TO$o%UO$r%WO't$oO'vTO'yUO'}%OO(R$rOd(OP~O!h%ZO~O!a%]O~O^%^O'k%^O~O'u!iO~P%QO't%eO~O!h%ZO't%eO'u!iO'}%OO~Ob%lO!h%ZO't%eO~O#o$PO~Oy%qO!X%nO!h%pO%b%tO't%eO'u!iO'vTO'yUO](vP~O!t#oO~O|%vO!X%wO't%eO~O|%vO!X%wO%j%{O't%eO~O't%|O~O#p}O%b!OO%d|O%e|O%h!PO%j!QO%m!RO%n!RO~Oa&VOb&UO!t&SO%`&TO%r&RO~P;fOa&YObwO!X&XO!tvO!x]O#p}O%`{O%d|O%e|O%h!PO%j!QO%m!RO%n!RO%p!SO~O_&]O#X&`O%b&ZO'u!iO~P<eO!h&aO!q&eO~O!h#kO~O!XXO~O^%^O'j&mO'k%^O~O^%^O'j&pO'k%^O~O^%^O'j&rO'k%^O~O'iYX!SYXoYX!gYX&QYX!XYX%aYX!aYX~P(gO!['PO!]&xO!^&xO'u!iO'vTO'yUO~Ol&vO|&uO!U&yO(U&tO!W(YP!W(hP~P?fOg'SO!X'QO't%eO~Ob'XO!h%ZO't%eO~Oy%qO!h%pO~Ol!kO|!lO!x9mO!|!mO!}!mO#P!mO#Q!mO'u!iO'vTO'yUO(U!jO(a!pO~O!['_O!]'^O!^'^O#O!mO#T'`O#U'`O~PAQO^%^O!a#rO!h%ZO'k%^O'}%OO(b'bO~O!l'fO#X'dO~PB`Ol!kO|!lO'vTO'yUO(U!jO(a!pO~O!XXOl(_X|(_X![(_X!](_X!^(_X!x(_X!|(_X!}(_X#O(_X#P(_X#Q(_X#T(_X#U(_X'u(_X'v(_X'y(_X(U(_X(a(_X~O!]'^O!^'^O'u!iO~PCOO'p'jO'q'jO'r'lO~O[!yO'v'nO'w!yO'x'nO~O[!|O'x'nO'y'nO'z!|O~Oq#OO!O#PO(S#PO(T'rO~O!U'tO!S&|X!S'SX!V&|X!V'SX~P+sO!V'vO!S(XX~OP$YOX$aOk#}Oy#vOz#wO|#xO!V'vO!e$PO!f#tO!h#uO!l$YO#g#{O#h#|O#i#|O#j#|O#k$OO#l$PO#m$PO#n$`O#o$PO#q$QO#s$SO#u$UO#v$VO(RVO(b$WO(i#yO(j#zO~O!S(XX~PFrO!S'{O~O!S(eX!V(eX!a(eX!g(eX(b(eX~O#X(eX#d#]X!W(eX~PHxO#X'|O!S(gX!V(gX~O!V'}O!S(fX~O!S(QO~O#X$bO~PHxO!W(RO~P`Oy#vOz#wO|#xO!f#tO!h#uO(RVOP!jaX!jak!ja!V!ja!e!ja!l!ja#g!ja#h!ja#i!ja#j!ja#k!ja#l!ja#m!ja#n!ja#o!ja#q!ja#s!ja#u!ja#v!ja(b!ja(i!ja(j!ja~O^!ja'k!ja'i!ja!S!ja!g!jao!ja!X!ja%a!ja!a!ja~PJ`O!g(SO~O!a#rO#X(TO(b'bO!V(dX^(dX'k(dX~O!g(dX~PMOO|%vO!X%wO!x]O#b(YO#c(XO't%eO~O!V(ZO!g(cX~O!g(]O~O|%vO!X%wO#c(XO't%eO~OP(WXX(WXk(WXy(WXz(WX|(WX!V(WX!e(WX!f(WX!h(WX!l(WX#g(WX#h(WX#i(WX#j(WX#k(WX#l(WX#m(WX#n(WX#o(WX#q(WX#s(WX#u(WX#v(WX(R(WX(b(WX(i(WX(j(WX~O!a#rO!g(WX~PNlOy(^Oz(_O!f#tO!h#uO!x!wa|!wa~O!t!wa%`!wa!X!wa#b!wa#c!wa't!wa~P!!pO!t(cO~OPYOQYOa!gOb!fOikOkYOlkOmkOskOuYOwYO|WO!QkO!RkO!XXO!csO!hZO!kYO!lYO!mYO!otO!quO!t!eO$Q!hO$UfO't!bO'vTO'yUO(RVO(a[O(niO~Oi%POk$qOl$pOm$pOs%QOu%ROw:VO|$xO!X$yO!c;aO!h$uO#c:]O$Q%VO$m:XO$o:ZO$r%WO't(gO'vTO'yUO'}%OO(R$rO~O#d(iO~Oi%POk$qOl$pOm$pOs%QOu%ROw%SO|$xO!X$yO!c%XO!h$uO#c%YO$Q%VO$m%TO$o%UO$r%WO't(gO'vTO'yUO'}%OO(R$rO~Od([P~P!'^O!U(mO!g(]P~P%QO(U(oO(a[O~O|(qO!h#uO(U(oO(a[O~OP9lOQ9lOa;]Ob!fOikOk9lOlkOmkOskOu9lOw9lO|WO!QkO!RkO!X!cO!c9oO!hZO!k9lO!l9lO!m9lO!o9pO!q9qO!t!eO$Q!hO$UfO't)PO'vTO'yUO(RVO(a[O(n;ZO~Oz)SO!h#uO~O!V$^O^$ka'k$ka'i$ka!g$ka!S$ka!X$ka%a$ka!a$ka~O#p)WO~P!%tOy)ZO!a)YO!X$XX$T$XX$W$XX$Y$XX$a$XX~O!a)YO!X(kX$T(kX$W(kX$Y(kX$a(kX~Oy)ZO~P!-SOy)ZO!X(kX$T(kX$W(kX$Y(kX$a(kX~O!X)]O$T)aO$W)[O$Y)[O$a)bO~O!U)eO~P!)jO$W$dO$Y$cO$a)iO~Og$sXy$sX|$sX!f$sX(i$sX(j$sX~OdfXd$sXgfX!VfX#XfX~P!.xOl)kO~Oq)lO(S)mO(T)oO~Og)xOy)qO|)rO(i)tO(j)vO~Od)pO~P!0ROd)yO~Oi%POk$qOl$pOm$pOs%QOu%ROw:VO|$xO!X$yO!c;aO!h$uO#c:]O$Q%VO$m:XO$o:ZO$r%WO'vTO'yUO'}%OO(R$rO~O!U)}O't)zO!g(oP~P!0pO#d*PO~O!h*QO~O!U*VO't*SO!S(pP~P!0pOk*cO|*ZO![*aO!]*YO!^*YO!h*QO#T*bO%W*]O'u!iO(U!jO~O!W*`O~P!2vO!f#tOg(QXy(QX|(QX(i(QX(j(QX!V(QX#X(QX~Od(QX#y(QX~P!3oOg*fO#X*eOd(PX!V(PX~O!V*gOd(OX~O't%|Od(OP~O!h*nO~O't(gO~Oi*rO|%vO!U#eO!X%wO!x]O#b#hO#c#eO't%eO!g(cP~O!a#rO#d*sO~OP$YOX$aOk#}Oy#vOz#wO|#xO!e$PO!f#tO!h#uO!l$YO#g#{O#h#|O#i#|O#j#|O#k$OO#l$PO#m$PO#n$`O#o$PO#q$QO#s$SO#u$UO#v$VO(RVO(b$WO(i#yO(j#zO~O^!ba!V!ba'k!ba'i!ba!S!ba!g!bao!ba!X!ba%a!ba!a!ba~P!6UOy#vOz#wO|#xO!f#tO!h#uO(RVOP!naX!nak!na!V!na!e!na!l!na#g!na#h!na#i!na#j!na#k!na#l!na#m!na#n!na#o!na#q!na#s!na#u!na#v!na(b!na(i!na(j!na~O^!na'k!na'i!na!S!na!g!nao!na!X!na%a!na!a!na~P!8oOy#vOz#wO|#xO!f#tO!h#uO(RVOP!paX!pak!pa!V!pa!e!pa!l!pa#g!pa#h!pa#i!pa#j!pa#k!pa#l!pa#m!pa#n!pa#o!pa#q!pa#s!pa#u!pa#v!pa(b!pa(i!pa(j!pa~O^!pa'k!pa'i!pa!S!pa!g!pao!pa!X!pa%a!pa!a!pa~P!;YOg*{O!X'QO%a*zO'}%OO~O!a*}O^'|X!X'|X'k'|X!V'|X~O^%^O!XXO'k%^O~O!h%ZO'}%OO~O!h%ZO't%eO'}%OO~O!a#rO#d(iO~O%b+ZO't+VO'vTO'yUO!W(wP~O!V+[O](vX~O(U(oO~OX+`O~O]+aO~O!X%nO't%eO'u!iO](vP~O|%vO!U+eO!V'}O!X%wO't%eO!S(fP~Ol&|O|+gO!U+fO'vTO'yUO(U(oO~O!W(hP~P!@xO!V+hO^(sX'k(sX~O#X+lO'}%OO~Og+oO!X$yO'}%OO~O!X+qO~Oy+sO!XXO~O!t+xO~Ob+}O~O't#jO!W(uP~Ob%lO~O%b!OO't%|O~P<eOX,TO],SO~OPYOQYOaxObwOikOkYOlkOmkOskOuYOwYO|WO!QkO!RkO!csO!hZO!kYO!lYO!mYO!otO!quO!tvO!x]O$UfO%`{O'vTO'yUO(RVO(a[O(niO~O!X!cO$Q!hO't!bO~P!C]O],SO^%^O'k%^O~O^,XO#p,ZO%d,ZO%e,ZO~P%QO!h&aO~O&S,`O~O!X,bO~O&e,dO&g,eOP&baQ&baV&ba^&baa&bab&bai&bak&bal&bam&bas&bau&baw&ba|&ba!Q&ba!R&ba!X&ba!c&ba!h&ba!k&ba!l&ba!m&ba!o&ba!q&ba!t&ba!x&ba#p&ba$Q&ba$U&ba%`&ba%b&ba%d&ba%e&ba%h&ba%j&ba%m&ba%n&ba%p&ba%|&ba&S&ba&U&ba&W&ba&Y&ba&]&ba&c&ba&i&ba&k&ba&m&ba&o&ba&q&ba'i&ba't&ba'v&ba'y&ba(R&ba(a&ba(n&ba!W&ba&Z&ba_&ba&`&ba~O't,jO~O!V{X!V!_X!W{X!W!_X!a{X!a!_X!h!_X#X{X'}!_X~O!a,oO#X,nO!V#aX!V(ZX!W#aX!W(ZX!a(ZX!h(ZX'}(ZX~O!a,qO!h%ZO'}%OO!V!ZX!W!ZX~Ol!kO|!lO'vTO'yUO(U!jO~OP9lOQ9lOa;]Ob!fOikOk9lOlkOmkOskOu9lOw9lO|WO!QkO!RkO!X!cO!c9oO!hZO!k9lO!l9lO!m9lO!o9pO!q9qO!t!eO$Q!hO$UfO'vTO'yUO(RVO(a[O(n;ZO~O't:bO~P!LrO!V,uO!W(YX~O!W,wO~O!a,oO#X,nO!V#aX!W#aX~O!V,xO!W(hX~O!W,zO~O!],{O!^,{O'u!iO~P!LaO!W-OO~P'TOg-RO!X'QO~O!S-WO~Ol!wa![!wa!]!wa!^!wa!|!wa!}!wa#O!wa#P!wa#Q!wa#T!wa#U!wa'u!wa'v!wa'y!wa(U!wa(a!wa~P!!pO!l-]O#X-ZO~PB`O!]-_O!^-_O'u!iO~PCOO^%^O#X-ZO'k%^O~O^%^O!a#rO#X-ZO'k%^O~O^%^O!a#rO!l-]O#X-ZO'k%^O(b'bO~O'p'jO'q'jO'r-dO~Oo-eO~O!S&|a!V&|a~P!6UO!U-iO!S&|X!V&|X~P%QO!V'vO!S(Xa~O!S(Xa~PFrO!V'}O!S(fa~O|%vO!U-mO!X%wO't%eO!S'SX!V'SX~O#X-oO!V(da!g(da^(da'k(da~O!a#rO~P#&xO!V(ZO!g(ca~O|%vO!X%wO#c-sO't%eO~Oi-xO|%vO!U-uO!X%wO!x]O#b-wO#c-uO't%eO!V'VX!g'VX~Oz-|O!h#uO~Og.PO!X'QO%a.OO'}%OO~O^#[i!V#[i'k#[i'i#[i!S#[i!g#[io#[i!X#[i%a#[i!a#[i~P!6UOg;gOy)qO|)rO(i)tO(j)vO~O#d#Wa^#Wa#X#Wa'k#Wa!V#Wa!g#Wa!X#Wa!S#Wa~P#)tO#d(QXP(QXX(QX^(QXk(QXz(QX!e(QX!h(QX!l(QX#g(QX#h(QX#i(QX#j(QX#k(QX#l(QX#m(QX#n(QX#o(QX#q(QX#s(QX#u(QX#v(QX'k(QX(R(QX(b(QX!g(QX!S(QX'i(QXo(QX!X(QX%a(QX!a(QX~P!3oO!V.YOd([X~P!0ROd.[O~O!V.]O!g(]X~P!6UO!g.`O~O!S.bO~OP$YOy#vOz#wO|#xO!f#tO!h#uO!l$YO(RVOX#fi^#fik#fi!V#fi!e#fi#h#fi#i#fi#j#fi#k#fi#l#fi#m#fi#n#fi#o#fi#q#fi#s#fi#u#fi#v#fi'k#fi(b#fi(i#fi(j#fi'i#fi!S#fi!g#fio#fi!X#fi%a#fi!a#fi~O#g#fi~P#-pO#g#{O~P#-pOP$YOy#vOz#wO|#xO!f#tO!h#uO!l$YO#g#{O#h#|O#i#|O#j#|O(RVOX#fi^#fi!V#fi!e#fi#k#fi#l#fi#m#fi#n#fi#o#fi#q#fi#s#fi#u#fi#v#fi'k#fi(b#fi(i#fi(j#fi'i#fi!S#fi!g#fio#fi!X#fi%a#fi!a#fi~Ok#fi~P#0bOk#}O~P#0bOP$YOk#}Oy#vOz#wO|#xO!f#tO!h#uO!l$YO#g#{O#h#|O#i#|O#j#|O#k$OO(RVO^#fi!V#fi#q#fi#s#fi#u#fi#v#fi'k#fi(b#fi(i#fi(j#fi'i#fi!S#fi!g#fio#fi!X#fi%a#fi!a#fi~OX#fi!e#fi#l#fi#m#fi#n#fi#o#fi~P#3SOX$aO!e$PO#l$PO#m$PO#n$`O#o$PO~P#3SOP$YOX$aOk#}Oy#vOz#wO|#xO!e$PO!f#tO!h#uO!l$YO#g#{O#h#|O#i#|O#j#|O#k$OO#l$PO#m$PO#n$`O#o$PO#q$QO(RVO^#fi!V#fi#s#fi#u#fi#v#fi'k#fi(b#fi(j#fi'i#fi!S#fi!g#fio#fi!X#fi%a#fi!a#fi~O(i#fi~P#6TO(i#yO~P#6TOP$YOX$aOk#}Oy#vOz#wO|#xO!e$PO!f#tO!h#uO!l$YO#g#{O#h#|O#i#|O#j#|O#k$OO#l$PO#m$PO#n$`O#o$PO#q$QO#s$SO(RVO(i#yO^#fi!V#fi#u#fi#v#fi'k#fi(b#fi'i#fi!S#fi!g#fio#fi!X#fi%a#fi!a#fi~O(j#fi~P#8uO(j#zO~P#8uOP$YOX$aOk#}Oy#vOz#wO|#xO!e$PO!f#tO!h#uO!l$YO#g#{O#h#|O#i#|O#j#|O#k$OO#l$PO#m$PO#n$`O#o$PO#q$QO#s$SO#u$UO(RVO(i#yO(j#zO~O^#fi!V#fi#v#fi'k#fi(b#fi'i#fi!S#fi!g#fio#fi!X#fi%a#fi!a#fi~P#;gOPYXXYXkYXyYXzYX|YX!eYX!fYX!hYX!lYX#XYX#dcX#gYX#hYX#iYX#jYX#kYX#lYX#mYX#nYX#oYX#qYX#sYX#uYX#vYX#{YX(RYX(bYX(iYX(jYX!VYX!WYX~O#yYX~P#>QOP$YOX:TOk9wOy#vOz#wO|#xO!e9yO!f#tO!h#uO!l$YO#g9uO#h9vO#i9vO#j9vO#k9xO#l9yO#m9yO#n:SO#o9yO#q9zO#s9|O#u:OO#v:PO(RVO(b$WO(i#yO(j#zO~O#y.dO~P#@_O#X:UO#{:UO#y(WX!W(WX~PNlO^'Ya!V'Ya'k'Ya'i'Ya!g'Ya!S'Yao'Ya!X'Ya%a'Ya!a'Ya~P!6UOP#fiX#fi^#fik#fiz#fi!V#fi!e#fi!f#fi!h#fi!l#fi#g#fi#h#fi#i#fi#j#fi#k#fi#l#fi#m#fi#n#fi#o#fi#q#fi#s#fi#u#fi#v#fi'k#fi(R#fi(b#fi'i#fi!S#fi!g#fio#fi!X#fi%a#fi!a#fi~P#)tO^#zi!V#zi'k#zi'i#zi!S#zi!g#zio#zi!X#zi%a#zi!a#zi~P!6UO$W.iO$Y.iO~O$W.jO$Y.jO~O!a)YO#X.kO!X$^X$T$^X$W$^X$Y$^X$a$^X~O!U.lO~O!X)]O$T.nO$W)[O$Y)[O$a.oO~O!V:QO!W(VX~P#@_O!W.pO~O!a)YO$a(kX~O$a.rO~Oq)lO(S)mO(T.uO~Ol.xO!S.yO'vTO'yUO~O!VcX!acX!gcX!g$sX(bcX~P!.xO!g/PO~P#)tO!V/QO!a#rO(b'bO!g(oX~O!g/VO~O!U)}O't%eO!g(oP~O#d/XO~O!S$sX!V$sX!a$zX~P!.xO!V/YO!S(pX~P#)tO!a/[O~O!S/^O~Ok/bO!a#rO!h%ZO'}%OO(b'bO~O't/dO~O!a*}O~O^%^O!V/hO'k%^O~O!W/jO~P!2vO!]/kO!^/kO'u!iO(U!jO~O|/mO(U!jO~O#T/nO~O't%|Od'_X!V'_X~O!V*gOd(Oa~Od/sO~Oy/tOz/tO|/uOgva(iva(jva!Vva#Xva~Odva#yva~P#L|Oy)qO|)rOg$la(i$la(j$la!V$la#X$la~Od$la#y$la~P#MrOy)qO|)rOg$na(i$na(j$na!V$na#X$na~Od$na#y$na~P#NeO#d/wO~Od$|a!V$|a#X$|a#y$|a~P!0RO!a#rO~O#d/zO~Oy#vOz#wO|#xO!f#tO!h#uO(RVOP!niX!nik!ni!V!ni!e!ni!l!ni#g!ni#h!ni#i!ni#j!ni#k!ni#l!ni#m!ni#n!ni#o!ni#q!ni#s!ni#u!ni#v!ni(b!ni(i!ni(j!ni~O^!ni'k!ni'i!ni!S!ni!g!nio!ni!X!ni%a!ni!a!ni~P$ wOg.PO!X'QO%a.OO~Oi0RO't0QO~P!0sO!a*}O^'|a!X'|a'k'|a!V'|a~O#d0XO~OXYX!VcX!WcX~O!V0YO!W(wX~O!W0[O~OX0]O~O't+VO'vTO'yUO~O!X%nO't%eO]'gX!V'gX~O!V+[O](va~O!g0bO~P!6UOX0eO~O]0fO~O!V+hO^(sa'k(sa~O#X0lO~Og0oO!X$yO~O(U(oO!W(tP~Og0xO!X0uO%a0wO'}%OO~OX1SO!V1QO!W(uX~O!W1TO~O]1VO^%^O'k%^O~O't#jO'vTO'yUO~O#X$bO#{$bOP(WXX(WXk(WXy(WXz(WX|(WX!V(WX!e(WX!h(WX!l(WX#g(WX#h(WX#i(WX#j(WX#k(WX#l(WX#m(WX#n(WX#q(WX#s(WX#u(WX#v(WX(R(WX(b(WX(i(WX(j(WX~O#o1YO&Q1ZO^(WX!f(WX~P$(xO#X$bO#o1YO&Q1ZO~O^1[O~P%QO^1^O~O&Z1bOP&XiQ&XiV&Xi^&Xia&Xib&Xii&Xik&Xil&Xim&Xis&Xiu&Xiw&Xi|&Xi!Q&Xi!R&Xi!X&Xi!c&Xi!h&Xi!k&Xi!l&Xi!m&Xi!o&Xi!q&Xi!t&Xi!x&Xi#p&Xi$Q&Xi$U&Xi%`&Xi%b&Xi%d&Xi%e&Xi%h&Xi%j&Xi%m&Xi%n&Xi%p&Xi%|&Xi&S&Xi&U&Xi&W&Xi&Y&Xi&]&Xi&c&Xi&i&Xi&k&Xi&m&Xi&o&Xi&q&Xi'i&Xi't&Xi'v&Xi'y&Xi(R&Xi(a&Xi(n&Xi!W&Xi_&Xi&`&Xi~O_1hO!W1fO&`1gO~P`O!XXO!h1jO~O&g,eOP&biQ&biV&bi^&bia&bib&bii&bik&bil&bim&bis&biu&biw&bi|&bi!Q&bi!R&bi!X&bi!c&bi!h&bi!k&bi!l&bi!m&bi!o&bi!q&bi!t&bi!x&bi#p&bi$Q&bi$U&bi%`&bi%b&bi%d&bi%e&bi%h&bi%j&bi%m&bi%n&bi%p&bi%|&bi&S&bi&U&bi&W&bi&Y&bi&]&bi&c&bi&i&bi&k&bi&m&bi&o&bi&q&bi'i&bi't&bi'v&bi'y&bi(R&bi(a&bi(n&bi!W&bi&Z&bi_&bi&`&bi~O!S1pO~O!V!Za!W!Za~P#@_Ol!kO|!lO!U1vO(U!jO!V&}X!W&}X~P?fO!V,uO!W(Ya~O!V'TX!W'TX~P!@xO!V,xO!W(ha~O!W1}O~P'TO^%^O#X2WO'k%^O~O^%^O!a#rO#X2WO'k%^O~O^%^O!a#rO!l2[O#X2WO'k%^O(b'bO~O^%^O'k%^O~P!6UO!V$^Oo$ka~O!S&|i!V&|i~P!6UO!V'vO!S(Xi~O!V'}O!S(fi~O!S(gi!V(gi~P!6UO!V(di!g(di^(di'k(di~P!6UO#X2^O!V(di!g(di^(di'k(di~O!V(ZO!g(ci~O|%vO!X%wO!x]O#b2cO#c2bO't%eO~O|%vO!X%wO#c2bO't%eO~Og2jO!X'QO%a2iO~Og2jO!X'QO%a2iO'}%OO~O#dvaPvaXva^vakva!eva!fva!hva!lva#gva#hva#iva#jva#kva#lva#mva#nva#ova#qva#sva#uva#vva'kva(Rva(bva!gva!Sva'ivaova!Xva%ava!ava~P#L|O#d$laP$laX$la^$lak$laz$la!e$la!f$la!h$la!l$la#g$la#h$la#i$la#j$la#k$la#l$la#m$la#n$la#o$la#q$la#s$la#u$la#v$la'k$la(R$la(b$la!g$la!S$la'i$lao$la!X$la%a$la!a$la~P#MrO#d$naP$naX$na^$nak$naz$na!e$na!f$na!h$na!l$na#g$na#h$na#i$na#j$na#k$na#l$na#m$na#n$na#o$na#q$na#s$na#u$na#v$na'k$na(R$na(b$na!g$na!S$na'i$nao$na!X$na%a$na!a$na~P#NeO#d$|aP$|aX$|a^$|ak$|az$|a!V$|a!e$|a!f$|a!h$|a!l$|a#g$|a#h$|a#i$|a#j$|a#k$|a#l$|a#m$|a#n$|a#o$|a#q$|a#s$|a#u$|a#v$|a'k$|a(R$|a(b$|a!g$|a!S$|a'i$|a#X$|ao$|a!X$|a%a$|a!a$|a~P#)tO^#[q!V#[q'k#[q'i#[q!S#[q!g#[qo#[q!X#[q%a#[q!a#[q~P!6UOd'OX!V'OX~P!'^O!V.YOd([a~O!U2rO!V'PX!g'PX~P%QO!V.]O!g(]a~O!V.]O!g(]a~P!6UO!S2uO~O#y!ja!W!ja~PJ`O#y!ba!V!ba!W!ba~P#@_O#y!na!W!na~P!8oO#y!pa!W!pa~P!;YO!X3XO$UfO$_3YO~O!W3^O~Oo3_O~P#)tO^$hq!V$hq'k$hq'i$hq!S$hq!g$hqo$hq!X$hq%a$hq!a$hq~P!6UO!S3`O~Ol.xO'vTO'yUO~Oy)qO|)rO(j)vOg%Xi(i%Xi!V%Xi#X%Xi~Od%Xi#y%Xi~P$GeOy)qO|)rOg%Zi(i%Zi(j%Zi!V%Zi#X%Zi~Od%Zi#y%Zi~P$HWO(b$WO~P#)tO!U3cO't%eO!V'ZX!g'ZX~O!V/QO!g(oa~O!V/QO!a#rO!g(oa~O!V/QO!a#rO(b'bO!g(oa~Od$ui!V$ui#X$ui#y$ui~P!0RO!U3kO't*SO!S']X!V']X~P!0pO!V/YO!S(pa~O!V/YO!S(pa~P#)tO!a#rO#o3sO~Ok3vO!a#rO(b'bO~Od(Pi!V(Pi~P!0RO#X3yOd(Pi!V(Pi~P!0RO!g3|O~O^$iq!V$iq'k$iq'i$iq!S$iq!g$iqo$iq!X$iq%a$iq!a$iq~P!6UO!V4QO!X(qX~P#)tO!f#tO~P3}O^$sX!X$sX%UYX'k$sX!V$sX~P!.xO%U4SO^hXghXyhX|hX!XhX'khX(ihX(jhX!VhX~O%U4SO~O%b4ZO't+VO'vTO'yUO!V'fX!W'fX~O!V0YO!W(wa~OX4_O~O]4`O~O!S4dO~O^%^O'k%^O~P#)tO!X$yO~P#)tO!V4iO#X4kO!W(tX~O!W4lO~Ol!kO|4mO![!uO!]!rO!^!rO!x9mO!|!mO!}!mO#O!mO#P!mO#Q!mO#T4rO#U!vO'u!iO'vTO'yUO(U!jO(a!pO~O!W4qO~P%!VOg4wO!X0uO%a4vO~Og4wO!X0uO%a4vO'}%OO~O't#jO!V'eX!W'eX~O!V1QO!W(ua~O'vTO'yUO(U5QO~O]5UO~O!g5XO~P%QO^5ZO~O^5ZO~P%QO#o5]O&Q5^O~PMOO_1hO!W5bO&`1gO~P`O!a5dO~O!a5fO!V(Zi!W(Zi!a(Zi!h(Zi'}(Zi~O!V#ai!W#ai~P#@_O#X5gO!V#ai!W#ai~O!V!Zi!W!Zi~P#@_O^%^O#X5pO'k%^O~O^%^O!a#rO#X5pO'k%^O~O!V(dq!g(dq^(dq'k(dq~P!6UO!V(ZO!g(cq~O|%vO!X%wO#c5wO't%eO~O!X'QO%a5zO~Og5}O!X'QO%a5zO~O#d%XiP%XiX%Xi^%Xik%Xiz%Xi!e%Xi!f%Xi!h%Xi!l%Xi#g%Xi#h%Xi#i%Xi#j%Xi#k%Xi#l%Xi#m%Xi#n%Xi#o%Xi#q%Xi#s%Xi#u%Xi#v%Xi'k%Xi(R%Xi(b%Xi!g%Xi!S%Xi'i%Xio%Xi!X%Xi%a%Xi!a%Xi~P$GeO#d%ZiP%ZiX%Zi^%Zik%Ziz%Zi!e%Zi!f%Zi!h%Zi!l%Zi#g%Zi#h%Zi#i%Zi#j%Zi#k%Zi#l%Zi#m%Zi#n%Zi#o%Zi#q%Zi#s%Zi#u%Zi#v%Zi'k%Zi(R%Zi(b%Zi!g%Zi!S%Zi'i%Zio%Zi!X%Zi%a%Zi!a%Zi~P$HWO#d$uiP$uiX$ui^$uik$uiz$ui!V$ui!e$ui!f$ui!h$ui!l$ui#g$ui#h$ui#i$ui#j$ui#k$ui#l$ui#m$ui#n$ui#o$ui#q$ui#s$ui#u$ui#v$ui'k$ui(R$ui(b$ui!g$ui!S$ui'i$ui#X$uio$ui!X$ui%a$ui!a$ui~P#)tOd'Oa!V'Oa~P!0RO!V'Pa!g'Pa~P!6UO!V.]O!g(]i~O#y#[i!V#[i!W#[i~P#@_OP$YOy#vOz#wO|#xO!f#tO!h#uO!l$YO(RVOX#fik#fi!e#fi#h#fi#i#fi#j#fi#k#fi#l#fi#m#fi#n#fi#o#fi#q#fi#s#fi#u#fi#v#fi#y#fi(b#fi(i#fi(j#fi!V#fi!W#fi~O#g#fi~P%0fO#g9uO~P%0fOP$YOy#vOz#wO|#xO!f#tO!h#uO!l$YO#g9uO#h9vO#i9vO#j9vO(RVOX#fi!e#fi#k#fi#l#fi#m#fi#n#fi#o#fi#q#fi#s#fi#u#fi#v#fi#y#fi(b#fi(i#fi(j#fi!V#fi!W#fi~Ok#fi~P%2qOk9wO~P%2qOP$YOk9wOy#vOz#wO|#xO!f#tO!h#uO!l$YO#g9uO#h9vO#i9vO#j9vO#k9xO(RVO#q#fi#s#fi#u#fi#v#fi#y#fi(b#fi(i#fi(j#fi!V#fi!W#fi~OX#fi!e#fi#l#fi#m#fi#n#fi#o#fi~P%4|OX:TO!e9yO#l9yO#m9yO#n:SO#o9yO~P%4|OP$YOX:TOk9wOy#vOz#wO|#xO!e9yO!f#tO!h#uO!l$YO#g9uO#h9vO#i9vO#j9vO#k9xO#l9yO#m9yO#n:SO#o9yO#q9zO(RVO#s#fi#u#fi#v#fi#y#fi(b#fi(j#fi!V#fi!W#fi~O(i#fi~P%7hO(i#yO~P%7hOP$YOX:TOk9wOy#vOz#wO|#xO!e9yO!f#tO!h#uO!l$YO#g9uO#h9vO#i9vO#j9vO#k9xO#l9yO#m9yO#n:SO#o9yO#q9zO#s9|O(RVO(i#yO#u#fi#v#fi#y#fi(b#fi!V#fi!W#fi~O(j#fi~P%9sO(j#zO~P%9sOP$YOX:TOk9wOy#vOz#wO|#xO!e9yO!f#tO!h#uO!l$YO#g9uO#h9vO#i9vO#j9vO#k9xO#l9yO#m9yO#n:SO#o9yO#q9zO#s9|O#u:OO(RVO(i#yO(j#zO~O#v#fi#y#fi(b#fi!V#fi!W#fi~P%<OO^#wy!V#wy'k#wy'i#wy!S#wy!g#wyo#wy!X#wy%a#wy!a#wy~P!6UOg;hOy)qO|)rO(i)tO(j)vO~OP#fiX#fik#fiz#fi!e#fi!f#fi!h#fi!l#fi#g#fi#h#fi#i#fi#j#fi#k#fi#l#fi#m#fi#n#fi#o#fi#q#fi#s#fi#u#fi#v#fi#y#fi(R#fi(b#fi!V#fi!W#fi~P%>vO!f#tOP(QXX(QXg(QXk(QXy(QXz(QX|(QX!e(QX!h(QX!l(QX#g(QX#h(QX#i(QX#j(QX#k(QX#l(QX#m(QX#n(QX#o(QX#q(QX#s(QX#u(QX#v(QX#y(QX(R(QX(b(QX(i(QX(j(QX!V(QX!W(QX~O#y#zi!V#zi!W#zi~P#@_O#y!ni!W!ni~P$ wO!W6ZO~O!V'Ya!W'Ya~P#@_O!a#rO(b'bO!V'Za!g'Za~O!V/QO!g(oi~O!V/QO!a#rO!g(oi~Od$uq!V$uq#X$uq#y$uq~P!0RO!S']a!V']a~P#)tO!a6bO~O!V/YO!S(pi~P#)tO!V/YO!S(pi~O!S6fO~O!a#rO#o6kO~Ok6lO!a#rO(b'bO~O!S6nO~Od$wq!V$wq#X$wq#y$wq~P!0RO^$iy!V$iy'k$iy'i$iy!S$iy!g$iyo$iy!X$iy%a$iy!a$iy~P!6UO!V4QO!X(qa~O^#[y!V#[y'k#[y'i#[y!S#[y!g#[yo#[y!X#[y%a#[y!a#[y~P!6UOX6sO~O!V0YO!W(wi~O]6yO~O!a5fO~O(U(oO!V'bX!W'bX~O!V4iO!W(ta~OikO't7QO~P._O!W7TO~P%!VOl!kO|7UO'vTO'yUO(U!jO(a!pO~O!X0uO~O!X0uO%a7WO~Og7ZO!X0uO%a7WO~OX7`O!V'ea!W'ea~O!V1QO!W(ui~O!g7dO~O!g7eO~O!g7fO~O!g7fO~P%QO^7hO~O!a7kO~O!g7lO~O!V(gi!W(gi~P#@_O^%^O#X7tO'k%^O~O!V(dy!g(dy^(dy'k(dy~P!6UO!V(ZO!g(cy~O!X'QO%a7wO~O#d$uqP$uqX$uq^$uqk$uqz$uq!V$uq!e$uq!f$uq!h$uq!l$uq#g$uq#h$uq#i$uq#j$uq#k$uq#l$uq#m$uq#n$uq#o$uq#q$uq#s$uq#u$uq#v$uq'k$uq(R$uq(b$uq!g$uq!S$uq'i$uq#X$uqo$uq!X$uq%a$uq!a$uq~P#)tO#d$wqP$wqX$wq^$wqk$wqz$wq!V$wq!e$wq!f$wq!h$wq!l$wq#g$wq#h$wq#i$wq#j$wq#k$wq#l$wq#m$wq#n$wq#o$wq#q$wq#s$wq#u$wq#v$wq'k$wq(R$wq(b$wq!g$wq!S$wq'i$wq#X$wqo$wq!X$wq%a$wq!a$wq~P#)tO!V'Pi!g'Pi~P!6UO#y#[q!V#[q!W#[q~P#@_Oy/tOz/tO|/uOPvaXvagvakva!eva!fva!hva!lva#gva#hva#iva#jva#kva#lva#mva#nva#ova#qva#sva#uva#vva#yva(Rva(bva(iva(jva!Vva!Wva~Oy)qO|)rOP$laX$lag$lak$laz$la!e$la!f$la!h$la!l$la#g$la#h$la#i$la#j$la#k$la#l$la#m$la#n$la#o$la#q$la#s$la#u$la#v$la#y$la(R$la(b$la(i$la(j$la!V$la!W$la~Oy)qO|)rOP$naX$nag$nak$naz$na!e$na!f$na!h$na!l$na#g$na#h$na#i$na#j$na#k$na#l$na#m$na#n$na#o$na#q$na#s$na#u$na#v$na#y$na(R$na(b$na(i$na(j$na!V$na!W$na~OP$|aX$|ak$|az$|a!e$|a!f$|a!h$|a!l$|a#g$|a#h$|a#i$|a#j$|a#k$|a#l$|a#m$|a#n$|a#o$|a#q$|a#s$|a#u$|a#v$|a#y$|a(R$|a(b$|a!V$|a!W$|a~P%>vO#y$hq!V$hq!W$hq~P#@_O#y$iq!V$iq!W$iq~P#@_O!W8RO~O#y8SO~P!0RO!a#rO!V'Zi!g'Zi~O!a#rO(b'bO!V'Zi!g'Zi~O!V/QO!g(oq~O!S']i!V']i~P#)tO!V/YO!S(pq~O!S8YO~P#)tO!S8YO~Od(Py!V(Py~P!0RO!V'`a!X'`a~P#)tO^%Tq!X%Tq'k%Tq!V%Tq~P#)tOX8_O~O!V0YO!W(wq~O#X8cO!V'ba!W'ba~O!V4iO!W(ti~P#@_OPYXXYXkYXyYXzYX|YX!SYX!VYX!eYX!fYX!hYX!lYX#XYX#dcX#gYX#hYX#iYX#jYX#kYX#lYX#mYX#nYX#oYX#qYX#sYX#uYX#vYX#{YX(RYX(bYX(iYX(jYX~O!a%RX#o%RX~P&/vO!X0uO%a8gO~O'vTO'yUO(U8lO~O!V1QO!W(uq~O!g8oO~O!g8oO~P%QO!g8qO~O!g8rO~O#X8tO!V#ay!W#ay~O!V#ay!W#ay~P#@_O!X'QO%a8yO~O#y#wy!V#wy!W#wy~P#@_OP$uiX$uik$uiz$ui!e$ui!f$ui!h$ui!l$ui#g$ui#h$ui#i$ui#j$ui#k$ui#l$ui#m$ui#n$ui#o$ui#q$ui#s$ui#u$ui#v$ui#y$ui(R$ui(b$ui!V$ui!W$ui~P%>vOy)qO|)rO(j)vOP%XiX%Xig%Xik%Xiz%Xi!e%Xi!f%Xi!h%Xi!l%Xi#g%Xi#h%Xi#i%Xi#j%Xi#k%Xi#l%Xi#m%Xi#n%Xi#o%Xi#q%Xi#s%Xi#u%Xi#v%Xi#y%Xi(R%Xi(b%Xi(i%Xi!V%Xi!W%Xi~Oy)qO|)rOP%ZiX%Zig%Zik%Ziz%Zi!e%Zi!f%Zi!h%Zi!l%Zi#g%Zi#h%Zi#i%Zi#j%Zi#k%Zi#l%Zi#m%Zi#n%Zi#o%Zi#q%Zi#s%Zi#u%Zi#v%Zi#y%Zi(R%Zi(b%Zi(i%Zi(j%Zi!V%Zi!W%Zi~O#y$iy!V$iy!W$iy~P#@_O#y#[y!V#[y!W#[y~P#@_O!a#rO!V'Zq!g'Zq~O!V/QO!g(oy~O!S']q!V']q~P#)tO!S9QO~P#)tO!V0YO!W(wy~O!V4iO!W(tq~O!X0uO%a9XO~O!g9[O~O!X'QO%a9aO~OP$uqX$uqk$uqz$uq!e$uq!f$uq!h$uq!l$uq#g$uq#h$uq#i$uq#j$uq#k$uq#l$uq#m$uq#n$uq#o$uq#q$uq#s$uq#u$uq#v$uq#y$uq(R$uq(b$uq!V$uq!W$uq~P%>vOP$wqX$wqk$wqz$wq!e$wq!f$wq!h$wq!l$wq#g$wq#h$wq#i$wq#j$wq#k$wq#l$wq#m$wq#n$wq#o$wq#q$wq#s$wq#u$wq#v$wq#y$wq(R$wq(b$wq!V$wq!W$wq~P%>vOd%]!Z!V%]!Z#X%]!Z#y%]!Z~P!0RO!V'bq!W'bq~P#@_O!V#a!Z!W#a!Z~P#@_O#d%]!ZP%]!ZX%]!Z^%]!Zk%]!Zz%]!Z!V%]!Z!e%]!Z!f%]!Z!h%]!Z!l%]!Z#g%]!Z#h%]!Z#i%]!Z#j%]!Z#k%]!Z#l%]!Z#m%]!Z#n%]!Z#o%]!Z#q%]!Z#s%]!Z#u%]!Z#v%]!Z'k%]!Z(R%]!Z(b%]!Z!g%]!Z!S%]!Z'i%]!Z#X%]!Zo%]!Z!X%]!Z%a%]!Z!a%]!Z~P#)tOP%]!ZX%]!Zk%]!Zz%]!Z!e%]!Z!f%]!Z!h%]!Z!l%]!Z#g%]!Z#h%]!Z#i%]!Z#j%]!Z#k%]!Z#l%]!Z#m%]!Z#n%]!Z#o%]!Z#q%]!Z#s%]!Z#u%]!Z#v%]!Z#y%]!Z(R%]!Z(b%]!Z!V%]!Z!W%]!Z~P%>vOo(VX~P1gO'u!iO~P!)jO!ScX!VcX#XcX~P&/vOPYXXYXkYXyYXzYX|YX!VYX!VcX!eYX!fYX!hYX!lYX#XYX#XcX#dcX#gYX#hYX#iYX#jYX#kYX#lYX#mYX#nYX#oYX#qYX#sYX#uYX#vYX#{YX(RYX(bYX(iYX(jYX~O!acX!gYX!gcX(bcX~P&E^OP9lOQ9lOa;]Ob!fOikOk9lOlkOmkOskOu9lOw9lO|WO!QkO!RkO!XXO!c9oO!hZO!k9lO!l9lO!m9lO!o9pO!q9qO!t!eO$Q!hO$UfO't)PO'vTO'yUO(RVO(a[O(n;ZO~O!V:QO!W$ka~Oi%POk$qOl$pOm$pOs%QOu%ROw:WO|$xO!X$yO!c;bO!h$uO#c:^O$Q%VO$m:YO$o:[O$r%WO't(gO'vTO'yUO'}%OO(R$rO~O#p)WO~P&JSO!WYX!WcX~P&E^O#d9tO~O!a#rO#d9tO~O#X:UO~O#o9yO~O#X:`O!V(gX!W(gX~O#X:UO!V(eX!W(eX~O#d:aO~Od:cO~P!0RO#d:hO~O#d:iO~O!a#rO#d:jO~O!a#rO#d:aO~O#y:kO~P#@_O#d:lO~O#d:mO~O#d:nO~O#d:oO~O#d:pO~O#d:qO~O#y:rO~P!0RO#y:sO~P!0RO$U~!f!|!}#P#Q#T#b#c#n(n$m$o$r%U%`%a%b%h%j%m%n%p%r~'oR$U(n#h!R'm'u#il#g#jky'n(U'n't$W$Y$W~",goto:"$%Z({PPPP(|P)PP)aP*p.rPPPP5SPP5iP;d>iP>|P>|PPP>|P@lP>|P>|P>|P@pPP@uPA`PFUPPPFYPPPPFYIXPPPI_JYPFYPLgPPPPNuFYPPPFYPFYP!#TFYP!&g!'i!'rP!(e!(i!(ePPPPP!+r!'iPP!,`!-YP!/|FYFY!0R!3Z!7n!7n!;cPPP!;jFYPPPPPPPPPPP!>uP!@WPPFY!AePFYPFYFYFYFYPFY!BwPP!E}P!IPP!IT!I_!Ic!IcP!EzP!Ig!IgP!LiP!LmFYFY!Ls# t>|P>|P>|>|P##O>|>|#$x>|#'V>|#(y>|>|#)g#+c#+c#+g#+o#+c#+wP#+cP>|#,a>|#-i>|>|5SPPP#.tPP#/^#/^P#/^P#/s#/^PP#/yP#/pP#/p#0]#/p#0w#0}5P)P#1Q)PP#1X#1X#1XP)PP)PP)PP)PPP)PP#1_#1bP#1b)PP#1fP#1iP)PP)PP)PP)PP)PP)P)PPP#1o#1u#2P#2V#2]#2c#2i#2w#2}#3T#3_#3e#3o#4O#4U#4u#5X#5_#5e#5s#6Y#7j#7x#8O#8U#8[#8b#8l#8r#8x#9S#9f#9lPPPPPPPPPP#9rPPPPPPP#:f#=mP#>|#?T#?]PPPP#Cg#F]#Lr#Lu#Lx#Mq#Mt#Mw#NO#NWPP#N^#Nb$ Z$!Z$!_$!sPP$!w$!}$#RP$#U$#Y$#]$$R$$i$$n$$q$$t$$z$$}$%R$%VR!xRmpOXr!X#`%]&d&f&g&i,],b1b1eY!rQ'Q,}0u4pQ%ctQ%kwQ%rzQ&[!TS&x!c,uQ'W!fS'^!o!uS*Y$y*_Q+T%lQ+b%tQ+|&UQ,{'PQ-V'XQ-_'_Q/k*aQ1P+}R:_9p$zdOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$^$b%]%c%p&]&`&d&f&g&i&m&u'S'd't'v'|(T(i(m(q)p*s+g,X,],b-R-Z-i-o.].d/u/z0X0x1Y1Z1[1^1b1e1g2W2^2r4m4w5Z5]5^5p7U7Z7h7tS#m]9m!r)R$X$j&y)e,n,q.l1v3X4k5g8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^Q*j%SQ+Y%nQ,O&XQ,V&aQ.S:VQ0O*{Q0S*}Q0_+ZQ1X,TQ2f.PQ4Y0YQ5O1QQ5|2jQ6S:WQ6u4ZR7z5}&xkOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$X$^$b$j%]%c%p&]&`&a&d&f&g&i&m&u&y'S'd't'v'|(T(i(m(q)e)p*s*{+g,X,],b,n,q-R-Z-i-o.P.].d.l/u/z0X0x1Y1Z1[1^1b1e1g1v2W2^2j2r3X4k4m4w5Z5]5^5g5p5}7U7Z7h7t8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^t!kQ!o!r!u!v&x'P'Q'^'_'`,u,{,}-_0u4p4r$Y$pi#r#t$`$a$u$x%T%U%Y)l)u)w)x*P*V*e*f*z*}+l+o.O.Y/X/Y/[/w0l0o0w2i3a3k3s3y4Q4S4v5z6b6k7W7w8S8g8y9X9a:S:T:X:Y:Z:[:]:^:d:e:f:g:h:i:l:m:n:o:r:s;Z;c;d;g;hQ%uzQ&v!cS&|%w,xQ+Y%nS.x)r.zQ/v*nQ0_+ZQ0d+aQ1W,SQ1X,TQ4Y0YQ4c0fQ5R1SQ5S1VQ6u4ZQ6x4`Q7c5UQ8b6yR8m7`pmOXr!T!X#`%]&Z&d&f&g&i,],b1b1eR,Q&]&r^OPXYrstux!X!^!g!l#O#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$X$^$b$j%]%c%p&]&`&a&d&f&g&i&m&u'S'd'v'|(T(i(m(q)e)p*s*{+g,X,],b,n,q-R-Z-i-o.P.].d.l/u/z0X0x1Y1Z1[1^1b1e1g1v2W2^2j2r3X4k4m4w5Z5]5^5g5p5}7U7Z7h7t8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;];^[#XWZ#S#V&y'tQ%fvQ%jwS%oz%t!U%x|}#d#e#h%Z%v'}(X(Y(Z+e+f+h,Z,o-m-s-t-u-w1j2b2c5f5wQ&Q!RQ'T!eQ'V!fQ(b#oS)|$u*QS+S%k%lQ+W%nQ+w&SQ+{&US-U'W'XQ.R(cQ/U)}Q0W+TQ0^+ZQ0`+[Q0c+`Q0z+xS1O+|+}Q2S-VQ3b/QQ4X0YQ4]0]Q4b0eQ4}1PQ6_3cQ6t4ZQ6w4_Q8^6sR9S8_v$wi#t%T%U%Y)u)w*P*e*f.Y/X/w3a3y8S;Z;c;d!S%hw!f!q%j%k%l&w'V'W'X']'g*X+S+T,r-U-V-^/c0W1{2S2Z3uQ*|%fQ+m%}Q+p&OQ+z&UQ.Q(bQ0y+wU0}+{+|+}Q2k.RQ4x0zS4|1O1PQ7_4}!z;_#r$`$a$u$x)l)x*V*z*}+l+o.O/Y/[0l0o0w2i3k3s4Q4S4v5z6b6k7W7w8g8y9X9a:X:Z:]:d:f:h:l:n:r;g;hg;`:S:T:Y:[:^:e:g:i:m:o:sW$|i%O*g;ZS%}!O&ZQ&O!PQ&P!QR+k%{$Z${i#r#t$`$a$u$x%T%U%Y)l)u)w)x*P*V*e*f*z*}+l+o.O.Y/X/Y/[/w0l0o0w2i3a3k3s3y4Q4S4v5z6b6k7W7w8S8g8y9X9a:S:T:X:Y:Z:[:]:^:d:e:f:g:h:i:l:m:n:o:r:s;Z;c;d;g;hT)m$r)nV*k%S:V:WU&|!c%w,xS(p#v#wQ+_%qS-z(^(_Q0p+qQ3z/tR6}4i&xkOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$X$^$b$j%]%c%p&]&`&a&d&f&g&i&m&u&y'S'd't'v'|(T(i(m(q)e)p*s*{+g,X,],b,n,q-R-Z-i-o.P.].d.l/u/z0X0x1Y1Z1[1^1b1e1g1v2W2^2j2r3X4k4m4w5Z5]5^5g5p5}7U7Z7h7t8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^$i$]c#U#a%a%b%d's'y(e(l(t(u(v(w(x(y(z({(|(})O)Q)T)X)c*x+^,s-b-g-l-n.X._.c.e.f.g.v/x1q1t2U2]2q2v2w2x2y2z2{2|2}3O3P3Q3R3S3V3W3]4O4V5i5o5t6Q6R6W6X7P7n7r7{8P8Q8v9U9]9n;QT#PV#Q&ykOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$X$^$b$j%]%c%p&]&`&a&d&f&g&i&m&u&y'S'd't'v'|(T(i(m(q)e)p*s*{+g,X,],b,n,q-R-Z-i-o.P.].d.l/u/z0X0x1Y1Z1[1^1b1e1g1v2W2^2j2r3X4k4m4w5Z5]5^5g5p5}7U7Z7h7t8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^Q&z!cR1w,uv!kQ!c!o!r!u!v&x'P'Q'^'_'`,u,{,}-_0u4p4rS*X$y*_S/c*Y*aQ/l*bQ0r+sQ3u/kR3x/nlpOXr!X#`%]&d&f&g&i,],b1b1eQ&k![Q'h!tS(d#q9tQ+Q%iQ+u&QQ+v&RQ-S'UQ-a'aS.W(i:aS/y*s:jQ0U+RQ0t+tQ1i,dQ1k,eQ1s,pQ2Q-TQ2T-XS4P/z:pQ4T0VS4W0X:qQ5h1uQ5l2RQ5q2YQ6r4UQ7o5jQ7p5mQ7s5rR8s7l$d$[c#U#a%b%d's'y(e(l(t(u(v(w(x(y(z({(|(})O)Q)T)X)c*x+^,s-b-g-l-n.X._.c.f.g.v/x1q1t2U2]2q2v2w2x2y2z2{2|2}3O3P3Q3R3S3V3W3]4O4V5i5o5t6Q6R6W6X7P7n7r7{8P8Q8v9U9]9n;QS(a#l'ZU*d$z(h3US*w%a.eQ2g0OQ5y2fQ7y5|R8z7z$d$Zc#U#a%b%d's'y(e(l(t(u(v(w(x(y(z({(|(})O)Q)T)X)c*x+^,s-b-g-l-n.X._.c.f.g.v/x1q1t2U2]2q2v2w2x2y2z2{2|2}3O3P3Q3R3S3V3W3]4O4V5i5o5t6Q6R6W6X7P7n7r7{8P8Q8v9U9]9n;QS(`#l'ZS(r#w$[S*v%a.eS-{(_(aQ.h)SQ/{*wR2d-|&xkOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$X$^$b$j%]%c%p&]&`&a&d&f&g&i&m&u&y'S'd't'v'|(T(i(m(q)e)p*s*{+g,X,],b,n,q-R-Z-i-o.P.].d.l/u/z0X0x1Y1Z1[1^1b1e1g1v2W2^2j2r3X4k4m4w5Z5]5^5g5p5}7U7Z7h7t8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^S#m]9mQ&f!VQ&g!WQ&i!YQ&j!ZR1a,`Q'R!eQ*y%fQ-Q'TS-}(b*|Q2O-PW2h.Q.R/}0PQ5k2PU5x2e2g2kS7v5y5{S8x7x7yS9_8w8zQ9g9`R9j9hU!sQ'Q,}T4n0u4p!O_OXZ`r!T!X#`#d%Z%]&Z&]&d&f&g&i(Z,],b-t1b1e]!mQ!o'Q,}0u4pT#m]9m%UyOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$^$b%]%c%p&]&`&a&d&f&g&i&m&u'S'd't'v'|(T(i(m(q)p*s*{+g,X,],b-R-Z-i-o.P.].d/u/z0X0x1Y1Z1[1^1b1e1g2W2^2j2r4m4w5Z5]5^5p5}7U7Z7h7tS(p#v#wS-z(^(_!s:w$X$j&y)e,n,q.l1v3X4k5g8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^Y!qQ'Q,}0u4pQ']!oS'g!r!uS'i!v4rS-^'^'_Q-`'`R2Z-_Q'f!qS(V#c1_S-]']'iQ/T)|Q/a*XQ2[-`Q3g/US3p/b/lQ6^3bS6i3v3xQ8U6_R8]6lQ#sbQ'e!qS(U#c1_S(W#i*rQ*t%[Q+O%gQ+U%mU-[']'f'iQ-p(VQ/S)|Q/`*XQ/f*[Q0T+PQ0{+yS2X-]-`Q2a-xS3f/T/US3o/a/lQ3r/eQ3t/gQ4z0|Q5s2[Q6]3bQ6a3gS6e3p3xQ6j3wQ7]4{S8T6^6_Q8X6fQ8Z6iQ8j7^Q9O8UQ9P8YQ9R8]Q9Z8kQ9c9QQ:z:uQ;V;OR;W;PV!sQ'Q,}%UaOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$^$b%]%c%p&]&`&a&d&f&g&i&m&u'S'd't'v'|(T(i(m(q)p*s*{+g,X,],b-R-Z-i-o.P.].d/u/z0X0x1Y1Z1[1^1b1e1g2W2^2j2r4m4w5Z5]5^5p5}7U7Z7h7tS#sx!g!r:t$X$j&y)e,n,q.l1v3X4k5g8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^R:z;]%UbOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$^$b%]%c%p&]&`&a&d&f&g&i&m&u'S'd't'v'|(T(i(m(q)p*s*{+g,X,],b-R-Z-i-o.P.].d/u/z0X0x1Y1Z1[1^1b1e1g2W2^2j2r4m4w5Z5]5^5p5}7U7Z7h7tQ%[j!S%gw!f!q%j%k%l&w'V'W'X']'g*X+S+T,r-U-V-^/c0W1{2S2Z3uS%mx!gQ+P%hQ+y&UW0|+z+{+|+}U4{0}1O1PS7^4|4}Q8k7_!r:u$X$j&y)e,n,q.l1v3X4k5g8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^Q;O;[R;P;]$xeOPXYrstu!X!^!l#O#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$^$b%]%c%p&]&`&d&f&g&i&m&u'S'd'v'|(T(i(m(q)p*s*{+g,X,],b-R-Z-i-o.P.].d/u/z0X0x1Y1Z1[1^1b1e1g2W2^2j2r4m4w5Z5]5^5p5}7U7Z7h7tY#^WZ#S#V't!U%x|}#d#e#h%Z%v'}(X(Y(Z+e+f+h,Z,o-m-s-t-u-w1j2b2c5f5wQ,W&a!p:v$X$j)e,n,q.l1v3X4k5g8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^R:y&yS&}!c%wR1y,x$zdOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$^$b%]%c%p&]&`&d&f&g&i&m&u'S'd't'v'|(T(i(m(q)p*s+g,X,],b-R-Z-i-o.].d/u/z0X0x1Y1Z1[1^1b1e1g2W2^2r4m4w5Z5]5^5p7U7Z7h7t!r)R$X$j&y)e,n,q.l1v3X4k5g8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^Q,V&aQ0O*{Q2f.PQ5|2jR7z5}!f$Rc#U%a's'y(e(l({(|(})O)T)X+^-b-g-l-n.X._.v/x2U2]2q3S4O4V5o5t6Q7r8v9n!T9{)Q)c,s.e1q1t2v3O3P3Q3R3V3]5i6R6W6X7P7n7{8P8Q9U9];Q!b$Tc#U%a's'y(e(l(})O)T)X+^-b-g-l-n.X._.v/x2U2]2q3S4O4V5o5t6Q7r8v9n!P9})Q)c,s.e1q1t2v3Q3R3V3]5i6R6W6X7P7n7{8P8Q9U9];Q!^$Xc#U%a's'y(e(l)T)X+^-b-g-l-n.X._.v/x2U2]2q3S4O4V5o5t6Q7r8v9nQ3a/Oz;^)Q)c,s.e1q1t2v3V3]5i6R6W6X7P7n7{8P8Q9U9];QQ;c;eR;d;f&xkOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$X$^$b$j%]%c%p&]&`&a&d&f&g&i&m&u&y'S'd't'v'|(T(i(m(q)e)p*s*{+g,X,],b,n,q-R-Z-i-o.P.].d.l/u/z0X0x1Y1Z1[1^1b1e1g1v2W2^2j2r3X4k4m4w5Z5]5^5g5p5}7U7Z7h7t8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^S$kh$lR3Y.k'PgOPWXYZhrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$X$^$b$j$l%]%c%p&]&`&a&d&f&g&i&m&u&y'S'd't'v'|(T(i(m(q)e)p*s*{+g,X,],b,n,q-R-Z-i-o.P.].d.k.l/u/z0X0x1Y1Z1[1^1b1e1g1v2W2^2j2r3X4k4m4w5Z5]5^5g5p5}7U7Z7h7t8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^T$gf$mQ$efS)[$h)`R)h$mT$ff$mT)^$h)`'PhOPWXYZhrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$X$^$b$j$l%]%c%p&]&`&a&d&f&g&i&m&u&y'S'd't'v'|(T(i(m(q)e)p*s*{+g,X,],b,n,q-R-Z-i-o.P.].d.k.l/u/z0X0x1Y1Z1[1^1b1e1g1v2W2^2j2r3X4k4m4w5Z5]5^5g5p5}7U7Z7h7t8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^T$kh$lQ$nhR)g$l%UjOPWXYZrstu!X!^!l#O#S#V#`#k#q#u#x#{#|#}$O$P$Q$R$S$T$U$V$^$b%]%c%p&]&`&a&d&f&g&i&m&u'S'd't'v'|(T(i(m(q)p*s*{+g,X,],b-R-Z-i-o.P.].d/u/z0X0x1Y1Z1[1^1b1e1g2W2^2j2r4m4w5Z5]5^5p5}7U7Z7h7t!s;[$X$j&y)e,n,q.l1v3X4k5g8c8t9l9o9p9q9t9u9v9w9x9y9z9{9|9}:O:P:Q:U:_:`:a:c:j:k:p:q;^#alOPXZr!X!^!l#O#`#k#x$j%]&]&`&a&d&f&g&i&m&u'S(q)e*{+g,X,],b-R.P.l/u0x1Y1Z1[1^1b1e1g2j3X4m4w5Z5]5^5}7U7Z7hv$zi#t%T%U%Y)u)w*P*e*f.Y/X/w3a3y8S;Z;c;d!z(h#r$`$a$u$x)l)x*V*z*}+l+o.O/Y/[0l0o0w2i3k3s4Q4S4v5z6b6k7W7w8g8y9X9a:X:Z:]:d:f:h:l:n:r;g;hQ*o%WQ.w)qg3U:S:T:Y:[:^:e:g:i:m:o:sv$vi#t%T%U%Y)u)w*P*e*f.Y/X/w3a3y8S;Z;c;dQ*R$wS*[$y*_Q*p%XQ/g*]!z:|#r$`$a$u$x)l)x*V*z*}+l+o.O/Y/[0l0o0w2i3k3s4Q4S4v5z6b6k7W7w8g8y9X9a:X:Z:]:d:f:h:l:n:r;g;hf:}:S:T:Y:[:^:e:g:i:m:o:sQ;R;_Q;S;`Q;T;aR;U;bv$zi#t%T%U%Y)u)w*P*e*f.Y/X/w3a3y8S;Z;c;d!z(h#r$`$a$u$x)l)x*V*z*}+l+o.O/Y/[0l0o0w2i3k3s4Q4S4v5z6b6k7W7w8g8y9X9a:X:Z:]:d:f:h:l:n:r;g;hg3U:S:T:Y:[:^:e:g:i:m:o:slnOXr!X#`%]&d&f&g&i,],b1b1eQ*U$xQ,k&pQ,l&rR3j/Y$Y${i#r#t$`$a$u$x%T%U%Y)l)u)w)x*P*V*e*f*z*}+l+o.O.Y/X/Y/[/w0l0o0w2i3a3k3s3y4Q4S4v5z6b6k7W7w8S8g8y9X9a:S:T:X:Y:Z:[:]:^:d:e:f:g:h:i:l:m:n:o:r:s;Z;c;d;g;hQ+n&OQ0n+pQ4g0mR6|4hT*^$y*_S*^$y*_T4o0u4pS/e*Z4mT3w/m7UQ+O%gQ/f*[Q0T+PQ0{+yQ4z0|Q7]4{Q8j7^R9Z8kn)u$s(j*q/W/o/p2o3h3}6[6m8}:{;X;Y!W:d(f)V){*T.V.s/O/]/|0k0m2n3i3m4f4h6O6P6c6g6o6q8W8[9b;e;f]:e3T6V7|8{8|9kp)w$s(j*q.|/W/o/p2o3h3}6[6m8}:{;X;Y!Y:f(f)V){*T.V.s/O/]/|0k0m2l2n3i3m4f4h6O6P6c6g6o6q8W8[9b;e;f_:g3T6V7|7}8{8|9kpmOXr!T!X#`%]&Z&d&f&g&i,],b1b1eQ&W!SR,X&apmOXr!T!X#`%]&Z&d&f&g&i,],b1b1eR&W!SQ+r&PR0j+kqmOXr!T!X#`%]&Z&d&f&g&i,],b1b1eQ0v+wS4u0y0zU7V4s4t4xS8f7X7YS9V8e8hQ9d9WR9i9eQ&_!TR,R&ZR5R1SS%oz%tR0`+[Q&d!UR,]&eR,c&jT1c,b1eR,g&kQ,f&kR1l,gQ'k!wR-c'kQrOQ#`XT%`r#`Q!zTR'm!zQ!}UR'o!}Q)n$rR.t)nQ#QVR'q#QQ#TWU'w#T'x-jQ'x#UR-j'yQ,v&zR1x,vQ.Z(jR2p.ZQ.^(lS2s.^2tR2t._Q,}'QR1|,}Y!oQ'Q,}0u4pR'[!oS#ZW%vU(O#Z(P-kQ(P#[R-k'zQ,y&}R1z,yr`OXr!T!X#`%]&Z&]&d&f&g&i,],b1b1eS#dZ%ZU#n`#d-tR-t(ZQ([#fQ-q(WW-y([-q2_5uQ2_-rR5u2`Q)`$hR.m)`Q$lhR)f$lQ$_cU)U$_-f:RQ-f9nR:R)cQ/R)|W3d/R3e6`8VU3e/S/T/US6`3f3gR8V6a#m)s$s(f(j)V){*T*l*m*q.T.U.V.s.|.}/O/W/]/o/p/|0k0m2l2m2n2o3T3h3i3m3}4f4h6O6P6T6U6V6[6c6g6m6o6q7|7}8O8W8[8{8|8}9b9k:{;X;Y;e;fQ/Z*TU3l/Z3n6dQ3n/]R6d3mQ*_$yR/i*_Q*h$}R/r*hQ4R/|R6p4RQ+i%yR0i+iQ4j0pS7O4j8dR8d7PQ+t&QR0s+tQ4p0uR7S4pQ1R,OS5P1R7aR7a5RQ0Z+WW4[0Z4^6v8`Q4^0^Q6v4]R8`6wQ+]%oR0a+]Q1e,bR5a1eWqOXr#`Q&h!XQ*u%]Q,[&dQ,^&fQ,_&gQ,a&iQ1`,]S1c,b1eR5`1bQ%_oQ&l!]Q&o!_Q&q!`Q&s!aQ'c!qQ+Q%iQ+d%uQ+j%zQ,Q&_Q,i&nW-Y']'e'f'iQ-a'aQ/h*^Q0U+RS1U,R,UQ1m,hQ1n,kQ1o,lQ2T-XW2V-[-]-`-bQ4T0VQ4a0dQ4e0kQ4y0{Q5T1WQ5_1aU5n2U2X2[Q5q2YQ6r4UQ6z4cQ6{4fQ7R4oQ7[4zQ7b5SS7q5o5sQ7s5rQ8a6xQ8i7]Q8n7cQ8u7rQ9T8bQ9Y8jQ9^8vR9f9ZQ%iwQ'U!fQ'a!qU+R%j%k%lQ,p&wU-T'V'W'XS-X']'gQ/_*XS0V+S+TQ1u,rS2R-U-VQ2Y-^Q3q/cQ4U0WQ5j1{Q5m2SQ5r2ZR6h3uS$ti;ZR*i%OU$}i%O;ZR/q*gQ$siS(f#r*}Q(j#tS)V$`$aQ){$uQ*T$xQ*l%TQ*m%UQ*q%YQ.T:XQ.U:ZQ.V:]Q.s)lQ.|)uQ.})wQ/O)xQ/W*PQ/]*VQ/o*eQ/p*fh/|*z.O0w2i4v5z7W7w8g8y9X9aQ0k+lQ0m+oQ2l:dQ2m:fQ2n:hQ2o.YS3T:S:TQ3h/XQ3i/YQ3m/[Q3}/wQ4f0lQ4h0oQ6O:lQ6P:nQ6T:YQ6U:[Q6V:^Q6[3aQ6c3kQ6g3sQ6m3yQ6o4QQ6q4SQ7|:iQ7}:eQ8O:gQ8W6bQ8[6kQ8{:mQ8|:oQ8}8SQ9b:rQ9k:sQ:{;ZQ;X;cQ;Y;dQ;e;gR;f;hloOXr!X#`%]&d&f&g&i,],b1b1eQ!dPS#bZ#kQ&n!^U'Y!l4m7UQ'p#OQ(s#xQ)d$jS,U&]&`Q,Y&aQ,h&mQ,m&uQ-P'SQ.a(qQ.q)eQ0P*{Q0g+gQ1],XQ2P-RQ2g.PQ3[.lQ3{/uQ4t0xQ5V1YQ5W1ZQ5Y1[Q5[1^Q5c1gQ5y2jQ6Y3XQ7Y4wQ7g5ZQ7i5]Q7j5^Q7y5}Q8h7ZR8p7h#UcOPXZr!X!^!l#`#k#x%]&]&`&a&d&f&g&i&m&u'S(q*{+g,X,],b-R.P/u0x1Y1Z1[1^1b1e1g2j4m4w5Z5]5^5}7U7Z7hQ#UWQ#aYQ%asQ%btQ%duS's#S'vQ'y#VQ(e#qQ(l#uQ(t#{Q(u#|Q(v#}Q(w$OQ(x$PQ(y$QQ(z$RQ({$SQ(|$TQ(}$UQ)O$VQ)Q$XQ)T$^Q)X$bW)c$j)e.l3XQ*x%cQ+^%pS,s&y1vQ-b'dS-g't-iQ-l'|Q-n(TQ.X(iQ._(mQ.c9lQ.e9oQ.f9pQ.g9qQ.v)pQ/x*sQ1q,nQ1t,qQ2U-ZQ2]-oQ2q.]Q2v9tQ2w9uQ2x9vQ2y9wQ2z9xQ2{9yQ2|9zQ2}9{Q3O9|Q3P9}Q3Q:OQ3R:PQ3S.dQ3V:UQ3W:_Q3]:QQ4O/zQ4V0XQ5i:`Q5o2WQ5t2^Q6Q2rQ6R:aQ6W:cQ6X:jQ7P4kQ7n5gQ7r5pQ7{:kQ8P:pQ8Q:qQ8v7tQ9U8cQ9]8tQ9n#OR;Q;^R#WWR&{!cY!qQ'Q,}0u4pS&w!c,uQ']!oS'g!r!uS'i!v4rS,r&x'PS-^'^'_Q-`'`Q1{,{R2Z-_R(k#tR(n#uQ!dQT,|'Q,}]!nQ!o'Q,}0u4pQ#l]R'Z9mT#gZ%ZS#fZ%ZU%y|},ZU(W#d#e#hS-r(X(YQ-v(ZQ0h+hQ2`-sU2a-t-u-wS5v2b2cR7u5w`#YW#S#V%v't'}+e-mt#cZ|}#d#e#h%Z(X(Y(Z+h-s-t-u-w2b2c5wQ1_,ZQ1r,oQ5e1jQ7m5fT:x&y+fT#]W%vS#[W%vS'u#S'}S'z#V+eS,t&y+fT-h't-mT'O!c%wQ$hfR)j$mT)_$h)`R3Z.kT*O$u*QR*W$xQ/}*zQ2e.OQ4s0wQ5{2iQ7X4vQ7x5zQ8e7WQ8w7wQ9W8gQ9`8yQ9e9XR9h9alpOXr!X#`%]&d&f&g&i,],b1b1eQ&^!TR,Q&ZV%z|},ZR0q+qR,P&XQ%szR+c%tR+X%nT&b!U&eT&c!U&eT1d,b1e",nodeNames:"⚠ ArithOp ArithOp LineComment BlockComment Script ExportDeclaration export Star as VariableName String Escape from ; default FunctionDeclaration async function VariableDefinition > TypeParamList TypeDefinition extends ThisType this LiteralType ArithOp Number BooleanLiteral TemplateType InterpolationEnd Interpolation InterpolationStart NullType null VoidType void TypeofType typeof MemberExpression . ?. PropertyName [ TemplateString Escape Interpolation super RegExp ] ArrayExpression Spread , } { ObjectExpression Property async get set PropertyDefinition Block : NewExpression new TypeArgList CompareOp < ) ( ArgList UnaryExpression delete LogicOp BitOp YieldExpression yield AwaitExpression await ParenthesizedExpression ClassExpression class ClassBody MethodDeclaration Decorator @ MemberExpression PrivatePropertyName CallExpression declare Privacy static abstract override PrivatePropertyDefinition PropertyDeclaration readonly accessor Optional TypeAnnotation Equals StaticBlock FunctionExpression ArrowFunction ParamList ParamList ArrayPattern ObjectPattern PatternProperty Privacy readonly Arrow MemberExpression BinaryExpression ArithOp ArithOp ArithOp ArithOp BitOp CompareOp instanceof satisfies in const CompareOp BitOp BitOp BitOp LogicOp LogicOp ConditionalExpression LogicOp LogicOp AssignmentExpression UpdateOp PostfixExpression CallExpression TaggedTemplateExpression DynamicImport import ImportMeta JSXElement JSXSelfCloseEndTag JSXStartTag JSXSelfClosingTag JSXIdentifier JSXBuiltin JSXIdentifier JSXNamespacedName JSXMemberExpression JSXSpreadAttribute JSXAttribute JSXAttributeValue JSXEscape JSXEndTag JSXOpenTag JSXFragmentTag JSXText JSXEscape JSXStartCloseTag JSXCloseTag PrefixCast ArrowFunction TypeParamList SequenceExpression KeyofType keyof UniqueType unique ImportType InferredType infer TypeName ParenthesizedType FunctionSignature ParamList NewSignature IndexedType TupleType Label ArrayType ReadonlyType ObjectType MethodType PropertyType IndexSignature PropertyDefinition CallSignature TypePredicate is NewSignature new UnionType LogicOp IntersectionType LogicOp ConditionalType ParameterizedType ClassDeclaration abstract implements type VariableDeclaration let var TypeAliasDeclaration InterfaceDeclaration interface EnumDeclaration enum EnumBody NamespaceDeclaration namespace module AmbientDeclaration declare GlobalDeclaration global ClassDeclaration ClassBody AmbientFunctionDeclaration ExportGroup VariableName VariableName ImportDeclaration ImportGroup ForStatement for ForSpec ForInSpec ForOfSpec of WhileStatement while WithStatement with DoStatement do IfStatement if else SwitchStatement switch SwitchBody CaseLabel case DefaultLabel TryStatement try CatchClause catch FinallyClause finally ReturnStatement return ThrowStatement throw BreakStatement break ContinueStatement continue DebuggerStatement debugger LabeledStatement ExpressionStatement SingleExpression SingleClassItem",maxTerm:364,context:trackNewline,nodeProps:[["group",-26,6,14,16,62,199,203,206,207,209,212,215,225,227,233,235,237,239,242,248,254,256,258,260,262,264,265,"Statement",-32,10,11,25,28,29,35,45,48,49,51,56,64,72,76,78,80,81,103,104,113,114,131,134,136,137,138,139,141,142,162,163,165,"Expression",-23,24,26,30,34,36,38,166,168,170,171,173,174,175,177,178,179,181,182,183,193,195,197,198,"Type",-3,84,96,102,"ClassItem"],["openedBy",31,"InterpolationStart",50,"[",54,"{",69,"(",143,"JSXStartTag",155,"JSXStartTag JSXStartCloseTag"],["closedBy",33,"InterpolationEnd",44,"]",55,"}",70,")",144,"JSXSelfCloseEndTag JSXEndTag",160,"JSXEndTag"]],propSources:[jsHighlight],skippedNodes:[0,3,4,268],repeatNodeCount:33,tokenData:"$>y(CSR!bOX%ZXY+gYZ-yZ[+g[]%Z]^.c^p%Zpq+gqr/mrs3cst:_tu>PuvBavwDxwxGgxyMvyz! Qz{!![{|!%O|}!&]}!O!%O!O!P!'g!P!Q!1w!Q!R#0t!R![#3T![!]#@T!]!^#Aa!^!_#Bk!_!`#GS!`!a#In!a!b#N{!b!c$$z!c!}>P!}#O$&U#O#P$'`#P#Q$,w#Q#R$.R#R#S>P#S#T$/`#T#o$0j#o#p$4z#p#q$5p#q#r$7Q#r#s$8^#s$f%Z$f$g+g$g#BY>P#BY#BZ$9h#BZ$IS>P$IS$I_$9h$I_$I|>P$I|$I}$<s$I}$JO$<s$JO$JT>P$JT$JU$9h$JU$KV>P$KV$KW$9h$KW&FU>P&FU&FV$9h&FV;'S>P;'S;=`BZ<%l?HT>P?HT?HU$9h?HUO>P(n%d_$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z&j&hT$d&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c&j&zP;=`<%l&c'|'U]$d&j'z!bOY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}!b(SU'z!bOY'}Zw'}x#O'}#P;'S'};'S;=`(f<%lO'}!b(iP;=`<%l'}'|(oP;=`<%l&}'[(y]$d&j'wpOY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(rp)wU'wpOY)rZr)rs#O)r#P;'S)r;'S;=`*Z<%lO)rp*^P;=`<%l)r'[*dP;=`<%l(r#S*nX'wp'z!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g#S+^P;=`<%l*g(n+dP;=`<%l%Z(CS+rq$d&j'wp'z!b'm(;dOX%ZXY+gYZ&cZ[+g[p%Zpq+gqr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p$f%Z$f$g+g$g#BY%Z#BY#BZ+g#BZ$IS%Z$IS$I_+g$I_$JT%Z$JT$JU+g$JU$KV%Z$KV$KW+g$KW&FU%Z&FU&FV+g&FV;'S%Z;'S;=`+a<%l?HT%Z?HT?HU+g?HUO%Z(CS.ST'x#S$d&j'n(;dO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c(CS.n_$d&j'wp'z!b'n(;dOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#`/x`$d&j!l$Ip'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`0z!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#S1V`#q$Id$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`2X!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#S2d_#q$Id$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$2b3l_'v$(n$d&j'z!bOY4kYZ5qZr4krs7nsw4kwx5qx!^4k!^!_8p!_#O4k#O#P5q#P#o4k#o#p8p#p;'S4k;'S;=`:X<%lO4k*r4r_$d&j'z!bOY4kYZ5qZr4krs7nsw4kwx5qx!^4k!^!_8p!_#O4k#O#P5q#P#o4k#o#p8p#p;'S4k;'S;=`:X<%lO4k)`5vX$d&jOr5qrs6cs!^5q!^!_6y!_#o5q#o#p6y#p;'S5q;'S;=`7h<%lO5q)`6jT$_#t$d&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c#t6|TOr6yrs7]s;'S6y;'S;=`7b<%lO6y#t7bO$_#t#t7eP;=`<%l6y)`7kP;=`<%l5q*r7w]$_#t$d&j'z!bOY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}%W8uZ'z!bOY8pYZ6yZr8prs9hsw8pwx6yx#O8p#O#P6y#P;'S8p;'S;=`:R<%lO8p%W9oU$_#t'z!bOY'}Zw'}x#O'}#P;'S'};'S;=`(f<%lO'}%W:UP;=`<%l8p*r:[P;=`<%l4k#%|:hg$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}st%Ztu<Puw%Zwx(rx!^%Z!^!_*g!_!c%Z!c!}<P!}#O%Z#O#P&c#P#R%Z#R#S<P#S#T%Z#T#o<P#o#p*g#p$g%Z$g;'S<P;'S;=`=y<%lO<P#%|<[i$d&j(a!L^'wp'z!bOY%ZYZ&cZr%Zrs&}st%Ztu<Puw%Zwx(rx!Q%Z!Q![<P![!^%Z!^!_*g!_!c%Z!c!}<P!}#O%Z#O#P&c#P#R%Z#R#S<P#S#T%Z#T#o<P#o#p*g#p$g%Z$g;'S<P;'S;=`=y<%lO<P#%|=|P;=`<%l<P(CS>`k$d&j'wp'z!b(U!LY't&;d$W#tOY%ZYZ&cZr%Zrs&}st%Ztu>Puw%Zwx(rx}%Z}!O@T!O!Q%Z!Q![>P![!^%Z!^!_*g!_!c%Z!c!}>P!}#O%Z#O#P&c#P#R%Z#R#S>P#S#T%Z#T#o>P#o#p*g#p$g%Z$g;'S>P;'S;=`BZ<%lO>P+d@`k$d&j'wp'z!b$W#tOY%ZYZ&cZr%Zrs&}st%Ztu@Tuw%Zwx(rx}%Z}!O@T!O!Q%Z!Q![@T![!^%Z!^!_*g!_!c%Z!c!}@T!}#O%Z#O#P&c#P#R%Z#R#S@T#S#T%Z#T#o@T#o#p*g#p$g%Z$g;'S@T;'S;=`BT<%lO@T+dBWP;=`<%l@T(CSB^P;=`<%l>P%#SBl`$d&j'wp'z!b#i$IdOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#SCy_$d&j#{$Id'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%DfETa(j%<v$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sv%ZvwFYwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#SFe`$d&j#u$Id'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$2bGp_'y$)`$d&j'wpOYHoYZIuZrHorsIuswHowxKVx!^Ho!^!_LX!_#OHo#O#PIu#P#oHo#o#pLX#p;'SHo;'S;=`Mp<%lOHo*QHv_$d&j'wpOYHoYZIuZrHorsIuswHowxKVx!^Ho!^!_LX!_#OHo#O#PIu#P#oHo#o#pLX#p;'SHo;'S;=`Mp<%lOHo)`IzX$d&jOwIuwx6cx!^Iu!^!_Jg!_#oIu#o#pJg#p;'SIu;'S;=`KP<%lOIu#tJjTOwJgwx7]x;'SJg;'S;=`Jy<%lOJg#tJ|P;=`<%lJg)`KSP;=`<%lIu*QK`]$_#t$d&j'wpOY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(r$fL^Z'wpOYLXYZJgZrLXrsJgswLXwxMPx#OLX#O#PJg#P;'SLX;'S;=`Mj<%lOLX$fMWU$_#t'wpOY)rZr)rs#O)r#P;'S)r;'S;=`*Z<%lO)r$fMmP;=`<%lLX*QMsP;=`<%lHo(*QNR_!h(!b$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z!'l! ]_!gM|$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'+h!!ib$d&j'wp'z!b'u#)d#j$IdOY%ZYZ&cZr%Zrs&}sw%Zwx(rxz%Zz{!#q{!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#S!#|`$d&j'wp'z!b#g$IdOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z&-O!%Z`$d&j'wp'z!bk&%`OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z&C[!&h_!V&;l$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(CS!'rc$d&j'wp'z!by'<nOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!(}!P!Q%Z!Q![!+g![!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z!'d!)Wa$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!*]!P!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z!'d!*h_!UMt$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l!+rg$d&j'wp'z!bl$'|OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!+g![!^%Z!^!_*g!_!g%Z!g!h!-Z!h#O%Z#O#P&c#P#R%Z#R#S!+g#S#X%Z#X#Y!-Z#Y#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l!-dg$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx{%Z{|!.{|}%Z}!O!.{!O!Q%Z!Q![!0a![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!0a#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l!/Uc$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!0a![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!0a#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l!0lc$d&j'wp'z!bl$'|OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!0a![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!0a#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(CS!2Sf$d&j'wp'z!b#h$IdOY!3hYZ&cZr!3hrs!4{sw!3hwx!C}xz!3hz{#$s{!P!3h!P!Q#&Y!Q!^!3h!^!_!Mh!_!`#-x!`!a#/_!a!}!3h!}#O##[#O#P!<w#P#o!3h#o#p!Mh#p;'S!3h;'S;=`#$m<%lO!3h(r!3sb$d&j'wp'z!b!RSOY!3hYZ&cZr!3hrs!4{sw!3hwx!C}x!P!3h!P!Q!Kh!Q!^!3h!^!_!Mh!_!}!3h!}#O##[#O#P!<w#P#o!3h#o#p!Mh#p;'S!3h;'S;=`#$m<%lO!3h(Q!5U`$d&j'z!b!RSOY!4{YZ&cZw!4{wx!6Wx!P!4{!P!Q!=o!Q!^!4{!^!_!?g!_!}!4{!}#O!Bn#O#P!<w#P#o!4{#o#p!?g#p;'S!4{;'S;=`!Cw<%lO!4{&n!6_^$d&j!RSOY!6WYZ&cZ!P!6W!P!Q!7Z!Q!^!6W!^!_!8g!_!}!6W!}#O!;U#O#P!<w#P#o!6W#o#p!8g#p;'S!6W;'S;=`!=i<%lO!6W&n!7ba$d&j!RSO!^&c!_#Z&c#Z#[!7Z#[#]&c#]#^!7Z#^#a&c#a#b!7Z#b#g&c#g#h!7Z#h#i&c#i#j!7Z#j#m&c#m#n!7Z#n#o&c#p;'S&c;'S;=`&w<%lO&cS!8lX!RSOY!8gZ!P!8g!P!Q!9X!Q!}!8g!}#O!9p#O#P!:o#P;'S!8g;'S;=`!;O<%lO!8gS!9^U!RS#Z#[!9X#]#^!9X#a#b!9X#g#h!9X#i#j!9X#m#n!9XS!9sVOY!9pZ#O!9p#O#P!:Y#P#Q!8g#Q;'S!9p;'S;=`!:i<%lO!9pS!:]SOY!9pZ;'S!9p;'S;=`!:i<%lO!9pS!:lP;=`<%l!9pS!:rSOY!8gZ;'S!8g;'S;=`!;O<%lO!8gS!;RP;=`<%l!8g&n!;Z[$d&jOY!;UYZ&cZ!^!;U!^!_!9p!_#O!;U#O#P!<P#P#Q!6W#Q#o!;U#o#p!9p#p;'S!;U;'S;=`!<q<%lO!;U&n!<UX$d&jOY!;UYZ&cZ!^!;U!^!_!9p!_#o!;U#o#p!9p#p;'S!;U;'S;=`!<q<%lO!;U&n!<tP;=`<%l!;U&n!<|X$d&jOY!6WYZ&cZ!^!6W!^!_!8g!_#o!6W#o#p!8g#p;'S!6W;'S;=`!=i<%lO!6W&n!=lP;=`<%l!6W(Q!=xi$d&j'z!b!RSOY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#Z&}#Z#[!=o#[#]&}#]#^!=o#^#a&}#a#b!=o#b#g&}#g#h!=o#h#i&}#i#j!=o#j#m&}#m#n!=o#n#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}!f!?nZ'z!b!RSOY!?gZw!?gwx!8gx!P!?g!P!Q!@a!Q!}!?g!}#O!Ap#O#P!:o#P;'S!?g;'S;=`!Bh<%lO!?g!f!@hb'z!b!RSOY'}Zw'}x#O'}#P#Z'}#Z#[!@a#[#]'}#]#^!@a#^#a'}#a#b!@a#b#g'}#g#h!@a#h#i'}#i#j!@a#j#m'}#m#n!@a#n;'S'};'S;=`(f<%lO'}!f!AuX'z!bOY!ApZw!Apwx!9px#O!Ap#O#P!:Y#P#Q!?g#Q;'S!Ap;'S;=`!Bb<%lO!Ap!f!BeP;=`<%l!Ap!f!BkP;=`<%l!?g(Q!Bu^$d&j'z!bOY!BnYZ&cZw!Bnwx!;Ux!^!Bn!^!_!Ap!_#O!Bn#O#P!<P#P#Q!4{#Q#o!Bn#o#p!Ap#p;'S!Bn;'S;=`!Cq<%lO!Bn(Q!CtP;=`<%l!Bn(Q!CzP;=`<%l!4{'`!DW`$d&j'wp!RSOY!C}YZ&cZr!C}rs!6Ws!P!C}!P!Q!EY!Q!^!C}!^!_!GQ!_!}!C}!}#O!JX#O#P!<w#P#o!C}#o#p!GQ#p;'S!C};'S;=`!Kb<%lO!C}'`!Eci$d&j'wp!RSOY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#Z(r#Z#[!EY#[#](r#]#^!EY#^#a(r#a#b!EY#b#g(r#g#h!EY#h#i(r#i#j!EY#j#m(r#m#n!EY#n#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(rt!GXZ'wp!RSOY!GQZr!GQrs!8gs!P!GQ!P!Q!Gz!Q!}!GQ!}#O!IZ#O#P!:o#P;'S!GQ;'S;=`!JR<%lO!GQt!HRb'wp!RSOY)rZr)rs#O)r#P#Z)r#Z#[!Gz#[#])r#]#^!Gz#^#a)r#a#b!Gz#b#g)r#g#h!Gz#h#i)r#i#j!Gz#j#m)r#m#n!Gz#n;'S)r;'S;=`*Z<%lO)rt!I`X'wpOY!IZZr!IZrs!9ps#O!IZ#O#P!:Y#P#Q!GQ#Q;'S!IZ;'S;=`!I{<%lO!IZt!JOP;=`<%l!IZt!JUP;=`<%l!GQ'`!J`^$d&j'wpOY!JXYZ&cZr!JXrs!;Us!^!JX!^!_!IZ!_#O!JX#O#P!<P#P#Q!C}#Q#o!JX#o#p!IZ#p;'S!JX;'S;=`!K[<%lO!JX'`!K_P;=`<%l!JX'`!KeP;=`<%l!C}(r!Ksk$d&j'wp'z!b!RSOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#Z%Z#Z#[!Kh#[#]%Z#]#^!Kh#^#a%Z#a#b!Kh#b#g%Z#g#h!Kh#h#i%Z#i#j!Kh#j#m%Z#m#n!Kh#n#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z#W!Mq]'wp'z!b!RSOY!MhZr!Mhrs!?gsw!Mhwx!GQx!P!Mh!P!Q!Nj!Q!}!Mh!}#O#!U#O#P!:o#P;'S!Mh;'S;=`##U<%lO!Mh#W!Nse'wp'z!b!RSOY*gZr*grs'}sw*gwx)rx#O*g#P#Z*g#Z#[!Nj#[#]*g#]#^!Nj#^#a*g#a#b!Nj#b#g*g#g#h!Nj#h#i*g#i#j!Nj#j#m*g#m#n!Nj#n;'S*g;'S;=`+Z<%lO*g#W#!]Z'wp'z!bOY#!UZr#!Urs!Apsw#!Uwx!IZx#O#!U#O#P!:Y#P#Q!Mh#Q;'S#!U;'S;=`##O<%lO#!U#W##RP;=`<%l#!U#W##XP;=`<%l!Mh(r##e`$d&j'wp'z!bOY##[YZ&cZr##[rs!Bnsw##[wx!JXx!^##[!^!_#!U!_#O##[#O#P!<P#P#Q!3h#Q#o##[#o#p#!U#p;'S##[;'S;=`#$g<%lO##[(r#$jP;=`<%l##[(r#$pP;=`<%l!3h(CS#%Qb$d&j'wp'z!b'o(;d!RSOY!3hYZ&cZr!3hrs!4{sw!3hwx!C}x!P!3h!P!Q!Kh!Q!^!3h!^!_!Mh!_!}!3h!}#O##[#O#P!<w#P#o!3h#o#p!Mh#p;'S!3h;'S;=`#$m<%lO!3h(CS#&e_$d&j'wp'z!bR(;dOY#&YYZ&cZr#&Yrs#'dsw#&Ywx#*tx!^#&Y!^!_#,s!_#O#&Y#O#P#(f#P#o#&Y#o#p#,s#p;'S#&Y;'S;=`#-r<%lO#&Y(Bb#'m]$d&j'z!bR(;dOY#'dYZ&cZw#'dwx#(fx!^#'d!^!_#)w!_#O#'d#O#P#(f#P#o#'d#o#p#)w#p;'S#'d;'S;=`#*n<%lO#'d(AO#(mX$d&jR(;dOY#(fYZ&cZ!^#(f!^!_#)Y!_#o#(f#o#p#)Y#p;'S#(f;'S;=`#)q<%lO#(f(;d#)_SR(;dOY#)YZ;'S#)Y;'S;=`#)k<%lO#)Y(;d#)nP;=`<%l#)Y(AO#)tP;=`<%l#(f(<v#*OW'z!bR(;dOY#)wZw#)wwx#)Yx#O#)w#O#P#)Y#P;'S#)w;'S;=`#*h<%lO#)w(<v#*kP;=`<%l#)w(Bb#*qP;=`<%l#'d(Ap#*}]$d&j'wpR(;dOY#*tYZ&cZr#*trs#(fs!^#*t!^!_#+v!_#O#*t#O#P#(f#P#o#*t#o#p#+v#p;'S#*t;'S;=`#,m<%lO#*t(<U#+}W'wpR(;dOY#+vZr#+vrs#)Ys#O#+v#O#P#)Y#P;'S#+v;'S;=`#,g<%lO#+v(<U#,jP;=`<%l#+v(Ap#,pP;=`<%l#*t(=h#,|Y'wp'z!bR(;dOY#,sZr#,srs#)wsw#,swx#+vx#O#,s#O#P#)Y#P;'S#,s;'S;=`#-l<%lO#,s(=h#-oP;=`<%l#,s(CS#-uP;=`<%l#&Y%#W#.Vb$d&j#{$Id'wp'z!b!RSOY!3hYZ&cZr!3hrs!4{sw!3hwx!C}x!P!3h!P!Q!Kh!Q!^!3h!^!_!Mh!_!}!3h!}#O##[#O#P!<w#P#o!3h#o#p!Mh#p;'S!3h;'S;=`#$m<%lO!3h+h#/lb$T#t$d&j'wp'z!b!RSOY!3hYZ&cZr!3hrs!4{sw!3hwx!C}x!P!3h!P!Q!Kh!Q!^!3h!^!_!Mh!_!}!3h!}#O##[#O#P!<w#P#o!3h#o#p!Mh#p;'S!3h;'S;=`#$m<%lO!3h$/l#1Pp$d&j'wp'z!bl$'|OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!+g!P!Q%Z!Q![#3T![!^%Z!^!_*g!_!g%Z!g!h!-Z!h#O%Z#O#P&c#P#R%Z#R#S#3T#S#U%Z#U#V#6_#V#X%Z#X#Y!-Z#Y#b%Z#b#c#5T#c#d#9g#d#l%Z#l#m#<i#m#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l#3`k$d&j'wp'z!bl$'|OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!+g!P!Q%Z!Q![#3T![!^%Z!^!_*g!_!g%Z!g!h!-Z!h#O%Z#O#P&c#P#R%Z#R#S#3T#S#X%Z#X#Y!-Z#Y#b%Z#b#c#5T#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l#5`_$d&j'wp'z!bl$'|OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l#6hd$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!R#7v!R!S#7v!S!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#7v#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l#8Rf$d&j'wp'z!bl$'|OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!R#7v!R!S#7v!S!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#7v#S#b%Z#b#c#5T#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l#9pc$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!Y#:{!Y!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#:{#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l#;We$d&j'wp'z!bl$'|OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!Y#:{!Y!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#:{#S#b%Z#b#c#5T#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l#<rg$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![#>Z![!^%Z!^!_*g!_!c%Z!c!i#>Z!i#O%Z#O#P&c#P#R%Z#R#S#>Z#S#T%Z#T#Z#>Z#Z#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z$/l#>fi$d&j'wp'z!bl$'|OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![#>Z![!^%Z!^!_*g!_!c%Z!c!i#>Z!i#O%Z#O#P&c#P#R%Z#R#S#>Z#S#T%Z#T#Z#>Z#Z#b%Z#b#c#5T#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%Gh#@b_!a$b$d&j#y%<f'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z)[#Al_^l$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(CS#Bz^'}!*v!e'.r'wp'z!b$U)d(nSOY*gZr*grs'}sw*gwx)rx!P*g!P!Q#Cv!Q!^*g!^!_#Dl!_!`#F^!`#O*g#P;'S*g;'S;=`+Z<%lO*g(n#DPX$f&j'wp'z!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g$Kh#DuZ#k$Id'wp'z!bOY*gZr*grs'}sw*gwx)rx!_*g!_!`#Eh!`#O*g#P;'S*g;'S;=`+Z<%lO*g$Kh#EqX#{$Id'wp'z!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g$Kh#FgX#l$Id'wp'z!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g%Gh#G_a#X%?x$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`0z!`!a#Hd!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#W#Ho_#d$Ih$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%Gh#I}adBf#l$Id$a#|$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`#KS!`!a#L^!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#S#K__#l$Id$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#S#Lia#k$Id$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`!a#Mn!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#S#My`#k$Id$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'+h$ Wc(b$Ip$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P$!c!P!^%Z!^!_*g!_!a%Z!a!b$#m!b#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'+`$!n_z'#p$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#S$#x`$d&j#v$Id'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z#&^$%V_!x!Ln$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(@^$&a_|(8n$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(n$'eZ$d&jO!^$(W!^!_$(n!_#i$(W#i#j$(s#j#l$(W#l#m$*f#m#o$(W#o#p$(n#p;'S$(W;'S;=`$,q<%lO$(W(n$(_T[#S$d&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c#S$(sO[#S(n$(x[$d&jO!Q&c!Q![$)n![!^&c!_!c&c!c!i$)n!i#T&c#T#Z$)n#Z#o&c#o#p$,U#p;'S&c;'S;=`&w<%lO&c(n$)sZ$d&jO!Q&c!Q![$*f![!^&c!_!c&c!c!i$*f!i#T&c#T#Z$*f#Z#o&c#p;'S&c;'S;=`&w<%lO&c(n$*kZ$d&jO!Q&c!Q![$+^![!^&c!_!c&c!c!i$+^!i#T&c#T#Z$+^#Z#o&c#p;'S&c;'S;=`&w<%lO&c(n$+cZ$d&jO!Q&c!Q![$(W![!^&c!_!c&c!c!i$(W!i#T&c#T#Z$(W#Z#o&c#p;'S&c;'S;=`&w<%lO&c#S$,XR!Q![$,b!c!i$,b#T#Z$,b#S$,eS!Q![$,b!c!i$,b#T#Z$,b#q#r$(n(n$,tP;=`<%l$(W!'l$-S_!SM|$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#S$.^`#s$Id$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z&,v$/k_$d&j'wp'z!b(R&%WOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(CS$0yk$d&j'wp'z!b(U!LY't&;d$Y#tOY%ZYZ&cZr%Zrs&}st%Ztu$0juw%Zwx(rx}%Z}!O$2n!O!Q%Z!Q![$0j![!^%Z!^!_*g!_!c%Z!c!}$0j!}#O%Z#O#P&c#P#R%Z#R#S$0j#S#T%Z#T#o$0j#o#p*g#p$g%Z$g;'S$0j;'S;=`$4t<%lO$0j+d$2yk$d&j'wp'z!b$Y#tOY%ZYZ&cZr%Zrs&}st%Ztu$2nuw%Zwx(rx}%Z}!O$2n!O!Q%Z!Q![$2n![!^%Z!^!_*g!_!c%Z!c!}$2n!}#O%Z#O#P&c#P#R%Z#R#S$2n#S#T%Z#T#o$2n#o#p*g#p$g%Z$g;'S$2n;'S;=`$4n<%lO$2n+d$4qP;=`<%l$2n(CS$4wP;=`<%l$0j!5p$5TX!X!3l'wp'z!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g%Df$5{a(i%<v$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Cn!`#O%Z#O#P&c#P#o%Z#o#p*g#p#q$#m#q;'S%Z;'S;=`+a<%lO%Z%#`$7__!W$I`o`$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(r$8i_!mS$d&j'wp'z!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(CS$9y|$d&j'wp'z!b'm(;d(U!LY't&;d$W#tOX%ZXY+gYZ&cZ[+g[p%Zpq+gqr%Zrs&}st%Ztu>Puw%Zwx(rx}%Z}!O@T!O!Q%Z!Q![>P![!^%Z!^!_*g!_!c%Z!c!}>P!}#O%Z#O#P&c#P#R%Z#R#S>P#S#T%Z#T#o>P#o#p*g#p$f%Z$f$g+g$g#BY>P#BY#BZ$9h#BZ$IS>P$IS$I_$9h$I_$JT>P$JT$JU$9h$JU$KV>P$KV$KW$9h$KW&FU>P&FU&FV$9h&FV;'S>P;'S;=`BZ<%l?HT>P?HT?HU$9h?HUO>P(CS$=Uk$d&j'wp'z!b'n(;d(U!LY't&;d$W#tOY%ZYZ&cZr%Zrs&}st%Ztu>Puw%Zwx(rx}%Z}!O@T!O!Q%Z!Q![>P![!^%Z!^!_*g!_!c%Z!c!}>P!}#O%Z#O#P&c#P#R%Z#R#S>P#S#T%Z#T#o>P#o#p*g#p$g%Z$g;'S>P;'S;=`BZ<%lO>P",tokenizers:[noSemicolon,incdecToken,2,3,4,5,6,7,8,9,10,11,12,13,insertSemicolon,new LocalTokenGroup("$S~RRtu[#O#Pg#S#T#|~_P#o#pb~gOq~~jVO#i!P#i#j!U#j#l!P#l#m!q#m;'S!P;'S;=`#v<%lO!P~!UO!O~~!XS!Q![!e!c!i!e#T#Z!e#o#p#Z~!hR!Q![!q!c!i!q#T#Z!q~!tR!Q![!}!c!i!}#T#Z!}~#QR!Q![!P!c!i!P#T#Z!P~#^R!Q![#g!c!i#g#T#Z#g~#jS!Q![#g!c!i#g#T#Z#g#q#r!P~#yP;=`<%l!P~$RO(T~~",141,326),new LocalTokenGroup("j~RQYZXz{^~^O'q~~aP!P!Qd~iO'r~~",25,308)],topRules:{Script:[0,5],SingleExpression:[1,266],SingleClassItem:[2,267]},dialects:{jsx:12686,ts:12688},dynamicPrecedences:{76:1,78:1,163:1,191:1},specialized:[{term:312,get:value=>spec_identifier[value]||-1},{term:328,get:value=>spec_word[value]||-1},{term:67,get:value=>spec_LessThan[value]||-1}],tokenPrec:12712}),snippets=[snippetCompletion("function ${name}(${params}) {\n\t${}\n}",{label:"function",detail:"definition",type:"keyword"}),snippetCompletion("for (let ${index} = 0; ${index} < ${bound}; ${index}++) {\n\t${}\n}",{label:"for",detail:"loop",type:"keyword"}),snippetCompletion("for (let ${name} of ${collection}) {\n\t${}\n}",{label:"for",detail:"of loop",type:"keyword"}),snippetCompletion("do {\n\t${}\n} while (${})",{label:"do",detail:"loop",type:"keyword"}),snippetCompletion("while (${}) {\n\t${}\n}",{label:"while",detail:"loop",type:"keyword"}),snippetCompletion("try {\n\t${}\n} catch (${error}) {\n\t${}\n}",{label:"try",detail:"/ catch block",type:"keyword"}),snippetCompletion("if (${}) {\n\t${}\n}",{label:"if",detail:"block",type:"keyword"}),snippetCompletion("if (${}) {\n\t${}\n} else {\n\t${}\n}",{label:"if",detail:"/ else block",type:"keyword"}),snippetCompletion("class ${name} {\n\tconstructor(${params}) {\n\t\t${}\n\t}\n}",{label:"class",detail:"definition",type:"keyword"}),snippetCompletion('import {${names}} from "${module}"\n${}',{label:"import",detail:"named",type:"keyword"}),snippetCompletion('import ${name} from "${module}"\n${}',{label:"import",detail:"default",type:"keyword"})],cache=new NodeWeakMap,ScopeNodes=new Set(["Script","Block","FunctionExpression","FunctionDeclaration","ArrowFunction","MethodDeclaration","ForStatement"]);function defID(type){return(node,def)=>{let id=node.node.getChild("VariableDefinition");return id&&def(id,type),!0}}const functionContext=["FunctionDeclaration"],gatherCompletions={FunctionDeclaration:defID("function"),ClassDeclaration:defID("class"),ClassExpression:()=>!0,EnumDeclaration:defID("constant"),TypeAliasDeclaration:defID("type"),NamespaceDeclaration:defID("namespace"),VariableDefinition(node,def){node.matchContext(functionContext)||def(node,"variable")},TypeDefinition(node,def){def(node,"type")},__proto__:null};function getScope(doc,node){let cached=cache.get(node);if(cached)return cached;let completions=[],top=!0;function def(node,type){let name=doc.sliceString(node.from,node.to);completions.push({label:name,type:type})}return node.cursor(IterMode.IncludeAnonymous).iterate((node=>{if(top)top=!1;else if(node.name){let gather=gatherCompletions[node.name];if(gather&&gather(node,def)||ScopeNodes.has(node.name))return!1}else if(node.to-node.from>8192){for(let c of getScope(doc,node.node))completions.push(c);return!1}})),cache.set(node,completions),completions}const Identifier$1=/^[\w$\xa1-\uffff][\w$\d\xa1-\uffff]*$/,dontComplete=["TemplateString","String","RegExp","LineComment","BlockComment","VariableDefinition","TypeDefinition","Label","PropertyDefinition","PropertyName","PrivatePropertyDefinition","PrivatePropertyName",".","?."];function localCompletionSource(context){let inner=syntaxTree(context.state).resolveInner(context.pos,-1);if(dontComplete.indexOf(inner.name)>-1)return null;let isWord="VariableName"==inner.name||inner.to-inner.from<20&&Identifier$1.test(context.state.sliceDoc(inner.from,inner.to));if(!isWord&&!context.explicit)return null;let options=[];for(let pos=inner;pos;pos=pos.parent)ScopeNodes.has(pos.name)&&(options=options.concat(getScope(context.state.doc,pos)));return{options:options,from:isWord?inner.from:context.pos,validFor:Identifier$1}}const javascriptLanguage=LRLanguage.define({name:"javascript",parser:parser$1.configure({props:[indentNodeProp.add({IfStatement:continuedIndent({except:/^\s*({|else\b)/}),TryStatement:continuedIndent({except:/^\s*({|catch\b|finally\b)/}),LabeledStatement:context=>context.baseIndent,SwitchBody:context=>{let after=context.textAfter,closed=/^\s*\}/.test(after),isCase=/^\s*(case|default)\b/.test(after);return context.baseIndent+(closed?0:isCase?1:2)*context.unit},Block:function(_ref8){let{closing:closing,align:align=!0,units:units=1}=_ref8;return context=>delimitedStrategy(context,align,units,closing)}({closing:"}"}),ArrowFunction:cx=>cx.baseIndent+cx.unit,"TemplateString BlockComment":()=>null,"Statement Property":continuedIndent({except:/^{/}),JSXElement(context){let closed=/^\s*<\//.test(context.textAfter);return context.lineIndent(context.node.from)+(closed?0:context.unit)},JSXEscape(context){let closed=/\s*\}/.test(context.textAfter);return context.lineIndent(context.node.from)+(closed?0:context.unit)},"JSXOpenTag JSXSelfClosingTag":context=>context.column(context.node.from)+context.unit}),foldNodeProp.add({"Block ClassBody SwitchBody EnumBody ObjectExpression ArrayExpression ObjectType":foldInside,BlockComment:tree=>({from:tree.from+2,to:tree.to-2})})]}),languageData:{closeBrackets:{brackets:["(","[","{","'",'"',"`"]},commentTokens:{line:"//",block:{open:"/*",close:"*/"}},indentOnInput:/^\s*(?:case |default:|\{|\}|<\/)$/,wordChars:"$"}}),jsxSublanguage={test:node=>/^JSX/.test(node.name),facet:defineLanguageFacet({commentTokens:{block:{open:"{/*",close:"*/}"}}})},typescriptLanguage=javascriptLanguage.configure({dialect:"ts"},"typescript"),jsxLanguage=javascriptLanguage.configure({dialect:"jsx",props:[sublanguageProp.add((n=>n.isTop?[jsxSublanguage]:void 0))]}),tsxLanguage=javascriptLanguage.configure({dialect:"jsx ts",props:[sublanguageProp.add((n=>n.isTop?[jsxSublanguage]:void 0))]},"typescript"),keywords="break case const continue default delete export extends false finally in instanceof let new return static super switch this throw true typeof var yield".split(" ").map((kw=>({label:kw,type:"keyword"})));function javascript(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},lang=config.jsx?config.typescript?tsxLanguage:jsxLanguage:config.typescript?typescriptLanguage:javascriptLanguage;return new LanguageSupport(lang,[javascriptLanguage.data.of({autocomplete:ifNotIn(dontComplete,completeFromList(snippets.concat(keywords)))}),javascriptLanguage.data.of({autocomplete:localCompletionSource}),config.jsx?autoCloseTags$1:[]])}function elementName$2(doc,tree){let max=arguments.length>2&&void 0!==arguments[2]?arguments[2]:doc.length;for(let ch=null==tree?void 0:tree.firstChild;ch;ch=ch.nextSibling)if("JSXIdentifier"==ch.name||"JSXBuiltin"==ch.name||"JSXNamespacedName"==ch.name||"JSXMemberExpression"==ch.name)return doc.sliceString(ch.from,Math.min(ch.to,max));return""}const android="object"==typeof navigator&&/Android\b/.test(navigator.userAgent),autoCloseTags$1=EditorView.inputHandler.of(((view,from,to,text)=>{if((android?view.composing:view.compositionStarted)||view.state.readOnly||from!=to||">"!=text&&"/"!=text||!javascriptLanguage.isActiveAt(view.state,from,-1))return!1;let{state:state}=view,changes=state.changeByRange((range=>{var _a;let name,{head:head}=range,around=syntaxTree(state).resolveInner(head,-1);if("JSXStartTag"==around.name&&(around=around.parent),"JSXAttributeValue"==around.name&&around.to>head);else{if(">"==text&&"JSXFragmentTag"==around.name)return{range:EditorSelection.cursor(head+1),changes:{from:head,insert:"></>"}};if("/"==text&&"JSXFragmentTag"==around.name){let empty=around.parent,base=null==empty?void 0:empty.parent;if(empty.from==head-1&&"JSXEndTag"!=(null===(_a=base.lastChild)||void 0===_a?void 0:_a.name)&&(name=elementName$2(state.doc,null==base?void 0:base.firstChild,head))){let insert="/".concat(name,">");return{range:EditorSelection.cursor(head+insert.length),changes:{from:head,insert:insert}}}}else if(">"==text){let openTag=function(node){for(;;){if("JSXOpenTag"==node.name||"JSXSelfClosingTag"==node.name||"JSXFragmentTag"==node.name)return node;if("JSXEscape"==node.name||!node.parent)return null;node=node.parent}}(around);if(openTag&&(!(node=openTag.lastChild)||"JSXEndTag"!=node.name&&"JSXSelfCloseEndTag"!=node.name)&&"</"!=state.sliceDoc(head,head+2)&&(name=elementName$2(state.doc,openTag,head)))return{range:EditorSelection.cursor(head+1),changes:{from:head,insert:"></".concat(name,">")}}}}var node;return{range:range}}));return!changes.changes.empty&&(view.dispatch(changes,{userEvent:"input.type",scrollIntoView:!0}),!0)})),Targets=["_blank","_self","_top","_parent"],Charsets=["ascii","utf-8","utf-16","latin1","latin1"],Methods=["get","post","put","delete"],Encs=["application/x-www-form-urlencoded","multipart/form-data","text/plain"],Bool=["true","false"],S={},Tags={a:{attrs:{href:null,ping:null,type:null,media:null,target:Targets,hreflang:null}},abbr:S,address:S,area:{attrs:{alt:null,coords:null,href:null,target:null,ping:null,media:null,hreflang:null,type:null,shape:["default","rect","circle","poly"]}},article:S,aside:S,audio:{attrs:{src:null,mediagroup:null,crossorigin:["anonymous","use-credentials"],preload:["none","metadata","auto"],autoplay:["autoplay"],loop:["loop"],controls:["controls"]}},b:S,base:{attrs:{href:null,target:Targets}},bdi:S,bdo:S,blockquote:{attrs:{cite:null}},body:S,br:S,button:{attrs:{form:null,formaction:null,name:null,value:null,autofocus:["autofocus"],disabled:["autofocus"],formenctype:Encs,formmethod:Methods,formnovalidate:["novalidate"],formtarget:Targets,type:["submit","reset","button"]}},canvas:{attrs:{width:null,height:null}},caption:S,center:S,cite:S,code:S,col:{attrs:{span:null}},colgroup:{attrs:{span:null}},command:{attrs:{type:["command","checkbox","radio"],label:null,icon:null,radiogroup:null,command:null,title:null,disabled:["disabled"],checked:["checked"]}},data:{attrs:{value:null}},datagrid:{attrs:{disabled:["disabled"],multiple:["multiple"]}},datalist:{attrs:{data:null}},dd:S,del:{attrs:{cite:null,datetime:null}},details:{attrs:{open:["open"]}},dfn:S,div:S,dl:S,dt:S,em:S,embed:{attrs:{src:null,type:null,width:null,height:null}},eventsource:{attrs:{src:null}},fieldset:{attrs:{disabled:["disabled"],form:null,name:null}},figcaption:S,figure:S,footer:S,form:{attrs:{action:null,name:null,"accept-charset":Charsets,autocomplete:["on","off"],enctype:Encs,method:Methods,novalidate:["novalidate"],target:Targets}},h1:S,h2:S,h3:S,h4:S,h5:S,h6:S,head:{children:["title","base","link","style","meta","script","noscript","command"]},header:S,hgroup:S,hr:S,html:{attrs:{manifest:null}},i:S,iframe:{attrs:{src:null,srcdoc:null,name:null,width:null,height:null,sandbox:["allow-top-navigation","allow-same-origin","allow-forms","allow-scripts"],seamless:["seamless"]}},img:{attrs:{alt:null,src:null,ismap:null,usemap:null,width:null,height:null,crossorigin:["anonymous","use-credentials"]}},input:{attrs:{alt:null,dirname:null,form:null,formaction:null,height:null,list:null,max:null,maxlength:null,min:null,name:null,pattern:null,placeholder:null,size:null,src:null,step:null,value:null,width:null,accept:["audio/*","video/*","image/*"],autocomplete:["on","off"],autofocus:["autofocus"],checked:["checked"],disabled:["disabled"],formenctype:Encs,formmethod:Methods,formnovalidate:["novalidate"],formtarget:Targets,multiple:["multiple"],readonly:["readonly"],required:["required"],type:["hidden","text","search","tel","url","email","password","datetime","date","month","week","time","datetime-local","number","range","color","checkbox","radio","file","submit","image","reset","button"]}},ins:{attrs:{cite:null,datetime:null}},kbd:S,keygen:{attrs:{challenge:null,form:null,name:null,autofocus:["autofocus"],disabled:["disabled"],keytype:["RSA"]}},label:{attrs:{for:null,form:null}},legend:S,li:{attrs:{value:null}},link:{attrs:{href:null,type:null,hreflang:null,media:null,sizes:["all","16x16","16x16 32x32","16x16 32x32 64x64"]}},map:{attrs:{name:null}},mark:S,menu:{attrs:{label:null,type:["list","context","toolbar"]}},meta:{attrs:{content:null,charset:Charsets,name:["viewport","application-name","author","description","generator","keywords"],"http-equiv":["content-language","content-type","default-style","refresh"]}},meter:{attrs:{value:null,min:null,low:null,high:null,max:null,optimum:null}},nav:S,noscript:S,object:{attrs:{data:null,type:null,name:null,usemap:null,form:null,width:null,height:null,typemustmatch:["typemustmatch"]}},ol:{attrs:{reversed:["reversed"],start:null,type:["1","a","A","i","I"]},children:["li","script","template","ul","ol"]},optgroup:{attrs:{disabled:["disabled"],label:null}},option:{attrs:{disabled:["disabled"],label:null,selected:["selected"],value:null}},output:{attrs:{for:null,form:null,name:null}},p:S,param:{attrs:{name:null,value:null}},pre:S,progress:{attrs:{value:null,max:null}},q:{attrs:{cite:null}},rp:S,rt:S,ruby:S,samp:S,script:{attrs:{type:["text/javascript"],src:null,async:["async"],defer:["defer"],charset:Charsets}},section:S,select:{attrs:{form:null,name:null,size:null,autofocus:["autofocus"],disabled:["disabled"],multiple:["multiple"]}},slot:{attrs:{name:null}},small:S,source:{attrs:{src:null,type:null,media:null}},span:S,strong:S,style:{attrs:{type:["text/css"],media:null,scoped:null}},sub:S,summary:S,sup:S,table:S,tbody:S,td:{attrs:{colspan:null,rowspan:null,headers:null}},template:S,textarea:{attrs:{dirname:null,form:null,maxlength:null,name:null,placeholder:null,rows:null,cols:null,autofocus:["autofocus"],disabled:["disabled"],readonly:["readonly"],required:["required"],wrap:["soft","hard"]}},tfoot:S,th:{attrs:{colspan:null,rowspan:null,headers:null,scope:["row","col","rowgroup","colgroup"]}},thead:S,time:{attrs:{datetime:null}},title:S,tr:S,track:{attrs:{src:null,label:null,default:null,kind:["subtitles","captions","descriptions","chapters","metadata"],srclang:null}},ul:{children:["li","script","template","ul","ol"]},var:S,video:{attrs:{src:null,poster:null,width:null,height:null,crossorigin:["anonymous","use-credentials"],preload:["auto","metadata","none"],autoplay:["autoplay"],mediagroup:["movie"],muted:["muted"],controls:["controls"]}},wbr:S},GlobalAttrs={accesskey:null,class:null,contenteditable:Bool,contextmenu:null,dir:["ltr","rtl","auto"],draggable:["true","false","auto"],dropzone:["copy","move","link","string:","file:"],hidden:["hidden"],id:null,inert:["inert"],itemid:null,itemprop:null,itemref:null,itemscope:["itemscope"],itemtype:null,lang:["ar","bn","de","en-GB","en-US","es","fr","hi","id","ja","pa","pt","ru","tr","zh"],spellcheck:Bool,autocorrect:Bool,autocapitalize:Bool,style:null,tabindex:null,title:null,translate:["yes","no"],rel:["stylesheet","alternate","author","bookmark","help","license","next","nofollow","noreferrer","prefetch","prev","search","tag"],role:"alert application article banner button cell checkbox complementary contentinfo dialog document feed figure form grid gridcell heading img list listbox listitem main navigation region row rowgroup search switch tab table tabpanel textbox timer".split(" "),"aria-activedescendant":null,"aria-atomic":Bool,"aria-autocomplete":["inline","list","both","none"],"aria-busy":Bool,"aria-checked":["true","false","mixed","undefined"],"aria-controls":null,"aria-describedby":null,"aria-disabled":Bool,"aria-dropeffect":null,"aria-expanded":["true","false","undefined"],"aria-flowto":null,"aria-grabbed":["true","false","undefined"],"aria-haspopup":Bool,"aria-hidden":Bool,"aria-invalid":["true","false","grammar","spelling"],"aria-label":null,"aria-labelledby":null,"aria-level":null,"aria-live":["off","polite","assertive"],"aria-multiline":Bool,"aria-multiselectable":Bool,"aria-owns":null,"aria-posinset":null,"aria-pressed":["true","false","mixed","undefined"],"aria-readonly":Bool,"aria-relevant":null,"aria-required":Bool,"aria-selected":["true","false","undefined"],"aria-setsize":null,"aria-sort":["ascending","descending","none","other"],"aria-valuemax":null,"aria-valuemin":null,"aria-valuenow":null,"aria-valuetext":null},eventAttributes="beforeunload copy cut dragstart dragover dragleave dragenter dragend drag paste focus blur change click load mousedown mouseenter mouseleave mouseup keydown keyup resize scroll unload".split(" ").map((n=>"on"+n));for(let a of eventAttributes)GlobalAttrs[a]=null;class Schema{constructor(extraTags,extraAttrs){this.tags=Object.assign(Object.assign({},Tags),extraTags),this.globalAttrs=Object.assign(Object.assign({},GlobalAttrs),extraAttrs),this.allTags=Object.keys(this.tags),this.globalAttrNames=Object.keys(this.globalAttrs)}}function elementName$1(doc,tree){let max=arguments.length>2&&void 0!==arguments[2]?arguments[2]:doc.length;if(!tree)return"";let tag=tree.firstChild,name=tag&&tag.getChild("TagName");return name?doc.sliceString(name.from,Math.min(name.to,max)):""}function findParentElement$1(tree){let skip=arguments.length>1&&void 0!==arguments[1]&&arguments[1];for(;tree;tree=tree.parent)if("Element"==tree.name){if(!skip)return tree;skip=!1}return null}function allowedChildren(doc,tree,schema){let parentInfo=schema.tags[elementName$1(doc,findParentElement$1(tree))];return(null==parentInfo?void 0:parentInfo.children)||schema.allTags}function openTags(doc,tree){let open=[];for(let parent=findParentElement$1(tree);parent&&!parent.type.isTop;parent=findParentElement$1(parent.parent)){let tagName=elementName$1(doc,parent);if(tagName&&"CloseTag"==parent.lastChild.name)break;tagName&&open.indexOf(tagName)<0&&("EndTag"==tree.name||tree.from>=parent.firstChild.to)&&open.push(tagName)}return open}Schema.default=new Schema;const identifier=/^[:\-\.\w\u00b7-\uffff]*$/;function completeTag(state,schema,tree,from,to){let end=/\s*>/.test(state.sliceDoc(to,to+5))?"":">",parent=findParentElement$1(tree,!0);return{from:from,to:to,options:allowedChildren(state.doc,parent,schema).map((tagName=>({label:tagName,type:"type"}))).concat(openTags(state.doc,tree).map(((tag,i)=>({label:"/"+tag,apply:"/"+tag+end,type:"type",boost:99-i})))),validFor:/^\/?[:\-\.\w\u00b7-\uffff]*$/}}function completeCloseTag(state,tree,from,to){let end=/\s*>/.test(state.sliceDoc(to,to+5))?"":">";return{from:from,to:to,options:openTags(state.doc,tree).map(((tag,i)=>({label:tag,apply:tag+end,type:"type",boost:99-i}))),validFor:identifier}}function htmlCompletionFor(schema,context){let{state:state,pos:pos}=context,tree=syntaxTree(state).resolveInner(pos,-1),around=tree.resolve(pos);for(let before,scan=pos;around==tree&&(before=tree.childBefore(scan));){let last=before.lastChild;if(!last||!last.type.isError||last.from<last.to)break;around=tree=before,scan=last.from}return"TagName"==tree.name?tree.parent&&/CloseTag$/.test(tree.parent.name)?completeCloseTag(state,tree,tree.from,pos):completeTag(state,schema,tree,tree.from,pos):"StartTag"==tree.name?completeTag(state,schema,tree,pos,pos):"StartCloseTag"==tree.name||"IncompleteCloseTag"==tree.name?completeCloseTag(state,tree,pos,pos):context.explicit&&("OpenTag"==tree.name||"SelfClosingTag"==tree.name)||"AttributeName"==tree.name?function(state,schema,tree,from,to){let elt=findParentElement$1(tree),info=elt?schema.tags[elementName$1(state.doc,elt)]:null,localAttrs=info&&info.attrs?Object.keys(info.attrs):[];return{from:from,to:to,options:(info&&!1===info.globalAttrs?localAttrs:localAttrs.length?localAttrs.concat(schema.globalAttrNames):schema.globalAttrNames).map((attrName=>({label:attrName,type:"property"}))),validFor:identifier}}(state,schema,tree,"AttributeName"==tree.name?tree.from:pos,pos):"Is"==tree.name||"AttributeValue"==tree.name||"UnquotedAttributeValue"==tree.name?function(state,schema,tree,from,to){var _a;let token,nameNode=null===(_a=tree.parent)||void 0===_a?void 0:_a.getChild("AttributeName"),options=[];if(nameNode){let attrName=state.sliceDoc(nameNode.from,nameNode.to),attrs=schema.globalAttrs[attrName];if(!attrs){let elt=findParentElement$1(tree),info=elt?schema.tags[elementName$1(state.doc,elt)]:null;attrs=(null==info?void 0:info.attrs)&&info.attrs[attrName]}if(attrs){let base=state.sliceDoc(from,to).toLowerCase(),quoteStart='"',quoteEnd='"';/^['"]/.test(base)?(token='"'==base[0]?/^[^"]*$/:/^[^']*$/,quoteStart="",quoteEnd=state.sliceDoc(to,to+1)==base[0]?"":base[0],base=base.slice(1),from++):token=/^[^\s<>='"]*$/;for(let value of attrs)options.push({label:value,apply:quoteStart+value+quoteEnd,type:"constant"})}}return{from:from,to:to,options:options,validFor:token}}(state,schema,tree,"Is"==tree.name?pos:tree.from,pos):!context.explicit||"Element"!=around.name&&"Text"!=around.name&&"Document"!=around.name?null:function(state,schema,tree,pos){let options=[],level=0;for(let tagName of allowedChildren(state.doc,tree,schema))options.push({label:"<"+tagName,type:"type"});for(let open of openTags(state.doc,tree))options.push({label:"</"+open+">",type:"type",boost:99-level++});return{from:pos,to:pos,options:options,validFor:/^<\/?[:\-\.\w\u00b7-\uffff]*$/}}(state,schema,tree,pos)}function htmlCompletionSourceWith(config){let{extraTags:extraTags,extraGlobalAttributes:extraAttrs}=config,schema=extraAttrs||extraTags?new Schema(extraTags,extraAttrs):Schema.default;return context=>htmlCompletionFor(schema,context)}const defaultNesting=[{tag:"script",attrs:attrs=>"text/typescript"==attrs.type||"ts"==attrs.lang,parser:typescriptLanguage.parser},{tag:"script",attrs:attrs=>"text/babel"==attrs.type||"text/jsx"==attrs.type,parser:jsxLanguage.parser},{tag:"script",attrs:attrs=>"text/typescript-jsx"==attrs.type,parser:tsxLanguage.parser},{tag:"script",attrs:attrs=>!attrs.type||/^(?:text|application)\/(?:x-)?(?:java|ecma)script$|^module$|^$/i.test(attrs.type),parser:javascriptLanguage.parser},{tag:"style",attrs:attrs=>(!attrs.lang||"css"==attrs.lang)&&(!attrs.type||/^(text\/)?(x-)?(stylesheet|css)$/i.test(attrs.type)),parser:cssLanguage.parser}],defaultAttrs=[{name:"style",parser:cssLanguage.parser.configure({top:"Styles"})}].concat(eventAttributes.map((name=>({name:name,parser:javascriptLanguage.parser})))),htmlPlain=LRLanguage.define({name:"html",parser:parser$3.configure({props:[indentNodeProp.add({Element(context){let after=/^(\s*)(<\/)?/.exec(context.textAfter);return context.node.to<=context.pos+after[0].length?context.continue():context.lineIndent(context.node.from)+(after[2]?0:context.unit)},"OpenTag CloseTag SelfClosingTag":context=>context.column(context.node.from)+context.unit,Document(context){if(context.pos+/\s*/.exec(context.textAfter)[0].length<context.node.to)return context.continue();let close,endElt=null;for(let cur=context.node;;){let last=cur.lastChild;if(!last||"Element"!=last.name||last.to!=cur.to)break;endElt=cur=last}return endElt&&(!(close=endElt.lastChild)||"CloseTag"!=close.name&&"SelfClosingTag"!=close.name)?context.lineIndent(endElt.from)+context.unit:null}}),foldNodeProp.add({Element(node){let first=node.firstChild,last=node.lastChild;return first&&"OpenTag"==first.name?{from:first.to,to:"CloseTag"==last.name?last.from:node.to}:null}}),bracketMatchingHandle.add({"OpenTag CloseTag":node=>node.getChild("TagName")})]}),languageData:{commentTokens:{block:{open:"\x3c!--",close:"--\x3e"}},indentOnInput:/^\s*<\/\w+\W$/,wordChars:"-._"}}),htmlLanguage=htmlPlain.configure({wrap:configureNesting(defaultNesting,defaultAttrs)});const selfClosers=new Set("area base br col command embed frame hr img input keygen link meta param source track wbr menuitem".split(" ")),autoCloseTags=EditorView.inputHandler.of(((view,from,to,text)=>{if(view.composing||view.state.readOnly||from!=to||">"!=text&&"/"!=text||!htmlLanguage.isActiveAt(view.state,from,-1))return!1;let{state:state}=view,changes=state.changeByRange((range=>{var _a,_b,_c;let name,{head:head}=range,around=syntaxTree(state).resolveInner(head,-1);if("TagName"!=around.name&&"StartTag"!=around.name||(around=around.parent),">"==text&&"OpenTag"==around.name){if("CloseTag"!=(null===(_b=null===(_a=around.parent)||void 0===_a?void 0:_a.lastChild)||void 0===_b?void 0:_b.name)&&(name=elementName$1(state.doc,around.parent,head))&&!selfClosers.has(name)){let hasRightBracket=">"===view.state.doc.sliceString(head,head+1),insert="".concat(hasRightBracket?"":">","</").concat(name,">");return{range:EditorSelection.cursor(head+1),changes:{from:head+(hasRightBracket?1:0),insert:insert}}}}else if("/"==text&&"OpenTag"==around.name){let empty=around.parent,base=null==empty?void 0:empty.parent;if(empty.from==head-1&&"CloseTag"!=(null===(_c=base.lastChild)||void 0===_c?void 0:_c.name)&&(name=elementName$1(state.doc,base,head))&&!selfClosers.has(name)){let hasRightBracket=">"===view.state.doc.sliceString(head,head+1),insert="/".concat(name).concat(hasRightBracket?"":">"),pos=head+insert.length+(hasRightBracket?1:0);return{range:EditorSelection.cursor(pos),changes:{from:head,insert:insert}}}}return{range:range}}));return!changes.changes.empty&&(view.dispatch(changes,{userEvent:"input.type",scrollIntoView:!0}),!0)}));function nameChar(ch){return 45==ch||46==ch||58==ch||ch>=65&&ch<=90||95==ch||ch>=97&&ch<=122||ch>=161}let cachedName=null,cachedInput=null,cachedPos=0;function tagNameAfter(input,offset){let pos=input.pos+offset;if(cachedInput==input&&cachedPos==pos)return cachedName;for(;9==(ch=input.peek(offset))||10==ch||13==ch||32==ch;)offset++;var ch;let name="";for(;;){let next=input.peek(offset);if(!nameChar(next))break;name+=String.fromCharCode(next),offset++}return cachedInput=input,cachedPos=pos,cachedName=name||null}function ElementContext(name,parent){this.name=name,this.parent=parent,this.hash=parent?parent.hash:0;for(let i=0;i<name.length;i++)this.hash+=(this.hash<<4)+name.charCodeAt(i)+(name.charCodeAt(i)<<8)}const elementContext=new ContextTracker({start:null,shift:(context,term,stack,input)=>1==term?new ElementContext(tagNameAfter(input,1)||"",context):context,reduce:(context,term)=>11==term&&context?context.parent:context,reuse(context,node,_stack,input){let type=node.type.id;return 1==type||13==type?new ElementContext(tagNameAfter(input,1)||"",context):context},hash:context=>context?context.hash:0,strict:!1}),startTag=new ExternalTokenizer(((input,stack)=>{if(60==input.next)if(input.advance(),47==input.next){input.advance();let name=tagNameAfter(input,0);if(!name)return input.acceptToken(5);if(stack.context&&name==stack.context.name)return input.acceptToken(2);for(let cx=stack.context;cx;cx=cx.parent)if(cx.name==name)return input.acceptToken(3,-2);input.acceptToken(4)}else if(33!=input.next&&63!=input.next)return input.acceptToken(1)}),{contextual:!0});function scanTo(type,end){return new ExternalTokenizer((input=>{for(let endPos=0,len=0;;len++){if(input.next<0){len&&input.acceptToken(type);break}if(input.next==end.charCodeAt(endPos)){if(endPos++,endPos==end.length){len>=end.length&&input.acceptToken(type,1-end.length);break}}else endPos=input.next==end.charCodeAt(0)?1:0;input.advance()}}))}const commentContent=scanTo(35,"--\x3e"),piContent=scanTo(36,"?>"),cdataContent=scanTo(37,"]]>"),xmlHighlighting=styleTags({Text:tags$1.content,"StartTag StartCloseTag EndTag SelfCloseEndTag":tags$1.angleBracket,TagName:tags$1.tagName,"MismatchedCloseTag/Tagname":[tags$1.tagName,tags$1.invalid],AttributeName:tags$1.attributeName,AttributeValue:tags$1.attributeValue,Is:tags$1.definitionOperator,"EntityReference CharacterReference":tags$1.character,Comment:tags$1.blockComment,ProcessingInst:tags$1.processingInstruction,DoctypeDecl:tags$1.documentMeta,Cdata:tags$1.special(tags$1.string)}),parser=LRParser.deserialize({version:14,states:",SOQOaOOOrOxO'#CfOzOpO'#CiO!tOaO'#CgOOOP'#Cg'#CgO!{OrO'#CrO#TOtO'#CsO#]OpO'#CtOOOP'#DS'#DSOOOP'#Cv'#CvQQOaOOOOOW'#Cw'#CwO#eOxO,59QOOOP,59Q,59QOOOO'#Cx'#CxO#mOpO,59TO#uO!bO,59TOOOP'#C{'#C{O$TOaO,59RO$[OpO'#CoOOOP,59R,59ROOOQ'#C|'#C|O$dOrO,59^OOOP,59^,59^OOOS'#C}'#C}O$lOtO,59_OOOP,59_,59_O$tOpO,59`O$|OpO,59`OOOP-E6t-E6tOOOW-E6u-E6uOOOP1G.l1G.lOOOO-E6v-E6vO%UO!bO1G.oO%UO!bO1G.oO%dOpO'#CkO%lO!bO'#CyO%zO!bO1G.oOOOP1G.o1G.oOOOP1G.w1G.wOOOP-E6y-E6yOOOP1G.m1G.mO&VOpO,59ZO&_OpO,59ZOOOQ-E6z-E6zOOOP1G.x1G.xOOOS-E6{-E6{OOOP1G.y1G.yO&gOpO1G.zO&gOpO1G.zOOOP1G.z1G.zO&oO!bO7+$ZO&}O!bO7+$ZOOOP7+$Z7+$ZOOOP7+$c7+$cO'YOpO,59VO'bOpO,59VO'jO!bO,59eOOOO-E6w-E6wO'xOpO1G.uO'xOpO1G.uOOOP1G.u1G.uO(QOpO7+$fOOOP7+$f7+$fO(YO!bO<<GuOOOP<<Gu<<GuOOOP<<G}<<G}O'bOpO1G.qO'bOpO1G.qO(eO#tO'#CnOOOO1G.q1G.qO(sOpO7+$aOOOP7+$a7+$aOOOP<<HQ<<HQOOOPAN=aAN=aOOOPAN=iAN=iO'bOpO7+$]OOOO7+$]7+$]OOOO'#Cz'#CzO({O#tO,59YOOOO,59Y,59YOOOP<<G{<<G{OOOO<<Gw<<GwOOOO-E6x-E6xOOOO1G.t1G.t",stateData:")Z~OPQOSVOTWOVWOWWOXWOiXOxPO}TO!PUO~OuZOw]O~O^`Oy^O~OPQOQcOSVOTWOVWOWWOXWOxPO}TO!PUO~ORdO~P!SOseO|gO~OthO!OjO~O^lOy^O~OuZOwoO~O^qOy^O~O[vO`sOdwOy^O~ORyO~P!SO^{Oy^O~OseO|}O~OthO!O!PO~O^!QOy^O~O[!SOy^O~O[!VO`sOd!WOy^O~Oa!YOy^O~Oy^O[mX`mXdmX~O[!VO`sOd!WO~O^!]Oy^O~O[!_Oy^O~O[!aOy^O~O[!cO`sOd!dOy^O~O[!cO`sOd!dO~Oa!eOy^O~Oy^Oz!gO~Oy^O[ma`madma~O[!jOy^O~O[!kOy^O~O[!lO`sOd!mO~OW!pOX!pOz!rO{!pO~O[!sOy^O~OW!pOX!pOz!vO{!pO~O",goto:"%[wPPPPPPPPPPxxP!OP!UPP!_!iP!oxxxP!u!{#R$Z$j$p$v$|PPPP%SXWORYbXRORYb_t`qru!T!U!bQ!h!YS!o!e!fR!t!nQdRRybXSORYbQYORmYQ[PRn[Q_QQkVjp_krz!R!T!X!Z!^!`!f!i!nQr`QzcQ!RlQ!TqQ!XsQ!ZtQ!^{Q!`!QQ!f!YQ!i!]R!n!eQu`S!UqrU![u!U!bR!b!TQ!q!gR!u!qQbRRxbQfTR|fQiUR!OiSXOYTaRb",nodeNames:"⚠ StartTag StartCloseTag MissingCloseTag StartCloseTag StartCloseTag Document Text EntityReference CharacterReference Cdata Element EndTag OpenTag TagName Attribute AttributeName Is AttributeValue CloseTag SelfCloseEndTag SelfClosingTag Comment ProcessingInst MismatchedCloseTag DoctypeDecl",maxTerm:47,context:elementContext,nodeProps:[["closedBy",1,"SelfCloseEndTag EndTag",13,"CloseTag MissingCloseTag"],["openedBy",12,"StartTag StartCloseTag",19,"OpenTag",20,"StartTag"]],propSources:[xmlHighlighting],skippedNodes:[0],repeatNodeCount:8,tokenData:"IX~R!XOX$nXY&kYZ&kZ]$n]^&k^p$npq&kqr$nrs'ssv$nvw(Zw}$n}!O*l!O!P$n!P!Q,{!Q![$n![!].e!]!^$n!^!_1v!_!`Cz!`!aDm!a!bE`!b!c$n!c!}.e!}#P$n#P#QFx#Q#R$n#R#S.e#S#T$n#T#o.e#o%W$n%W%o.e%o%p$n%p&a.e&a&b$n&b1p.e1p4U$n4U4d.e4d4e$n4e$IS.e$IS$I`$n$I`$Ib.e$Ib$Kh$n$Kh%#t.e%#t&/x$n&/x&Et.e&Et&FV$n&FV;'S.e;'S;:j1p;:j;=`&e<%l?&r$n?&r?Ah.e?Ah?BY$n?BY?Mn.e?MnO$nX$uWVP{WOr$nrs%_sv$nw!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$nP%dTVPOv%_w!^%_!_;'S%_;'S;=`%s<%lO%_P%vP;=`<%l%_W&OT{WOr%ysv%yw;'S%y;'S;=`&_<%lO%yW&bP;=`<%l%yX&hP;=`<%l$n_&t_VP{WyUOX$nXY&kYZ&kZ]$n]^&k^p$npq&kqr$nrs%_sv$nw!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$nZ'zTzYVPOv%_w!^%_!_;'S%_;'S;=`%s<%lO%_~(^VOp(sqs(sst)ht!](s!^;'S(s;'S;=`)b<%lO(s~(vVOp(sqs(st!](s!]!^)]!^;'S(s;'S;=`)b<%lO(s~)bOW~~)eP;=`<%l(s~)kTOp)zq!])z!^;'S)z;'S;=`*f<%lO)z~)}UOp)zq!])z!]!^*a!^;'S)z;'S;=`*f<%lO)z~*fOX~~*iP;=`<%l)zZ*sYVP{WOr$nrs%_sv$nw}$n}!O+c!O!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$nZ+jYVP{WOr$nrs%_sv$nw!^$n!^!_%y!_!`$n!`!a,Y!a;'S$n;'S;=`&e<%lO$nZ,cW|QVP{WOr$nrs%_sv$nw!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$n]-SYVP{WOr$nrs%_sv$nw!^$n!^!_%y!_!`$n!`!a-r!a;'S$n;'S;=`&e<%lO$n]-{WdSVP{WOr$nrs%_sv$nw!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$n_.p!O`S^QVP{WOr$nrs%_sv$nw}$n}!O.e!O!P.e!P!Q$n!Q![.e![!].e!]!^$n!^!_%y!_!c$n!c!}.e!}#R$n#R#S.e#S#T$n#T#o.e#o$}$n$}%O.e%O%W$n%W%o.e%o%p$n%p&a.e&a&b$n&b1p.e1p4U.e4U4d.e4d4e$n4e$IS.e$IS$I`$n$I`$Ib.e$Ib$Je$n$Je$Jg.e$Jg$Kh$n$Kh%#t.e%#t&/x$n&/x&Et.e&Et&FV$n&FV;'S.e;'S;:j1p;:j;=`&e<%l?&r$n?&r?Ah.e?Ah?BY$n?BY?Mn.e?MnO$n_1sP;=`<%l.eX1{W{WOq%yqr2esv%yw!a%y!a!bCd!b;'S%y;'S;=`&_<%lO%yX2j]{WOr%ysv%yw}%y}!O3c!O!f%y!f!g4e!g!}%y!}#O9t#O#W%y#W#X@Q#X;'S%y;'S;=`&_<%lO%yX3hV{WOr%ysv%yw}%y}!O3}!O;'S%y;'S;=`&_<%lO%yX4UT}P{WOr%ysv%yw;'S%y;'S;=`&_<%lO%yX4jV{WOr%ysv%yw!q%y!q!r5P!r;'S%y;'S;=`&_<%lO%yX5UV{WOr%ysv%yw!e%y!e!f5k!f;'S%y;'S;=`&_<%lO%yX5pV{WOr%ysv%yw!v%y!v!w6V!w;'S%y;'S;=`&_<%lO%yX6[V{WOr%ysv%yw!{%y!{!|6q!|;'S%y;'S;=`&_<%lO%yX6vV{WOr%ysv%yw!r%y!r!s7]!s;'S%y;'S;=`&_<%lO%yX7bV{WOr%ysv%yw!g%y!g!h7w!h;'S%y;'S;=`&_<%lO%yX7|X{WOr7wrs8isv7wvw8iw!`7w!`!a9W!a;'S7w;'S;=`9n<%lO7wP8lTO!`8i!`!a8{!a;'S8i;'S;=`9Q<%lO8iP9QOiPP9TP;=`<%l8iX9_TiP{WOr%ysv%yw;'S%y;'S;=`&_<%lO%yX9qP;=`<%l7wX9yX{WOr%ysv%yw!e%y!e!f:f!f#V%y#V#W=t#W;'S%y;'S;=`&_<%lO%yX:kV{WOr%ysv%yw!f%y!f!g;Q!g;'S%y;'S;=`&_<%lO%yX;VV{WOr%ysv%yw!c%y!c!d;l!d;'S%y;'S;=`&_<%lO%yX;qV{WOr%ysv%yw!v%y!v!w<W!w;'S%y;'S;=`&_<%lO%yX<]V{WOr%ysv%yw!c%y!c!d<r!d;'S%y;'S;=`&_<%lO%yX<wV{WOr%ysv%yw!}%y!}#O=^#O;'S%y;'S;=`&_<%lO%yX=eT{WxPOr%ysv%yw;'S%y;'S;=`&_<%lO%yX=yV{WOr%ysv%yw#W%y#W#X>`#X;'S%y;'S;=`&_<%lO%yX>eV{WOr%ysv%yw#T%y#T#U>z#U;'S%y;'S;=`&_<%lO%yX?PV{WOr%ysv%yw#h%y#h#i?f#i;'S%y;'S;=`&_<%lO%yX?kV{WOr%ysv%yw#T%y#T#U<r#U;'S%y;'S;=`&_<%lO%yX@VV{WOr%ysv%yw#c%y#c#d@l#d;'S%y;'S;=`&_<%lO%yX@qV{WOr%ysv%yw#V%y#V#WAW#W;'S%y;'S;=`&_<%lO%yXA]V{WOr%ysv%yw#h%y#h#iAr#i;'S%y;'S;=`&_<%lO%yXAwV{WOr%ysv%yw#m%y#m#nB^#n;'S%y;'S;=`&_<%lO%yXBcV{WOr%ysv%yw#d%y#d#eBx#e;'S%y;'S;=`&_<%lO%yXB}V{WOr%ysv%yw#X%y#X#Y7w#Y;'S%y;'S;=`&_<%lO%yXCkT!PP{WOr%ysv%yw;'S%y;'S;=`&_<%lO%yZDTWaQVP{WOr$nrs%_sv$nw!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$n_DvW[UVP{WOr$nrs%_sv$nw!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$nZEgYVP{WOr$nrs%_sv$nw!^$n!^!_%y!_!`$n!`!aFV!a;'S$n;'S;=`&e<%lO$nZF`W!OQVP{WOr$nrs%_sv$nw!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$nZGPYVP{WOr$nrs%_sv$nw!^$n!^!_%y!_#P$n#P#QGo#Q;'S$n;'S;=`&e<%lO$nZGvYVP{WOr$nrs%_sv$nw!^$n!^!_%y!_!`$n!`!aHf!a;'S$n;'S;=`&e<%lO$nZHoWwQVP{WOr$nrs%_sv$nw!^$n!^!_%y!_;'S$n;'S;=`&e<%lO$n",tokenizers:[startTag,commentContent,piContent,cdataContent,0,1,2,3],topRules:{Document:[0,6]},tokenPrec:0});function tagName(doc,tag){let name=tag&&tag.getChild("TagName");return name?doc.sliceString(name.from,name.to):""}function elementName(doc,tree){let tag=tree&&tree.firstChild;return tag&&"OpenTag"==tag.name?tagName(doc,tag):""}function findParentElement(tree){for(let cur=tree&&tree.parent;cur;cur=cur.parent)if("Element"==cur.name)return cur;return null}class Element{constructor(spec,attrs,attrValues){this.attrs=attrs,this.attrValues=attrValues,this.children=[],this.name=spec.name,this.completion=Object.assign(Object.assign({type:"type"},spec.completion||{}),{label:this.name}),this.openCompletion=Object.assign(Object.assign({},this.completion),{label:"<"+this.name}),this.closeCompletion=Object.assign(Object.assign({},this.completion),{label:"</"+this.name+">",boost:2}),this.closeNameCompletion=Object.assign(Object.assign({},this.completion),{label:this.name+">"}),this.text=spec.textContent?spec.textContent.map((s=>({label:s,type:"text"}))):[]}}const Identifier=/^[:\-\.\w\u00b7-\uffff]*$/;function attrCompletion(spec){return Object.assign(Object.assign({type:"property"},spec.completion||{}),{label:spec.name})}function valueCompletion(spec){return"string"==typeof spec?{label:'"'.concat(spec,'"'),type:"constant"}:/^"/.test(spec.label)?spec:Object.assign(Object.assign({},spec),{label:'"'.concat(spec.label,'"')})}function completeFromSchema(eltSpecs,attrSpecs){let allAttrs=[],globalAttrs=[],attrValues=Object.create(null);for(let s of attrSpecs){let completion=attrCompletion(s);allAttrs.push(completion),s.global&&globalAttrs.push(completion),s.values&&(attrValues[s.name]=s.values.map(valueCompletion))}let allElements=[],topElements=[],byName=Object.create(null);for(let s of eltSpecs){let attrs=globalAttrs,attrVals=attrValues;s.attributes&&(attrs=attrs.concat(s.attributes.map((s=>"string"==typeof s?allAttrs.find((a=>a.label==s))||{label:s,type:"property"}:(s.values&&(attrVals==attrValues&&(attrVals=Object.create(attrVals)),attrVals[s.name]=s.values.map(valueCompletion)),attrCompletion(s))))));let elt=new Element(s,attrs,attrVals);byName[elt.name]=elt,allElements.push(elt),s.top&&topElements.push(elt)}topElements.length||(topElements=allElements);for(let i=0;i<allElements.length;i++){let s=eltSpecs[i],elt=allElements[i];if(s.children)for(let ch of s.children)byName[ch]&&elt.children.push(byName[ch]);else elt.children=allElements}return cx=>{var _a;let{doc:doc}=cx.state,loc=function(state,pos){var _a;let at=syntaxTree(state).resolveInner(pos,-1),inTag=null;for(let cur=at;!inTag&&cur.parent;cur=cur.parent)"OpenTag"!=cur.name&&"CloseTag"!=cur.name&&"SelfClosingTag"!=cur.name&&"MismatchedCloseTag"!=cur.name||(inTag=cur);if(inTag&&(inTag.to>pos||inTag.lastChild.type.isError)){let elt=inTag.parent;if("TagName"==at.name)return"CloseTag"==inTag.name||"MismatchedCloseTag"==inTag.name?{type:"closeTag",from:at.from,context:elt}:{type:"openTag",from:at.from,context:findParentElement(elt)};if("AttributeName"==at.name)return{type:"attrName",from:at.from,context:inTag};if("AttributeValue"==at.name)return{type:"attrValue",from:at.from,context:inTag};let before=at==inTag||"Attribute"==at.name?at.childBefore(pos):at;return"StartTag"==(null==before?void 0:before.name)?{type:"openTag",from:pos,context:findParentElement(elt)}:"StartCloseTag"==(null==before?void 0:before.name)&&before.to<=pos?{type:"closeTag",from:pos,context:elt}:"Is"==(null==before?void 0:before.name)?{type:"attrValue",from:pos,context:inTag}:before?{type:"attrName",from:pos,context:inTag}:null}if("StartCloseTag"==at.name)return{type:"closeTag",from:pos,context:at.parent};for(;at.parent&&at.to==pos&&!(null===(_a=at.lastChild)||void 0===_a?void 0:_a.type.isError);)at=at.parent;return"Element"==at.name||"Text"==at.name||"Document"==at.name?{type:"tag",from:pos,context:"Element"==at.name?at:findParentElement(at)}:null}(cx.state,cx.pos);if(!loc||"tag"==loc.type&&!cx.explicit)return null;let{type:type,from:from,context:context}=loc;if("openTag"==type){let children=topElements,parentName=elementName(doc,context);if(parentName){let parent=byName[parentName];children=(null==parent?void 0:parent.children)||allElements}return{from:from,options:children.map((ch=>ch.completion)),validFor:Identifier}}if("closeTag"==type){let parentName=elementName(doc,context);return parentName?{from:from,to:cx.pos+(">"==doc.sliceString(cx.pos,cx.pos+1)?1:0),options:[(null===(_a=byName[parentName])||void 0===_a?void 0:_a.closeNameCompletion)||{label:parentName+">",type:"type"}],validFor:Identifier}:null}if("attrName"==type){let parent=byName[tagName(doc,context)];return{from:from,options:(null==parent?void 0:parent.attrs)||globalAttrs,validFor:Identifier}}if("attrValue"==type){let attr=function(doc,tag,pos){let attr=tag&&tag.getChildren("Attribute").find((a=>a.from<=pos&&a.to>=pos)),name=attr&&attr.getChild("AttributeName");return name?doc.sliceString(name.from,name.to):""}(doc,context,from);if(!attr)return null;let parent=byName[tagName(doc,context)],values=((null==parent?void 0:parent.attrValues)||attrValues)[attr];return values&&values.length?{from:from,to:cx.pos+('"'==doc.sliceString(cx.pos,cx.pos+1)?1:0),options:values,validFor:/^"[^"]*"?$/}:null}if("tag"==type){let parentName=elementName(doc,context),parent=byName[parentName],closing=[],last=context&&context.lastChild;!parentName||last&&"CloseTag"==last.name&&tagName(doc,last)==parentName||closing.push(parent?parent.closeCompletion:{label:"</"+parentName+">",type:"type",boost:2});let options=closing.concat(((null==parent?void 0:parent.children)||(context?allElements:topElements)).map((e=>e.openCompletion)));if(context&&(null==parent?void 0:parent.text.length)){let openTag=context.firstChild;openTag.to>cx.pos-20&&!/\S/.test(cx.state.sliceDoc(openTag.to,cx.pos))&&(options=options.concat(parent.text))}return{from:from,options:options,validFor:/^<\/?[:\-\.\w\u00b7-\uffff]*$/}}return null}}const xmlLanguage=LRLanguage.define({name:"xml",parser:parser.configure({props:[indentNodeProp.add({Element(context){let closed=/^\s*<\//.test(context.textAfter);return context.lineIndent(context.node.from)+(closed?0:context.unit)},"OpenTag CloseTag SelfClosingTag":context=>context.column(context.node.from)+context.unit}),foldNodeProp.add({Element(subtree){let first=subtree.firstChild,last=subtree.lastChild;return first&&"OpenTag"==first.name?{from:first.to,to:"CloseTag"==last.name?last.from:subtree.to}:null}}),bracketMatchingHandle.add({"OpenTag CloseTag":node=>node.getChild("TagName")})]}),languageData:{commentTokens:{block:{open:"\x3c!--",close:"--\x3e"}},indentOnInput:/^\s*<\/$/}});const lang={html:function(){let wrap,config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},dialect="";!1===config.matchClosingTags&&(dialect="noMatch"),!0===config.selfClosingTags&&(dialect=(dialect?dialect+" ":"")+"selfClosing"),(config.nestedLanguages&&config.nestedLanguages.length||config.nestedAttributes&&config.nestedAttributes.length)&&(wrap=configureNesting((config.nestedLanguages||[]).concat(defaultNesting),(config.nestedAttributes||[]).concat(defaultAttrs)));let lang=wrap?htmlPlain.configure({wrap:wrap,dialect:dialect}):dialect?htmlLanguage.configure({dialect:dialect}):htmlLanguage;return new LanguageSupport(lang,[htmlLanguage.data.of({autocomplete:htmlCompletionSourceWith(config)}),!1!==config.autoCloseTags?autoCloseTags:[],javascript().support,css().support])},javascript:javascript,xml:function(){let conf=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return new LanguageSupport(xmlLanguage,xmlLanguage.data.of({autocomplete:completeFromSchema(conf.elements||[],conf.attributes||[])}))}};_exports.lang=lang}));

//# sourceMappingURL=codemirror-lazy.min.js.map