/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import gnu.xml.stream.XMLOutputFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class XMLOutputFactory {
    public static final String IS_PREFIX_DEFAULTING = "javax.xml.stream.isPrefixDefaulting";
    static /* synthetic */ Class class$javax$xml$stream$XMLOutputFactory;

    public static XMLOutputFactory newInstance() throws FactoryConfigurationError {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            Class clazz = class$javax$xml$stream$XMLOutputFactory;
            if (clazz == null) {
                clazz = class$javax$xml$stream$XMLOutputFactory = XMLOutputFactory.class("[Ljavax.xml.stream.XMLOutputFactory;", false);
            }
            loader = clazz.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = XMLOutputFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class t = loader != null ? loader.loadClass(className) : Class.forName(className);
                return (XMLOutputFactory)t.newInstance();
            }
            catch (ClassNotFoundException e) {
                className = null;
            }
            catch (Exception e) {
                throw new FactoryConfigurationError(e, "error instantiating class " + className);
            }
        } while (className == null && count < 3);
        return new XMLOutputFactoryImpl();
    }

    private static final String getFactoryClassName(ClassLoader loader, int attempt) {
        String propertyName = "javax.xml.stream.XMLOutputFactory";
        switch (attempt) {
            case 0: {
                return System.getProperty("javax.xml.stream.XMLOutputFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "stax.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty("javax.xml.stream.XMLOutputFactory");
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream in;
                    InputStream inputStream;
                    String serviceKey = "/META-INF/services/javax.xml.stream.XMLOutputFactory";
                    if (loader != null) {
                        inputStream = loader.getResourceAsStream(serviceKey);
                    } else {
                        Class clazz = class$javax$xml$stream$XMLOutputFactory;
                        if (clazz == null) {
                            clazz = class$javax$xml$stream$XMLOutputFactory = XMLOutputFactory.class("[Ljavax.xml.stream.XMLOutputFactory;", false);
                        }
                        inputStream = in = clazz.getResourceAsStream(serviceKey);
                    }
                    if (in != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        String ret = r.readLine();
                        r.close();
                        return ret;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public static XMLInputFactory newInstance(String factoryId, ClassLoader classLoader) throws FactoryConfigurationError {
        return XMLInputFactory.newInstance(factoryId, classLoader);
    }

    public abstract XMLStreamWriter createXMLStreamWriter(Writer var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1) throws XMLStreamException;

    public abstract XMLStreamWriter createXMLStreamWriter(OutputStream var1, String var2) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(OutputStream var1) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(OutputStream var1, String var2) throws XMLStreamException;

    public abstract XMLEventWriter createXMLEventWriter(Writer var1) throws XMLStreamException;

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPrefixDefaulting();

    public abstract boolean isPropertySupported(String var1);

    public abstract void setPrefixDefaulting(boolean var1);

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected XMLOutputFactory() {
    }
}

